# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.get_meeting_recording_request import GetMeetingRecordingRequest
from ..model.get_meeting_recording_response import GetMeetingRecordingResponse
from ..model.set_permission_meeting_recording_request import SetPermissionMeetingRecordingRequest
from ..model.set_permission_meeting_recording_response import SetPermissionMeetingRecordingResponse
from ..model.start_meeting_recording_request import StartMeetingRecordingRequest
from ..model.start_meeting_recording_response import StartMeetingRecordingResponse
from ..model.stop_meeting_recording_request import StopMeetingRecordingRequest
from ..model.stop_meeting_recording_response import StopMeetingRecordingResponse


class MeetingRecording(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def get(self, request: GetMeetingRecordingRequest,
            option: Optional[RequestOption] = None) -> GetMeetingRecordingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetMeetingRecordingResponse = JSON.unmarshal(str(resp.content, UTF_8), GetMeetingRecordingResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetMeetingRecordingRequest,
                   option: Optional[RequestOption] = None) -> GetMeetingRecordingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetMeetingRecordingResponse = JSON.unmarshal(str(resp.content, UTF_8), GetMeetingRecordingResponse)
        response.raw = resp

        return response

    def set_permission(self, request: SetPermissionMeetingRecordingRequest,
                       option: Optional[RequestOption] = None) -> SetPermissionMeetingRecordingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: SetPermissionMeetingRecordingResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                         SetPermissionMeetingRecordingResponse)
        response.raw = resp

        return response

    async def aset_permission(self, request: SetPermissionMeetingRecordingRequest,
                              option: Optional[RequestOption] = None) -> SetPermissionMeetingRecordingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: SetPermissionMeetingRecordingResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                         SetPermissionMeetingRecordingResponse)
        response.raw = resp

        return response

    def start(self, request: StartMeetingRecordingRequest,
              option: Optional[RequestOption] = None) -> StartMeetingRecordingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: StartMeetingRecordingResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                 StartMeetingRecordingResponse)
        response.raw = resp

        return response

    async def astart(self, request: StartMeetingRecordingRequest,
                     option: Optional[RequestOption] = None) -> StartMeetingRecordingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: StartMeetingRecordingResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                 StartMeetingRecordingResponse)
        response.raw = resp

        return response

    def stop(self, request: StopMeetingRecordingRequest,
             option: Optional[RequestOption] = None) -> StopMeetingRecordingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: StopMeetingRecordingResponse = JSON.unmarshal(str(resp.content, UTF_8), StopMeetingRecordingResponse)
        response.raw = resp

        return response

    async def astop(self, request: StopMeetingRecordingRequest,
                    option: Optional[RequestOption] = None) -> StopMeetingRecordingResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: StopMeetingRecordingResponse = JSON.unmarshal(str(resp.content, UTF_8), StopMeetingRecordingResponse)
        response.raw = resp

        return response
