# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.apply_reserve_request import ApplyReserveRequest
from ..model.apply_reserve_response import ApplyReserveResponse
from ..model.delete_reserve_request import DeleteReserveRequest
from ..model.delete_reserve_response import DeleteReserveResponse
from ..model.get_active_meeting_reserve_request import GetActiveMeetingReserveRequest
from ..model.get_active_meeting_reserve_response import GetActiveMeetingReserveResponse
from ..model.get_reserve_request import GetReserveRequest
from ..model.get_reserve_response import GetReserveResponse
from ..model.update_reserve_request import UpdateReserveRequest
from ..model.update_reserve_response import UpdateReserveResponse


class Reserve(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def apply(self, request: ApplyReserveRequest, option: Optional[RequestOption] = None) -> ApplyReserveResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ApplyReserveResponse = JSON.unmarshal(str(resp.content, UTF_8), ApplyReserveResponse)
        response.raw = resp

        return response

    async def aapply(self, request: ApplyReserveRequest,
                     option: Optional[RequestOption] = None) -> ApplyReserveResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ApplyReserveResponse = JSON.unmarshal(str(resp.content, UTF_8), ApplyReserveResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteReserveRequest, option: Optional[RequestOption] = None) -> DeleteReserveResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteReserveResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteReserveResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteReserveRequest,
                      option: Optional[RequestOption] = None) -> DeleteReserveResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteReserveResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteReserveResponse)
        response.raw = resp

        return response

    def get(self, request: GetReserveRequest, option: Optional[RequestOption] = None) -> GetReserveResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetReserveResponse = JSON.unmarshal(str(resp.content, UTF_8), GetReserveResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetReserveRequest, option: Optional[RequestOption] = None) -> GetReserveResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetReserveResponse = JSON.unmarshal(str(resp.content, UTF_8), GetReserveResponse)
        response.raw = resp

        return response

    def get_active_meeting(self, request: GetActiveMeetingReserveRequest,
                           option: Optional[RequestOption] = None) -> GetActiveMeetingReserveResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetActiveMeetingReserveResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                   GetActiveMeetingReserveResponse)
        response.raw = resp

        return response

    async def aget_active_meeting(self, request: GetActiveMeetingReserveRequest,
                                  option: Optional[RequestOption] = None) -> GetActiveMeetingReserveResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetActiveMeetingReserveResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                   GetActiveMeetingReserveResponse)
        response.raw = resp

        return response

    def update(self, request: UpdateReserveRequest, option: Optional[RequestOption] = None) -> UpdateReserveResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UpdateReserveResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateReserveResponse)
        response.raw = resp

        return response

    async def aupdate(self, request: UpdateReserveRequest,
                      option: Optional[RequestOption] = None) -> UpdateReserveResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UpdateReserveResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateReserveResponse)
        response.raw = resp

        return response
