# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.get_reserve_config_form_request import GetReserveConfigFormRequest
from ..model.get_reserve_config_form_response import GetReserveConfigFormResponse
from ..model.patch_reserve_config_form_request import PatchReserveConfigFormRequest
from ..model.patch_reserve_config_form_response import PatchReserveConfigFormResponse


class ReserveConfigForm(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def get(self, request: GetReserveConfigFormRequest,
            option: Optional[RequestOption] = None) -> GetReserveConfigFormResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetReserveConfigFormResponse = JSON.unmarshal(str(resp.content, UTF_8), GetReserveConfigFormResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetReserveConfigFormRequest,
                   option: Optional[RequestOption] = None) -> GetReserveConfigFormResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetReserveConfigFormResponse = JSON.unmarshal(str(resp.content, UTF_8), GetReserveConfigFormResponse)
        response.raw = resp

        return response

    def patch(self, request: PatchReserveConfigFormRequest,
              option: Optional[RequestOption] = None) -> PatchReserveConfigFormResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PatchReserveConfigFormResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  PatchReserveConfigFormResponse)
        response.raw = resp

        return response

    async def apatch(self, request: PatchReserveConfigFormRequest,
                     option: Optional[RequestOption] = None) -> PatchReserveConfigFormResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PatchReserveConfigFormResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  PatchReserveConfigFormResponse)
        response.raw = resp

        return response
