# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.query_room_config_request import QueryRoomConfigRequest
from ..model.query_room_config_response import QueryRoomConfigResponse
from ..model.set_checkboard_access_code_room_config_request import SetCheckboardAccessCodeRoomConfigRequest
from ..model.set_checkboard_access_code_room_config_response import SetCheckboardAccessCodeRoomConfigResponse
from ..model.set_room_access_code_room_config_request import SetRoomAccessCodeRoomConfigRequest
from ..model.set_room_access_code_room_config_response import SetRoomAccessCodeRoomConfigResponse
from ..model.set_room_config_request import SetRoomConfigRequest
from ..model.set_room_config_response import SetRoomConfigResponse


class RoomConfig(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def query(self, request: QueryRoomConfigRequest, option: Optional[RequestOption] = None) -> QueryRoomConfigResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: QueryRoomConfigResponse = JSON.unmarshal(str(resp.content, UTF_8), QueryRoomConfigResponse)
        response.raw = resp

        return response

    async def aquery(self, request: QueryRoomConfigRequest,
                     option: Optional[RequestOption] = None) -> QueryRoomConfigResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: QueryRoomConfigResponse = JSON.unmarshal(str(resp.content, UTF_8), QueryRoomConfigResponse)
        response.raw = resp

        return response

    def set(self, request: SetRoomConfigRequest, option: Optional[RequestOption] = None) -> SetRoomConfigResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: SetRoomConfigResponse = JSON.unmarshal(str(resp.content, UTF_8), SetRoomConfigResponse)
        response.raw = resp

        return response

    async def aset(self, request: SetRoomConfigRequest,
                   option: Optional[RequestOption] = None) -> SetRoomConfigResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: SetRoomConfigResponse = JSON.unmarshal(str(resp.content, UTF_8), SetRoomConfigResponse)
        response.raw = resp

        return response

    def set_checkboard_access_code(self, request: SetCheckboardAccessCodeRoomConfigRequest,
                                   option: Optional[RequestOption] = None) -> SetCheckboardAccessCodeRoomConfigResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: SetCheckboardAccessCodeRoomConfigResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                             SetCheckboardAccessCodeRoomConfigResponse)
        response.raw = resp

        return response

    async def aset_checkboard_access_code(self, request: SetCheckboardAccessCodeRoomConfigRequest, option: Optional[
        RequestOption] = None) -> SetCheckboardAccessCodeRoomConfigResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: SetCheckboardAccessCodeRoomConfigResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                             SetCheckboardAccessCodeRoomConfigResponse)
        response.raw = resp

        return response

    def set_room_access_code(self, request: SetRoomAccessCodeRoomConfigRequest,
                             option: Optional[RequestOption] = None) -> SetRoomAccessCodeRoomConfigResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: SetRoomAccessCodeRoomConfigResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                       SetRoomAccessCodeRoomConfigResponse)
        response.raw = resp

        return response

    async def aset_room_access_code(self, request: SetRoomAccessCodeRoomConfigRequest,
                                    option: Optional[RequestOption] = None) -> SetRoomAccessCodeRoomConfigResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: SetRoomAccessCodeRoomConfigResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                       SetRoomAccessCodeRoomConfigResponse)
        response.raw = resp

        return response
