# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_room_level_request import CreateRoomLevelRequest
from ..model.create_room_level_response import CreateRoomLevelResponse
from ..model.del_room_level_request import DelRoomLevelRequest
from ..model.del_room_level_response import DelRoomLevelResponse
from ..model.get_room_level_request import GetRoomLevelRequest
from ..model.get_room_level_response import GetRoomLevelResponse
from ..model.list_room_level_request import ListRoomLevelRequest
from ..model.list_room_level_response import ListRoomLevelResponse
from ..model.mget_room_level_request import MgetRoomLevelRequest
from ..model.mget_room_level_response import MgetRoomLevelResponse
from ..model.patch_room_level_request import PatchRoomLevelRequest
from ..model.patch_room_level_response import PatchRoomLevelResponse
from ..model.search_room_level_request import SearchRoomLevelRequest
from ..model.search_room_level_response import SearchRoomLevelResponse


class RoomLevel(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateRoomLevelRequest,
               option: Optional[RequestOption] = None) -> CreateRoomLevelResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateRoomLevelResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateRoomLevelResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateRoomLevelRequest,
                      option: Optional[RequestOption] = None) -> CreateRoomLevelResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateRoomLevelResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateRoomLevelResponse)
        response.raw = resp

        return response

    def del_(self, request: DelRoomLevelRequest, option: Optional[RequestOption] = None) -> DelRoomLevelResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DelRoomLevelResponse = JSON.unmarshal(str(resp.content, UTF_8), DelRoomLevelResponse)
        response.raw = resp

        return response

    async def adel_(self, request: DelRoomLevelRequest, option: Optional[RequestOption] = None) -> DelRoomLevelResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DelRoomLevelResponse = JSON.unmarshal(str(resp.content, UTF_8), DelRoomLevelResponse)
        response.raw = resp

        return response

    def get(self, request: GetRoomLevelRequest, option: Optional[RequestOption] = None) -> GetRoomLevelResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetRoomLevelResponse = JSON.unmarshal(str(resp.content, UTF_8), GetRoomLevelResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetRoomLevelRequest, option: Optional[RequestOption] = None) -> GetRoomLevelResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetRoomLevelResponse = JSON.unmarshal(str(resp.content, UTF_8), GetRoomLevelResponse)
        response.raw = resp

        return response

    def list(self, request: ListRoomLevelRequest, option: Optional[RequestOption] = None) -> ListRoomLevelResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListRoomLevelResponse = JSON.unmarshal(str(resp.content, UTF_8), ListRoomLevelResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListRoomLevelRequest,
                    option: Optional[RequestOption] = None) -> ListRoomLevelResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListRoomLevelResponse = JSON.unmarshal(str(resp.content, UTF_8), ListRoomLevelResponse)
        response.raw = resp

        return response

    def mget(self, request: MgetRoomLevelRequest, option: Optional[RequestOption] = None) -> MgetRoomLevelResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: MgetRoomLevelResponse = JSON.unmarshal(str(resp.content, UTF_8), MgetRoomLevelResponse)
        response.raw = resp

        return response

    async def amget(self, request: MgetRoomLevelRequest,
                    option: Optional[RequestOption] = None) -> MgetRoomLevelResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: MgetRoomLevelResponse = JSON.unmarshal(str(resp.content, UTF_8), MgetRoomLevelResponse)
        response.raw = resp

        return response

    def patch(self, request: PatchRoomLevelRequest, option: Optional[RequestOption] = None) -> PatchRoomLevelResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PatchRoomLevelResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchRoomLevelResponse)
        response.raw = resp

        return response

    async def apatch(self, request: PatchRoomLevelRequest,
                     option: Optional[RequestOption] = None) -> PatchRoomLevelResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PatchRoomLevelResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchRoomLevelResponse)
        response.raw = resp

        return response

    def search(self, request: SearchRoomLevelRequest,
               option: Optional[RequestOption] = None) -> SearchRoomLevelResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: SearchRoomLevelResponse = JSON.unmarshal(str(resp.content, UTF_8), SearchRoomLevelResponse)
        response.raw = resp

        return response

    async def asearch(self, request: SearchRoomLevelRequest,
                      option: Optional[RequestOption] = None) -> SearchRoomLevelResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: SearchRoomLevelResponse = JSON.unmarshal(str(resp.content, UTF_8), SearchRoomLevelResponse)
        response.raw = resp

        return response
