# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_scope_config_request import CreateScopeConfigRequest
from ..model.create_scope_config_response import CreateScopeConfigResponse
from ..model.get_scope_config_request import GetScopeConfigRequest
from ..model.get_scope_config_response import GetScopeConfigResponse


class ScopeConfig(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateScopeConfigRequest,
               option: Optional[RequestOption] = None) -> CreateScopeConfigResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateScopeConfigResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateScopeConfigResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateScopeConfigRequest,
                      option: Optional[RequestOption] = None) -> CreateScopeConfigResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateScopeConfigResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateScopeConfigResponse)
        response.raw = resp

        return response

    def get(self, request: GetScopeConfigRequest, option: Optional[RequestOption] = None) -> GetScopeConfigResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetScopeConfigResponse = JSON.unmarshal(str(resp.content, UTF_8), GetScopeConfigResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetScopeConfigRequest,
                   option: Optional[RequestOption] = None) -> GetScopeConfigResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetScopeConfigResponse = JSON.unmarshal(str(resp.content, UTF_8), GetScopeConfigResponse)
        response.raw = resp

        return response
