# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .node import Node


class ListSpaceNodeResponseBody(object):
    _types = {
        "items": List[Node],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.items: Optional[List[Node]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListSpaceNodeResponseBodyBuilder":
        return ListSpaceNodeResponseBodyBuilder()


class ListSpaceNodeResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_space_node_response_body = ListSpaceNodeResponseBody()

    def items(self, items: List[Node]) -> "ListSpaceNodeResponseBodyBuilder":
        self._list_space_node_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "ListSpaceNodeResponseBodyBuilder":
        self._list_space_node_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "ListSpaceNodeResponseBodyBuilder":
        self._list_space_node_response_body.has_more = has_more
        return self

    def build(self) -> "ListSpaceNodeResponseBody":
        return self._list_space_node_response_body
