# Infinote

*Feel the spatial freedom in your notes.*

## Instalation

```bash
pipx install infinote-md
```

I also recommend installing these vim plugins (but that's optional):
```
Plug 'ggandor/leap.nvim'
Plug 'MattesGroeger/vim-bookmarks'
Plug 'ixru/nvim-markdown'
Plug 'madox2/vim-ai'
```

## Runninng

```
infinote PATH_TO_YOUR_NOTES/WORKSPACE/GROUP
```

(Necessary folders will be created.)

F.e.:
```
infinote ~/cloud/notes/astrophysics/$(date +%Y.%m)
```

Here `~/cloud/notes` is your notes dir, `astrophysics` is the workspace name, and `$(+%Y.%m)` is the autogenerated group name of the form `2024.01`. Every group will have a different color. All the groups from the chosen workspace will be shown, but you will add boxes only to the chosen group.

## Shortcuts
- scroll with mouse wheel to zoom
- click to create a new box or to choose an existing one
- `<A-j>` - move to neighbor down
- `<A-k>` - move to neighbor up
- `<A-h>` - move to neighbor left
- `<A-l>` - move to neighbor right
- `<M-A-j>` - make a new child of the current text box, to the bottom
- `<M-A-l>` - make a new child of the current text box, to the right
- `<A-S-j>` - catch a child and insert it to the bottom (will hang until you click or move to the box to catch)
- `<A-S-l>` - catch a child and insert it to the right (will hang until you click or move to the box to catch)
- `<A-y>` - zoom down
- `<A-o>` - zoom up
- `<A-u>` - grow box
- `<A-i>` - shrink box
- `<C-o>` - jump back
- `<C-i>` - jump forward
- `,c` - center the view on current box
- `,m` - maximize the view on current box (zoom out as much as possible, while keeping the current box in view)
- `,b` - when in bookmarks window, jump to location of bookmark under cursor
    - requires 'MattesGroeger/vim-bookmarks' installed
- `,h` - hop to any text using leap plugin
    - requires 'ggandor/leap.nvim' installed

## Customization

Edit the file `~/.local/pipx/venvs/infinote-md/lib64/python3.*/site-packages/infinote/config.py`.

(Note that upgrading with pipx will overwrite this file.)

## Troubleshooting

If program hangs during opening, check if vim can open your .md notes. There may be some lingering swap files that you'll need to delete. Or simply copy your note folder to a new location and see if it opens there.
