/*! For license information please see custom-protocol-check.js.LICENSE.txt */
!function(n,e){"object"==typeof exports&&"object"==typeof module?module.exports=e():"function"==typeof define&&define.amd?define("customProtocolCheck",[],e):"object"==typeof exports?exports.customProtocolCheck=e():n.customProtocolCheck=e()}(window,(function(){return function(n){var e={};function r(t){if(e[t])return e[t].exports;var i=e[t]={i:t,l:!1,exports:{}};return n[t].call(i.exports,i,i.exports,r),i.l=!0,i.exports}return r.m=n,r.c=e,r.d=function(n,e,t){r.o(n,e)||Object.defineProperty(n,e,{enumerable:!0,get:t})},r.r=function(n){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(n,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(n,"__esModule",{value:!0})},r.t=function(n,e){if(1&e&&(n=r(n)),8&e)return n;if(4&e&&"object"==typeof n&&n&&n.__esModule)return n;var t=Object.create(null);if(r.r(t),Object.defineProperty(t,"default",{enumerable:!0,value:n}),2&e&&"string"!=typeof n)for(var i in n)r.d(t,i,function(e){return n[e]}.bind(null,i));return t},r.n=function(n){var e=n&&n.__esModule?function(){return n.default}:function(){return n};return r.d(e,"a",e),e},r.o=function(n,e){return Object.prototype.hasOwnProperty.call(n,e)},r.p="",r(r.s=0)}({"./index.js":function(module,exports){eval('var browser = {\n  getUserAgent: function getUserAgent() {\n    return window.navigator.userAgent;\n  },\n  userAgentContains: function userAgentContains(browserName) {\n    browserName = browserName.toLowerCase();\n    return this.getUserAgent().toLowerCase().indexOf(browserName) > -1;\n  },\n  isOSX: function isOSX() {\n    return this.userAgentContains("Macintosh");\n  },\n  isFirefox: function isFirefox() {\n    return this.userAgentContains("firefox");\n  },\n  isInternetExplorer: function isInternetExplorer() {\n    return this.userAgentContains("trident");\n  },\n\n  /**\r\n   * Detects IE 11 and older\r\n   * @return {Boolean} Returns true when IE 11 and older\r\n   */\n  isIE: function isIE() {\n    var ua = this.getUserAgent().toLowerCase(); // Test values.\n    // Uncomment to check result\n    // IE 10\n    // ua = \'Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2; Trident/6.0)\';\n    // IE 11\n    // ua = \'Mozilla/5.0 (Windows NT 6.3; Trident/7.0; rv:11.0) like Gecko/20100101 Firefox/12.0\';\n\n    var msie = ua.indexOf("msie");\n\n    if (msie > 0) {\n      // IE 10 or older\n      return true;\n    }\n\n    var trident = ua.indexOf("trident/");\n\n    if (trident > 0) {\n      // IE 11\n      return true;\n    } // other browser\n\n\n    return false;\n  },\n  isEdge: function isEdge() {\n    var ua = this.getUserAgent().toLowerCase(); // Test values.\n    // Uncomment to check result\n    // Edge\n    // ua = \'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.135 Safari/537.36 Edge/12.10240\';\n\n    var edge = ua.indexOf("edge");\n\n    if (edge > 0) {\n      return true;\n    }\n\n    return false;\n  },\n  isChrome: function isChrome() {\n    // IE11 returns undefined for window.chrome\n    // and new Opera 30 outputs true for window.chrome\n    // but needs to check if window.opr is not undefined\n    // and new IE Edge outputs to true for window.chrome\n    // and if not iOS Chrome check\n    var isChromium = window.chrome;\n    var winNav = window.navigator;\n    var vendorName = winNav.vendor;\n    var isOpera = typeof window.opr !== "undefined";\n    var isIEedge = winNav.userAgent.indexOf("Edge") > -1;\n    var isIOSChrome = winNav.userAgent.match("CriOS");\n    return isChromium !== null && typeof isChromium !== "undefined" && vendorName === "Google Inc." && isOpera === false && isIEedge === false || isIOSChrome;\n  },\n  isOpera: function isOpera() {\n    return this.userAgentContains(" OPR/");\n  }\n};\nvar DEFAULT_CUSTOM_PROTOCOL_FAIL_CALLBACK_TIMEOUT;\n\nvar registerEvent = function registerEvent(target, eventType, cb) {\n  if (target.addEventListener) {\n    target.addEventListener(eventType, cb);\n    return {\n      remove: function remove() {\n        target.removeEventListener(eventType, cb);\n      }\n    };\n  } else {\n    target.attachEvent(eventType, cb);\n    return {\n      remove: function remove() {\n        target.detachEvent(eventType, cb);\n      }\n    };\n  }\n};\n\nvar createHiddenIframe = function createHiddenIframe(target, uri) {\n  var iframe = document.createElement("iframe");\n  iframe.src = uri;\n  iframe.id = "hiddenIframe";\n  iframe.style.display = "none";\n  target.appendChild(iframe);\n  return iframe;\n};\n\nvar openUriWithHiddenFrame = function openUriWithHiddenFrame(uri, failCb, successCb) {\n  var timeout = setTimeout(function () {\n    failCb();\n    handler.remove();\n  }, DEFAULT_CUSTOM_PROTOCOL_FAIL_CALLBACK_TIMEOUT);\n  var iframe = document.querySelector("#hiddenIframe");\n\n  if (!iframe) {\n    iframe = createHiddenIframe(document.body, "about:blank");\n  }\n\n  onBlur = function onBlur() {\n    clearTimeout(timeout);\n    handler.remove();\n    successCb();\n  };\n\n  var handler = registerEvent(window, "blur", onBlur);\n  iframe.contentWindow.location.href = uri;\n};\n\nvar openUriWithTimeoutHack = function openUriWithTimeoutHack(uri, failCb, successCb) {\n  var timeout = setTimeout(function () {\n    failCb();\n    handler.remove();\n  }, DEFAULT_CUSTOM_PROTOCOL_FAIL_CALLBACK_TIMEOUT); //handle page running in an iframe (blur must be registered with top level window)\n\n  var target = window;\n\n  while (target.parent && target != target.parent) {\n    target = target.parent;\n  }\n\n  onBlur = function onBlur() {\n    clearTimeout(timeout);\n    handler.remove();\n    successCb();\n  };\n\n  var handler = registerEvent(target, "blur", onBlur);\n  window.location = uri;\n};\n\nvar openUriUsingFirefox = function openUriUsingFirefox(uri, failCb, successCb) {\n  var iframe = document.querySelector("#hiddenIframe");\n\n  if (!iframe) {\n    iframe = createHiddenIframe(document.body, "about:blank");\n  }\n\n  try {\n    iframe.contentWindow.location.href = uri;\n    successCb();\n  } catch (e) {\n    if (e.name == "NS_ERROR_UNKNOWN_PROTOCOL") {\n      failCb();\n    }\n  }\n};\n\nvar openUriWithMsLaunchUri = function openUriWithMsLaunchUri(uri, failCb, successCb) {\n  navigator.msLaunchUri(uri, successCb, failCb);\n};\n\nvar getBrowserVersion = function getBrowserVersion() {\n  var ua = window.navigator.userAgent;\n  var tem,\n      M = ua.match(/(opera|chrome|safari|firefox|msie|trident(?=\\/))\\/?\\s*(\\d+)/i) || [];\n\n  if (/trident/i.test(M[1])) {\n    tem = /\\brv[ :]+(\\d+)/g.exec(ua) || [];\n    return parseFloat(tem[1]) || "";\n  }\n\n  if (M[1] === "Chrome") {\n    tem = ua.match(/\\b(OPR|Edge)\\/(\\d+)/);\n\n    if (tem != null) {\n      return parseFloat(tem[2]);\n    }\n  }\n\n  M = M[2] ? [M[1], M[2]] : [window.navigator.appName, window.navigator.appVersion, "-?"];\n  if ((tem = ua.match(/version\\/(\\d+)/i)) != null) M.splice(1, 1, tem[1]);\n  return parseFloat(M[1]);\n};\n\nvar protocolCheck = function protocolCheck(uri, failCb, successCb) {\n  var timeout = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 2000;\n  var unsupportedCb = arguments.length > 4 ? arguments[4] : undefined;\n\n  var failCallback = function failCallback() {\n    failCb && failCb();\n  };\n\n  var successCallback = function successCallback() {\n    successCb && successCb();\n  };\n\n  var unsupportedCallback = function unsupportedCallback() {\n    unsupportedCb && unsupportedCb();\n  };\n\n  var openUri = function openUri() {\n    if (browser.isFirefox()) {\n      var browserVersion = getBrowserVersion();\n\n      if (browserVersion >= 64) {\n        openUriWithHiddenFrame(uri, failCallback, successCallback);\n      } else {\n        openUriUsingFirefox(uri, failCallback, successCallback);\n      }\n    } else if (browser.isChrome()) {\n      openUriWithTimeoutHack(uri, failCallback, successCallback);\n    } else if (browser.isOSX()) {\n      openUriWithHiddenFrame(uri, failCallback, successCallback);\n    } else {\n      //not supported, implement please\n      unsupportedCallback();\n    }\n  };\n\n  if (timeout) {\n    DEFAULT_CUSTOM_PROTOCOL_FAIL_CALLBACK_TIMEOUT = timeout;\n  }\n\n  if (browser.isEdge() || browser.isIE()) {\n    //for IE and Edge in Win 8 and Win 10\n    openUriWithMsLaunchUri(uri, failCb, successCb);\n  } else {\n    if (document.hasFocus()) {\n      openUri();\n    } else {\n      var focusHandler = registerEvent(window, "focus", function () {\n        focusHandler.remove();\n        openUri();\n      });\n    }\n  }\n};\n\nmodule.exports = protocolCheck;\n\n//# sourceURL=webpack://customProtocolCheck/./index.js?')},0:function(module,exports,__webpack_require__){eval('module.exports = __webpack_require__(/*! /Users/shahv/Viresh/work/rnd/custom-protocol-check/index.js */"./index.js");\n\n\n//# sourceURL=webpack://customProtocolCheck/multi_./index.js?')}})}));