# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ConfigurationProfileArgs', 'ConfigurationProfile']

@pulumi.input_type
class ConfigurationProfileArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 reference_host_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ConfigurationProfile resource.
        :param pulumi.Input[_builtins.str] cluster_id: The identifier of the cluster.
        :param pulumi.Input[_builtins.str] configuration: The configuration JSON provided as a plain string. This argument can only be specified if `reference_host_id` is not set.
        :param pulumi.Input[_builtins.str] reference_host_id: The identifier of the host to use as a configuration source.
               The host needs to be a member of the cluster identified by `cluster_id`. This argument can only be specified if
               `configuration` is not set.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if reference_host_id is not None:
            pulumi.set(__self__, "reference_host_id", reference_host_id)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The identifier of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration JSON provided as a plain string. This argument can only be specified if `reference_host_id` is not set.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter(name="referenceHostId")
    def reference_host_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the host to use as a configuration source.
        The host needs to be a member of the cluster identified by `cluster_id`. This argument can only be specified if
        `configuration` is not set.
        """
        return pulumi.get(self, "reference_host_id")

    @reference_host_id.setter
    def reference_host_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reference_host_id", value)


@pulumi.input_type
class _ConfigurationProfileState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 reference_host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ConfigurationProfile resources.
        :param pulumi.Input[_builtins.str] cluster_id: The identifier of the cluster.
        :param pulumi.Input[_builtins.str] configuration: The configuration JSON provided as a plain string. This argument can only be specified if `reference_host_id` is not set.
        :param pulumi.Input[_builtins.str] reference_host_id: The identifier of the host to use as a configuration source.
               The host needs to be a member of the cluster identified by `cluster_id`. This argument can only be specified if
               `configuration` is not set.
        :param pulumi.Input[_builtins.str] schema: The JSON schema for the profile.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if reference_host_id is not None:
            pulumi.set(__self__, "reference_host_id", reference_host_id)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration JSON provided as a plain string. This argument can only be specified if `reference_host_id` is not set.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter(name="referenceHostId")
    def reference_host_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the host to use as a configuration source.
        The host needs to be a member of the cluster identified by `cluster_id`. This argument can only be specified if
        `configuration` is not set.
        """
        return pulumi.get(self, "reference_host_id")

    @reference_host_id.setter
    def reference_host_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reference_host_id", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The JSON schema for the profile.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)


@pulumi.type_token("vsphere:index/configurationProfile:ConfigurationProfile")
class ConfigurationProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 reference_host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a ConfigurationProfile resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The identifier of the cluster.
        :param pulumi.Input[_builtins.str] configuration: The configuration JSON provided as a plain string. This argument can only be specified if `reference_host_id` is not set.
        :param pulumi.Input[_builtins.str] reference_host_id: The identifier of the host to use as a configuration source.
               The host needs to be a member of the cluster identified by `cluster_id`. This argument can only be specified if
               `configuration` is not set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigurationProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ConfigurationProfile resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ConfigurationProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigurationProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 reference_host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigurationProfileArgs.__new__(ConfigurationProfileArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["reference_host_id"] = reference_host_id
            __props__.__dict__["schema"] = None
        super(ConfigurationProfile, __self__).__init__(
            'vsphere:index/configurationProfile:ConfigurationProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            configuration: Optional[pulumi.Input[_builtins.str]] = None,
            reference_host_id: Optional[pulumi.Input[_builtins.str]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None) -> 'ConfigurationProfile':
        """
        Get an existing ConfigurationProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The identifier of the cluster.
        :param pulumi.Input[_builtins.str] configuration: The configuration JSON provided as a plain string. This argument can only be specified if `reference_host_id` is not set.
        :param pulumi.Input[_builtins.str] reference_host_id: The identifier of the host to use as a configuration source.
               The host needs to be a member of the cluster identified by `cluster_id`. This argument can only be specified if
               `configuration` is not set.
        :param pulumi.Input[_builtins.str] schema: The JSON schema for the profile.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigurationProfileState.__new__(_ConfigurationProfileState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["reference_host_id"] = reference_host_id
        __props__.__dict__["schema"] = schema
        return ConfigurationProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[_builtins.str]:
        """
        The configuration JSON provided as a plain string. This argument can only be specified if `reference_host_id` is not set.
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter(name="referenceHostId")
    def reference_host_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier of the host to use as a configuration source.
        The host needs to be a member of the cluster identified by `cluster_id`. This argument can only be specified if
        `configuration` is not set.
        """
        return pulumi.get(self, "reference_host_id")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The JSON schema for the profile.
        """
        return pulumi.get(self, "schema")

