# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAuthenticationRuleResult',
    'AwaitableGetAuthenticationRuleResult',
    'get_authentication_rule',
    'get_authentication_rule_output',
]

@pulumi.output_type
class GetAuthenticationRuleResult:
    """
    A collection of values returned by getAuthenticationRule.
    """
    def __init__(__self__, authentication_enforcement=None, categories=None, description=None, destination_hips=None, destinations=None, disabled=None, froms=None, group_tag=None, hip_profiles=None, id=None, log_authentication_timeout=None, log_setting=None, name=None, negate_destination=None, negate_source=None, services=None, source_hips=None, source_users=None, sources=None, tags=None, tfid=None, timeout=None, tos=None):
        if authentication_enforcement and not isinstance(authentication_enforcement, str):
            raise TypeError("Expected argument 'authentication_enforcement' to be a str")
        pulumi.set(__self__, "authentication_enforcement", authentication_enforcement)
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if destination_hips and not isinstance(destination_hips, list):
            raise TypeError("Expected argument 'destination_hips' to be a list")
        pulumi.set(__self__, "destination_hips", destination_hips)
        if destinations and not isinstance(destinations, list):
            raise TypeError("Expected argument 'destinations' to be a list")
        pulumi.set(__self__, "destinations", destinations)
        if disabled and not isinstance(disabled, bool):
            raise TypeError("Expected argument 'disabled' to be a bool")
        pulumi.set(__self__, "disabled", disabled)
        if froms and not isinstance(froms, list):
            raise TypeError("Expected argument 'froms' to be a list")
        pulumi.set(__self__, "froms", froms)
        if group_tag and not isinstance(group_tag, str):
            raise TypeError("Expected argument 'group_tag' to be a str")
        pulumi.set(__self__, "group_tag", group_tag)
        if hip_profiles and not isinstance(hip_profiles, list):
            raise TypeError("Expected argument 'hip_profiles' to be a list")
        pulumi.set(__self__, "hip_profiles", hip_profiles)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if log_authentication_timeout and not isinstance(log_authentication_timeout, bool):
            raise TypeError("Expected argument 'log_authentication_timeout' to be a bool")
        pulumi.set(__self__, "log_authentication_timeout", log_authentication_timeout)
        if log_setting and not isinstance(log_setting, str):
            raise TypeError("Expected argument 'log_setting' to be a str")
        pulumi.set(__self__, "log_setting", log_setting)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if negate_destination and not isinstance(negate_destination, bool):
            raise TypeError("Expected argument 'negate_destination' to be a bool")
        pulumi.set(__self__, "negate_destination", negate_destination)
        if negate_source and not isinstance(negate_source, bool):
            raise TypeError("Expected argument 'negate_source' to be a bool")
        pulumi.set(__self__, "negate_source", negate_source)
        if services and not isinstance(services, list):
            raise TypeError("Expected argument 'services' to be a list")
        pulumi.set(__self__, "services", services)
        if source_hips and not isinstance(source_hips, list):
            raise TypeError("Expected argument 'source_hips' to be a list")
        pulumi.set(__self__, "source_hips", source_hips)
        if source_users and not isinstance(source_users, list):
            raise TypeError("Expected argument 'source_users' to be a list")
        pulumi.set(__self__, "source_users", source_users)
        if sources and not isinstance(sources, list):
            raise TypeError("Expected argument 'sources' to be a list")
        pulumi.set(__self__, "sources", sources)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)
        if timeout and not isinstance(timeout, int):
            raise TypeError("Expected argument 'timeout' to be a int")
        pulumi.set(__self__, "timeout", timeout)
        if tos and not isinstance(tos, list):
            raise TypeError("Expected argument 'tos' to be a list")
        pulumi.set(__self__, "tos", tos)

    @_builtins.property
    @pulumi.getter(name="authenticationEnforcement")
    def authentication_enforcement(self) -> _builtins.str:
        """
        the authentication profile name to apply to authentication rule.
        """
        return pulumi.get(self, "authentication_enforcement")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Sequence[_builtins.str]:
        """
        The Categories param.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The Description param.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationHips")
    def destination_hips(self) -> Sequence[_builtins.str]:
        """
        The DestinationHips param.
        """
        return pulumi.get(self, "destination_hips")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Sequence[_builtins.str]:
        """
        The Destinations param.
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> _builtins.bool:
        """
        The Disabled param. Default: `false`.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def froms(self) -> Sequence[_builtins.str]:
        """
        The Froms param.
        """
        return pulumi.get(self, "froms")

    @_builtins.property
    @pulumi.getter(name="groupTag")
    def group_tag(self) -> _builtins.str:
        """
        The GroupTag param.
        """
        return pulumi.get(self, "group_tag")

    @_builtins.property
    @pulumi.getter(name="hipProfiles")
    def hip_profiles(self) -> Sequence[_builtins.str]:
        """
        The HipProfiles param.
        """
        return pulumi.get(self, "hip_profiles")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The Id param.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="logAuthenticationTimeout")
    def log_authentication_timeout(self) -> _builtins.bool:
        """
        The LogAuthenticationTimeout param. Default: `false`.
        """
        return pulumi.get(self, "log_authentication_timeout")

    @_builtins.property
    @pulumi.getter(name="logSetting")
    def log_setting(self) -> _builtins.str:
        """
        The LogSetting param.
        """
        return pulumi.get(self, "log_setting")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Name param.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="negateDestination")
    def negate_destination(self) -> _builtins.bool:
        """
        The NegateDestination param. Default: `false`.
        """
        return pulumi.get(self, "negate_destination")

    @_builtins.property
    @pulumi.getter(name="negateSource")
    def negate_source(self) -> _builtins.bool:
        """
        The NegateSource param. Default: `false`.
        """
        return pulumi.get(self, "negate_source")

    @_builtins.property
    @pulumi.getter
    def services(self) -> Sequence[_builtins.str]:
        """
        The Services param.
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter(name="sourceHips")
    def source_hips(self) -> Sequence[_builtins.str]:
        """
        The SourceHips param.
        """
        return pulumi.get(self, "source_hips")

    @_builtins.property
    @pulumi.getter(name="sourceUsers")
    def source_users(self) -> Sequence[_builtins.str]:
        """
        The SourceUsers param.
        """
        return pulumi.get(self, "source_users")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence[_builtins.str]:
        """
        The Sources param.
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        The Tags param.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.int:
        """
        The Timeout param. Value must be between 1 and 1440.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def tos(self) -> Sequence[_builtins.str]:
        """
        The Tos param.
        """
        return pulumi.get(self, "tos")


class AwaitableGetAuthenticationRuleResult(GetAuthenticationRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthenticationRuleResult(
            authentication_enforcement=self.authentication_enforcement,
            categories=self.categories,
            description=self.description,
            destination_hips=self.destination_hips,
            destinations=self.destinations,
            disabled=self.disabled,
            froms=self.froms,
            group_tag=self.group_tag,
            hip_profiles=self.hip_profiles,
            id=self.id,
            log_authentication_timeout=self.log_authentication_timeout,
            log_setting=self.log_setting,
            name=self.name,
            negate_destination=self.negate_destination,
            negate_source=self.negate_source,
            services=self.services,
            source_hips=self.source_hips,
            source_users=self.source_users,
            sources=self.sources,
            tags=self.tags,
            tfid=self.tfid,
            timeout=self.timeout,
            tos=self.tos)


def get_authentication_rule(id: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthenticationRuleResult:
    """
    Retrieves a config item.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    example = scm.get_authentication_rule(id="1234-56-789")
    ```


    :param _builtins.str id: The Id param.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getAuthenticationRule:getAuthenticationRule', __args__, opts=opts, typ=GetAuthenticationRuleResult).value

    return AwaitableGetAuthenticationRuleResult(
        authentication_enforcement=pulumi.get(__ret__, 'authentication_enforcement'),
        categories=pulumi.get(__ret__, 'categories'),
        description=pulumi.get(__ret__, 'description'),
        destination_hips=pulumi.get(__ret__, 'destination_hips'),
        destinations=pulumi.get(__ret__, 'destinations'),
        disabled=pulumi.get(__ret__, 'disabled'),
        froms=pulumi.get(__ret__, 'froms'),
        group_tag=pulumi.get(__ret__, 'group_tag'),
        hip_profiles=pulumi.get(__ret__, 'hip_profiles'),
        id=pulumi.get(__ret__, 'id'),
        log_authentication_timeout=pulumi.get(__ret__, 'log_authentication_timeout'),
        log_setting=pulumi.get(__ret__, 'log_setting'),
        name=pulumi.get(__ret__, 'name'),
        negate_destination=pulumi.get(__ret__, 'negate_destination'),
        negate_source=pulumi.get(__ret__, 'negate_source'),
        services=pulumi.get(__ret__, 'services'),
        source_hips=pulumi.get(__ret__, 'source_hips'),
        source_users=pulumi.get(__ret__, 'source_users'),
        sources=pulumi.get(__ret__, 'sources'),
        tags=pulumi.get(__ret__, 'tags'),
        tfid=pulumi.get(__ret__, 'tfid'),
        timeout=pulumi.get(__ret__, 'timeout'),
        tos=pulumi.get(__ret__, 'tos'))
def get_authentication_rule_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAuthenticationRuleResult]:
    """
    Retrieves a config item.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    example = scm.get_authentication_rule(id="1234-56-789")
    ```


    :param _builtins.str id: The Id param.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getAuthenticationRule:getAuthenticationRule', __args__, opts=opts, typ=GetAuthenticationRuleResult)
    return __ret__.apply(lambda __response__: GetAuthenticationRuleResult(
        authentication_enforcement=pulumi.get(__response__, 'authentication_enforcement'),
        categories=pulumi.get(__response__, 'categories'),
        description=pulumi.get(__response__, 'description'),
        destination_hips=pulumi.get(__response__, 'destination_hips'),
        destinations=pulumi.get(__response__, 'destinations'),
        disabled=pulumi.get(__response__, 'disabled'),
        froms=pulumi.get(__response__, 'froms'),
        group_tag=pulumi.get(__response__, 'group_tag'),
        hip_profiles=pulumi.get(__response__, 'hip_profiles'),
        id=pulumi.get(__response__, 'id'),
        log_authentication_timeout=pulumi.get(__response__, 'log_authentication_timeout'),
        log_setting=pulumi.get(__response__, 'log_setting'),
        name=pulumi.get(__response__, 'name'),
        negate_destination=pulumi.get(__response__, 'negate_destination'),
        negate_source=pulumi.get(__response__, 'negate_source'),
        services=pulumi.get(__response__, 'services'),
        source_hips=pulumi.get(__response__, 'source_hips'),
        source_users=pulumi.get(__response__, 'source_users'),
        sources=pulumi.get(__response__, 'sources'),
        tags=pulumi.get(__response__, 'tags'),
        tfid=pulumi.get(__response__, 'tfid'),
        timeout=pulumi.get(__response__, 'timeout'),
        tos=pulumi.get(__response__, 'tos')))
