# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetJobsResult',
    'AwaitableGetJobsResult',
    'get_jobs',
    'get_jobs_output',
]

@pulumi.output_type
class GetJobsResult:
    """
    A collection of values returned by getJobs.
    """
    def __init__(__self__, description=None, device_name=None, end_ts=None, id=None, job_result=None, job_status=None, job_type=None, parent_id=None, percent=None, result_str=None, start_ts=None, status_str=None, summary=None, tfid=None, type_str=None, uname=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device_name and not isinstance(device_name, str):
            raise TypeError("Expected argument 'device_name' to be a str")
        pulumi.set(__self__, "device_name", device_name)
        if end_ts and not isinstance(end_ts, str):
            raise TypeError("Expected argument 'end_ts' to be a str")
        pulumi.set(__self__, "end_ts", end_ts)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if job_result and not isinstance(job_result, int):
            raise TypeError("Expected argument 'job_result' to be a int")
        pulumi.set(__self__, "job_result", job_result)
        if job_status and not isinstance(job_status, int):
            raise TypeError("Expected argument 'job_status' to be a int")
        pulumi.set(__self__, "job_status", job_status)
        if job_type and not isinstance(job_type, int):
            raise TypeError("Expected argument 'job_type' to be a int")
        pulumi.set(__self__, "job_type", job_type)
        if parent_id and not isinstance(parent_id, int):
            raise TypeError("Expected argument 'parent_id' to be a int")
        pulumi.set(__self__, "parent_id", parent_id)
        if percent and not isinstance(percent, int):
            raise TypeError("Expected argument 'percent' to be a int")
        pulumi.set(__self__, "percent", percent)
        if result_str and not isinstance(result_str, str):
            raise TypeError("Expected argument 'result_str' to be a str")
        pulumi.set(__self__, "result_str", result_str)
        if start_ts and not isinstance(start_ts, str):
            raise TypeError("Expected argument 'start_ts' to be a str")
        pulumi.set(__self__, "start_ts", start_ts)
        if status_str and not isinstance(status_str, str):
            raise TypeError("Expected argument 'status_str' to be a str")
        pulumi.set(__self__, "status_str", status_str)
        if summary and not isinstance(summary, str):
            raise TypeError("Expected argument 'summary' to be a str")
        pulumi.set(__self__, "summary", summary)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)
        if type_str and not isinstance(type_str, str):
            raise TypeError("Expected argument 'type_str' to be a str")
        pulumi.set(__self__, "type_str", type_str)
        if uname and not isinstance(uname, str):
            raise TypeError("Expected argument 'uname' to be a str")
        pulumi.set(__self__, "uname", uname)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description provided by the administrator or service account.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> _builtins.str:
        """
        The name of the device.
        """
        return pulumi.get(self, "device_name")

    @_builtins.property
    @pulumi.getter(name="endTs")
    def end_ts(self) -> _builtins.str:
        """
        The timestamp indicating when the job was finished.
        """
        return pulumi.get(self, "end_ts")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The Id param.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="jobResult")
    def job_result(self) -> _builtins.int:
        """
        The job result.
        """
        return pulumi.get(self, "job_result")

    @_builtins.property
    @pulumi.getter(name="jobStatus")
    def job_status(self) -> _builtins.int:
        """
        The current status of the job.
        """
        return pulumi.get(self, "job_status")

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> _builtins.int:
        """
        The job type.
        """
        return pulumi.get(self, "job_type")

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> _builtins.int:
        """
        The parent job ID.
        """
        return pulumi.get(self, "parent_id")

    @_builtins.property
    @pulumi.getter
    def percent(self) -> _builtins.int:
        """
        Job completion percentage. Value must be less than or equal to 100.
        """
        return pulumi.get(self, "percent")

    @_builtins.property
    @pulumi.getter(name="resultStr")
    def result_str(self) -> _builtins.str:
        """
        The result of the job. String must be one of these: `"OK"`, `"FAIL"`, `"PEND"`, `"WAIT"`, `"CANCELLED"`.
        """
        return pulumi.get(self, "result_str")

    @_builtins.property
    @pulumi.getter(name="startTs")
    def start_ts(self) -> _builtins.str:
        """
        The timestamp indicating when the job was created.
        """
        return pulumi.get(self, "start_ts")

    @_builtins.property
    @pulumi.getter(name="statusStr")
    def status_str(self) -> _builtins.str:
        """
        The current status of the job. String must be one of these: `"ACT"`, `"FIN"`, `"PEND"`, `"PUSHSENT"`, `"PUSHFAIL"`.
        """
        return pulumi.get(self, "status_str")

    @_builtins.property
    @pulumi.getter
    def summary(self) -> _builtins.str:
        """
        The completion summary of the job.
        """
        return pulumi.get(self, "summary")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="typeStr")
    def type_str(self) -> _builtins.str:
        """
        The job type. String must be one of these: `"CommitAll"`, `"CommitAndPush"`, `"NGFW-Bootstrap-Push"`, `"Validate"`.
        """
        return pulumi.get(self, "type_str")

    @_builtins.property
    @pulumi.getter
    def uname(self) -> _builtins.str:
        """
        The administrator or service account that created the job.
        """
        return pulumi.get(self, "uname")


class AwaitableGetJobsResult(GetJobsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJobsResult(
            description=self.description,
            device_name=self.device_name,
            end_ts=self.end_ts,
            id=self.id,
            job_result=self.job_result,
            job_status=self.job_status,
            job_type=self.job_type,
            parent_id=self.parent_id,
            percent=self.percent,
            result_str=self.result_str,
            start_ts=self.start_ts,
            status_str=self.status_str,
            summary=self.summary,
            tfid=self.tfid,
            type_str=self.type_str,
            uname=self.uname)


def get_jobs(id: Optional[_builtins.int] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJobsResult:
    """
    Retrieves a config item.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    example = scm.get_jobs()
    ```


    :param _builtins.int id: The Id param.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getJobs:getJobs', __args__, opts=opts, typ=GetJobsResult).value

    return AwaitableGetJobsResult(
        description=pulumi.get(__ret__, 'description'),
        device_name=pulumi.get(__ret__, 'device_name'),
        end_ts=pulumi.get(__ret__, 'end_ts'),
        id=pulumi.get(__ret__, 'id'),
        job_result=pulumi.get(__ret__, 'job_result'),
        job_status=pulumi.get(__ret__, 'job_status'),
        job_type=pulumi.get(__ret__, 'job_type'),
        parent_id=pulumi.get(__ret__, 'parent_id'),
        percent=pulumi.get(__ret__, 'percent'),
        result_str=pulumi.get(__ret__, 'result_str'),
        start_ts=pulumi.get(__ret__, 'start_ts'),
        status_str=pulumi.get(__ret__, 'status_str'),
        summary=pulumi.get(__ret__, 'summary'),
        tfid=pulumi.get(__ret__, 'tfid'),
        type_str=pulumi.get(__ret__, 'type_str'),
        uname=pulumi.get(__ret__, 'uname'))
def get_jobs_output(id: Optional[pulumi.Input[_builtins.int]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetJobsResult]:
    """
    Retrieves a config item.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    example = scm.get_jobs()
    ```


    :param _builtins.int id: The Id param.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getJobs:getJobs', __args__, opts=opts, typ=GetJobsResult)
    return __ret__.apply(lambda __response__: GetJobsResult(
        description=pulumi.get(__response__, 'description'),
        device_name=pulumi.get(__response__, 'device_name'),
        end_ts=pulumi.get(__response__, 'end_ts'),
        id=pulumi.get(__response__, 'id'),
        job_result=pulumi.get(__response__, 'job_result'),
        job_status=pulumi.get(__response__, 'job_status'),
        job_type=pulumi.get(__response__, 'job_type'),
        parent_id=pulumi.get(__response__, 'parent_id'),
        percent=pulumi.get(__response__, 'percent'),
        result_str=pulumi.get(__response__, 'result_str'),
        start_ts=pulumi.get(__response__, 'start_ts'),
        status_str=pulumi.get(__response__, 'status_str'),
        summary=pulumi.get(__response__, 'summary'),
        tfid=pulumi.get(__response__, 'tfid'),
        type_str=pulumi.get(__response__, 'type_str'),
        uname=pulumi.get(__response__, 'uname')))
