# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetProfileGroupResult',
    'AwaitableGetProfileGroupResult',
    'get_profile_group',
    'get_profile_group_output',
]

@pulumi.output_type
class GetProfileGroupResult:
    """
    A collection of values returned by getProfileGroup.
    """
    def __init__(__self__, ai_securities=None, dns_securities=None, file_blockings=None, id=None, name=None, saas_securities=None, spywares=None, tfid=None, url_filterings=None, virus_and_wildfire_analyses=None, vulnerabilities=None):
        if ai_securities and not isinstance(ai_securities, list):
            raise TypeError("Expected argument 'ai_securities' to be a list")
        pulumi.set(__self__, "ai_securities", ai_securities)
        if dns_securities and not isinstance(dns_securities, list):
            raise TypeError("Expected argument 'dns_securities' to be a list")
        pulumi.set(__self__, "dns_securities", dns_securities)
        if file_blockings and not isinstance(file_blockings, list):
            raise TypeError("Expected argument 'file_blockings' to be a list")
        pulumi.set(__self__, "file_blockings", file_blockings)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if saas_securities and not isinstance(saas_securities, list):
            raise TypeError("Expected argument 'saas_securities' to be a list")
        pulumi.set(__self__, "saas_securities", saas_securities)
        if spywares and not isinstance(spywares, list):
            raise TypeError("Expected argument 'spywares' to be a list")
        pulumi.set(__self__, "spywares", spywares)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)
        if url_filterings and not isinstance(url_filterings, list):
            raise TypeError("Expected argument 'url_filterings' to be a list")
        pulumi.set(__self__, "url_filterings", url_filterings)
        if virus_and_wildfire_analyses and not isinstance(virus_and_wildfire_analyses, list):
            raise TypeError("Expected argument 'virus_and_wildfire_analyses' to be a list")
        pulumi.set(__self__, "virus_and_wildfire_analyses", virus_and_wildfire_analyses)
        if vulnerabilities and not isinstance(vulnerabilities, list):
            raise TypeError("Expected argument 'vulnerabilities' to be a list")
        pulumi.set(__self__, "vulnerabilities", vulnerabilities)

    @_builtins.property
    @pulumi.getter(name="aiSecurities")
    def ai_securities(self) -> Sequence[_builtins.str]:
        """
        List of AI security profiles.
        """
        return pulumi.get(self, "ai_securities")

    @_builtins.property
    @pulumi.getter(name="dnsSecurities")
    def dns_securities(self) -> Sequence[_builtins.str]:
        """
        List of DNS security profiles.
        """
        return pulumi.get(self, "dns_securities")

    @_builtins.property
    @pulumi.getter(name="fileBlockings")
    def file_blockings(self) -> Sequence[_builtins.str]:
        """
        List of file blocking profiles.
        """
        return pulumi.get(self, "file_blockings")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The Id param.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the profile group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="saasSecurities")
    def saas_securities(self) -> Sequence[_builtins.str]:
        """
        List of HTTP header insertion profiles.
        """
        return pulumi.get(self, "saas_securities")

    @_builtins.property
    @pulumi.getter
    def spywares(self) -> Sequence[_builtins.str]:
        """
        List of anti-spyware profiles.
        """
        return pulumi.get(self, "spywares")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="urlFilterings")
    def url_filterings(self) -> Sequence[_builtins.str]:
        """
        List of URL filtering profiles.
        """
        return pulumi.get(self, "url_filterings")

    @_builtins.property
    @pulumi.getter(name="virusAndWildfireAnalyses")
    def virus_and_wildfire_analyses(self) -> Sequence[_builtins.str]:
        """
        List of anti-virus and Wildfire analysis profiles.
        """
        return pulumi.get(self, "virus_and_wildfire_analyses")

    @_builtins.property
    @pulumi.getter
    def vulnerabilities(self) -> Sequence[_builtins.str]:
        """
        List of vulnerability protection profiles.
        """
        return pulumi.get(self, "vulnerabilities")


class AwaitableGetProfileGroupResult(GetProfileGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProfileGroupResult(
            ai_securities=self.ai_securities,
            dns_securities=self.dns_securities,
            file_blockings=self.file_blockings,
            id=self.id,
            name=self.name,
            saas_securities=self.saas_securities,
            spywares=self.spywares,
            tfid=self.tfid,
            url_filterings=self.url_filterings,
            virus_and_wildfire_analyses=self.virus_and_wildfire_analyses,
            vulnerabilities=self.vulnerabilities)


def get_profile_group(id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProfileGroupResult:
    """
    Retrieves a config item.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    example = scm.get_profile_group(id="1234-56-789")
    ```


    :param _builtins.str id: The Id param.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getProfileGroup:getProfileGroup', __args__, opts=opts, typ=GetProfileGroupResult).value

    return AwaitableGetProfileGroupResult(
        ai_securities=pulumi.get(__ret__, 'ai_securities'),
        dns_securities=pulumi.get(__ret__, 'dns_securities'),
        file_blockings=pulumi.get(__ret__, 'file_blockings'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        saas_securities=pulumi.get(__ret__, 'saas_securities'),
        spywares=pulumi.get(__ret__, 'spywares'),
        tfid=pulumi.get(__ret__, 'tfid'),
        url_filterings=pulumi.get(__ret__, 'url_filterings'),
        virus_and_wildfire_analyses=pulumi.get(__ret__, 'virus_and_wildfire_analyses'),
        vulnerabilities=pulumi.get(__ret__, 'vulnerabilities'))
def get_profile_group_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProfileGroupResult]:
    """
    Retrieves a config item.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    example = scm.get_profile_group(id="1234-56-789")
    ```


    :param _builtins.str id: The Id param.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getProfileGroup:getProfileGroup', __args__, opts=opts, typ=GetProfileGroupResult)
    return __ret__.apply(lambda __response__: GetProfileGroupResult(
        ai_securities=pulumi.get(__response__, 'ai_securities'),
        dns_securities=pulumi.get(__response__, 'dns_securities'),
        file_blockings=pulumi.get(__response__, 'file_blockings'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        saas_securities=pulumi.get(__response__, 'saas_securities'),
        spywares=pulumi.get(__response__, 'spywares'),
        tfid=pulumi.get(__response__, 'tfid'),
        url_filterings=pulumi.get(__response__, 'url_filterings'),
        virus_and_wildfire_analyses=pulumi.get(__response__, 'virus_and_wildfire_analyses'),
        vulnerabilities=pulumi.get(__response__, 'vulnerabilities')))
