# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetScepProfileResult',
    'AwaitableGetScepProfileResult',
    'get_scep_profile',
    'get_scep_profile_output',
]

@pulumi.output_type
class GetScepProfileResult:
    """
    A collection of values returned by getScepProfile.
    """
    def __init__(__self__, algorithm=None, ca_identity_name=None, certificate_attributes=None, digest=None, fingerprint=None, id=None, name=None, scep_ca_cert=None, scep_challenge=None, scep_client_cert=None, scep_url=None, subject=None, tfid=None, use_as_digital_signature=None, use_for_key_encipherment=None):
        if algorithm and not isinstance(algorithm, dict):
            raise TypeError("Expected argument 'algorithm' to be a dict")
        pulumi.set(__self__, "algorithm", algorithm)
        if ca_identity_name and not isinstance(ca_identity_name, str):
            raise TypeError("Expected argument 'ca_identity_name' to be a str")
        pulumi.set(__self__, "ca_identity_name", ca_identity_name)
        if certificate_attributes and not isinstance(certificate_attributes, dict):
            raise TypeError("Expected argument 'certificate_attributes' to be a dict")
        pulumi.set(__self__, "certificate_attributes", certificate_attributes)
        if digest and not isinstance(digest, str):
            raise TypeError("Expected argument 'digest' to be a str")
        pulumi.set(__self__, "digest", digest)
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if scep_ca_cert and not isinstance(scep_ca_cert, str):
            raise TypeError("Expected argument 'scep_ca_cert' to be a str")
        pulumi.set(__self__, "scep_ca_cert", scep_ca_cert)
        if scep_challenge and not isinstance(scep_challenge, dict):
            raise TypeError("Expected argument 'scep_challenge' to be a dict")
        pulumi.set(__self__, "scep_challenge", scep_challenge)
        if scep_client_cert and not isinstance(scep_client_cert, str):
            raise TypeError("Expected argument 'scep_client_cert' to be a str")
        pulumi.set(__self__, "scep_client_cert", scep_client_cert)
        if scep_url and not isinstance(scep_url, str):
            raise TypeError("Expected argument 'scep_url' to be a str")
        pulumi.set(__self__, "scep_url", scep_url)
        if subject and not isinstance(subject, str):
            raise TypeError("Expected argument 'subject' to be a str")
        pulumi.set(__self__, "subject", subject)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)
        if use_as_digital_signature and not isinstance(use_as_digital_signature, bool):
            raise TypeError("Expected argument 'use_as_digital_signature' to be a bool")
        pulumi.set(__self__, "use_as_digital_signature", use_as_digital_signature)
        if use_for_key_encipherment and not isinstance(use_for_key_encipherment, bool):
            raise TypeError("Expected argument 'use_for_key_encipherment' to be a bool")
        pulumi.set(__self__, "use_for_key_encipherment", use_for_key_encipherment)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> 'outputs.GetScepProfileAlgorithmResult':
        """
        The Algorithm param.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter(name="caIdentityName")
    def ca_identity_name(self) -> _builtins.str:
        """
        The CaIdentityName param.
        """
        return pulumi.get(self, "ca_identity_name")

    @_builtins.property
    @pulumi.getter(name="certificateAttributes")
    def certificate_attributes(self) -> 'outputs.GetScepProfileCertificateAttributesResult':
        """
        The CertificateAttributes param.
        """
        return pulumi.get(self, "certificate_attributes")

    @_builtins.property
    @pulumi.getter
    def digest(self) -> _builtins.str:
        """
        The Digest param.
        """
        return pulumi.get(self, "digest")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> _builtins.str:
        """
        The Fingerprint param.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The Id param.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        alphanumeric string [ 0-9a-zA-Z._-]. String length must not exceed 31 characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="scepCaCert")
    def scep_ca_cert(self) -> _builtins.str:
        """
        The ScepCaCert param.
        """
        return pulumi.get(self, "scep_ca_cert")

    @_builtins.property
    @pulumi.getter(name="scepChallenge")
    def scep_challenge(self) -> 'outputs.GetScepProfileScepChallengeResult':
        """
        The ScepChallenge param.
        """
        return pulumi.get(self, "scep_challenge")

    @_builtins.property
    @pulumi.getter(name="scepClientCert")
    def scep_client_cert(self) -> _builtins.str:
        """
        The ScepClientCert param.
        """
        return pulumi.get(self, "scep_client_cert")

    @_builtins.property
    @pulumi.getter(name="scepUrl")
    def scep_url(self) -> _builtins.str:
        """
        The ScepUrl param.
        """
        return pulumi.get(self, "scep_url")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> _builtins.str:
        """
        The Subject param.
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="useAsDigitalSignature")
    def use_as_digital_signature(self) -> _builtins.bool:
        """
        The UseAsDigitalSignature param.
        """
        return pulumi.get(self, "use_as_digital_signature")

    @_builtins.property
    @pulumi.getter(name="useForKeyEncipherment")
    def use_for_key_encipherment(self) -> _builtins.bool:
        """
        The UseForKeyEncipherment param.
        """
        return pulumi.get(self, "use_for_key_encipherment")


class AwaitableGetScepProfileResult(GetScepProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScepProfileResult(
            algorithm=self.algorithm,
            ca_identity_name=self.ca_identity_name,
            certificate_attributes=self.certificate_attributes,
            digest=self.digest,
            fingerprint=self.fingerprint,
            id=self.id,
            name=self.name,
            scep_ca_cert=self.scep_ca_cert,
            scep_challenge=self.scep_challenge,
            scep_client_cert=self.scep_client_cert,
            scep_url=self.scep_url,
            subject=self.subject,
            tfid=self.tfid,
            use_as_digital_signature=self.use_as_digital_signature,
            use_for_key_encipherment=self.use_for_key_encipherment)


def get_scep_profile(id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScepProfileResult:
    """
    Retrieves a config item.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    example = scm.get_scep_profile(id="1234-56-789")
    ```


    :param _builtins.str id: The Id param.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getScepProfile:getScepProfile', __args__, opts=opts, typ=GetScepProfileResult).value

    return AwaitableGetScepProfileResult(
        algorithm=pulumi.get(__ret__, 'algorithm'),
        ca_identity_name=pulumi.get(__ret__, 'ca_identity_name'),
        certificate_attributes=pulumi.get(__ret__, 'certificate_attributes'),
        digest=pulumi.get(__ret__, 'digest'),
        fingerprint=pulumi.get(__ret__, 'fingerprint'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        scep_ca_cert=pulumi.get(__ret__, 'scep_ca_cert'),
        scep_challenge=pulumi.get(__ret__, 'scep_challenge'),
        scep_client_cert=pulumi.get(__ret__, 'scep_client_cert'),
        scep_url=pulumi.get(__ret__, 'scep_url'),
        subject=pulumi.get(__ret__, 'subject'),
        tfid=pulumi.get(__ret__, 'tfid'),
        use_as_digital_signature=pulumi.get(__ret__, 'use_as_digital_signature'),
        use_for_key_encipherment=pulumi.get(__ret__, 'use_for_key_encipherment'))
def get_scep_profile_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetScepProfileResult]:
    """
    Retrieves a config item.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    example = scm.get_scep_profile(id="1234-56-789")
    ```


    :param _builtins.str id: The Id param.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getScepProfile:getScepProfile', __args__, opts=opts, typ=GetScepProfileResult)
    return __ret__.apply(lambda __response__: GetScepProfileResult(
        algorithm=pulumi.get(__response__, 'algorithm'),
        ca_identity_name=pulumi.get(__response__, 'ca_identity_name'),
        certificate_attributes=pulumi.get(__response__, 'certificate_attributes'),
        digest=pulumi.get(__response__, 'digest'),
        fingerprint=pulumi.get(__response__, 'fingerprint'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        scep_ca_cert=pulumi.get(__response__, 'scep_ca_cert'),
        scep_challenge=pulumi.get(__response__, 'scep_challenge'),
        scep_client_cert=pulumi.get(__response__, 'scep_client_cert'),
        scep_url=pulumi.get(__response__, 'scep_url'),
        subject=pulumi.get(__response__, 'subject'),
        tfid=pulumi.get(__response__, 'tfid'),
        use_as_digital_signature=pulumi.get(__response__, 'use_as_digital_signature'),
        use_for_key_encipherment=pulumi.get(__response__, 'use_for_key_encipherment')))
