# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetVulnerabilityProtectionSignaturesResult',
    'AwaitableGetVulnerabilityProtectionSignaturesResult',
    'get_vulnerability_protection_signatures',
    'get_vulnerability_protection_signatures_output',
]

@pulumi.output_type
class GetVulnerabilityProtectionSignaturesResult:
    """
    A collection of values returned by getVulnerabilityProtectionSignatures.
    """
    def __init__(__self__, affected_host=None, bugtraqs=None, comment=None, cves=None, default_action=None, direction=None, id=None, references=None, severity=None, signature=None, tfid=None, threat_id=None, threatname=None, vendors=None):
        if affected_host and not isinstance(affected_host, dict):
            raise TypeError("Expected argument 'affected_host' to be a dict")
        pulumi.set(__self__, "affected_host", affected_host)
        if bugtraqs and not isinstance(bugtraqs, list):
            raise TypeError("Expected argument 'bugtraqs' to be a list")
        pulumi.set(__self__, "bugtraqs", bugtraqs)
        if comment and not isinstance(comment, str):
            raise TypeError("Expected argument 'comment' to be a str")
        pulumi.set(__self__, "comment", comment)
        if cves and not isinstance(cves, list):
            raise TypeError("Expected argument 'cves' to be a list")
        pulumi.set(__self__, "cves", cves)
        if default_action and not isinstance(default_action, dict):
            raise TypeError("Expected argument 'default_action' to be a dict")
        pulumi.set(__self__, "default_action", default_action)
        if direction and not isinstance(direction, str):
            raise TypeError("Expected argument 'direction' to be a str")
        pulumi.set(__self__, "direction", direction)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if references and not isinstance(references, list):
            raise TypeError("Expected argument 'references' to be a list")
        pulumi.set(__self__, "references", references)
        if severity and not isinstance(severity, str):
            raise TypeError("Expected argument 'severity' to be a str")
        pulumi.set(__self__, "severity", severity)
        if signature and not isinstance(signature, dict):
            raise TypeError("Expected argument 'signature' to be a dict")
        pulumi.set(__self__, "signature", signature)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)
        if threat_id and not isinstance(threat_id, int):
            raise TypeError("Expected argument 'threat_id' to be a int")
        pulumi.set(__self__, "threat_id", threat_id)
        if threatname and not isinstance(threatname, str):
            raise TypeError("Expected argument 'threatname' to be a str")
        pulumi.set(__self__, "threatname", threatname)
        if vendors and not isinstance(vendors, list):
            raise TypeError("Expected argument 'vendors' to be a list")
        pulumi.set(__self__, "vendors", vendors)

    @_builtins.property
    @pulumi.getter(name="affectedHost")
    def affected_host(self) -> 'outputs.GetVulnerabilityProtectionSignaturesAffectedHostResult':
        """
        The AffectedHost param.
        """
        return pulumi.get(self, "affected_host")

    @_builtins.property
    @pulumi.getter
    def bugtraqs(self) -> Sequence[_builtins.str]:
        """
        The Bugtraqs param.
        """
        return pulumi.get(self, "bugtraqs")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        """
        The Comment param. String length must not exceed 256 characters.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def cves(self) -> Sequence[_builtins.str]:
        """
        The Cves param.
        """
        return pulumi.get(self, "cves")

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> 'outputs.GetVulnerabilityProtectionSignaturesDefaultActionResult':
        """
        The DefaultAction param.
        """
        return pulumi.get(self, "default_action")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> _builtins.str:
        """
        The Direction param. String must be one of these: `"client2server"`, `"server2client"`, `"both"`.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The Id param.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def references(self) -> Sequence[_builtins.str]:
        """
        The References param.
        """
        return pulumi.get(self, "references")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.str:
        """
        The Severity param. String must be one of these: `"critical"`, `"low"`, `"high"`, `"medium"`, `"informational"`.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def signature(self) -> 'outputs.GetVulnerabilityProtectionSignaturesSignatureResult':
        """
        The Signature param.
        """
        return pulumi.get(self, "signature")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="threatId")
    def threat_id(self) -> _builtins.int:
        """
        threat id range \\n\\n and \\n\\n. Value must be between 41000 and 6900000.
        """
        return pulumi.get(self, "threat_id")

    @_builtins.property
    @pulumi.getter
    def threatname(self) -> _builtins.str:
        """
        The Threatname param. String length must not exceed 1024 characters.
        """
        return pulumi.get(self, "threatname")

    @_builtins.property
    @pulumi.getter
    def vendors(self) -> Sequence[_builtins.str]:
        """
        The Vendors param.
        """
        return pulumi.get(self, "vendors")


class AwaitableGetVulnerabilityProtectionSignaturesResult(GetVulnerabilityProtectionSignaturesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVulnerabilityProtectionSignaturesResult(
            affected_host=self.affected_host,
            bugtraqs=self.bugtraqs,
            comment=self.comment,
            cves=self.cves,
            default_action=self.default_action,
            direction=self.direction,
            id=self.id,
            references=self.references,
            severity=self.severity,
            signature=self.signature,
            tfid=self.tfid,
            threat_id=self.threat_id,
            threatname=self.threatname,
            vendors=self.vendors)


def get_vulnerability_protection_signatures(id: Optional[_builtins.str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVulnerabilityProtectionSignaturesResult:
    """
    Retrieves a config item.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    example = scm.get_vulnerability_protection_signatures(id="1234-56-789")
    ```


    :param _builtins.str id: The Id param.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getVulnerabilityProtectionSignatures:getVulnerabilityProtectionSignatures', __args__, opts=opts, typ=GetVulnerabilityProtectionSignaturesResult).value

    return AwaitableGetVulnerabilityProtectionSignaturesResult(
        affected_host=pulumi.get(__ret__, 'affected_host'),
        bugtraqs=pulumi.get(__ret__, 'bugtraqs'),
        comment=pulumi.get(__ret__, 'comment'),
        cves=pulumi.get(__ret__, 'cves'),
        default_action=pulumi.get(__ret__, 'default_action'),
        direction=pulumi.get(__ret__, 'direction'),
        id=pulumi.get(__ret__, 'id'),
        references=pulumi.get(__ret__, 'references'),
        severity=pulumi.get(__ret__, 'severity'),
        signature=pulumi.get(__ret__, 'signature'),
        tfid=pulumi.get(__ret__, 'tfid'),
        threat_id=pulumi.get(__ret__, 'threat_id'),
        threatname=pulumi.get(__ret__, 'threatname'),
        vendors=pulumi.get(__ret__, 'vendors'))
def get_vulnerability_protection_signatures_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVulnerabilityProtectionSignaturesResult]:
    """
    Retrieves a config item.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    example = scm.get_vulnerability_protection_signatures(id="1234-56-789")
    ```


    :param _builtins.str id: The Id param.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getVulnerabilityProtectionSignatures:getVulnerabilityProtectionSignatures', __args__, opts=opts, typ=GetVulnerabilityProtectionSignaturesResult)
    return __ret__.apply(lambda __response__: GetVulnerabilityProtectionSignaturesResult(
        affected_host=pulumi.get(__response__, 'affected_host'),
        bugtraqs=pulumi.get(__response__, 'bugtraqs'),
        comment=pulumi.get(__response__, 'comment'),
        cves=pulumi.get(__response__, 'cves'),
        default_action=pulumi.get(__response__, 'default_action'),
        direction=pulumi.get(__response__, 'direction'),
        id=pulumi.get(__response__, 'id'),
        references=pulumi.get(__response__, 'references'),
        severity=pulumi.get(__response__, 'severity'),
        signature=pulumi.get(__response__, 'signature'),
        tfid=pulumi.get(__response__, 'tfid'),
        threat_id=pulumi.get(__response__, 'threat_id'),
        threatname=pulumi.get(__response__, 'threatname'),
        vendors=pulumi.get(__response__, 'vendors')))
