# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NatRuleArgs', 'NatRule']

@pulumi.input_type
class NatRuleArgs:
    def __init__(__self__, *,
                 destinations: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 froms: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 service: pulumi.Input[_builtins.str],
                 sources: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 tos: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 active_active_device_binding: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_translation: Optional[pulumi.Input['NatRuleDestinationTranslationArgs']] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dynamic_destination_translation: Optional[pulumi.Input['NatRuleDynamicDestinationTranslationArgs']] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 group_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_translation: Optional[pulumi.Input['NatRuleSourceTranslationArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target: Optional[pulumi.Input['NatRuleTargetArgs']] = None,
                 to_interface: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NatRule resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: The destination address(es).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: The source security zone(s).
        :param pulumi.Input[_builtins.str] service: The Service param.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: The source address(es).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: The destination security zone(s).
        :param pulumi.Input[_builtins.str] active_active_device_binding: The ActiveActiveDeviceBinding param. String must be one of these: `"primary"`, `"both"`, `"0"`, `"1"`.
        :param pulumi.Input[_builtins.str] description: The Description param.
        :param pulumi.Input['NatRuleDestinationTranslationArgs'] destination_translation: Static destination translation parameter.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        :param pulumi.Input[_builtins.bool] disabled: The Disabled param.
        :param pulumi.Input['NatRuleDynamicDestinationTranslationArgs'] dynamic_destination_translation: Dynamic destination translation parameter.
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        :param pulumi.Input[_builtins.str] group_tag: The GroupTag param.
        :param pulumi.Input[_builtins.str] name: The Name param.
        :param pulumi.Input[_builtins.str] nat_type: The NatType param. String must be one of these: `"ipv4"`, `"nat64"`, `"nptv6"`.
        :param pulumi.Input[_builtins.str] position: The Position param. String must be one of these: `"pre"`, `"post"`. Default: `"pre"`.
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        :param pulumi.Input['NatRuleSourceTranslationArgs'] source_translation: The SourceTranslation param.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The Tags param.
        :param pulumi.Input['NatRuleTargetArgs'] target: The Target param.
        :param pulumi.Input[_builtins.str] to_interface: The ToInterface param.
        """
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "froms", froms)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "tos", tos)
        if active_active_device_binding is not None:
            pulumi.set(__self__, "active_active_device_binding", active_active_device_binding)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_translation is not None:
            pulumi.set(__self__, "destination_translation", destination_translation)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if dynamic_destination_translation is not None:
            pulumi.set(__self__, "dynamic_destination_translation", dynamic_destination_translation)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if group_tag is not None:
            pulumi.set(__self__, "group_tag", group_tag)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_type is not None:
            pulumi.set(__self__, "nat_type", nat_type)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if source_translation is not None:
            pulumi.set(__self__, "source_translation", source_translation)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if to_interface is not None:
            pulumi.set(__self__, "to_interface", to_interface)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The destination address(es).
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter
    def froms(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The source security zone(s).
        """
        return pulumi.get(self, "froms")

    @froms.setter
    def froms(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "froms", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> pulumi.Input[_builtins.str]:
        """
        The Service param.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The source address(es).
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter
    def tos(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The destination security zone(s).
        """
        return pulumi.get(self, "tos")

    @tos.setter
    def tos(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "tos", value)

    @_builtins.property
    @pulumi.getter(name="activeActiveDeviceBinding")
    def active_active_device_binding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ActiveActiveDeviceBinding param. String must be one of these: `"primary"`, `"both"`, `"0"`, `"1"`.
        """
        return pulumi.get(self, "active_active_device_binding")

    @active_active_device_binding.setter
    def active_active_device_binding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "active_active_device_binding", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Description param.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationTranslation")
    def destination_translation(self) -> Optional[pulumi.Input['NatRuleDestinationTranslationArgs']]:
        """
        Static destination translation parameter.
        """
        return pulumi.get(self, "destination_translation")

    @destination_translation.setter
    def destination_translation(self, value: Optional[pulumi.Input['NatRuleDestinationTranslationArgs']]):
        pulumi.set(self, "destination_translation", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The Disabled param.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="dynamicDestinationTranslation")
    def dynamic_destination_translation(self) -> Optional[pulumi.Input['NatRuleDynamicDestinationTranslationArgs']]:
        """
        Dynamic destination translation parameter.
        """
        return pulumi.get(self, "dynamic_destination_translation")

    @dynamic_destination_translation.setter
    def dynamic_destination_translation(self, value: Optional[pulumi.Input['NatRuleDynamicDestinationTranslationArgs']]):
        pulumi.set(self, "dynamic_destination_translation", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="groupTag")
    def group_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GroupTag param.
        """
        return pulumi.get(self, "group_tag")

    @group_tag.setter
    def group_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_tag", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name param.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="natType")
    def nat_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The NatType param. String must be one of these: `"ipv4"`, `"nat64"`, `"nptv6"`.
        """
        return pulumi.get(self, "nat_type")

    @nat_type.setter
    def nat_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_type", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Position param. String must be one of these: `"pre"`, `"post"`. Default: `"pre"`.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="sourceTranslation")
    def source_translation(self) -> Optional[pulumi.Input['NatRuleSourceTranslationArgs']]:
        """
        The SourceTranslation param.
        """
        return pulumi.get(self, "source_translation")

    @source_translation.setter
    def source_translation(self, value: Optional[pulumi.Input['NatRuleSourceTranslationArgs']]):
        pulumi.set(self, "source_translation", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The Tags param.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['NatRuleTargetArgs']]:
        """
        The Target param.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['NatRuleTargetArgs']]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter(name="toInterface")
    def to_interface(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ToInterface param.
        """
        return pulumi.get(self, "to_interface")

    @to_interface.setter
    def to_interface(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "to_interface", value)


@pulumi.input_type
class _NatRuleState:
    def __init__(__self__, *,
                 active_active_device_binding: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_translation: Optional[pulumi.Input['NatRuleDestinationTranslationArgs']] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dynamic_destination_translation: Optional[pulumi.Input['NatRuleDynamicDestinationTranslationArgs']] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_translation: Optional[pulumi.Input['NatRuleSourceTranslationArgs']] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target: Optional[pulumi.Input['NatRuleTargetArgs']] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None,
                 to_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering NatRule resources.
        :param pulumi.Input[_builtins.str] active_active_device_binding: The ActiveActiveDeviceBinding param. String must be one of these: `"primary"`, `"both"`, `"0"`, `"1"`.
        :param pulumi.Input[_builtins.str] description: The Description param.
        :param pulumi.Input['NatRuleDestinationTranslationArgs'] destination_translation: Static destination translation parameter.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: The destination address(es).
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        :param pulumi.Input[_builtins.bool] disabled: The Disabled param.
        :param pulumi.Input['NatRuleDynamicDestinationTranslationArgs'] dynamic_destination_translation: Dynamic destination translation parameter.
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: The source security zone(s).
        :param pulumi.Input[_builtins.str] group_tag: The GroupTag param.
        :param pulumi.Input[_builtins.str] name: The Name param.
        :param pulumi.Input[_builtins.str] nat_type: The NatType param. String must be one of these: `"ipv4"`, `"nat64"`, `"nptv6"`.
        :param pulumi.Input[_builtins.str] position: The Position param. String must be one of these: `"pre"`, `"post"`. Default: `"pre"`.
        :param pulumi.Input[_builtins.str] service: The Service param.
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        :param pulumi.Input['NatRuleSourceTranslationArgs'] source_translation: The SourceTranslation param.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: The source address(es).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The Tags param.
        :param pulumi.Input['NatRuleTargetArgs'] target: The Target param.
        :param pulumi.Input[_builtins.str] to_interface: The ToInterface param.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: The destination security zone(s).
        """
        if active_active_device_binding is not None:
            pulumi.set(__self__, "active_active_device_binding", active_active_device_binding)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_translation is not None:
            pulumi.set(__self__, "destination_translation", destination_translation)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if dynamic_destination_translation is not None:
            pulumi.set(__self__, "dynamic_destination_translation", dynamic_destination_translation)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if froms is not None:
            pulumi.set(__self__, "froms", froms)
        if group_tag is not None:
            pulumi.set(__self__, "group_tag", group_tag)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_type is not None:
            pulumi.set(__self__, "nat_type", nat_type)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if source_translation is not None:
            pulumi.set(__self__, "source_translation", source_translation)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)
        if to_interface is not None:
            pulumi.set(__self__, "to_interface", to_interface)
        if tos is not None:
            pulumi.set(__self__, "tos", tos)

    @_builtins.property
    @pulumi.getter(name="activeActiveDeviceBinding")
    def active_active_device_binding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ActiveActiveDeviceBinding param. String must be one of these: `"primary"`, `"both"`, `"0"`, `"1"`.
        """
        return pulumi.get(self, "active_active_device_binding")

    @active_active_device_binding.setter
    def active_active_device_binding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "active_active_device_binding", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Description param.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationTranslation")
    def destination_translation(self) -> Optional[pulumi.Input['NatRuleDestinationTranslationArgs']]:
        """
        Static destination translation parameter.
        """
        return pulumi.get(self, "destination_translation")

    @destination_translation.setter
    def destination_translation(self, value: Optional[pulumi.Input['NatRuleDestinationTranslationArgs']]):
        pulumi.set(self, "destination_translation", value)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The destination address(es).
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The Disabled param.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="dynamicDestinationTranslation")
    def dynamic_destination_translation(self) -> Optional[pulumi.Input['NatRuleDynamicDestinationTranslationArgs']]:
        """
        Dynamic destination translation parameter.
        """
        return pulumi.get(self, "dynamic_destination_translation")

    @dynamic_destination_translation.setter
    def dynamic_destination_translation(self, value: Optional[pulumi.Input['NatRuleDynamicDestinationTranslationArgs']]):
        pulumi.set(self, "dynamic_destination_translation", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def froms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The source security zone(s).
        """
        return pulumi.get(self, "froms")

    @froms.setter
    def froms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "froms", value)

    @_builtins.property
    @pulumi.getter(name="groupTag")
    def group_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GroupTag param.
        """
        return pulumi.get(self, "group_tag")

    @group_tag.setter
    def group_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_tag", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name param.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="natType")
    def nat_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The NatType param. String must be one of these: `"ipv4"`, `"nat64"`, `"nptv6"`.
        """
        return pulumi.get(self, "nat_type")

    @nat_type.setter
    def nat_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_type", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Position param. String must be one of these: `"pre"`, `"post"`. Default: `"pre"`.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Service param.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="sourceTranslation")
    def source_translation(self) -> Optional[pulumi.Input['NatRuleSourceTranslationArgs']]:
        """
        The SourceTranslation param.
        """
        return pulumi.get(self, "source_translation")

    @source_translation.setter
    def source_translation(self, value: Optional[pulumi.Input['NatRuleSourceTranslationArgs']]):
        pulumi.set(self, "source_translation", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The source address(es).
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The Tags param.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['NatRuleTargetArgs']]:
        """
        The Target param.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['NatRuleTargetArgs']]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)

    @_builtins.property
    @pulumi.getter(name="toInterface")
    def to_interface(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ToInterface param.
        """
        return pulumi.get(self, "to_interface")

    @to_interface.setter
    def to_interface(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "to_interface", value)

    @_builtins.property
    @pulumi.getter
    def tos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The destination security zone(s).
        """
        return pulumi.get(self, "tos")

    @tos.setter
    def tos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tos", value)


@pulumi.type_token("scm:index/natRule:NatRule")
class NatRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_active_device_binding: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_translation: Optional[pulumi.Input[Union['NatRuleDestinationTranslationArgs', 'NatRuleDestinationTranslationArgsDict']]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dynamic_destination_translation: Optional[pulumi.Input[Union['NatRuleDynamicDestinationTranslationArgs', 'NatRuleDynamicDestinationTranslationArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_translation: Optional[pulumi.Input[Union['NatRuleSourceTranslationArgs', 'NatRuleSourceTranslationArgsDict']]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target: Optional[pulumi.Input[Union['NatRuleTargetArgs', 'NatRuleTargetArgsDict']]] = None,
                 to_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Retrieves a config item.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] active_active_device_binding: The ActiveActiveDeviceBinding param. String must be one of these: `"primary"`, `"both"`, `"0"`, `"1"`.
        :param pulumi.Input[_builtins.str] description: The Description param.
        :param pulumi.Input[Union['NatRuleDestinationTranslationArgs', 'NatRuleDestinationTranslationArgsDict']] destination_translation: Static destination translation parameter.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: The destination address(es).
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        :param pulumi.Input[_builtins.bool] disabled: The Disabled param.
        :param pulumi.Input[Union['NatRuleDynamicDestinationTranslationArgs', 'NatRuleDynamicDestinationTranslationArgsDict']] dynamic_destination_translation: Dynamic destination translation parameter.
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: The source security zone(s).
        :param pulumi.Input[_builtins.str] group_tag: The GroupTag param.
        :param pulumi.Input[_builtins.str] name: The Name param.
        :param pulumi.Input[_builtins.str] nat_type: The NatType param. String must be one of these: `"ipv4"`, `"nat64"`, `"nptv6"`.
        :param pulumi.Input[_builtins.str] position: The Position param. String must be one of these: `"pre"`, `"post"`. Default: `"pre"`.
        :param pulumi.Input[_builtins.str] service: The Service param.
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        :param pulumi.Input[Union['NatRuleSourceTranslationArgs', 'NatRuleSourceTranslationArgsDict']] source_translation: The SourceTranslation param.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: The source address(es).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The Tags param.
        :param pulumi.Input[Union['NatRuleTargetArgs', 'NatRuleTargetArgsDict']] target: The Target param.
        :param pulumi.Input[_builtins.str] to_interface: The ToInterface param.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: The destination security zone(s).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NatRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Retrieves a config item.

        :param str resource_name: The name of the resource.
        :param NatRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NatRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_active_device_binding: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_translation: Optional[pulumi.Input[Union['NatRuleDestinationTranslationArgs', 'NatRuleDestinationTranslationArgsDict']]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dynamic_destination_translation: Optional[pulumi.Input[Union['NatRuleDynamicDestinationTranslationArgs', 'NatRuleDynamicDestinationTranslationArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_translation: Optional[pulumi.Input[Union['NatRuleSourceTranslationArgs', 'NatRuleSourceTranslationArgsDict']]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target: Optional[pulumi.Input[Union['NatRuleTargetArgs', 'NatRuleTargetArgsDict']]] = None,
                 to_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NatRuleArgs.__new__(NatRuleArgs)

            __props__.__dict__["active_active_device_binding"] = active_active_device_binding
            __props__.__dict__["description"] = description
            __props__.__dict__["destination_translation"] = destination_translation
            if destinations is None and not opts.urn:
                raise TypeError("Missing required property 'destinations'")
            __props__.__dict__["destinations"] = destinations
            __props__.__dict__["device"] = device
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["dynamic_destination_translation"] = dynamic_destination_translation
            __props__.__dict__["folder"] = folder
            if froms is None and not opts.urn:
                raise TypeError("Missing required property 'froms'")
            __props__.__dict__["froms"] = froms
            __props__.__dict__["group_tag"] = group_tag
            __props__.__dict__["name"] = name
            __props__.__dict__["nat_type"] = nat_type
            __props__.__dict__["position"] = position
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["source_translation"] = source_translation
            if sources is None and not opts.urn:
                raise TypeError("Missing required property 'sources'")
            __props__.__dict__["sources"] = sources
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target"] = target
            __props__.__dict__["to_interface"] = to_interface
            if tos is None and not opts.urn:
                raise TypeError("Missing required property 'tos'")
            __props__.__dict__["tos"] = tos
            __props__.__dict__["tfid"] = None
        super(NatRule, __self__).__init__(
            'scm:index/natRule:NatRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_active_device_binding: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination_translation: Optional[pulumi.Input[Union['NatRuleDestinationTranslationArgs', 'NatRuleDestinationTranslationArgsDict']]] = None,
            destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            dynamic_destination_translation: Optional[pulumi.Input[Union['NatRuleDynamicDestinationTranslationArgs', 'NatRuleDynamicDestinationTranslationArgsDict']]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            group_tag: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nat_type: Optional[pulumi.Input[_builtins.str]] = None,
            position: Optional[pulumi.Input[_builtins.str]] = None,
            service: Optional[pulumi.Input[_builtins.str]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            source_translation: Optional[pulumi.Input[Union['NatRuleSourceTranslationArgs', 'NatRuleSourceTranslationArgsDict']]] = None,
            sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            target: Optional[pulumi.Input[Union['NatRuleTargetArgs', 'NatRuleTargetArgsDict']]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None,
            to_interface: Optional[pulumi.Input[_builtins.str]] = None,
            tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'NatRule':
        """
        Get an existing NatRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] active_active_device_binding: The ActiveActiveDeviceBinding param. String must be one of these: `"primary"`, `"both"`, `"0"`, `"1"`.
        :param pulumi.Input[_builtins.str] description: The Description param.
        :param pulumi.Input[Union['NatRuleDestinationTranslationArgs', 'NatRuleDestinationTranslationArgsDict']] destination_translation: Static destination translation parameter.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: The destination address(es).
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        :param pulumi.Input[_builtins.bool] disabled: The Disabled param.
        :param pulumi.Input[Union['NatRuleDynamicDestinationTranslationArgs', 'NatRuleDynamicDestinationTranslationArgsDict']] dynamic_destination_translation: Dynamic destination translation parameter.
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: The source security zone(s).
        :param pulumi.Input[_builtins.str] group_tag: The GroupTag param.
        :param pulumi.Input[_builtins.str] name: The Name param.
        :param pulumi.Input[_builtins.str] nat_type: The NatType param. String must be one of these: `"ipv4"`, `"nat64"`, `"nptv6"`.
        :param pulumi.Input[_builtins.str] position: The Position param. String must be one of these: `"pre"`, `"post"`. Default: `"pre"`.
        :param pulumi.Input[_builtins.str] service: The Service param.
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        :param pulumi.Input[Union['NatRuleSourceTranslationArgs', 'NatRuleSourceTranslationArgsDict']] source_translation: The SourceTranslation param.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: The source address(es).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The Tags param.
        :param pulumi.Input[Union['NatRuleTargetArgs', 'NatRuleTargetArgsDict']] target: The Target param.
        :param pulumi.Input[_builtins.str] to_interface: The ToInterface param.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: The destination security zone(s).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NatRuleState.__new__(_NatRuleState)

        __props__.__dict__["active_active_device_binding"] = active_active_device_binding
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_translation"] = destination_translation
        __props__.__dict__["destinations"] = destinations
        __props__.__dict__["device"] = device
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["dynamic_destination_translation"] = dynamic_destination_translation
        __props__.__dict__["folder"] = folder
        __props__.__dict__["froms"] = froms
        __props__.__dict__["group_tag"] = group_tag
        __props__.__dict__["name"] = name
        __props__.__dict__["nat_type"] = nat_type
        __props__.__dict__["position"] = position
        __props__.__dict__["service"] = service
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["source_translation"] = source_translation
        __props__.__dict__["sources"] = sources
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target"] = target
        __props__.__dict__["tfid"] = tfid
        __props__.__dict__["to_interface"] = to_interface
        __props__.__dict__["tos"] = tos
        return NatRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activeActiveDeviceBinding")
    def active_active_device_binding(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ActiveActiveDeviceBinding param. String must be one of these: `"primary"`, `"both"`, `"0"`, `"1"`.
        """
        return pulumi.get(self, "active_active_device_binding")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Description param.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationTranslation")
    def destination_translation(self) -> pulumi.Output[Optional['outputs.NatRuleDestinationTranslation']]:
        """
        Static destination translation parameter.
        """
        return pulumi.get(self, "destination_translation")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The destination address(es).
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The Disabled param.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="dynamicDestinationTranslation")
    def dynamic_destination_translation(self) -> pulumi.Output[Optional['outputs.NatRuleDynamicDestinationTranslation']]:
        """
        Dynamic destination translation parameter.
        """
        return pulumi.get(self, "dynamic_destination_translation")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def froms(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The source security zone(s).
        """
        return pulumi.get(self, "froms")

    @_builtins.property
    @pulumi.getter(name="groupTag")
    def group_tag(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The GroupTag param.
        """
        return pulumi.get(self, "group_tag")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name param.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="natType")
    def nat_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The NatType param. String must be one of these: `"ipv4"`, `"nat64"`, `"nptv6"`.
        """
        return pulumi.get(self, "nat_type")

    @_builtins.property
    @pulumi.getter
    def position(self) -> pulumi.Output[_builtins.str]:
        """
        The Position param. String must be one of these: `"pre"`, `"post"`. Default: `"pre"`.
        """
        return pulumi.get(self, "position")

    @_builtins.property
    @pulumi.getter
    def service(self) -> pulumi.Output[_builtins.str]:
        """
        The Service param.
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined. String length must not exceed 64 characters. String validation regex: `^[a-zA-Z\\d-_\\. ]+$`.
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter(name="sourceTranslation")
    def source_translation(self) -> pulumi.Output[Optional['outputs.NatRuleSourceTranslation']]:
        """
        The SourceTranslation param.
        """
        return pulumi.get(self, "source_translation")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The source address(es).
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The Tags param.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def target(self) -> pulumi.Output[Optional['outputs.NatRuleTarget']]:
        """
        The Target param.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="toInterface")
    def to_interface(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ToInterface param.
        """
        return pulumi.get(self, "to_interface")

    @_builtins.property
    @pulumi.getter
    def tos(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The destination security zone(s).
        """
        return pulumi.get(self, "tos")

