# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScepProfileArgs', 'ScepProfile']

@pulumi.input_type
class ScepProfileArgs:
    def __init__(__self__, *,
                 ca_identity_name: pulumi.Input[_builtins.str],
                 digest: pulumi.Input[_builtins.str],
                 scep_url: pulumi.Input[_builtins.str],
                 algorithm: Optional[pulumi.Input['ScepProfileAlgorithmArgs']] = None,
                 certificate_attributes: Optional[pulumi.Input['ScepProfileCertificateAttributesArgs']] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_challenge: Optional[pulumi.Input['ScepProfileScepChallengeArgs']] = None,
                 scep_client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 use_as_digital_signature: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_for_key_encipherment: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ScepProfile resource.
        :param pulumi.Input[_builtins.str] ca_identity_name: The CaIdentityName param.
        :param pulumi.Input[_builtins.str] digest: The Digest param.
        :param pulumi.Input[_builtins.str] scep_url: The ScepUrl param.
        :param pulumi.Input['ScepProfileAlgorithmArgs'] algorithm: The Algorithm param.
        :param pulumi.Input['ScepProfileCertificateAttributesArgs'] certificate_attributes: The CertificateAttributes param.
        :param pulumi.Input[_builtins.str] device: The Device param.
        :param pulumi.Input[_builtins.str] fingerprint: The Fingerprint param.
        :param pulumi.Input[_builtins.str] folder: The Folder param.
        :param pulumi.Input[_builtins.str] name: alphanumeric string [ 0-9a-zA-Z._-]. String length must not exceed 31 characters.
        :param pulumi.Input[_builtins.str] scep_ca_cert: The ScepCaCert param.
        :param pulumi.Input['ScepProfileScepChallengeArgs'] scep_challenge: The ScepChallenge param.
        :param pulumi.Input[_builtins.str] scep_client_cert: The ScepClientCert param.
        :param pulumi.Input[_builtins.str] snippet: The Snippet param.
        :param pulumi.Input[_builtins.str] subject: The Subject param.
        :param pulumi.Input[_builtins.bool] use_as_digital_signature: The UseAsDigitalSignature param.
        :param pulumi.Input[_builtins.bool] use_for_key_encipherment: The UseForKeyEncipherment param.
        """
        pulumi.set(__self__, "ca_identity_name", ca_identity_name)
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "scep_url", scep_url)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if certificate_attributes is not None:
            pulumi.set(__self__, "certificate_attributes", certificate_attributes)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scep_ca_cert is not None:
            pulumi.set(__self__, "scep_ca_cert", scep_ca_cert)
        if scep_challenge is not None:
            pulumi.set(__self__, "scep_challenge", scep_challenge)
        if scep_client_cert is not None:
            pulumi.set(__self__, "scep_client_cert", scep_client_cert)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if use_as_digital_signature is not None:
            pulumi.set(__self__, "use_as_digital_signature", use_as_digital_signature)
        if use_for_key_encipherment is not None:
            pulumi.set(__self__, "use_for_key_encipherment", use_for_key_encipherment)

    @_builtins.property
    @pulumi.getter(name="caIdentityName")
    def ca_identity_name(self) -> pulumi.Input[_builtins.str]:
        """
        The CaIdentityName param.
        """
        return pulumi.get(self, "ca_identity_name")

    @ca_identity_name.setter
    def ca_identity_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ca_identity_name", value)

    @_builtins.property
    @pulumi.getter
    def digest(self) -> pulumi.Input[_builtins.str]:
        """
        The Digest param.
        """
        return pulumi.get(self, "digest")

    @digest.setter
    def digest(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "digest", value)

    @_builtins.property
    @pulumi.getter(name="scepUrl")
    def scep_url(self) -> pulumi.Input[_builtins.str]:
        """
        The ScepUrl param.
        """
        return pulumi.get(self, "scep_url")

    @scep_url.setter
    def scep_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scep_url", value)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input['ScepProfileAlgorithmArgs']]:
        """
        The Algorithm param.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input['ScepProfileAlgorithmArgs']]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter(name="certificateAttributes")
    def certificate_attributes(self) -> Optional[pulumi.Input['ScepProfileCertificateAttributesArgs']]:
        """
        The CertificateAttributes param.
        """
        return pulumi.get(self, "certificate_attributes")

    @certificate_attributes.setter
    def certificate_attributes(self, value: Optional[pulumi.Input['ScepProfileCertificateAttributesArgs']]):
        pulumi.set(self, "certificate_attributes", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Device param.
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Fingerprint param.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Folder param.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        alphanumeric string [ 0-9a-zA-Z._-]. String length must not exceed 31 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="scepCaCert")
    def scep_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ScepCaCert param.
        """
        return pulumi.get(self, "scep_ca_cert")

    @scep_ca_cert.setter
    def scep_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scep_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="scepChallenge")
    def scep_challenge(self) -> Optional[pulumi.Input['ScepProfileScepChallengeArgs']]:
        """
        The ScepChallenge param.
        """
        return pulumi.get(self, "scep_challenge")

    @scep_challenge.setter
    def scep_challenge(self, value: Optional[pulumi.Input['ScepProfileScepChallengeArgs']]):
        pulumi.set(self, "scep_challenge", value)

    @_builtins.property
    @pulumi.getter(name="scepClientCert")
    def scep_client_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ScepClientCert param.
        """
        return pulumi.get(self, "scep_client_cert")

    @scep_client_cert.setter
    def scep_client_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scep_client_cert", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Snippet param.
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Subject param.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject", value)

    @_builtins.property
    @pulumi.getter(name="useAsDigitalSignature")
    def use_as_digital_signature(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The UseAsDigitalSignature param.
        """
        return pulumi.get(self, "use_as_digital_signature")

    @use_as_digital_signature.setter
    def use_as_digital_signature(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_as_digital_signature", value)

    @_builtins.property
    @pulumi.getter(name="useForKeyEncipherment")
    def use_for_key_encipherment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The UseForKeyEncipherment param.
        """
        return pulumi.get(self, "use_for_key_encipherment")

    @use_for_key_encipherment.setter
    def use_for_key_encipherment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_for_key_encipherment", value)


@pulumi.input_type
class _ScepProfileState:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input['ScepProfileAlgorithmArgs']] = None,
                 ca_identity_name: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_attributes: Optional[pulumi.Input['ScepProfileCertificateAttributesArgs']] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 digest: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypted_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_challenge: Optional[pulumi.Input['ScepProfileScepChallengeArgs']] = None,
                 scep_client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_url: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None,
                 use_as_digital_signature: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_for_key_encipherment: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ScepProfile resources.
        :param pulumi.Input['ScepProfileAlgorithmArgs'] algorithm: The Algorithm param.
        :param pulumi.Input[_builtins.str] ca_identity_name: The CaIdentityName param.
        :param pulumi.Input['ScepProfileCertificateAttributesArgs'] certificate_attributes: The CertificateAttributes param.
        :param pulumi.Input[_builtins.str] device: The Device param.
        :param pulumi.Input[_builtins.str] digest: The Digest param.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] encrypted_values: (Internal use) Encrypted values returned from the API.
        :param pulumi.Input[_builtins.str] fingerprint: The Fingerprint param.
        :param pulumi.Input[_builtins.str] folder: The Folder param.
        :param pulumi.Input[_builtins.str] name: alphanumeric string [ 0-9a-zA-Z._-]. String length must not exceed 31 characters.
        :param pulumi.Input[_builtins.str] scep_ca_cert: The ScepCaCert param.
        :param pulumi.Input['ScepProfileScepChallengeArgs'] scep_challenge: The ScepChallenge param.
        :param pulumi.Input[_builtins.str] scep_client_cert: The ScepClientCert param.
        :param pulumi.Input[_builtins.str] scep_url: The ScepUrl param.
        :param pulumi.Input[_builtins.str] snippet: The Snippet param.
        :param pulumi.Input[_builtins.str] subject: The Subject param.
        :param pulumi.Input[_builtins.bool] use_as_digital_signature: The UseAsDigitalSignature param.
        :param pulumi.Input[_builtins.bool] use_for_key_encipherment: The UseForKeyEncipherment param.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if ca_identity_name is not None:
            pulumi.set(__self__, "ca_identity_name", ca_identity_name)
        if certificate_attributes is not None:
            pulumi.set(__self__, "certificate_attributes", certificate_attributes)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if encrypted_values is not None:
            pulumi.set(__self__, "encrypted_values", encrypted_values)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scep_ca_cert is not None:
            pulumi.set(__self__, "scep_ca_cert", scep_ca_cert)
        if scep_challenge is not None:
            pulumi.set(__self__, "scep_challenge", scep_challenge)
        if scep_client_cert is not None:
            pulumi.set(__self__, "scep_client_cert", scep_client_cert)
        if scep_url is not None:
            pulumi.set(__self__, "scep_url", scep_url)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)
        if use_as_digital_signature is not None:
            pulumi.set(__self__, "use_as_digital_signature", use_as_digital_signature)
        if use_for_key_encipherment is not None:
            pulumi.set(__self__, "use_for_key_encipherment", use_for_key_encipherment)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input['ScepProfileAlgorithmArgs']]:
        """
        The Algorithm param.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input['ScepProfileAlgorithmArgs']]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter(name="caIdentityName")
    def ca_identity_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CaIdentityName param.
        """
        return pulumi.get(self, "ca_identity_name")

    @ca_identity_name.setter
    def ca_identity_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_identity_name", value)

    @_builtins.property
    @pulumi.getter(name="certificateAttributes")
    def certificate_attributes(self) -> Optional[pulumi.Input['ScepProfileCertificateAttributesArgs']]:
        """
        The CertificateAttributes param.
        """
        return pulumi.get(self, "certificate_attributes")

    @certificate_attributes.setter
    def certificate_attributes(self, value: Optional[pulumi.Input['ScepProfileCertificateAttributesArgs']]):
        pulumi.set(self, "certificate_attributes", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Device param.
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def digest(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Digest param.
        """
        return pulumi.get(self, "digest")

    @digest.setter
    def digest(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "digest", value)

    @_builtins.property
    @pulumi.getter(name="encryptedValues")
    def encrypted_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Internal use) Encrypted values returned from the API.
        """
        return pulumi.get(self, "encrypted_values")

    @encrypted_values.setter
    def encrypted_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "encrypted_values", value)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Fingerprint param.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Folder param.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        alphanumeric string [ 0-9a-zA-Z._-]. String length must not exceed 31 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="scepCaCert")
    def scep_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ScepCaCert param.
        """
        return pulumi.get(self, "scep_ca_cert")

    @scep_ca_cert.setter
    def scep_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scep_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="scepChallenge")
    def scep_challenge(self) -> Optional[pulumi.Input['ScepProfileScepChallengeArgs']]:
        """
        The ScepChallenge param.
        """
        return pulumi.get(self, "scep_challenge")

    @scep_challenge.setter
    def scep_challenge(self, value: Optional[pulumi.Input['ScepProfileScepChallengeArgs']]):
        pulumi.set(self, "scep_challenge", value)

    @_builtins.property
    @pulumi.getter(name="scepClientCert")
    def scep_client_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ScepClientCert param.
        """
        return pulumi.get(self, "scep_client_cert")

    @scep_client_cert.setter
    def scep_client_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scep_client_cert", value)

    @_builtins.property
    @pulumi.getter(name="scepUrl")
    def scep_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ScepUrl param.
        """
        return pulumi.get(self, "scep_url")

    @scep_url.setter
    def scep_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scep_url", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Snippet param.
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Subject param.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)

    @_builtins.property
    @pulumi.getter(name="useAsDigitalSignature")
    def use_as_digital_signature(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The UseAsDigitalSignature param.
        """
        return pulumi.get(self, "use_as_digital_signature")

    @use_as_digital_signature.setter
    def use_as_digital_signature(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_as_digital_signature", value)

    @_builtins.property
    @pulumi.getter(name="useForKeyEncipherment")
    def use_for_key_encipherment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The UseForKeyEncipherment param.
        """
        return pulumi.get(self, "use_for_key_encipherment")

    @use_for_key_encipherment.setter
    def use_for_key_encipherment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_for_key_encipherment", value)


@pulumi.type_token("scm:index/scepProfile:ScepProfile")
class ScepProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[Union['ScepProfileAlgorithmArgs', 'ScepProfileAlgorithmArgsDict']]] = None,
                 ca_identity_name: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_attributes: Optional[pulumi.Input[Union['ScepProfileCertificateAttributesArgs', 'ScepProfileCertificateAttributesArgsDict']]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 digest: Optional[pulumi.Input[_builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_challenge: Optional[pulumi.Input[Union['ScepProfileScepChallengeArgs', 'ScepProfileScepChallengeArgsDict']]] = None,
                 scep_client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_url: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 use_as_digital_signature: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_for_key_encipherment: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Retrieves a config item.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        example = scm.ScepProfile("example")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ScepProfileAlgorithmArgs', 'ScepProfileAlgorithmArgsDict']] algorithm: The Algorithm param.
        :param pulumi.Input[_builtins.str] ca_identity_name: The CaIdentityName param.
        :param pulumi.Input[Union['ScepProfileCertificateAttributesArgs', 'ScepProfileCertificateAttributesArgsDict']] certificate_attributes: The CertificateAttributes param.
        :param pulumi.Input[_builtins.str] device: The Device param.
        :param pulumi.Input[_builtins.str] digest: The Digest param.
        :param pulumi.Input[_builtins.str] fingerprint: The Fingerprint param.
        :param pulumi.Input[_builtins.str] folder: The Folder param.
        :param pulumi.Input[_builtins.str] name: alphanumeric string [ 0-9a-zA-Z._-]. String length must not exceed 31 characters.
        :param pulumi.Input[_builtins.str] scep_ca_cert: The ScepCaCert param.
        :param pulumi.Input[Union['ScepProfileScepChallengeArgs', 'ScepProfileScepChallengeArgsDict']] scep_challenge: The ScepChallenge param.
        :param pulumi.Input[_builtins.str] scep_client_cert: The ScepClientCert param.
        :param pulumi.Input[_builtins.str] scep_url: The ScepUrl param.
        :param pulumi.Input[_builtins.str] snippet: The Snippet param.
        :param pulumi.Input[_builtins.str] subject: The Subject param.
        :param pulumi.Input[_builtins.bool] use_as_digital_signature: The UseAsDigitalSignature param.
        :param pulumi.Input[_builtins.bool] use_for_key_encipherment: The UseForKeyEncipherment param.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScepProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Retrieves a config item.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        example = scm.ScepProfile("example")
        ```

        :param str resource_name: The name of the resource.
        :param ScepProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScepProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[Union['ScepProfileAlgorithmArgs', 'ScepProfileAlgorithmArgsDict']]] = None,
                 ca_identity_name: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_attributes: Optional[pulumi.Input[Union['ScepProfileCertificateAttributesArgs', 'ScepProfileCertificateAttributesArgsDict']]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 digest: Optional[pulumi.Input[_builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_challenge: Optional[pulumi.Input[Union['ScepProfileScepChallengeArgs', 'ScepProfileScepChallengeArgsDict']]] = None,
                 scep_client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_url: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 use_as_digital_signature: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_for_key_encipherment: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScepProfileArgs.__new__(ScepProfileArgs)

            __props__.__dict__["algorithm"] = algorithm
            if ca_identity_name is None and not opts.urn:
                raise TypeError("Missing required property 'ca_identity_name'")
            __props__.__dict__["ca_identity_name"] = ca_identity_name
            __props__.__dict__["certificate_attributes"] = certificate_attributes
            __props__.__dict__["device"] = device
            if digest is None and not opts.urn:
                raise TypeError("Missing required property 'digest'")
            __props__.__dict__["digest"] = digest
            __props__.__dict__["fingerprint"] = fingerprint
            __props__.__dict__["folder"] = folder
            __props__.__dict__["name"] = name
            __props__.__dict__["scep_ca_cert"] = scep_ca_cert
            __props__.__dict__["scep_challenge"] = scep_challenge
            __props__.__dict__["scep_client_cert"] = scep_client_cert
            if scep_url is None and not opts.urn:
                raise TypeError("Missing required property 'scep_url'")
            __props__.__dict__["scep_url"] = scep_url
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["subject"] = subject
            __props__.__dict__["use_as_digital_signature"] = use_as_digital_signature
            __props__.__dict__["use_for_key_encipherment"] = use_for_key_encipherment
            __props__.__dict__["encrypted_values"] = None
            __props__.__dict__["tfid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["encryptedValues"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ScepProfile, __self__).__init__(
            'scm:index/scepProfile:ScepProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            algorithm: Optional[pulumi.Input[Union['ScepProfileAlgorithmArgs', 'ScepProfileAlgorithmArgsDict']]] = None,
            ca_identity_name: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_attributes: Optional[pulumi.Input[Union['ScepProfileCertificateAttributesArgs', 'ScepProfileCertificateAttributesArgsDict']]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            digest: Optional[pulumi.Input[_builtins.str]] = None,
            encrypted_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            scep_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
            scep_challenge: Optional[pulumi.Input[Union['ScepProfileScepChallengeArgs', 'ScepProfileScepChallengeArgsDict']]] = None,
            scep_client_cert: Optional[pulumi.Input[_builtins.str]] = None,
            scep_url: Optional[pulumi.Input[_builtins.str]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            subject: Optional[pulumi.Input[_builtins.str]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None,
            use_as_digital_signature: Optional[pulumi.Input[_builtins.bool]] = None,
            use_for_key_encipherment: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ScepProfile':
        """
        Get an existing ScepProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ScepProfileAlgorithmArgs', 'ScepProfileAlgorithmArgsDict']] algorithm: The Algorithm param.
        :param pulumi.Input[_builtins.str] ca_identity_name: The CaIdentityName param.
        :param pulumi.Input[Union['ScepProfileCertificateAttributesArgs', 'ScepProfileCertificateAttributesArgsDict']] certificate_attributes: The CertificateAttributes param.
        :param pulumi.Input[_builtins.str] device: The Device param.
        :param pulumi.Input[_builtins.str] digest: The Digest param.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] encrypted_values: (Internal use) Encrypted values returned from the API.
        :param pulumi.Input[_builtins.str] fingerprint: The Fingerprint param.
        :param pulumi.Input[_builtins.str] folder: The Folder param.
        :param pulumi.Input[_builtins.str] name: alphanumeric string [ 0-9a-zA-Z._-]. String length must not exceed 31 characters.
        :param pulumi.Input[_builtins.str] scep_ca_cert: The ScepCaCert param.
        :param pulumi.Input[Union['ScepProfileScepChallengeArgs', 'ScepProfileScepChallengeArgsDict']] scep_challenge: The ScepChallenge param.
        :param pulumi.Input[_builtins.str] scep_client_cert: The ScepClientCert param.
        :param pulumi.Input[_builtins.str] scep_url: The ScepUrl param.
        :param pulumi.Input[_builtins.str] snippet: The Snippet param.
        :param pulumi.Input[_builtins.str] subject: The Subject param.
        :param pulumi.Input[_builtins.bool] use_as_digital_signature: The UseAsDigitalSignature param.
        :param pulumi.Input[_builtins.bool] use_for_key_encipherment: The UseForKeyEncipherment param.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScepProfileState.__new__(_ScepProfileState)

        __props__.__dict__["algorithm"] = algorithm
        __props__.__dict__["ca_identity_name"] = ca_identity_name
        __props__.__dict__["certificate_attributes"] = certificate_attributes
        __props__.__dict__["device"] = device
        __props__.__dict__["digest"] = digest
        __props__.__dict__["encrypted_values"] = encrypted_values
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["folder"] = folder
        __props__.__dict__["name"] = name
        __props__.__dict__["scep_ca_cert"] = scep_ca_cert
        __props__.__dict__["scep_challenge"] = scep_challenge
        __props__.__dict__["scep_client_cert"] = scep_client_cert
        __props__.__dict__["scep_url"] = scep_url
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["subject"] = subject
        __props__.__dict__["tfid"] = tfid
        __props__.__dict__["use_as_digital_signature"] = use_as_digital_signature
        __props__.__dict__["use_for_key_encipherment"] = use_for_key_encipherment
        return ScepProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Output[Optional['outputs.ScepProfileAlgorithm']]:
        """
        The Algorithm param.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter(name="caIdentityName")
    def ca_identity_name(self) -> pulumi.Output[_builtins.str]:
        """
        The CaIdentityName param.
        """
        return pulumi.get(self, "ca_identity_name")

    @_builtins.property
    @pulumi.getter(name="certificateAttributes")
    def certificate_attributes(self) -> pulumi.Output[Optional['outputs.ScepProfileCertificateAttributes']]:
        """
        The CertificateAttributes param.
        """
        return pulumi.get(self, "certificate_attributes")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Device param.
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def digest(self) -> pulumi.Output[_builtins.str]:
        """
        The Digest param.
        """
        return pulumi.get(self, "digest")

    @_builtins.property
    @pulumi.getter(name="encryptedValues")
    def encrypted_values(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Internal use) Encrypted values returned from the API.
        """
        return pulumi.get(self, "encrypted_values")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Fingerprint param.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Folder param.
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        alphanumeric string [ 0-9a-zA-Z._-]. String length must not exceed 31 characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="scepCaCert")
    def scep_ca_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ScepCaCert param.
        """
        return pulumi.get(self, "scep_ca_cert")

    @_builtins.property
    @pulumi.getter(name="scepChallenge")
    def scep_challenge(self) -> pulumi.Output[Optional['outputs.ScepProfileScepChallenge']]:
        """
        The ScepChallenge param.
        """
        return pulumi.get(self, "scep_challenge")

    @_builtins.property
    @pulumi.getter(name="scepClientCert")
    def scep_client_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ScepClientCert param.
        """
        return pulumi.get(self, "scep_client_cert")

    @_builtins.property
    @pulumi.getter(name="scepUrl")
    def scep_url(self) -> pulumi.Output[_builtins.str]:
        """
        The ScepUrl param.
        """
        return pulumi.get(self, "scep_url")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Snippet param.
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Subject param.
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="useAsDigitalSignature")
    def use_as_digital_signature(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The UseAsDigitalSignature param.
        """
        return pulumi.get(self, "use_as_digital_signature")

    @_builtins.property
    @pulumi.getter(name="useForKeyEncipherment")
    def use_for_key_encipherment(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The UseForKeyEncipherment param.
        """
        return pulumi.get(self, "use_for_key_encipherment")

