#include "../../../../../version.h"
#if (defined(RL_TOOLS_DISABLE_INCLUDE_GUARDS) || !defined(RL_TOOLS_RL_ENVIRONMENTS_L2F_PARAMETERS_DYNAMICS_FS_H)) && (RL_TOOLS_USE_THIS_VERSION == 1)
#pragma once
#define RL_TOOLS_RL_ENVIRONMENTS_L2F_PARAMETERS_DYNAMICS_FS_H
#include "../../multirotor.h"

RL_TOOLS_NAMESPACE_WRAPPER_START
namespace rl_tools::rl::environments::l2f::parameters::dynamics{
    namespace fs{
        template<typename T, typename TI>
        constexpr Dynamics<T, TI, 4> base = {
            // Rotor positions
//                array([[ 0.20895 , -0.240666,  0.      ],
//                [-0.20895 ,  0.240666,  0.      ],
//                [ 0.20895 ,  0.240666,  0.      ],
//                [-0.20895 , -0.240666,  0.      ]])
            {
                {
                    +0.20895,
                    -0.240666,
                    0
                },
                {
                    -0.20895,
                    +0.240666,
                    0
                },
                {
                    +0.20895,
                    +0.240666,
                    0
                },
                {
                    -0.20895,
                    -0.240666,
                    0
                },
            },
            // Rotor thrust directions
            {
                {0, 0, 1},
                {0, 0, 1},
                {0, 0, 1},
                {0, 0, 1},
            },
            // Rotor torque directions
            {
                {0, 0, -1},
                {0, 0, -1},
                {0, 0, +1},
                {0, 0, +1},
            },
            // thrust constants
            {
                {0.7846629595902934, 9.15540123440728, 18.005569363583604},
                {0.7846629595902934, 9.15540123440728, 18.005569363583604},
                {0.7846629595902934, 9.15540123440728, 18.005569363583604},
                {0.7846629595902934, 9.15540123440728, 18.005569363583604}
            },
            // torque constant
            {0.01492, 0.01492, 0.01492, 0.01492},
            // T, RPM time constant
            {0.06532, 0.06532, 0.06532, 0.06532},
            {0.06532, 0.06532, 0.06532, 0.06532},
            // mass vehicle
            3.35000,
            // gravity
            {0, 0, -9.81},
            // J
            {
                {
                    7.56e-2,
                    0.0000000000000000000000000000000000000000,
                    0.0000000000000000000000000000000000000000
                },
                {
                    0.0000000000000000000000000000000000000000,
                    7.296e-2,
                    0.0000000000000000000000000000000000000000
                },
                {
                    0.0000000000000000000000000000000000000000,
                    0.0000000000000000000000000000000000000000,
                    7.296e-2 * 1.879,
                }
            },
            // J_inv
            {
                {
                    13.227513227513228,
                    0.0000000000000000000000000000000000000000,
                    0.0000000000000000000000000000000000000000
                },
                {
                    0.0000000000000000000000000000000000000000,
                    13.706140350877194,
                    0.0000000000000000000000000000000000000000
                },
                {
                    0.0000000000000000000000000000000000000000,
                    0.0000000000000000000000000000000000000000,
                    7.294380176092173
                }
            },
            // hovering throttle (julia): sqrt((mass * 9.81/4 - thrust_curve[1])/thrust_curve[3]),
            0.44905530730868937,
            // action limit
            {0.0, 1.0}, // about [0.5thrust2weight, 2.5thrust2weight]
        };
    }
}
RL_TOOLS_NAMESPACE_WRAPPER_END
#endif
