# PySDM tutorials

PySDM tutorial notebooks are designed to introduce users to fundamental cloud microphysical processes.
Each tutorial includes introductory information about the relevant chemistry and physics, an interactive
  code example where the user can explore how simulation results depend on various parameter values.
Some of the notebooks feature sets of questions to assess comprehension.
Part of these notebooks were originally designed for an introductory cloud physics course for advanced 
  undergraduate and first-year graduate students, other was developed to support the Wikipedia entry on SDM.

### Collisions
A 0-D box model tutorial of the collision-coalescence process. Based on the [Shima et al. 2009]() example.
- [![View notebook](https://img.shields.io/static/v1?label=render%20on&logo=github&color=87ce3e&message=GitHub)](https://github.com/open-atmos/PySDM/tree/main/tutorials/collisions/collisions_playground.ipynb)
  [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/open-atmos/PySDM.git/main?urlpath=lab/tree/tutorials/collisions/collisions_playground.ipynb)
  [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/open-atmos/PySDM/blob/main/tutorials/collisions/collisions_playground.ipynb)

### Condensation
A 0-D adiabatic parcel tutorial of the condensation and aerosol activation process. Based on the [Pyrcel]() example.
- [![View notebook](https://img.shields.io/static/v1?label=render%20on&logo=github&color=87ce3e&message=GitHub)](https://github.com/open-atmos/PySDM/tree/main/tutorials/condensation/condensation_playground.ipynb)
  [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/open-atmos/PySDM.git/main?urlpath=lab/tree/tutorials/condensation/condensation_playground.ipynb)
  [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/open-atmos/PySDM/blob/main/tutorials/condensation/condensation_playground.ipynb)

### SDM algorithm
A pseuodocode-like implementation of the SDM algorithm (independent of PySDM) with a basic
simulation setup featuring additive coagulation kernel and exponential initial condition for which
the [Golovin's analytical solution](http://mi.mathnet.ru/dan27630)
is available and plotted along with SDM results.
- [![View notebook](https://img.shields.io/static/v1?label=render%20on&logo=github&color=87ce3e&message=GitHub)](https://github.com/open-atmos/PySDM/tree/main/tutorials/wikipedia/sdm.ipynb)
  [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/open-atmos/PySDM.git/main?urlpath=lab/tree/tutorials/wikipedia/sdm.ipynb)
  [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/open-atmos/PySDM/blob/main/tutorials/wikipedia/sdm.ipynb)
