"""
Download Media Example - BeastX
================================

Download all media from a channel.

Usage:
    python download_media.py
"""

from beastx import TelegramClient
import os

api_id = 12345
api_hash = 'your_api_hash_here'

client = TelegramClient('session', api_id, api_hash)


async def download_channel_media(channel, limit=10):
    """Download media from a channel"""
    
    # Create download directory
    os.makedirs('downloads', exist_ok=True)
    
    count = 0
    async for message in client.iter_messages(channel, limit=limit):
        if message.media:
            print(f'Downloading media {count + 1}...')
            path = await message.download_media(file='downloads/')
            print(f'  Saved: {path}')
            count += 1
    
    print(f'\nDownloaded {count} files!')


async def download_with_progress(channel):
    """Download with progress callback"""
    
    def progress(current, total):
        percent = (current / total) * 100
        print(f'  Progress: {percent:.1f}%', end='\r')
    
    async for message in client.iter_messages(channel, limit=5):
        if message.media:
            print(f'Downloading {message.file.name}...')
            await message.download_media(
                file='downloads/',
                progress_callback=progress
            )
            print()  # New line after progress


async def main():
    await client.start()
    
    # Download from channel
    await download_channel_media('channel_username', limit=10)
    
    # Download with progress
    # await download_with_progress('channel_username')


with client:
    client.loop.run_until_completed(main())
