def flatten(t):
    return [item for sublist in t for item in sublist]


portions = {
    "chicken": [
        r"wings?",
        r"giblets?",
        r"necks?",
        r"thighs?",
        r"legs?",
        r"drumsticks?",
        r"breasts?",
        r"back",
        r"drumm?ettes?",
        r"fillets?",
        r"feet",
        r"hindquarters?",
        r"rumps?",
        r"gizzards?",
        r"tenders?",
        r"nuggets?",
        r"quarters?",
        r"hal(?:f|ves)",
        r"meat",
        r"pieces?",
        r"cutlet",
        r"parts?",
        r"strips?",
        r"portions?",
        r"skin",
        r"carcass",
        r"chunks?",
        r"mince",
        r"hearts?",
        r"escalope",
        r"supreme",
        r"crowns?",
    ],
    "fish": [
        r"fillets?",
        r"steaks?",
        r"fins?",
        r"fish",
        r"cake",
        r"pie",
        r"tail",
        # these are cheap, think bout it
        r"trimmings?",
        r"sticks?",
        r"fingers?",
        r"meat",
        r"cheeks?",
        r"loin",
        r"head",
        r"balls?",
        r"carcass",
        r"medallions?",
        r"scampi",
    ],
    "pork": [
        r"trotters?",
        r"shanks?",
        r"legs?",
        r"hogs?",
        r"loins?",
        r"bell(?:y|ies)",
        r"fillets?",
        r"shoulders?",
        r"necks?",
        r"heads?",
        r"spare[- ]?ribs?",
        r"ribs?",
        r"meat",
        r"butt",
        r"chop",
        r"mince",
        r"hock",
        r"rind",
        r"cheek",
        r"skin",
        r"escalope",
        r"medallions?",
        r"rack",
        r"fatback",
        r"kidney",
        r"schnitzel",
        r"breast",
        r"brisket",
        r"cutlets?",
        r"round",
    ],
    "beef": [
        r"shin",
        r"silver[- ]?side",
        r"kidneys?",
        r"top[- ]?side",
        r"short[- ]?rib",
        r"prime[- ]?rib",
        r"t[- ]?bone",
        r"fillet",
        r"rump",
        r"flank",
        r"steak",
        r"hump",
        r"neck",
        r"bolo",
        r"wing[- ]?rib",
        r"chuck",
        r"brisket",
        r"round",
        r"meat",
        r"roast",
        r"mince",
        r"oxtail",
        r"shoulder",
        r"heart",
        r"sirloin",
        r"jerky",
        r"tongue",
        r"ribs?",
        r"chunks?",
        r"shanks?",
        r"medallions?",
        r"rump",
        r"chops?",
    ],
    "lamb": [
        r"neck",
        r"shoulder",
        r"chop",
        r"rack",
        r"loin",
        r"leg",
        r"shanks?",
        r"meat",
        r"mince",
        r"kidney",
        r"rump",
        r"fillet",
        r"cutlet",
        r"belly",
        r"rib",
        r"breast",
        r"shoulder joints?",
        r"breast joints?",
        r"rump joints?" r"rib chops?",
        r"leg chops?",
        r"double blade chops?",
        r"shoulder blade chops?",
        r"shoulder chops?",
        r"blade chops?",
        r"chump chops?",
        r"neck chops?",
        r"neck fillets?",
        r"meatballs?",
        r"double cutlets?",
        r"fore shanks?",
        r"breast ribs?",
    ],
    "sausage": [
        r"links?",
        r"rings?",
        r"casings?",
        r"meat",
        r"patty",
    ],
    "general": [
        "mince",
        "meat",
        "chunk",
        "slice",
        "portion",
        "escalope",
        "medallion",
        "paste",
        "mincemeat",
        "shin",
        "cutlet",
        "chop",
        "patty",
        "joint",
    ],
}
portions["all"] = flatten(list(portions.values()))
portions["any"] = [""]
portions["none"] = [r"$"]

dictionary = {
    "liver": [r"\blivers?\b"],
    "sausage": [
        r"sausage(?:s|meat)?",
        r"chorizos?",
        r"kielbasas?",
        r"bratwursts?",
        r"longaniza",
        r"sai[- ]?ua",
        r"sai kok",
        r"longganisas?",
        r"chipolatas?",
        r"boudins?",
        r"bangers?",
        r"salpicao",
        r"salchichas?",
        r"salchichons?",
        r"black[- ]?pudding",
        r"white[- ]?pudding",
        r"morcilla",
        r"salami$",
        r"pepperoni$",
    ],
    "poultry": [r"chicken", "turkey", "rabbit", "hen"],
    "lamb": ["lamb", "mutton", "goat"],
    "game bird": [
        "pigeon",
        "pheasant",
        "quail",
        "duck",
        "goose",
        "partridge",
        "guinea fowl",
        "crane",
        "grouse",
        "woodcock",
    ],
    "game": [
        "venison",
        "deer",
        r"boar",
        r"game",
        r"bear",
        r"kangaroo",
        r"elk",
        r"moose",
        r"reindeer",
    ],
    "pork": ["pork", "veal", r"meatballs?"],
    "tuna": [r"tuna"],
    "salmon": [r"\bsalmon\b"],
    "fatty fish": [
        "herring",
        "eel",
        "trout",
        "arctic char",
        "butterfish",
        "mackerel",
        r"^anchov(?:y|ies)$",
        "sardine",
        "swordfish",
        "shark",
        r"monk[- ]?fish",
        "bluefish",
        "wahoo",
        r"(?<!greenland )turbot",
    ],
    "lean fish": [
        "carp",
        "bonita",
        "bass",
        "squeteague",
        "catfish",
        "flounder",
        "cod",
        "skrei",
        "hake",
        "hoki",
        "sole",
        "snapper",
        "perch",
        "haddock",
        "halibut",
        r"greenland turbot",
        "pike",
        "tilapia",
        "swai",
        "whitefish",
        r"mahi[ -]?mahi",
        "greenland turbot",
        "barramundi",
        "char",
        "trout",
        "pollock",
        "cobia",
        "croaker",
        "mullet",
        "rockfish",
        "whiting",
        "saury",
        "plaice",
        "grenadier",
        "kingklip",
        "sanddab",
        "sandperch",
    ],
    "octopus": ["octopus", "squid", "calamari", r"cuttle[- ]?fish"],
    "crustacean": [
        "lobster",
        r"cra[wy][- ]?fish",
        "prawn",
        "shrimp",
        r"cra[wy][- ]?daddy",
        "krill",
        "crab",
        r"lobsterette?",
        r"langoustine",
        r"shell[- ]?fish",
    ],
    "other seafood": [
        r"clams?",
        r"mussels?",
        r"scallops?",
        r"oysters?",
        r"cockles?",
        r"snails?",
        r"escargots?",
        r"caviar",
        r"\broe\b",
        r"barnacles?",
    ],
    "ham": [
        r"mortadella",
        r"\bham$",
        r"pancetta(?: (?:di )?cubetti)?",
        "prosciutto",
        r"jamon(?: iberico)?",
        "jambon",
        "capicola",
        "culatello",
        "gammon",
        "serrano",
        "bresaola",
        "lomo",
    ],
    "beef": [
        "new york strip",
        "cow",
        "entrec[oô]te",
        r"fill?et mignon",
        "loin",
        "tenderloin",
        "sirloin",
        r"beef[^s]",
        "wagyu",
        r"rib[ \-]eye",
        r"beef$",
        "steak",
        "ground meat",
        "mincemeat",
        "stew meat",
        "minced meat",
        "meat",
        r"roast$",
        r"^chuck$",
        r"hamburger$",
    ],
    "bacon": [
        r"bacon bits?",
        r"bacon$",
        r"lardons?",
        r"rashers?",
        r"speck",
        r"guanciale",
        r"szalonna",
        r"lap yuk",
    ],
}

type_portions = {
    "poultry": "chicken",
    "lamb": "lamb",
    "game bird": "chicken",
    "game": "beef",
    "pork": "pork",
    "tuna": "fish",
    "salmon": "fish",
    "fatty fish": "fish",
    "lean fish": "fish",
    "beef": "beef",
    "crustacean": "fish",
    "sausage": "sausage",
    "bacon": "any",
    "ham": "any",
}

exceptions = [
    "stock",
    "juice",
    "bouillon",
]
