regions = [
    {
        "country": "DZ",
        "name": "Algiers",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 200),
        "soil_types": "clay",
        "primary_grapes": ["Grenache", "Syrah", "Cabernet Sauvignon", "Merlot"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the Mediterranean coast, Algiers boasts a vibrant tapestry of vineyards where the sun-kissed Grenache and bold Syrah thrive in clay soils, producing wines that are as rich in flavor as they are in history. Whether you're sipping a velvety red or a refreshing rosé, each glass tells the story of this enchanting region's unique terroir.",
        },
    },
    {
        "country": "DZ",
        "name": "Béjaïa",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 500),
        "soil_types": "clay",
        "primary_grapes": [
            "Cabernet Sauvignon",
            "Merlot",
            "Chardonnay",
            "Sauvignon Blanc",
        ],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the stunning Algerian coast, Béjaïa is a vibrant wine region where the robust Cabernet Sauvignon and Merlot meet the crisp elegance of Chardonnay and Sauvignon Blanc, all flourishing in its clay-rich soils. With a delightful array of red, white, and rosé wines, this region invites you to explore its unique terroir and savor the essence of its Mediterranean charm.",
        },
    },
    {
        "country": "DZ",
        "name": "Chlef Province",
        "subregions": [{"name": "Dahra"}],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Algeria, Chlef Province boasts a Mediterranean climate that nurtures a burgeoning wine scene, promising a delightful exploration of local grape varieties that capture the essence of this vibrant region. With its rich history and potential for unique wine styles, Chlef is a hidden gem waiting to be discovered by adventurous wine lovers.",
        },
    },
    {
        "country": "DZ",
        "name": "Mascara",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Algeria, the Mascara region is a hidden gem waiting to be discovered, where the mystery of its soil and the promise of its grape varieties hint at a vibrant future in winemaking. With an air of intrigue, this area invites adventurous palates to explore its untapped potential and unique character.",
        },
    },
    {
        "country": "DZ",
        "name": "Médéa",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 400.0,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": ["Cabernet Sauvignon", "Merlot", "Chardonnay", "Syrah"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Algeria, Médéa is a burgeoning wine region where the sun-drenched vineyards yield robust reds and crisp whites, with Cabernet Sauvignon and Chardonnay leading the charge. With a climate that dances between warmth and refreshing breezes, Médéa is a hidden gem for wine lovers seeking to explore the rich tapestry of Algerian viticulture.",
        },
    },
    {
        "country": "DZ",
        "name": "Tlemcen",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Algeria, Tlemcen is a hidden gem waiting to be uncovered, where the mystery of its soil and the potential of its grape varieties promise a delightful journey for the palate. With a rich history and a vibrant culture, this region invites adventurous wine lovers to explore its untapped potential.",
        },
    },
    {
        "country": "DZ",
        "name": "Zaccar",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Zaccar is a mysterious wine region waiting to unveil its secrets, with an enigmatic soil type and an undefined array of grape varieties. As it stands on the cusp of discovery, this region promises a thrilling adventure for wine enthusiasts eager to taste the unknown.",
        },
    },
    {
        "country": "CV",
        "name": "Chã das Caldeiras",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": (1000, 2000),
        "soil_types": "volcanic",
        "primary_grapes": ["Grapes of Cape Verde"],
        "wine_styles": ["red", "white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Chã das Caldeiras is a volcanic paradise in Cape Verde, where the high-altitude vineyards yield expressive wines that reflect the island's rugged beauty. With its unique grape varieties thriving in rich volcanic soils, this region offers a delightful exploration of both red and white styles that are as captivating as the landscape itself.",
        },
    },
    {
        "country": "MA",
        "name": "Atlas Mountains",
        "climate_types": "alpine",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (1000, 4000),
        "soil_types": "clay",
        "primary_grapes": ["Grenache", "Syrah", "Cabernet Sauvignon", "Merlot"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the majestic Atlas Mountains, this region boasts a stunning elevation that enhances the complexity of its wines, featuring bold reds and vibrant whites crafted from Grenache, Syrah, and more. With clay soils and a climate that dances between warmth and coolness, the wines here are as diverse and captivating as the landscape itself.",
        },
    },
    {
        "country": "MA",
        "name": "Benslimane",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Morocco, Benslimane is an emerging wine region that promises to surprise with its untapped potential. While the specifics of its soil and grape varieties remain a mystery, the region's unique climate hints at the possibility of crafting wines that are both intriguing and flavorful, waiting to be discovered by adventurous palates.",
        },
    },
    {
        "country": "MA",
        "name": "Meknès",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 300.0,
        "elevation_range": (400, 800),
        "soil_types": "clay",
        "primary_grapes": ["Cabernet Sauvignon", "Merlot", "Syrah", "Chenin Blanc"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Morocco, Meknès is a hidden gem where the sun-drenched vineyards yield exquisite wines, from the deep, rich reds of Cabernet Sauvignon to the crisp, lively whites of Chenin Blanc. With its unique clay soils and a climate that dances between warmth and cool elevation, this region is a delightful playground for wine lovers seeking both tradition and innovation.",
        },
    },
    {
        "country": "ZA",
        "name": "Western Cape",
        "subregions": [
            {"name": "Breede River Valley"},
            {"name": "Cape South Coast"},
            {"name": "Olifants River"},
        ],
        "description": {
            "default": "",
            "sommelier": "The Western Cape is a treasure trove of South African wine, where the sun-kissed vineyards yield everything from crisp Chenin Blanc to bold Shiraz and the uniquely local Pinotage. This region's diverse terroir and climate create a playground for winemakers, resulting in an exciting array of red, white, and sparkling wines that capture the essence of the Cape.",
            "julie": "The vineyards of South Africa are mostly located in the Western Cape, near the coast. Rainfall on the coastal side measures up to 1000 mm per year, making it possible for vine to thrive. There are five regions in the geographical unit of the Western Cape – Breede River Valley, Cape South Coast, Coastal Region, Klein Karoo and Olifants River. ",
        },
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 1000.0,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": ["Chenin Blanc", "Pinotage", "Shiraz"],
        "wine_styles": ["red", "white", "sparkling"],
    },
    {
        "country": "ZA",
        "name": "Little Karoo",
        "synonyms": ["Klein Karoo"],
        "subregions": [{"name": "Calitzdorp"}, {"name": "Langeberg-Garcia"}],
        "climate_types": "semi_desert",
        "avg_annual_rainfall": 300.0,
        "elevation_range": (300, 1200),
        "soil_types": "sandy_loam",
        "primary_grapes": ["Muscat", "Shiraz", "Grenache", "Tinta Barocca"],
        "wine_styles": ["red", "white", "fortified", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of South Africa, the Little Karoo is a sun-drenched paradise where sandy loam soils nurture vibrant Muscat and bold Shiraz, resulting in an eclectic mix of red, white, and fortified wines that tantalize the palate. With its dramatic landscapes and rich heritage, this region invites you to explore its diverse offerings, from refreshing whites to indulgent dessert wines.",
        },
    },
    {
        "country": "ZA",
        "name": "Coastal Region",
        "subregions": [
            {"name": "Swartland"},
            {"name": "Tulbagh"},
            {"name": "Constantia"},
            {"name": "Stellenbosch"},
            {"name": "Paarl"},
            {"name": "Darling"},
            {"name": "Cape Point"},
            {"name": "Wellington"},
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 650.0,
        "elevation_range": (0, 800),
        "soil_types": "clay",
        "primary_grapes": [
            "Chenin Blanc",
            "Cabernet Sauvignon",
            "Pinot Noir",
            "Shiraz",
            "Merlot",
        ],
        "wine_styles": ["red", "white", "sparkling", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the coast, this region boasts a delightful blend of clay soils and a temperate climate, perfect for crafting everything from luscious reds to refreshing whites and sparkling wines. With a rich tapestry of grape varieties like Chenin Blanc and Cabernet Sauvignon, the Coastal Region is a treasure trove for wine lovers seeking both diversity and quality in every sip.",
        },
    },
    {
        "country": "ZA",
        "name": "Durbanville",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 300),
        "soil_types": "clay",
        "primary_grapes": ["Sauvignon Blanc", "Shiraz"],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled just outside Cape Town, Durbanville is a hidden gem where the crisp, zesty notes of Sauvignon Blanc dance alongside the rich, spicy character of Shiraz, all nurtured by the region's clay soils and gentle rainfall. This picturesque area not only produces exceptional wines but also offers a delightful escape for wine lovers seeking both quality and charm.",
        },
    },
    {
        "country": "ZA",
        "name": "Elim",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "sandy",
        "primary_grapes": ["Chenin Blanc", "Shiraz"],
        "wine_styles": ["red", "white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of South Africa, Elim is a sandy-soiled gem where the crisp Chenin Blanc dances with tropical notes, while the bold Shiraz offers a rich tapestry of dark fruit and spice. This region is a delightful playground for wine lovers seeking both refreshing whites and robust reds, all with a touch of coastal charm.",
        },
    },
    {
        "country": "ZA",
        "name": "Franschhoek",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 500),
        "soil_types": "sandy",
        "primary_grapes": ["Cabernet Sauvignon", "Merlot", "Chardonnay"],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Franschhoek is a picturesque gem in South Africa, where the sun-kissed vineyards thrive in sandy soils, producing exquisite reds and whites that reflect the region's rich heritage and vibrant terroir. With its stunning mountain backdrop and a delightful blend of Cabernet Sauvignon, Merlot, and Chardonnay, this region is a must-visit for any wine enthusiast seeking both quality and charm.",
        },
    },
    {
        "country": "ZA",
        "name": "Orange River Valley",
        "climate_types": "semi_desert",
        "avg_annual_rainfall": 300.0,
        "elevation_range": (100, 500),
        "soil_types": "sandy",
        "primary_grapes": ["Chenin Blanc", "Shiraz"],
        "wine_styles": ["red", "white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of South Africa, the Orange River Valley is a sun-drenched paradise where sandy soils nurture luscious Chenin Blanc and robust Shiraz, producing wines that burst with character and charm. With its unique climate and diverse wine styles, this region is a hidden gem waiting to be explored by wine enthusiasts.",
        },
    },
    {
        "country": "ZA",
        "name": "Cederberg",
        "climate_types": "cool_climate",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (800, 2000),
        "soil_types": "granite",
        "primary_grapes": ["Chenin Blanc", "Shiraz", "Cabernet Sauvignon", "Merlot"],
        "wine_styles": [
            "red",
            "white",
            "medium_bodied",
            "full_bodied",
            "oaked",
            "unoaked",
        ],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the breathtaking Cederberg mountains, this region is a treasure trove of wine diversity, where granite soils and high altitudes give birth to exquisite Chenin Blancs and bold Shiraz. With a climate that dances between refreshing breezes and warm sunshine, Cederberg wines are a delightful exploration of both elegance and power.",
        },
    },
    {
        "country": "ZA",
        "name": "Piekenierskloof",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (300, 800),
        "soil_types": "sandy_loam",
        "primary_grapes": ["Chenin Blanc", "Shiraz"],
        "wine_styles": ["red", "white", "blend"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled between the mountains, Piekenierskloof is a vibrant tapestry of sandy loam and sun-kissed vineyards, where the crisp Chenin Blanc dances alongside bold Shiraz, crafting wines that are as expressive as the landscape itself. This region is a delightful discovery for those seeking both refreshing whites and robust reds, all with a touch of South African charm.",
        },
    },
    {
        "country": "TN",
        "name": "Arianah",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "clay",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Arianah, the clay soils nurture grapes that flourish under the sun, resulting in wines that are both bold and expressive. This region promises a delightful exploration of flavors, perfect for those seeking to uncover hidden gems in the world of wine.",
        },
    },
    {
        "country": "TN",
        "name": "Nabul",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (0, 200),
        "soil_types": "clay",
        "primary_grapes": ["Cinsault", "Syrah", "Grenache", "Carignan", "Chardonnay"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Tunisia, Nabul is a vibrant wine region where the sun-kissed clay soils nurture a delightful array of grape varieties, producing everything from luscious reds to crisp whites and effervescent sparkling wines. With its unique terroir and a rich winemaking tradition, Nabul invites you to explore its diverse and flavorful offerings.",
        },
    },
    {
        "country": "TN",
        "name": "Sousse",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 400.0,
        "elevation_range": (0, 100),
        "soil_types": "sandy",
        "primary_grapes": ["Grenache", "Syrah", "Cinsault"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the coast, Sousse boasts a sun-kissed landscape where sandy soils nurture bold Grenache and Syrah, resulting in wines that are as vibrant as the region's culture. Whether you're sipping a luscious red or a refreshing rosé, each glass tells the story of this enchanting Mediterranean locale.",
        },
    },
    {
        "country": "AR",
        "name": "Buenos Aires Province",
        "subregions": [{"name": "Médanos"}],
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of Argentina, Buenos Aires Province is a hidden gem for Malbec lovers, where high-altitude vineyards yield luscious, full-bodied reds that are both bold and elegant. The region's wines are a delightful expression of the grape's character, often enhanced by oak aging, making each sip a journey through the vibrant landscapes of this captivating province.",
            "julie": "Argentina is the world’s fifth largest wine producer in the world with just under 200,000 hectares of vines and the tenth largest wine exporter. The country’s vineyards are mostly confined to the western sector of the country, in the plains and foothills near the Andes. In the rain shadow of the Andes, Argentina’s wine producing regions are very dry, a condition exacerbated by the Zonda, a fierce, dusty, hot afternoon wind that blows down from the mountains in the late spring and early summer. The general lack of humidity in most Argentinean winegrowing regions keeps vineyards free of fungal problems, and snowmelt provides plentiful water for irrigation—in those years that the Andes receive heavy winter snowfall. Vineyards are planted at high altitude to help mitigate the semi-deserted climate that prevail in most of the country. In fact, the average national elevation for vineyards is approximately 900 meters above sea level and can reach over 3000 meters in the norther region of Salta. Mendoza is the biggest centre of production, representing over 70% of the country’s wine production. Malbec is by far the most planted grape in the country representing nearly 25% of the total grapevine plantings. ",
        },
        "climate_types": "semi_desert",
        "avg_annual_rainfall": None,
        "elevation_range": (900, 3000),
        "soil_types": "uknown",
        "primary_grapes": ["Malbec"],
        "wine_styles": ["red", "full_bodied", "oaked", "varietal"],
    },
    {
        "country": "AR",
        "name": "Catamarca Province",
        "synonyms": ["Catamarca"],
        "description": {
            "default": "",
            "sommelier": "In the breathtaking heights of Catamarca Province, where the Andes kiss the sky, Malbec reigns supreme, offering a delightful spectrum of wines from rich reds to refreshing whites. This region's altitude and varied styles promise a captivating experience for any wine lover, whether you're seeking a bold reserve or a crisp sparkling delight.",
            "julie": "Argentina is the world’s fifth largest wine producer in the world with just under 200,000 hectares of vines and the tenth largest wine exporter. The country’s vineyards are mostly confined to the western sector of the country, in the plains and foothills near the Andes. In the rain shadow of the Andes, Argentina’s wine producing regions are very dry, a condition exacerbated by the Zonda, a fierce, dusty, hot afternoon wind that blows down from the mountains in the late spring and early summer. The general lack of humidity in most Argentinean winegrowing regions keeps vineyards free of fungal problems, and snowmelt provides plentiful water for irrigation—in those years that the Andes receive heavy winter snowfall. Vineyards are planted at high altitude to help mitigate the semi-deserted climate that prevail in most of the country. In fact, the average national elevation for vineyards is approximately 900 meters above sea level and can reach over 3000 meters in the norther region of Salta. Mendoza is the biggest centre of production, representing over 70% of the country’s wine production. Malbec is by far the most planted grape in the country representing nearly 25% of the total grapevine plantings. ",
        },
        "climate_types": "semi_desert",
        "avg_annual_rainfall": None,
        "elevation_range": (900, 3000),
        "soil_types": "uknown",
        "primary_grapes": ["Malbec"],
        "wine_styles": [
            "red",
            "white",
            "rose",
            "sparkling",
            "dessert",
            "fortified",
            "medium_bodied",
            "full_bodied",
            "oaked",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "premium",
            "reserve",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "country": "AR",
        "name": "La Rioja Province",
        "synonyms": ["La Rioja"],
        "description": {
            "default": "",
            "sommelier": "Nestled in the stunning Andes foothills, La Rioja Province is a hidden gem for Malbec lovers, where the high-altitude vineyards produce robust, oaked reds that tantalize the palate with their depth and character. This region's wines are a true testament to the artistry of winemaking, offering a delightful experience for any connoisseur.",
            "julie": "Argentina is the world’s fifth largest wine producer in the world with just under 200,000 hectares of vines and the tenth largest wine exporter. The country’s vineyards are mostly confined to the western sector of the country, in the plains and foothills near the Andes. In the rain shadow of the Andes, Argentina’s wine producing regions are very dry, a condition exacerbated by the Zonda, a fierce, dusty, hot afternoon wind that blows down from the mountains in the late spring and early summer. The general lack of humidity in most Argentinean winegrowing regions keeps vineyards free of fungal problems, and snowmelt provides plentiful water for irrigation—in those years that the Andes receive heavy winter snowfall. Vineyards are planted at high altitude to help mitigate the semi-deserted climate that prevail in most of the country. In fact, the average national elevation for vineyards is approximately 900 meters above sea level and can reach over 3000 meters in the norther region of Salta. Mendoza is the biggest centre of production, representing over 70% of the country’s wine production. Malbec is by far the most planted grape in the country representing nearly 25% of the total grapevine plantings. ",
        },
        "climate_types": "semi_desert",
        "avg_annual_rainfall": None,
        "elevation_range": (900, 3000),
        "soil_types": "uknown",
        "primary_grapes": ["Malbec"],
        "wine_styles": ["red", "full_bodied", "oaked", "varietal"],
    },
    {
        "country": "AR",
        "name": "Mendoza",
        "synonyms": ["Mendoza Province"],
        "subregions": [
            {"name": "Agrelo"},
            {"name": "Barrancas"},
            {"name": "Las Compuertas"},
            {"name": "Lujan de Cuyo"},
            {"name": "Lunlunta"},
            {"name": "Maipu"},
            {"name": "Perdriel"},
            {"name": "San Martin"},
            {"name": "San Rafael"},
            {
                "name": "Uco Valley",
                "subregions": [
                    {"name": "Altamira"},
                    {"name": "La Consulta"},
                    {"name": "Los Chacayes"},
                    {
                        "name": "San Carlos",
                        "subregions": [{"name": "Pampa El Cepillo"}],
                    },
                    {"name": "Tunuyan", "subregions": [{"name": "San Pablo"}]},
                    {"name": "Tupungato", "subregions": [{"name": "Gualtallary"}]},
                    {"name": "Vista Flores"},
                ],
            },
            {"name": "Ugarteche"},
            {"name": "Vistalba"},
        ],
        "description": {
            "default": "",
            "sommelier": "Mendoza is a sun-drenched paradise for wine lovers, where the majestic Andes provide a stunning backdrop to vineyards that yield luscious Malbecs and a variety of other styles. With its diverse elevations and alluvial soils, this region crafts wines that are as bold and vibrant as the landscape itself.",
            "julie": "Argentina is the world’s fifth largest wine producer in the world with just under 200,000 hectares of vines and the tenth largest wine exporter. The country’s vineyards are mostly confined to the western sector of the country, in the plains and foothills near the Andes. In the rain shadow of the Andes, Argentina’s wine producing regions are very dry, a condition exacerbated by the Zonda, a fierce, dusty, hot afternoon wind that blows down from the mountains in the late spring and early summer. The general lack of humidity in most Argentinean winegrowing regions keeps vineyards free of fungal problems, and snowmelt provides plentiful water for irrigation—in those years that the Andes receive heavy winter snowfall. Vineyards are planted at high altitude to help mitigate the semi-deserted climate that prevail in most of the country. In fact, the average national elevation for vineyards is approximately 900 meters above sea level and can reach over 3000 meters in the norther region of Salta. Mendoza is the biggest centre of production, representing over 70% of the country’s wine production. Malbec is by far the most planted grape in the country representing nearly 25% of the total grapevine plantings. ",
        },
        "climate_types": "semi_desert",
        "avg_annual_rainfall": 200.0,
        "elevation_range": (900, 3000),
        "soil_types": "alluvial",
        "primary_grapes": ["Malbec"],
        "wine_styles": [
            "red",
            "white",
            "sparkling",
            "fortified",
            "medium_bodied",
            "full_bodied",
        ],
    },
    {
        "country": "AR",
        "name": "Neuquén Province",
        "synonyms": ["Neuquén"],
        "description": {
            "default": "",
            "sommelier": "Discover the enchanting Neuquén Province, where the high-altitude vineyards produce exquisite Malbecs and a delightful array of wine styles, from sparkling to fortified. This lesser-known region is a treasure trove for adventurous palates seeking bold flavors and a taste of Argentina's diverse terroir.",
            "julie": "Argentina is the world’s fifth largest wine producer in the world with just under 200,000 hectares of vines and the tenth largest wine exporter. The country’s vineyards are mostly confined to the western sector of the country, in the plains and foothills near the Andes. In the rain shadow of the Andes, Argentina’s wine producing regions are very dry, a condition exacerbated by the Zonda, a fierce, dusty, hot afternoon wind that blows down from the mountains in the late spring and early summer. The general lack of humidity in most Argentinean winegrowing regions keeps vineyards free of fungal problems, and snowmelt provides plentiful water for irrigation—in those years that the Andes receive heavy winter snowfall. Vineyards are planted at high altitude to help mitigate the semi-deserted climate that prevail in most of the country. In fact, the average national elevation for vineyards is approximately 900 meters above sea level and can reach over 3000 meters in the norther region of Salta. Mendoza is the biggest centre of production, representing over 70% of the country’s wine production. Malbec is by far the most planted grape in the country representing nearly 25% of the total grapevine plantings. ",
        },
        "climate_types": "semi_desert",
        "avg_annual_rainfall": None,
        "elevation_range": (900, 3000),
        "soil_types": "uknown",
        "primary_grapes": ["Malbec"],
        "wine_styles": ["red", "white", "rose", "sparkling", "dessert", "fortified"],
    },
    {
        "country": "AR",
        "name": "Río Negro Province",
        "synonyms": ["Río Negro"],
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of Argentina, Río Negro Province is a high-altitude haven for Malbec, where the cool climate and varied elevations create wines that are both bold and nuanced, perfect for those who appreciate a robust, oaked red. This region's unique conditions allow for a remarkable expression of this iconic grape, making it a must-try for any wine enthusiast.",
            "julie": "Argentina is the world’s fifth largest wine producer in the world with just under 200,000 hectares of vines and the tenth largest wine exporter. The country’s vineyards are mostly confined to the western sector of the country, in the plains and foothills near the Andes. In the rain shadow of the Andes, Argentina’s wine producing regions are very dry, a condition exacerbated by the Zonda, a fierce, dusty, hot afternoon wind that blows down from the mountains in the late spring and early summer. The general lack of humidity in most Argentinean winegrowing regions keeps vineyards free of fungal problems, and snowmelt provides plentiful water for irrigation—in those years that the Andes receive heavy winter snowfall. Vineyards are planted at high altitude to help mitigate the semi-deserted climate that prevail in most of the country. In fact, the average national elevation for vineyards is approximately 900 meters above sea level and can reach over 3000 meters in the norther region of Salta. Mendoza is the biggest centre of production, representing over 70% of the country’s wine production. Malbec is by far the most planted grape in the country representing nearly 25% of the total grapevine plantings. ",
        },
        "climate_types": "semi_desert",
        "avg_annual_rainfall": None,
        "elevation_range": (900, 3000),
        "soil_types": "uknown",
        "primary_grapes": ["Malbec"],
        "wine_styles": ["red", "full_bodied", "oaked", "varietal"],
    },
    {
        "country": "AR",
        "name": "Salta Province",
        "synonyms": ["Salta"],
        "description": {
            "default": "",
            "sommelier": "In the soaring heights of Salta Province, where the air is thin and the sun shines bright, Malbec grapes flourish, yielding full-bodied reds that are both rich and complex. This high-altitude paradise offers a unique terroir that captivates the senses, making every sip a journey through the Andes.",
            "julie": "Argentina is the world’s fifth largest wine producer in the world with just under 200,000 hectares of vines and the tenth largest wine exporter. The country’s vineyards are mostly confined to the western sector of the country, in the plains and foothills near the Andes. In the rain shadow of the Andes, Argentina’s wine producing regions are very dry, a condition exacerbated by the Zonda, a fierce, dusty, hot afternoon wind that blows down from the mountains in the late spring and early summer. The general lack of humidity in most Argentinean winegrowing regions keeps vineyards free of fungal problems, and snowmelt provides plentiful water for irrigation—in those years that the Andes receive heavy winter snowfall. Vineyards are planted at high altitude to help mitigate the semi-deserted climate that prevail in most of the country. In fact, the average national elevation for vineyards is approximately 900 meters above sea level and can reach over 3000 meters in the norther region of Salta. Mendoza is the biggest centre of production, representing over 70% of the country’s wine production. Malbec is by far the most planted grape in the country representing nearly 25% of the total grapevine plantings. ",
        },
        "climate_types": "semi_desert",
        "avg_annual_rainfall": None,
        "elevation_range": (900, 3000),
        "soil_types": "uknown",
        "primary_grapes": ["Malbec"],
        "wine_styles": ["red", "full_bodied", "premium"],
    },
    {
        "country": "AR",
        "name": "San Juan Province",
        "synonyms": ["San Juan"],
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of Argentina, San Juan Province is a sun-drenched paradise where the high-altitude vineyards produce luscious Malbecs that burst with flavor. With its sandy soils and diverse wine styles, this region invites you to explore a delightful array of wines that capture the essence of its stunning landscape.",
            "julie": "Argentina is the world’s fifth largest wine producer in the world with just under 200,000 hectares of vines and the tenth largest wine exporter. The country’s vineyards are mostly confined to the western sector of the country, in the plains and foothills near the Andes. In the rain shadow of the Andes, Argentina’s wine producing regions are very dry, a condition exacerbated by the Zonda, a fierce, dusty, hot afternoon wind that blows down from the mountains in the late spring and early summer. The general lack of humidity in most Argentinean winegrowing regions keeps vineyards free of fungal problems, and snowmelt provides plentiful water for irrigation—in those years that the Andes receive heavy winter snowfall. Vineyards are planted at high altitude to help mitigate the semi-deserted climate that prevail in most of the country. In fact, the average national elevation for vineyards is approximately 900 meters above sea level and can reach over 3000 meters in the norther region of Salta. Mendoza is the biggest centre of production, representing over 70% of the country’s wine production. Malbec is by far the most planted grape in the country representing nearly 25% of the total grapevine plantings. ",
        },
        "climate_types": "semi_desert",
        "avg_annual_rainfall": None,
        "elevation_range": (900, 3000),
        "soil_types": "sandy",
        "primary_grapes": ["Malbec"],
        "wine_styles": ["red", "white", "rose"],
    },
    {
        "country": "BO",
        "name": "Tarija Department",
        "synonyms": ["Tarija"],
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (1800, 2500),
        "soil_types": "alluvial",
        "primary_grapes": ["Tannat", "Malbec"],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Tarija Department is a hidden gem in Bolivia's wine landscape, where the high-altitude vineyards yield bold Tannat and luscious Malbec, producing wines that are as vibrant as the region's stunning scenery. With its unique alluvial soils and a climate that dances between warmth and cool breezes, Tarija is a must-visit for adventurous wine lovers seeking something extraordinary.",
        },
    },
    {
        "country": "BR",
        "name": "Bahia",
        "subregions": [{"name": "Curaçá"}, {"name": "Irecê"}, {"name": "Juazeiro"}],
        "climate_types": "tropical",
        "avg_annual_rainfall": 800.0,
        "elevation_range": None,
        "soil_types": "sandy",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Brazil, Bahia's sandy soils and gentle rainfall create a sun-kissed paradise for grape cultivation, promising vibrant and refreshing wines that capture the essence of tropical flavors. This emerging wine region invites adventurous palates to explore its unique offerings, blending tradition with innovation.",
        },
    },
    {
        "country": "BR",
        "name": "Mato Grosso",
        "subregions": [{"name": "Nova Mutum"}],
        "climate_types": "tropical",
        "avg_annual_rainfall": 1500.0,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": ["Cabernet Sauvignon", "Merlot", "Chardonnay", "Syrah"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Brazil, Mato Grosso is a burgeoning wine region where the lush landscapes and ample rainfall nurture a delightful mix of grape varieties, producing everything from bold reds to refreshing sparkling wines. With Cabernet Sauvignon and Chardonnay leading the charge, this region is poised to surprise and delight wine enthusiasts with its unique offerings.",
        },
    },
    {
        "country": "BR",
        "name": "Minas Gerais",
        "subregions": [
            {"name": "Andradas"},
            {"name": "Caldas"},
            {"name": "Pirapora"},
            {"name": "Santa Rita de Caldas"},
        ],
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Brazil, Minas Gerais is a burgeoning wine region that captivates with its diverse landscapes and innovative winemaking. As it continues to develop, this area is poised to surprise palates with its unique expressions of grape varieties and styles, inviting adventurous wine lovers to discover its hidden gems.",
        },
    },
    {
        "country": "BR",
        "name": "Paraná",
        "subregions": [
            {"name": "Bandeirantes"},
            {"name": "Marialva"},
            {"name": "Maringá"},
            {"name": "Rosário do Avaí"},
        ],
        "climate_types": "tropical",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Brazil, the Paraná region is a hidden gem for adventurous wine lovers, offering the promise of undiscovered flavors and unique varietals waiting to be explored. While the specifics of its soil and grape varieties remain a mystery, the region's potential for innovation and growth in the wine industry is undeniably exciting.",
        },
    },
    {
        "country": "BR",
        "name": "Pernambuco",
        "subregions": [
            {"name": "Casa Nova"},
            {"name": "Petrolina"},
            {"name": "Santa Maria da Boa Vista"},
        ],
        "climate_types": "semi_desert",
        "avg_annual_rainfall": 500.0,
        "elevation_range": None,
        "soil_types": "sandy",
        "primary_grapes": ["Syrah", "Cabernet Sauvignon"],
        "wine_styles": ["red", "white", "oaked", "unoaked"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Brazil, Pernambuco offers a delightful exploration of wine with its sandy soils nurturing bold Syrah and Cabernet Sauvignon. Whether you prefer the richness of oaked reds or the freshness of unoaked whites, this region promises a vibrant tasting experience that reflects its unique climate and geography.",
        },
    },
    {
        "country": "BR",
        "name": "Rio Grande do Sul",
        "subregions": [
            {"name": "Bento Gonçalves"},
            {"name": "Caxias do Sul"},
            {"name": "Cotiporã"},
            {"name": "Farroupilha"},
            {"name": "Flores da Cunha"},
            {"name": "Garibaldi"},
            {"name": "Pinto Bandeira"},
        ],
        "climate_types": "temperate",
        "avg_annual_rainfall": 1500.0,
        "elevation_range": (100, 800),
        "soil_types": "clay",
        "primary_grapes": [
            "Merlot",
            "Cabernet Sauvignon",
            "Chardonnay",
            "Tannat",
            "Pinot Noir",
        ],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the southern reaches of Brazil, Rio Grande do Sul boasts a unique blend of climate and terroir, producing exquisite wines from Merlot to Chardonnay. With its lush landscapes and a commitment to quality, this region is a hidden gem for those seeking both bold reds and elegant whites.",
        },
    },
    {
        "country": "BR",
        "name": "Santa Catarina",
        "subregions": [
            {"name": "Pinheiro Preto"},
            {"name": "São Joaquim"},
            {"name": "Tangará"},
        ],
        "climate_types": "temperate",
        "avg_annual_rainfall": 1500.0,
        "elevation_range": (800, 1400),
        "soil_types": "volcanic",
        "primary_grapes": ["Pinot Noir", "Chardonnay"],
        "wine_styles": ["sparkling", "white", "red"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Santa Catarina is a hidden gem in Brazil's wine landscape, where the volcanic soils and high altitudes give rise to exquisite sparkling wines and elegant whites and reds, primarily from Pinot Noir and Chardonnay. This region's unique climate and terroir make it a must-visit for wine enthusiasts seeking something extraordinary.",
        },
    },
    {
        "country": "BR",
        "name": "São Paulo",
        "subregions": [{"name": "Jundiaí"}, {"name": "São Roque"}],
        "climate_types": "tropical",
        "avg_annual_rainfall": 1500.0,
        "elevation_range": (500, 1000),
        "soil_types": "clay",
        "primary_grapes": [
            "Cabernet Sauvignon",
            "Merlot",
            "Chardonnay",
            "Sauvignon Blanc",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Brazil, São Paulo is a burgeoning wine region where the robust Cabernet Sauvignon and elegant Chardonnay thrive amidst clay-rich soils and a temperate climate, producing everything from bold reds to refreshing sparkling wines that are sure to delight any palate.",
        },
    },
    {
        "country": "CA",
        "name": "British Columbia",
        "subregions": [
            {"name": "Fraser Valley"},
            {"name": "Gulf Islands"},
            {"name": "Okanagan Valley"},
            {"name": "Similkameen Valley"},
            {"name": "Thompson Valley"},
            {"name": "Vancouver Island"},
        ],
        "climate_types": "maritime",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 2000),
        "soil_types": "sandy_loam",
        "primary_grapes": [
            "Chardonnay",
            "Pinot Noir",
            "Merlot",
            "Cabernet Sauvignon",
            "Syrah",
        ],
        "wine_styles": ["red", "white", "sparkling", "dessert", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled between mountains and the Pacific Ocean, British Columbia is a vinous treasure trove where the cool climate nurtures a delightful array of wines, from sparkling whites to bold reds. With its sandy loam soils and diverse elevations, this region crafts wines that are as vibrant and varied as the stunning landscapes that surround them.",
        },
    },
    {
        "country": "CA",
        "name": "Nova Scotia",
        "subregions": [{"name": "Annapolis Valley"}],
        "climate_types": "maritime",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 300),
        "soil_types": "clay",
        "primary_grapes": ["L'Acadie Blanc", "Riesling", "Cabernet Franc"],
        "wine_styles": ["white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the Atlantic coast, Nova Scotia is a hidden gem for wine lovers, celebrated for its crisp whites and effervescent sparklings that capture the essence of the sea breeze. With a focus on indigenous varieties and a commitment to quality, this region is redefining Canadian wine with every bottle.",
        },
    },
    {
        "country": "CA",
        "name": "Ontario",
        "subregions": [
            {"name": "Lake Erie"},
            {"name": "Niagara Peninsula"},
            {"name": "Prince Edward County"},
            {"name": "Toronto"},
        ],
        "climate_types": "cool_climate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (100, 300),
        "soil_types": "clay",
        "primary_grapes": ["Chardonnay", "Riesling", "Pinot Noir", "Cabernet Franc"],
        "wine_styles": ["red", "white", "sparkling", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Ontario is a hidden gem in the wine world, where the lush clay soils and moderate climate give rise to a delightful array of wines, from crisp Chardonnays and aromatic Rieslings to velvety Pinot Noirs and bold Cabernet Francs. Whether you're sipping a sparkling wine or indulging in a luscious dessert wine, Ontario's vineyards promise a taste of the region's rich terroir and vibrant character.",
        },
    },
    {
        "country": "CA",
        "name": "Quebec",
        "subregions": [{"name": "Eastern Townships"}],
        "climate_types": "continental",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (200, 400),
        "soil_types": "clay",
        "primary_grapes": ["Chardonnay", "Pinot Noir", "Riesling"],
        "wine_styles": ["white", "red", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Quebec is a hidden gem in the wine world, where the cool climate and clay-rich soils nurture exquisite Chardonnay, Pinot Noir, and Riesling. This region produces a delightful array of wines, from crisp whites to elegant reds and sparkling treasures, showcasing the artistry and passion of its winemakers.",
        },
    },
    {
        "country": "CO",
        "name": "Villa de Leyva",
        "climate_types": "semi_desert",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (2000, 2500),
        "soil_types": "uknown",
        "primary_grapes": ["Tempranillo", "Cabernet Sauvignon", "Malbec"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the highlands of Colombia, Villa de Leyva is a captivating wine region where the altitude and climate converge to create exceptional wines, particularly its rich reds from Tempranillo and Malbec. This enchanting locale invites wine lovers to explore its vibrant offerings, all while soaking in the stunning Andean landscapes.",
        },
    },
    {
        "country": "CO",
        "name": "Valle del Cauca",
        "subregions": [{"name": "La Unión"}],
        "climate_types": "tropical",
        "avg_annual_rainfall": 1500.0,
        "elevation_range": (1000, 2000),
        "soil_types": "volcanic",
        "primary_grapes": ["Cabernet Sauvignon", "Malbec", "Chardonnay"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Colombia, Valle del Cauca is a hidden gem where volcanic soils and a temperate climate give rise to exquisite wines, from robust Cabernet Sauvignon and Malbec to refreshing Chardonnay. This region's diverse terroir and commitment to quality make it a must-visit for any wine enthusiast seeking to explore new horizons.",
        },
    },
    {
        "country": "CL",
        "name": "Aconcagua",
        "subregions": [{"name": "Aconcagua Valley"}, {"name": "Casablanca Valley"}],
        "description": {
            "default": "",
            "sommelier": "Nestled in the shadow of the Andes, Aconcagua is a vibrant wine region where the sun-drenched vineyards yield luscious Cabernet Sauvignon and Merlot, alongside crisp Chardonnay, crafting wines that are as bold and diverse as the landscape itself. Whether you prefer a rich red or a refreshing white, Aconcagua's offerings promise to delight and surprise with every sip.",
            "julie": "Chiles’ vineyards run for about 1300km, north to South, along the Pacific Ocean coastal area and most major regions of production are located to the South of the capital city, Santiago. From north to south, the six regional Denominations of Origin (DOs) in Chile are Atacama, Coquimbo, Aconcagua, the Valle Central (Central Valley), Sur (the Southern Regions), and a new area at the southernmost limit of grape growing in the country, the Austral Region. The northernmost regions of Atacama and Coquimbo are dry and desert-like, with grapes historically destined for Pisco production or the table. The country’s most suitable vineyards for fine wine are mostly situated in the Central Valley to the south of Santiago, where the proximity of the Andes cools night-time temperatures, and along the coast, where the cold, maritime Humboldt Current cools the vines. In the country’s southernmost areas of viticulture, rainfall is higher and the overall growing season is cooler and shorter. Significant variations in altitude exist in most of Chile’s major regions, as vineyard plantings climb from the coast into the Coastal Ranges, and from the valleys into the Andean foothills.",
        },
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "alluvial",
        "primary_grapes": ["Cabernet Sauvignon", "Merlot", "Chardonnay"],
        "wine_styles": ["red", "white", "sparkling", "medium_bodied", "full_bodied"],
    },
    {
        "country": "CL",
        "name": "Curicó",
        "synonyms": ["Curicó Valley"],
        "subregions": [
            {"name": "Licantén"},
            {"name": "Teno"},
            {"name": "Lontué", "synonyms": ["Lontué Valley"]},
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (200, 800),
        "soil_types": "clay",
        "primary_grapes": ["Cabernet Sauvignon", "Chardonnay", "Merlot", "Syrah"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Curicó Valley is a hidden gem in Chile, where the harmonious blend of clay soils and varied elevations creates a playground for winemakers. Here, you can savor everything from bold Cabernet Sauvignon to crisp Chardonnay, all while enjoying the region's stunning landscapes and vibrant wine culture.",
        },
    },
    {
        "country": "CL",
        "name": "Atacama",
        "subregions": [{"name": "Copiapó Valley"}, {"name": "Huasco Valley"}],
        "description": {
            "default": "",
            "sommelier": "Nestled in one of the driest places on Earth, the Atacama region offers a remarkable canvas for winemaking, where sandy soils and high elevations yield grapes that burst with intensity and complexity. This unique landscape challenges traditional viticulture, resulting in wines that are as bold and adventurous as the environment itself.",
            "julie": "Chiles’ vineyards run for about 1300km, north to South, along the Pacific Ocean coastal area and most major regions of production are located to the South of the capital city, Santiago. From north to south, the six regional Denominations of Origin (DOs) in Chile are Atacama, Coquimbo, Aconcagua, the Valle Central (Central Valley), Sur (the Southern Regions), and a new area at the southernmost limit of grape growing in the country, the Austral Region. The northernmost regions of Atacama and Coquimbo are dry and desert-like, with grapes historically destined for Pisco production or the table. The country’s most suitable vineyards for fine wine are mostly situated in the Central Valley to the south of Santiago, where the proximity of the Andes cools night-time temperatures, and along the coast, where the cold, maritime Humboldt Current cools the vines. In the country’s southernmost areas of viticulture, rainfall is higher and the overall growing season is cooler and shorter. Significant variations in altitude exist in most of Chile’s major regions, as vineyard plantings climb from the coast into the Coastal Ranges, and from the valleys into the Andean foothills.",
        },
        "climate_types": "desert",
        "avg_annual_rainfall": 50.0,
        "elevation_range": (0, 2000),
        "soil_types": "sandy",
        "primary_grapes": [],
        "wine_styles": [],
    },
    {
        "country": "CL",
        "name": "Central Valley",
        "subregions": [
            {
                "name": "Rapel Valley",
                "subregions": [
                    {"name": "Cachapoal Valley"},
                    {"name": "Colchagua Valley"},
                ],
            },
            {"name": "Maipo Valley"},
            {"name": "Mataquito Valley"},
            {"name": "Maule Valley"},
        ],
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of the wine country, Central Valley boasts a rich tapestry of flavors, from the boldness of Cabernet Sauvignon to the crispness of Chardonnay, all nurtured by its clay soils and varied elevations. This region is a treasure trove for wine lovers, offering a delightful array of medium to full-bodied wines that are sure to please any palate.",
            "julie": "Chiles’ vineyards run for about 1300km, north to South, along the Pacific Ocean coastal area and most major regions of production are located to the South of the capital city, Santiago. From north to south, the six regional Denominations of Origin (DOs) in Chile are Atacama, Coquimbo, Aconcagua, the Valle Central (Central Valley), Sur (the Southern Regions), and a new area at the southernmost limit of grape growing in the country, the Austral Region. The northernmost regions of Atacama and Coquimbo are dry and desert-like, with grapes historically destined for Pisco production or the table. The country’s most suitable vineyards for fine wine are mostly situated in the Central Valley to the south of Santiago, where the proximity of the Andes cools night-time temperatures, and along the coast, where the cold, maritime Humboldt Current cools the vines. In the country’s southernmost areas of viticulture, rainfall is higher and the overall growing season is cooler and shorter. Significant variations in altitude exist in most of Chile’s major regions, as vineyard plantings climb from the coast into the Coastal Ranges, and from the valleys into the Andean foothills.",
        },
        "climate_types": "temperate",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (0, 2000),
        "soil_types": "clay",
        "primary_grapes": [
            "Cabernet Sauvignon",
            "Merlot",
            "Chardonnay",
            "Carmenere",
            "Syrah",
        ],
        "wine_styles": ["red", "white", "blend", "medium_bodied", "full_bodied"],
    },
    {
        "country": "CL",
        "name": "Coquimbo",
        "subregions": [
            {"name": "Choapa Valley"},
            {
                "name": "Elqui Valley",
                "description": {
                    "default": "",
                    "sommelier": "Elqui is a region of extremes, with high-altitude desert vineyards at the edge of the Atacama Desert creating wines of incredible intensity and freshness. It is celebrated for producing a truly unique style of Syrah, which is deeply colored and powerful yet stunningly aromatic with notes of violets, black pepper, and brilliant acidity.",
                    "julie": "",
                },
            },
            {"name": "Limarí"},
        ],
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of Chile, Coquimbo is a hidden gem for wine enthusiasts, offering a tapestry of climates that nurture a variety of grape styles. With its mysterious soils and promising potential, this region invites adventurous palates to discover its unique offerings.",
            "julie": "Chiles’ vineyards run for about 1300km, north to South, along the Pacific Ocean coastal area and most major regions of production are located to the South of the capital city, Santiago. From north to south, the six regional Denominations of Origin (DOs) in Chile are Atacama, Coquimbo, Aconcagua, the Valle Central (Central Valley), Sur (the Southern Regions), and a new area at the southernmost limit of grape growing in the country, the Austral Region. The northernmost regions of Atacama and Coquimbo are dry and desert-like, with grapes historically destined for Pisco production or the table. The country’s most suitable vineyards for fine wine are mostly situated in the Central Valley to the south of Santiago, where the proximity of the Andes cools night-time temperatures, and along the coast, where the cold, maritime Humboldt Current cools the vines. In the country’s southernmost areas of viticulture, rainfall is higher and the overall growing season is cooler and shorter. Significant variations in altitude exist in most of Chile’s major regions, as vineyard plantings climb from the coast into the Coastal Ranges, and from the valleys into the Andean foothills.",
        },
        "climate_types": "desert",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
    },
    {
        "country": "CL",
        "name": "Pica",
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of Chile, the Pica region beckons with its mysterious charm, promising a canvas for winemakers to craft distinctive wines that reflect the untamed spirit of the land. With its unknown soil and potential for unique grape varieties, Pica is a hidden gem waiting to be unveiled by those daring enough to explore its vinous possibilities.",
            "julie": "Chiles’ vineyards run for about 1300km, north to South, along the Pacific Ocean coastal area and most major regions of production are located to the South of the capital city, Santiago. From north to south, the six regional Denominations of Origin (DOs) in Chile are Atacama, Coquimbo, Aconcagua, the Valle Central (Central Valley), Sur (the Southern Regions), and a new area at the southernmost limit of grape growing in the country, the Austral Region. The northernmost regions of Atacama and Coquimbo are dry and desert-like, with grapes historically destined for Pisco production or the table. The country’s most suitable vineyards for fine wine are mostly situated in the Central Valley to the south of Santiago, where the proximity of the Andes cools night-time temperatures, and along the coast, where the cold, maritime Humboldt Current cools the vines. In the country’s southernmost areas of viticulture, rainfall is higher and the overall growing season is cooler and shorter. Significant variations in altitude exist in most of Chile’s major regions, as vineyard plantings climb from the coast into the Coastal Ranges, and from the valleys into the Andean foothills.",
        },
        "climate_types": "desert",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
    },
    {
        "country": "CL",
        "name": "Southern Chile",
        "subregions": [
            {"name": "Patagonia"},
            {"name": "Bío-Bío Valley", "synonyms": ["Bío-Bío", "Valle del Bío-Bío"]},
            {"name": "Itata Valley", "synonyms": ["Valle del Itata"]},
            {"name": "Malleco Valley", "synonyms": ["Valle del Malleco"]},
            {"name": "Bueno Valley", "synonyms": ["Valle del Bueno"]},
        ],
        "description": {
            "default": "",
            "sommelier": "Southern Chile is a hidden gem where the majestic Andes meet the Pacific, crafting a vibrant tapestry of wines. With its stellar Cabernet Sauvignon and Merlot reds, alongside crisp Chardonnays, this region offers a delightful exploration of flavors that reflect its diverse climate and enigmatic soils.",
            "julie": "Chiles’ vineyards run for about 1300km, north to South, along the Pacific Ocean coastal area and most major regions of production are located to the South of the capital city, Santiago. From north to south, the six regional Denominations of Origin (DOs) in Chile are Atacama, Coquimbo, Aconcagua, the Valle Central (Central Valley), Sur (the Southern Regions), and a new area at the southernmost limit of grape growing in the country, the Austral Region. The northernmost regions of Atacama and Coquimbo are dry and desert-like, with grapes historically destined for Pisco production or the table. The country’s most suitable vineyards for fine wine are mostly situated in the Central Valley to the south of Santiago, where the proximity of the Andes cools night-time temperatures, and along the coast, where the cold, maritime Humboldt Current cools the vines. In the country’s southernmost areas of viticulture, rainfall is higher and the overall growing season is cooler and shorter. Significant variations in altitude exist in most of Chile’s major regions, as vineyard plantings climb from the coast into the Coastal Ranges, and from the valleys into the Andean foothills.",
        },
        "climate_types": "maritime",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": ["Cabernet Sauvignon", "Merlot", "Chardonnay"],
        "wine_styles": ["red", "white", "sparkling"],
    },
    {
        "country": "MX",
        "name": "Aguascalientes",
        "subregions": [{"name": "Aguascalientes"}],
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (1600, 2000),
        "soil_types": "uknown",
        "primary_grapes": ["Tempranillo", "Cabernet Sauvignon", "Chenin Blanc"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Aguascalientes is a hidden gem in the Mexican wine landscape, where the high altitude and moderate rainfall create a perfect environment for crafting bold reds and crisp whites. With Tempranillo and Cabernet Sauvignon leading the charge, this region promises a delightful exploration of flavors that reflect its unique terroir.",
        },
    },
    {
        "country": "MX",
        "name": "Baja California",
        "subregions": [
            {
                "name": "Valle de Guadalupe",
                "subregions": [
                    {"name": "Valle de Calafia"},
                    {"name": "Valle de Mexicali"},
                    {"name": "Valle de San Vicente"},
                    {"name": "Valle de Santo Tomás"},
                    {"name": "Zona Tecate"},
                ],
            }
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 300.0,
        "elevation_range": (0, 800),
        "soil_types": "sandy",
        "primary_grapes": [
            "Cabernet Sauvignon",
            "Merlot",
            "Tempranillo",
            "Chenin Blanc",
            "Zinfandel",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Baja California is a sun-soaked paradise for wine lovers, where sandy soils and a Mediterranean climate give rise to a delightful array of wines, from bold reds to crisp whites and even sparkling gems. With its rich tapestry of grape varieties, this region invites you to explore its dynamic and flavorful offerings, making every sip a celebration of its vibrant terroir.",
        },
    },
    {
        "country": "MX",
        "name": "Coahuila",
        "subregions": [{"name": "Valle de Parras"}],
        "climate_types": "semi_desert",
        "avg_annual_rainfall": 300.0,
        "elevation_range": (1500, 2000),
        "soil_types": "clay",
        "primary_grapes": ["Tempranillo", "Cabernet Sauvignon", "Chenin Blanc"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Mexico, Coahuila boasts a stunning elevation that breathes life into its Tempranillo and Cabernet Sauvignon, while its clay soils lend a distinctive character to its wines. With an impressive array of styles from bold reds to refreshing sparklings, this region is a hidden gem waiting to be explored by wine enthusiasts.",
        },
    },
    {
        "country": "MX",
        "name": "Guanajuato",
        "subregions": [
            {"name": "Guanajuato City"},
            {"name": "San Miguel de Allende"},
            {"name": "Dolores Hidalgo"},
            {"name": "San Felipe"},
            {"name": "Salvatierra"},
            {"name": "San Francisco del Rincón"},
        ],
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Mexico, Guanajuato is an emerging wine region that promises to surprise with its untapped potential and diverse grape varieties, inviting adventurous palates to discover its hidden gems.",
        },
    },
    {
        "country": "MX",
        "name": "Hidalgo",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (1500, 2500),
        "soil_types": "clay",
        "primary_grapes": ["Tempranillo", "Cabernet Sauvignon", "Chenin Blanc"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the highlands, Hidalgo is a hidden gem where the clay soils and crisp mountain air create a playground for winemakers. Here, you can savor everything from bold reds to elegant sparkling wines, all crafted from a delightful mix of Tempranillo, Cabernet Sauvignon, and Chenin Blanc.",
        },
    },
    {
        "country": "MX",
        "name": "Nuevo León",
        "subregions": [{"name": "Valle de Las Maravillas"}],
        "climate_types": "semi_desert",
        "avg_annual_rainfall": 300.0,
        "elevation_range": (500, 1500),
        "soil_types": "sandy",
        "primary_grapes": ["Tempranillo", "Cabernet Sauvignon", "Chardonnay"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Mexico, Nuevo León is a hidden gem for wine lovers, where the sun-drenched vineyards yield bold reds and crisp whites, showcasing the region's unique sandy soils and high elevation. With a blend of traditional and modern winemaking techniques, this region invites you to explore its vibrant wine styles, from luscious rosés to complex reds.",
        },
    },
    {
        "country": "MX",
        "name": "Querétaro",
        "subregions": [{"name": "Valle de Tequisquiapan"}],
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (1700, 2200),
        "soil_types": "clay",
        "primary_grapes": [
            "Tempranillo",
            "Chenin Blanc",
            "Cabernet Sauvignon",
            "Merlot",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Querétaro is a hidden gem in Mexico's wine landscape, where the high-altitude vineyards produce a delightful array of wines, from the bold Tempranillo to the crisp Chenin Blanc. With its clay-rich soils and a climate that dances between warmth and coolness, this region is a playground for wine lovers seeking both tradition and innovation.",
        },
    },
    {
        "country": "MX",
        "name": "Sonora",
        "subregions": [{"name": "Caborca"}, {"name": "Hermosillo"}],
        "climate_types": "desert",
        "avg_annual_rainfall": 200.0,
        "elevation_range": None,
        "soil_types": "sandy",
        "primary_grapes": ["Tempranillo", "Grenache", "Zinfandel"],
        "wine_styles": ["red", "white", "blend"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Sonora is a sun-drenched gem where sandy soils and minimal rainfall create the perfect backdrop for robust wines, particularly Tempranillo and Grenache. This region's diverse offerings, from rich reds to refreshing whites, invite wine lovers to explore its unique character and charm.",
        },
    },
    {
        "country": "MX",
        "name": "Zacatecas",
        "subregions": [{"name": "Valle de las Arcinas"}],
        "climate_types": "semi_desert",
        "avg_annual_rainfall": 300.0,
        "elevation_range": (1500, 2500),
        "soil_types": "clay",
        "primary_grapes": ["Tempranillo", "Cabernet Sauvignon", "Chenin Blanc"],
        "wine_styles": ["red", "white", "blend", "traditional", "modern"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the highlands of Mexico, Zacatecas is a hidden gem where the bold flavors of Tempranillo and the crisp notes of Chenin Blanc flourish in clay soils, producing wines that beautifully marry tradition with innovation. With its stunning elevation and unique climate, this region invites adventurous palates to explore its diverse offerings.",
        },
    },
    {
        "country": "PE",
        "name": "Arequipa",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": (2000, 3000),
        "soil_types": "volcanic",
        "primary_grapes": ["Malbec", "Tannat", "Cabernet Sauvignon"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Arequipa is a hidden gem in the Andes, where the volcanic soils and high elevation create a playground for bold varietals like Malbec and Tannat, resulting in wines that are as vibrant and dynamic as the region itself. Whether you're sipping a rich red or a crisp sparkling, each glass tells the story of this extraordinary terroir.",
        },
    },
    {
        "country": "PE",
        "name": "Huaral District",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Peru, the Huaral District is a hidden gem for wine lovers, where the interplay of climate and geography creates a canvas for unique grape expressions. Though details are sparse, the region's potential hints at exciting discoveries waiting to be uncorked.",
        },
    },
    {
        "country": "PE",
        "name": "Ica Region",
        "climate_types": "desert",
        "avg_annual_rainfall": 50.0,
        "elevation_range": (0, 2000),
        "soil_types": "sandy",
        "primary_grapes": ["Pisco", "Malbec", "Cabernet Sauvignon", "Chardonnay"],
        "wine_styles": [
            "red",
            "white",
            "sparkling",
            "fortified",
            "traditional",
            "modern",
        ],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the sun-drenched Ica Region, where the desert meets the vine, this area produces a delightful array of wines, from bold reds to crisp whites, all nurtured by its unique sandy soils and minimal rainfall. With a rich heritage of Pisco and a modern twist on classic varietals, Ica is a hidden gem for wine enthusiasts seeking adventure in every sip.",
        },
    },
    {
        "country": "PE",
        "name": "Pica",
        "climate_types": "desert",
        "avg_annual_rainfall": 100.0,
        "elevation_range": (1000, 2000),
        "soil_types": "sandy",
        "primary_grapes": ["Malbec", "Syrah", "Chardonnay"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled between 1000 and 2000 meters above sea level, Pica is a hidden gem where the sun-drenched slopes nurture bold Malbecs and elegant Chardonnays, all crafted from sandy soils that impart a delightful minerality. With just 100 mm of annual rainfall, this region produces wines that are as vibrant and diverse as its breathtaking landscapes.",
        },
    },
    {
        "country": "US",
        "name": "Arizona",
        "climate_types": "semi_desert",
        "avg_annual_rainfall": 300.0,
        "elevation_range": (600, 2400),
        "soil_types": "sandy",
        "primary_grapes": ["Zinfandel", "Syrah", "Cabernet Sauvignon", "Chardonnay"],
        "wine_styles": ["red", "white", "blend", "varietal"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of the Southwest, Arizona's wine country boasts a stunning elevation range that nurtures bold Zinfandels and elegant Chardonnays alike. With its sandy soils and a climate that dances between warmth and coolness, this emerging region is a treasure trove for adventurous palates seeking both varietal and blended wines.",
        },
    },
    {
        "country": "US",
        "name": "California",
        "subregions": [
            {
                "name": "Central Coast",
                "subregions": [
                    {"name": "Gabilan Mountains"},
                    {
                        "name": "Monterey County",
                        "subregions": [
                            {"name": "Arroyo Seco"},
                            {"name": "Carmel Valley"},
                            {"name": "Chalone"},
                            {"name": "Hames Valley"},
                            {"name": "Monterey"},
                            {"name": "San Antonio Valley"},
                            {"name": "San Bernabe"},
                            {"name": "San Lucas"},
                            {"name": "Santa Lucia Highlands"},
                        ],
                    },
                    {
                        "name": "San Benito County",
                        "subregions": [
                            {"name": "Cienega Valley"},
                            {"name": "Lime Kiln Valley"},
                            {"name": "Mount Harlan"},
                            {"name": "Paicines"},
                            {"name": "San Benito"},
                        ],
                    },
                    {
                        "name": "San Francisco Bay",
                        "subregions": [
                            {"name": "Ben Lomond Mountain"},
                            {"name": "Contra Costa County"},
                            {"name": "Livermore Valley"},
                            {"name": "Pacheco Pass"},
                            {"name": "San Ysidro District"},
                            {"name": "Santa Clara Valley"},
                            {"name": "Santa Cruz Mountains"},
                        ],
                    },
                    {
                        "name": "San Luis Obispo County",
                        "subregions": [
                            {"name": "Arroyo Grande Valley"},
                            {"name": "Edna Valley"},
                            {"name": "Paso Robles"},
                            {"name": "York Mountain"},
                        ],
                    },
                    {
                        "name": "Santa Barbara County",
                        "subregions": [
                            {"name": "Alisos Canyon"},
                            {
                                "name": "Happy Canyon of Santa Barbara",
                                "synonyms": ["Happy Canyon"],
                            },
                            {"name": "Santa Maria Valley"},
                            {
                                "name": "Santa Ynez Valley",
                                "subregions": [
                                    {
                                        "name": "Los Olivos District",
                                        "synonyms": ["Los Olivos"],
                                    },
                                    {"name": "Ballard Canyon"},
                                ],
                            },
                            {"name": "Sta. Rita Hills"},
                        ],
                    },
                ],
            },
            {
                "name": "Central Valley",
                "subregions": [
                    {"name": "Diablo Grande"},
                    {
                        "name": "Fresno County",
                        "subregions": [
                            {
                                "name": "Squaw Valley-Miramonte",
                                "synonyms": ["Squaw Valley", "Miramonte"],
                            }
                        ],
                    },
                    {"name": "Lodi"},
                    {"name": "Madera"},
                    {"name": "River Junction"},
                    {"name": "Salado Creek"},
                    {"name": "Tracy Hills"},
                ],
            },
            {
                "name": "North Coast",
                "subregions": [
                    {
                        "name": "Humboldt County",
                        "subregions": [{"name": "Willow Creek"}],
                        "description": {"default": "", "sommelier": "", "julie": ""},
                    },
                    {
                        "name": "Lake County",
                        "subregions": [
                            {"name": "Benmore Valley"},
                            {"name": "Big Valley District"},
                            {"name": "Clear Lake"},
                            {"name": "Guenoc Valley"},
                            {"name": "High Valley"},
                            {"name": "Kelsey Bench"},
                            {"name": "Red Hills Lake County"},
                        ],
                        "description": {"default": "", "sommelier": "", "julie": ""},
                    },
                    {
                        "name": "Marin County",
                        "subregions": [],
                        "description": {"default": "", "sommelier": "", "julie": ""},
                    },
                    {
                        "name": "Mendocino County",
                        "subregions": [
                            {"name": "Anderson Valley"},
                            {"name": "Cole Ranch"},
                            {"name": "Covelo"},
                            {"name": "Dos Rios"},
                            {"name": "Eagle Peak Mendocino County"},
                            {"name": "McDowell Valley"},
                            {"name": "Mendocino"},
                            {"name": "Mendocino Ridge"},
                            {"name": "Potter Valley"},
                            {"name": "Redwood Valley"},
                            {"name": "Yorkville Highlands"},
                        ],
                        "description": {"default": "", "sommelier": "", "julie": ""},
                    },
                    {
                        "name": "Napa County",
                        "synonyms": ["Napa", "Californien"],
                        "subregions": [{"name": "Napa Valley"}],
                        "description": {"default": "", "sommelier": "", "julie": ""},
                    },
                    {
                        "name": "Petaluma Gap",
                        "subregions": [],
                        "description": {"default": "", "sommelier": "", "julie": ""},
                    },
                    {
                        "name": "Solano County",
                        "synonyms": ["Solano"],
                        "subregions": [
                            {"name": "Solano County Green Valley"},
                            {"name": "Suisun Valley"},
                        ],
                        "description": {"default": "", "sommelier": "", "julie": ""},
                    },
                    {
                        "name": "Sonoma County",
                        "synonyms": ["Sonoma"],
                        "subregions": [
                            {"name": "Alexander Valley"},
                            {"name": "Bennett Valley"},
                            {"name": "Carneros"},
                            {"name": "Chalk Hill"},
                            {"name": "Dry Creek Valley"},
                            {"name": "Fort Ross-Seaview"},
                            {"name": "Fountaingrove District"},
                            {"name": "Green Valley of Russian River Valley"},
                            {"name": "Knights Valley"},
                            {"name": "Moon Mountain District"},
                            {"name": "Northern Sonoma"},
                            {"name": "Pine Mountain-Cloverdale Peak"},
                            {"name": "Rockpile"},
                            {"name": "Russian River Valley"},
                            {"name": "Sonoma Coast"},
                            {"name": "Sonoma Mountain"},
                            {"name": "Sonoma Valley"},
                            {"name": "West Sonoma Coast"},
                        ],
                        "description": {"default": "", "sommelier": "", "julie": ""},
                    },
                    {
                        "name": "Trinity County",
                        "subregions": [{"name": "Trinity Lakes"}],
                        "description": {"default": "", "sommelier": "", "julie": ""},
                    },
                ],
            },
            {
                "name": "Sierra Foothills",
                "subregions": [
                    {"name": "Amador County"},
                    {"name": "Calaveras County"},
                    {"name": "California Shenandoah Valley"},
                    {"name": "El Dorado"},
                    {"name": "El Dorado County"},
                    {"name": "Fair Play"},
                    {"name": "Fiddletown"},
                    {"name": "Mariposa County"},
                    {"name": "Nevada County"},
                    {"name": "North Yuba"},
                    {"name": "Placer County"},
                    {"name": "Tuolumne County"},
                ],
            },
            {
                "name": "South Coast",
                "subregions": [
                    {"name": "Antelope Valley of the California High Desert"},
                    {"name": "Cucamonga Valley"},
                    {"name": "Leona Valley"},
                    {"name": "Los Angeles County"},
                    {"name": "Malibu Coast"},
                    {"name": "Malibu-Newton Canyon"},
                    {"name": "Ramona Valley"},
                    {"name": "Saddle Rock Malibu"},
                    {"name": "San Diego County"},
                    {"name": "San Pasqual Valley"},
                    {"name": "Sierra Pelona Valley"},
                    {"name": "Tehachapi-Cummings Valley"},
                    {"name": "Temecula Valley"},
                    {"name": "Ventura County"},
                ],
            },
        ],
        "description": {
            "default": "",
            "sommelier": "California is a vinous paradise where sun-kissed vineyards yield an impressive array of wines, from the crisp elegance of Chardonnay to the bold richness of Cabernet Sauvignon. With its eclectic mix of grape varieties and styles, this region invites wine lovers to explore a vibrant tapestry of flavors and experiences.",
            "julie": "Much of California well suited to grape growing with its generous sunshine, its mild winters, and its generally low humidity levels that helps prevent cryptogamic diseases. The main grape growing regions lie in the central and coastal area of the state. The region is divided into 5 large American Viticultural Areas (AVAs) : North Coast, Central Coast, South Coast, San Francisco Bay, and the Sierra Foothills. The Central Valley, which produces 75% of the state’s wine, does not have an its own official AVA. Most of the fine wine districts are located near the coast, where fog and cool sea breezes mitigate temperatures and create a large diurnal swing from warm days to cool nights. California is known for producing some varietal Chardonnay, Cabernet Sauvignon, Merlot, and Zinfandel wines. However, the list is non exhaustive and producers experiments with various varieties such as Viognier, Petite Syrah and Nebbiolo. Premium blend wines, white or red, made from classical Bordeaux grape varieties are sold as “Meritage”. ",
        },
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [
            "Chardonnay",
            "Cabernet Sauvignon",
            "Merlot",
            "Zinfandel",
            "Viognier",
            "Petite Syrah",
            "Nebbiolo",
        ],
        "wine_styles": ["red", "white", "blend", "premium", "varietal"],
    },
    {
        "country": "US",
        "name": "Colorado",
        "climate_types": "continental",
        "avg_annual_rainfall": 400.0,
        "elevation_range": (1400, 2500),
        "soil_types": "sandy",
        "primary_grapes": [
            "Cabernet Sauvignon",
            "Merlot",
            "Chardonnay",
            "Syrah",
            "Zinfandel",
        ],
        "wine_styles": ["red", "white", "blend", "varietal"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of the Rockies, Colorado boasts a vibrant wine scene where high-altitude vineyards flourish, producing everything from robust reds like Syrah and Zinfandel to refreshing whites like Chardonnay. With its sandy soils and diverse climate, this region is a hidden gem for adventurous wine lovers seeking unique varietals and blends.",
        },
    },
    {
        "country": "US",
        "name": "Idaho",
        "climate_types": "continental",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (600, 1800),
        "soil_types": "volcanic",
        "primary_grapes": [
            "Riesling",
            "Cabernet Sauvignon",
            "Syrah",
            "Merlot",
            "Chardonnay",
        ],
        "wine_styles": ["red", "white", "sparkling", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of the Pacific Northwest, Idaho boasts a burgeoning wine scene where volcanic soils and varying elevations nurture an impressive array of grapes, including Riesling and Cabernet Sauvignon. With its diverse wine styles, from crisp whites to robust reds, Idaho is a hidden gem waiting to be explored by adventurous palates.",
        },
    },
    {
        "country": "US",
        "name": "Michigan",
        "climate_types": "cool_climate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (150, 300),
        "soil_types": "sandy_loam",
        "primary_grapes": ["Riesling", "Chardonnay", "Pinot Noir"],
        "wine_styles": ["white", "red", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of the Midwest, Michigan is a hidden gem for wine lovers, offering a delightful array of Riesling, Chardonnay, and Pinot Noir that thrive in its sandy loam soils and temperate climate. With a burgeoning reputation for both still and sparkling wines, this region invites you to explore its refreshing and nuanced offerings that capture the essence of the Great Lakes.",
        },
    },
    {
        "country": "US",
        "name": "Missouri",
        "climate_types": "temperate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (150, 300),
        "soil_types": "clay",
        "primary_grapes": ["Norton", "Chambourcin", "Catawba"],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of the Midwest, Missouri boasts a rich tapestry of vineyards where the bold Norton and lively Catawba thrive, producing wines that are as diverse as the landscape itself. With its clay soils and a climate that dances between warmth and moisture, this region is a hidden gem for wine lovers seeking both tradition and innovation in every sip.",
        },
    },
    {
        "country": "US",
        "name": "New Jersey",
        "climate_types": "temperate",
        "avg_annual_rainfall": 1000.0,
        "elevation_range": (0, 300),
        "soil_types": "sandy_loam",
        "primary_grapes": [
            "Cabernet Sauvignon",
            "Merlot",
            "Chardonnay",
            "Sauvignon Blanc",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of the Mid-Atlantic, New Jersey is a hidden gem for wine lovers, boasting a delightful array of wines from bold reds to crisp whites, all nurtured by its sandy loam soils and ample rainfall. With a burgeoning wine scene, this region invites you to explore its vibrant vineyards and taste the unique character of its wines.",
        },
    },
    {
        "country": "US",
        "name": "New Mexico",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 300.0,
        "elevation_range": (1200, 2400),
        "soil_types": "sandy",
        "primary_grapes": ["Chardonnay", "Cabernet Sauvignon", "Merlot", "Zinfandel"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of the Southwest, New Mexico boasts a vibrant wine scene where the sun-soaked vineyards yield everything from crisp Chardonnays to bold Cabernet Sauvignons. With its high elevation and sandy soils, this region is a hidden gem for wine lovers seeking both classic and adventurous styles, including delightful sparkling options.",
        },
    },
    {
        "country": "US",
        "name": "New York",
        "subregions": [
            {"name": "Finger Lakes"},
            {"name": "Hudson River Region"},
            {"name": "Long Island"},
        ],
        "climate_types": "temperate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 500),
        "soil_types": "sandy_loam",
        "primary_grapes": [
            "Riesling",
            "Cabernet Franc",
            "Merlot",
            "Chardonnay",
            "Pinot Noir",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling", "dessert", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "New York is a vinous treasure trove, where the crispness of Riesling dances alongside the boldness of Cabernet Franc, all nurtured by the region's sandy loam and moderate rainfall. With a spectrum of wine styles from sparkling to fortified, this region invites wine lovers to explore its rich tapestry of flavors and aromas.",
        },
    },
    {
        "country": "US",
        "name": "Oregon",
        "subregions": [{"name": "Willamette Valley"}],
        "description": {
            "default": "",
            "sommelier": "Oregon's wine country is a vibrant tapestry of rolling hills and lush vineyards, where the cool climate nurtures exquisite Pinot Noir and refreshing whites like Chardonnay and Riesling. With a commitment to both innovative and classic winemaking, this region offers a delightful array of styles, from elegant reds to sparkling gems, perfect for any palate.",
            "julie": "Oregon is one of the most successful wine regions of the United Sates. Located to the South of Washington State, it is highly influenced by the pacific ocean. The Willamette Valley, in the North West of the regions, stretches from Portland to Eugene. It is the oldest and the largest wine area of the region, with over 2/3 of Oregon’s wineries located there. The Willamette Valley AVA encompasses eleven sub-AVAs. The regions is protected from cold Pacific Ocean air and rainstorm on the west by the Coast Range mountains. The Cascade Range to the East protects the wine regions from dry, desert-like climate. The Willamette Valley is world famous for its high quality Pinot Noir wines but is also the source of delicious Chardonnay, Pinot Gris, Pinot Blanc, Riesling, etc. South of the Willamette Valley, the Southern Oregon AVA stretches from Eugene to the Californian Border and encompasses AVAs such as the Umpqua Valley, Applegate Valley and Elkton Oregon. Climate and soil varies greatly from one area to another and so do grape varieties that include Pinot Noir, Syrah, Cabernet Sauvignon, etc.",
        },
        "climate_types": "temperate",
        "avg_annual_rainfall": 1000.0,
        "elevation_range": (0, 600),
        "soil_types": "sandy_loam",
        "primary_grapes": [
            "Pinot Noir",
            "Chardonnay",
            "Pinot Gris",
            "Pinot Blanc",
            "Riesling",
            "Syrah",
            "Cabernet Sauvignon",
        ],
        "wine_styles": [
            "red",
            "white",
            "rose",
            "sparkling",
            "dessert",
            "fortified",
            "medium_bodied",
            "full_bodied",
            "oaked",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "premium",
            "reserve",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "country": "US",
        "name": "Pennsylvania",
        "climate_types": "temperate",
        "avg_annual_rainfall": 1000.0,
        "elevation_range": (100, 600),
        "soil_types": "clay",
        "primary_grapes": ["Cabernet Sauvignon", "Chardonnay", "Riesling"],
        "wine_styles": ["red", "white", "sparkling", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of the Mid-Atlantic, Pennsylvania boasts a rich tapestry of vineyards where the robust Cabernet Sauvignon meets the refreshing Riesling, all nurtured by clay soils and a temperate climate. With a delightful array of wine styles from sparkling to dessert, this region invites wine lovers to explore its hidden gems and celebrate its vinous diversity.",
        },
    },
    {
        "country": "US",
        "name": "Texas",
        "subregions": [
            {"name": "Texas High Plains"},
            {"name": "Texas Hill Country"},
            {"name": "Trans-Pecos"},
        ],
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 700.0,
        "elevation_range": (300, 1500),
        "soil_types": "clay",
        "primary_grapes": [
            "Tempranillo",
            "Cabernet Sauvignon",
            "Syrah",
            "Merlot",
            "Chardonnay",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Texas is a burgeoning wine region where the sun-soaked hills and clay soils nurture an impressive array of grape varieties, from the spicy Tempranillo to the elegant Chardonnay. With a climate that allows for both bold reds and crisp whites, Texas wines are as diverse as the state itself, inviting adventurous palates to explore its rich offerings.",
        },
    },
    {
        "country": "US",
        "name": "Virginia",
        "climate_types": "temperate",
        "avg_annual_rainfall": 1000.0,
        "elevation_range": (100, 600),
        "soil_types": "clay",
        "primary_grapes": [
            "Viognier",
            "Cabernet Franc",
            "Chardonnay",
            "Merlot",
            "Petit Verdot",
        ],
        "wine_styles": ["red", "white", "sparkling", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Virginia is a hidden gem in the wine world, where the rolling hills and clay soils nurture a delightful array of wines, from the aromatic Viognier to the bold Cabernet Franc. With a climate that dances between warmth and coolness, this region produces everything from refreshing whites to luscious dessert wines, inviting exploration and discovery.",
        },
    },
    {
        "country": "US",
        "name": "Vermont",
        "climate_types": "cool_climate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (100, 600),
        "soil_types": "clay",
        "primary_grapes": ["Marquette", "La Crescent", "Frontenac", "Baco Noir"],
        "wine_styles": ["white", "red", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the lush landscapes of New England, Vermont is a hidden gem for wine lovers, producing delightful wines from cold-hardy varieties like Marquette and La Crescent. With its clay-rich soils and a climate that dances between warmth and chill, this region crafts a diverse array of wines, from crisp whites to bold reds, perfect for any palate.",
        },
    },
    {
        "country": "US",
        "name": "Washington",
        "subregions": [{"name": "Columbia Valley"}],
        "description": {
            "default": "",
            "sommelier": "Nestled in the Pacific Northwest, Washington is a hidden gem for wine lovers, producing bold and full-bodied reds that rival the best in the world. With its sun-drenched vineyards and varied elevations, this region crafts wines that are rich in flavor and complexity, making every sip a delightful journey.",
            "julie": "Despite a relatively short history of viticulture, Washington has emerged as the nation’s second largest producer of premium wines, accounting for approximately 5% of total production. Most of the state’s wine regions, and over 99% of its vineyards, are located east of the Cascade Mountains. Columbia Valley AVA is the largest appellation in the state, covering over ¼ of Washington’s landmass. Other significant AVAs include Yakima Valley, the first AVA of the state in 1983,  Walla Walla Valley and Horse Heaven Hills. These AVAs are very successful at producing premium quality Merlot, Cabernet Sauvignon and Syrah Wines .",
        },
        "climate_types": "continental",
        "avg_annual_rainfall": 250.0,
        "elevation_range": (100, 1200),
        "soil_types": "sandy_loam",
        "primary_grapes": ["Merlot", "Cabernet Sauvignon", "Syrah"],
        "wine_styles": ["red", "premium", "full_bodied"],
    },
    {
        "country": "UY",
        "name": "Montevideo",
        "climate_types": "maritime",
        "avg_annual_rainfall": 1200.0,
        "elevation_range": (0, 100),
        "soil_types": "clay",
        "primary_grapes": ["Tannat", "Merlot", "Chardonnay"],
        "wine_styles": [
            "red",
            "white",
            "rose",
            "sparkling",
            "medium_bodied",
            "full_bodied",
            "traditional",
            "modern",
        ],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the southern coast of Uruguay, Montevideo is a vibrant wine region where the bold Tannat thrives alongside elegant Merlot and crisp Chardonnay, producing an exciting mix of traditional and modern wines that cater to every palate. With its clay soils and moderate climate, this area is quickly becoming a must-visit destination for wine enthusiasts seeking both quality and diversity.",
        },
    },
    {
        "country": "UY",
        "name": "Canelones",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 1000.0,
        "elevation_range": (0, 200),
        "soil_types": "clay",
        "primary_grapes": ["Tannat", "Merlot", "Chardonnay", "Sauvignon Blanc"],
        "wine_styles": [
            "red",
            "white",
            "rose",
            "sparkling",
            "medium_bodied",
            "full_bodied",
        ],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Uruguay, Canelones is a vibrant wine region celebrated for its rich clay soils and a delightful array of grape varieties. Here, Tannat reigns supreme, crafting bold reds, while the crisp whites of Chardonnay and Sauvignon Blanc offer a refreshing counterpoint, making Canelones a true gem for wine lovers seeking both diversity and quality.",
        },
    },
    {
        "country": "UY",
        "name": "Maldonado",
        "subregions": [{"name": "Garzón"}, {"name": "José Ignacio"}],
        "climate_types": "maritime",
        "avg_annual_rainfall": 1200.0,
        "elevation_range": (0, 200),
        "soil_types": "sandy_loam",
        "primary_grapes": ["Tannat", "Merlot", "Chardonnay"],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the picturesque landscapes of Uruguay, Maldonado boasts a unique blend of sandy loam soils and a temperate climate, producing exquisite wines that range from the bold and tannic Tannat to the crisp and elegant Chardonnay. With an average annual rainfall of 1200 mm, this region is a hidden gem for those seeking both traditional and innovative wine experiences.",
        },
    },
    {
        "country": "UY",
        "name": "Colonia",
        "climate_types": "temperate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 200),
        "soil_types": "sandy_loam",
        "primary_grapes": ["Tannat", "Merlot", "Chardonnay", "Sauvignon Blanc"],
        "wine_styles": [
            "red",
            "white",
            "rose",
            "sparkling",
            "medium_bodied",
            "full_bodied",
        ],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in a picturesque landscape, Colonia is a wine lover's paradise where the bold Tannat meets the crisp Sauvignon Blanc, creating a delightful tapestry of flavors. With its unique sandy loam soils and a climate that nurtures both red and white varietals, this region offers an exciting exploration of medium to full-bodied wines that are sure to impress.",
        },
    },
    {
        "country": "UY",
        "name": "San José",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "San José, a hidden gem in the wine world, invites adventurous palates to explore its mysterious terroir. With an enigmatic soil profile and an undiscovered array of grape varieties, this region promises delightful surprises for those willing to venture off the beaten path.",
        },
    },
    {
        "country": "AL",
        "name": "Berat",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (200, 800),
        "soil_types": "clay",
        "primary_grapes": [
            "Shesh i Bardhë",
            "Shesh i Zi",
            "Merlot",
            "Cabernet Sauvignon",
        ],
        "wine_styles": ["red", "white", "rose", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "In the enchanting region of Berat, where ancient history meets modern viticulture, the clay-rich soils and varied elevations create a perfect canvas for both indigenous and international grape varieties. Here, the unique blend of Shesh i Bardhë and Shesh i Zi alongside classic Merlot and Cabernet Sauvignon results in an exciting array of wines that are as diverse as the landscape itself.",
        },
    },
    {
        "country": "AL",
        "name": "Korça",
        "climate_types": "continental",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (400, 800),
        "soil_types": "clay",
        "primary_grapes": [
            "Shesh i Bardhë",
            "Shesh i Zi",
            "Merlot",
            "Cabernet Sauvignon",
        ],
        "wine_styles": ["red", "white", "medium_bodied", "full_bodied"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Korça is a hidden gem in Albania, where the harmonious blend of indigenous and international grape varieties flourishes in clay-rich soils, producing vibrant wines that range from refreshing whites to robust reds. With its picturesque elevation and balanced rainfall, this region invites wine lovers to discover its rich tapestry of flavors and aromas.",
        },
    },
    {
        "country": "AL",
        "name": "Leskovik",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of an undiscovered landscape, Leskovik promises a tantalizing journey for the palate, where the mystery of its soil and grape varieties invites wine lovers to explore the uncharted flavors of this enchanting region.",
        },
    },
    {
        "country": "AL",
        "name": "Lezhë",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 500),
        "soil_types": "clay",
        "primary_grapes": [
            "Shesh i Bardhë",
            "Shesh i Zi",
            "Merlot",
            "Cabernet Sauvignon",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Albania, Lezhë is a hidden gem where the indigenous Shesh i Bardhë and Shesh i Zi grapes flourish alongside classic varieties like Merlot and Cabernet Sauvignon. With its clay soils and a climate that balances warmth and moisture, this region produces an intriguing array of wines, from vibrant whites to bold reds, perfect for any palate.",
        },
    },
    {
        "country": "AL",
        "name": "Përmet",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (200, 800),
        "soil_types": "alluvial",
        "primary_grapes": ["Vranac", "Shesh i Bardhë", "Merlot", "Cabernet Sauvignon"],
        "wine_styles": [
            "red",
            "white",
            "rose",
            "sparkling",
            "medium_bodied",
            "full_bodied",
        ],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Përmet is a hidden gem in the wine world, where the lush alluvial soils and diverse elevations create a playground for both indigenous and international grape varieties. From the bold Vranac to the elegant Merlot, this region produces a delightful array of wines that cater to every palate, making it a must-visit for any wine enthusiast.",
        },
    },
    {
        "country": "AL",
        "name": "Shkoder",
        "climate_types": "temperate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Albania, Shkoder is a hidden gem waiting to be discovered, promising a canvas for innovative winemakers to craft distinctive wines that reflect its enigmatic terroir. With its rich cultural heritage and untapped potential, this region is poised to surprise and delight wine enthusiasts in the years to come.",
        },
    },
    {
        "country": "AL",
        "name": "Tirana County",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (100, 1500),
        "soil_types": "clay",
        "primary_grapes": [
            "Shesh i Bardhë",
            "Shesh i Zi",
            "Merlot",
            "Cabernet Sauvignon",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Albania, Tirana County boasts a rich tapestry of vineyards where the indigenous Shesh grapes flourish alongside classic varietals like Merlot and Cabernet Sauvignon. With its clay soils and a climate that dances between the Mediterranean and continental influences, this region produces an exciting array of wines, from vibrant whites to luscious reds and effervescent sparkling options, perfect for any palate.",
        },
    },
    {
        "country": "AT",
        "name": "Niederösterreich",
        "synonyms": ["Lower Austria", "Northeastern and eastern", "Niederosterreich"],
        "subregions": [
            {
                "name": "Kamptal",
                "description": {
                    "default": "",
                    "sommelier": "Named after the river Kamp that runs through it, the Kamptal’s principal town is Langenlois, Austria’s largest wine-producing town. Kamptal is one of the most successful wine regions in Austria, and boasts a high proportion of outstanding, high quality wine producers. Culture and tourism also enjoy particular prominence here. Since the 2008 vintage, the designation Kamptal DAC has been used to label Grüner Veltliner and Riesling produced in classic-to-middleweight styles and as dense, dry Reserve wines.",
                    "julie": "",
                },
            },
            {
                "name": "Kremstal",
                "description": {
                    "default": "",
                    "sommelier": "The vineyards in the Kremstal are divided into three distinct areas: the historic city of Krems, whose western “Stein” district borders directly with the Wachau, the Krems valley, with its thick loess nappes to the east, and finally, the small wine villages south of the Danube clustered around the imposing Göttweig Abbey. Since 2007, the Kremstal DAC designation has been synonymous with spicy Grüner Veltliner wines and elegant, mineral-driven Rieslings, which are not only produced in a fresh, classic-to-middleweight style, but also as dense Reserve wines.",
                    "julie": "",
                },
            },
            {
                "name": "Wachau",
                "description": {
                    "default": "",
                    "sommelier": "The Wachau corresponds to the stretch of the Danube valley between Melk and Krems. This wonderfully scenic part of the Austrian landscape has been declared a World Cultural Heritage site. Extraordinarily distinctive wines are produced here, some of which grow on steeply terraced hillsides. From the 2020 vintage onwards, wines produced here are able to use the designation Wachau DAC. The best vineyards here produce some of the world’s finest white wines with decades of ageing potential, especially those produced from Grüner Veltliner and Riesling grapes.",
                    "julie": "",
                },
            },
            {
                "name": "Wagram",
                "description": {
                    "default": "",
                    "sommelier": 'In this region, the vineyards are divided between two distinctly different zones. The first zone, north of the Danube, lies directly to the east of the Kamptal, where the "Wagram" (a vast terrace of land) stretches eastwards around 30 km. The second zone, south of the Danube, home to the small wine villages of the Tulln Basin, as well as the historic wine-growing town of Klosterneuburg, is just a stone\'s throw away from Vienna.',
                    "julie": "",
                },
            },
            {
                "name": "Traisental",
                "description": {
                    "default": "",
                    "sommelier": "The Traisental is one of the youngest wine-growing regions in Austria, having only existed in its present form since 1995. It is also one of the smallest in the country, but when it comes to the region’s Grüner Veltliner, the Traisental has a commanding presence. An integral part of the small wine villages here are the traditional Buschenschank taverns, but a real step back into the past is provided by the historic towns of Traismauer and Herzogenburg. Typical fruity and spicy Grüner Veltliner and robust, mineral-driven Riesling have been marketed under the Traisental DAC designation since the 2006 vintage.",
                    "julie": "",
                },
            },
            {
                "name": "Weinviertel",
                "description": {
                    "default": "",
                    "sommelier": "The Weinviertel may be a familiar name to all Austrian wine lovers, but awareness of Lower Austria’s largest wine-growing region is also growing internationally – the region covers roughly 14,000 hectares and produces a substantial variety of wines. The main driver behind this success is Grüner Veltliner, especially in the form of Weinviertel DAC and Weinviertel DAC Reserve or Große Reserve, which express the full extent of their regional typicity.",
                    "julie": "",
                },
            },
            {
                "name": "Thermenregion",
                "description": {
                    "default": "",
                    "sommelier": "The vines of the wine-growing region Thermenregion line the hillsides of the Wienerwald (Vienna Woods), stretching from the outskirts of Vienna along a ridge containing the Anninger mountain, the highest elevation south of Baden. Even today, white wine is prominent in the north of the region around Gumpoldskirchen, with a special focus on the autochthonous varieties Zierfandler (also known as Spätrot) and Rotgipfler. In the south of the region, red wine predominates with the varieties Sankt Laurent and Pinot Noir. As from 2023, “Thermenregion DAC” can be applied to the region’s red and white wines displaying regional typicity.",
                    "julie": "Baden is a large region in southern Germany. Baden covers a large area along the French border and touches the Swiss border to the south. Germany's warmest winegrowing region, Kaiserstuhl, is located in Baden. Spätburgunder and other red grapes are preferred, as the entire area is too hot for quality Riesling. Weissherbst, a local rosé wine, is a popular traditional style of the region. ",
                },
            },
            {
                "name": "Carnuntum",
                "description": {
                    "default": "",
                    "sommelier": "For many years now, archaeologists have been digging up evidence of ancient Roman culture from Carnuntum’s soils. While the ground is indeed rich in history, the region’s vines provide modern-day treasures, particularly in the form of regionally typical red wines produced from Zweigelt and Blaufränkisch. Likewise, Chardonnay, Pinot Blanc and Grüner Veltliner also deliver white DAC wines of impressive character.",
                    "julie": "",
                },
            },
        ],
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of Austria, Niederösterreich is a treasure trove of wine diversity, where the crisp, zesty Grüner Veltliner dances alongside the bold, fruity Zweigelt. With its picturesque landscapes and rich loess soils, this region crafts wines that are as captivating as the rolling hills they come from.",
            "julie": "Lower Austria, or Niederösterreich, is the largest winegrowing region in the country. Most of the vineyards are located along the path of the Danube River and its tributaries. The most planted grape varieties in the region is Grüner Veltliner. There are a total of eight subzones: Weinviertel DAC, Carnuntum DAC, Traisental DAC, Wagram DAC, Kremstal DAC, Kamptal DAC, Wachau DAC, and Thermenregion DAC.",
        },
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (150, 500),
        "soil_types": "loess",
        "primary_grapes": ["Grüner Veltliner", "Riesling", "Zweigelt", "Blaufränkisch"],
        "wine_styles": [
            "white",
            "red",
            "sparkling",
            "medium_bodied",
            "full_bodied",
            "traditional",
            "modern",
        ],
    },
    {
        "country": "AT",
        "name": "Burgenland",
        "description": {
            "default": "",
            "sommelier": "Burgenland is a treasure trove of vinous delights, where the sun-drenched vineyards yield luscious reds and exquisite dessert wines, captivating palates with their depth and character. This enchanting region invites you to explore its rich tapestry of flavors, making every sip a journey through its vibrant landscape.",
            "julie": "",
        },
        "subregions": [
            {
                "name": "Eisenberg",
                "description": {
                    "default": "",
                    "sommelier": "The southernmost part of Burgenland is home to the state’s purest and most natural viticultural landscape, stretching between Rechnitz in the north and Güssing in the south. The regionally authentic red wines, especially those made from Blaufränkisch with the protected designation of origin Eisenberg DAC , are characterised by a particular mineral spiciness. Elegant, spicy white wines, particularly Welschriesling, set the tone, as does the ancient speciality here, Uhudler.",
                    "julie": "",
                },
            },
            {
                "name": "Leithaberg",
                "description": {
                    "default": "",
                    "sommelier": "The Leitha Range is home to the good all-rounders. Hardly any other wine-growing region has such a variety of wine types as those grown on the western banks of Lake Neusiedl. Leithaberg DAC wines can be red or white, and always display the minerality, dynamic tension and vibrancy that is typical of the region.",
                    "julie": "",
                },
            },
            {
                "name": "Mittelburgenland",
                "description": {
                    "default": "",
                    "sommelier": "In the vineyards of the Mittelburgenland wine-growing region, Blaufränkisch takes centre stage and articulates its origins perfectly in the region’s DAC wines. Four municipalities set the tone: Deutschkreutz, Horitschon, Lutzmannsburg and Neckenmarkt. Mittelburgenland is also known as “Blaufränkischland”, due to it being Austira’s key wine-growing region for this grape variety.",
                    "julie": "",
                },
            },
            {
                "name": "Neusiedlersee",
                "description": {
                    "default": "",
                    "sommelier": "Austria’s Neusiedlersee wine-growing region, situated to the east of Lake Neusiedl, stretches from the hills and the wine capital of Gols, over the flat Heideboden, and down to the melancholic Seewinkel area. The vineyards on the banks of Lake Neusiedl – a shallow steppe lake – are home to a wealth of different grape varieties. The Neusiedlersee DAC has been recognised since the 2012 vintage and is synonymous with fruity, harmonious red Zweigelt wines that reflect the region’s climate and soil. This designation of origin also includes a Reserve category.",
                    "julie": "",
                },
            },
            {
                "name": "Rosalia",
                "description": {
                    "default": "",
                    "sommelier": "The Rosalia wine-growing region is situated on the eastern slope of the Rosalia Mountains, which extend along the border between Lower Austria and Burgenland. The Pannonian climate and loam soils offer perfect conditions for growing Blaufränkisch and Zweigelt, the region’s two most prominent grape varieties.",
                    "julie": "Burgenland produces some of Austria’s best red and sweet white wines. Burgenland borders Hungary, and shares many viticultural and climactic traits with regions just across the border. The hot continental, Pannonian climate in Burgenland is tempered by the cooling influence of the Neusiedlersee lake. Blaufränkisch is the most planted red grape. Zweigelt has significant acreage and St. Laurent is being cultivated with increasing frequency. Burgunland includes the following DACs : Mittleburgenland, Leithaberg, Eisenberg, Neusiedlersee, Rosalia and Ruster Ausbrusch – a DAC dedicated to the production of sweet wines made from botrytised berries. ",
                },
            },
        ],
        "climate_types": "continental",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": ["red", "white", "dessert"],
    },
    {
        "country": "AT",
        "name": "Steiermark",
        "synonyms": ["Styria"],
        "subregions": [
            {
                "name": "Südsteiermark",
                "description": {
                    "default": "",
                    "sommelier": "Südsteiermark is reputed for fresh, fragrant wines, especially those produced using the region’s flagship variety, Sauvignon Blanc. However, Südsteiermark accommodates a wide assortment of other grape varieties, including Welschriesling, Morillon \xad(Chardonnay), Muskateller and Traminer. Despite this being one of Europe’s most picturesque viticultural regions, the extremely steep gradient of most vineyards make winegrowing here a significant challenge.",
                    "julie": "",
                },
            },
            {
                "name": "Vulkanland Steiermark",
                "description": {
                    "default": "",
                    "sommelier": "The Vulkanland Steiermark wine-growing region is characterised by many small viticultural enclaves. Here, vineyards stretch up the sides of extinct volcanoes, giving the landscape a truly unique character. The vineyards cultivated in this region are concentrated around Klöch, St. Anna am Aigen and Straden. One grape variety here holds particular appeal: the highly aromatic Traminer. Traditional Buschenschank taverns are the sales channel of choice for this region’s wines.",
                    "julie": "",
                },
            },
            {
                "name": "Weststeiermark",
                "description": {
                    "default": "",
                    "sommelier": "Weststeiermark may only have approximately 660 hectares of land under vine, but the wine-growing families here cultivate them diligently to create an astonishing variety of products: polished white wines from numerous grape varieties, as well as the zesty, acidic Schilcher which is the undisputed star of the region. Internationally recognised as a regional speciality, this unique rosé terroir wine is vinified from Blauer Wildbacher grapes, which are the predominant local variety.",
                    "julie": "",
                },
            },
        ],
        "description": {
            "default": "",
            "sommelier": "Nestled in the rolling hills of Austria, Steiermark (Styria) enchants wine lovers with its crisp, aromatic whites that reflect the region's cool climate and diverse terroir. This hidden gem is a must-visit for those seeking to explore the vibrant flavors and stunning landscapes of Austrian viticulture.",
            "julie": "",
        },
        "climate_types": "temperate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
    },
    {
        "country": "AT",
        "name": "Wien",
        "synonyms": ["Vienna"],
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of Austria, Wien is a charming wine region where the crisp, zesty notes of Grüner Veltliner dance on the palate, perfectly embodying the spirit of Vienna's vibrant culture. With its loess-rich soils and a delightful blend of traditional and modern winemaking, this area offers a refreshing escape for wine lovers seeking both elegance and authenticity.",
            "julie": "",
        },
        "climate_types": "temperate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (150, 300),
        "soil_types": "loess",
        "primary_grapes": ["Grüner Veltliner", "Welschriesling", "Riesling"],
        "wine_styles": ["white", "blend", "traditional"],
    },
    {
        "country": "AT",
        "name": "Bergland",
        "description": {
            "default": "",
            "sommelier": "Nestled between 200 to 1000 meters in elevation, Bergland is a hidden gem where the clay soils nurture the crisp, refreshing Grüner Veltliner and the bold, fruity Zweigelt. With an average annual rainfall of 800 mm, this region crafts wines that are as dynamic as its landscape, offering a delightful exploration of both red and white styles.",
            "julie": "",
        },
        "climate_types": "continental",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (200, 1000),
        "soil_types": "clay",
        "primary_grapes": ["Grüner Veltliner", "Zweigelt"],
        "wine_styles": ["red", "white"],
    },
    {
        "country": "BE",
        "name": "Côtes de Sambre et Meuse",
        "synonyms": ["Sambre et Meuse", "Côtes de Sambre et Meuse"],
        "description": {
            "default": "",
            "sommelier": "Nestled along the banks of the Sambre and Meuse rivers, the Côtes de Sambre et Meuse enchants with its clay-rich soils that nurture vibrant grape varieties, promising wines that reflect the region's unique terroir. This hidden gem invites wine lovers to explore its charming landscapes and discover the delightful flavors that emerge from its fertile grounds.",
            "julie": "",
        },
        "climate_types": "temperate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "clay",
        "primary_grapes": [],
        "wine_styles": [],
    },
    {
        "country": "BE",
        "name": "Hagelandse wijn",
        "synonyms": ["Hageland"],
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of Belgium, Hagelandse wijn is a hidden gem where innovative winemakers craft delightful wines that capture the essence of the region's diverse landscape. With a focus on quality and character, this area is slowly gaining recognition for its unique offerings that are sure to surprise and delight wine enthusiasts.",
            "julie": "",
        },
        "climate_types": "temperate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
    },
    {
        "country": "BE",
        "name": "Haspengouw",
        "synonyms": ["Hesbaye", "Haspengauw"],
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of Belgium, Haspengouw is a hidden gem where the rich marl soil nurtures vibrant grape varieties, resulting in wines that are both expressive and delightful. This charming region, with its picturesque landscapes, invites wine lovers to explore its unique offerings and discover the essence of Belgian viticulture.",
            "julie": "",
        },
        "climate_types": "temperate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "marl",
        "primary_grapes": [],
        "wine_styles": [],
    },
    {
        "country": "BE",
        "name": "Heuvelland",
        "description": {
            "default": "",
            "sommelier": "Nestled in the picturesque landscape, Heuvelland is a hidden gem celebrated for its effervescent creations, where each sip captures the essence of its rolling hills and cool climate. The light-bodied sparkling wines from this region are a delightful treat, perfect for toasting life's special moments.",
            "julie": "",
        },
        "climate_types": "temperate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": ["sparkling", "light_bodied"],
    },
    {
        "country": "BA",
        "name": "Čapljina",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 500),
        "soil_types": "alluvial",
        "primary_grapes": ["Vranac", "Blatina", "Chardonnay", "Merlot"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Bosnia and Herzegovina, Čapljina is a vibrant wine region where the indigenous Vranac and Blatina grapes flourish alongside international favorites like Chardonnay and Merlot, producing an exciting array of wines that cater to every palate. With its lush landscapes and a commitment to quality, this region invites wine lovers to explore its unique offerings, from bold reds to elegant sparkling wines.",
        },
    },
    {
        "country": "BA",
        "name": "Čitluk",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (200, 400),
        "soil_types": "clay",
        "primary_grapes": ["Blatina", "Žilavka"],
        "wine_styles": ["red", "white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "In the heart of Bosnia and Herzegovina, Čitluk is a hidden gem where the robust Blatina and crisp Žilavka grapes thrive in clay-rich soils, yielding wines that are as vibrant and diverse as the region itself. With its moderate climate and stunning landscapes, this area invites wine lovers to explore its rich flavors and heritage.",
        },
    },
    {
        "country": "BA",
        "name": "Ljubuški",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "limestone",
        "primary_grapes": ["Vranac", "Zlahtina"],
        "wine_styles": ["red", "white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Bosnia and Herzegovina, Ljubuški is a hidden gem where the limestone soils nurture the bold Vranac and the elegant Zlahtina, resulting in wines that are both vibrant and full of personality. Whether you're savoring a deep red or a crisp white, each sip transports you to the sun-drenched vineyards of this enchanting region.",
        },
    },
    {
        "country": "BA",
        "name": "Međugorje",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (200, 600),
        "soil_types": "limestone",
        "primary_grapes": ["Vranac", "Zlahtina", "Chardonnay", "Merlot"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Discover the enchanting wines of Međugorje, where the limestone-rich soils and gentle elevations nurture a delightful blend of indigenous and international grape varieties, resulting in captivating reds, whites, and rosés that reflect the region's unique terroir.",
        },
    },
    {
        "country": "BA",
        "name": "Mostar",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (100, 500),
        "soil_types": "limestone",
        "primary_grapes": ["Vranac", "Blatina"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Mostar is a captivating wine region where the ancient limestone soils and a temperate climate converge to produce exquisite wines. With its signature grapes, Vranac and Blatina, this area offers a delightful exploration of rich reds and vibrant whites that reflect the heart and soul of the Balkans.",
        },
    },
    {
        "country": "BA",
        "name": "Stolac",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "limestone",
        "primary_grapes": ["Vranac", "Žilavka"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Bosnia and Herzegovina, Stolac is a captivating wine region where the limestone soil nurtures the bold Vranac and the crisp Žilavka, resulting in a delightful array of wines that celebrate both tradition and innovation.",
        },
    },
    {
        "country": "BA",
        "name": "Trebinje",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 500),
        "soil_types": "limestone",
        "primary_grapes": ["Vranac", "Zlahtina", "Chardonnay", "Merlot"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Bosnia and Herzegovina, Trebinje is a wine lover's paradise where the limestone soils and varied elevations create a perfect playground for grapes like Vranac and Zlahtina. Whether you're sipping a bold red or a crisp white, each glass tells the story of this enchanting region's rich heritage and vibrant terroir.",
        },
    },
    {
        "country": "BG",
        "name": "Black Sea",
        "climate_types": "temperate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 500),
        "soil_types": "clay",
        "primary_grapes": [
            "Mavrud",
            "Cabernet Sauvignon",
            "Merlot",
            "Chardonnay",
            "Sauvignon Blanc",
        ],
        "wine_styles": [
            "red",
            "white",
            "rose",
            "sparkling",
            "medium_bodied",
            "full_bodied",
        ],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the picturesque shores of the Black Sea, this region boasts a delightful blend of indigenous and international grape varieties, producing everything from bold reds to elegant whites. With its clay soils and moderate rainfall, the Black Sea is a hidden gem for wine lovers seeking both tradition and innovation in every sip.",
        },
    },
    {
        "country": "BG",
        "name": "Danubian Plain",
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 200),
        "soil_types": "alluvial",
        "primary_grapes": ["Cabernet Sauvignon", "Merlot", "Chardonnay", "Mavrud"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Bulgaria, the Danubian Plain is a vinous treasure trove where the lush alluvial soils nurture a delightful medley of grapes, from the bold Cabernet Sauvignon to the indigenous Mavrud. With a climate that dances between refreshing rains and warm sunshine, this region crafts an array of wines that tantalize the palate, including vibrant reds, crisp whites, and even sparkling delights.",
        },
    },
    {
        "country": "BG",
        "name": "Rose Valley",
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (200, 400),
        "soil_types": "clay",
        "primary_grapes": ["Chardonnay", "Cabernet Sauvignon", "Merlot", "Mavrud"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled between gentle hills, Rose Valley is a charming wine region where clay soils nurture a delightful array of grapes, including Chardonnay and Mavrud. With its unique climate and diverse wine styles, from crisp whites to bold reds, this valley is a hidden gem for wine lovers seeking both quality and variety.",
        },
    },
    {
        "country": "BG",
        "name": "Thrace",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 300),
        "soil_types": "clay",
        "primary_grapes": ["Merlot", "Cabernet Sauvignon", "Chardonnay", "Mavrud"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Bulgaria, Thrace is a vibrant wine region where the ancient art of winemaking meets modern techniques, producing exquisite wines that range from bold reds to elegant whites. With its unique blend of international varieties and local treasures like Mavrud, Thrace invites you to explore its rich flavors and captivating terroir.",
        },
    },
    {
        "country": "BG",
        "name": "Valley of the Struma River",
        "synonyms": ["Struma River Valley"],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 500),
        "soil_types": "alluvial",
        "primary_grapes": [
            "Mavrud",
            "Pamid",
            "Merlot",
            "Cabernet Sauvignon",
            "Chardonnay",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the picturesque Struma River, this vibrant valley is a treasure trove for wine lovers, showcasing a delightful array of wines from bold Mavrud to crisp Chardonnay. With its fertile alluvial soils and a climate that nurtures both red and white varietals, the Valley of the Struma River is a captivating destination for those seeking to explore the rich tapestry of Bulgarian winemaking.",
        },
    },
    {
        "country": "HR",
        "name": "Continental Croatia",
        "subregions": [
            {"name": "Moslavina"},
            {"name": "Plešivica"},
            {"name": "Podunavlje"},
            {"name": "Pokuplje"},
            {"name": "Prigorje"},
            {"name": "Slavonia"},
            {"name": "Zagorje"},
        ],
        "climate_types": "continental",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Croatia, Continental Croatia is a hidden gem where diverse soils and a continental climate come together to create wines that are both expressive and unique. This region invites adventurous wine lovers to explore its potential, promising delightful surprises in every bottle.",
        },
    },
    {
        "country": "HR",
        "name": "Littoral Croatia",
        "subregions": [
            {"name": "Croatian Coast"},
            {"name": "Dalmatian Interior"},
            {"name": "Central and South"},
            {"name": "Northern"},
            {"name": "Istria"},
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 1000),
        "soil_types": "limestone",
        "primary_grapes": ["Malvasia", "Teran", "Plavac Mali", "Grasevina"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the picturesque Adriatic coast, Littoral Croatia is a hidden gem where limestone soils and a Mediterranean climate give rise to a delightful array of wines, from the bold and fruity Plavac Mali to the aromatic Malvasia. This region's diverse offerings, including red, white, rosé, and sparkling wines, promise to enchant any wine lover's palate.",
        },
    },
    {
        "country": "CY",
        "name": "Commandaria",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (400, 800),
        "soil_types": "limestone",
        "primary_grapes": ["Xynisteri", "Mavro"],
        "wine_styles": ["dessert", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the sun-kissed hills of Cyprus, Commandaria is a treasure trove of luscious dessert wines, where the ancient Xynisteri and Mavro grapes flourish in limestone-rich soils. With a legacy steeped in history, each sip of Commandaria transports you to a time when wine was revered as the nectar of the gods.",
        },
    },
    {
        "country": "CY",
        "name": "Laona",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 550.0,
        "elevation_range": (0, 1500),
        "soil_types": "clay",
        "primary_grapes": ["Xynisteri", "Mavro"],
        "wine_styles": ["red", "white", "sparkling", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Cyprus, Laona is a hidden gem where the clay soils and varying elevations create a playground for winemakers. Here, the indigenous Xynisteri and Mavro grapes flourish, resulting in an exciting array of wines that range from crisp whites to luscious dessert styles, all reflecting the region's rich heritage and vibrant character.",
        },
    },
    {
        "country": "CY",
        "name": "Vouni Panagias – Ambelitis",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (300, 800),
        "soil_types": "clay",
        "primary_grapes": ["Xynisteri", "Maratheftiko"],
        "wine_styles": ["red", "white", "traditional"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the picturesque hills of Cyprus, Vouni Panagias – Ambelitis is a hidden gem where the indigenous Xynisteri and Maratheftiko grapes thrive in clay soils, yielding vibrant whites and robust reds that tell the story of this enchanting landscape.",
        },
    },
    {
        "country": "CY",
        "name": "Krasochoria Lemesou",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (300, 800),
        "soil_types": "limestone",
        "primary_grapes": ["Xynisteri", "Mavro", "Chardonnay", "Cabernet Sauvignon"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Krasochoria Lemesou is a hidden gem in Cyprus, where the limestone-rich soils and moderate elevation create a perfect playground for both indigenous and international grape varieties. Here, the sun-kissed vineyards yield everything from crisp whites to bold reds, making it a delightful destination for wine lovers seeking diversity and character in every sip.",
        },
    },
    {
        "country": "CY",
        "name": "Pitsilia",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (600, 1200),
        "soil_types": "clay",
        "primary_grapes": ["Xynisteri", "Mavro"],
        "wine_styles": ["red", "white", "sparkling", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Pitsilia is a hidden gem in Cyprus, where the high elevations and clay-rich soils nurture the indigenous Xynisteri and Mavro grapes, resulting in a delightful array of wines that tantalize the palate. Whether you're sipping a crisp white or indulging in a rich red, this region offers a taste of Cypriot heritage in every glass.",
        },
    },
    {
        "country": "CY",
        "name": "Diarizos Valley",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (200, 800),
        "soil_types": "limestone",
        "primary_grapes": ["Xynisteri", "Mavro", "Maratheftiko"],
        "wine_styles": ["white", "red", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Cyprus, the Diarizos Valley is a treasure trove of wine diversity, where the limestone soils nurture the unique flavors of Xynisteri and Mavro. This enchanting region produces everything from refreshing whites to elegant sparkling wines, inviting you to explore its rich vinous tapestry.",
        },
    },
    {
        "country": "CZ",
        "name": "Moravia",
        "subregions": [
            {"name": "Mikulov"},
            {"name": "Slovácko"},
            {"name": "Velké Pavlovice"},
            {"name": "Znojmo"},
        ],
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (150, 400),
        "soil_types": "clay",
        "primary_grapes": [
            "Veltlínské zelené",
            "Ryzlink rýnský",
            "Sauvignon blanc",
            "Frankovka",
            "Svatovavřinecké",
        ],
        "wine_styles": [
            "red",
            "white",
            "rose",
            "sparkling",
            "medium_bodied",
            "full_bodied",
        ],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of the Czech Republic, Moravia is a treasure trove of wine diversity, where the clay soils nurture exquisite Veltlínské zelené and Ryzlink rýnský, alongside bold reds like Frankovka. This enchanting region offers a delightful spectrum of wine styles, from refreshing whites to elegant sparkling wines, perfect for any palate.",
        },
    },
    {
        "country": "CZ",
        "name": "Bohemia",
        "subregions": [{"name": "Litoměřice"}, {"name": "Mělník"}],
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (150, 400),
        "soil_types": "clay",
        "primary_grapes": [
            "Müller-Thurgau",
            "Riesling",
            "Sauvignon Blanc",
            "Pinot Noir",
        ],
        "wine_styles": ["white", "red", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of the Czech Republic, Bohemia is a hidden gem for wine lovers, offering a delightful array of wines from crisp Müller-Thurgau to sophisticated Pinot Noir. With its clay soils and a climate that nurtures both white and red varietals, this region promises a tasting experience that is as rich in history as it is in flavor.",
        },
    },
    {
        "country": "CZ",
        "name": "Prague",
        "subregions": [
            {"name": "Gazebo at Gröbe's Villa"},
            {"name": "St. Clare's"},
            {"name": "St. Wenceslas' Vineyard at Prague castle"},
            {"name": "Salabka, Troja"},
        ],
        "climate_types": "continental",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Europe, Prague's wine scene is a delightful tapestry of tradition and modernity, where local winemakers experiment with diverse grape varieties to create unique wines that echo the city's vibrant history. As you stroll through its charming streets, you may just stumble upon a hidden vineyard producing delightful sips that capture the essence of this enchanting city.",
        },
    },
    {
        "country": "FR",
        "name": "Alsace",
        "synonyms": ["Elsass", "Elsaß", "Elzas", "Haut-Rhin", "Bas-Rhin"],
        "description": {
            "default": "",
            "sommelier": "Alsace is a picturesque region where the sun-kissed vineyards thrive on granite soils, producing some of the world's most aromatic white wines. With a delightful array of varietals like Riesling and Gewürztraminer, this enchanting locale is a must-visit for any wine lover seeking both elegance and complexity in their glass.",
            "julie": "Alsace is divided into two zones, Haut-Rhin and Bas-Rhin. The region is separated from the rest of France by the Vosges Mountains in the west. The mountains provide a rain shadow effect, and as a result, Alsace is one of France’s driest and sunniest climates. Colmar, capital of the Haut-Rhin département, is the driest city in France. The vineyards of Alsace is a long, narrow vineyard that runs along the lower slopes and foothills of the Vosges, and the exact aspect and location of each vineyard is of importance in this semi-continental climate. Alsatian vineyards have myriad soil types : granite, limestone, schist, clay, gravel, chalk, loess, and a local pink sandstone called grés de Vosges. 90% of the wine production in Alsace is white and the region is planted with Riesling, Pinot Gris, Muscat, Gewürztraminer, Pinot Blanc, Chasselas, Sylvaner and Savagnin Rose. The only red grape permitted in the region for AOP wines is Pinot Noir. Since 1975, fifty-one vineyards of exception have been elevated to a Grand Cru AOP status. Alsace is famous for the quality of its sweet wines which can be labelled as “VT” Vendanges Tardives, meaning late harvests, and as “SGN” Sélection de Grains Nobles, translating as selection of noble berries. ",
        },
        "climate_types": "semi_desert",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "granite",
        "primary_grapes": [
            "Riesling",
            "Pinot Gris",
            "Muscat",
            "Gewürztraminer",
            "Pinot Blanc",
            "Chasselas",
            "Sylvaner",
            "Savagnin Rose",
            "Pinot Noir",
        ],
        "wine_styles": ["white", "dessert"],
    },
    {
        "country": "FR",
        "name": "Charentais",
        "synonyms": ["Charente", "Charentes", "Charente-Maritime"],
        "subregions": [{"name": "Cognac"}, {"name": "Pineau des Charentes"}],
        "climate_types": "maritime",
        "avg_annual_rainfall": 700.0,
        "elevation_range": (0, 200),
        "soil_types": "clay",
        "primary_grapes": ["Ugni Blanc", "Folle Blanche", "Colombard"],
        "wine_styles": ["white", "fortified", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of France, the Charentais region is a charming blend of tradition and innovation, where the crisp notes of Ugni Blanc dance alongside the rich heritage of fortified and sparkling wines. With its clay-rich soils and a climate that nurtures vibrant flavors, Charentais is a must-visit for those seeking to explore the elegance of French viticulture.",
        },
    },
    {
        "country": "FR",
        "name": "Bordeaux",
        "synonyms": ["Bordelais", "Bordo"],
        "subregions": [
            {"name": "Barsac"},
            {"name": "Entre-Deux-Mers"},
            {"name": "Fronsac"},
            {"name": "Graves"},
            {"name": "Haut-Médoc"},
            {"name": "Margaux"},
            {"name": "Médoc"},
            {"name": "Pauillac"},
            {"name": "Pessac-Léognan"},
            {"name": "Pomerol", "synonyms": ["Lalande-de-Pomerol'"]},
            {
                "name": "Saint-Émilion",
                "subregions": [
                    {"name": "Lussac-Saint-Emilion", "synonyms": ["Lussac"]},
                    {"name": "Montagne-Saint-Emilion", "synonyms": ["Montagne"]},
                    {"name": "Puisseguin-Saint-Emilion", "synonyms": ["Puisseguin"]},
                    {"name": "Saint-Emilion Grand Cru"},
                    {
                        "name": "Saint-Georges-Saint-Emilion",
                        "synonyms": ["Saint-Georges"],
                    },
                ],
            },
            {"name": "Saint-Estèphe", "synonyms": ["Saint-Estephe"]},
            {"name": "Saint-Julien"},
            {"name": "Sauternes"},
        ],
        "description": {
            "default": "",
            "sommelier": "Bordeaux, the jewel of French viticulture, is a symphony of flavors where Cabernet Sauvignon and Merlot dance in harmony, producing age-worthy reds that are the envy of the world. With its picturesque vineyards nestled on gravelly soils and a climate that nurtures both bold reds and crisp whites, Bordeaux is a must-visit for any wine lover seeking to indulge in the art of winemaking.",
            "julie": "The region of Bordeaux is France's second largest region of production by volume behind the Languedoc region and as approximatively 115,000 hectares of vines planted. The region is located near the Atlantic ocean and is crossed by the Dordogne and the Garonne River that meets to form the Estuary of Gironde. The most planted grape varieties of Bordeaux are : Cabernet Sauvignon, Merlot, Cabernet Franc, Petit Verdot, Malbec, and Carmènere. Cabernet Sauvignon is known to thrive on the left bank of the Garonne River in the well drained soils of the Médoc and Graves areas. Merlot and Cabernet Franc have been historically more suited on the right bank of the Dordogne River where they produce the prestigious appellations of Saint Emilion and Pomerol.  Sauvignon blanc and Sémillon are commonly blended to produce the dry wines of the regions that range in style from light, inexpensive and fruity to complex and age-worthy on regions such as Pessac-Léognan. Sémillon is also the main player for the production of the iconic botrytised sweet wines of Sauternes and Barsac. ",
        },
        "climate_types": "maritime",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 100),
        "soil_types": "gravel",
        "primary_grapes": [
            "Cabernet Sauvignon",
            "Merlot",
            "Cabernet Franc",
            "Petit Verdot",
            "Malbec",
            "Carmènere",
            "Sauvignon Blanc",
            "Sémillon",
        ],
        "wine_styles": [
            "red",
            "white",
            "rose",
            "sparkling",
            "dessert",
            "fortified",
            "medium_bodied",
            "full_bodied",
            "age_worthy",
        ],
    },
    {
        "country": "FR",
        "name": "South West France",
        "synonyms": ["Sud-Ouest"],
        "subregions": [
            {
                "name": "Garonne",
                "synonyms": ["Tarn-et-Garonne"],
                "subregions": [{"name": "Cahors"}],
            },
            {
                "name": "Bergerac & Dordogne",
                "synonyms": ["Bergeracois", "Bergerac", "Dordogne"],
                "subregions": [
                    {"name": "Monbazillac"},
                    {"name": "Pécharmant"},
                    {"name": "Rosette"},
                ],
            },
            {
                "name": "Gascogne",
                "synonyms": ["Gascony"],
                "subregions": [
                    {"name": "Armagnac"},
                    {"name": "Côtes de Gascogne"},
                    {"name": "Tursan"},
                    {"name": "Béarn"},
                    {"name": "Jurançon"},
                    {"name": "Madiran"},
                ],
            },
        ],
        "climate_types": "temperate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 500),
        "soil_types": "clay",
        "primary_grapes": [
            "Merlot",
            "Cabernet Sauvignon",
            "Sauvignon Blanc",
            "Malbec",
            "Chenin Blanc",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "South West France is a treasure trove of vinous delights, where the clay-rich soils nurture a medley of grapes like Merlot and Malbec, resulting in everything from bold reds to elegant whites and sparkling wines. This region's diverse climate and rich heritage make it a captivating destination for those seeking to explore the multifaceted world of French wine.",
        },
    },
    {
        "country": "FR",
        "name": "Burgundy",
        "synonyms": ["Bourgogne"],
        "subregions": [
            {"name": "Chablis"},
            {
                "name": "Côte Chalonnaise",
                "subregions": [
                    {"name": "Givry"},
                    {"name": "Mercurey"},
                    {"name": "Montagny"},
                    {"name": "Bouzeron"},
                    {"name": "Rully"},
                ],
            },
            {
                "name": "Côte d'Or",
                "subregions": [
                    {
                        "name": "Côte de Beaune",
                        "subregions": [
                            {"name": "Aloxe-Corton"},
                            {"name": "Auxey-Duresses"},
                            {"name": "Beaune"},
                            {"name": "Chassagne-Montrachet"},
                            {"name": "Meursault"},
                            {"name": "Santenay"},
                            {"name": "Puligny-Montrachet"},
                            {"name": "Volnay"},
                            {"name": "Pommard"},
                            {"name": "Saint-Aubin"},
                        ],
                    },
                    {
                        "name": "Côte de Nuits",
                        "subregions": [
                            {"name": "Chambolle-Musigny"},
                            {"name": "Gevrey-Chambertin"},
                            {"name": "Nuits-Saint-Georges"},
                            {"name": "Vosne-Romanée"},
                            {"name": "Morey-Saint-Denis"},
                            {"name": "Fixin"},
                            {"name": "Marsannay"},
                        ],
                    },
                ],
            },
            {"name": "Mâconnais", "subregions": [{"name": "Pouilly-Fuissé"}]},
            {
                "name": "Beaujolais",
                "subregions": [
                    {
                        "name": "Beaujolais Villages",
                        "synonyms": ["Beaujolais-Villages"],
                    },
                    {
                        "name": "Beaujolais Crus",
                        "synonyms": ["Cru Beaujolais"],
                        "subregions": [
                            {"name": "Brouilly"},
                            {"name": "Chénas"},
                            {"name": "Chiroubles"},
                            {"name": "Côte de Brouilly"},
                            {"name": "Fleurie"},
                            {"name": "Juliénas"},
                            {"name": "Morgon"},
                            {"name": "Moulin-à-Vent"},
                            {"name": "Régnié"},
                            {"name": "Saint-Amour"},
                        ],
                    },
                ],
            },
        ],
        "description": {
            "default": "",
            "sommelier": "Burgundy is a wine lover's paradise, where the delicate dance of Pinot Noir and Chardonnay unfolds in every glass, showcasing the region's rich clay soils and a climate that nurtures elegance and depth. With a history steeped in tradition, each bottle tells a story of terroir and craftsmanship that is simply irresistible.",
            "julie": "Burgundy streches over 230km between Macon and Auxerre and covers just over 30,000ha of vines. The two iconic grape varities of the region are Pinot Noir for the red wines and Chardonnay for the whites. However, in recent years, Aligoté has also started to build a reputation for itself. Burgundy is divided into four main areas, from North to South : Chablis, Côte de Nuits, Côte de Beaune and Maconnais. ",
        },
        "climate_types": "continental",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (200, 400),
        "soil_types": "clay",
        "primary_grapes": ["Pinot Noir", "Chardonnay", "Aligoté"],
        "wine_styles": ["red", "white", "traditional"],
    },
    {
        "country": "FR",
        "name": "Champagne",
        "description": {
            "default": "",
            "sommelier": "Nestled in the northeastern corner of France, Champagne is a sparkling wine lover's paradise, where the interplay of chalky soils and a cool climate creates effervescent masterpieces. With a trio of grape stars—Pinot Noir, Pinot Meunier, and Chardonnay—this region crafts wines that are synonymous with celebration and elegance.",
            "julie": "The region of Champagne is located in Northern France, 150km East of Paris and is internationally acclaimed for its production of high quality sparkling wines made by traditionnal method, locally known as Champagne method. The region is divided into 5 main areas called : Montagne de Reims, Côte des Blancs, Valais de la Marne, Sézannais and Aube region. The most planted grape varities are Pinot Noir, Pinot Meunier and Chardonnay. Today, the region also produces some still wines white and red sold under the Côteaux Champenois AOP as well as some still rosé wines produces in Les Riceys area and sols as Rosé des Riceys AOP. ",
        },
        "subregions": [
            {"name": "Montagne de Reims", "synonyms": ["Reims"]},
            {"name": "Côte des Blancs"},
            {"name": "Vallée de la Marne"},
            {"name": "Côte des Bar"},
            {"name": "Côte de Sézanne", "synonyms": ["Sézannais"]},
            {"name": "Côte des Riceys"},
            {"name": "Aube"},
        ],
        "climate_types": "cool_climate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (90, 300),
        "soil_types": "chalk",
        "primary_grapes": ["Pinot Noir", "Pinot Meunier", "Chardonnay"],
        "wine_styles": ["sparkling", "white", "red", "rose"],
    },
    {
        "country": "FR",
        "name": "Corsica",
        "subregions": [
            {"name": "Ajaccio"},
            {"name": "Cap Course"},
            {"name": "Patrimonio"},
            {
                "name": "Vin de Corse",
                "subregions": [
                    {"name": "Calvi"},
                    {"name": "Figari"},
                    {"name": "Porto-Vecchio"},
                    {"name": "Sartène"},
                ],
            },
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 1200),
        "soil_types": "limestone",
        "primary_grapes": ["Nielluccio", "Vermentino", "Sciaccarellu"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Corsica is a captivating wine region where the rugged beauty of limestone hills meets the azure Mediterranean, producing vibrant wines that reflect its rich heritage. With a delightful array of styles, from the bold Nielluccio reds to the crisp Vermentino whites, Corsica invites you to explore its enchanting flavors and sun-kissed landscapes.",
        },
    },
    {
        "country": "FR",
        "name": "Jura",
        "description": {
            "default": "",
            "sommelier": "Nestled between Burgundy and Switzerland, the Jura region is a treasure trove of wine diversity, where the ancient limestone soils nurture exquisite Savagnin and Trousseau grapes, resulting in wines that are both complex and captivating. From the zesty whites to the charming reds, Jura's offerings are a delightful exploration of tradition and terroir.",
            "julie": "The Jura is located just South of Alsace and to the East of Burgundy. The region’s vineyards are found on the mountains’ lower slopes and the climate is continental, turning harshly cold in the wintertime. Vin Jaune, a local speciality made from the Savagnin blanc grape (called locally Naturé), is aged under a layer of yeasts called “fleur” for over 6 years before being bottled. It is sold in a traditional 62cl bottle called Clavelin and is reminiscent of Fino sherries in terms of flavours. The region also produces some high quality white, red and sweet wines (Vin de Paille) from Chardonnay, Naturé, Pinot Noir, Trousseau and Poulsard.",
        },
        "climate_types": "continental",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "limestone",
        "primary_grapes": [
            "Savagnin blanc",
            "Chardonnay",
            "Pinot Noir",
            "Trousseau",
            "Poulsard",
        ],
        "wine_styles": ["white", "red", "dessert"],
    },
    {
        "country": "FR",
        "name": "Languedoc-Roussillon",
        "synonyms": ["Languedoc", "Roussillon", "Languedoc Roussillon"],
        "subregions": [
            {"name": "Pinet", "synonyms": ["Picpoul de Pinet"]},
            {"name": "Terrasses du Larzac", "synonyms": ["Larzac"]},
            {"name": "Banyuls", "synonyms": ["Banyuls Grand Cru", "Banyuls Rimage"]},
            {"name": "Cabardès"},
            {"name": "Collioure"},
            {"name": "Corbières"},
            {"name": "Côtes du Roussillon"},
            {"name": "Fitou"},
            {
                "name": "Limoux",
                "synonyms": ["Blanquette de Limoux", "Crémant de Limoux"],
            },
            {"name": "Maury"},
            {"name": "Minervois"},
            {"name": "Rivesaltes"},
            {"name": "Saint-Chinian"},
            {"name": "Cévennes", "synonyms": ["Vin De Pays des Cévennes"]},
            {"name": "Côtes Catalanes", "synonyms": ["Cotes Catalanes"]},
        ],
        "description": {
            "default": "",
            "sommelier": "Languedoc-Roussillon is a vibrant tapestry of wine styles, where sun-kissed vineyards yield everything from bold reds to refreshing whites and sparkling delights. This dynamic region, steeped in history and innovation, invites wine lovers to explore its eclectic offerings, each sip telling a story of its diverse terroir.",
            "julie": "Located on the southern coast of France, the Languedoc-Roussillon wine region, nowadays called Occitanie region, runs in a crescent shape between Provence to the East and the Spanish border to the South.  The region has the biggest acreage under vines in France and in some vintages produces close to 30% of the national production. However, most of the wines produced are sold at IGP level. The region is mostly known for its red wine production even though white and red wines are also produced. Some of the most famous Appellations d’Origine Protégée (AOP) include Fitou, Corbières, Corbières-Boutenac, Minervois, Minervois-la-Livinière, Saint Chinian and Faugères. Wines are produces from blends that generally include Grenache Noir, Syrah, Carignan. Crémant de Limoux is dedicated to the production of sparkling wines made from Chardonnay, Chenin Blanc, Mauzac and Pinot. The eastern half of Languedoc is dominated by the regional appellation Languedoc AOP. Formerly Coteaux du Languedoc AOC, this appellation encompasses nearly all of Languedoc-Roussillon, extending from the Spanish border to the city of Nîmes. Languedoc AOP covers the production of red, rosé, and white wines and encompasses 11 geographic designations. The Languedoc has also build its reputation on the production of sweet fortified wines known as “vins doux naturels”. The white examples are made from the Muscat blanc à petits grains. Muscat d’Alexandrie, Grenache (Gris and Blanc), Maccabéo, Tourbat. The red examples can be sold young, when young and fruity, or can be aged in an oxidative environment to where they develop some rancio style flavours. The main red grape used for the purpose of red vin doux naturel wine is Grenache Noir. ",
        },
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 600),
        "soil_types": "clay",
        "primary_grapes": [
            "Grenache Noir",
            "Syrah",
            "Carignan",
            "Chardonnay",
            "Chenin Blanc",
            "Mauzac",
            "Pinot",
            "Muscat blanc à petits grains",
            "Muscat d’Alexandrie",
            "Grenache Gris",
            "Maccabéo",
            "Tourbat",
        ],
        "wine_styles": [
            "red",
            "white",
            "rose",
            "sparkling",
            "dessert",
            "fortified",
            "blend",
            "varietal",
            "traditional",
            "modern",
        ],
    },
    {
        "country": "FR",
        "name": "Loire Valley",
        "synonyms": ["Loire", "Val de Loire"],
        "subregions": [
            {
                "name": "Anjou",
                "synonyms": ["Anjou-Saumur", "Saumur"],
                "subregions": [
                    {"name": "Saumur-Champigny"},
                    {
                        "name": "Quarts de Chaume",
                        "synonyms": ["Quarts de Chaume Grand Cru"],
                    },
                    {"name": "Coteaux du Layon"},
                    {"name": "Bonnezeaux"},
                    {
                        "name": "Savennières",
                        "synonyms": [
                            "Savennières Roche aux Moines",
                            "Savennières Coulée de Serrant",
                        ],
                    },
                ],
            },
            {
                "name": "Central Loire",
                "synonyms": ["Centre-Loire"],
                "subregions": [
                    {"name": "Chinon"},
                    {"name": "Menetou-Salon"},
                    {"name": "Quincy"},
                    {"name": "Reuilly"},
                    {"name": "Pouilly-Fumé"},
                    {"name": "Sancerre"},
                ],
            },
            {
                "name": "Touraine",
                "subregions": [
                    {"name": "Bourgueil"},
                    {"name": "Montlouis", "synonyms": ["Montlouis-sur-Loire"]},
                    {"name": "Vouvray"},
                    {"name": "Touraine Oisly", "synonyms": ["Oisly", "Touraine-Oisly"]},
                    {
                        "name": "Touraine Mesland",
                        "synonyms": ["Mesland", "Touraine-Mesland"],
                    },
                    {
                        "name": "Touraine Amboise",
                        "synonyms": ["Amboise", "Touraine-Amboise"],
                    },
                    {
                        "name": "Touraine Azay-le-Rideau",
                        "synonyms": ["Azay-le-Rideau", "Touraine-Azay-le-Rideau"],
                    },
                    {
                        "name": "Touraine Chenonceaux",
                        "synonyms": ["Chenonceaux", "Touraine-Chenonceaux"],
                    },
                ],
            },
            {
                "name": "Pays Nantais",
                "synonyms": ["Muscadet", "Nantais", "Pays Nantes"],
                "subregions": [
                    {"name": "Muscadet Sèvre et Maine"},
                    {"name": "Muscadet Coteaux de la Loire"},
                    {"name": "Muscadet Côtes de Grandlieu"},
                ],
            },
        ],
        "description": {
            "default": "",
            "sommelier": "The Loire Valley is a picturesque wine region celebrated for its stunning landscapes and a remarkable variety of wines, including the zesty Chenin Blanc and the aromatic Sauvignon Blanc. This enchanting area, with its clay soils and gentle elevations, offers a delightful journey through both vibrant whites and charming reds, making it a must-visit for any wine lover.",
            "julie": "The Loire is France’s longest river and run for 1006 kilometres from the Massif Central to the Atlantic Ocean. Along, the Loire, some of France most qualitative vineyards can be found. The region produces more white wine than any other French region is second to Champagne when it comes to sparkling wine production. The most classical white grapes of the Loire Valley are Chenin Blanc, Sauvignon Blanc and Melon de Bourgogne while Cabernet Franc (known locally as Breton), Pinot Noir and Gamay are the most planted red grapes. The Loire Valley wine region is divided into 4 sub-regions : Pays Nantais, Touraine, Anjou and Central Loire. Famous AOPs include Muscadet, Savennières, Chinon, Vouvray, Sancerre and Pouilly-Fumé. ",
        },
        "climate_types": "temperate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 200),
        "soil_types": "clay",
        "primary_grapes": [
            "Chenin Blanc",
            "Sauvignon Blanc",
            "Melon de Bourgogne",
            "Cabernet Franc",
            "Pinot Noir",
            "Gamay",
        ],
        "wine_styles": ["white", "sparkling", "red", "rose"],
    },
    {
        "country": "FR",
        "name": "Lorraine",
        "climate_types": "temperate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (200, 400),
        "soil_types": "clay",
        "primary_grapes": ["Pinot Noir", "Auxerrois"],
        "wine_styles": ["white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Lorraine is a hidden gem in the French wine landscape, where the elegance of Pinot Noir and the charm of Auxerrois come together to create exquisite white and sparkling wines. With its clay-rich soils and moderate elevation, this region offers a refreshing taste of France's vinous diversity, perfect for those seeking something off the beaten path.",
        },
    },
    {
        "country": "FR",
        "name": "Madiran",
        "climate_types": "temperate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (200, 400),
        "soil_types": "clay",
        "primary_grapes": ["Tannat", "Cabernet Franc", "Cabernet Sauvignon"],
        "wine_styles": ["red", "full_bodied", "age_worthy"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of southwestern France, Madiran is a treasure trove for lovers of bold red wines, where the mighty Tannat reigns supreme. With its clay-rich soils and a climate that nurtures depth and character, this region produces age-worthy wines that promise to evolve beautifully over the years.",
        },
    },
    {
        "country": "FR",
        "name": "Provence",
        "synonyms": ["Côtes de Provence", "Cotes de Provence"],
        "description": {
            "default": "",
            "sommelier": "Provence is a picturesque wine region celebrated for its exquisite rosés, crafted from a harmonious blend of Cinsault, Grenache, and Mourvèdre, alongside delightful whites and robust reds. With its stunning landscapes and rich history, this region offers a taste of the Mediterranean lifestyle in every sip.",
            "julie": "Provence, the birthplace of French wine, lies to the east of the Rhône basin on the sun-drenched Mediterranean coast. The region is world famous for its pale-hued, dry rosés which represent over 80% of the region’s total wine production.Three-quarters of the wines are sold under the Côtes de Provence AOP which is solely made as rosé. Cinsault, Grenache, Mourvèdre, Syrah, and the local Tibouren are the main red grape varieties planted.  Other appellations of the region, offering high quality wines in all colour, include Bandol, Casis, Les-Baux-de-Provence, Palette and Bellet AOPs. ",
        },
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": ["Cinsault", "Grenache", "Mourvèdre", "Syrah", "Tibouren"],
        "wine_styles": ["rose", "red", "white"],
    },
    {
        "country": "FR",
        "name": "Coteaux du Pont du Gard",
        "synonyms": ["Pont du Gard"],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (50, 200),
        "soil_types": "clay",
        "primary_grapes": ["Grenache", "Syrah", "Mourvèdre"],
        "wine_styles": ["red", "rose", "white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of southern France, Coteaux du Pont du Gard is a treasure trove of vibrant reds, elegant rosés, and crisp whites, all crafted from the region's signature grapes. With its clay-rich soils and a picturesque landscape, this area not only produces exceptional wines but also invites you to savor the rich history and culture that surrounds it.",
        },
    },
    {
        "country": "FR",
        "name": "Rhône",
        "synonyms": ["Rhône Valley", "Rhone Valley"],
        "subregions": [
            {"name": "Beaumes-de-Venise"},
            {"name": "Château-Grillet"},
            {
                "name": "Châteauneuf-du-Pape",
                "synonyms": ["Chateauneuf-du-Pape", "Chateauneuf du Pape"],
            },
            {"name": "Lirac"},
            {"name": "Luberon"},
            {"name": "Condrieu"},
            {"name": "Cornas"},
            {"name": "Côte du Rhône-Villages"},
            {"name": "Côte-Rôtie"},
            {"name": "Côtes du Rhône", "synonyms": ["Cotes du Rhone"]},
            {"name": "Crozes-Hermitage"},
            {"name": "Hermitage"},
            {"name": "Gigondas"},
            {"name": "St. Joseph"},
            {"name": "Saint-Péray"},
            {"name": "Vacqueyras"},
            {"name": "Tavel"},
        ],
        "description": {
            "default": "",
            "sommelier": "The Rhône Valley is a vinous treasure trove, where the bold Syrah and luscious Grenache dance together in harmonious blends, creating wines that are as diverse as the landscape itself—from full-bodied reds to aromatic whites and everything in between. With its sun-drenched hills and clay-rich soils, this region is a true celebration of terroir and tradition.",
            "julie": "",
        },
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 500),
        "soil_types": "clay",
        "primary_grapes": ["Syrah", "Grenache", "Viognier", "Mourvèdre", "Cinsault"],
        "wine_styles": [
            "red",
            "white",
            "rose",
            "sparkling",
            "fortified",
            "blend",
            "varietal",
        ],
    },
    {
        "country": "FR",
        "name": "Savoy",
        "synonyms": ["Savoie"],
        "subregions": [{"name": "Bugey"}, {"name": "Vin de Savoie"}],
        "climate_types": "alpine",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Savoy is a hidden gem in the French Alps, where the crisp mountain air and diverse grape varieties come together to create refreshing wines that are as vibrant as the region's breathtaking scenery. With its unique terroir, Savoy offers a delightful exploration of flavors that are sure to surprise and enchant any wine enthusiast.",
        },
    },
    {
        "country": "GE",
        "name": "Abkhazia",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 1500.0,
        "elevation_range": (0, 2000),
        "soil_types": "clay",
        "primary_grapes": [
            "Rkatsiteli",
            "Saperavi",
            "Mtsvane",
            "Chardonnay",
            "Cabernet Sauvignon",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled between the Black Sea and the Caucasus Mountains, Abkhazia is a captivating wine region where ancient traditions meet modern winemaking. With its lush landscapes and a medley of grape varieties, including the bold Saperavi and aromatic Mtsvane, this region produces an exciting array of wines that are sure to delight any palate.",
        },
    },
    {
        "country": "GE",
        "name": "Kartli",
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (300, 800),
        "soil_types": "clay",
        "primary_grapes": ["Saperavi", "Rkatsiteli"],
        "wine_styles": ["red", "white", "traditional", "modern"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "In the heart of Georgia, Kartli is a vibrant tapestry of clay-rich soils and rolling hills, where the bold Saperavi and aromatic Rkatsiteli grapes flourish. This region masterfully blends tradition with innovation, offering a delightful array of wines that capture the essence of its rich heritage and stunning landscapes.",
        },
    },
    {
        "country": "GE",
        "name": "Imereti",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (200, 1000),
        "soil_types": "alluvial",
        "primary_grapes": ["Tsitska", "Tsolikouri", "Mtsvane", "Saperavi"],
        "wine_styles": ["red", "white", "rose", "sparkling", "traditional"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Georgia, Imereti is a vibrant wine region where the ancient art of winemaking thrives amidst lush landscapes and fertile alluvial soils. Here, the indigenous grapes Tsitska and Tsolikouri flourish, producing an array of delightful wines that reflect the region's rich heritage and diverse climate.",
        },
    },
    {
        "country": "GE",
        "name": "Racha-Lechkhumi and Kvemo Svaneti",
        "climate_types": "temperate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (500, 2000),
        "soil_types": "clay",
        "primary_grapes": ["Saperavi", "Rkatsiteli", "Mtsvane"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Georgia, Racha-Lechkhumi and Kvemo Svaneti boasts a stunning landscape where the ancient Saperavi grape flourishes alongside the aromatic Rkatsiteli and Mtsvane. With its clay-rich soils and a climate kissed by 800 mm of rainfall, this region crafts wines that are as bold and expressive as the mountains that cradle them.",
        },
    },
    {
        "country": "DE",
        "name": "Ahr",
        "synonyms": ["Ahr Valley"],
        "description": {
            "default": "",
            "sommelier": "Nestled in a charming valley, the Ahr region is a treasure trove for lovers of red wine, showcasing the finesse of Spätburgunder and Frühburgunder. With its stunning landscapes and a commitment to quality, Ahr wines are a delightful exploration of elegance and depth, perfect for any occasion.",
            "julie": "",
        },
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": ["Spätburgunder", "Frühburgunder"],
        "wine_styles": ["red"],
    },
    {
        "country": "DE",
        "name": "Baden",
        "synonyms": ["Baden-Württemberg"],
        "description": {
            "default": "",
            "sommelier": "Baden, or Baden-Württemberg, is a picturesque wine region celebrated for its exquisite Spätburgunder, Grauburgunder, and Weißburgunder, offering a delightful array of red and white wines that capture the essence of southern Germany's sun-kissed vineyards. With its charming landscapes and a commitment to quality, Baden is a must-visit for any wine enthusiast seeking to explore the nuances of German viticulture.",
            "julie": "",
        },
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": ["Spätburgunder", "Grauburgunder", "Weißburgunder"],
        "wine_styles": ["red", "white"],
    },
    {
        "country": "DE",
        "name": "Franken",
        "synonyms": ["Franken", "Franconia"],
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of Germany, Franken enchants with its limestone hills and charming vineyards, where Silvaner and Muller-Thurgau flourish to create delightful, medium-bodied white wines that reflect the region's rich heritage and vibrant terroir.",
            "julie": "",
        },
        "climate_types": "continental",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "limestone",
        "primary_grapes": ["Silvaner", "Muller-Thurgau"],
        "wine_styles": ["white", "medium_bodied", "traditional"],
    },
    {
        "country": "DE",
        "name": "Hessische Bergstrasse",
        "climate_types": "temperate",
        "avg_annual_rainfall": 700.0,
        "elevation_range": (100, 400),
        "soil_types": "loess",
        "primary_grapes": ["Riesling", "Pinot Noir", "Pinot Blanc", "Pinot Gris"],
        "wine_styles": ["white", "red", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled between the Odenwald and the Rhine, Hessische Bergstrasse is a charming wine region known for its exquisite Rieslings and refined Pinots, all nurtured by the region's loess soils and gentle slopes. With a delightful mix of white, red, and sparkling wines, this area offers a taste of Germany's vinous diversity in a picturesque setting.",
        },
    },
    {
        "country": "DE",
        "name": "Mittelrhein",
        "climate_types": "maritime",
        "avg_annual_rainfall": 700.0,
        "elevation_range": (100, 300),
        "soil_types": "slate",
        "primary_grapes": ["Riesling", "Spätburgunder"],
        "wine_styles": ["white", "red", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the romantic Rhine River, Mittelrhein enchants with its slate-laden hills and a climate that nurtures exquisite Rieslings and charming Spätburgunders, offering a delightful tapestry of white, red, and sparkling wines that reflect the region's unique terroir.",
        },
    },
    {
        "country": "DE",
        "name": "Mosel",
        "synonyms": ["Moselle", "Mosel-Saar-Ruwer", "Mosel Saar Ruwer", "The Mosel"],
        "description": {
            "default": "",
            "sommelier": "Nestled along the winding Mosel River, this picturesque region is celebrated for its exquisite Riesling wines, which capture the essence of its slate-rich soils and cool climate. With steep vineyards that cling to the hillsides, the Mosel offers a delightful journey through some of the world's most enchanting wine landscapes.",
            "julie": "The Mosel is one of the most scenic wine regions of the world with incredibly steep slate slopes where only vines can grow.These vineyards are impossible to harvest mechanically, and cable systems are often employed to enable workers to traverse the cliff-side vines. The Mosel is highly regarded for its production of pure, light, racy, mineral and low alcohol Rieslings that exhibits aromas of green apple, citrus and blossom. The wines produced range from dry to sweet and labelled often based on their prädikat level.  The Mosel is divided into six bereiche: Bernkastel, Burg Cochem, Saar, Ruwertal, Obermosel, and Moseltor. The Ruwer and the Saar are two tributaries of the Mosel. ",
        },
        "climate_types": "uknown",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
    },
    {
        "country": "DE",
        "name": "Nahe",
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of Germany, the Nahe region boasts volcanic soils that nurture a vibrant tapestry of grape varieties, with Riesling leading the charge. Here, winemakers craft both elegant whites and robust reds, each bottle a delightful expression of the region's unique terroir and winemaking tradition.",
            "julie": "The Nahe region is one of the smallest of Germany and it is located to the west of the Rheinhessen, along the Nahe River, a tributary of the Rhine. The region has an extraordinary range of soil types and is protected from cold winds by the Hunsrück mountain range. The Nahe receives plenty of sunshine each year. The Region produces over 75% of white wine with Riesling counting for approximately 30% of the plantings. The steeper sites of volcanic weathered stones and those with red clay and slates are the preferred ones for Riesling. Other white grape varities such as Rivaner, Silvaner, Pinot Gris and Pinot Blanc and also increasingly cultivated. Dornfelder and Spätburgunder are the most planted red grapes. ",
        },
        "climate_types": "temperate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "volcanic",
        "primary_grapes": [
            "Riesling",
            "Rivaner",
            "Silvaner",
            "Pinot Gris",
            "Pinot Blanc",
            "Dornfelder",
            "Spätburgunder",
        ],
        "wine_styles": ["white", "red", "medium_bodied", "full_bodied", "traditional"],
    },
    {
        "country": "DE",
        "name": "Palatinate",
        "synonyms": ["Pfalz", "Pflaz"],
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of Germany, the Palatinate region dazzles with its loess-laden vineyards, producing exquisite wines that range from the crisp elegance of Riesling to the bold character of Spätburgunder. A true gem for wine lovers, this area offers a delightful blend of tradition and modernity in every bottle.",
            "julie": "The Pfalz, also known as the Palatinate is one of the warmest winegrowing regions of Germany and is located at the border with Alsace in France. The region has a very complex soil makeup with red sandstone, limestones, loess, red slate, basalt, granite and gravels. The white wines produced in the region tend to be dry and more full-bodied than in other regions of Germany. ",
        },
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "loess",
        "primary_grapes": [
            "Riesling",
            "Müller-Thurgau",
            "Grauburgunder",
            "Dornfelder",
            "Spatburgunder",
            "Portugueser",
        ],
        "wine_styles": ["white", "red", "full_bodied"],
    },
    {
        "country": "DE",
        "name": "Rheingau",
        "synonyms": ["Rhinegau"],
        "description": {
            "default": "",
            "sommelier": "Nestled along the banks of the Rhine River, the Rheingau is a gem of German winemaking, where the slate-rich soils nurture some of the world's finest Rieslings, alongside elegant Spätburgunders. This enchanting region offers a delightful array of wine styles, from crisp whites to luscious dessert wines, making it a must-visit for any wine lover.",
            "julie": "The Rheingau region is stretches from Lorch to the East to Wiesbaden to the West, on the northern shore of the Rhine River.  Riesling represents 80% of the total plantings in Rheingau. Soil in the upper slope vineyards is dominated by slate, whereas the lower vineyards closer to the water contain a mixture of clay, loess, alluvial sand and red slate. Rheingau Riesling tend to be intense, concentrated with a racy acidity. On the western end of the Rheingau, to the northwest of Rüdesheim, lies the village of Assmannshausen. Assmannshausen is the Rheingau’s center for red wine production and  Spätburgunder (Pinot Noir) being the most planted red grape in the region.",
        },
        "climate_types": "temperate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "slate",
        "primary_grapes": ["Riesling", "Spätburgunder"],
        "wine_styles": ["white", "red", "dessert"],
    },
    {
        "country": "DE",
        "name": "Rheinhessen",
        "synonyms": ["Rheinhesse"],
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of Germany, Rheinhessen is a treasure trove of wine diversity, where the crisp elegance of Riesling meets the rich depth of Dornfelder, all nurtured by the region's fertile loess soils. Whether you prefer a refreshing white or a robust red, this region offers a delightful sip for every palate.",
            "julie": "",
        },
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "loess",
        "primary_grapes": [
            "Riesling",
            "Muller-Thurgau",
            "Dornfelder",
            "Silvaner",
            "Grauburgunder",
            "Spatburgunder",
        ],
        "wine_styles": [
            "red",
            "white",
            "rose",
            "medium_bodied",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
        ],
    },
    {
        "country": "DE",
        "name": "Saale-Unstrut",
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 300),
        "soil_types": "clay",
        "primary_grapes": ["Müller-Thurgau", "Riesling"],
        "wine_styles": ["white", "sparkling", "medium_bodied"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Saale-Unstrut is a charming wine region where the gentle slopes and clay-rich soils nurture exquisite Müller-Thurgau and Riesling grapes. Known for its refreshing whites and elegant sparkling wines, this area offers a delightful taste of Germany's vinous heritage, perfect for those seeking something off the beaten path.",
        },
    },
    {
        "country": "DE",
        "name": "Saxony",
        "climate_types": "temperate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 300),
        "soil_types": "sandy_loam",
        "primary_grapes": ["Riesling", "Müller-Thurgau", "Pinot Blanc"],
        "wine_styles": ["white", "sparkling", "medium_bodied"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the banks of the Elbe River, Saxony is a hidden gem where the crispness of Riesling and the charm of Müller-Thurgau come together, creating wines that dance on the palate with vibrant acidity and floral notes. This enchanting region, with its rolling hills and sandy loam soils, produces delightful whites and sparkling wines that are perfect for any occasion.",
        },
    },
    {
        "country": "DE",
        "name": "Württemberg",
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of Germany, Württemberg is a charming region celebrated for its vibrant Trollinger wines, which dance on the palate with notes of cherry and spice, all thanks to the region's rich marl soils. This delightful area invites wine lovers to explore its picturesque vineyards and savor the essence of its red wine heritage.",
            "julie": "",
        },
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "marl",
        "primary_grapes": ["Trollinger"],
        "wine_styles": ["red"],
    },
    {
        "country": "GR",
        "name": "Aegean islands",
        "subregions": [
            {"name": "Crete"},
            {"name": "Limnos"},
            {"name": "Paros"},
            {"name": "Rhodes"},
            {"name": "Samos"},
            {"name": "Santorini"},
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 2456),
        "soil_types": "volcanic",
        "primary_grapes": ["Assyrtiko", "Agiorgitiko", "Xinomavro", "Mavrotragano"],
        "wine_styles": ["red", "white", "rose", "sparkling", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "The Aegean islands are a vinous paradise where volcanic soils meet the azure sea, producing exceptional wines like the zesty Assyrtiko and the complex Xinomavro. With a delightful array of styles from sparkling to dessert, this region invites you to explore its rich flavors and vibrant character.",
        },
    },
    {
        "country": "GR",
        "name": "Central Greece",
        "subregions": [
            {"name": "Attica"},
            {"name": "Epirus", "subregions": [{"name": "Zitsa"}]},
            {
                "name": "Thessaly",
                "subregions": [{"name": "Nea Anchialos"}, {"name": "Rapsani"}],
            },
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 2000),
        "soil_types": "limestone",
        "primary_grapes": ["Savatiano", "Assyrtiko", "Xinomavro", "Agiorgitiko"],
        "wine_styles": ["red", "white", "rose", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Central Greece is a hidden gem where limestone soils and a dramatic elevation range create a tapestry of flavors, producing everything from zesty Assyrtiko whites to bold Xinomavro reds. This region invites wine lovers to explore its diverse offerings, each sip telling the story of its rich terroir.",
        },
    },
    {
        "country": "GR",
        "name": "Ionian Islands",
        "subregions": [{"name": "Kefalonia"}],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 1000),
        "soil_types": "limestone",
        "primary_grapes": ["Robola", "Mavrodaphne", "Muscat"],
        "wine_styles": ["white", "red", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "The Ionian Islands are a hidden gem in the Mediterranean, where the limestone-rich soils and gentle climate give rise to exquisite wines, from the zesty whites of Robola to the luscious reds of Mavrodaphne. Each sip transports you to sun-drenched shores, making it a delightful destination for wine lovers seeking both tradition and innovation.",
        },
    },
    {
        "country": "GR",
        "name": "Macedonia",
        "subregions": [
            {"name": "Amyntaion"},
            {"name": "Goumenissa"},
            {"name": "Naousa", "synonyms": ["Naoussa", "Naoysa"]},
            {"name": "Imathia"},
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (200, 800),
        "soil_types": "clay",
        "primary_grapes": ["Xinomavro", "Assyrtiko", "Negoska"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Northern Greece, Macedonia boasts a rich tapestry of wine styles, from the bold and complex reds of Xinomavro to the crisp and zesty whites of Assyrtiko. With its clay soils and varied elevations, this region is a hidden gem for wine lovers seeking both tradition and innovation in every sip.",
        },
    },
    {
        "country": "GR",
        "name": "Peloponnesus",
        "subregions": [{"name": "Mantineia"}, {"name": "Nemea"}, {"name": "Patras"}],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 1200),
        "soil_types": "clay",
        "primary_grapes": ["Agiorgitiko", "Moschofilero"],
        "wine_styles": ["red", "white", "sparkling", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Greece, Peloponnesus is a vinous treasure trove where the bold Agiorgitiko and aromatic Moschofilero flourish, producing everything from luscious reds to effervescent delights. With its clay soils and varied elevations, this region offers a delightful tapestry of flavors that reflect the rich heritage and vibrant landscape of Greek winemaking.",
        },
    },
    {
        "country": "HU",
        "name": "Balaton",
        "subregions": [
            {"name": "Badacsony"},
            {"name": "Balaton-felvidék"},
            {"name": "Balatonboglár"},
            {"name": "Balatonfüred-Csopak"},
            {"name": "Nagy-Somló"},
            {"name": "Zala"},
        ],
        "climate_types": "temperate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 400),
        "soil_types": "clay",
        "primary_grapes": [
            "Furmint",
            "Hárslevelü",
            "Kékfrankos",
            "Cabernet Sauvignon",
            "Merlot",
        ],
        "wine_styles": ["white", "red", "rose", "sparkling", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled around the picturesque Lake Balaton, this region is a treasure trove of wine styles, where the crisp, aromatic whites of Furmint and Hárslevelü dance alongside the bold reds of Kékfrankos and Merlot, all crafted from the region's fertile clay soils. Whether you're sipping a sparkling wine by the lakeside or indulging in a rich dessert wine, Balaton promises a delightful experience for every palate.",
        },
    },
    {
        "country": "HU",
        "name": "Duna",
        "subregions": [
            {"name": "Csongrád"},
            {"name": "Hajós-Baja"},
            {"name": "Kunság"},
        ],
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 200),
        "soil_types": "clay",
        "primary_grapes": ["Furmint", "Hárslevelű", "Kékfrankos", "Cabernet Sauvignon"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the banks of the Duna River, this enchanting region boasts a rich tapestry of clay soils and a climate that nurtures both vibrant whites and bold reds. With Furmint and Hárslevelű leading the charge for whites, and Kékfrankos adding depth to the reds, Duna is a delightful destination for wine lovers seeking both tradition and innovation in every sip.",
        },
    },
    {
        "country": "HU",
        "name": "Eger",
        "subregions": [
            {"name": "Bükk"},
            {"name": "Eger"},
            {"name": "Észak-Dunántúl"},
            {"name": "Etyek-Buda"},
            {"name": "Mátra"},
            {"name": "Mór"},
            {"name": "Neszmély"},
            {"name": "Pannonhalma"},
        ],
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 400),
        "soil_types": "clay",
        "primary_grapes": [
            "Furmint",
            "Harslevelu",
            "Kekfrankos",
            "Cabernet Sauvignon",
            "Merlot",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Hungary, Eger is celebrated for its rich tapestry of wines, from the crisp and aromatic Furmint to the bold and structured Kekfrankos. With its clay soils and varied elevations, this region produces everything from refreshing whites to luscious dessert wines, ensuring there's a delightful sip for every palate.",
        },
    },
    {
        "country": "HU",
        "name": "Pannon",
        "subregions": [
            {"name": "Pécs"},
            {"name": "Szekszárd"},
            {"name": "Tolna"},
            {"name": "Villány"},
        ],
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 400),
        "soil_types": "clay",
        "primary_grapes": [
            "Kékfrankos",
            "Cabernet Sauvignon",
            "Merlot",
            "Chardonnay",
            "Furmint",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Hungary, the Pannon region is a vinous treasure trove where the earthy clay soils nurture a delightful array of grapes, producing everything from bold reds to elegant whites and effervescent sparkling wines. With an average rainfall of 600 mm, this region's climate is perfectly balanced, making it a haven for wine lovers seeking both tradition and innovation.",
        },
    },
    {
        "country": "HU",
        "name": "Sopron",
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (150, 400),
        "soil_types": "clay",
        "primary_grapes": ["Kékfrankos", "Zweigelt", "Sauvignon Blanc", "Chardonnay"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Sopron is a hidden gem in Hungary, where the harmonious blend of clay soils and a temperate climate gives rise to an array of delightful wines, from the robust reds of Kékfrankos to the refreshing whites of Sauvignon Blanc. This enchanting region invites wine lovers to explore its diverse styles, including sparkling and rosé, all crafted with a touch of Alpine charm.",
        },
    },
    {
        "country": "HU",
        "name": "Tokaj",
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 400),
        "soil_types": "volcanic",
        "primary_grapes": ["Furmint", "Hárslevelü"],
        "wine_styles": ["white", "dessert", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Hungary, Tokaj is a legendary wine region celebrated for its volcanic soils and the enchanting Furmint and Hárslevelü grapes, producing everything from crisp whites to sumptuous dessert wines. With a rich history and a climate that nurtures complexity, Tokaj is a must-visit for any wine lover seeking to explore the depths of flavor and tradition.",
        },
    },
    {
        "country": "IT",
        "name": "Apulia",
        "synonyms": ["Puglia", "Pouilles", "Apulien", "Salento"],
        "subregions": [
            {"name": "Gioia del Colle"},
            {"name": "Bianco di Locorotondo e Martina Franca"},
            {"name": "Manduria", "synonyms": ["Primitivo di Manduria"]},
            {"name": "Salice Salentino"},
            {"name": "Squinzano"},
            {"name": "Brindisi"},
        ],
        "description": {
            "default": "",
            "sommelier": "Apulia is a vibrant tapestry of sun-soaked vineyards, where the bold Negroamaro and Primitivo grapes flourish, crafting full-bodied reds that embody the warmth and passion of Southern Italy. This region invites wine lovers to indulge in its rich, flavorful offerings that pair beautifully with hearty Mediterranean cuisine.",
            "julie": "Apulia, the heel of the boot of Italy, is located near the Adriatic and Ionian seas, in the south-east of Italy, and is the least mountainous region in the country. Apulia’s mass production was historically devoted to the base wines for vermouth, bulk blending material and distillation. Today, even though the overall quality of the wines produced has increased, only approximately 7% of the total production is sold at DOC or DOCG level. Negroamaro is the most cultivated red grape in the region and produces powerful and full bodied red wines. In the North of Puglia, the Nero di Troia grape variety produces aromatic and tannic wines. The third major red grape of Apulia is Primitivo, which is genetically identical to Zinfandel from the US. ",
        },
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": ["Negroamaro", "Nero di Troia", "Primitivo"],
        "wine_styles": ["red", "full_bodied"],
    },
    {
        "country": "IT",
        "name": "Calabria",
        "subregions": [
            {"name": "Bivongi"},
            {"name": "Cirò"},
            {"name": "Lamezia"},
            {"name": "Melissa"},
            {"name": "Sant'Anna di Isola Capo Rizzuto"},
            {"name": "Savuto"},
            {"name": "Scavigna"},
            {"name": "Terre di Cosenza"},
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "clay",
        "primary_grapes": ["Gaglioppo", "Greco"],
        "wine_styles": ["red", "white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the toe of Italy's boot, Calabria boasts a rich tapestry of flavors, where the bold Gaglioppo grape produces reds that echo the region's rugged landscapes, while the Greco grape offers whites that are as refreshing as a sea breeze. This underappreciated region invites you to explore its vibrant wines that tell the story of its ancient roots and sun-kissed hills.",
        },
    },
    {
        "country": "IT",
        "name": "Abruzzo",
        "synonyms": ["Abruzzi", "Abruzzen"],
        "subregions": [{"name": "Montepulciano d'Abruzzo"}],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "clay",
        "primary_grapes": ["Montepulciano", "Trebbiano"],
        "wine_styles": ["red", "white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled between the Apennine mountains and the Adriatic Sea, Abruzzo is a treasure trove of wine, where the bold Montepulciano dances with the refreshing Trebbiano, creating a delightful symphony of flavors that reflect the region's stunning landscapes and rich heritage.",
        },
    },
    {
        "country": "IT",
        "name": "Lazio",
        "synonyms": ["Latium"],
        "subregions": [
            {"name": "Cannellino di Frascati"},
            {"name": "Cesanese del Piglio"},
            {"name": "Cerveteri"},
            {"name": "Frascati"},
            {"name": "Marino"},
            {"name": "Montecompatri-Colonna"},
            {"name": "Nettuno"},
            {"name": "Velletri"},
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "volcanic",
        "primary_grapes": ["Trebbiano", "Malvasia", "Cesanese"],
        "wine_styles": ["red", "white", "sparkling", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Italy, Lazio boasts a rich tapestry of volcanic soils that nurture a diverse array of grape varieties, resulting in wines that are as vibrant as the region's history. From the crisp, aromatic whites of Trebbiano and Malvasia to the bold, fruit-forward reds of Cesanese, Lazio offers a delightful exploration of Italian winemaking traditions.",
        },
    },
    {
        "country": "IT",
        "name": "Molise",
        "synonyms": ["Molize"],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 800),
        "soil_types": "clay",
        "primary_grapes": ["Trebbiano", "Montepulciano"],
        "wine_styles": ["red", "white", "medium_bodied", "full_bodied"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled between the Apennines and the Adriatic Sea, Molise is a captivating region where the robust Montepulciano and crisp Trebbiano thrive, producing wines that are as rich in character as the landscape itself. With its charming villages and rolling hills, this area invites you to savor its unique offerings, from vibrant whites to luscious reds.",
        },
    },
    {
        "country": "IT",
        "name": "Campania",
        "subregions": [
            {"name": "Avellino", "subregions": [{"name": "Falanghina"}]},
            {
                "name": "Benevento",
                "subregions": [{"name": "Falanghina"}, {"name": "Solopaca"}],
            },
            {"name": "Napoli"},
            {"name": "Salerno"},
            {"name": "Irpinia", "subregions": [{"name": "Taurasi"}]},
            {"name": "Taburno", "synonyms": ["Taburno", "Aglianico del Taburno"]},
            {"name": "Sannio"},
        ],
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of southern Italy, Campania is a volcanic paradise where the ancient Aglianico grape reigns supreme, crafting bold reds that age gracefully. With a symphony of flavors from its native whites like Falanghina and Greco, this region invites wine lovers to explore its rich heritage and dynamic expressions.",
            "julie": "Naples, the capital of Campania, is a World Heritage Site and the largest and most important city in Southern Italy. The region has a very long history of winemaking and today, the ancient red varieties Aglianico and Piedirosso (“red feet”) and the white Falanghina, Greco, and Fiano comprise a majority of the Campanian DOC wines. Aglianico is a tannic, high-acid grape grape variety that has the capacity to produce long-lived red wines. Aglianico shines as a varietal wine in Taurasi DOCG and Aglianico del Taburno DOCG. The white DOCG wines of Campania are Greco di Tufo and Fiano di Avellino. The Fiano di Avellino DOCG wines are produced from a minimum 85% the Fiano grape that gives rich,  full-bodied and aged-worthy white wines. Greco di Tufo DOCG must me made from a minimum of 85% of Greco variety, a lighter but more intensely aromatic grape than Fiano. Falanghina is another qualitative grape of the region that is also worth a mention. ",
        },
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "volcanic",
        "primary_grapes": ["Aglianico", "Piedirosso", "Falanghina", "Greco", "Fiano"],
        "wine_styles": ["red", "white", "full_bodied", "age_worthy"],
    },
    {
        "country": "IT",
        "name": "Emilia-Romagna",
        "synonyms": ["Emilia Romagna"],
        "subregions": [
            {"name": "Colli Cesenate"},
            {"name": "Sangiovese Superiore di Romagna"},
            {"name": "Trebbiano di Romagna"},
        ],
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of Italy, Emilia-Romagna is a treasure trove of flavors, celebrated for its sparkling Lambrusco and rich Sangiovese. With its fertile clay soils and a climate that nurtures both red and white varietals, this region offers a delightful exploration of Italian wine heritage.",
            "julie": "Emilia-Romagna region are world-renowned is the home of Parmigiano-Reggiano, Prosciutto di Parma, and Modena’s Balsamic vinegar. The region is also home to tow DOCGs for wine : Romagna Albana, Italy’s first white wine DOCG since 1987, and Colli Bolognesi Pignoletto DOCG awarded in 2011. Emilia Romagna is, however, most famous for its production of Lambrusco sparkling red wines made from various subvarieties of the Lambrusco variety. ",
        },
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 600),
        "soil_types": "clay",
        "primary_grapes": ["Lambrusco", "Sangiovese", "Trebbiano"],
        "wine_styles": ["red", "sparkling", "white"],
    },
    {
        "country": "IT",
        "name": "Liguria",
        "subregions": [{"name": "Cinque Terre"}],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 500),
        "soil_types": "sandy_loam",
        "primary_grapes": ["Vermentino", "Sciacchetrà"],
        "wine_styles": ["white", "dessert", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the stunning Italian coastline, Liguria is renowned for its refreshing Vermentino and the exquisite dessert wine Sciacchetrà, both of which capture the sun-drenched flavors of the region. With its sandy loam soils and a backdrop of rolling hills, this enchanting area produces wines that are as delightful as the breathtaking views they accompany.",
        },
    },
    {
        "country": "IT",
        "name": "Lombardy",
        "synonyms": ["Lombardia"],
        "subregions": [
            {"name": "Botticino"},
            {"name": "Capriano del Colle"},
            {"name": "Casteggio"},
            {"name": "Cellatica"},
            {"name": "Curtefranca"},
            {"name": "Franciacorta"},
            {"name": "Garda Colli Mantovani"},
            {"name": "Garda Lombardy"},
            {"name": "Lambrusco Mantovano"},
            {
                "name": "Lombardy IGTs",
                "subregions": [
                    {"name": "Alpi Retiche IGT"},
                    {"name": "Benaco Bresciano IGT"},
                    {"name": "Bergamasca IGT"},
                    {"name": "Provincia di Pavia IGT"},
                    {"name": "Sebino IGT"},
                ],
            },
            {"name": "Lugana"},
            {"name": "Montenetto di Brescia IGT"},
            {"name": "Moscato di Scanzo"},
            {
                "name": "Oltrepo Pavese",
                "subregions": [
                    {"name": "Bonarda dell'Oltrepo Pavese"},
                    {"name": "Buttafuoco dell'Oltrepo Pavese"},
                    {"name": "Oltrepo Pavese Metodo Classico"},
                    {"name": "Oltrepo Pavese Pinot Grigio"},
                    {"name": "Pinot Nero dell'Oltrepo Pavese"},
                    {"name": "Sangue di Giuda dell'Oltrepo Pavese"},
                ],
            },
            {"name": "Riviera del Garda Classico"},
            {"name": "San Colombano al Lambro"},
            {"name": "San Martino della Battaglia"},
            {"name": "Terre del Colleoni"},
            {"name": "Valcalepio"},
            {
                "name": "Valtellina",
                "subregions": [
                    {"name": "Sforzato di Valtellina"},
                    {"name": "Valtellina Superiore"},
                ],
            },
        ],
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of northern Italy, Lombardy boasts a stunning array of wines, from the bold Nebbiolo to the crisp Chardonnay, all crafted in a landscape defined by limestone hills and breathtaking elevations. Whether you're sipping a full-bodied red or a refreshing sparkling wine, Lombardy offers a delightful journey through Italy's vinous heritage.",
            "julie": "Lombardy is most famous for the quality of its traditional method sparkling wines sold under the Franciacorta and the Oltrepò Pavese metodo Classico DOCGs.  To the north of Franciacorta is Valtellina, Lombardy’s most important zone for red wines and considered an “heroic wine zone” for the challenging condition of its grape growing, making mechanisation impossible. Chiavennasca, the local names given to the Nebbiolo grape, provides a lighter style than in neighbouring Piemonte, often harvest from grapes grown in elevated terraces held together by stone walls.  ",
        },
        "climate_types": "temperate",
        "avg_annual_rainfall": None,
        "elevation_range": (200, 800),
        "soil_types": "limestone",
        "primary_grapes": ["Nebbiolo", "Chardonnay", "Pinot Noir", "Sangiovese"],
        "wine_styles": ["red", "white", "sparkling", "medium_bodied", "full_bodied"],
    },
    {
        "country": "IT",
        "name": "Marche",
        "synonyms": ["Marches", "Le Marche", "De Marken"],
        "subregions": [
            {"name": "Castelli di Jesi"},
            {"name": "Conero"},
            {"name": "Piceno"},
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 600),
        "soil_types": "clay",
        "primary_grapes": ["Verdicchio", "Sangiovese", "Montepulciano"],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the Adriatic coast, Marche is a hidden gem where the rolling hills meet the sea, producing exquisite wines like the zesty Verdicchio and the bold Sangiovese. With its rich clay soils and a climate that dances between the mountains and the coast, this region offers a delightful array of red, white, and sparkling wines that are sure to enchant any palate.",
        },
    },
    {
        "country": "IT",
        "name": "Aosta Valley",
        "synonyms": ["Valle d'Aosta"],
        "climate_types": "alpine",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (600, 3000),
        "soil_types": "granite",
        "primary_grapes": ["Petit Rouge", "Fumin", "Pinot Noir", "Chardonnay"],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "The Aosta Valley is a hidden gem in the Italian Alps, where the rugged granite soils and high elevations create a playground for both indigenous and international grape varieties. From the vibrant reds of Petit Rouge to the elegant whites of Chardonnay, this region offers a captivating blend of flavors that reflect its alpine heritage.",
        },
    },
    {
        "country": "IT",
        "name": "Piedmont",
        "synonyms": ["Piemonte"],
        "subregions": [
            {
                "name": "Acqui",
                "synonyms": ["Acqui Terme", "Brachetto d'Acqui", "Barbera d'Acqui"],
            },
            {"name": "Asti"},
            {"name": "Colli Tortonesi"},
            {"name": "Gattinara"},
            {"name": "Gavi", "synonyms": ["Cortese di Gavi"]},
            {"name": "Ghemme"},
            {
                "name": "Langhe",
                "subregions": [
                    {"name": "Roero"},
                    {"name": "Alba"},
                    {"name": "Barolo"},
                    {"name": "Barbaresco"},
                    {"name": "Dogliani"},
                ],
            },
            {"name": "Monferrato"},
            {"name": "Nizza"},
            {"name": "Ovada"},
        ],
        "description": {
            "default": "",
            "sommelier": "Nestled at the foot of the Alps, Piedmont is a treasure trove of rich, full-bodied wines, where the noble Nebbiolo reigns supreme, crafting exquisite Barolos that age like fine art. With its rolling hills and charming villages, this region offers a delightful blend of breathtaking scenery and world-class viniculture that captivates the senses.",
            "julie": "The region of Piedmont produces some of the finest wines in Italy and is considered, with Tuscany, as one of Italy’s most significant wine regions. Piedmont means “the foot the mountain” and is located at the foothills of the Appennines and the Alps. Most of the vineyards are planted south of the Po River Valley in the province of Asti, Alessandria and Cuneo. Piedmont experiences a continental climate to which the Alps provide a barrier from the rain. The region is composed of various soils such as calcareous marl, sandstone, clay and sand that are an important asset to viticulture. The region produces a broad range of wines – sparkling, sweet, white, red – from various grape varieties such as Nebbiolo, Barbera, Dolcetto, Arneis and Moscato. ",
        },
    },
    {
        "country": "IT",
        "name": "Sardinia",
        "synonyms": ["Sardegna"],
        "subregions": [
            {"name": "Cagliari"},
            {"name": "Cannonau"},
            {"name": "Monti"},
            {"name": "Ogliastra"},
        ],
        "description": {
            "default": "",
            "sommelier": "Sardinia is a sun-kissed paradise where the bold flavors of Cannonau and the crisp notes of Vermentino dance in harmony, reflecting the island's rugged landscapes and rich heritage. This enchanting region invites you to explore its diverse wine styles, each sip telling a story of its Mediterranean roots.",
            "julie": "Sardinia is an Italian island located south of Corsica in the middle of the Mediterranean sea. The island is well known for its refreshing aromatic white wines sold under the Vermentino di Gallura DOCG and for its powerful, sun kissed red wines made from the grape varities Cannonau (Grenache) and Carignano. ",
        },
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": ["Cannonau", "Carignano", "Vermentino"],
        "wine_styles": ["red", "white"],
    },
    {
        "country": "IT",
        "name": "Sicily",
        "synonyms": ["Sicilia", "Sicilien"],
        "subregions": [{"name": "Etna"}, {"name": "Noto"}, {"name": "Pantelleria"}],
        "description": {
            "default": "",
            "sommelier": "Sicily, with its volcanic soils and Mediterranean climate, is a treasure trove of wine diversity, producing everything from bold reds like Nero d’Avola to fragrant whites such as Grillo. This enchanting island invites you to explore its rich flavors and storied traditions, making every sip a journey through its sun-drenched landscapes.",
            "julie": "Sicily is one of Italy’s largest producers of wine, usually surpassed in volume only by Veneto. Historically, Sicily has been producing very little wine at the DOC level and a lot of the wine produced are low quality bulk wines. However, Sicily is well-suited to quality winemaking and more and more premium wines are being born on the island. The volcanic region of Etna, in the east of the island, is now producing some of the finest dry white and red wines of the country. The island has a wealth of indigenous grapes uniquely suited to its warm, dry climate. White grapes include the native Catarratto, Inzolia, Grecanico, Carricante, and Grillo. Zibibbo (Muscat of Alexandria) and Malvasia are also commonly encountered in Sicily. Native red grapes include Nero d’Avola (Calabrese), Frappato, Perricone, Nerello Mascalese and Nerello Cappuccio.",
        },
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 3340),
        "soil_types": "volcanic",
        "primary_grapes": [
            "Catarratto",
            "Inzolia",
            "Grecanico",
            "Carricante",
            "Grillo",
            "Zibibbo",
            "Malvasia",
            "Nero d’Avola",
            "Frappato",
            "Perricone",
            "Nerello Mascalese",
            "Nerello Cappuccio",
        ],
        "wine_styles": [
            "red",
            "white",
            "rose",
            "sparkling",
            "dessert",
            "fortified",
            "medium_bodied",
            "full_bodied",
            "premium",
        ],
    },
    {
        "country": "IT",
        "name": "Tuscany",
        "synonyms": ["Toscana"],
        "subregions": [
            {"name": "Bolgheri"},
            {"name": "Chianti", "subregions": [{"name": "Chianti Classico"}]},
            {"name": "Colli Apuani"},
            {"name": "Colli Etruria Centrale"},
            {"name": "Colline Lucchesi"},
            {"name": "Elba"},
            {"name": "Montalcino", "synonyms": ["Brunello di Montalcino"]},
            {"name": "Montescudaio"},
            {"name": "Parrina"},
            {"name": "Pitigliano"},
            {"name": "San Gimignano"},
            {"name": "Scansano"},
            {"name": "Val di Chiana"},
            {"name": "Val di Cornia"},
            {"name": "Valdinievole"},
            {"name": "Valle di Arbia"},
        ],
        "description": {
            "default": "",
            "sommelier": "Tuscany is a picturesque wine region that enchants with its rolling hills and sun-drenched vineyards, producing everything from robust reds like Chianti to elegant whites. With a blend of indigenous grapes and international varieties, Tuscany offers a delightful exploration of flavors that reflect its rich history and vibrant culture.",
            "julie": "The first DOC and DOCG zones to be delimited in Italy were Tuscan, with the famous wine region of Chianti being first delimited in 1716. Tuscany is known for its unique beauty made of hills covered in vineyards, olive tree groves and wheat fields. Tuscany is home to 11 DOCGs – Denominazione di origine controllata e garantita – the highest appellation level for wine in Italy. Tuscany trails only Piedmont and Veneto in the number of its DOCG zones. Tuscany overall enjoys a dry, Mediterranean climate but some parts of the region can experience more extreme weather patterns with very hot Summers and harsh Winters. Elevation and soil types also vary greatly within the region. Sangiovese is the main red grape of Tuscany – light in colour, naturally high in acidity and tannins with aromas of sour cherries and wild herbs – it is the main component of the wines of Chianti DOCG, Chianti Classico DOCG, Vino Nobile di Montepulciano DOCG and the only grape permitted for the production of Brunello di Montalcino DOCG. 85% of the wines produced in Tuscany are red and other grape varieties commonly found in the region include Colorino, Canaiolo, Cabernet Sauvignon, Merlot and Syrah.",
        },
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [
            "Sangiovese",
            "Colorino",
            "Canaiolo",
            "Cabernet Sauvignon",
            "Merlot",
            "Syrah",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling", "dessert", "fortified"],
    },
    {
        "country": "IT",
        "name": "Umbria",
        "synonyms": ["Ombrie", "Umbrien"],
        "subregions": [
            {"name": "Montefalco"},
            {"name": "Orvieto"},
            {"name": "Torgiano"},
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (200, 600),
        "soil_types": "clay",
        "primary_grapes": ["Sangiovese", "Trebbiano", "Sagrantino"],
        "wine_styles": ["red", "white", "sparkling", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Italy, Umbria is a treasure trove of wine diversity, where the bold Sangiovese and the rare Sagrantino flourish amidst rolling hills and fertile clay soils. Whether you're sipping a robust red or a crisp white, each glass tells the story of this enchanting region's rich heritage and vibrant landscape.",
        },
    },
    {
        "country": "IT",
        "name": "Trevenezie",
        "synonyms": ["Tre Venezie", "delle Venezie"],
        "subregions": [
            {
                "name": "Veneto",
                "subregions": [
                    {"name": "Arcole"},
                    {"name": "Bagnoli"},
                    {"name": "Bardolino"},
                    {"name": "Bianco di Custoza"},
                    {"name": "Breganze"},
                    {"name": "Colli Berici"},
                    {"name": "Colli di Conegliano"},
                    {"name": "Colli Euganei"},
                    {"name": "Gambellara"},
                    {"name": "Lessini Durello"},
                    {"name": "Lison Pramaggiore"},
                    {"name": "Lugana"},
                    {"name": "Montgello e Colli Asolani"},
                    {"name": "Piave"},
                    {"name": "Soave"},
                    {"name": "Valdadige", "synonyms": ["Etschtaler"]},
                    {"name": "Valpolicella"},
                    {
                        "name": "Treviso",
                        "synonyms": ["Prosecco di Treviso"],
                        "subregions": [],
                        "description": {
                            "default": "",
                            "sommelier": "From the historic heart of the region, this classic Prosecco showcases vibrant notes of green apple and white flowers, culminating in an exceptionally crisp and refreshing finish perfect for any celebration.",
                            "julie": "",
                        },
                    },
                    {"name": "Verona"},
                ],
                "description": {
                    "default": "",
                    "sommelier": "",
                    "julie": "Veneto produces more wine than any other region in Italy, yet much of  its production is at inexpensive price point with the bulk of it being made of Pinot Grigio and sparkling prosecco. However, Veneto also produces some of the most sought-after wines of the countries including the famous Amarone della Valpolicella, a red wine made from grapes partially dried. Other noteworthy wines of the region include the Valpolicella and Bardolino DOCs that produce bright, mouth-watering red wine with cherry and bitter almond flavours from the Corvina and Rondinella grape varieties. The Soave DOC, the most important white wine zone of the region, planted with Garganega, Trebbiano di Soave and Chardonnay offers some dry white wines that range from light, crisp and simple to rich, complex and mineral. Sweet wines made from dried grapes are also produced in the regions of Valpolicella and Soave and  are labelled as “Recioto”. ",
                },
            },
            {
                "name": "Friuli-Venezia Giulia",
                "synonyms": ["Friuli", "Friuli Venezia Giulia"],
                "subregions": [
                    {"name": "Carso"},
                    {"name": "Collio", "synonyms": ["Collio Goriziano"]},
                    {"name": "Friuli Aquileia", "synonyms": ["Aquileia"]},
                    {"name": "Friuli Isonzo"},
                    {"name": "Friuli Grave"},
                    {"name": "Latisana"},
                    {"name": "Lison-Pramaggiore"},
                    {"name": "Ramandolo"},
                ],
                "description": {
                    "default": "",
                    "sommelier": "",
                    "julie": "The winemaking tradition of Friuli-Venezia Giulia is highly influenced from neighbouring Slavic, German, and Italian cultures. The introduction of controlled cold fermentations in in stainless steel vats in the 1960s, coupled with the region’s moderate temperatures, led to the Friulian style: crisp, aromatic, fruit-driven varietal white wines designed for quick consumption. Pinot Bianco, Chardonnay, Pinot Grigio and Sauvignon blanc are very popular international white grapes in the region. Friuli is also rich in local grape varieties which are attracting more and more interest : Verduzzo Gialla, Picolit, Friulano, Ribolla Gialla and Malvasia Istriana are great white examples while Schioppettino, Refosco, Terrano and Pignolo are indigenous red grape varieties that produces some excellent quality wines. Today, producers are also continually experimenting and Modern Friulian whites can be blended, barrel-fermented, powerful and lush rather than lean. Skin-contact white wines have also gained in popularity. Despite the fact that Friuli receives the most acclaim for its white wines, a significant part of the region is planted with Merlot, Cabernet Franc and Cabernet Sauvignon that can be sold as varietal wines or blended. The winemaking tradition of Friuli-Venezia Giulia is highly influenced from neighbouring Slavic, German, and Italian cultures. The introduction of controlled cold fermentations in in stainless steel vats in the 1960s, coupled with the region’s moderate temperatures, led to the Friulian style: crisp, aromatic, fruit-driven varietal white wines designed for quick consumption. Pinot Bianco, Chardonnay, Pinot Grigio and Sauvignon blanc are very popular international white grapes in the region. Friuli is also rich in local grape varieties which are attracting more and more interest : Verduzzo Gialla, Picolit, Friulano, Ribolla Gialla and Malvasia Istriana are great white examples while Schioppettino, Refosco, Terrano and Pignolo are indigenous red grape varieties that produces some excellent quality wines. Today, producers are also continually experimenting and Modern Friulian whites can be blended, barrel-fermented, powerful and lush rather than lean. Skin-contact white wines have also gained in popularity. Despite the fact that Friuli receives the most acclaim for its white wines, a significant part of the region is planted with Merlot, Cabernet Franc and Cabernet Sauvignon that can be sold as varietal wines or blended. The winemaking tradition of Friuli-Venezia Giulia is highly influenced from neighbouring Slavic, German, and Italian cultures. The introduction of controlled cold fermentations in in stainless steel vats in the 1960s, coupled with the region’s moderate temperatures, led to the Friulian style: crisp, aromatic, fruit-driven varietal white wines designed for quick consumption. Pinot Bianco, Chardonnay, Pinot Grigio and Sauvignon blanc are very popular international white grapes in the region. Friuli is also rich in local grape varieties which are attracting more and more interest : Verduzzo Gialla, Picolit, Friulano, Ribolla Gialla and Malvasia Istriana are great white examples while Schioppettino, Refosco, Terrano and Pignolo are indigenous red grape varieties that produces some excellent quality wines. Today, producers are also continually experimenting and Modern Friulian whites can be blended, barrel-fermented, powerful and lush rather than lean. Skin-contact white wines have also gained in popularity. Despite the fact that Friuli receives the most acclaim for its white wines, a significant part of the region is planted with Merlot, Cabernet Franc and Cabernet Sauvignon that can be sold as varietal wines or blended.",
                },
            },
            {
                "name": "Trentino-Alto Adige",
                "synonyms": [
                    "Trentino-South Tyrol",
                    "Trentino-Südtirol",
                    "Trentino Alto Adige",
                ],
                "subregions": [
                    {"name": "South Tyrol", "synonyms": ["Alto Adige", "Südtirol"]},
                    {"name": "Trentino"},
                ],
                "description": {
                    "default": "",
                    "sommelier": "",
                    "julie": "The Trentino-Alto Adige region is subdivided into the Italian-speaking Trentino in the south and the German-speaking Alto-Adige or Südtirol, in the north. Trentino-Alto Adige is primarily known for its white wines, but the region supplies a larger quantity of reds than whites. Schiava (Vernatsch) is the predominant grape and produces light red wines. The Lagrein grape is native to Trentino and produces denser, spicier wines than Schiava. Pinot Nero (Pino Noir) is also becoming increasingly important in the region, especially in the South of the region. Other interesting res grapes of the region include Teroldego and Marzemino. ",
                },
            },
        ],
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of northeastern Italy, Trevenezie is a vibrant tapestry of vineyards where the crispness of Pinot Grigio meets the effervescence of Prosecco, all under the watchful gaze of the Alps. With its clay-rich soils and a climate that dances between the cool mountain breezes and warm Mediterranean influences, this region crafts wines that are as diverse as its breathtaking landscapes.",
            "julie": "",
        },
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (100, 2000),
        "soil_types": "clay",
        "primary_grapes": [
            "Pinot Grigio",
            "Prosecco",
            "Merlot",
            "Sangiovese",
            "Cabernet Sauvignon",
        ],
        "wine_styles": ["red", "white", "sparkling", "medium_bodied", "full_bodied"],
    },
    {
        "country": "IT",
        "name": "Basilicata",
        "synonyms": ["Basilicate"],
        "subregions": [
            {
                "name": "Aglianico del Vulture",
                "synonyms": ["Aglianico del Vulture Superiore", "Vulture"],
            }
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (300, 1000),
        "soil_types": "volcanic",
        "primary_grapes": ["Aglianico"],
        "wine_styles": ["red", "full_bodied", "age_worthy"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of southern Italy, Basilicata is a volcanic wonderland where the Aglianico grape flourishes, yielding robust and age-worthy red wines that are as rich in flavor as the region's storied past. With its dramatic landscapes and a climate that nurtures excellence, this region is a must-visit for any wine enthusiast seeking depth and character in their glass.",
        },
    },
    {
        "country": "LV",
        "name": "Sabile",
        "climate_types": "temperate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Latvia, the Sabile region is a hidden gem for wine enthusiasts, where the mystery of its soil and the allure of its grape varieties promise a delightful exploration of flavors waiting to be uncovered. With its unique climate and potential for diverse wine styles, Sabile invites adventurous palates to discover the unexpected treasures of Baltic viticulture.",
        },
    },
    {
        "country": "LT",
        "name": "Anykščių vynas",
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Lithuania, Anykščių vynas is a hidden gem where the interplay of moderate rainfall and local grape varieties creates wines that are both intriguing and refreshing, inviting adventurous palates to discover its unique character.",
        },
    },
    {
        "country": "LT",
        "name": "Mėmelio vynas",
        "climate_types": "temperate",
        "avg_annual_rainfall": 650.0,
        "elevation_range": (0, 200),
        "soil_types": "clay",
        "primary_grapes": ["Riesling", "Pinot Noir"],
        "wine_styles": ["white", "red"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in a picturesque landscape, Mėmelio vynas is a hidden gem where the crispness of Riesling meets the sophistication of Pinot Noir, producing wines that are as delightful as they are diverse. With its clay soils and gentle elevations, this region crafts both refreshing whites and robust reds that are sure to enchant any wine lover.",
        },
    },
    {
        "country": "LU",
        "name": "Moselle Valley",
        "climate_types": "cool_climate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (100, 400),
        "soil_types": "slate",
        "primary_grapes": ["Riesling", "Pinot Blanc", "Gewürztraminer"],
        "wine_styles": ["white", "sparkling", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Europe, the Moselle Valley enchants with its steep, slate-covered slopes and meandering river, producing some of the world's finest Rieslings. Here, the interplay of cool climate and rich terroir gives rise to wines that are both refreshing and aromatic, perfect for any occasion.",
        },
    },
    {
        "country": "MD",
        "name": "Bardar",
        "climate_types": "continental",
        "avg_annual_rainfall": 500.0,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [
            "Feteasca Neagra",
            "Merlot",
            "Cabernet Sauvignon",
            "Chardonnay",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of wine country, Bardar is a hidden gem where the robust Feteasca Neagra dances alongside the elegance of Chardonnay, crafting wines that are as diverse as the landscape itself. With its unique blend of grape varieties and styles, this region invites wine lovers to explore its rich tapestry of flavors, from bold reds to refreshing sparkling wines.",
        },
    },
    {
        "country": "MD",
        "name": "Codri",
        "climate_types": "continental",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (100, 300),
        "soil_types": "clay",
        "primary_grapes": [
            "Feteasca Neagra",
            "Merlot",
            "Cabernet Sauvignon",
            "Chardonnay",
            "Feteasca Alba",
        ],
        "wine_styles": [
            "red",
            "white",
            "rose",
            "sparkling",
            "medium_bodied",
            "full_bodied",
        ],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Moldova, Codri is a treasure trove for wine lovers, where the earthy clay soils nurture exquisite Feteasca Neagra and elegant Chardonnay, resulting in a delightful spectrum of wines that range from full-bodied reds to crisp sparkling whites. With its moderate climate and rich viticultural heritage, Codri promises a sip of tradition in every glass.",
        },
    },
    {
        "country": "MD",
        "name": "Hîncești",
        "climate_types": "temperate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Moldova, Hîncești is a hidden gem waiting to be discovered, where the mystery of its soils and the promise of its grapes create a canvas for innovative winemaking. This region invites adventurous palates to explore its potential, offering a taste of the unexpected in every sip.",
        },
    },
    {
        "country": "MD",
        "name": "Purcari",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (100, 200),
        "soil_types": "clay",
        "primary_grapes": [
            "Feteasca Neagra",
            "Merlot",
            "Cabernet Sauvignon",
            "Chardonnay",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Moldova, Purcari is a charming wine region where the rich clay soils and gentle elevations yield a delightful spectrum of wines, from bold reds to refreshing whites and even sparkling delights. With its historical roots and a commitment to quality, Purcari invites you to savor the essence of its diverse grape varieties, including the indigenous Feteasca Neagra and classic Merlot.",
        },
    },
    {
        "country": "ME",
        "name": "Crmnica",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "limestone",
        "primary_grapes": ["Vranac", "Krstač"],
        "wine_styles": ["red", "white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Montenegro, Crmnica is a hidden gem where the limestone soils nurture the bold Vranac and the elegant Krstač, resulting in wines that are both vibrant and expressive. Whether you're savoring a deep red or a crisp white, each sip transports you to the sun-drenched hills of this enchanting region.",
        },
    },
    {
        "country": "ME",
        "name": "Plantaže",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 600),
        "soil_types": "limestone",
        "primary_grapes": ["Vranac", "Krstač"],
        "wine_styles": ["red", "white", "medium_bodied", "traditional", "modern"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Montenegro, Plantaže enchants with its limestone-rich soils and a climate that nurtures the bold Vranac and elegant Krstač grapes. Here, winemakers blend tradition with innovation, crafting medium-bodied wines that are as rich in flavor as they are in history.",
        },
    },
    {
        "country": "NL",
        "name": "Groesbeek",
        "climate_types": "temperate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of the Netherlands, Groesbeek is an emerging wine region that promises to surprise with its innovative blends and unique expressions, inviting wine lovers to explore its uncharted potential.",
        },
    },
    {
        "country": "MK",
        "name": "Povardarie",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of the Balkans, Povardarie is a hidden gem waiting to be uncovered, promising a delightful journey through its enigmatic vineyards and potential wine styles that reflect the region's rich heritage and diverse terroir.",
        },
    },
    {
        "country": "MK",
        "name": "Skopsko vinogorje",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "clay",
        "primary_grapes": ["Vranec", "Kratosija"],
        "wine_styles": ["red", "white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of North Macedonia, Skopsko vinogorje is a hidden gem where the bold Vranec and fragrant Kratosija grapes thrive in clay soils, resulting in wines that are as vibrant and diverse as the landscape itself. Whether you prefer a deep, luscious red or a crisp white, this region promises a delightful exploration of flavors.",
        },
    },
    {
        "country": "MK",
        "name": "Tikveš",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of North Macedonia, Tikveš is a hidden gem where ancient winemaking traditions meet modern techniques, producing wines that are both bold and expressive. With its varied climate and rich heritage, this region invites wine lovers to discover its unique character and delightful offerings.",
        },
    },
    {
        "country": "NO",
        "name": "Mostly",
        "climate_types": "maritime",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": ["white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of wine country, Mostly is a hidden gem known for its vibrant white wines that tantalize the palate with crisp acidity and floral notes, inviting wine lovers to explore its unique terroir and the mystery of its grape varieties.",
        },
    },
    {
        "country": "NO",
        "name": "Sognefjord",
        "climate_types": "maritime",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled among the breathtaking fjords of Norway, the Sognefjord region offers a picturesque backdrop for viticulture, where the cool climate and varied topography create a unique environment for grape growing. While the specific grape varieties remain a mystery, the potential for crafting exceptional wines in this stunning locale is as vast as the fjord itself.",
        },
    },
    {
        "country": "PL",
        "name": "Dolny Śląsk",
        "climate_types": "temperate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (200, 600),
        "soil_types": "clay",
        "primary_grapes": ["Riesling", "Pinot Noir", "Chardonnay"],
        "wine_styles": ["red", "white", "sparkling", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Poland, Dolny Śląsk is a hidden gem for wine lovers, where the lush hills and clay soils nurture exquisite Rieslings and elegant Pinot Noirs. This region's unique climate and diverse wine styles promise a delightful exploration of flavors, from crisp whites to vibrant reds and effervescent sparklers.",
        },
    },
    {
        "country": "PL",
        "name": "Kazimierz Dolny",
        "climate_types": "temperate",
        "avg_annual_rainfall": 650.0,
        "elevation_range": (100, 300),
        "soil_types": "clay",
        "primary_grapes": ["Riesling", "Pinot Noir"],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the picturesque landscape of Poland, Kazimierz Dolny is a hidden gem where the elegance of Riesling meets the boldness of Pinot Noir, all nurtured by the region's clay soils and gentle rainfall. This charming locale offers a delightful array of wines, from refreshing whites to sophisticated reds and effervescent sparklers, perfect for any palate.",
        },
    },
    {
        "country": "PL",
        "name": "Małopolska",
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (200, 400),
        "soil_types": "clay",
        "primary_grapes": ["Riesling", "Pinot Noir", "Sauvignon Blanc"],
        "wine_styles": ["red", "white", "traditional", "modern"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Poland, Małopolska is a hidden gem where the elegance of Riesling meets the boldness of Pinot Noir, all nurtured by clay soils and a temperate climate. This region offers a delightful blend of traditional and modern wines, inviting connoisseurs to savor its unique character.",
        },
    },
    {
        "country": "PL",
        "name": "Podkarpacie",
        "climate_types": "continental",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Poland, Podkarpacie offers a tantalizing glimpse into the country's burgeoning wine scene, where mystery and potential intertwine. With its undisclosed soil types and a promise of diverse grape varieties, this region invites curious palates to explore its uncharted vinous landscapes.",
        },
    },
    {
        "country": "PL",
        "name": "Warka",
        "climate_types": "continental",
        "avg_annual_rainfall": 700.0,
        "elevation_range": (100, 300),
        "soil_types": "clay",
        "primary_grapes": ["Riesling", "Pinot Noir", "Sauvignon Blanc"],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in a picturesque landscape, Warka is a hidden gem where the clay soils nurture exquisite Riesling and Pinot Noir, alongside refreshing Sauvignon Blanc. This region's unique climate and elevation create a delightful playground for winemakers, resulting in a captivating array of red, white, and sparkling wines that are sure to enchant any palate.",
        },
    },
    {
        "country": "PL",
        "name": "Zielona Góra",
        "climate_types": "temperate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 200),
        "soil_types": "clay",
        "primary_grapes": ["Pinot Noir", "Riesling", "Sauvignon Blanc"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Poland, Zielona Góra is a hidden gem for wine lovers, where the clay soils nurture exquisite Pinot Noir and vibrant Riesling, producing wines that are as charming as the region itself. With a perfect blend of tradition and innovation, this area promises a delightful tasting experience that showcases the best of Polish viticulture.",
        },
    },
    {
        "country": "PT",
        "name": "Lisboa",
        "synonyms": ["Lisbon"],
        "description": {
            "default": "",
            "sommelier": "Lisboa is a captivating wine region where the Atlantic breeze dances through vineyards, nurturing a rich tapestry of grape varieties that yield wines full of character and charm. With its blend of tradition and innovation, this region invites wine lovers to explore its delightful offerings, each sip telling a story of its coastal heritage.",
            "julie": "The coastal Lisboa IGP covers the area south of Beiras and runs up to Portugal’s capital city. Lisboa contains nine individual DOPs : Bucelas, Colares, Carcavelos, Arruda, Torres Vedas, Alenquer, Óbidos, Lourinhã and Encostas d’Aire. Lourinhå produces aguardente ",
        },
        "climate_types": "coastal",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
    },
    {
        "country": "PT",
        "name": "Península de Setúbal",
        "synonyms": ["Setúbal", "Setúbal Peninsula"],
        "subregions": [{"name": "Palmela"}],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 300),
        "soil_types": "clay",
        "primary_grapes": ["Muscat", "Castelão"],
        "wine_styles": ["red", "white", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the stunning Portuguese coastline, the Península de Setúbal is a treasure trove of flavor, celebrated for its luscious Muscat and robust Castelão grapes. With a perfect blend of sun, clay soils, and a maritime breeze, this region crafts wines that are as vibrant and diverse as its breathtaking landscapes.",
        },
    },
    {
        "country": "PT",
        "name": "Alentejo",
        "description": {
            "default": "",
            "sommelier": "Nestled in the sun-drenched heart of Portugal, Alentejo is a treasure trove of flavors, where the robust Trincadeira grape crafts luscious reds and refreshing whites that dance on the palate. With its warm climate and varied soils, this region offers a delightful exploration of Portuguese winemaking traditions.",
            "julie": "The Alentejo DOP is located withing the Alentejano IGP that covers 30% of Portugal’s landmass. The DOP includes 8 subzones : Moura, Granja-Amareleja, Évora, Vidigueira, Reguengos, Redondo, Borba, and Portalegre. Red wine production exceeds that of whites and Trincadeira is the most planted variety. The region is also known for its plantation of cork tree and its cork production. ",
        },
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": ["Trincadeira"],
        "wine_styles": ["red", "white"],
    },
    {
        "country": "PT",
        "name": "Bairrada",
        "climate_types": "temperate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (50, 300),
        "soil_types": "clay",
        "primary_grapes": ["Baga", "Touriga Nacional", "Arinto", "Bical"],
        "wine_styles": ["red", "white", "sparkling", "medium_bodied", "full_bodied"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Bairrada is a hidden gem in Portugal, celebrated for its rich, full-bodied reds and refreshing whites, all nurtured by the region's unique clay soils and temperate climate. With a legacy steeped in tradition, this region offers a delightful exploration of indigenous grapes like Baga and Touriga Nacional, making it a must-visit for any wine enthusiast.",
        },
    },
    {
        "country": "PT",
        "name": "Bucelas",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (100, 300),
        "soil_types": "clay",
        "primary_grapes": ["Arinto"],
        "wine_styles": ["white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Bucelas is a hidden gem in Portugal, celebrated for its crisp and refreshing Arinto wines that dance with citrus and mineral notes, making it a delightful choice for those seeking a taste of the country's lesser-known viticultural treasures. The region's clay soils and moderate elevation create the perfect backdrop for producing both elegant whites and sparkling wines that are sure to impress.",
        },
    },
    {
        "country": "PT",
        "name": "Carcavelos",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 200),
        "soil_types": "sandy",
        "primary_grapes": ["Arinto", "Muscat"],
        "wine_styles": ["white", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the Portuguese coast, Carcavelos is a hidden gem known for its sandy soils and delightful wines, primarily crafted from Arinto and Muscat grapes. This region's fortified and white wines are a testament to its rich maritime heritage, offering a taste of the Atlantic in every sip.",
        },
    },
    {
        "country": "PT",
        "name": "Colares",
        "climate_types": "coastal",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 200),
        "soil_types": "sandy",
        "primary_grapes": ["Ramisco", "Garnacha", "Malvasia"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the Atlantic coast, Colares is a treasure trove of sandy soils and maritime breezes, producing exquisite wines from the indigenous Ramisco and Malvasia grapes. With a delightful array of styles, including vibrant reds and elegant sparklings, this region invites wine lovers to explore its rich history and unique terroir.",
        },
    },
    {
        "country": "PT",
        "name": "Dão",
        "climate_types": "temperate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (200, 800),
        "soil_types": "clay",
        "primary_grapes": ["Touriga Nacional", "Tinta Roriz", "Jaen", "Alfrocheiro"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "The Dão region is a picturesque wine haven, where the majestic mountains cradle vineyards that yield exquisite wines, particularly known for their rich reds and vibrant whites. With its clay soils and a climate that dances between warmth and coolness, Dão offers a delightful exploration of Portugal's winemaking heritage.",
        },
    },
    {
        "country": "PT",
        "name": "Lagoa",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of wine country, Lagoa is a hidden gem waiting to be discovered, where the mystery of its unknown soils hints at the potential for exceptional and unique wine expressions. With a promise of delightful surprises, this region invites adventurous palates to explore its uncharted grape varieties and styles.",
        },
    },
    {
        "country": "PT",
        "name": "Lagos",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 200),
        "soil_types": "sandy",
        "primary_grapes": ["Touriga Nacional", "Aragonez", "Alvarinho", "Verdejo"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the sun-kissed landscapes of Lagos, this region boasts a delightful array of wines crafted from indigenous grapes like Touriga Nacional and Alvarinho. With its sandy soils and a climate that nurtures both red and white varietals, Lagos is a treasure trove for wine enthusiasts seeking both tradition and innovation in every sip.",
        },
    },
    {
        "country": "PT",
        "name": "Madeira",
        "climate_types": "maritime",
        "avg_annual_rainfall": 1200.0,
        "elevation_range": (0, 1500),
        "soil_types": "volcanic",
        "primary_grapes": ["Tinta Negra", "Sercial", "Verdelho", "Bual", "Malvasia"],
        "wine_styles": [
            "red",
            "white",
            "fortified",
            "dessert",
            "medium_bodied",
            "age_worthy",
        ],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Madeira is a wine lover's paradise, where the volcanic soils and varied elevations produce a stunning array of fortified wines, from the crisp and refreshing Sercial to the luscious sweetness of Malvasia. With an average annual rainfall of 1200 mm, this island region crafts age-worthy wines that are as captivating as the landscapes they come from.",
        },
    },
    {
        "country": "PT",
        "name": "Portimão",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 300),
        "soil_types": "sandy",
        "primary_grapes": ["Touriga Nacional", "Aragonez", "Trincadeira", "Alvarinho"],
        "wine_styles": ["red", "white", "rose", "sparkling", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the Algarve, Portimão is a sun-kissed paradise where sandy soils nurture a delightful mix of Touriga Nacional and Aragonez, producing everything from luscious reds to zesty whites and sparkling wines. This region's diverse offerings and charming coastal backdrop make it a must-visit for any wine lover seeking adventure in their glass.",
        },
    },
    {
        "country": "PT",
        "name": "Porto e Douro",
        "synonyms": ["Douro", "Douro Valley", "Porto", "Duoro"],
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of Portugal, the Porto e Douro region is celebrated for its breathtaking landscapes and rich winemaking heritage, where the iconic Touriga Nacional and Tinta Roriz flourish amidst the dramatic schist slopes, crafting wines that are as complex as the terrain itself.",
            "julie": "The Douro was Portugal’s first demarcated wine region and is a UNESCO World Heritage Site. The Douro river and its tributaries have carved deep valleys through the granitic Marão and Montemuro Mountains, and vineyards run from the riverside up the terraced, precipitous slopes. Schist is in abundance throughout the zone. The Douro Valley experiences a continental climate of severely hot summers and cold winters. The region’s craggy mountains act as barriers to the humid Atlantic winds, and the Douro becomes progressively drier and hotter toward the Spanish border. There are three subzones in Douro; Baixo Corgo to the west has the highest density of plantings, Cima Corgo has the highest total vineyard acreage, and Douro Superior, which stretches to the Spanish border, is the largest, most arid, and most sparsely planted region in Douro. The region is famous for the production of fortified wines known as Port wines that represent about 50% of the total production. Table wines are produced as Douro DOP and can be white, rosé, red, sweet and sparkling.",
        },
        "climate_types": "continental",
        "avg_annual_rainfall": None,
        "elevation_range": (0, 800),
        "soil_types": "schist",
        "primary_grapes": [
            "Touriga Nacional",
            "Touriga Franca",
            "Tinta Roriz",
            "Tinta Barroca",
            "Tinto Cão",
            "Rabigato",
            "Gouveio",
            "Viosinho",
        ],
        "wine_styles": ["fortified", "red", "white", "rose", "sparkling", "dessert"],
    },
    {
        "country": "PT",
        "name": "Setúbal",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 500),
        "soil_types": "sandy",
        "primary_grapes": ["Muscat of Alexandria", "Castelão", "Trincadeira"],
        "wine_styles": ["red", "white", "dessert", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the stunning Portuguese coastline, Setúbal is a treasure trove of flavors, where the sun-kissed Muscat of Alexandria dances with the hearty Castelão and Trincadeira, producing everything from delightful dessert wines to robust reds. With its sandy soils and a climate that whispers of the Mediterranean, this region invites you to explore its rich tapestry of wine styles.",
        },
    },
    {
        "country": "PT",
        "name": "Tavira",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": ["Touriga Nacional", "Alvarinho", "Arinto"],
        "wine_styles": ["red", "white", "rose", "sparkling", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the sun-kissed landscapes of Portugal, Tavira is a delightful treasure trove for wine lovers, where the bold flavors of Touriga Nacional dance alongside the crisp elegance of Alvarinho, crafting everything from luscious reds to refreshing sparkling wines. This region invites exploration, promising a sip of its enchanting diversity in every glass.",
        },
    },
    {
        "country": "PT",
        "name": "Vinhos Verdes",
        "synonyms": ["Vinho Verde", "Minho"],
        "climate_types": "maritime",
        "avg_annual_rainfall": 1200.0,
        "elevation_range": (0, 500),
        "soil_types": "clay",
        "primary_grapes": ["Alvarinho", "Loureiro", "Trajadura"],
        "wine_styles": ["white", "rose", "red", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Vinhos Verdes is a delightful Portuguese wine region celebrated for its crisp and effervescent wines, often enjoyed young and fresh. With a backdrop of rolling hills and fertile clay soils, this region produces a symphony of flavors that dance on the palate, making it a perfect companion for seafood and sunny afternoons.",
        },
    },
    {
        "country": "RO",
        "name": "Banat",
        "subregions": [
            {"name": "Arad"},
            {"name": "Jamu Mare"},
            {"name": "Măderat"},
            {"name": "Miniș"},
            {"name": "Moldova Nouă"},
            {"name": "Recaș"},
            {"name": "Silagiu"},
            {"name": "Teremia"},
            {"name": "Tirol"},
        ],
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 300),
        "soil_types": "clay",
        "primary_grapes": [
            "Fetească Neagră",
            "Merlot",
            "Cabernet Sauvignon",
            "Chardonnay",
            "Sauvignon Blanc",
        ],
        "wine_styles": [
            "red",
            "white",
            "rose",
            "sparkling",
            "medium_bodied",
            "full_bodied",
        ],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Eastern Europe, Banat is a hidden gem where the clay soils nurture a delightful array of wines, from the bold Fetească Neagră to the crisp Sauvignon Blanc. With a climate that dances between warmth and coolness, this region crafts wines that are as diverse as its landscape, inviting enthusiasts to explore its rich tapestry of flavors.",
        },
    },
    {
        "country": "RU",
        "name": "Caucasus",
        "climate_types": "temperate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (200, 2500),
        "soil_types": "clay",
        "primary_grapes": ["Saperavi", "Rkatsiteli", "Kisi"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled between Europe and Asia, the Caucasus is a vinous treasure trove where ancient traditions meet modern winemaking, producing everything from bold Saperavi reds to aromatic Rkatsiteli whites. With its dramatic landscapes and rich clay soils, this region invites wine lovers to explore its diverse offerings, each sip telling a story of its storied past.",
        },
    },
    {
        "country": "RU",
        "name": "Krasnodar",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 500),
        "soil_types": "clay",
        "primary_grapes": ["Cabernet Sauvignon", "Merlot", "Chardonnay", "Saperavi"],
        "wine_styles": ["red", "white", "rose", "sparkling", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Russia, Krasnodar is a vibrant wine region where the sun-kissed clay soils nurture a delightful mix of grape varieties, including the bold Cabernet Sauvignon and the aromatic Chardonnay. With its diverse wine styles ranging from luscious reds to refreshing sparkling wines, Krasnodar is a hidden gem waiting to be explored by adventurous palates.",
        },
    },
    {
        "country": "RU",
        "name": "Stavropol",
        "climate_types": "continental",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (200, 800),
        "soil_types": "clay",
        "primary_grapes": [
            "Cabernet Sauvignon",
            "Merlot",
            "Chardonnay",
            "Sauvignon Blanc",
        ],
        "wine_styles": ["red", "white", "sparkling", "medium_bodied"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Russia, Stavropol is a hidden gem for wine lovers, where the clay soils nurture bold Cabernet Sauvignon and elegant Chardonnay, resulting in a delightful array of medium-bodied reds and whites. With its picturesque landscapes and a climate that dances between warmth and coolness, this region promises a unique tasting experience that reflects its rich terroir.",
        },
    },
    {
        "country": "RS",
        "name": "Banat",
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 300),
        "soil_types": "clay",
        "primary_grapes": ["Prokupac", "Chardonnay", "Cabernet Sauvignon", "Merlot"],
        "wine_styles": ["red", "white", "sparkling", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Eastern Europe, the Banat region boasts a delightful tapestry of wines, where the indigenous Prokupac dances alongside the elegance of Chardonnay and the boldness of Cabernet Sauvignon. With its clay soils and moderate climate, Banat produces a spectrum of styles, from luscious reds to effervescent sparkling wines, inviting all to explore its vinous treasures.",
        },
    },
    {
        "country": "SK",
        "name": "Malokarpatská",
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (150, 400),
        "soil_types": "clay",
        "primary_grapes": [
            "Frankovka",
            "Riesling",
            "Veltlinske Zelené",
            "Sauvignon Blanc",
        ],
        "wine_styles": ["red", "white", "medium_bodied", "full_bodied"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Slovakia, Malokarpatská is a hidden gem where the robust Frankovka and refreshing Riesling thrive, producing wines that are both medium and full-bodied, perfect for any palate. With its clay-rich soils and picturesque elevations, this region invites wine lovers to explore its delightful offerings.",
        },
    },
    {
        "country": "SK",
        "name": "Južnoslovenská",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Southern Slovakia, Južnoslovenská is a hidden gem for wine enthusiasts, promising a delightful journey through its diverse offerings. With a climate that nurtures a variety of grape styles, this region invites you to discover its unique character and potential for exquisite wines.",
        },
    },
    {
        "country": "SK",
        "name": "Nitrianska",
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (150, 400),
        "soil_types": "clay",
        "primary_grapes": [
            "Grüner Veltliner",
            "Riesling",
            "Frankovka",
            "Veltlinské Zelené",
        ],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Slovakia, Nitrianska is a hidden gem where clay soils nurture a delightful array of wines, from the zesty whites of Grüner Veltliner and Riesling to the bold reds of Frankovka. With an average rainfall of 600 mm and elevations that enhance the complexity of its wines, this region invites wine lovers to explore its charming offerings.",
        },
    },
    {
        "country": "SK",
        "name": "Stredoslovenská",
        "climate_types": "continental",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Slovakia, Stredoslovenská is a hidden gem where the interplay of climate and elevation creates a canvas for winemakers to craft distinctive wines. With its untapped potential, this region invites adventurous palates to discover the unique flavors that emerge from its mysterious terroir.",
        },
    },
    {
        "country": "SK",
        "name": "Tokaj",
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 400),
        "soil_types": "volcanic",
        "primary_grapes": ["Furmint", "Hárslevelű"],
        "wine_styles": ["white", "dessert", "fortified", "traditional"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Hungary, Tokaj is a treasure trove of volcanic soils and lush vineyards, where the Furmint and Hárslevelű grapes flourish to create some of the world's most celebrated sweet wines. With a rich history and a climate that dances between rain and sunshine, this region is a must-visit for any wine lover seeking to indulge in its luscious, honeyed delights.",
        },
    },
    {
        "country": "SK",
        "name": "Východoslovenská",
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (200, 400),
        "soil_types": "clay",
        "primary_grapes": ["Frankovka", "Riesling"],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Eastern Slovakia, Východoslovenská is a hidden gem where the robust Frankovka and elegant Riesling thrive in clay soils, producing wines that are as diverse as the landscape itself. Whether you're sipping a bold red or a refreshing sparkling wine, this region promises a delightful journey for the palate.",
        },
    },
    {
        "country": "SK",
        "name": "The whole of southern Slovakia",
        "climate_types": "temperate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 400),
        "soil_types": "loess",
        "primary_grapes": [
            "Frankovka",
            "Veltlinske Zelene",
            "Rizling",
            "Cabernet Sauvignon",
            "Merlot",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Southern Slovakia boasts a rich tapestry of vineyards where Frankovka and Veltlinske Zelene thrive alongside international favorites like Cabernet Sauvignon and Merlot. With its loess soils and a climate that nurtures both red and white varietals, this region offers a delightful exploration of flavors, perfect for any wine enthusiast.",
        },
    },
    {
        "country": "SI",
        "name": "Podravje",
        "climate_types": "continental",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (150, 400),
        "soil_types": "clay",
        "primary_grapes": ["Sauvignon Blanc", "Riesling", "Pinot Noir"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Slovenia, Podravje is a treasure trove for wine lovers, where the lush clay soils nurture vibrant Sauvignon Blanc and Riesling, alongside the delicate charm of Pinot Noir. With its picturesque landscapes and a delightful array of red, white, and rosé wines, this region invites you to explore its rich vinous tapestry.",
        },
    },
    {
        "country": "SI",
        "name": "Posavje",
        "climate_types": "temperate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Slovenia, Posavje is a captivating region where tradition meets innovation, offering a delightful array of wines that showcase the area's unique character and charm. With its picturesque landscapes and a commitment to quality, this region invites wine lovers to explore its hidden treasures and experience the essence of Slovenian viticulture.",
        },
    },
    {
        "country": "SI",
        "name": "Primorska",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (100, 400),
        "soil_types": "clay",
        "primary_grapes": [
            "Sauvignon Blanc",
            "Chardonnay",
            "Merlot",
            "Cabernet Sauvignon",
            "Pinot Noir",
        ],
        "wine_styles": [
            "red",
            "white",
            "rose",
            "sparkling",
            "medium_bodied",
            "full_bodied",
        ],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the picturesque landscapes of Slovenia, Primorska is a vibrant wine region where the sun-kissed hills nurture a medley of grape varieties, producing everything from crisp Sauvignon Blanc to luscious Merlot. With its clay soils and a climate that dances between Mediterranean warmth and alpine freshness, this region offers a delightful exploration of both traditional and innovative wine styles.",
        },
    },
    {
        "country": "ES",
        "name": "Andalusia",
        "subregions": [
            {"name": "Condado de Huelva"},
            {
                "name": "Jerez-Xeres-Sherry",
                "synonyms": ["Jerez", "Xeres", "Sherry", "Jeres"],
            },
            {"name": "Málaga and Sierras de Málaga"},
            {"name": "Manzanilla"},
            {"name": "Montilla-Moriles"},
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 1000),
        "soil_types": "sandy",
        "primary_grapes": ["Palomino", "Pedro Ximénez", "Muscat"],
        "wine_styles": ["red", "white", "fortified", "dessert", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Andalusia is a sun-drenched paradise where the sandy soils nurture a vibrant array of wines, from the refreshing whites of Palomino to the indulgent dessert wines of Pedro Ximénez. This region's rich history and diverse climate create a delightful playground for wine lovers seeking both tradition and innovation.",
        },
    },
    {
        "country": "ES",
        "name": "Aragón",
        "synonyms": ["Aragon"],
        "subregions": [
            {"name": "Calatayud"},
            {"name": "Campo de Borja"},
            {"name": "Campo de Cariñena", "synonyms": ["Cariñena"]},
            {"name": "Cava"},
            {"name": "Somontano"},
        ],
        "climate_types": "continental",
        "avg_annual_rainfall": 400.0,
        "elevation_range": (300, 1200),
        "soil_types": "clay",
        "primary_grapes": ["Garnacha", "Tempranillo", "Macabeo", "Chardonnay"],
        "wine_styles": ["red", "white", "rose", "sparkling", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Spain, Aragón is a treasure trove of wine styles, from bold reds to elegant sparkling wines, all crafted from its signature grapes like Garnacha and Tempranillo. With its varied elevations and clay-rich soils, this region offers a delightful exploration of flavors that reflect its vibrant terroir.",
        },
    },
    {
        "country": "ES",
        "name": "Balearic Islands",
        "subregions": [
            {"name": "Binissalem-Mallorca", "synonyms": ["Binissalem", "Mallorca"]},
            {"name": "Plà i Llevant"},
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (0, 600),
        "soil_types": "limestone",
        "primary_grapes": [
            "Manto Negro",
            "Callet",
            "Tempranillo",
            "Chardonnay",
            "Macabeo",
        ],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "The Balearic Islands are a sun-kissed paradise where limestone soils nurture a delightful medley of wines, from the bold Manto Negro reds to the crisp Chardonnay whites. With a backdrop of stunning landscapes and a vibrant culture, this region offers a refreshing escape for wine lovers seeking both tradition and innovation in every sip.",
        },
    },
    {
        "country": "ES",
        "name": "Basque Country",
        "synonyms": [
            "Euskadi",
            "País Vasco",
            "La Comunidad Autonoma del País Vasco",
            "El País Vasco",
        ],
        "subregions": [
            {
                "name": "Alava",
                "synonyms": [
                    "Álava",
                    "Alavan Txakolina",
                    "Alavan Txakoli",
                    "Arabako Txakolina",
                    "Araba",
                ],
            },
            {
                "name": "Biscay",
                "synonyms": [
                    "Bizkaiko",
                    "Bizkaiko Txakolina",
                    "Biscay",
                    "Biscayan Txakoli",
                ],
            },
            {"name": "Cava"},
            {
                "name": "Getaria",
                "synonyms": [
                    "Getariako Txakolina",
                    "Getaria",
                    "Getarian Txakoli",
                    "Txakoli de Getaria",
                ],
            },
        ],
        "climate_types": "maritime",
        "avg_annual_rainfall": 1200.0,
        "elevation_range": (0, 600),
        "soil_types": "clay",
        "primary_grapes": ["Hondarrabi Zuri", "Hondarrabi Beltza"],
        "wine_styles": ["white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the verdant hills of northern Spain, the Basque Country is a treasure trove of zesty white and effervescent sparkling wines, primarily crafted from the indigenous Hondarrabi grapes. With its rich culinary traditions and stunning coastal scenery, this region offers a perfect pairing of wine and gastronomy that is sure to tantalize the senses.",
        },
    },
    {
        "country": "ES",
        "name": "Canary Islands",
        "subregions": [
            {"name": "Abona"},
            {"name": "El Hierro"},
            {"name": "Gran Canaria"},
            {"name": "La Gomera"},
            {"name": "La Palma"},
            {"name": "Lanzarote"},
            {"name": "Tacoronte-Acentejo"},
            {"name": "Valle de Güímar"},
            {"name": "Valle de la Orotava"},
            {"name": "Ycoden-Daute-Isora"},
        ],
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": (0, 3718),
        "soil_types": "volcanic",
        "primary_grapes": [
            "Listán Negro",
            "Listán Blanco",
            "Malvasía",
            "Garnacha",
            "Syrah",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "The Canary Islands are a vinous treasure trove, where the sun-kissed volcanic soils nurture a medley of grapes like Listán Negro and Malvasía, crafting everything from bold reds to refreshing whites and even sparkling delights. With elevations soaring up to 3718 meters, each sip transports you to a landscape where the earth's fiery origins meet the ocean's cool embrace.",
        },
    },
    {
        "country": "ES",
        "name": "Castile and León",
        "synonyms": [
            "Castilla y León",
            "Castilla y Leon",
            "Castile-Leon",
            "Espumosos de Castilla y León",
        ],
        "subregions": [
            {"name": "Arlanza"},
            {"name": "Arribes del Duero", "synonyms": ["Arribes"]},
            {"name": "Bierzo"},
            {"name": "Cava"},
            {"name": "Cebreros"},
            {"name": "Cigales"},
            {
                "name": "Castilla y Leon VT",
                "synonyms": ["Vino de la Tierra Castilla y León"],
            },
            {"name": "León", "synonyms": ["Tierra de León"]},
            {"name": "Ribera del Duero"},
            {"name": "Rueda"},
            {"name": "Sardon de Duero", "synonyms": ["Sardón de Duero"]},
            {"name": "Sierra de Salamanca"},
            {"name": "Zamora", "synonyms": ["Tierra del Vino de Zamora"]},
            {"name": "Toro"},
            {"name": "Valles de Benavente"},
            {"name": "Valtiendas"},
        ],
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of Spain, Castile and León is a treasure trove of winemaking, where the robust Tempranillo and elegant Verdejo flourish, crafting wines that are as bold and vibrant as the region's storied history. With a blend of tradition and innovation, this region offers a delightful exploration of flavors that will enchant any wine lover.",
            "julie": "Castilla y León is located in north central Spain. The region is crossed by the Duero River that flows westward through the centre of the region and passes the DOs of Ribera del Duero, Toro, Tierra del Vino de Zamora and Arribes on its way to Portugal. Other DOs of the region include Arlanza, Cigales, Leòn and Bierzo. The main red grape varieties of Castilla y León are Tempranillo and Mencia while the main white grape varieties are Verdejo, Viura and Godello. ",
        },
        "climate_types": "continental",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": ["Tempranillo", "Mencia", "Verdejo", "Viura", "Godello"],
        "wine_styles": ["red", "white", "uknown"],
    },
    {
        "country": "ES",
        "name": "Castile–La Mancha",
        "synonyms": [
            "Castilla-La Mancha",
            "Castilla La Mancha",
            "Castila la Mancha",
            "Vino de la Tierra Castilla",
        ],
        "subregions": [
            {"name": "Almansa"},
            {"name": "Guijoso", "synonyms": ["Pago Guijoso"]},
            {"name": "La Mancha"},
            {"name": "Manchuela"},
            {"name": "Méntrida"},
            {"name": "Mondéjar"},
            {"name": "Ribera del Júcar"},
            {"name": "Toledo", "subregions": [{"name": "Dominio de Valdepusa"}]},
            {"name": "Uclés"},
            {"name": "Valdepeñas"},
        ],
        "description": {
            "default": "",
            "sommelier": "Castile–La Mancha, the heart of Spain's wine production, offers a delightful array of wines, from the robust reds of Cencibel to the crisp whites of Airén. With its sun-soaked vineyards and a rich tapestry of flavors, this region is a treasure trove for wine lovers seeking both quality and affordability.",
            "julie": "Castilla-La-Mancha is home to La Mancha DO, Europe’s largest single demarcated wine region. The principal grapes of the region are Cencibel (Tempranillo) and Airén, which thrive in La Mancha’s hot, dry environment. ",
        },
        "climate_types": "hot_climate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": ["Cencibel", "Airén"],
        "wine_styles": ["red", "white", "rose", "fortified", "blend"],
    },
    {
        "country": "ES",
        "name": "Catalonia",
        "synonyms": ["Catalunya", "Cataluña"],
        "subregions": [
            {"name": "Alella"},
            {"name": "Conca de Barberà"},
            {"name": "Costers del Segre"},
            {"name": "Empordà"},
            {"name": "Montsant"},
            {"name": "Penedès", "subregions": [{"name": "Cava"}]},
            {"name": "Pla de Bages"},
            {"name": "Priorat"},
            {"name": "Tarragona"},
            {"name": "Terra Alta"},
        ],
        "description": {
            "default": "",
            "sommelier": "Catalonia is a dynamic wine region that dances between tradition and modernity, producing everything from bold reds to elegant sparkling wines. With its rich cultural heritage and diverse grape varieties, this region invites wine lovers to indulge in a tapestry of flavors that reflect its spirited identity.",
            "julie": "Catalonia, or Catalunya in the Catalan language, is located very near to France’s Roussillon region. Catalunya is the centre of production for Cava wines, a Spanish traditional method sparkling wine that founds its origin within the sub-region of Penedes. The region has a Mediterranean climamte and is home to 12 DOs (Denominacion de Origen) and 1 DOCa, the highest distinction for a wine region in Spain. Catalonia produces a wide range of wines from dry to sweet, white to red, sparkling and oxidative. Elevation, distance from the sea and geology as well as the choice of grape varieties are all factors that have an impact on the styles of the wines of the region. Notable regions include Priorat DOCa, Conca del Barvera DO, Costers del Segre DO, Penedes DO, etc.",
        },
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [
            "red",
            "white",
            "sparkling",
            "dessert",
            "fortified",
            "traditional",
            "modern",
        ],
    },
    {
        "country": "ES",
        "name": "Extremadura",
        "subregions": [{"name": "Cava"}, {"name": "Ribera del Guadiana"}],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (200, 800),
        "soil_types": "clay",
        "primary_grapes": ["Tempranillo", "Airén", "Garnacha", "Macabeo"],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Spain, Extremadura is a hidden gem where the robust Tempranillo and refreshing Airén thrive amidst clay soils and a sun-kissed climate, producing wines that range from bold reds to crisp whites and even delightful sparkling varieties. This region invites adventurous palates to explore its rich tapestry of flavors and styles.",
        },
    },
    {
        "country": "ES",
        "name": "Galicia",
        "subregions": [
            {"name": "Monterrey"},
            {"name": "Rías Baixas"},
            {"name": "Ribeira Sacra"},
            {"name": "Ribeiro"},
            {"name": "Valdeorras"},
        ],
        "description": {
            "default": "",
            "sommelier": "Galicia is a hidden gem of Spanish winemaking, where the crisp, aromatic Albariño dances with the sea breeze, and the elegant Mencía reveals the region's soulful character. With its lush landscapes and diverse grape varieties, this enchanting region offers a delightful exploration of refreshing whites, charming rosés, and expressive reds.",
            "julie": "Galicia is one of Spain’s greenest region with lush vegetation and forests and is located at the border with Portugal. The region maritime climate is also ideal for the production of crisp white wines as well as fresh rosé and reds. The five DOs of Galicia are Ríais Baixas, Ribeiro, Valdeorras, Ribeira Sacra and Monterrei. Albariño is the most planted grape in the Ríais Baixas DO and represents 96% of the plantings in the region. Ribeiro DO is of the Spain’s oldest wine region and produces white wines made from Treixadura and red wines made from Caiño. In recent years, Ribeira Sacra DO has produced some of Spain’s most sought-after wines.This remote wine region’s best red and wine wines are made from the Mencía, Treixadura and Godello grape varieties. Finally, Valdeorras is Galicia’s easternmost DO and is best known for the quality of its dry white wines made from the Godello grape variety. ",
        },
        "climate_types": "maritime",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": ["Albariño", "Treixadura", "Caiño", "Mencía", "Godello"],
        "wine_styles": ["white", "rose", "red"],
    },
    {
        "country": "ES",
        "name": "La Rioja",
        "synonyms": ["Rioja"],
        "subregions": [{"name": "Cava"}],
        "description": {
            "default": "",
            "sommelier": "La Rioja is a vibrant tapestry of wine styles, where the noble Tempranillo reigns supreme amidst a backdrop of clay soils and rolling hills. This enchanting region crafts everything from robust reds to refreshing whites, making it a must-visit for any wine lover seeking both tradition and innovation.",
            "julie": "The region of Rioja is named after the Oja river, a small tributary to the Ebro and was the first Spanish region to be awarded a DOCa (the highest appellation level in Spain), in 1991. The region is located between Haro to the north west to Alfaro in the south east and it is divided in to three subregions : Rioja Alta, Rioja Alavesa, Rioja Oriental. Each of these subregions have a specific climate and soil type that impact the styles of wine produced. Tempranillo is the main grape for the production of red Rioja and is traditionally blended with Mazuelo, Graciano, Garnacha and Maturana Tinta. Viura, also called Macabeo, is the principal white grape for the production of white Rioja. Rioja wines are be labelled as Joven, Crianza, Reserva and Gran Reserva depending on their time of ageing in cask and bottle before release. A small amount of Rioja is also produced as rosé wine and since 2018, the region is also allowed to produce some sparkling wines sold as “vino espumoso de Calidad”. ",
        },
        "climate_types": "temperate",
        "avg_annual_rainfall": 450.0,
        "elevation_range": (300, 800),
        "soil_types": "clay",
        "primary_grapes": [
            "Tempranillo",
            "Mazuelo",
            "Graciano",
            "Garnacha",
            "Maturana Tinta",
            "Viura",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling", "blend", "traditional"],
    },
    {
        "country": "ES",
        "name": "Community of Madrid",
        "subregions": [{"name": "Vinos de Madrid"}],
        "synonyms": ["Madrid"],
        "climate_types": "continental",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (600, 1200),
        "soil_types": "clay",
        "primary_grapes": ["Tempranillo", "Garnacha"],
        "wine_styles": ["red", "white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Spain, the Community of Madrid boasts a rich tapestry of vineyards where the bold Tempranillo and lively Garnacha thrive, producing wines that are as dynamic as the city itself. With its clay soils and varying elevations, this region crafts delightful reds and whites that capture the essence of Spanish viticulture.",
        },
    },
    {
        "country": "ES",
        "name": "Región de Murcia",
        "synonyms": ["Murcia"],
        "subregions": [{"name": "Bullas"}, {"name": "Jumilla"}, {"name": "Yecla"}],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 300.0,
        "elevation_range": (200, 800),
        "soil_types": "clay",
        "primary_grapes": ["Monastrell", "Tempranillo", "Syrah", "Cabernet Sauvignon"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in southeastern Spain, the Región de Murcia is a sun-drenched paradise for wine lovers, where the bold Monastrell grape reigns supreme, crafting wines that are as rich and vibrant as the landscape itself. With a diverse range of styles from luscious reds to crisp rosés, this region invites you to explore its unique character and charm.",
        },
    },
    {
        "country": "ES",
        "name": "Navarre",
        "subregions": [{"name": "Cava"}, {"name": "Navarra"}],
        "climate_types": "temperate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (200, 800),
        "soil_types": "clay",
        "primary_grapes": ["Tempranillo", "Garnacha", "Chardonnay", "Viura"],
        "wine_styles": ["red", "white", "sparkling", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Navarre is a hidden gem of Spanish winemaking, where the lush landscapes and varied elevations create a playground for grape varieties like Tempranillo and Garnacha. This region delights wine lovers with its eclectic offerings, from bold reds to crisp whites and even sparkling wines, all crafted with a touch of local charm.",
        },
    },
    {
        "country": "ES",
        "name": "Valencian Community",
        "synonyms": ["Valencia"],
        "subregions": [
            {"name": "Alicante"},
            {"name": "Cava"},
            {"name": "Utiel-Requena"},
        ],
        "description": {
            "default": "",
            "sommelier": "Nestled along Spain's eastern coast, the Valencian Community is a vibrant tapestry of sun-soaked vineyards where the indigenous Merseguera and Bobal grapes flourish, crafting wines that are as diverse as the landscape itself—from refreshing whites to bold reds and sweet delights, each sip tells a story of its sun-drenched origins.",
            "julie": "Valencia is simultaneously the name of the autonomía, its capital  and a DO zone focusing on white wines produced from the local Merseguera grape and other varieties. The other DO zones within the autonomía of Valencia are Alicante and Utiel-Requena. Alicante DO is known Fondillón, a solera-style, oxidative dessert wine produced from overripe Monastrell (Mourvèdre) grapes aged for a minimum of ten years. Utiel-Requena DO red wines are primarily produced from the Bobal grape.",
        },
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (0, 800),
        "soil_types": "clay",
        "primary_grapes": ["Merseguera", "Bobal", "Monastrell"],
        "wine_styles": ["white", "red", "dessert"],
    },
    {
        "country": "SE",
        "name": "Gutevin",
        "climate_types": "cool_climate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 200),
        "soil_types": "clay",
        "primary_grapes": ["Solaris", "Rondo"],
        "wine_styles": ["white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the gentle elevations of Gutevin, the region's clay soils nurture the Solaris and Rondo grapes, resulting in lively white and sparkling wines that dance on the palate. With a refreshing balance and a touch of elegance, these wines are a delightful expression of their lush, rain-kissed landscape.",
        },
    },
    {
        "country": "CH",
        "name": "Aargau",
        "climate_types": "temperate",
        "avg_annual_rainfall": 1000.0,
        "elevation_range": (300, 600),
        "soil_types": "clay",
        "primary_grapes": ["Chardonnay", "Pinot Noir", "Riesling", "Merlot"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Aargau is a Swiss treasure where the lush landscapes and clay-rich soils give rise to a delightful array of wines, from the refreshing whites of Chardonnay and Riesling to the robust reds of Pinot Noir and Merlot. With its picturesque elevation and ample rainfall, this region is a must-visit for those seeking to explore the nuances of Swiss viticulture.",
        },
    },
    {
        "country": "CH",
        "name": "Bern",
        "subregions": [
            {"name": "Shores of Lake Biel"},
            {"name": "Shores of Lake Thun"},
        ],
        "climate_types": "temperate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (400, 800),
        "soil_types": "clay",
        "primary_grapes": ["Pinot Noir", "Chasselas"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Switzerland, Bern boasts a delightful tapestry of vineyards where the robust Pinot Noir and crisp Chasselas thrive, producing wines that range from luscious reds to effervescent sparklers. With its clay soils and picturesque elevation, this region is a treasure trove for those seeking to explore the nuanced flavors of Swiss viticulture.",
        },
    },
    {
        "country": "CH",
        "name": "Freiburg",
        "climate_types": "temperate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Germany, Freiburg is a hidden gem waiting to be uncovered, where the mystery of its soil and grape varieties invites adventurous palates to explore its unique wine offerings. This region promises a delightful journey through its uncharted flavors, perfect for those seeking something extraordinary.",
        },
    },
    {
        "country": "CH",
        "name": "Geneva",
        "synonyms": ["Genève", "Genf", "Zeneva"],
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of Switzerland, Geneva is a charming wine region that boasts a rich tapestry of cultural influences and stunning landscapes. While the specifics of its grape varieties may remain a mystery, the wines produced here are often a delightful reflection of the region's vibrant heritage and dedication to quality.",
            "julie": "",
        },
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
    },
    {
        "country": "CH",
        "name": "Grisons",
        "climate_types": "alpine",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (600, 1200),
        "soil_types": "granite",
        "primary_grapes": ["Pinot Noir", "Chardonnay"],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of the Swiss Alps, Grisons is a hidden gem where granite soils and high elevations create a playground for Pinot Noir and Chardonnay. With its stunning landscapes and diverse wine styles, this region offers a delightful exploration of both red and sparkling wines that are as captivating as the mountains themselves.",
        },
    },
    {
        "country": "CH",
        "name": "Neuchâtel",
        "synonyms": ["Neuenburg", "Three Lakes"],
        "description": {
            "default": "",
            "sommelier": "Neuchâtel is a charming Swiss wine region where the serene lakes meet rolling hills, producing exquisite Chasselas whites and vibrant Pinot Noir reds. With its diverse wine styles, including sparkling options, this area invites you to explore its delightful offerings and savor the essence of Swiss viticulture.",
            "julie": "",
        },
        "climate_types": "temperate",
        "avg_annual_rainfall": None,
        "elevation_range": (0, 500),
        "soil_types": "uknown",
        "primary_grapes": ["Chasselas", "Pinot Noir"],
        "wine_styles": ["white", "red", "sparkling"],
    },
    {
        "country": "CH",
        "name": "St. Gallen",
        "climate_types": "temperate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (400, 800),
        "soil_types": "clay",
        "primary_grapes": ["Pinot Noir", "Chasselas"],
        "wine_styles": ["red", "white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "St. Gallen is a hidden gem in Swiss winemaking, where the elegant Pinot Noir and refreshing Chasselas thrive in clay-rich soils and a temperate climate, resulting in wines that are both expressive and refined. This picturesque region invites wine lovers to explore its delightful offerings, each sip telling the story of its lush landscape.",
        },
    },
    {
        "country": "CH",
        "name": "Schaffhausen",
        "description": {
            "default": "",
            "sommelier": "Nestled in the heart of Switzerland, Schaffhausen is a hidden gem for Pinot Noir lovers, offering rich, full-bodied reds that are elegantly oaked, showcasing the region's commitment to quality and craftsmanship in winemaking.",
            "julie": "",
        },
        "climate_types": "temperate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": ["Pinot Noir"],
        "wine_styles": ["red", "full_bodied", "oaked"],
    },
    {
        "country": "CH",
        "name": "Thurgau",
        "climate_types": "temperate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (400, 600),
        "soil_types": "clay",
        "primary_grapes": ["Riesling", "Chasselas", "Pinot Noir"],
        "wine_styles": ["white", "red", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Thurgau is a hidden gem in Switzerland, where the clay-rich soils and gentle elevations nurture exquisite Riesling and Chasselas, resulting in wines that are both vibrant and nuanced. Whether you're sipping a crisp white or a sophisticated red, the charm of Thurgau's vineyards is sure to captivate your palate.",
        },
    },
    {
        "country": "CH",
        "name": "Ticino",
        "synonyms": ["Tessin"],
        "description": {
            "default": "",
            "sommelier": "Nestled between the majestic Alps and the serene shores of Lake Lugano, Ticino is a hidden gem for wine lovers, where the sun-drenched slopes yield luscious Merlot wines that are both elegant and expressive. With its charming villages and breathtaking scenery, a visit to this region promises not just delightful sips but also a feast for the eyes.",
            "julie": "",
        },
        "climate_types": "maritime",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": ["Merlot"],
        "wine_styles": ["red", "white", "rose"],
    },
    {
        "country": "CH",
        "name": "Valais",
        "synonyms": ["Wallis"],
        "description": {
            "default": "",
            "sommelier": "In the heart of the Swiss Alps, Valais (or Wallis) boasts a stunning elevation that nurtures exquisite Pinot Noir and Gamay grapes, resulting in vibrant red and refreshing white wines. This enchanting region is a hidden gem for wine lovers, offering a delightful taste of alpine elegance in every sip.",
            "julie": "",
        },
        "climate_types": "alpine",
        "avg_annual_rainfall": None,
        "elevation_range": (0, 1100),
        "soil_types": "uknown",
        "primary_grapes": ["Pinot Noir", "Gamay"],
        "wine_styles": ["red", "white"],
    },
    {
        "country": "CH",
        "name": "Vaud",
        "synonyms": ["Waadt", "Vaud wine region", "Vaud wine country"],
        "subregions": [{"name": "La Côte"}, {"name": "Lavaux"}],
        "description": {
            "default": "",
            "sommelier": "Vaud is a charming Swiss wine region celebrated for its exquisite Chasselas wines, which embody the essence of its limestone soils and stunning alpine vistas. Here, traditional winemaking meets breathtaking scenery, offering a delightful experience for both the palate and the eyes.",
            "julie": "",
        },
        "climate_types": "maritime",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (300, 800),
        "soil_types": "limestone",
        "primary_grapes": ["Chasselas"],
        "wine_styles": ["white", "sparkling", "medium_bodied", "traditional"],
    },
    {
        "country": "CH",
        "name": "Zürich",
        "synonyms": ["Zurich"],
        "climate_types": "temperate",
        "avg_annual_rainfall": 900.0,
        "elevation_range": (400, 600),
        "soil_types": "clay",
        "primary_grapes": ["Pinot Noir", "Chardonnay"],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Zürich is a hidden gem in the Swiss wine landscape, where the rich clay soils nurture exquisite Pinot Noir and Chardonnay, resulting in wines that are both refined and expressive. With its picturesque elevation and a delightful mix of red, white, and sparkling styles, this region invites wine lovers to explore its charming offerings.",
        },
    },
    {
        "country": "TR",
        "name": "Marmara",
        "synonyms": ["Thrace", "Thracia"],
        "subregions": [
            {
                "name": "Tekirdağ",
                "subregions": [{"name": "Büyükkarıştıran"}, {"name": "Lüleburgaz"}],
            },
            {
                "name": "Kırklareli",
                "subregions": [
                    {"name": "Şarköy"},
                    {"name": "Mürefte"},
                    {"name": "Yazır"},
                    {"name": "Çerkezköy"},
                ],
            },
            {
                "name": "Balıkesir",
                "subregions": [
                    {"name": "Avşa"},
                    {"name": "Marmara Island"},
                    {"name": "Yiğitler"},
                ],
            },
            {"name": "Istanbul", "subregions": [{"name": "Kemerburgaz"}]},
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 1000),
        "soil_types": "clay",
        "primary_grapes": [
            "Chardonnay",
            "Cabernet Sauvignon",
            "Merlot",
            "Öküzgözü",
            "Boğazkere",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled between the Sea of Marmara and the Aegean, the Thrace region is a hidden gem where traditional Turkish grapes like Öküzgözü and Boğazkere dance alongside global stars like Chardonnay and Cabernet Sauvignon, creating a vibrant tapestry of flavors in every bottle. With its clay-rich soils and a climate that nurtures both red and white varietals, Marmara is a delightful destination for those seeking to explore the rich diversity of Turkish wines.",
        },
    },
    {
        "country": "TR",
        "name": "Aegean wine region",
        "subregions": [
            {
                "name": "Çanakkale",
                "subregions": [
                    {"name": "Bozcaada"},
                    {"name": "Gelibolu"},
                    {"name": "Eceabat"},
                ],
            },
            {"name": "Manisa", "subregions": [{"name": "Akhisar"}, {"name": "Kula"}]},
            {"name": "Denizli", "subregions": [{"name": "Bekilli"}, {"name": "Güney"}]},
            {
                "name": "İzmir",
                "subregions": [
                    {"name": "Torbalı"},
                    {"name": "Urla"},
                    {"name": "Kemalpaşa"},
                    {"name": "Selçuk"},
                ],
            },
            {"name": "Isparta"},
            {"name": "Muğla", "subregions": [{"name": "Bodrum"}]},
            {"name": "Burdur"},
            {"name": "Aydın"},
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 1000),
        "soil_types": "clay",
        "primary_grapes": [
            "Chardonnay",
            "Sauvignon Blanc",
            "Cabernet Sauvignon",
            "Merlot",
            "Öküzgözü",
            "Boğazkere",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the stunning Aegean coast, this wine region is a treasure trove of flavors, producing everything from refreshing whites to bold reds and even sparkling delights. With its clay soils and a climate that dances between the Mediterranean sun and gentle breezes, the Aegean is a playground for grape varieties like Öküzgözü and Boğazkere, promising a sip of adventure in every glass.",
        },
    },
    {
        "country": "TR",
        "name": "Mediterrenean wine region",
        "subregions": [
            {"name": "Antalya", "subregions": [{"name": "Elmalı"}]},
            {"name": "Mersin"},
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 1000),
        "soil_types": "sandy",
        "primary_grapes": ["Chardonnay", "Shiraz", "Cabernet Sauvignon", "Merlot"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the sun-kissed embrace of the Mediterranean, this vibrant wine region boasts sandy soils and a delightful climate, perfect for crafting an array of wines. From the crisp elegance of Chardonnay to the bold richness of Shiraz, each sip tells a story of the land's diverse terroir and winemaking tradition.",
        },
    },
    {
        "country": "TR",
        "name": "Anatolia",
        "subregions": [
            {
                "name": "Mid-southern anatolia",
                "subregions": [
                    {
                        "name": "Nevşehir",
                        "subregions": [
                            {"name": "Ürgüp"},
                            {"name": "Göreme"},
                            {"name": "Gülşehir"},
                        ],
                    },
                    {"name": "Kayseri"},
                ],
            },
            {
                "name": "Mid-northern anatolia",
                "subregions": [
                    {
                        "name": "Ankara",
                        "subregions": [{"name": "Akyurt"}, {"name": "Kalecik"}],
                    },
                    {"name": "Eskişehir"},
                    {"name": "Yozgat"},
                    {"name": "Sivas"},
                    {"name": "Çankırı"},
                ],
            },
            {
                "name": "Mid-eastern anatolia",
                "subregions": [{"name": "Tokat"}, {"name": "Elazığ"}],
            },
            {
                "name": "Southeast anatolia",
                "subregions": [{"name": "Şanlıurfa"}, {"name": "Diyarbakır"}],
            },
        ],
        "climate_types": "continental",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Anatolia, the heart of Turkey, offers a fascinating tapestry of wine culture, where ancient traditions meet modern winemaking. With its varied climate and topography, this region produces wines that are as diverse as its history, inviting enthusiasts to explore its hidden gems.",
        },
    },
    {
        "country": "UA",
        "name": "Autonomous Republic of Crimea",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (0, 1500),
        "soil_types": "clay",
        "primary_grapes": [
            "Chardonnay",
            "Merlot",
            "Cabernet Sauvignon",
            "Aligote",
            "Saperavi",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled between the Black Sea and the mountains, Crimea's vineyards thrive in a unique blend of Mediterranean and continental climates, yielding exquisite wines that reflect the region's rich history and diverse terroir. Whether you're sipping a crisp Chardonnay or a bold Cabernet Sauvignon, each glass tells a story of this enchanting land.",
        },
    },
    {
        "country": "UA",
        "name": "Kherson Oblast",
        "climate_types": "continental",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (0, 200),
        "soil_types": "alluvial",
        "primary_grapes": [
            "Chardonnay",
            "Cabernet Sauvignon",
            "Merlot",
            "Sauvignon Blanc",
        ],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Ukraine, Kherson Oblast boasts a rich tapestry of vineyards where Chardonnay and Cabernet Sauvignon flourish under the sun-drenched skies. With its alluvial soils and a climate that nurtures both red and white varietals, this region is a delightful surprise for those seeking unique and flavorful wines.",
        },
    },
    {
        "country": "UA",
        "name": "Mykolaiv Oblast",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (0, 200),
        "soil_types": "clay",
        "primary_grapes": ["Chardonnay", "Cabernet Sauvignon", "Merlot"],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Ukraine, Mykolaiv Oblast boasts a unique terroir where clay soils nurture exquisite Chardonnay, Cabernet Sauvignon, and Merlot. This region crafts a delightful array of wines, from vibrant whites to bold reds and even sparkling varieties, perfect for any palate.",
        },
    },
    {
        "country": "UA",
        "name": "Odesa Oblast",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (0, 200),
        "soil_types": "sandy_loam",
        "primary_grapes": ["Chardonnay", "Cabernet Sauvignon", "Merlot", "Saperavi"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the picturesque Black Sea, Odesa Oblast is a hidden gem for wine lovers, where the sun-kissed vineyards yield a delightful array of wines, from crisp Chardonnays to rich Merlots. This vibrant region not only boasts a rich tapestry of flavors but also invites you to explore its sparkling creations, making every sip a celebration of its unique terroir.",
        },
    },
    {
        "country": "UA",
        "name": "Zakarpattia Oblast",
        "climate_types": "temperate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 800),
        "soil_types": "clay",
        "primary_grapes": ["Saperavi", "Riesling", "Cabernet Sauvignon", "Chardonnay"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the picturesque landscapes of western Ukraine, Zakarpattia Oblast is a treasure trove for wine lovers, showcasing a delightful array of Saperavi, Riesling, and Cabernet Sauvignon. With its clay soils and a climate that dances between the cool and the warm, this region crafts everything from luscious reds to effervescent sparkling wines, inviting you to explore its vinous wonders.",
        },
    },
    {
        "country": "UA",
        "name": "Zaporizhzhia Oblast",
        "climate_types": "continental",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (100, 300),
        "soil_types": "alluvial",
        "primary_grapes": ["Saperavi", "Cabernet Sauvignon", "Merlot"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Ukraine, Zaporizhzhia Oblast boasts a rich tapestry of vineyards where the bold Saperavi and classic Cabernet Sauvignon thrive, producing wines that are as vibrant as the region's history. With its unique alluvial soils and a climate that nurtures both red and white varietals, this area is a hidden gem for wine enthusiasts seeking to explore the depths of Ukrainian viticulture.",
        },
    },
    {
        "country": "AM",
        "name": "Ararat Valley",
        "climate_types": "continental",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (800, 1500),
        "soil_types": "alluvial",
        "primary_grapes": [
            "Armenian indigenous grapes",
            "Cabernet Sauvignon",
            "Merlot",
            "Chardonnay",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled between the majestic Ararat Mountains, the Ararat Valley is a treasure trove of viticulture, where ancient Armenian grapes flourish alongside global varietals, producing an eclectic mix of wines that range from bold reds to elegant sparkling options. With its rich alluvial soils and a climate that dances between elevation and rainfall, this region is a must-visit for any wine enthusiast seeking to explore the depths of Armenian winemaking heritage.",
        },
    },
    {
        "country": "AM",
        "name": "Ijevan",
        "climate_types": "continental",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Armenia, the Ijevan region beckons adventurous palates with its mysterious terroir and untapped potential, promising a delightful journey into the world of wine where every bottle tells a story waiting to be uncovered.",
        },
    },
    {
        "country": "AZ",
        "name": "Aghdam",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Aghdam, a hidden gem in the wine world, invites adventurous palates to uncover its mysteries, despite the enigma of its soil and grape varieties. As this region develops, it holds the promise of unique wines waiting to be discovered by those willing to explore its uncharted territory.",
        },
    },
    {
        "country": "AZ",
        "name": "Baku",
        "climate_types": "semi_desert",
        "avg_annual_rainfall": 300.0,
        "elevation_range": (0, 500),
        "soil_types": "sandy",
        "primary_grapes": ["Saperavi", "Shiraz", "Cabernet Sauvignon", "Merlot"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the Caspian Sea, Baku is a vibrant wine region where the sun-drenched sandy soils yield bold reds like Saperavi and Shiraz, alongside refreshing whites and rosés, making it a delightful destination for wine enthusiasts seeking both tradition and innovation.",
        },
    },
    {
        "country": "AZ",
        "name": "Ganja",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (200, 800),
        "soil_types": "alluvial",
        "primary_grapes": ["Saperavi", "Shiraz", "Cabernet Sauvignon", "Merlot"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Azerbaijan, the Ganja region boasts a unique blend of alluvial soils and a temperate climate, perfect for crafting bold reds like Saperavi and Shiraz, alongside delightful whites and rosés. With its stunning elevation changes and a rich winemaking heritage, Ganja is a hidden gem waiting to be explored by wine enthusiasts.",
        },
    },
    {
        "country": "AZ",
        "name": "Tovuz",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "alluvial",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Azerbaijan, Tovuz boasts rich alluvial soils that nurture vibrant grape varieties, resulting in wines that are both expressive and full of character. This region is a hidden gem for those seeking to explore the diverse flavors of Azerbaijani viticulture.",
        },
    },
    {
        "country": "MM",
        "name": "Shan State",
        "climate_types": "tropical",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the picturesque hills of Myanmar, Shan State is an emerging wine region that invites adventurous palates to discover its untapped potential. With its mysterious soils and nascent grape varieties, this area promises a delightful journey into the unknown, where each sip could unveil a new facet of its unique character.",
        },
    },
    {
        "country": "CN",
        "name": "Chang'an",
        "climate_types": "continental",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (200, 800),
        "soil_types": "clay",
        "primary_grapes": ["Cabernet Sauvignon", "Merlot"],
        "wine_styles": ["red", "white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of China, Chang'an is a burgeoning wine region where the rich clay soils nurture bold Cabernet Sauvignon and Merlot grapes, resulting in wines that are both expressive and refined. With its unique climate and elevation, this area is poised to become a notable player on the global wine stage.",
        },
    },
    {
        "country": "CN",
        "name": "Gaochang",
        "climate_types": "desert",
        "avg_annual_rainfall": 100.0,
        "elevation_range": None,
        "soil_types": "sandy",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in a sun-drenched landscape, Gaochang is a hidden gem where sandy soils and minimal rainfall create the perfect conditions for crafting bold, characterful wines that reflect the rugged beauty of their environment. This region invites adventurous palates to explore its distinctive offerings, promising a taste of the extraordinary.",
        },
    },
    {
        "country": "CN",
        "name": "Luoyang",
        "climate_types": "continental",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (100, 500),
        "soil_types": "clay",
        "primary_grapes": [
            "Cabernet Sauvignon",
            "Merlot",
            "Chardonnay",
            "local varieties",
        ],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of China, Luoyang is a burgeoning wine region where the ancient art of viticulture meets modern winemaking techniques. With its clay soils nurturing a blend of international favorites like Cabernet Sauvignon and Chardonnay alongside unique local varieties, Luoyang is crafting a delightful spectrum of wines that are as rich in flavor as they are in history.",
        },
    },
    {
        "country": "CN",
        "name": "Qiuci",
        "climate_types": "semi_desert",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of an undiscovered wine frontier, Qiuci beckons adventurous palates with its enigmatic charm and untapped potential. While the soil remains a mystery, the region promises a journey of exploration for those eager to uncover its hidden grape varieties and unique wine styles.",
        },
    },
    {
        "country": "CN",
        "name": "Yantai",
        "climate_types": "temperate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 500),
        "soil_types": "sandy",
        "primary_grapes": ["Cabernet Sauvignon", "Chardonnay", "Merlot", "Syrah"],
        "wine_styles": ["red", "white", "sparkling", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the coast, Yantai is a vibrant wine region where sandy soils and a temperate climate converge to produce exquisite wines, from bold Cabernet Sauvignon to crisp Chardonnay. This dynamic area is a treasure trove for wine lovers, offering a delightful array of styles including red, white, sparkling, and rosé.",
        },
    },
    {
        "country": "IN",
        "name": "Nashik",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (500, 600),
        "soil_types": "alluvial",
        "primary_grapes": [
            "Chenin Blanc",
            "Sauvignon Blanc",
            "Shiraz",
            "Cabernet Sauvignon",
            "Zinfandel",
        ],
        "wine_styles": ["red", "white", "sparkling", "medium_bodied", "full_bodied"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the Western Ghats, Nashik is a vibrant wine region where the sun-kissed vineyards yield exquisite Chenin Blanc and Shiraz, among others. With its rich alluvial soils and a climate that dances between warmth and cool breezes, Nashik is crafting a new narrative in the world of wine, inviting connoisseurs to explore its delightful offerings.",
        },
    },
    {
        "country": "IN",
        "name": "Bangalore",
        "climate_types": "tropical",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (800, 1000),
        "soil_types": "clay",
        "primary_grapes": ["Chenin Blanc", "Shiraz", "Cabernet Sauvignon", "Zinfandel"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of India, Bangalore's wine scene is a delightful blend of tradition and innovation, where the lush landscapes yield vibrant Chenin Blancs and bold Shiraz. With its clay soils and ideal elevation, this region is quickly becoming a hidden gem for wine enthusiasts seeking unique and flavorful expressions.",
        },
    },
    {
        "country": "IN",
        "name": "Vijayapura",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": None,
        "soil_types": "clay",
        "primary_grapes": ["Chenin Blanc", "Shiraz", "Cabernet Sauvignon"],
        "wine_styles": ["red", "white", "sparkling", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of India, Vijayapura is a burgeoning wine region where the robust Shiraz and elegant Chenin Blanc thrive in clay soils, producing a delightful array of wines from crisp whites to luscious desserts. With a climate that nurtures creativity, this region invites wine lovers to explore its diverse offerings, each bottle telling a story of its unique terroir.",
        },
    },
    {
        "country": "IN",
        "name": "Narayangaon",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (300, 600),
        "soil_types": "clay",
        "primary_grapes": ["Chenin Blanc", "Shiraz", "Cabernet Sauvignon"],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of India, Narayangaon is a hidden gem where the lush clay soils and moderate elevations nurture a delightful medley of Chenin Blanc, Shiraz, and Cabernet Sauvignon. This vibrant region produces an exciting array of wines, from crisp whites to bold reds, making it a must-visit for any wine enthusiast seeking to explore India's burgeoning wine scene.",
        },
    },
    {
        "country": "IN",
        "name": "Pune",
        "climate_types": "tropical",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (500, 800),
        "soil_types": "clay",
        "primary_grapes": [
            "Chenin Blanc",
            "Sauvignon Blanc",
            "Shiraz",
            "Cabernet Sauvignon",
        ],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the scenic hills of Pune, this emerging wine region boasts a delightful blend of Chenin Blanc and Shiraz, thriving in its clay soils and moderate rainfall. With a burgeoning reputation for crafting vibrant whites and bold reds, Pune is a hidden gem for wine enthusiasts seeking to explore India's vinous potential.",
        },
    },
    {
        "country": "IN",
        "name": "Sangli",
        "climate_types": "tropical",
        "avg_annual_rainfall": 800.0,
        "elevation_range": None,
        "soil_types": "alluvial",
        "primary_grapes": [
            "Chenin Blanc",
            "Sauvignon Blanc",
            "Cabernet Sauvignon",
            "Shiraz",
        ],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Maharashtra, Sangli is a vibrant wine region where the lush alluvial soils nurture a delightful array of grape varieties. From the crisp elegance of Chenin Blanc to the bold character of Shiraz, this region offers a tantalizing journey through its diverse wine styles, making it a hidden gem for wine enthusiasts.",
        },
    },
    {
        "country": "IR",
        "name": "Malayer",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 300.0,
        "elevation_range": None,
        "soil_types": "clay",
        "primary_grapes": ["Cabernet Sauvignon", "Merlot", "Shiraz"],
        "wine_styles": ["red", "white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Iran, Malayer is a hidden gem where the clay soils nurture luscious Cabernet Sauvignon, Merlot, and Shiraz grapes, resulting in rich, full-bodied wines that tantalize the palate. With a climate that balances warmth and moisture, this region produces captivating reds and whites that are sure to impress any wine lover.",
        },
    },
    {
        "country": "IR",
        "name": "Takestan",
        "climate_types": "continental",
        "avg_annual_rainfall": 300.0,
        "elevation_range": (800, 1200),
        "soil_types": "clay",
        "primary_grapes": ["Fakhri", "Keshmeshi", "Sefid", "Zard", "Shiraz"],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Iran, Takestan is a hidden gem where the ancient art of winemaking thrives amidst clay soils and a picturesque elevation. Here, the unique Fakhri and Keshmeshi grapes flourish, producing a delightful array of wines that range from robust reds to refreshing whites and even sparkling delights, making it a must-visit for adventurous wine lovers.",
        },
    },
    {
        "country": "IR",
        "name": "Urmia",
        "climate_types": "continental",
        "avg_annual_rainfall": 400.0,
        "elevation_range": (1200, 1800),
        "soil_types": "clay",
        "primary_grapes": ["Furmint", "Sauvignon Blanc", "Cabernet Sauvignon"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Urmia is a captivating wine region where the high-altitude vineyards thrive in clay soils, producing an intriguing mix of Furmint, Sauvignon Blanc, and Cabernet Sauvignon. With its diverse wine styles ranging from refreshing whites to robust reds, Urmia invites adventurous palates to explore its unique offerings.",
        },
    },
    {
        "country": "IR",
        "name": "Qazvin",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 300.0,
        "elevation_range": (1000, 2000),
        "soil_types": "clay",
        "primary_grapes": ["Fakhri", "Keshmeshi", "Sefid", "Shiraz"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Qazvin is a hidden gem in Iran's wine landscape, where the high-altitude vineyards thrive in clay soils, producing exquisite wines that reflect the region's rich heritage. With a blend of indigenous and classic grape varieties, this area offers a delightful exploration of flavors, from the boldness of Shiraz to the elegance of local whites.",
        },
    },
    {
        "country": "IR",
        "name": "Quchan",
        "climate_types": "continental",
        "avg_annual_rainfall": 300.0,
        "elevation_range": (1000, 2000),
        "soil_types": "clay",
        "primary_grapes": ["Fakhri", "Keshmeshi", "Sefid", "Zard", "Shirin"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Quchan is a hidden gem in the wine world, where the high elevation and clay-rich soils create a playground for unique grape varieties. With its intriguing blend of red, white, and rosé wines, this region invites adventurous palates to explore its rich flavors and vibrant character.",
        },
    },
    {
        "country": "IL",
        "name": "Galilee",
        "subregions": [{"name": "Upper Galilee"}],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (400, 1200),
        "soil_types": "clay",
        "primary_grapes": ["Cabernet Sauvignon", "Merlot", "Sauvignon Blanc"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the northern part of Israel, Galilee is a wine lover's paradise where the majestic hills and clay soils nurture exceptional Cabernet Sauvignon and Merlot, alongside vibrant Sauvignon Blanc. With its unique climate and elevation, this region crafts a delightful array of wines that tantalize the palate, from rich reds to zesty whites and charming rosés.",
        },
    },
    {
        "country": "IL",
        "name": "Golan Heights",
        "climate_types": "cool_climate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (400, 1200),
        "soil_types": "volcanic",
        "primary_grapes": [
            "Cabernet Sauvignon",
            "Merlot",
            "Chardonnay",
            "Syrah",
            "Sauvignon Blanc",
        ],
        "wine_styles": ["red", "white", "sparkling", "medium_bodied", "full_bodied"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled between the mountains and valleys, the Golan Heights is a winemaker's paradise where volcanic soils and high elevations yield exceptional Cabernet Sauvignon and Syrah, alongside elegant Chardonnay and Sauvignon Blanc. This region's wines are a delightful exploration of bold flavors and refreshing acidity, perfect for any palate.",
        },
    },
    {
        "country": "IL",
        "name": "Judean Hills",
        "subregions": [{"name": "Jerusalem"}, {"name": "Bet Shemesh"}],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (400, 900),
        "soil_types": "limestone",
        "primary_grapes": ["Cabernet Sauvignon", "Merlot", "Syrah"],
        "wine_styles": ["red", "white", "blend", "oaked"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Israel, the Judean Hills is a wine lover's paradise where limestone soils and varying elevations create a canvas for exquisite wines, particularly bold reds and elegant blends. With a climate that nurtures the likes of Cabernet Sauvignon and Syrah, this region offers a delightful exploration of flavors that reflect its rich terroir.",
        },
    },
    {
        "country": "IL",
        "name": "Mount Carmel",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 500),
        "soil_types": "clay",
        "primary_grapes": [
            "Cabernet Sauvignon",
            "Merlot",
            "Chardonnay",
            "Sauvignon Blanc",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Israel, Mount Carmel is a vinous treasure trove where the rich clay soils nurture a delightful medley of grapes, from bold Cabernet Sauvignon to refreshing Sauvignon Blanc. This region's unique climate and elevation create a playground for winemakers, resulting in an impressive spectrum of wines, including reds, whites, rosés, and even sparkling delights.",
        },
    },
    {
        "country": "IL",
        "name": "Rishon LeZion",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (0, 100),
        "soil_types": "sandy_loam",
        "primary_grapes": [
            "Cabernet Sauvignon",
            "Merlot",
            "Chardonnay",
            "Sauvignon Blanc",
        ],
        "wine_styles": ["red", "white", "sparkling", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled near the Mediterranean coast, Rishon LeZion is a sun-kissed paradise for wine lovers, where the rich flavors of Cabernet Sauvignon and the crisp elegance of Chardonnay come to life. This dynamic region not only crafts exquisite reds and whites but also delights with sparkling and rosé offerings, making it a true gem in the world of wine.",
        },
    },
    {
        "country": "JP",
        "name": "Yamanashi",
        "climate_types": "temperate",
        "avg_annual_rainfall": 1200.0,
        "elevation_range": (300, 1200),
        "soil_types": "volcanic",
        "primary_grapes": ["Koshu", "Merlot", "Cabernet Sauvignon", "Chardonnay"],
        "wine_styles": ["white", "red", "sparkling", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Japan, Yamanashi is a treasure trove of viticulture, where volcanic soils and varying elevations create a perfect canvas for crafting exquisite wines. From the refreshing Koshu whites to the bold reds, this region offers a delightful exploration of flavors that reflect its rich terroir.",
        },
    },
    {
        "country": "JP",
        "name": "Hokkaido",
        "climate_types": "cool_climate",
        "avg_annual_rainfall": 1000.0,
        "elevation_range": (0, 1000),
        "soil_types": "sandy_loam",
        "primary_grapes": ["Chardonnay", "Pinot Noir", "Riesling"],
        "wine_styles": ["white", "sparkling", "red"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the northern reaches of Japan, Hokkaido is a hidden gem for wine lovers, where the cool climate and sandy loam create a perfect playground for Chardonnay, Pinot Noir, and Riesling. This region produces a delightful array of wines, from refreshing whites to sophisticated reds, all with a distinct character that reflects its unique landscape.",
        },
    },
    {
        "country": "JP",
        "name": "Nagano",
        "climate_types": "cool_climate",
        "avg_annual_rainfall": 1200.0,
        "elevation_range": (300, 1200),
        "soil_types": "volcanic",
        "primary_grapes": ["Chardonnay", "Merlot"],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nagano is a hidden gem in Japan's wine landscape, where volcanic soils and a temperate climate give rise to exquisite Chardonnay and Merlot. With its stunning elevation changes and a penchant for both red and sparkling wines, this region offers a delightful exploration of flavors that reflect its unique terroir.",
        },
    },
    {
        "country": "KR",
        "name": "Anseong",
        "climate_types": "temperate",
        "avg_annual_rainfall": 1000.0,
        "elevation_range": None,
        "soil_types": "clay",
        "primary_grapes": ["Cabernet Sauvignon", "Merlot"],
        "wine_styles": ["red", "white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of South Korea, Anseong is a burgeoning wine region where the rich clay soils nurture bold Cabernet Sauvignon and Merlot grapes, resulting in wines that are both expressive and refined. With a unique blend of red and white styles, Anseong invites adventurous palates to explore its delightful offerings.",
        },
    },
    {
        "country": "KR",
        "name": "Gimcheon",
        "climate_types": "temperate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Korea, Gimcheon is a hidden gem waiting to unveil its vinous secrets, promising a delightful journey for adventurous wine lovers eager to taste the unknown.",
        },
    },
    {
        "country": "KR",
        "name": "Gyeongsan",
        "climate_types": "temperate",
        "avg_annual_rainfall": 1200.0,
        "elevation_range": (100, 300),
        "soil_types": "clay",
        "primary_grapes": ["Chardonnay", "Cabernet Sauvignon", "Merlot"],
        "wine_styles": ["red", "white", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of South Korea, Gyeongsan is a burgeoning wine region where the clay soils nurture exquisite Chardonnay and bold Cabernet Sauvignon, resulting in a delightful array of red, white, and rosé wines. With an average annual rainfall of 1200 mm, this region's lush vineyards promise a refreshing exploration of flavors that are as diverse as its landscape.",
        },
    },
    {
        "country": "KR",
        "name": "Yeongcheon",
        "climate_types": "temperate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of South Korea, Yeongcheon is a hidden gem waiting to be discovered, where the mystery of its soil and the promise of diverse grape varieties hint at a future filled with exciting wine possibilities.",
        },
    },
    {
        "country": "KR",
        "name": "Yeongdong",
        "climate_types": "temperate",
        "avg_annual_rainfall": 1200.0,
        "elevation_range": (100, 300),
        "soil_types": "clay",
        "primary_grapes": ["Chardonnay", "Cabernet Sauvignon", "Moscato"],
        "wine_styles": ["white", "red", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of South Korea, Yeongdong is a burgeoning wine region where the lush clay soils and moderate elevation create a perfect canvas for crafting exquisite wines. From the crisp elegance of Chardonnay to the fruity allure of Moscato, this region promises a delightful exploration of flavors for every palate.",
        },
    },
    {
        "country": "LB",
        "name": "Bekaa Valley",
        "subregions": [
            {"name": "Anjar"},
            {"name": "Chtoura"},
            {"name": "Rashaya"},
            {"name": "Zahlé"},
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (800, 1200),
        "soil_types": "clay",
        "primary_grapes": [
            "Cabernet Sauvignon",
            "Merlot",
            "Syrah",
            "Chardonnay",
            "Grenache",
        ],
        "wine_styles": ["red", "white", "sparkling", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled between the majestic mountains of Lebanon, the Bekaa Valley is a vinous treasure trove where the sun-drenched slopes yield exquisite wines, from bold reds like Cabernet Sauvignon to crisp Chardonnays. With its unique terroir and a climate that dances between Mediterranean warmth and alpine coolness, this region is a must-visit for any wine enthusiast seeking to explore the rich tapestry of Lebanese viticulture.",
        },
    },
    {
        "country": "LB",
        "name": "Mount Lebanon",
        "subregions": [
            {"name": "Aley"},
            {"name": "Baabda"},
            {"name": "Beit Mery"},
            {"name": "Bhamdoun"},
            {"name": "Brummana"},
            {"name": "Byblos"},
            {"name": "Chouf"},
            {"name": "Keserwan District"},
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (300, 2000),
        "soil_types": "limestone",
        "primary_grapes": [
            "Cabernet Sauvignon",
            "Merlot",
            "Syrah",
            "Chardonnay",
            "Obeidi",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Lebanon, Mount Lebanon boasts a stunning elevation range and limestone soils that give rise to a delightful array of wines, from the rich reds of Cabernet Sauvignon and Syrah to the crisp whites of Chardonnay and Obeidi. This region is a treasure trove for wine lovers, offering everything from sparkling to fortified styles, all crafted under the Mediterranean sun.",
        },
    },
    {
        "country": "LB",
        "name": "North Governorate",
        "subregions": [
            {"name": "Ehden"},
            {"name": "Koura"},
            {"name": "Qadisha Valley"},
            {"name": "Tripoli"},
            {"name": "Zgharta"},
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (300, 2000),
        "soil_types": "limestone",
        "primary_grapes": ["Obeidi", "Merlot", "Cabernet Sauvignon", "Syrah"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Lebanon, the North Governorate boasts a stunning elevation range that nurtures a vibrant tapestry of grape varieties, including the unique Obeidi and classic Merlot. With its limestone soils and a climate that dances between rain and sun, this region crafts wines that are as diverse as they are delightful, from elegant reds to effervescent sparkling wines.",
        },
    },
    {
        "country": "LB",
        "name": "South Governorate",
        "subregions": [{"name": "Jezzine"}, {"name": "Marjayoun"}, {"name": "Rmaich"}],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (300, 1200),
        "soil_types": "limestone",
        "primary_grapes": ["Obeidi", "Merlot", "Cabernet Sauvignon", "Syrah"],
        "wine_styles": ["red", "white", "rose", "sparkling", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled between rolling hills and sun-kissed valleys, the South Governorate is a hidden gem where limestone soils nurture a vibrant mix of Obeidi, Merlot, and Syrah, resulting in wines that range from bold reds to elegant sparkling varieties. With an average rainfall of 800 mm and elevations soaring up to 1200 m, this region is a playground for wine lovers seeking both tradition and innovation.",
        },
    },
    {
        "country": "PS",
        "name": "Beit Jala",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (600, 800),
        "soil_types": "limestone",
        "primary_grapes": ["Cabernet Sauvignon", "Merlot", "Syrah", "local varieties"],
        "wine_styles": ["red", "white", "rose", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Beit Jala is a hidden gem in the hills, where limestone soils and a temperate climate nurture a vibrant tapestry of wines, from luscious reds to crisp whites. With its unique blend of international varieties and local grapes, this region invites wine lovers to explore its diverse and delightful offerings.",
        },
    },
    {
        "country": "PS",
        "name": "Hebron",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (600, 900),
        "soil_types": "limestone",
        "primary_grapes": ["Cabernet Sauvignon", "Merlot", "Syrah"],
        "wine_styles": ["red", "white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of the hills, Hebron is a hidden gem where limestone soils and a moderate climate converge to produce exquisite wines. With a focus on bold reds like Cabernet Sauvignon and Syrah, this region offers a delightful exploration of flavors that reflect its unique terroir.",
        },
    },
    {
        "country": "SY",
        "name": "Bloudan",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of the unknown, Bloudan beckons the curious palate with its mysterious terroir and untapped grape varieties, promising a delightful journey into the world of wine where every bottle tells a story waiting to be uncovered.",
        },
    },
    {
        "country": "SY",
        "name": "Homs District",
        "climate_types": "semi_desert",
        "avg_annual_rainfall": 300.0,
        "elevation_range": (200, 800),
        "soil_types": "clay",
        "primary_grapes": ["Damask", "Merlot", "Syrah"],
        "wine_styles": ["red", "white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Syria, the Homs District boasts a rich tapestry of clay soils and a climate that nurtures both indigenous and international grape varieties, resulting in vibrant red and white wines that reflect the region's unique terroir. With elevations ranging from 200 to 800 meters, this area is a hidden gem for wine enthusiasts seeking to explore the flavors of the Middle East.",
        },
    },
    {
        "country": "SY",
        "name": "Jabal el Druze",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": None,
        "elevation_range": (1000, 2000),
        "soil_types": "volcanic",
        "primary_grapes": ["Syrah", "Grenache"],
        "wine_styles": ["red", "white", "traditional", "modern"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled between 1000 to 2000 meters in elevation, Jabal el Druze boasts volcanic soils that give rise to robust Syrah and Grenache wines, showcasing a delightful blend of tradition and modernity in every sip. This enchanting region invites you to explore its dynamic character, where each bottle tells a story of its dramatic landscape.",
        },
    },
    {
        "country": "SY",
        "name": "Latakia",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 500),
        "soil_types": "sandy_loam",
        "primary_grapes": ["Syrah", "Cabernet Sauvignon", "Merlot", "Chardonnay"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the coastal embrace of Syria, Latakia is a vibrant wine region where the sun-kissed slopes yield luscious Syrah and Cabernet Sauvignon, alongside the crisp elegance of Chardonnay. With its sandy loam soils and a delightful mix of red, white, and sparkling wines, Latakia invites you to explore its rich tapestry of flavors and styles.",
        },
    },
    {
        "country": "SY",
        "name": "Sednaya",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of Syria, Sednaya is a hidden gem waiting to be discovered, where the ancient traditions of winemaking blend seamlessly with the region's rich cultural heritage. Although the specifics of its soil and grape varieties remain a mystery, the enchanting landscapes promise a unique tasting experience that reflects the spirit of this historic locale.",
        },
    },
    {
        "country": "SY",
        "name": "Syrian Golan",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (400, 1200),
        "soil_types": "volcanic",
        "primary_grapes": [
            "Syrah",
            "Cabernet Sauvignon",
            "Merlot",
            "Chardonnay",
            "Sauvignon Blanc",
        ],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heights of the Syrian Golan, this region boasts a volcanic landscape that nurtures bold Syrah and elegant Chardonnay, among other varietals. With its dramatic elevation and diverse climate, the wines here are as dynamic as the terrain, offering a delightful exploration of flavors from rich reds to crisp whites and even sparkling delights.",
        },
    },
    {
        "country": "SY",
        "name": "Tartous",
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 500),
        "soil_types": "clay",
        "primary_grapes": ["Syrah", "Cabernet Sauvignon", "Merlot", "Chardonnay"],
        "wine_styles": ["red", "white", "oaked", "unoaked"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled along the Syrian coast, Tartous is a hidden gem where the Mediterranean climate meets rich clay soils, producing exquisite wines that range from bold reds to crisp whites. With a focus on varietals like Syrah and Chardonnay, this region invites wine lovers to explore its unique terroir and delightful expressions.",
        },
    },
    {
        "country": "VN",
        "name": "Da Lat",
        "climate_types": "cool_climate",
        "avg_annual_rainfall": 1500.0,
        "elevation_range": (1500, 2000),
        "soil_types": "volcanic",
        "primary_grapes": ["Cabernet Sauvignon", "Merlot", "Chardonnay"],
        "wine_styles": ["red", "white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the cool heights of Vietnam, Da Lat is a hidden gem where volcanic soils and a temperate climate give rise to exquisite wines, from bold reds to crisp whites. With its lush landscapes and high-altitude vineyards, this region is a delightful surprise for wine enthusiasts seeking something truly unique.",
        },
    },
    {
        "country": "AU",
        "name": "New South Wales",
        "synonyms": ["NSW"],
        "subregions": [
            {"name": "Big Rivers"},
            {"name": "Canberra District"},
            {"name": "Central Ranges"},
            {"name": "Cowra"},
            {"name": "Griffith"},
            {"name": "Gundagai"},
            {"name": "Hastings River"},
            {"name": "Hawkesbury River"},
            {"name": "Hilltops"},
            {"name": "Hunter Valley"},
            {"name": "Mudgee"},
            {"name": "Murray Darling"},
            {"name": "New England Australia"},
            {"name": "Northern Rivers"},
            {"name": "Northern Slopes"},
            {"name": "Orange"},
            {"name": "Perricoota"},
            {"name": "Riverina"},
            {"name": "Shoalhaven Coast"},
            {"name": "South Coast"},
            {"name": "Southern Highlands"},
            {"name": "Southern New South Wales"},
            {"name": "Swan Hill"},
            {"name": "Tumbarumba"},
            {"name": "Western Plains"},
        ],
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 1200),
        "soil_types": "clay",
        "primary_grapes": [
            "Shiraz",
            "Chardonnay",
            "Cabernet Sauvignon",
            "Semillon",
            "Merlot",
        ],
        "wine_styles": ["red", "white", "sparkling", "dessert", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "New South Wales is a vibrant wine region where the sun-kissed hills and clay-rich soils give birth to a delightful spectrum of wines, from bold reds to crisp whites and even luscious dessert styles. With its unique blend of climates and elevations, this region is a treasure trove for wine lovers seeking both variety and quality.",
        },
    },
    {
        "country": "AU",
        "name": "Northern Territory",
        "climate_types": "tropical",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [],
        "wine_styles": [],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "The Northern Territory, with its sun-drenched landscapes and vibrant ecosystems, offers a canvas for adventurous winemakers to explore uncharted grape varieties and styles, promising a delightful surprise for those willing to venture off the beaten path.",
        },
    },
    {
        "country": "AU",
        "name": "Queensland",
        "subregions": [
            {"name": "Granite Belt"},
            {"name": "Scenic Rim"},
            {"name": "South Burnett"},
        ],
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (200, 1200),
        "soil_types": "granite",
        "primary_grapes": ["Shiraz", "Chardonnay", "Verdelho"],
        "wine_styles": ["red", "white", "sparkling", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Queensland is a hidden gem in the Australian wine landscape, where granite soils and a warm climate give rise to luscious Shiraz and vibrant Chardonnay. With a diverse array of wine styles, including sparkling and dessert wines, this region invites adventurous palates to explore its rich offerings.",
        },
    },
    {
        "country": "AU",
        "name": "South Australia",
        "synonyms": ["Southern Australia"],
        "subregions": [
            {"name": "Adelaide Hills"},
            {"name": "Adelaide Plains"},
            {
                "name": "Barossa",
                "subregions": [{"name": "Barossa Valley"}, {"name": "Eden Valley"}],
            },
            {
                "name": "Clare Valley",
                "subregions": [{"name": "Polish Hill River"}, {"name": "Watervale"}],
            },
            {"name": "Coonawarra"},
            {"name": "Currency Creek"},
            {"name": "Far North"},
            {"name": "Fleurieu"},
            {"name": "Kangaroo Island"},
            {"name": "Langhorne Creek"},
            {"name": "Lenswood"},
            {"name": "Limestone Coast"},
            {"name": "Lower Murray"},
            {"name": "McLaren Vale"},
            {"name": "Mount Benson"},
            {"name": "Mount Gambier"},
            {"name": "Mount Lofty Ranges"},
            {"name": "Padthaway"},
            {"name": "Piccadilly Valley"},
            {"name": "Riverland"},
            {"name": "Robe"},
            {"name": "Southern Flinders Ranges"},
            {"name": "The Peninsulas"},
            {"name": "Wrattonbully"},
        ],
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 500.0,
        "elevation_range": (0, 1000),
        "soil_types": "clay",
        "primary_grapes": [
            "Shiraz",
            "Cabernet Sauvignon",
            "Chardonnay",
            "Grenache",
            "Merlot",
        ],
        "wine_styles": ["red", "white", "sparkling", "dessert", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "South Australia is a vibrant wine region celebrated for its exceptional Shiraz and Chardonnay, thriving in clay soils and a climate that nurtures both red and white varietals. From robust reds to sparkling delights, this region offers a delightful journey through its diverse wine styles.",
        },
    },
    {
        "country": "AU",
        "name": "South Eastern Australia",
        "synonyms": ["South East Australia"],
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 600),
        "soil_types": "sandy_loam",
        "primary_grapes": [
            "Shiraz",
            "Cabernet Sauvignon",
            "Chardonnay",
            "Merlot",
            "Sauvignon Blanc",
        ],
        "wine_styles": ["red", "white", "sparkling", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "South Eastern Australia is a treasure trove of vinous delights, where the sun-kissed vineyards yield everything from bold Shiraz to crisp Sauvignon Blanc. With its sandy loam soils and a climate that dances between warmth and cool breezes, this region crafts wines that are as diverse as the landscapes themselves, inviting enthusiasts to explore its rich tapestry of flavors.",
        },
    },
    {
        "country": "AU",
        "name": "Tasmania",
        "subregions": [
            {"name": "Coal River Valley"},
            {"name": "Derwent Valley"},
            {"name": "Huon Valley"},
            {"name": "Pipers River"},
            {"name": "Tamar Valley"},
        ],
        "climate_types": "cool_climate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 600),
        "soil_types": "clay",
        "primary_grapes": ["Pinot Noir", "Chardonnay", "Riesling"],
        "wine_styles": ["red", "white", "sparkling", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the cool embrace of the Southern Ocean, Tasmania is a winemaker's paradise where the crisp air and fertile clay soils yield exquisite Pinot Noir and Chardonnay. This enchanting region is celebrated for its diverse wine styles, from vibrant whites to sophisticated sparkling wines, making it a must-visit for any wine enthusiast.",
        },
    },
    {
        "country": "AU",
        "name": "Victoria",
        "subregions": [
            {"name": "Alpine Valleys"},
            {"name": "Beechworth"},
            {"name": "Bendigo"},
            {"name": "Central Victoria"},
            {"name": "Geelong", "subregions": [{"name": "Bellarine Peninsula"}]},
            {"name": "Gippsland"},
            {"name": "Glenrowan"},
            {"name": "Goulburn Valley"},
            {"name": "Grampians"},
            {"name": "Great Western"},
            {"name": "Heathcote"},
            {"name": "Henty"},
            {"name": "King Valley"},
            {"name": "Macedon Ranges"},
            {"name": "Mornington Peninsula"},
            {"name": "Nagambie Lakes"},
            {"name": "North East Victoria"},
            {"name": "North West Victoria"},
            {"name": "Port Phillip"},
            {"name": "Pyrenees"},
            {"name": "Rutherglen"},
            {"name": "Strathbogie Ranges"},
            {"name": "Sunbury"},
            {"name": "Upper Goulburn"},
            {"name": "Western Victoria"},
            {"name": "Yarra Valley"},
        ],
        "climate_types": "temperate",
        "avg_annual_rainfall": None,
        "elevation_range": None,
        "soil_types": "uknown",
        "primary_grapes": [
            "Shiraz",
            "Chardonnay",
            "Cabernet Sauvignon",
            "Pinot Noir",
            "Merlot",
        ],
        "wine_styles": ["red", "white", "rose", "sparkling", "dessert", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Victoria is a vibrant tapestry of wine styles, where the boldness of Shiraz meets the elegance of Chardonnay, and the finesse of Pinot Noir dances alongside the richness of fortified wines. This region is a playground for wine lovers, offering a delightful array of flavors and experiences that reflect its unique terroir.",
        },
    },
    {
        "country": "AU",
        "name": "Western Australia",
        "synonyms": ["WA", "West Australia"],
        "subregions": [
            {"name": "Albany"},
            {"name": "Blackwood Valley"},
            {"name": "Denmark Western Australia"},
            {"name": "Ferguson Valley"},
            {"name": "Frankland River"},
            {"name": "Geographe"},
            {"name": "Great Southern"},
            {"name": "Manjimup"},
            {
                "name": "Margaret River",
                "subregions": [
                    {"name": "Karridale"},
                    {"name": "Wallcliffe"},
                    {"name": "Wilyabrup"},
                    {"name": "Yallingup"},
                ],
            },
            {"name": "Mount Barker"},
            {"name": "Peel"},
            {"name": "Pemberton"},
            {"name": "Perth Hills"},
            {"name": "Porongurup"},
            {"name": "Swan District", "subregions": [{"name": "Swan Valley"}]},
        ],
        "climate_types": "mediterranean",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 500),
        "soil_types": "sandy",
        "primary_grapes": [
            "Cabernet Sauvignon",
            "Chardonnay",
            "Shiraz",
            "Merlot",
            "Semillon",
        ],
        "wine_styles": ["red", "white", "sparkling", "dessert", "fortified"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Western Australia is a vibrant wine region known for its sandy soils and a climate that nurtures a delightful array of grape varieties, including Cabernet Sauvignon and Shiraz. With an impressive range of wine styles from bold reds to refreshing whites, this region offers a captivating experience for every palate.",
        },
    },
    {
        "country": "NZ",
        "name": "Auckland",
        "subregions": [
            {"name": "Henderson"},
            {"name": "Kumeu"},
            {"name": "Matakana"},
            {"name": "Waiheke Island", "synonyms": ["Waiheke"]},
        ],
        "climate_types": "maritime",
        "avg_annual_rainfall": 1200.0,
        "elevation_range": (0, 300),
        "soil_types": "clay",
        "primary_grapes": ["Chardonnay", "Merlot", "Cabernet Sauvignon"],
        "wine_styles": ["red", "white", "sparkling", "dessert"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Auckland is a vibrant wine region where the lush clay soils nurture a delightful array of wines, from crisp Chardonnays to bold Merlots and Cabernets. With its unique blend of red, white, sparkling, and dessert styles, this region offers a taste of New Zealand's winemaking diversity, all under the embrace of its temperate climate.",
        },
    },
    {
        "country": "NZ",
        "name": "Canterbury",
        "subregions": [{"name": "North Canterbury"}, {"name": "Waipara Valley"}],
        "climate_types": "cool_climate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 500),
        "soil_types": "clay",
        "primary_grapes": ["Pinot Noir", "Sauvignon Blanc", "Chardonnay"],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of New Zealand's South Island, Canterbury is a wine lover's paradise where the elegance of Pinot Noir meets the vibrant zest of Sauvignon Blanc and the creamy allure of Chardonnay. With its clay soils and a climate kissed by gentle rains, this region crafts wines that are as diverse as its stunning landscapes.",
        },
    },
    {
        "country": "NZ",
        "name": "Central Otago",
        "subregions": [
            {"name": "Bendigo"},
            {"name": "Bannockburn"},
            {"name": "Gibbston"},
            {"name": "Wanaka"},
        ],
        "climate_types": "cool_climate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (200, 400),
        "soil_types": "alluvial",
        "primary_grapes": ["Pinot Noir", "Chardonnay", "Riesling"],
        "wine_styles": ["red", "white"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of New Zealand's South Island, Central Otago is a vinous gem celebrated for its vibrant Pinot Noir, alongside elegant Chardonnay and aromatic Riesling. With its dramatic landscapes and diverse microclimates, this region produces wines that are as bold and expressive as the rugged beauty that surrounds them.",
        },
    },
    {
        "country": "NZ",
        "name": "Gisborne",
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 200),
        "soil_types": "sandy_loam",
        "primary_grapes": ["Chardonnay", "Sauvignon Blanc", "Gewürztraminer"],
        "wine_styles": ["white", "sparkling", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled on New Zealand's North Island, Gisborne is a sun-kissed haven renowned for its exquisite Chardonnay and Sauvignon Blanc, offering a delightful array of white, sparkling, and rosé wines that capture the essence of its coastal climate and sandy loam soils.",
        },
    },
    {
        "country": "NZ",
        "name": "Hawke's Bay",
        "subregions": [
            {"name": "Central Hawke's Bay"},
            {"name": "Gimblett Gravels"},
            {"name": "Bridge Pa Triangle"},
        ],
        "climate_types": "warm_climate",
        "avg_annual_rainfall": 800.0,
        "elevation_range": (0, 300),
        "soil_types": "sandy_loam",
        "primary_grapes": [
            "Merlot",
            "Cabernet Sauvignon",
            "Chardonnay",
            "Sauvignon Blanc",
        ],
        "wine_styles": [
            "red",
            "white",
            "rose",
            "sparkling",
            "medium_bodied",
            "full_bodied",
        ],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled on the eastern coast of New Zealand's North Island, Hawke's Bay is celebrated for its rich tapestry of wines, ranging from luscious reds to crisp whites. With its sun-soaked vineyards and a climate that nurtures both bold and elegant styles, this region is a must-visit for any wine enthusiast seeking to explore the diverse flavors of New Zealand.",
        },
    },
    {
        "country": "NZ",
        "name": "Marlborough",
        "subregions": [
            {"name": "Wairau Valley"},
            {"name": "Southern Valleys"},
            {"name": "Awatere Valley"},
        ],
        "climate_types": "maritime",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (0, 800),
        "soil_types": "alluvial",
        "primary_grapes": ["Sauvignon Blanc", "Pinot Noir", "Chardonnay"],
        "wine_styles": ["white", "red", "sparkling", "rose"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the sun-drenched valleys of New Zealand, Marlborough is a wine lover's paradise, celebrated for its crisp Sauvignon Blanc, elegant Pinot Noir, and refreshing Chardonnay. With its unique terroir and a stunning backdrop of mountains, this region produces wines that are as lively and expressive as the landscape itself.",
        },
    },
    {
        "country": "NZ",
        "name": "Nelson",
        "climate_types": "maritime",
        "avg_annual_rainfall": 1200.0,
        "elevation_range": (0, 400),
        "soil_types": "clay",
        "primary_grapes": ["Sauvignon Blanc", "Pinot Noir", "Chardonnay"],
        "wine_styles": ["white", "red", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the sun-kissed landscapes of New Zealand, Nelson is a vibrant wine region where the lush clay soils nurture exquisite Sauvignon Blancs and delicate Pinot Noirs, all kissed by the gentle maritime climate. With an annual rainfall that keeps the vines thriving, this region offers a delightful array of wines that are as refreshing as the coastal breezes that sweep through its vineyards.",
        },
    },
    {
        "country": "NZ",
        "name": "Northland",
        "climate_types": "maritime",
        "avg_annual_rainfall": 1200.0,
        "elevation_range": (0, 200),
        "soil_types": "clay",
        "primary_grapes": ["Chardonnay", "Merlot", "Cabernet Sauvignon", "Syrah"],
        "wine_styles": ["red", "white", "rose", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the embrace of lush landscapes, Northland is a wine lover's paradise where clay soils and ample rainfall cultivate a delightful array of wines. From the crisp elegance of Chardonnay to the bold character of Syrah, this region offers a tantalizing journey through red, white, and sparkling styles that are sure to enchant any palate.",
        },
    },
    {
        "country": "NZ",
        "name": "Waikato",
        "climate_types": "maritime",
        "avg_annual_rainfall": 1200.0,
        "elevation_range": (0, 300),
        "soil_types": "alluvial",
        "primary_grapes": ["Chardonnay", "Pinot Noir"],
        "wine_styles": ["red", "white", "sparkling", "medium_bodied"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of New Zealand's North Island, Waikato is a hidden gem where the rolling hills and fertile alluvial soils give rise to exquisite Chardonnay and Pinot Noir. With a climate that nurtures both red and white wines, this region offers a delightful array of medium-bodied wines that are as refreshing as the lush landscapes that surround them.",
        },
    },
    {
        "country": "NZ",
        "name": "Wairarapa",
        "subregions": [{"name": "Martinborough"}, {"name": "Gladstone"}],
        "climate_types": "cool_climate",
        "avg_annual_rainfall": 900.0,
        "elevation_range": (0, 300),
        "soil_types": "clay",
        "primary_grapes": ["Pinot Noir", "Sauvignon Blanc"],
        "wine_styles": [
            "red",
            "white",
            "medium_bodied",
            "full_bodied",
            "oaked",
            "unoaked",
        ],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled in the heart of New Zealand, Wairarapa is celebrated for its exquisite Pinot Noir and vibrant Sauvignon Blanc, crafted from clay soils that impart depth and character. With a delightful mix of red and white styles, this region offers a captivating journey for the palate, whether you prefer a lush, oaked red or a crisp, unoaked white.",
        },
    },
    {
        "country": "NZ",
        "name": "Waitaki Valley",
        "climate_types": "cool_climate",
        "avg_annual_rainfall": 600.0,
        "elevation_range": (200, 400),
        "soil_types": "alluvial",
        "primary_grapes": ["Pinot Noir", "Riesling"],
        "wine_styles": ["red", "white", "sparkling"],
        "description": {
            "julie": "",
            "default": "",
            "sommelier": "Nestled between the mountains and the sea, the Waitaki Valley is a hidden gem where the cool climate nurtures vibrant Pinot Noir and aromatic Riesling, resulting in wines that are both expressive and refreshing. With its stunning landscapes and innovative winemakers, this region is a must-visit for any wine enthusiast seeking to explore New Zealand's diverse offerings.",
        },
    },
]
