# Generated by Django 4.1.9 on 2023-07-11 08:24

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("io", "0001_initial_squashed"),
        ("wbportfolio", "0041_remove_listresearch_research_ptr_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="InstrumentList",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=255)),
                ("identifier", models.CharField(max_length=255, unique=True)),
                (
                    "instrument_list_type",
                    models.CharField(
                        blank=True,
                        choices=[("WATCH", "Watch List"), ("EXCLUSION", "Exclusion List")],
                        max_length=32,
                        null=True,
                    ),
                ),
            ],
            options={
                "verbose_name": "Instrument List",
                "verbose_name_plural": "Instrument Lists",
            },
        ),
        migrations.CreateModel(
            name="InstrumentListThroughModel",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("from_date", models.DateField(blank=True, null=True)),
                ("to_date", models.DateField(blank=True, null=True)),
                ("comment", models.TextField(blank=True, default="")),
                ("validated", models.BooleanField(default=False)),
                (
                    "import_source",
                    models.ForeignKey(
                        blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="io.importsource"
                    ),
                ),
                (
                    "instrument",
                    models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="wbportfolio.instrument"),
                ),
                (
                    "instrument_list",
                    models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="wbportfolio.instrumentlist"),
                ),
            ],
            options={
                "verbose_name": "Instruments in Instrument List",
                "unique_together": {("instrument", "instrument_list")},
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name="instrumentlist",
            name="instruments",
            field=models.ManyToManyField(
                through="wbportfolio.InstrumentListThroughModel", to="wbportfolio.instrument"
            ),
        ),
    ]
