# Generated by Django 4.2.7 on 2023-12-12 16:27
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("wbfdm", "0010_classification_classificationgroup_deal_exchange_and_more"),
        ("wbportfolio", "0051_delete_macroreview"),
    ]

    operations = [
        migrations.AlterUniqueTogether(
            name="dailyfundamental",
            unique_together=None,
        ),
        migrations.AlterUniqueTogether(
            name="fiscalperiod",
            unique_together=None,
        ),
        migrations.AlterUniqueTogether(
            name="forecast",
            unique_together=None,
        ),
        migrations.AlterUniqueTogether(
            name="fundamental",
            unique_together=None,
        ),
        migrations.AlterUniqueTogether(
            name="geographicsegment",
            unique_together=None,
        ),
        migrations.AlterUniqueTogether(
            name="instrumentlistthroughmodel",
            unique_together=None,
        ),
        migrations.AlterUniqueTogether(
            name="instrumentprice",
            unique_together=None,
        ),
        migrations.AlterUniqueTogether(
            name="relatedinstrumentthroughmodel",
            unique_together=None,
        ),
        migrations.RemoveField(
            model_name="cash",
            name="instrument_ptr",
        ),
        migrations.RemoveField(
            model_name="dailyfundamental",
            name="import_source",
        ),
        migrations.RemoveField(
            model_name="dailyfundamental",
            name="instrument",
        ),
        migrations.RemoveField(
            model_name="equity",
            name="instrument_ptr",
        ),
        migrations.RemoveField(
            model_name="etf",
            name="instrument_ptr",
        ),
        migrations.RemoveField(
            model_name="etp",
            name="instrument_ptr",
        ),
        migrations.RemoveField(
            model_name="fiscalperiod",
            name="import_source",
        ),
        migrations.RemoveField(
            model_name="fiscalperiod",
            name="instrument",
        ),
        migrations.RemoveField(
            model_name="forecast",
            name="import_source",
        ),
        migrations.RemoveField(
            model_name="forecast",
            name="instrument",
        ),
        migrations.RemoveField(
            model_name="fundamental",
            name="import_source",
        ),
        migrations.RemoveField(
            model_name="fundamental",
            name="instrument",
        ),
        migrations.RemoveField(
            model_name="fundamental",
            name="period",
        ),
        migrations.RemoveField(
            model_name="future",
            name="instrument_ptr",
        ),
        migrations.RemoveField(
            model_name="geographicsegment",
            name="import_source",
        ),
        migrations.RemoveField(
            model_name="geographicsegment",
            name="instrument",
        ),
        migrations.RemoveField(
            model_name="geographicsegment",
            name="period",
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="exchanges",
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="last_daily_fundamental",
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="imports_allowed",
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="last_forecast",
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="last_fundamental_current",
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="last_fundamental_y0",
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="last_fundamental_y1",
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="last_fundamental_y2",
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="last_fundamental_y3",
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="last_geographic_segment",
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="last_instrument_price",
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="last_quarterly_period",
        ),
        migrations.RemoveField(
            model_name="mutualfund",
            name="instrument_ptr",
        ),
        migrations.RemoveField(
            model_name="option",
            name="instrument_ptr",
        ),
        migrations.RemoveField(
            model_name="option",
            name="underlying",
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="financial_instrument",
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="next_quarterly_period",
        ),
        migrations.RemoveField(
            model_name="interestratederivative",
            name="instrument_ptr",
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="portfolios",
        ),
        migrations.AddField(
            model_name="portfolio",
            name="instruments",
            field=models.ManyToManyField(
                blank=True,
                help_text="Instruments linked to this instrument",
                related_name="portfolios",
                through="wbportfolio.InstrumentPortfolioThroughModel",
                to="wbfdm.instrument",
                verbose_name="Instruments",
            ),
        ),
        migrations.RenameField(
            model_name="instrument",
            old_name="price_computation",
            new_name="old_price_computation",
        ),
        migrations.AddField(
            model_name="product",
            name="price_computation",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="products",
                to="wbportfolio.pricecomputation",
                verbose_name="Price Computation Method",
            ),
        ),
        migrations.AddField(
            model_name="index",
            name="price_computation",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="indexes",
                to="wbportfolio.pricecomputation",
                verbose_name="Price Computation Method",
            ),
        ),
        migrations.AddField(
            model_name="instrument",
            name="exchange",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="wbportfolio.exchange",
            ),
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="old_price_computation",
        ),
        migrations.RenameField(model_name="classification", old_name="title", new_name="name"),
        migrations.RenameField(model_name="classificationgroup", old_name="title", new_name="name"),
        migrations.RenameField(model_name="instrument", old_name="title", new_name="name"),
        migrations.RenameField(model_name="instrument", old_name="title_repr", new_name="name_repr"),
        migrations.RenameField(model_name="instrument", old_name="closing_date", new_name="delisted_date"),
        migrations.RenameField(model_name="instrument", old_name="alternative_titles", new_name="alternative_names"),
        migrations.RemoveField(
            model_name="exchangeinstrumentthroughmodel",
            name="exchange",
        ),
        migrations.RemoveField(
            model_name="exchangeinstrumentthroughmodel",
            name="instrument",
        ),
        migrations.RemoveField(
            model_name="instrument",
            name="primary_field",
        ),
        migrations.AlterField(
            model_name="instrument",
            name="currency",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="currency.currency",
            ),
        ),
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.AlterUniqueTogether(
                    name="adjustment",
                    unique_together={("date", "instrument")},
                ),
                migrations.AddIndex(
                    model_name="adjustment",
                    index=models.Index(fields=["instrument", "-date"], name="instrument_adjustment_idx"),
                ),
                migrations.AddIndex(
                    model_name="assetposition",
                    index=models.Index(
                        fields=["date", "underlying_instrument", "portfolio"], name="wbportfolio_date_0a7c0a_idx"
                    ),
                ),
                migrations.AddIndex(
                    model_name="assetposition",
                    index=models.Index(fields=["date", "underlying_instrument"], name="wbportfolio_date_da82d2_idx"),
                ),
                migrations.AddIndex(
                    model_name="transaction",
                    index=models.Index(
                        fields=["underlying_instrument", "transaction_date"], name="wbportfolio_underly_391e3e_idx"
                    ),
                ),
                migrations.RemoveField(
                    model_name="classification",
                    name="group",
                ),
                migrations.RemoveField(
                    model_name="classification",
                    name="parent",
                ),
                migrations.RemoveField(
                    model_name="deal",
                    name="equity",
                ),
                migrations.RemoveField(
                    model_name="deal",
                    name="import_source",
                ),
                migrations.RemoveField(
                    model_name="deal",
                    name="investors",
                ),
                migrations.RemoveField(
                    model_name="exchange",
                    name="city",
                ),
                migrations.RemoveField(
                    model_name="exchange",
                    name="country",
                ),
                migrations.RemoveField(
                    model_name="instrument",
                    name="classifications",
                ),
                migrations.RemoveField(
                    model_name="instrument",
                    name="country",
                ),
                migrations.RemoveField(
                    model_name="instrument",
                    name="currency",
                ),
                migrations.RemoveField(
                    model_name="instrument",
                    name="headquarter_city",
                ),
                migrations.RemoveField(
                    model_name="instrument",
                    name="import_source",
                ),
                migrations.RemoveField(
                    model_name="instrument",
                    name="related_instruments",
                ),
                migrations.RemoveField(
                    model_name="instrument",
                    name="tags",
                ),
                migrations.RemoveField(
                    model_name="instrumentclassificationrelatedinstrument",
                    name="classified_instrument",
                ),
                migrations.RemoveField(
                    model_name="instrumentclassificationrelatedinstrument",
                    name="related_instrument",
                ),
                migrations.RemoveField(
                    model_name="instrumentclassificationthroughmodel",
                    name="classification",
                ),
                migrations.RemoveField(
                    model_name="instrumentclassificationthroughmodel",
                    name="instrument",
                ),
                migrations.RemoveField(
                    model_name="instrumentclassificationthroughmodel",
                    name="related_instruments",
                ),
                migrations.RemoveField(
                    model_name="instrumentclassificationthroughmodel",
                    name="tags",
                ),
                migrations.RemoveField(
                    model_name="instrumentfavoritegroup",
                    name="instruments",
                ),
                migrations.RemoveField(
                    model_name="instrumentfavoritegroup",
                    name="owner",
                ),
                migrations.RemoveField(
                    model_name="instrumentlistthroughmodel",
                    name="import_source",
                ),
                migrations.RemoveField(
                    model_name="instrumentlistthroughmodel",
                    name="instrument",
                ),
                migrations.RemoveField(
                    model_name="instrumentlistthroughmodel",
                    name="instrument_list",
                ),
                migrations.RemoveField(
                    model_name="instrumentprice",
                    name="currency_fx_rate_to_usd",
                ),
                migrations.RemoveField(
                    model_name="instrumentprice",
                    name="import_source",
                ),
                migrations.RemoveField(
                    model_name="instrumentprice",
                    name="instrument",
                ),
                migrations.RemoveField(
                    model_name="instrumentrequest",
                    name="created_instrument",
                ),
                migrations.RemoveField(
                    model_name="instrumentrequest",
                    name="handler",
                ),
                migrations.RemoveField(
                    model_name="instrumentrequest",
                    name="requester",
                ),
                migrations.RemoveField(
                    model_name="relatedinstrumentthroughmodel",
                    name="instrument",
                ),
                migrations.RemoveField(
                    model_name="relatedinstrumentthroughmodel",
                    name="related_instrument",
                ),
                migrations.AddField(
                    model_name="adjustment",
                    name="instrument",
                    field=models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="pms_adjustments",
                        to="wbfdm.instrument",
                    ),
                ),
                migrations.AddField(
                    model_name="assetposition",
                    name="exchange",
                    field=models.ForeignKey(
                        blank=True,
                        help_text="The exchange where this asset is.",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="assets",
                        to="wbfdm.exchange",
                        verbose_name="Exchange",
                    ),
                ),
                migrations.AddField(
                    model_name="assetposition",
                    name="underlying_instrument",
                    field=models.ForeignKey(
                        help_text="The instrument that is this asset.",
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="assets",
                        to="wbfdm.instrument",
                        verbose_name="Underlying Instrument",
                    ),
                ),
                migrations.AddField(
                    model_name="assetposition",
                    name="underlying_instrument_price",
                    field=models.ForeignKey(
                        blank=True,
                        help_text="The instrument price that is this asset.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="assets",
                        to="wbfdm.instrumentprice",
                        verbose_name="Underlying Instrument Price",
                    ),
                ),
                migrations.AddField(
                    model_name="instrumentportfoliothroughmodel",
                    name="instrument",
                    field=models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="through_portfolios",
                        to="wbfdm.instrument",
                    ),
                ),
                migrations.AddField(
                    model_name="index",
                    name="instrument_ptr",
                    field=models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbfdm.instrument",
                    ),
                ),
                migrations.AddField(
                    model_name="product",
                    name="instrument_ptr",
                    field=models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbfdm.instrument",
                    ),
                ),
                migrations.AddField(
                    model_name="productgroup",
                    name="instrument_ptr",
                    field=models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbfdm.instrument",
                    ),
                ),
                migrations.AddField(
                    model_name="portfolio",
                    name="prefered_instrument_classifications",
                    field=models.ManyToManyField(
                        blank=True,
                        related_name="prefered_portfolio_classifications",
                        through="wbportfolio.PortfolioInstrumentPreferedClassificationThroughModel",
                        to="wbfdm.instrument",
                        verbose_name="The Prefered classification per instrument",
                    ),
                ),
                migrations.AddField(
                    model_name="portfolioinstrumentpreferedclassificationthroughmodel",
                    name="classification",
                    field=models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="prefered_classification_throughs",
                        to="wbfdm.classification",
                    ),
                ),
                migrations.AddField(
                    model_name="portfolioinstrumentpreferedclassificationthroughmodel",
                    name="classification_group",
                    field=models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="prefered_classification_group_throughs",
                        to="wbfdm.classificationgroup",
                    ),
                ),
                migrations.AddField(
                    model_name="portfolioinstrumentpreferedclassificationthroughmodel",
                    name="instrument",
                    field=models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="prefered_classification_portfolio",
                        to="wbfdm.instrument",
                    ),
                ),
                migrations.AddField(
                    model_name="portfoliorole",
                    name="instrument",
                    field=models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="portfolio_roles",
                        to="wbfdm.instrument",
                        verbose_name="Instrument",
                    ),
                ),
                migrations.AddField(
                    model_name="transaction",
                    name="underlying_instrument",
                    field=models.ForeignKey(
                        help_text="The instrument that is this transaction.",
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="transactions",
                        to="wbfdm.instrument",
                        verbose_name="Underlying Instrument",
                    ),
                ),
            ]
        ),
        migrations.DeleteModel(
            name="Bond",
        ),
        migrations.DeleteModel(
            name="Cash",
        ),
        migrations.DeleteModel(
            name="Equity",
        ),
        migrations.DeleteModel(
            name="ETF",
        ),
        migrations.DeleteModel(
            name="ETP",
        ),
        migrations.DeleteModel(
            name="DailyFundamental",
        ),
        migrations.DeleteModel(
            name="FiscalPeriod",
        ),
        migrations.DeleteModel(
            name="Forecast",
        ),
        migrations.DeleteModel(
            name="Fundamental",
        ),
        migrations.DeleteModel(
            name="Future",
        ),
        migrations.DeleteModel(
            name="GeographicSegment",
        ),
        migrations.DeleteModel(
            name="InterestRateDerivative",
        ),
        migrations.DeleteModel(
            name="MutualFund",
        ),
        migrations.DeleteModel(
            name="Option",
        ),
        migrations.DeleteModel(
            name="ExchangeInstrumentThroughModel",
        ),
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.DeleteModel(
                    name="Exchange",
                )
            ],
            database_operations=[migrations.AlterModelTable(name="Exchange", table="wbfdm_exchange")],
        ),
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.DeleteModel(
                    name="Classification",
                )
            ],
            database_operations=[migrations.AlterModelTable(name="Classification", table="wbfdm_classification")],
        ),
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.DeleteModel(
                    name="ClassificationGroup",
                )
            ],
            database_operations=[
                migrations.AlterModelTable(name="ClassificationGroup", table="wbfdm_classificationgroup")
            ],
        ),
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.DeleteModel(
                    name="Instrument",
                )
            ],
            database_operations=[migrations.AlterModelTable(name="Instrument", table="wbfdm_instrument")],
        ),
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.DeleteModel(
                    name="InstrumentClassificationRelatedInstrument",
                )
            ],
            database_operations=[
                migrations.AlterModelTable(
                    name="InstrumentClassificationRelatedInstrument",
                    table="wbfdm_instrumentclassificationrelatedinstrument",
                )
            ],
        ),
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.DeleteModel(
                    name="InstrumentClassificationThroughModel",
                )
            ],
            database_operations=[
                migrations.AlterModelTable(
                    name="InstrumentClassificationThroughModel", table="wbfdm_instrumentclassificationthroughmodel"
                )
            ],
        ),
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.DeleteModel(
                    name="InstrumentFavoriteGroup",
                )
            ],
            database_operations=[
                migrations.AlterModelTable(name="InstrumentFavoriteGroup", table="wbfdm_instrumentfavoritegroup")
            ],
        ),
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.DeleteModel(
                    name="InstrumentList",
                )
            ],
            database_operations=[migrations.AlterModelTable(name="InstrumentList", table="wbfdm_instrumentlist")],
        ),
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.DeleteModel(
                    name="InstrumentListThroughModel",
                )
            ],
            database_operations=[
                migrations.AlterModelTable(name="InstrumentListThroughModel", table="wbfdm_instrumentlistthroughmodel")
            ],
        ),
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.DeleteModel(
                    name="InstrumentPrice",
                )
            ],
            database_operations=[migrations.AlterModelTable(name="InstrumentPrice", table="wbfdm_instrumentprice")],
        ),
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.DeleteModel(
                    name="InstrumentRequest",
                )
            ],
            database_operations=[
                migrations.AlterModelTable(name="InstrumentRequest", table="wbfdm_instrumentrequest")
            ],
        ),
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.DeleteModel(
                    name="RelatedInstrumentThroughModel",
                )
            ],
            database_operations=[
                migrations.AlterModelTable(
                    name="RelatedInstrumentThroughModel", table="wbfdm_relatedinstrumentthroughmodel"
                )
            ],
        ),
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.DeleteModel(
                    name="Deal",
                ),
            ],
            database_operations=[migrations.AlterModelTable(name="Deal", table="wbfdm_deal")],
        ),
    ]
