"""
Python port of ImGuiColorTextEdit: https://github.com/BalazsJako/ImGuiColorTextEdit

Below is the readme from the project
====================================

# ImGuiColorTextEdit
Syntax highlighting text editor for ImGui

![Screenshot](https://github.com/BalazsJako/ImGuiColorTextEdit/wiki/ImGuiTextEdit.png "Screenshot")

Demo project: https://github.com/BalazsJako/ColorTextEditorDemo

This started as my attempt to write a relatively simple widget which provides text editing functionality with syntax highlighting. Now there are other contributors who provide valuable additions.

While it relies on Omar Cornut's https://github.com/ocornut/imgui, it does not follow the "pure" one widget - one function approach. Since the editor has to maintain a relatively complex and large internal state, it did not seem to be practical to try and enforce fully immediate mode. It stores its internal state in an object instance which is reused across frames.

The code is (still) work in progress, please report if you find any issues.

# Main features
 - approximates typical code editor look and feel (essential mouse/keyboard commands work - I mean, the commands _I_ normally use :))
 - undo/redo
 - UTF-8 support
 - works with both fixed and variable-width fonts
 - extensible syntax highlighting for multiple languages
 - identifier declarations: a small piece of description can be associated with an identifier. The editor displays it in a tooltip when the mouse cursor is hovered over the identifier
 - error markers: the user can specify a list of error messages together the line of occurence, the editor will highligh the lines with red backround and display error message in a tooltip when the mouse cursor is hovered over the line
 - large files: there is no explicit limit set on file size or number of lines (below 2GB, performance is not affected when large files are loaded (except syntax coloring, see below)
 - color palette support: you can switch between different color palettes, or even define your own
 - whitespace indicators (TAB, space)

# Known issues
 - syntax highligthing of most languages - except C/C++ - is based on std::regex, which is diasppointingly slow. Because of that, the highlighting process is amortized between multiple frames. C/C++ has a hand-written tokenizer which is much faster.

Please post your screenshots if you find this little piece of software useful. :)

# Contribute

If you want to contribute, please refer to CONTRIBUTE file.

"""
# ruff: noqa: F821, B008
from __future__ import annotations
from typing import List, Any, Dict, Set, overload, Optional
import enum

from imgui_bundle.imgui import ImVec2Like

String = str
Identifiers = Dict[
    str, Any
]  # Dict[str, Identifier] (but Identifier is defined later in the generated code)
Keywords = Set[str]
ErrorMarkers = Dict[int, str]
Breakpoints = Set[int]
Palette = List[int]
Char = int


# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# <litgen_stub> // Autogenerated code below! Do not edit!
####################    <generated_from:TextEditor.h>    ####################


class TextEditor:
    # ------------- Exposed API ------------- //

    def __init__(self) -> None:
        pass

    class PaletteId(enum.IntEnum):
        dark = enum.auto()               # (= 0)
        light = enum.auto()              # (= 1)
        mariana = enum.auto()            # (= 2)
        retro_blue = enum.auto()         # (= 3)
    class LanguageDefinitionId(enum.IntEnum):
        none = enum.auto()               # (= 0)
        cpp = enum.auto()                # (= 1)
        c = enum.auto()                  # (= 2)
        cs = enum.auto()                 # (= 3)
        python = enum.auto()             # (= 4)
        lua = enum.auto()                # (= 5)
        json = enum.auto()               # (= 6)
        sql = enum.auto()                # (= 7)
        angel_script = enum.auto()       # (= 8)
        glsl = enum.auto()               # (= 9)
        hlsl = enum.auto()               # (= 10)
    class SetViewAtLineMode(enum.IntEnum):
        first_visible_line = enum.auto() # (= 0)
        centered = enum.auto()           # (= 1)
        last_visible_line = enum.auto()  # (= 2)

    def set_read_only_enabled(self, a_value: bool) -> None:
        pass
    def is_read_only_enabled(self) -> bool:
        pass
    def set_auto_indent_enabled(self, a_value: bool) -> None:
        pass
    def is_auto_indent_enabled(self) -> bool:
        pass
    def set_show_whitespaces_enabled(self, a_value: bool) -> None:
        pass
    def is_show_whitespaces_enabled(self) -> bool:
        pass
    def set_show_line_numbers_enabled(self, a_value: bool) -> None:
        pass
    def is_show_line_numbers_enabled(self) -> bool:
        pass
    def set_short_tabs_enabled(self, a_value: bool) -> None:
        pass
    def is_short_tabs_enabled(self) -> bool:
        pass
    def get_line_count(self) -> int:
        pass
    def set_palette(self, a_value: TextEditor.PaletteId) -> None:
        pass
    def get_palette(self) -> TextEditor.PaletteId:
        pass
    def set_language_definition(self, a_value: TextEditor.LanguageDefinitionId) -> None:
        pass
    def get_language_definition(self) -> TextEditor.LanguageDefinitionId:
        pass
    def get_language_definition_name(self) -> str:
        pass
    def set_tab_size(self, a_value: int) -> None:
        pass
    def get_tab_size(self) -> int:
        pass
    def set_line_spacing(self, a_value: float) -> None:
        pass
    def get_line_spacing(self) -> float:
        pass

    @staticmethod
    def set_default_palette(a_value: TextEditor.PaletteId) -> None:
        pass
    @staticmethod
    def get_default_palette() -> TextEditor.PaletteId:
        pass

    def select_all(self) -> None:
        pass
    def select_line(self, a_line: int) -> None:
        pass
    def select_region(
        self,
        a_start_line: int,
        a_start_char: int,
        a_end_line: int,
        a_end_char: int
        ) -> None:
        pass
    @overload
    def select_next_occurrence_of(
        self,
        a_text: str,
        a_text_size: int,
        a_case_sensitive: bool = True
        ) -> None:
        pass
    def select_all_occurrences_of(
        self,
        a_text: str,
        a_text_size: int,
        a_case_sensitive: bool = True
        ) -> None:
        pass
    def any_cursor_has_selection(self) -> bool:
        pass
    def all_cursors_have_selection(self) -> bool:
        pass
    def clear_extra_cursors(self) -> None:
        pass
    def clear_selections(self) -> None:
        pass
    @overload
    def set_cursor_position(self, a_line: int, a_char_index: int) -> None:
        pass
    def get_cursor_position(self, out_line: int, out_column: int) -> None:
        pass
    def get_first_visible_line(self) -> int:
        pass
    def get_last_visible_line(self) -> int:
        pass
    def set_view_at_line(self, a_line: int, a_mode: TextEditor.SetViewAtLineMode) -> None:
        pass

    def copy(self) -> None:
        pass
    def cut(self) -> None:
        pass
    def paste(self) -> None:
        pass
    def undo(self, a_steps: int = 1) -> None:
        pass
    def redo(self, a_steps: int = 1) -> None:
        pass
    def can_undo(self) -> bool:
        pass
    def can_redo(self) -> bool:
        pass
    def get_undo_index(self) -> int:
        pass

    def set_text(self, a_text: str) -> None:
        pass
    @overload
    def get_text(self) -> str:
        pass

    def set_text_lines(self, a_lines: List[str]) -> None:
        pass
    def get_text_lines(self) -> List[str]:
        pass

    @overload
    def render(
        self,
        a_title: str,
        a_parent_is_focused: bool = False,
        a_size: Optional[ImVec2Like] = None,
        a_border: bool = False
        ) -> bool:
        """Python bindings defaults:
            If aSize is None, then its default value will be: ImVec2()
        """
        pass

    def im_gui_debug_panel(self, panel_name: str = "Debug") -> None:
        pass
    def unit_tests(self) -> None:
        pass

    @overload
    def set_selection(
        self,
        a_start_line: int,
        a_start_char: int,
        a_end_line: int,
        a_end_char: int,
        a_cursor: int = -1
        ) -> None:
        pass
    def get_selection_start(self, a_cursor: int = -1) -> TextEditor.Coordinates:
        pass
    def get_selection_end(self, a_cursor: int = -1) -> TextEditor.Coordinates:
        pass
    def get_selected_text(self, a_cursor: int = -1) -> str:
        pass

####################    </generated_from:TextEditor.h>    ####################

# </litgen_stub> // Autogenerated code end!
