"""Knobs for ImGui
Python bindings for https://github.com/altschuler/imgui-knobs
"""

from typing import Tuple, Optional, overload
import enum

from imgui_bundle.imgui import ImColor

ImGuiKnobFlags = int
ImGuiKnobVariant = int

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# <litgen_stub> // Autogenerated code below! Do not edit!
####################    <generated_from:imgui-knobs.h>    ####################

class ImGuiKnobFlags_(enum.IntEnum):
    no_title = enum.auto()  # (= 1 << 0)
    no_input = enum.auto()  # (= 1 << 1)
    value_tooltip = enum.auto()  # (= 1 << 2)
    drag_horizontal = enum.auto()  # (= 1 << 3)
    drag_vertical = enum.auto()  # (= 1 << 4)
    logarithmic = enum.auto()  # (= 1 << 5)
    always_clamp = enum.auto()  # (= 1 << 6)

class ImGuiKnobVariant_(enum.IntEnum):
    tick = enum.auto()  # (= 1 << 0)
    dot = enum.auto()  # (= 1 << 1)
    wiper = enum.auto()  # (= 1 << 2)
    wiper_only = enum.auto()  # (= 1 << 3)
    wiper_dot = enum.auto()  # (= 1 << 4)
    stepped = enum.auto()  # (= 1 << 5)
    space = enum.auto()  # (= 1 << 6)

class color_set:
    base: ImColor
    hovered: ImColor
    active: ImColor

    @overload
    def __init__(self, base: ImColor, hovered: ImColor, active: ImColor) -> None:
        pass

    @overload
    def __init__(self, color: ImColor) -> None:
        pass

def knob(
    label: str,
    p_value: float,
    v_min: float,
    v_max: float,
    speed: float = 0,
    format: str = "%.3",
    variant: Optional[ImGuiKnobVariant] = None,
    size: float = 0,
    flags: ImGuiKnobFlags = 0,
    steps: int = 10,
    angle_min: float = -1,
    angle_max: float = -1,
) -> Tuple[bool, float]:
    """Python bindings defaults:
    If variant is None, then its default value will be: ImGuiKnobVariant_.tick
    """
    pass

def knob_int(
    label: str,
    p_value: int,
    v_min: int,
    v_max: int,
    speed: float = 0,
    format: str = "%i",
    variant: Optional[ImGuiKnobVariant] = None,
    size: float = 0,
    flags: ImGuiKnobFlags = 0,
    steps: int = 10,
    angle_min: float = -1,
    angle_max: float = -1,
) -> Tuple[bool, int]:
    """Python bindings defaults:
    If variant is None, then its default value will be: ImGuiKnobVariant_.tick
    """
    pass

####################    </generated_from:imgui-knobs.h>    ####################

# </litgen_stub> // Autogenerated code end!
