"""A texture inspector tool for Dear ImGui
https://github.com/andyborrell/imgui_tex_inspect
"""
# ruff: noqa: F821, B008
from typing import overload, Optional
import enum

import imgui_bundle
from imgui_bundle.imgui import ImVec2, ImTextureID, ImDrawList, ImU32, ImVec2Like, ImVec4Like
from imgui_bundle import imgui

ImGuiTexInspect = imgui_bundle.imgui_tex_inspect
ImGuiID = imgui.ID
InspectorFlags = int

def create_context() -> int:
    """Creates a context and returns it address"""
    pass

def destroy_context(ctx_address: int) -> None:
    """Destroy a context and returns it address"""
    pass

def set_current_context(ctx_address: int) -> None:
    pass


# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# <litgen_stub> // Autogenerated code below! Do not edit!
####################    <generated_from:imgui_tex_inspect.h>    ####################
# ImGuiTexInspect, a texture inspector widget for dear imgui


#-------------------------------------------------------------------------
# [SECTION] INIT & SHUTDOWN
#-------------------------------------------------------------------------
def init() -> None:
    pass
def shutdown() -> None:
    pass


#-------------------------------------------------------------------------
# [SECTION] BASIC USAGE
#-------------------------------------------------------------------------

class InspectorAlphaMode(enum.IntEnum):
    im_gui = enum.auto()       # (= 0)  # Alpha is transparency so you see the ImGui panel background behind image
    black = enum.auto()        # (= 1)  # Alpha is used to blend over a black background
    white = enum.auto()        # (= 2)  # Alpha is used to blend over a white background
    custom_color = enum.auto() # (= 3)  # Alpha is used to blend over a custom colour.

class InspectorFlags_(enum.IntEnum):
    show_wrap = enum.auto()               # (= 1 << 0)  # Draw beyong the [0,1] uv range. What you see will depend on API
    no_force_filter_nearest = enum.auto() # (= 1 << 1)  # Normally we force nearest neighbour sampling when zoomed in. Set to disable this.
    no_grid = enum.auto()                 # (= 1 << 2)  # By default a grid is shown at high zoom levels
    no_tooltip = enum.auto()              # (= 1 << 3)  # Disable tooltip on hover
    fill_horizontal = enum.auto()         # (= 1 << 4)  # Scale to fill available space horizontally
    fill_vertical = enum.auto()           # (= 1 << 5)  # Scale to fill available space vertically
    no_auto_read_texture = enum.auto()    # (= 1 << 6)  # By default texture data is read to CPU every frame for tooltip and annotations
    flip_x = enum.auto()                  # (= 1 << 7)  # Horizontally flip the way the texture is displayed
    flip_y = enum.auto()                  # (= 1 << 8)  # Vertically flip the way the texture is displayed

# Use one of these Size structs if you want to specify an exact size for the inspector panel.
# * E.g.
# * BeginInspectorPanel("MyPanel", texture_1K, ImVec2(1024,1024), 0, SizeExcludingBorder(ImVec2(1024,1024)));
# *
# * However, most of the time the default size will be fine. E.g.
# *
# * BeginInspectorPanel("MyPanel", texture_1K, ImVec2(1024,1024));
#
class SizeIncludingBorder:
    size: ImVec2
    def __init__(self, size: ImVec2Like) -> None:
        pass
class SizeExcludingBorder:
    size: ImVec2
    def __init__(self, size: ImVec2Like) -> None:
        pass
# BeginInspectorPanel
# * Returns True if panel is drawn.  Note that flags will only be considered on the first call
@overload
def begin_inspector_panel(
    name: str,
    param_1: ImTextureID,
    texture_size: ImVec2Like,
    flags: InspectorFlags = 0
    ) -> bool:
    pass
@overload
def begin_inspector_panel(
    name: str,
    param_1: ImTextureID,
    texture_size: ImVec2Like,
    flags: InspectorFlags,
    size: SizeIncludingBorder
    ) -> bool:
    pass
@overload
def begin_inspector_panel(
    name: str,
    param_1: ImTextureID,
    texture_size: ImVec2Like,
    flags: InspectorFlags,
    size: SizeExcludingBorder
    ) -> bool:
    pass

def end_inspector_panel() -> None:
    """ EndInspectorPanel
     * Always call after BeginInspectorPanel and after you have drawn any required annotations
    """
    pass

def release_inspector_data(id: ImGuiID) -> None:
    """ ReleaseInspectorData
     * ImGuiTexInspect keeps texture data cached in memory.  If you know you won't
     * be displaying a particular panel for a while you can call this to release
     * the memory. It won't be allocated again until next time you call
     * BeginInspectorPanel.  If id is None then the current (most recent) inspector
     * will be affected.  Unless you have a lot of different Inspector instances
     * you can probably not worry about this. Call CurrentInspector_GetID to get
     * the ID of an inspector.

    """
    pass

#-------------------------------------------------------------------------
# [SECTION] CURRENT INSPECTOR MANIPULATORS
#-------------------------------------------------------------------------
#/* All the functions starting with CurrentInspector_ can be used after calling
# * BeginInspector until the end of the frame.  It is not necessary to call them
# * before the matching EndInspectorPanel
# */


# CurrentInspector_SetAlphaMode - see enum comments for details
def current_inspector_set_alpha_mode(param_0: InspectorAlphaMode) -> None:
    pass
def current_inspector_set_flags(
    to_set: InspectorFlags,
    to_clear: InspectorFlags = 0
    ) -> None:
    pass
def current_inspector_clear_flags(to_clear: InspectorFlags) -> None:
    pass
def current_inspector_set_grid_color(color: ImU32) -> None:
    pass
def current_inspector_set_max_annotations(max_annotations: int) -> None:
    pass

def current_inspector_invalidate_texture_cache() -> None:
    """ CurrentInspector_InvalidateTextureCache
     * If using the InspectorFlags_NoAutoReadTexture flag then call this to
     * indicate your texture has changed context.

    """
    pass

# CurrentInspector_SetCustomBackgroundColor
# * If using InspectorAlphaMode_CustomColor then this is the color that will be
# * blended as the background where alpha is less than one.
#
@overload
def current_inspector_set_custom_background_color(color: ImVec4Like) -> None:
    pass
@overload
def current_inspector_set_custom_background_color(color: ImU32) -> None:
    pass

def current_inspector_get_id() -> ImGuiID:
    """ CurrentInspector_GetID
     * Get the ID of the current inspector.  Currently only used for calling
     * ReleaseInspectorData.

    """
    pass

# Some convenience functions for drawing ImGui controls for the current Inspector
def draw_color_matrix_editor() -> None:
    """ ColorMatrix editor.  See comments on ColorMatrix below."""
    pass
def draw_grid_editor() -> None:
    """ Grid editor.  Enable/Disable grid. Set Grid Color."""
    pass
def draw_color_channel_selector() -> None:
    """ For toggling R,G,B channels"""
    pass
def draw_alpha_mode_selector() -> None:
    """ A combo box for selecting the alpha mode"""
    pass

def set_zoom_rate(factor: float) -> None:
    """-------------------------------------------------------------------------
     [SECTION] CONTEXT-WIDE SETTINGS
    -------------------------------------------------------------------------
    /* SetZoomRate
     * factor should be greater than 1.  A value of 1.5 means one mouse wheel
     * scroll will increase zoom level by 50%. The factor used for zooming out is
     * 1/factor. */
    """
    pass

#-------------------------------------------------------------------------
# [SECTION] ANNOTATION TOOLS
#-------------------------------------------------------------------------

def draw_annotation_line(
    draw_list: ImDrawList,
    from_texel: ImVec2Like,
    to_texel: ImVec2Like,
    texels_to_pixels: Transform2D,
    color: ImU32
    ) -> None:
    """ DrawAnnotationLine
     * Convenience function to add a line to draw list using texel coordinates.

    """
    pass

#-------------------------------------------------------------------------
# [SECTION] Annotation Classes
#-------------------------------------------------------------------------


class ValueText:
    """ ValueText
     * An annoation class that draws text inside each texel when zoom level is high enough for it to fit.
     * The text shows the value of the texel. E.g. "R:255, G: 128, B:0, A:255"

    """
    class Format(enum.IntEnum):
        hex_string = enum.auto() # (= 0)  # E.g.  #EF97B9FF
        bytes_hex = enum.auto()  # (= 1)  # E.g.  R:#EF G:#97 B:#B9 A:#FF  (split over 4 lines)
        bytes_dec = enum.auto()  # (= 2)  # E.g.  R:239 G: 151 B:185 A:255  (split over 4 lines)
        floats = enum.auto()     # (= 3)  # E.g.  0.937 0.592 0.725 1.000 (split over 4 lines)
    def __init__(self, format: ValueText.Format = ValueText.HexString) -> None:
        pass
    def draw_annotation(
        self,
        draw_list: ImDrawList,
        texel: ImVec2Like,
        texels_to_pixels: Transform2D,
        value: ImVec4Like
        ) -> None:
        pass

class Arrow:
    """ Arrow
     * An annotation class that draws an arrow inside each texel when zoom level is
     * high enough. The direction and length of the arrow are determined by texel
     * values.
     * The X and Y components of the arrow is determined by the VectorIndex_x, and
     * VectorIndex_y channels of the texel value.  Examples:

     * VectorIndex_x = 0,  VectorIndex_y = 1  means  X component is red and Y component is green
     * VectorIndex_x = 1,  VectorIndex_y = 2  means  X component is green and Y component is blue
     * VectorIndex_x = 0,  VectorIndex_y = 3  means  X component is red and Y component is alpha
     *
     * ZeroPoint is the texel value which corresponds to a zero length vector. E.g.
     * ZeroPoint = (0.5, 0.5) means (0.5, 0.5) will be drawn as a zero length arrow
     *
     * All public properties can be directly manipulated.  There are also presets that can be set
     * by calling UsePreset.


    """
    vector_index_x: int
    vector_index_y: int
    line_scale: ImVec2
    zero_point: ImVec2 = ImVec2(0, 0)

    class Preset(enum.IntEnum):
        normal_map = enum.auto()       # (= 0)  # For normal maps. I.e. Arrow is in (R,G) channels.  128, 128 is zero point
        normalized_float = enum.auto() # (= 1)  # Arrow in (R,G) channels. 0,0 is zero point, (1,0) will draw an arrow exactly to
        # right edge of texture. (0,-1) will draw exactly to the bottom etc.
    def __init__(
        self,
        x_vector_index: int = 0,
        y_vector_index: int = 1,
        line_scale: Optional[ImVec2Like] = None
        ) -> None:
        """Python bindings defaults:
            If lineScale is None, then its default value will be: ImVec2(1, 1)
        """
        pass
    def use_preset(self, param_0: Arrow.Preset) -> Arrow:
        pass
    def draw_annotation(
        self,
        draw_list: ImDrawList,
        texel: ImVec2Like,
        texels_to_pixels: Transform2D,
        value: ImVec4Like
        ) -> None:
        pass

#-------------------------------------------------------------------------
# [SECTION] INTERNAL
#-------------------------------------------------------------------------

class Transform2D:
    scale: ImVec2
    translate: ImVec2

    def __mul__(self, rhs: ImVec2Like) -> ImVec2:
        """ Transform a vector by this transform.  Scale is applied first"""
        pass

    def inverse(self) -> Transform2D:
        """ Return an inverse transform such that transform.Inverse() * transform * vector == vector"""
        pass
    def __init__(
        self,
        scale: Optional[ImVec2Like] = None,
        translate: Optional[ImVec2Like] = None
        ) -> None:
        """Auto-generated default constructor with named params


        Python bindings defaults:
            If any of the params below is None, then its default value below will be used:
                * Scale: ImVec2()
                * Translate: ImVec2()
        """
        pass



#-------------------------------------------------------------------------
# [SECTION] FORWARD DECLARATIONS FOR TEMPLATE IMPLEMENTATION - Do not call directly
#-------------------------------------------------------------------------



####################    </generated_from:imgui_tex_inspect.h>    ####################


####################    <generated_from:imgui_tex_inspect_demo.h>    ####################
# ImGuiTexInspect, a texture inspector widget for dear imgui


class Texture:
    texture: ImTextureID
    size: ImVec2
    def __init__(
        self,
        texture: Optional[ImTextureID] = None,
        size: Optional[ImVec2Like] = None
        ) -> None:
        """Auto-generated default constructor with named params


        Python bindings defaults:
            If any of the params below is None, then its default value below will be used:
                * texture: ImTextureID()
                * size: ImVec2()
        """
        pass


def show_demo_window() -> None:
    pass

####################    </generated_from:imgui_tex_inspect_demo.h>    ####################

# </litgen_stub> // Autogenerated code end!
