"""ImPlot3D: Immediate Mode 3D Plotting for ImGui
Python bindings for https://github.com/brenocq/implot3d
"""

# ruff: noqa: B008, F821, F811
from typing import Any, Optional, List, overload
import numpy as np
import enum
from . import internal as internal

from imgui_bundle import imgui
from imgui_bundle.imgui import (
    ImVec2,
    ImVec2Like,
    ImVec4,
    ImVec4Like,
    ImU32,
    ImDrawList,
    ImTextureRef,
)

ImageFlags = int  # enum ImageFlags_

ImGui_Context = imgui.internal.Context

##################################################
#    Manually inserted code (typedefs, etc.)
##################################################
IMPLOT3D_AUTO = -1  # Deduce variable automatically
IMPLOT3D_AUTO_COL = ImVec4(0, 0, 0, -1)  # Deduce color automatically
AUTO = IMPLOT3D_AUTO
AUTO_COL = IMPLOT3D_AUTO_COL

VERSION: str

UInt = int
Context = Any
ImAxis3D = int  # enum ImAxis3D_

# // Flags
# typedef int ImPlot3DFlags;         // -> ImPlot3DFlags_         // Flags: for BeginPlot()
Flags = int  # enum Flags_ (ImPlot3DFlags)
#     typedef int ImPlot3DItemFlags;     // -> ImPlot3DItemFlags_     // Flags: Item flags
ItemFlags = int  # enum ItemFlags_
# typedef int ImPlot3DScatterFlags;  // -> ImPlot3DScatterFlags_  // Flags: Scatter plot flags
ScatterFlags = int  # enum ScatterFlags_
# typedef int ImPlot3DLineFlags;     // -> ImPlot3DLineFlags_     // Flags: Line plot flags
LineFlags = int  # enum LineFlags_
# typedef int ImPlot3DTriangleFlags; // -> ImPlot3DTriangleFlags_ // Flags: Triangle plot flags
TriangleFlags = int  # enum TriangleFlags_
# typedef int ImPlot3DQuadFlags;     // -> ImPlot3DQuadFlags_     // Flags: QuadFplot flags
QuadFlags = int  # enum QuadFlags_
# typedef int ImPlot3DSurfaceFlags;  // -> ImPlot3DSurfaceFlags_  // Flags: Surface plot flags
SurfaceFlags = int  # enum SurfaceFlags_
# typedef int ImPlot3DMeshFlags;     // -> ImPlot3DMeshFlags_     // Flags: Mesh plot flags
MeshFlags = int  # enum MeshFlags_
# typedef int ImPlot3DLegendFlags;   // -> ImPlot3DLegendFlags_   // Flags: Legend flags
LegendFlags = int  # enum LegendFlags_
# typedef int ImPlot3DAxisFlags;     // -> ImPlot3DAxisFlags_     // Flags: Axis flags

AxisFlags = int  # enum AxisFlags_

# typedef int ImPlot3DColormap; // -> ImPlot3DColormap_          // Enum: Colormaps
Colormap = int  # enum Colormap_

# // Enums
# typedef int ImPlot3DCond;     // -> ImPlot3DCond_              // Enum: Condition for flags
Cond = int  # enum Cond_
# typedef int ImPlot3DCol;      // -> ImPlot3DCol_               // Enum: Styling colors
Col = int  # enum Col_
# typedef int ImPlot3DStyleVar; // -> ImPlot3DStyleVar_          // Enum: Style variables
StyleVar = int  # enum StyleVar_
# typedef int ImPlot3DMarker;   // -> ImPlot3DMarker_            // Enum: Marker styles
Marker = int  # enum Marker_
# typedef int ImPlot3DLocation; // -> ImPlot3DLocation_          // Enum: Locations
Location = int  # enum Location_
# typedef int ImAxis3D;         // -> ImAxis3D_                  // Enum: Axis indices
# typedef int ImPlane3D;        // -> ImPlane3D_                  // Enum: Plane indices
ImPlane3D = int  # enum ImPlane3D_
# typedef int ImPlot3DColormap; // -> ImPlot3DColormap_          // Enum: Colormaps
#

"""
"""

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# <litgen_stub> // Autogenerated code below! Do not edit!
####################    <generated_from:implot3d.h>    ####################
# --------------------------------------------------
# ImPlot3D v0.3 WIP
# implot3.h
# Date: 2024-11-16
# Author: Breno Cunha Queiroz (brenocq.com)
#
# Acknowledgments:
#  ImPlot3D is heavily inspired by ImPlot
#  (https://github.com/epezent/implot) by Evan Pezent,
#  and follows a similar code style and structure to
#  maintain consistency with ImPlot's API.
# --------------------------------------------------

# Table of Contents:
# [SECTION] Macros and Defines
# [SECTION] Forward declarations and basic types
# [SECTION] Flags & Enumerations
# [SECTION] Callbacks
# [SECTION] Context
# [SECTION] Begin/End Plot
# [SECTION] Setup
# [SECTION] Plot Items
# [SECTION] Plot Utils
# [SECTION] Miscellaneous
# [SECTION] Styles
# [SECTION] Demo
# [SECTION] Debugging
# [SECTION] ImPlot3DPoint
# [SECTION] ImPlot3DRay
# [SECTION] ImPlot3DPlane
# [SECTION] ImPlot3DBox
# [SECTION] ImPlot3DQuat
# [SECTION] ImPlot3DStyle
# [SECTION] Meshes

# #ifndef IMGUI_DISABLE
#

# [ADAPT_IMGUI_BUNDLE]
# #ifdef IMGUI_BUNDLE_PYTHON_API
#
# #endif
#
# [/ADAPT_IMGUI_BUNDLE]

# -----------------------------------------------------------------------------
# [SECTION] Macros and Defines
# -----------------------------------------------------------------------------

# -----------------------------------------------------------------------------
# [SECTION] Forward declarations and basic types
# -----------------------------------------------------------------------------

# Forward declarations

# Enums

# Flags

# Fallback for ImGui versions before v1.92: define ImTextureRef as ImTextureID
# You can `#define IMPLOT3D_NO_IMTEXTUREREF` to avoid this fallback

# -----------------------------------------------------------------------------
# [SECTION] Flags & Enumerations
# -----------------------------------------------------------------------------

class Flags_(enum.IntFlag):
    """Flags for ImPlot3D::BeginPlot()"""

    # ImPlot3DFlags_None = 0,                 /* original C++ signature */
    none = enum.auto()  # (= 0)  # Default
    # ImPlot3DFlags_NoTitle = 1 << 0,         /* original C++ signature */
    no_title = enum.auto()  # (= 1 << 0)  # Hide plot title
    # ImPlot3DFlags_NoLegend = 1 << 1,        /* original C++ signature */
    no_legend = enum.auto()  # (= 1 << 1)  # Hide plot legend
    # ImPlot3DFlags_NoMouseText = 1 << 2,     /* original C++ signature */
    no_mouse_text = enum.auto()  # (= 1 << 2)  # Hide mouse position in plot coordinates
    # ImPlot3DFlags_NoClip = 1 << 3,          /* original C++ signature */
    no_clip = enum.auto()  # (= 1 << 3)  # Disable 3D box clipping
    # ImPlot3DFlags_NoMenus = 1 << 4,         /* original C++ signature */
    no_menus = enum.auto()  # (= 1 << 4)  # The user will not be able to open context menus
    # ImPlot3DFlags_CanvasOnly = ImPlot3DFlags_NoTitle | ImPlot3DFlags_NoLegend | ImPlot3DFlags_NoMouseText,    /* original C++ signature */
    # }
    canvas_only = enum.auto()  # (= Flags_NoTitle | Flags_NoLegend | Flags_NoMouseText)

class Cond_(enum.IntFlag):
    """Represents a condition for SetupAxisLimits etc. (same as ImGuiCond, but we only support a subset of those enums)"""

    # ImPlot3DCond_None = ImGuiCond_None,         /* original C++ signature */
    none = enum.auto()  # (= Cond_None)  # No condition (always set the variable), same as _Always
    # ImPlot3DCond_Always = ImGuiCond_Always,     /* original C++ signature */
    always = enum.auto()  # (= Cond_Always)  # No condition (always set the variable)
    # ImPlot3DCond_Once = ImGuiCond_Once,         /* original C++ signature */
    once = enum.auto()  # (= Cond_Once)  # Set the variable once per runtime session (only the first call will succeed)

class Col_(enum.IntFlag):
    # Item colors
    # ImPlot3DCol_Line = 0,          /* original C++ signature */
    line = enum.auto()  # (= 0)  # Line color
    # ImPlot3DCol_Fill,              /* original C++ signature */
    fill = enum.auto()  # (= 1)  # Fill color
    # ImPlot3DCol_MarkerOutline,     /* original C++ signature */
    marker_outline = enum.auto()  # (= 2)  # Marker outline color
    # ImPlot3DCol_MarkerFill,        /* original C++ signature */
    marker_fill = enum.auto()  # (= 3)  # Marker fill color
    # Plot colors
    # ImPlot3DCol_TitleText,      /* original C++ signature */
    title_text = enum.auto()  # (= 4)  # Title color
    # ImPlot3DCol_InlayText,      /* original C++ signature */
    inlay_text = enum.auto()  # (= 5)  # Color for texts appearing inside of plots
    # ImPlot3DCol_FrameBg,        /* original C++ signature */
    frame_bg = enum.auto()  # (= 6)  # Frame background color
    # ImPlot3DCol_PlotBg,         /* original C++ signature */
    plot_bg = enum.auto()  # (= 7)  # Plot area background color
    # ImPlot3DCol_PlotBorder,     /* original C++ signature */
    plot_border = enum.auto()  # (= 8)  # Plot area border color
    # Legend colors
    # ImPlot3DCol_LegendBg,         /* original C++ signature */
    legend_bg = enum.auto()  # (= 9)  # Legend background color
    # ImPlot3DCol_LegendBorder,     /* original C++ signature */
    legend_border = enum.auto()  # (= 10)  # Legend border color
    # ImPlot3DCol_LegendText,       /* original C++ signature */
    legend_text = enum.auto()  # (= 11)  # Legend text color
    # Axis colors
    # ImPlot3DCol_AxisText,     /* original C++ signature */
    axis_text = enum.auto()  # (= 12)  # Axis label and tick lables color
    # ImPlot3DCol_AxisGrid,     /* original C++ signature */
    axis_grid = enum.auto()  # (= 13)  # Axis grid color
    # ImPlot3DCol_AxisTick,     /* original C++ signature */
    axis_tick = enum.auto()  # (= 14)  # Axis tick color (defaults to AxisGrid)
    # ImPlot3DCol_COUNT,    /* original C++ signature */
    # }
    count = enum.auto()  # (= 15)

class StyleVar_(enum.IntFlag):
    """Plot styling variables"""

    # Item style
    # ImPlot3DStyleVar_LineWeight,       /* original C++ signature */
    line_weight = enum.auto()  # (= 0)  # float, plot item line weight in pixels
    # ImPlot3DStyleVar_Marker,           /* original C++ signature */
    marker = enum.auto()  # (= 1)  # int,   marker specification
    # ImPlot3DStyleVar_MarkerSize,       /* original C++ signature */
    marker_size = enum.auto()  # (= 2)  # float, marker size in pixels (roughly the marker's "radius")
    # ImPlot3DStyleVar_MarkerWeight,     /* original C++ signature */
    marker_weight = enum.auto()  # (= 3)  # float, plot outline weight of markers in pixels
    # ImPlot3DStyleVar_FillAlpha,        /* original C++ signature */
    fill_alpha = enum.auto()  # (= 4)  # float, alpha modifier applied to all plot item fills
    # Plot style
    # ImPlot3DStyleVar_PlotDefaultSize,     /* original C++ signature */
    plot_default_size = enum.auto()  # (= 5)  # ImVec2, default size used when ImVec2(0,0) is passed to BeginPlot
    # ImPlot3DStyleVar_PlotMinSize,         /* original C++ signature */
    plot_min_size = enum.auto()  # (= 6)  # ImVec2, minimum size plot frame can be when shrunk
    # ImPlot3DStyleVar_PlotPadding,         /* original C++ signature */
    plot_padding = (
        enum.auto()
    )  # (= 7)  # ImVec2, padding between widget frame and plot area, labels, or outside legends (i.e. main padding)
    # ImPlot3DStyleVar_LabelPadding,        /* original C++ signature */
    label_padding = enum.auto()  # (= 8)  # ImVec2, padding between axes labels, tick labels, and plot edge
    # Legend style
    # ImPlot3DStyleVar_LegendPadding,          /* original C++ signature */
    legend_padding = enum.auto()  # (= 9)  # ImVec2, legend padding from plot edges
    # ImPlot3DStyleVar_LegendInnerPadding,     /* original C++ signature */
    legend_inner_padding = enum.auto()  # (= 10)  # ImVec2, legend inner padding from legend edges
    # ImPlot3DStyleVar_LegendSpacing,          /* original C++ signature */
    legend_spacing = enum.auto()  # (= 11)  # ImVec2, spacing between legend entries
    # ImPlot3DStyleVar_COUNT    /* original C++ signature */
    # }
    count = enum.auto()  # (= 12)

class Marker_(enum.IntFlag):
    # ImPlot3DMarker_None = -1,     /* original C++ signature */
    none = enum.auto()  # (= -1)  # No marker
    # ImPlot3DMarker_Circle,        /* original C++ signature */
    circle = enum.auto()  # (= 0)  # Circle marker (default)
    # ImPlot3DMarker_Square,        /* original C++ signature */
    square = enum.auto()  # (= 1)  # Square maker
    # ImPlot3DMarker_Diamond,       /* original C++ signature */
    diamond = enum.auto()  # (= 2)  # Diamond marker
    # ImPlot3DMarker_Up,            /* original C++ signature */
    up = enum.auto()  # (= 3)  # Upward-pointing triangle marker
    # ImPlot3DMarker_Down,          /* original C++ signature */
    down = enum.auto()  # (= 4)  # Downward-pointing triangle marker
    # ImPlot3DMarker_Left,          /* original C++ signature */
    left = enum.auto()  # (= 5)  # Leftward-pointing triangle marker
    # ImPlot3DMarker_Right,         /* original C++ signature */
    right = enum.auto()  # (= 6)  # Rightward-pointing triangle marker
    # ImPlot3DMarker_Cross,         /* original C++ signature */
    cross = enum.auto()  # (= 7)  # Cross marker (not fillable)
    # ImPlot3DMarker_Plus,          /* original C++ signature */
    plus = enum.auto()  # (= 8)  # Plus marker (not fillable)
    # ImPlot3DMarker_Asterisk,      /* original C++ signature */
    asterisk = enum.auto()  # (= 9)  # Asterisk marker (not fillable)
    # ImPlot3DMarker_COUNT    /* original C++ signature */
    # }
    count = enum.auto()  # (= 10)

class ItemFlags_(enum.IntFlag):
    """Flags for items"""

    # ImPlot3DItemFlags_None = 0,              /* original C++ signature */
    none = enum.auto()  # (= 0)  # Default
    # ImPlot3DItemFlags_NoLegend = 1 << 0,     /* original C++ signature */
    no_legend = enum.auto()  # (= 1 << 0)  # The item won't have a legend entry displayed
    # ImPlot3DItemFlags_NoFit = 1 << 1,        /* original C++ signature */
    no_fit = enum.auto()  # (= 1 << 1)  # The item won't be considered for plot fits

class ScatterFlags_(enum.IntFlag):
    """Flags for PlotScatter"""

    # ImPlot3DScatterFlags_None = 0,     /* original C++ signature */
    none = enum.auto()  # (= 0)  # Default
    # ImPlot3DScatterFlags_NoLegend = ImPlot3DItemFlags_NoLegend,    /* original C++ signature */
    no_legend = enum.auto()  # (= ItemFlags_NoLegend)
    # ImPlot3DScatterFlags_NoFit = ImPlot3DItemFlags_NoFit,    /* original C++ signature */
    # }
    no_fit = enum.auto()  # (= ItemFlags_NoFit)

class LineFlags_(enum.IntFlag):
    """Flags for PlotLine"""

    # ImPlot3DLineFlags_None = 0,     /* original C++ signature */
    none = enum.auto()  # (= 0)  # Default
    # ImPlot3DLineFlags_NoLegend = ImPlot3DItemFlags_NoLegend,    /* original C++ signature */
    no_legend = enum.auto()  # (= ItemFlags_NoLegend)
    # ImPlot3DLineFlags_NoFit = ImPlot3DItemFlags_NoFit,    /* original C++ signature */
    no_fit = enum.auto()  # (= ItemFlags_NoFit)
    # ImPlot3DLineFlags_Segments = 1 << 10,     /* original C++ signature */
    segments = enum.auto()  # (= 1 << 10)  # A line segment will be rendered from every two consecutive points
    # ImPlot3DLineFlags_Loop = 1 << 11,         /* original C++ signature */
    loop = enum.auto()  # (= 1 << 11)  # The last and first point will be connected to form a closed loop
    # ImPlot3DLineFlags_SkipNaN = 1 << 12,      /* original C++ signature */
    skip_nan = enum.auto()  # (= 1 << 12)  # NaNs values will be skipped instead of rendered as missing data

class TriangleFlags_(enum.IntFlag):
    """Flags for PlotTriangle"""

    # ImPlot3DTriangleFlags_None = 0,     /* original C++ signature */
    none = enum.auto()  # (= 0)  # Default
    # ImPlot3DTriangleFlags_NoLegend = ImPlot3DItemFlags_NoLegend,    /* original C++ signature */
    no_legend = enum.auto()  # (= ItemFlags_NoLegend)
    # ImPlot3DTriangleFlags_NoFit = ImPlot3DItemFlags_NoFit,    /* original C++ signature */
    no_fit = enum.auto()  # (= ItemFlags_NoFit)
    # ImPlot3DTriangleFlags_NoLines = 1 << 10,       /* original C++ signature */
    no_lines = enum.auto()  # (= 1 << 10)  # No lines will be rendered
    # ImPlot3DTriangleFlags_NoFill = 1 << 11,        /* original C++ signature */
    no_fill = enum.auto()  # (= 1 << 11)  # No fill will be rendered
    # ImPlot3DTriangleFlags_NoMarkers = 1 << 12,     /* original C++ signature */
    no_markers = enum.auto()  # (= 1 << 12)  # No markers will be rendered

class QuadFlags_(enum.IntFlag):
    """Flags for PlotQuad"""

    # ImPlot3DQuadFlags_None = 0,     /* original C++ signature */
    none = enum.auto()  # (= 0)  # Default
    # ImPlot3DQuadFlags_NoLegend = ImPlot3DItemFlags_NoLegend,    /* original C++ signature */
    no_legend = enum.auto()  # (= ItemFlags_NoLegend)
    # ImPlot3DQuadFlags_NoFit = ImPlot3DItemFlags_NoFit,    /* original C++ signature */
    no_fit = enum.auto()  # (= ItemFlags_NoFit)
    # ImPlot3DQuadFlags_NoLines = 1 << 10,       /* original C++ signature */
    no_lines = enum.auto()  # (= 1 << 10)  # No lines will be rendered
    # ImPlot3DQuadFlags_NoFill = 1 << 11,        /* original C++ signature */
    no_fill = enum.auto()  # (= 1 << 11)  # No fill will be rendered
    # ImPlot3DQuadFlags_NoMarkers = 1 << 12,     /* original C++ signature */
    no_markers = enum.auto()  # (= 1 << 12)  # No markers will be rendered

class SurfaceFlags_(enum.IntFlag):
    """Flags for PlotSurface"""

    # ImPlot3DSurfaceFlags_None = 0,     /* original C++ signature */
    none = enum.auto()  # (= 0)  # Default
    # ImPlot3DSurfaceFlags_NoLegend = ImPlot3DItemFlags_NoLegend,    /* original C++ signature */
    no_legend = enum.auto()  # (= ItemFlags_NoLegend)
    # ImPlot3DSurfaceFlags_NoFit = ImPlot3DItemFlags_NoFit,    /* original C++ signature */
    no_fit = enum.auto()  # (= ItemFlags_NoFit)
    # ImPlot3DSurfaceFlags_NoLines = 1 << 10,       /* original C++ signature */
    no_lines = enum.auto()  # (= 1 << 10)  # No lines will be rendered
    # ImPlot3DSurfaceFlags_NoFill = 1 << 11,        /* original C++ signature */
    no_fill = enum.auto()  # (= 1 << 11)  # No fill will be rendered
    # ImPlot3DSurfaceFlags_NoMarkers = 1 << 12,     /* original C++ signature */
    no_markers = enum.auto()  # (= 1 << 12)  # No markers will be rendered

class MeshFlags_(enum.IntFlag):
    """Flags for PlotMesh"""

    # ImPlot3DMeshFlags_None = 0,     /* original C++ signature */
    none = enum.auto()  # (= 0)  # Default
    # ImPlot3DMeshFlags_NoLegend = ImPlot3DItemFlags_NoLegend,    /* original C++ signature */
    no_legend = enum.auto()  # (= ItemFlags_NoLegend)
    # ImPlot3DMeshFlags_NoFit = ImPlot3DItemFlags_NoFit,    /* original C++ signature */
    no_fit = enum.auto()  # (= ItemFlags_NoFit)
    # ImPlot3DMeshFlags_NoLines = 1 << 10,       /* original C++ signature */
    no_lines = enum.auto()  # (= 1 << 10)  # No lines will be rendered
    # ImPlot3DMeshFlags_NoFill = 1 << 11,        /* original C++ signature */
    no_fill = enum.auto()  # (= 1 << 11)  # No fill will be rendered
    # ImPlot3DMeshFlags_NoMarkers = 1 << 12,     /* original C++ signature */
    no_markers = enum.auto()  # (= 1 << 12)  # No markers will be rendered

class ImageFlags_(enum.IntFlag):
    """Flags for PlotImage"""

    # ImPlot3DImageFlags_None = 0,     /* original C++ signature */
    none = enum.auto()  # (= 0)  # Default
    # ImPlot3DImageFlags_NoLegend = ImPlot3DItemFlags_NoLegend,    /* original C++ signature */
    no_legend = enum.auto()  # (= ItemFlags_NoLegend)
    # ImPlot3DImageFlags_NoFit = ImPlot3DItemFlags_NoFit,    /* original C++ signature */
    # }
    no_fit = enum.auto()  # (= ItemFlags_NoFit)

class LegendFlags_(enum.IntFlag):
    """Flags for legends"""

    # ImPlot3DLegendFlags_None = 0,                     /* original C++ signature */
    none = enum.auto()  # (= 0)  # Default
    # ImPlot3DLegendFlags_NoButtons = 1 << 0,           /* original C++ signature */
    no_buttons = enum.auto()  # (= 1 << 0)  # Legend icons will not function as hide/show buttons
    # ImPlot3DLegendFlags_NoHighlightItem = 1 << 1,     /* original C++ signature */
    no_highlight_item = (
        enum.auto()
    )  # (= 1 << 1)  # Plot items will not be highlighted when their legend entry is hovered
    # ImPlot3DLegendFlags_Horizontal = 1 << 2,          /* original C++ signature */
    horizontal = enum.auto()  # (= 1 << 2)  # Legend entries will be displayed horizontally

class Location_(enum.IntFlag):
    """Used to position legend on a plot"""

    # ImPlot3DLocation_Center = 0,                                                     /* original C++ signature */
    center = enum.auto()  # (= 0)  # Center-center
    # ImPlot3DLocation_North = 1 << 0,                                                 /* original C++ signature */
    north = enum.auto()  # (= 1 << 0)  # Top-center
    # ImPlot3DLocation_South = 1 << 1,                                                 /* original C++ signature */
    south = enum.auto()  # (= 1 << 1)  # Bottom-center
    # ImPlot3DLocation_West = 1 << 2,                                                  /* original C++ signature */
    west = enum.auto()  # (= 1 << 2)  # Center-left
    # ImPlot3DLocation_East = 1 << 3,                                                  /* original C++ signature */
    east = enum.auto()  # (= 1 << 3)  # Center-right
    # ImPlot3DLocation_NorthWest = ImPlot3DLocation_North | ImPlot3DLocation_West,     /* original C++ signature */
    north_west = enum.auto()  # (= Location_North | Location_West)  # Top-left
    # ImPlot3DLocation_NorthEast = ImPlot3DLocation_North | ImPlot3DLocation_East,     /* original C++ signature */
    north_east = enum.auto()  # (= Location_North | Location_East)  # Top-right
    # ImPlot3DLocation_SouthWest = ImPlot3DLocation_South | ImPlot3DLocation_West,     /* original C++ signature */
    south_west = enum.auto()  # (= Location_South | Location_West)  # Bottom-left
    # ImPlot3DLocation_SouthEast = ImPlot3DLocation_South | ImPlot3DLocation_East      /* original C++ signature */
    south_east = enum.auto()  # (= Location_South | Location_East)  # Bottom-right

class AxisFlags_(enum.IntFlag):
    """Flags for axis"""

    # ImPlot3DAxisFlags_None = 0,                  /* original C++ signature */
    none = enum.auto()  # (= 0)  # Default
    # ImPlot3DAxisFlags_NoLabel = 1 << 0,          /* original C++ signature */
    no_label = enum.auto()  # (= 1 << 0)  # No axis label will be displayed
    # ImPlot3DAxisFlags_NoGridLines = 1 << 1,      /* original C++ signature */
    no_grid_lines = enum.auto()  # (= 1 << 1)  # No grid lines will be displayed
    # ImPlot3DAxisFlags_NoTickMarks = 1 << 2,      /* original C++ signature */
    no_tick_marks = enum.auto()  # (= 1 << 2)  # No tick marks will be displayed
    # ImPlot3DAxisFlags_NoTickLabels = 1 << 3,     /* original C++ signature */
    no_tick_labels = enum.auto()  # (= 1 << 3)  # No tick labels will be displayed
    # ImPlot3DAxisFlags_LockMin = 1 << 4,          /* original C++ signature */
    lock_min = enum.auto()  # (= 1 << 4)  # The axis minimum value will be locked when panning/zooming
    # ImPlot3DAxisFlags_LockMax = 1 << 5,          /* original C++ signature */
    lock_max = enum.auto()  # (= 1 << 5)  # The axis maximum value will be locked when panning/zooming
    # ImPlot3DAxisFlags_AutoFit = 1 << 6,          /* original C++ signature */
    auto_fit = enum.auto()  # (= 1 << 6)  # Axis will be auto-fitting to data extents
    # ImPlot3DAxisFlags_Invert = 1 << 7,           /* original C++ signature */
    invert = enum.auto()  # (= 1 << 7)  # The axis will be inverted
    # ImPlot3DAxisFlags_PanStretch = 1 << 8,       /* original C++ signature */
    pan_stretch = (
        enum.auto()
    )  # (= 1 << 8)  # Panning in a locked or constrained state will cause the axis to stretch if possible
    # ImPlot3DAxisFlags_Lock = ImPlot3DAxisFlags_LockMin | ImPlot3DAxisFlags_LockMax,    /* original C++ signature */
    lock = enum.auto()  # (= AxisFlags_LockMin | AxisFlags_LockMax)
    # ImPlot3DAxisFlags_NoDecorations = ImPlot3DAxisFlags_NoLabel | ImPlot3DAxisFlags_NoGridLines | ImPlot3DAxisFlags_NoTickLabels,    /* original C++ signature */
    # }
    no_decorations = enum.auto()  # (= AxisFlags_NoLabel | AxisFlags_NoGridLines | AxisFlags_NoTickLabels)

class ImAxis3D_(enum.IntFlag):
    """Axis indices"""

    # ImAxis3D_X = 0,    /* original C++ signature */
    x = enum.auto()  # (= 0)
    # ImAxis3D_Y,    /* original C++ signature */
    y = enum.auto()  # (= 1)
    # ImAxis3D_Z,    /* original C++ signature */
    z = enum.auto()  # (= 2)
    # ImAxis3D_COUNT,    /* original C++ signature */
    # }
    count = enum.auto()  # (= 3)

class ImPlane3D_(enum.IntFlag):
    """Plane indices"""

    # ImPlane3D_YZ = 0,    /* original C++ signature */
    yz = enum.auto()  # (= 0)
    # ImPlane3D_XZ,    /* original C++ signature */
    xz = enum.auto()  # (= 1)
    # ImPlane3D_XY,    /* original C++ signature */
    xy = enum.auto()  # (= 2)
    # ImPlane3D_COUNT,    /* original C++ signature */
    # }
    count = enum.auto()  # (= 3)

class Colormap_(enum.IntFlag):
    """Colormaps"""

    # ImPlot3DColormap_Deep = 0,          /* original C++ signature */
    deep = enum.auto()  # (= 0)  # Same as seaborn "deep"
    # ImPlot3DColormap_Dark = 1,          /* original C++ signature */
    dark = enum.auto()  # (= 1)  # Same as matplotlib "Set1"
    # ImPlot3DColormap_Pastel = 2,        /* original C++ signature */
    pastel = enum.auto()  # (= 2)  # Same as matplotlib "Pastel1"
    # ImPlot3DColormap_Paired = 3,        /* original C++ signature */
    paired = enum.auto()  # (= 3)  # Same as matplotlib "Paired"
    # ImPlot3DColormap_Viridis = 4,       /* original C++ signature */
    viridis = enum.auto()  # (= 4)  # Same as matplotlib "viridis"
    # ImPlot3DColormap_Plasma = 5,        /* original C++ signature */
    plasma = enum.auto()  # (= 5)  # Same as matplotlib "plasma"
    # ImPlot3DColormap_Hot = 6,           /* original C++ signature */
    hot = enum.auto()  # (= 6)  # Same as matplotlib/MATLAB "hot"
    # ImPlot3DColormap_Cool = 7,          /* original C++ signature */
    cool = enum.auto()  # (= 7)  # Same as matplotlib/MATLAB "cool"
    # ImPlot3DColormap_Pink = 8,          /* original C++ signature */
    pink = enum.auto()  # (= 8)  # Same as matplotlib/MATLAB "pink"
    # ImPlot3DColormap_Jet = 9,           /* original C++ signature */
    jet = enum.auto()  # (= 9)  # Same as matplotlib/MATLAB "jet"
    # ImPlot3DColormap_Twilight = 10,     /* original C++ signature */
    twilight = enum.auto()  # (= 10)  # Same as matplotlib "twilight"
    # ImPlot3DColormap_RdBu = 11,         /* original C++ signature */
    rd_bu = enum.auto()  # (= 11)  # Same as matplotlib "RdBu"
    # ImPlot3DColormap_BrBG = 12,         /* original C++ signature */
    br_bg = enum.auto()  # (= 12)  # Same as matplotlib "BrGB"
    # ImPlot3DColormap_PiYG = 13,         /* original C++ signature */
    pi_yg = enum.auto()  # (= 13)  # Same as matplotlib "PiYG"
    # ImPlot3DColormap_Spectral = 14,     /* original C++ signature */
    spectral = enum.auto()  # (= 14)  # Same as matplotlib "Spectral"
    # ImPlot3DColormap_Greys = 15,        /* original C++ signature */
    greys = enum.auto()  # (= 15)  # White/black

# -----------------------------------------------------------------------------
# [SECTION] Callbacks
# -----------------------------------------------------------------------------

# -----------------------------------------------------------------------------
# [SECTION] Context
# -----------------------------------------------------------------------------
# IMPLOT3D_API ImPlot3DContext* CreateContext();    /* original C++ signature */
def create_context() -> Context:
    pass

# IMPLOT3D_API void DestroyContext(ImPlot3DContext* ctx = nullptr);    /* original C++ signature */
def destroy_context(ctx: Optional[Context] = None) -> None:
    pass

# IMPLOT3D_API ImPlot3DContext* GetCurrentContext();    /* original C++ signature */
def get_current_context() -> Context:
    pass

# IMPLOT3D_API void SetCurrentContext(ImPlot3DContext* ctx);    /* original C++ signature */
def set_current_context(ctx: Context) -> None:
    pass

# -----------------------------------------------------------------------------
# [SECTION] Begin/End Plot
# -----------------------------------------------------------------------------

# Starts a 3D plotting context. If this function returns True, EndPlot() MUST
# be called! You are encouraged to use the following convention:
#
# if (ImPlot3D::BeginPlot(...)) {
#     ImPlot3D::PlotLine(...);
#     ...
#     ImPlot3D::EndPlot();
# }
#
# Important notes:
# - #title_id must be unique to the current ImGui ID scope. If you need to avoid ID
#   collisions or don't want to display a title in the plot, use double hashes
#   (e.g. "MyPlot##HiddenIdText" or "##NoTitle").
# - #size is the **frame** size of the plot widget, not the plot area.
# IMPLOT3D_API bool BeginPlot(const char* title_id, const ImVec2& size = ImVec2(-1, 0), ImPlot3DFlags flags = 0);    /* original C++ signature */
def begin_plot(title_id: str, size: Optional[ImVec2Like] = None, flags: Flags = 0) -> bool:
    """Python bindings defaults:
    If size is None, then its default value will be: ImVec2(-1, 0)
    """
    pass

# IMPLOT3D_API void EndPlot();     /* original C++ signature */
def end_plot() -> None:
    """Only call if BeginPlot() returns True!"""
    pass

# -----------------------------------------------------------------------------
# [SECTION] Setup
# -----------------------------------------------------------------------------

# The following API allows you to setup and customize various aspects of the
# current plot. The functions should be called immediately after BeginPlot()
# and before any other API calls. Typical usage is as follows:

# if (ImPlot3D::BeginPlot(...)) {                     1) Begin a new plot
#     ImPlot3D::SetupAxis(ImAxis3D_X, "My X-Axis");    2) Make Setup calls
#     ImPlot3D::SetupAxis(ImAxis3D_Y, "My Y-Axis");
#     ImPlot3D::SetupLegend(ImPlotLocation_North);
#     ...
#     ImPlot3D::SetupFinish();                        3) [Optional] Explicitly finish setup
#     ImPlot3D::PlotLine(...);                        4) Plot items
#     ...
#     ImPlot3D::EndPlot();                            5) End the plot
# }
#
# Important notes:
#
# - Always call Setup code at the top of your BeginPlot conditional statement.
# - Setup is locked once you start plotting or explicitly call SetupFinish.
#   Do NOT call Setup code after you begin plotting or after you make
#   any non-Setup API calls (e.g. utils like PlotToPixels also lock Setup).
# - Calling SetupFinish is OPTIONAL, but probably good practice. If you do not
#   call it yourself, then the first subsequent plotting or utility function will
#   call it for you.

# IMPLOT3D_API void SetupAxis(ImAxis3D axis, const char* label = nullptr, ImPlot3DAxisFlags flags = 0);    /* original C++ signature */
def setup_axis(axis: ImAxis3D, label: Optional[str] = None, flags: AxisFlags = 0) -> None:
    """Enables an axis or sets the label and/or flags for an existing axis. Leave #label = None for no label"""
    pass

# IMPLOT3D_API void SetupAxisLimits(ImAxis3D axis, double v_min, double v_max, ImPlot3DCond cond = ImPlot3DCond_Once);    /* original C++ signature */
def setup_axis_limits(axis: ImAxis3D, v_min: float, v_max: float, cond: Optional[Cond] = None) -> None:
    """Python bindings defaults:
    If cond is None, then its default value will be: Cond_Once
    """
    pass

# IMPLOT3D_API void SetupAxisLimitsConstraints(ImAxis3D axis, double v_min, double v_max);    /* original C++ signature */
def setup_axis_limits_constraints(axis: ImAxis3D, v_min: float, v_max: float) -> None:
    """Sets an axis' limits constraints"""
    pass

# IMPLOT3D_API void SetupAxisZoomConstraints(ImAxis3D axis, double z_min, double z_max);    /* original C++ signature */
def setup_axis_zoom_constraints(axis: ImAxis3D, z_min: float, z_max: float) -> None:
    """Sets an axis' zoom constraints"""
    pass

# IMPLOT3D_API void SetupAxes(const char* x_label, const char* y_label, const char* z_label, ImPlot3DAxisFlags x_flags = 0,    /* original C++ signature */
#                             ImPlot3DAxisFlags y_flags = 0, ImPlot3DAxisFlags z_flags = 0);
def setup_axes(
    x_label: str, y_label: str, z_label: str, x_flags: AxisFlags = 0, y_flags: AxisFlags = 0, z_flags: AxisFlags = 0
) -> None:
    """Sets the label and/or flags for primary X/Y/Z axes (shorthand for three calls to SetupAxis)"""
    pass

# IMPLOT3D_API void SetupAxesLimits(double x_min, double x_max, double y_min, double y_max, double z_min, double z_max,    /* original C++ signature */
#                                   ImPlot3DCond cond = ImPlot3DCond_Once);
def setup_axes_limits(
    x_min: float, x_max: float, y_min: float, y_max: float, z_min: float, z_max: float, cond: Optional[Cond] = None
) -> None:
    """Sets the X/Y/Z axes range limits. If ImPlot3DCond_Always is used, the axes limits will be locked (shorthand for two calls to SetupAxisLimits)


    Python bindings defaults:
        If cond is None, then its default value will be: Cond_Once
    """
    pass

# IMPLOT3D_API void SetupBoxRotation(float elevation, float azimuth, bool animate = false, ImPlot3DCond cond = ImPlot3DCond_Once);    /* original C++ signature */
@overload
def setup_box_rotation(elevation: float, azimuth: float, animate: bool = False, cond: Optional[Cond] = None) -> None:
    """Sets the plot box rotation given the elevation and azimuth angles in degrees. If ImPlot3DCond_Always is used, the rotation will be locked


    Python bindings defaults:
        If cond is None, then its default value will be: Cond_Once
    """
    pass

# IMPLOT3D_API void SetupBoxRotation(ImPlot3DQuat rotation, bool animate = false, ImPlot3DCond cond = ImPlot3DCond_Once);    /* original C++ signature */
@overload
def setup_box_rotation(rotation: Quat, animate: bool = False, cond: Optional[Cond] = None) -> None:
    """Sets the plot box rotation given a quaternion. If ImPlot3DCond_Always is used, the rotation will be locked


    Python bindings defaults:
        If cond is None, then its default value will be: Cond_Once
    """
    pass

# IMPLOT3D_API void SetupBoxInitialRotation(float elevation, float azimuth);    /* original C++ signature */
@overload
def setup_box_initial_rotation(elevation: float, azimuth: float) -> None:
    """Sets the plot box initial rotation given the elevation and azimuth angles in degrees. The initial rotation is the rotation the plot goes back to
    when a left mouse button double click happens
    """
    pass

# IMPLOT3D_API void SetupBoxInitialRotation(ImPlot3DQuat rotation);    /* original C++ signature */
@overload
def setup_box_initial_rotation(rotation: Quat) -> None:
    """Sets the plot box initial rotation given a quaternion. The initial rotation is the rotation the plot goes back to when a left mouse button double
    click happens
    """
    pass

# IMPLOT3D_API void SetupBoxScale(float x, float y, float z);    /* original C++ signature */
def setup_box_scale(x: float, y: float, z: float) -> None:
    """Sets the plot box X/Y/Z scale. A scale of 1.0 is the default. Values greater than 1.0 enlarge the plot, while values between 0.0 and 1.0 shrink it"""
    pass

# IMPLOT3D_API void SetupLegend(ImPlot3DLocation location, ImPlot3DLegendFlags flags = 0);    /* original C++ signature */
def setup_legend(location: Location, flags: LegendFlags = 0) -> None:
    pass

# -----------------------------------------------------------------------------
# [SECTION] Plot Items
# -----------------------------------------------------------------------------

# IMPLOT3D_TMP void PlotScatter(const char* label_id, const T* xs, const T* ys, const T* zs, int count, ImPlot3DScatterFlags flags = 0, int offset = 0,    /* original C++ signature */
#                               int stride = sizeof(T));
def plot_scatter(
    label_id: str,
    xs: np.ndarray,
    ys: np.ndarray,
    zs: np.ndarray,
    flags: ScatterFlags = 0,
    offset: int = 0,
    stride: int = -1,
) -> None:
    pass

# IMPLOT3D_TMP void PlotLine(const char* label_id, const T* xs, const T* ys, const T* zs, int count, ImPlot3DLineFlags flags = 0, int offset = 0,    /* original C++ signature */
#                            int stride = sizeof(T));
def plot_line(
    label_id: str,
    xs: np.ndarray,
    ys: np.ndarray,
    zs: np.ndarray,
    flags: LineFlags = 0,
    offset: int = 0,
    stride: int = -1,
) -> None:
    pass

# IMPLOT3D_TMP void PlotTriangle(const char* label_id, const T* xs, const T* ys, const T* zs, int count, ImPlot3DTriangleFlags flags = 0,    /* original C++ signature */
#                                int offset = 0, int stride = sizeof(T));
def plot_triangle(
    label_id: str,
    xs: np.ndarray,
    ys: np.ndarray,
    zs: np.ndarray,
    flags: TriangleFlags = 0,
    offset: int = 0,
    stride: int = -1,
) -> None:
    pass

# IMPLOT3D_TMP void PlotQuad(const char* label_id, const T* xs, const T* ys, const T* zs, int count, ImPlot3DQuadFlags flags = 0, int offset = 0,    /* original C++ signature */
#                            int stride = sizeof(T));
def plot_quad(
    label_id: str,
    xs: np.ndarray,
    ys: np.ndarray,
    zs: np.ndarray,
    flags: QuadFlags = 0,
    offset: int = 0,
    stride: int = -1,
) -> None:
    pass

# [ADAPT_IMGUI_BUNDLE]
# #ifdef IMGUI_BUNDLE_PYTHON_API
#
# A version of PlotSurface whose API is easier to port to Python
#    (params xs_count, ys_count and zs_count are removed in the Python API, but are used in the bindings code generation)

# IMPLOT3D_TMP void PlotSurface(    /* original C++ signature */
#     const char* label_id,
#     const T* xs, int xs_count,
#     const T* ys, int ys_count,
#     const T* zs, int zs_count,
#     int x_count, int y_count,
#     double scale_min = 0.0, double scale_max = 0.0,
#     ImPlot3DSurfaceFlags flags = 0,
#     int offset = 0,
#     int stride = sizeof(T));
def plot_surface(
    label_id: str,
    xs: np.ndarray,
    ys: np.ndarray,
    zs: np.ndarray,
    x_count: int,
    y_count: int,
    scale_min: float = 0.0,
    scale_max: float = 0.0,
    flags: SurfaceFlags = 0,
    offset: int = 0,
    stride: int = -1,
) -> None:
    """Plot the surface defined by a grid of vertices. The grid is defined by the x and y arrays,
    and the z array contains the height of each vertex.
    A total of x_count * y_count vertices are expected for each array.
    Leave #scale_min and #scale_max both at 0 for automatic color scaling, or set them to a predefined range.
    """
    pass

# #endif
#
# [/ADAPT_IMGUI_BUNDLE]

# [ADAPT_IMGUI_BUNDLE]
# #ifdef IMGUI_BUNDLE_PYTHON_API
#
class Mesh:
    # std::vector<ImPlot3DPoint> Points;    /* original C++ signature */
    points: List[Point]
    # std::vector<UInt> Idx;    /* original C++ signature */
    idx: List[UInt]
    # Mesh(std::vector<ImPlot3DPoint> Points = std::vector<ImPlot3DPoint>(), std::vector<UInt> Idx = std::vector<UInt>());    /* original C++ signature */
    def __init__(self, points: Optional[List[Point]] = None, idx: Optional[List[UInt]] = None) -> None:
        """Auto-generated default constructor with named params


        Python bindings defaults:
            If any of the params below is None, then its default value below will be used:
                * Points: List[Point]()
                * Idx: List[UInt]()
        """
        pass

# IMPLOT3D_API void PlotMesh(const char* label_id, const Mesh& mesh, ImPlot3DMeshFlags flags=0);    /* original C++ signature */
def plot_mesh(label_id: str, mesh: Mesh, flags: MeshFlags = 0) -> None:
    pass

# #endif
#
# [/ADAPT_IMGUI_BUNDLE]

# IMPLOT3D_API void PlotImage(const char* label_id, ImTextureRef tex_ref, const ImPlot3DPoint& center, const ImPlot3DPoint& axis_u,    /* original C++ signature */
#                             const ImPlot3DPoint& axis_v, const ImVec2& uv0 = ImVec2(0, 0), const ImVec2& uv1 = ImVec2(1, 1),
#                             const ImVec4& tint_col = ImVec4(1, 1, 1, 1), ImPlot3DImageFlags flags = 0);
@overload
def plot_image(
    label_id: str,
    tex_ref: ImTextureRef,
    center: Point,
    axis_u: Point,
    axis_v: Point,
    uv0: Optional[ImVec2Like] = None,
    uv1: Optional[ImVec2Like] = None,
    tint_col: Optional[ImVec4Like] = None,
    flags: ImageFlags = 0,
) -> None:
    """Plots a rectangular image in 3D defined by its center and two direction vectors (axes).
     #center is the center of the rectangle in plot coordinates.
     #axis_u and #axis_v define the local axes and half-extents of the rectangle in 3D space.
     The rectangle is formed by moving from the center along ±axis_u and ±axis_v.
     #uv0 and #uv1 define the texture mapping.
     #tint_col can be used to tint the image.


    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            * uv0: ImVec2(0, 0)
            * uv1: ImVec2(1, 1)
            * tint_col: ImVec4(1, 1, 1, 1)
    """
    pass

# IMPLOT3D_API void PlotImage(const char* label_id, ImTextureRef tex_ref, const ImPlot3DPoint& p0, const ImPlot3DPoint& p1, const ImPlot3DPoint& p2,    /* original C++ signature */
#                             const ImPlot3DPoint& p3, const ImVec2& uv0 = ImVec2(0, 0), const ImVec2& uv1 = ImVec2(1, 0),
#                             const ImVec2& uv2 = ImVec2(1, 1), const ImVec2& uv3 = ImVec2(0, 1), const ImVec4& tint_col = ImVec4(1, 1, 1, 1),
#                             ImPlot3DImageFlags flags = 0);
@overload
def plot_image(
    label_id: str,
    tex_ref: ImTextureRef,
    p0: Point,
    p1: Point,
    p2: Point,
    p3: Point,
    uv0: Optional[ImVec2Like] = None,
    uv1: Optional[ImVec2Like] = None,
    uv2: Optional[ImVec2Like] = None,
    uv3: Optional[ImVec2Like] = None,
    tint_col: Optional[ImVec4Like] = None,
    flags: ImageFlags = 0,
) -> None:
    """Plots an image using four arbitrary 3D points that define a quad in space.
     Each corner (p0 to p3) corresponds to a corner in the image, and #uv0 to #uv3 are the texture coordinates for each.
     This overload allows full control over orientation, shape, and distortion.
     Note: The quad is internally split into two triangles, so non-rectangular quads may produce rendering artifacts
     since distortion is interpolated per triangle rather than over the full quad.


    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            * uv0: ImVec2(0, 0)
            * uv1: ImVec2(1, 0)
            * uv2: ImVec2(1, 1)
            * uv3: ImVec2(0, 1)
            * tint_col: ImVec4(1, 1, 1, 1)
    """
    pass

# IMPLOT3D_API void PlotText(const char* text, float x, float y, float z, float angle = 0.0f, const ImVec2& pix_offset = ImVec2(0, 0));    /* original C++ signature */
def plot_text(
    text: str, x: float, y: float, z: float, angle: float = 0.0, pix_offset: Optional[ImVec2Like] = None
) -> None:
    """Plots a centered text label at point x,y,z. It is possible to set the text angle in radians and offset in pixels


    Python bindings defaults:
        If pix_offset is None, then its default value will be: ImVec2(0, 0)
    """
    pass

# -----------------------------------------------------------------------------
# [SECTION] Plot Utils
# -----------------------------------------------------------------------------

# Convert a position in the current plot's coordinate system to pixels
# IMPLOT3D_API ImVec2 PlotToPixels(const ImPlot3DPoint& point);    /* original C++ signature */
@overload
def plot_to_pixels(point: Point) -> ImVec2:
    pass

# IMPLOT3D_API ImVec2 PlotToPixels(double x, double y, double z);    /* original C++ signature */
@overload
def plot_to_pixels(x: float, y: float, z: float) -> ImVec2:
    pass

# Convert a pixel coordinate to a ray in the current plot's coordinate system
# IMPLOT3D_API ImPlot3DRay PixelsToPlotRay(const ImVec2& pix);    /* original C++ signature */
@overload
def pixels_to_plot_ray(pix: ImVec2Like) -> Ray:
    pass

# IMPLOT3D_API ImPlot3DRay PixelsToPlotRay(double x, double y);    /* original C++ signature */
@overload
def pixels_to_plot_ray(x: float, y: float) -> Ray:
    pass

# Convert a pixel coordinate to a point in an axis plane in the current plot's coordinate system
# IMPLOT3D_API ImPlot3DPoint PixelsToPlotPlane(const ImVec2& pix, ImPlane3D plane, bool mask = true);    /* original C++ signature */
@overload
def pixels_to_plot_plane(pix: ImVec2Like, plane: ImPlane3D, mask: bool = True) -> Point:
    pass

# IMPLOT3D_API ImPlot3DPoint PixelsToPlotPlane(double x, double y, ImPlane3D plane, bool mask = true);    /* original C++ signature */
@overload
def pixels_to_plot_plane(x: float, y: float, plane: ImPlane3D, mask: bool = True) -> Point:
    pass

# IMPLOT3D_API ImVec2 GetPlotPos();      /* original C++ signature */
def get_plot_pos() -> ImVec2:
    """Get the current plot position (top-left) in pixels"""
    pass

# IMPLOT3D_API ImVec2 GetPlotSize();     /* original C++ signature */
def get_plot_size() -> ImVec2:
    """Get the current plot size in pixels"""
    pass

# -----------------------------------------------------------------------------
# [SECTION] Miscellaneous
# -----------------------------------------------------------------------------

# IMPLOT3D_API ImDrawList* GetPlotDrawList();    /* original C++ signature */
def get_plot_draw_list() -> ImDrawList:
    pass

# -----------------------------------------------------------------------------
# [SECTION] Styles
# -----------------------------------------------------------------------------

# Get current style
# IMPLOT3D_API ImPlot3DStyle& GetStyle();    /* original C++ signature */
def get_style() -> Style:
    pass

# IMPLOT3D_API void SetStyle(const ImPlot3DStyle& style);    /* original C++ signature */
def set_style(style: Style) -> None:
    pass

# Set color styles
# IMPLOT3D_API void StyleColorsAuto(ImPlot3DStyle* dst = nullptr);        /* original C++ signature */
def style_colors_auto(dst: Optional[Style] = None) -> None:
    """Set colors with ImGui style"""
    pass

# IMPLOT3D_API void StyleColorsDark(ImPlot3DStyle* dst = nullptr);        /* original C++ signature */
def style_colors_dark(dst: Optional[Style] = None) -> None:
    """Set colors with dark style"""
    pass

# IMPLOT3D_API void StyleColorsLight(ImPlot3DStyle* dst = nullptr);       /* original C++ signature */
def style_colors_light(dst: Optional[Style] = None) -> None:
    """Set colors with light style"""
    pass

# IMPLOT3D_API void StyleColorsClassic(ImPlot3DStyle* dst = nullptr);     /* original C++ signature */
def style_colors_classic(dst: Optional[Style] = None) -> None:
    """Set colors with classic style"""
    pass

# Temporarily modify a style color. Don't forget to call PopStyleColor!
# IMPLOT3D_API void PushStyleColor(ImPlot3DCol idx, ImU32 col);    /* original C++ signature */
@overload
def push_style_color(idx: Col, col: ImU32) -> None:
    pass

# IMPLOT3D_API void PushStyleColor(ImPlot3DCol idx, const ImVec4& col);    /* original C++ signature */
@overload
def push_style_color(idx: Col, col: ImVec4Like) -> None:
    pass

# IMPLOT3D_API void PopStyleColor(int count = 1);    /* original C++ signature */
def pop_style_color(count: int = 1) -> None:
    """Undo temporary style color modification(s). Undo multiple pushes at once by increasing count"""
    pass

# IMPLOT3D_API void PushStyleVar(ImPlot3DStyleVar idx, float val);    /* original C++ signature */
@overload
def push_style_var(idx: StyleVar, val: float) -> None:
    """Temporarily modify a style variable of float type. Don't forget to call PopStyleVar!"""
    pass

# IMPLOT3D_API void PushStyleVar(ImPlot3DStyleVar idx, int val);    /* original C++ signature */
@overload
def push_style_var(idx: StyleVar, val: int) -> None:
    """Temporarily modify a style variable of int type. Don't forget to call PopStyleVar!"""
    pass

# IMPLOT3D_API void PushStyleVar(ImPlot3DStyleVar idx, const ImVec2& val);    /* original C++ signature */
@overload
def push_style_var(idx: StyleVar, val: ImVec2Like) -> None:
    """Temporarily modify a style variable of ImVec2 type. Don't forget to call PopStyleVar!"""
    pass

# IMPLOT3D_API void PopStyleVar(int count = 1);    /* original C++ signature */
def pop_style_var(count: int = 1) -> None:
    """Undo temporary style variable modification(s). Undo multiple pushes at once by increasing count"""
    pass

# IMPLOT3D_API void SetNextLineStyle(const ImVec4& col = IMPLOT3D_AUTO_COL, float weight = IMPLOT3D_AUTO);    /* original C++ signature */
def set_next_line_style(col: Optional[ImVec4Like] = None, weight: float = IMPLOT3D_AUTO) -> None:
    """Set the line color and weight for the next item only


    Python bindings defaults:
        If col is None, then its default value will be: IMPLOT3D_AUTO_COL
    """
    pass

# IMPLOT3D_API void SetNextFillStyle(const ImVec4& col = IMPLOT3D_AUTO_COL, float alpha_mod = IMPLOT3D_AUTO);    /* original C++ signature */
def set_next_fill_style(col: Optional[ImVec4Like] = None, alpha_mod: float = IMPLOT3D_AUTO) -> None:
    """Set the fill color for the next item only


    Python bindings defaults:
        If col is None, then its default value will be: IMPLOT3D_AUTO_COL
    """
    pass

# IMPLOT3D_API void SetNextMarkerStyle(ImPlot3DMarker marker = IMPLOT3D_AUTO, float size = IMPLOT3D_AUTO, const ImVec4& fill = IMPLOT3D_AUTO_COL,    /* original C++ signature */
#                                      float weight = IMPLOT3D_AUTO, const ImVec4& outline = IMPLOT3D_AUTO_COL);
def set_next_marker_style(
    marker: Optional[Marker] = None,
    size: float = IMPLOT3D_AUTO,
    fill: Optional[ImVec4Like] = None,
    weight: float = IMPLOT3D_AUTO,
    outline: Optional[ImVec4Like] = None,
) -> None:
    """Set the marker style for the next item only


    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            * marker: IMPLOT3D_AUTO
            * fill: IMPLOT3D_AUTO_COL
            * outline: IMPLOT3D_AUTO_COL
    """
    pass

# Get color
# IMPLOT3D_API ImVec4 GetStyleColorVec4(ImPlot3DCol idx);    /* original C++ signature */
def get_style_color_vec4(idx: Col) -> ImVec4:
    pass

# IMPLOT3D_API ImU32 GetStyleColorU32(ImPlot3DCol idx);    /* original C++ signature */
def get_style_color_u32(idx: Col) -> ImU32:
    pass

# -----------------------------------------------------------------------------
# [SECTION] Colormaps
# -----------------------------------------------------------------------------

# Item styling is based on colormaps when the relevant ImPlot3DCol_XXX is set to
# IMPLOT3D_AUTO_COL (default). Several built-in colormaps are available. You can
# add and then push/pop your own colormaps as well. To permanently set a colormap,
# modify the Colormap index member of your ImPlot3DStyle.

# Colormap data will be ignored and a custom color will be used if you have done one of the following:
#     1) Modified an item style color in your ImPlot3DStyle to anything other than IMPLOT3D_AUTO_COL.
#     3) Set the next item style with a SetNextXXXStyle function.

# Add a new colormap. The color data will be copied. The colormap can be used by pushing either the returned index or the
# string name with PushColormap. The colormap name must be unique and the size must be greater than 1. You will receive
# an assert otherwise! By default colormaps are considered to be qualitative (i.e. discrete). If you want to create a
# continuous colormap, set #qual=False. This will treat the colors you provide as keys, and ImPlot3D will build a linearly
# interpolated lookup table. The memory footprint of this table will be exactly ((size-1)*255+1)*4 bytes.

# IMPLOT3D_API ImPlot3DColormap AddColormap(const char* name, const ImVec4* cols, int size, bool qual = true);    /* original C++ signature */
@overload
def add_colormap(name: str, cols: ImVec4Like, size: int, qual: bool = True) -> Colormap:
    pass

# IMPLOT3D_API ImPlot3DColormap AddColormap(const char* name, const ImU32* cols, int size, bool qual = true);    /* original C++ signature */
@overload
def add_colormap(name: str, cols: ImU32, size: int, qual: bool = True) -> Colormap:
    pass

# IMPLOT3D_API int GetColormapCount();    /* original C++ signature */
def get_colormap_count() -> int:
    """Returns the number of available colormaps (i.e. the built-in + user-added count)"""
    pass

# IMPLOT3D_API const char* GetColormapName(ImPlot3DColormap cmap);    /* original C++ signature */
def get_colormap_name(cmap: Colormap) -> str:
    """Returns a null terminated string name for a colormap given an index. Returns None if index is invalid"""
    pass

# IMPLOT3D_API ImPlot3DColormap GetColormapIndex(const char* name);    /* original C++ signature */
def get_colormap_index(name: str) -> Colormap:
    """Returns an index number for a colormap given a valid string name. Returns -1 if name is invalid"""
    pass

# IMPLOT3D_API void PushColormap(ImPlot3DColormap cmap);    /* original C++ signature */
@overload
def push_colormap(cmap: Colormap) -> None:
    """Temporarily switch to one of the built-in (i.e. ImPlot3DColormap_XXX) or user-added colormaps (i.e. a return value of AddColormap). Don't forget to
    call PopColormap!
    """
    pass

# IMPLOT3D_API void PushColormap(const char* name);    /* original C++ signature */
@overload
def push_colormap(name: str) -> None:
    """Push a colormap by string name. Use built-in names such as "Default", "Deep", "Jet", etc. or a string you provided to AddColormap. Don't forget to
    call PopColormap!
    """
    pass

# IMPLOT3D_API void PopColormap(int count = 1);    /* original C++ signature */
def pop_colormap(count: int = 1) -> None:
    """Undo temporary colormap modification(s). Undo multiple pushes at once by increasing count"""
    pass

# IMPLOT3D_API ImVec4 NextColormapColor();    /* original C++ signature */
def next_colormap_color() -> ImVec4:
    """Returns the next color from the current colormap and advances the colormap for the current plot
    Can also be used with no return value to skip colors if desired. You need to call it between Begin/EndPlot!
    """
    pass

# IMPLOT3D_API int GetColormapSize(ImPlot3DColormap cmap = IMPLOT3D_AUTO);    /* original C++ signature */
def get_colormap_size(cmap: Optional[Colormap] = None) -> int:
    """Returns the size of a colormap


    Python bindings defaults:
        If cmap is None, then its default value will be: IMPLOT3D_AUTO
    """
    pass

# IMPLOT3D_API ImVec4 GetColormapColor(int idx, ImPlot3DColormap cmap = IMPLOT3D_AUTO);    /* original C++ signature */
def get_colormap_color(idx: int, cmap: Optional[Colormap] = None) -> ImVec4:
    """Returns a color from a colormap given an index >= 0 (modulo will be performed)


    Python bindings defaults:
        If cmap is None, then its default value will be: IMPLOT3D_AUTO
    """
    pass

# IMPLOT3D_API ImVec4 SampleColormap(float t, ImPlot3DColormap cmap = IMPLOT3D_AUTO);    /* original C++ signature */
def sample_colormap(t: float, cmap: Optional[Colormap] = None) -> ImVec4:
    """Sample a color from the current colormap given t between 0 and 1


    Python bindings defaults:
        If cmap is None, then its default value will be: IMPLOT3D_AUTO
    """
    pass

# -----------------------------------------------------------------------------
# [SECTION] Demo
# -----------------------------------------------------------------------------
# Add implot3_demo.cpp to your sources to use methods in this section

# IMPLOT3D_API void ShowDemoWindow(bool* p_open = nullptr);    /* original C++ signature */
def show_demo_window(p_open: Optional[bool] = None) -> Optional[bool]:
    """Shows the ImPlot3D demo window"""
    pass

# IMPLOT3D_API void ShowAllDemos();    /* original C++ signature */
def show_all_demos() -> None:
    """Shows all ImPlot3D demos, without enclosing window"""
    pass

# IMPLOT3D_API void ShowStyleEditor(ImPlot3DStyle* ref = nullptr);    /* original C++ signature */
def show_style_editor(ref: Optional[Style] = None) -> None:
    """Shows ImPlot3D style editor block (not a window)"""
    pass

# IMPLOT3D_API void ShowMetricsWindow(bool* p_popen = nullptr);    /* original C++ signature */
def show_metrics_window(p_popen: Optional[bool] = None) -> Optional[bool]:
    """Shows ImPlot3D metrics/debug information window."""
    pass

# -----------------------------------------------------------------------------
# [SECTION] ImPlot3DPoint
# -----------------------------------------------------------------------------

class Point:
    """ImPlot3DPoint: 3D vector to store points in 3D"""

    # float x,     /* original C++ signature */
    x: float
    # y,     /* original C++ signature */
    y: float
    # z;    /* original C++ signature */
    z: float
    # constexpr ImPlot3DPoint() : x(0.0f), y(0.0f), z(0.0f) {}    /* original C++ signature */
    @overload
    def __init__(self) -> None:
        pass
    # constexpr ImPlot3DPoint(float _x, float _y, float _z) : x(_x), y(_y), z(_z) {}    /* original C++ signature */
    @overload
    def __init__(self, _x: float, _y: float, _z: float) -> None:
        pass
    # Accessors
    # float& operator[](size_t idx) {    /* original C++ signature */
    #         IM_ASSERT(idx == 0 || idx == 1 || idx == 2);
    #         return ((float*)(void*)(char*)this)[idx];
    #     }
    @overload
    def __getitem__(self, idx: int) -> float:
        """(private API)"""
        pass
    # float operator[](size_t idx) const {    /* original C++ signature */
    #         IM_ASSERT(idx == 0 || idx == 1 || idx == 2);
    #         return ((const float*)(const void*)(const char*)this)[idx];
    #     }
    @overload
    def __getitem__(self, idx: int) -> float:
        """(private API)"""
        pass
    # Binary operators
    # IMPLOT3D_API ImPlot3DPoint operator*(float rhs) const;    /* original C++ signature */
    @overload
    def __mul__(self, rhs: float) -> Point:
        pass
    # IMPLOT3D_API ImPlot3DPoint operator/(float rhs) const;    /* original C++ signature */
    @overload
    def __truediv__(self, rhs: float) -> Point:
        pass
    # IMPLOT3D_API ImPlot3DPoint operator+(const ImPlot3DPoint& rhs) const;    /* original C++ signature */
    def __add__(self, rhs: Point) -> Point:
        pass
    # IMPLOT3D_API ImPlot3DPoint operator-(const ImPlot3DPoint& rhs) const;    /* original C++ signature */
    @overload
    def __sub__(self, rhs: Point) -> Point:
        pass
    # IMPLOT3D_API ImPlot3DPoint operator*(const ImPlot3DPoint& rhs) const;    /* original C++ signature */
    @overload
    def __mul__(self, rhs: Point) -> Point:
        pass
    # IMPLOT3D_API ImPlot3DPoint operator/(const ImPlot3DPoint& rhs) const;    /* original C++ signature */
    @overload
    def __truediv__(self, rhs: Point) -> Point:
        pass
    # IMPLOT3D_API ImPlot3DPoint operator-() const;    /* original C++ signature */
    @overload
    def __neg__(self) -> Point:
        """Unary operator"""
        pass
    # Compound assignment operators
    # IMPLOT3D_API ImPlot3DPoint& operator*=(float rhs);    /* original C++ signature */
    @overload
    def __imul__(self, rhs: float) -> Point:
        pass
    # IMPLOT3D_API ImPlot3DPoint& operator/=(float rhs);    /* original C++ signature */
    @overload
    def __itruediv__(self, rhs: float) -> Point:
        pass
    # IMPLOT3D_API ImPlot3DPoint& operator+=(const ImPlot3DPoint& rhs);    /* original C++ signature */
    def __iadd__(self, rhs: Point) -> Point:
        pass
    # IMPLOT3D_API ImPlot3DPoint& operator-=(const ImPlot3DPoint& rhs);    /* original C++ signature */
    def __isub__(self, rhs: Point) -> Point:
        pass
    # IMPLOT3D_API ImPlot3DPoint& operator*=(const ImPlot3DPoint& rhs);    /* original C++ signature */
    @overload
    def __imul__(self, rhs: Point) -> Point:
        pass
    # IMPLOT3D_API ImPlot3DPoint& operator/=(const ImPlot3DPoint& rhs);    /* original C++ signature */
    @overload
    def __itruediv__(self, rhs: Point) -> Point:
        pass
    # Comparison operators
    # IMPLOT3D_API bool operator==(const ImPlot3DPoint& rhs) const;    /* original C++ signature */
    def __eq__(self, rhs: Point) -> bool:
        pass
    # IMPLOT3D_API bool operator!=(const ImPlot3DPoint& rhs) const;    /* original C++ signature */
    def __ne__(self, rhs: Point) -> bool:
        pass
    # IMPLOT3D_API float Dot(const ImPlot3DPoint& rhs) const;    /* original C++ signature */
    def dot(self, rhs: Point) -> float:
        """Dot product"""
        pass
    # IMPLOT3D_API ImPlot3DPoint Cross(const ImPlot3DPoint& rhs) const;    /* original C++ signature */
    def cross(self, rhs: Point) -> Point:
        """Cross product"""
        pass
    # IMPLOT3D_API float Length() const;    /* original C++ signature */
    def length(self) -> float:
        """Get vector length"""
        pass
    # IMPLOT3D_API float LengthSquared() const;    /* original C++ signature */
    def length_squared(self) -> float:
        """Get vector squared length"""
        pass
    # IMPLOT3D_API void Normalize();    /* original C++ signature */
    def normalize(self) -> None:
        """Normalize to unit length"""
        pass
    # IMPLOT3D_API ImPlot3DPoint Normalized() const;    /* original C++ signature */
    def normalized(self) -> Point:
        """Return vector normalized to unit length"""
        pass
    # IMPLOT3D_API bool IsNaN() const;    /* original C++ signature */
    def is_nan(self) -> bool:
        """Check if the point is NaN"""
        pass

# -----------------------------------------------------------------------------
# [SECTION] ImPlot3DRay
# -----------------------------------------------------------------------------

class Ray:
    # ImPlot3DPoint Origin;    /* original C++ signature */
    origin: Point
    # ImPlot3DPoint Direction;    /* original C++ signature */
    direction: Point
    # ImPlot3DRay(ImPlot3DPoint Origin = ImPlot3DPoint(), ImPlot3DPoint Direction = ImPlot3DPoint());    /* original C++ signature */
    def __init__(self, origin: Optional[Point] = None, direction: Optional[Point] = None) -> None:
        """Auto-generated default constructor with named params


        Python bindings defaults:
            If any of the params below is None, then its default value below will be used:
                * Origin: Point()
                * Direction: Point()
        """
        pass

# -----------------------------------------------------------------------------
# [SECTION] ImPlot3DPlane
# -----------------------------------------------------------------------------

class Plane:
    # ImPlot3DPoint Point;    /* original C++ signature */
    point: Point
    # ImPlot3DPoint Normal;    /* original C++ signature */
    normal: Point
    # ImPlot3DPlane(ImPlot3DPoint Point = ImPlot3DPoint(), ImPlot3DPoint Normal = ImPlot3DPoint());    /* original C++ signature */
    def __init__(self, point: Optional[Point] = None, normal: Optional[Point] = None) -> None:
        """Auto-generated default constructor with named params


        Python bindings defaults:
            If any of the params below is None, then its default value below will be used:
                * Point: Point()
                * Normal: Point()
        """
        pass

# -----------------------------------------------------------------------------
# [SECTION] ImPlot3DBox
# -----------------------------------------------------------------------------

class Box:
    # ImPlot3DPoint Min;    /* original C++ signature */
    min: Point
    # ImPlot3DPoint Max;    /* original C++ signature */
    max: Point

    # constexpr ImPlot3DBox() : Min(ImPlot3DPoint()), Max(ImPlot3DPoint()) {}    /* original C++ signature */
    @overload
    def __init__(self) -> None:
        """Default constructor"""
        pass
    # constexpr ImPlot3DBox(const ImPlot3DPoint& min, const ImPlot3DPoint& max) : Min(min), Max(max) {}    /* original C++ signature */
    @overload
    def __init__(self, min: Point, max: Point) -> None:
        """Constructor with two points"""
        pass
    # IMPLOT3D_API void Expand(const ImPlot3DPoint& point);    /* original C++ signature */
    def expand(self, point: Point) -> None:
        """Method to expand the box to include a point"""
        pass
    # IMPLOT3D_API bool Contains(const ImPlot3DPoint& point) const;    /* original C++ signature */
    def contains(self, point: Point) -> bool:
        """Method to check if a point is inside the box"""
        pass
    # IMPLOT3D_API bool ClipLineSegment(const ImPlot3DPoint& p0, const ImPlot3DPoint& p1, ImPlot3DPoint& p0_clipped, ImPlot3DPoint& p1_clipped) const;    /* original C++ signature */
    def clip_line_segment(self, p0: Point, p1: Point, p0_clipped: Point, p1_clipped: Point) -> bool:
        """Method to clip a line segment against the box"""
        pass

# -----------------------------------------------------------------------------
# [SECTION] ImPlot3DRange
# -----------------------------------------------------------------------------

class Range:
    # float Min;    /* original C++ signature */
    min: float
    # float Max;    /* original C++ signature */
    max: float

    # constexpr ImPlot3DRange() : Min(0.0f), Max(0.0f) {}    /* original C++ signature */
    @overload
    def __init__(self) -> None:
        pass
    # constexpr ImPlot3DRange(float min, float max) : Min(min), Max(max) {}    /* original C++ signature */
    @overload
    def __init__(self, min: float, max: float) -> None:
        pass
    # IMPLOT3D_API void Expand(float value);    /* original C++ signature */
    def expand(self, value: float) -> None:
        pass
    # IMPLOT3D_API bool Contains(float value) const;    /* original C++ signature */
    def contains(self, value: float) -> bool:
        pass
    # float Size() const { return Max - Min; }    /* original C++ signature */
    def size(self) -> float:
        """(private API)"""
        pass

# -----------------------------------------------------------------------------
# [SECTION] ImPlot3DQuat
# -----------------------------------------------------------------------------

class Quat:
    # float x,     /* original C++ signature */
    x: float
    # y,     /* original C++ signature */
    y: float
    # z,     /* original C++ signature */
    z: float
    # w;    /* original C++ signature */
    w: float

    # Constructors
    # constexpr ImPlot3DQuat() : x(0.0f), y(0.0f), z(0.0f), w(1.0f) {}    /* original C++ signature */
    @overload
    def __init__(self) -> None:
        pass
    # constexpr ImPlot3DQuat(float _x, float _y, float _z, float _w) : x(_x), y(_y), z(_z), w(_w) {}    /* original C++ signature */
    @overload
    def __init__(self, _x: float, _y: float, _z: float, _w: float) -> None:
        pass
    # IMPLOT3D_API ImPlot3DQuat(float _angle, const ImPlot3DPoint& _axis);    /* original C++ signature */
    @overload
    def __init__(self, _angle: float, _axis: Point) -> None:
        pass
    # IMPLOT3D_API static ImPlot3DQuat FromTwoVectors(const ImPlot3DPoint& v0, const ImPlot3DPoint& v1);    /* original C++ signature */
    @staticmethod
    def from_two_vectors(v0: Point, v1: Point) -> Quat:
        """Set quaternion from two vectors"""
        pass
    # IMPLOT3D_API static ImPlot3DQuat FromElAz(float elevation, float azimuth);    /* original C++ signature */
    @staticmethod
    def from_el_az(elevation: float, azimuth: float) -> Quat:
        """Set quaternion given elevation and azimuth angles in radians"""
        pass
    # IMPLOT3D_API float Length() const;    /* original C++ signature */
    def length(self) -> float:
        """Get quaternion length"""
        pass
    # IMPLOT3D_API ImPlot3DQuat Normalized() const;    /* original C++ signature */
    def normalized(self) -> Quat:
        """Get normalized quaternion"""
        pass
    # IMPLOT3D_API ImPlot3DQuat Conjugate() const;    /* original C++ signature */
    def conjugate(self) -> Quat:
        """Conjugate of the quaternion"""
        pass
    # IMPLOT3D_API ImPlot3DQuat Inverse() const;    /* original C++ signature */
    def inverse(self) -> Quat:
        """Inverse of the quaternion"""
        pass
    # IMPLOT3D_API ImPlot3DQuat operator*(const ImPlot3DQuat& rhs) const;    /* original C++ signature */
    @overload
    def __mul__(self, rhs: Quat) -> Quat:
        """Binary operators"""
        pass
    # IMPLOT3D_API ImPlot3DQuat& Normalize();    /* original C++ signature */
    def normalize(self) -> Quat:
        """Normalize the quaternion in place"""
        pass
    # IMPLOT3D_API ImPlot3DPoint operator*(const ImPlot3DPoint& point) const;    /* original C++ signature */
    @overload
    def __mul__(self, point: Point) -> Point:
        """Rotate a 3D point using the quaternion"""
        pass
    # Comparison operators
    # IMPLOT3D_API bool operator==(const ImPlot3DQuat& rhs) const;    /* original C++ signature */
    def __eq__(self, rhs: Quat) -> bool:
        pass
    # IMPLOT3D_API bool operator!=(const ImPlot3DQuat& rhs) const;    /* original C++ signature */
    def __ne__(self, rhs: Quat) -> bool:
        pass
    # IMPLOT3D_API static ImPlot3DQuat Slerp(const ImPlot3DQuat& q1, const ImPlot3DQuat& q2, float t);    /* original C++ signature */
    @staticmethod
    def slerp(q1: Quat, q2: Quat, t: float) -> Quat:
        """Interpolate between two quaternions"""
        pass
    # IMPLOT3D_API float Dot(const ImPlot3DQuat& rhs) const;    /* original C++ signature */
    def dot(self, rhs: Quat) -> float:
        """Get quaternion dot product"""
        pass

# -----------------------------------------------------------------------------
# [SECTION] ImPlot3DStyle
# -----------------------------------------------------------------------------

class Style:
    """
    (has support for copy.copy)
    """

    # Item style
    # float LineWeight;    /* original C++ signature */
    line_weight: float  # Line weight in pixels
    # int Marker;    /* original C++ signature */
    marker: int  # Default marker type (ImPlot3DMarker_None)
    # float MarkerSize;    /* original C++ signature */
    marker_size: float  # Marker size in pixels (roughly the marker's "radius")
    # float MarkerWeight;    /* original C++ signature */
    marker_weight: float  # Marker outline weight in pixels
    # float FillAlpha;    /* original C++ signature */
    fill_alpha: float  # Alpha modifier applied to plot fills
    # Plot style
    # ImVec2 PlotDefaultSize;    /* original C++ signature */
    plot_default_size: ImVec2
    # ImVec2 PlotMinSize;    /* original C++ signature */
    plot_min_size: ImVec2
    # ImVec2 PlotPadding;    /* original C++ signature */
    plot_padding: ImVec2
    # ImVec2 LabelPadding;    /* original C++ signature */
    label_padding: ImVec2
    # Legend style
    # ImVec2 LegendPadding;    /* original C++ signature */
    legend_padding: ImVec2  # Legend padding from plot edges
    # ImVec2 LegendInnerPadding;    /* original C++ signature */
    legend_inner_padding: ImVec2  # Legend inner padding from legend edges
    # ImVec2 LegendSpacing;    /* original C++ signature */
    legend_spacing: ImVec2  # Spacing between legend entries
    # inline ImVec4 GetColor(ImPlot3DCol idx) const { return Colors[idx]; }    /* original C++ signature */
    def get_color(self, idx: Col) -> ImVec4:
        """(private API)"""
        pass
    # inline void SetColor(ImPlot3DCol idx, const ImVec4& col) { Colors[idx] = col; }    /* original C++ signature */
    def set_color(self, idx: Col, col: ImVec4Like) -> None:
        """(private API)"""
        pass
    # Colormap
    # ImPlot3DColormap Colormap;    /* original C++ signature */
    colormap: Colormap  # The current colormap. Set this to either an ImPlot3DColormap_ enum or an index returned by AddColormap
    # IMPLOT3D_API ImPlot3DStyle();    /* original C++ signature */
    @overload
    def __init__(self) -> None:
        """Constructor"""
        pass
    # ImPlot3DStyle(const ImPlot3DStyle& other) = default;    /* original C++ signature */
    @overload
    def __init__(self, other: Style) -> None:
        pass

# -----------------------------------------------------------------------------
# [SECTION] Meshes
# -----------------------------------------------------------------------------

# Cube

# Sphere

# Duck (Rubber Duck by Poly by Google [CC-BY] via Poly Pizza)

# #endif
####################    </generated_from:implot3d.h>    ####################

# </litgen_stub>
# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

###############################################################################
# MANUAL BINDINGS BELOW
###############################################################################

# Sets an axis' ticks and optionally the labels for the next plot. To keep the default ticks, set #keep_default=true.
# IMPLOT3D_API void SetupAxisTicks(ImAxis3D axis, double v_min, double v_max, int n_ticks, const char* const labels[] = nullptr, bool keep_default = false);
def setup_axis_ticks(
    axis: ImAxis3D,
    v_min: float,
    v_max: float,
    n_ticks: int,
    labels: List[str] | None = None,
    keep_default: bool = False,
):
    pass

# Sets an axis' ticks and optionally the labels for the next plot. To keep the default ticks, set #keep_default=true.
# IMPLOT3D_API void SetupAxisTicks(ImAxis3D axis, const double* values, int n_ticks, const char* const labels[] = nullptr, bool keep_default = false);
def setup_axis_ticks(
    axis: ImAxis3D,
    values: List[float],
    labels: List[str] | None = None,
    keep_default: bool = False,
):
    pass
