// Part of ImGui Bundle - MIT License - Copyright (c) 2022-2024 Pascal Thomet - https://github.com/pthom/imgui_bundle
#include <nanobind/nanobind.h>
#include <nanobind/trampoline.h>
#include <nanobind/stl/array.h>
#include <nanobind/stl/string.h>
#include <nanobind/stl/vector.h>
#include <nanobind/stl/optional.h>
#include <nanobind/stl/function.h>
#include <nanobind/stl/shared_ptr.h>
#include <nanobind/stl/unique_ptr.h>
#include <nanobind/stl/map.h>
#include <nanobind/stl/tuple.h>
#include <nanobind/make_iterator.h>
#include <nanobind/ndarray.h>

#include "ImCoolBar/ImCoolBar.h"  // Change this include to the library you are binding

namespace nb = nanobind;

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// <litgen_glue_code>  // Autogenerated code below! Do not edit!

// </litgen_glue_code> // Autogenerated code end
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!



void py_init_module_imcoolbar(nb::module_& m)
{
    using namespace ImGui;

    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // <litgen_pydef> // Autogenerated code below! Do not edit!
    ////////////////////    <generated_from:ImCoolbar.h>    ////////////////////
    auto pyEnumImCoolBarFlags_ =
        nb::enum_<ImCoolBarFlags_>(m, "ImCoolBarFlags_", nb::is_arithmetic(), "")
            .value("none", ImCoolBarFlags_None, "")
            .value("vertical", ImCoolBarFlags_Vertical, "")
            .value("horizontal", ImCoolBarFlags_Horizontal, "");


    auto pyClassImCoolBarConfig =
        nb::class_<ImGui::ImCoolBarConfig>
            (m, "ImCoolBarConfig", "")
        .def_rw("anchor", &ImGui::ImCoolBarConfig::anchor, "")
        .def_rw("normal_size", &ImGui::ImCoolBarConfig::normal_size, "")
        .def_rw("hovered_size", &ImGui::ImCoolBarConfig::hovered_size, "")
        .def_rw("anim_step", &ImGui::ImCoolBarConfig::anim_step, "")
        .def_rw("effect_strength", &ImGui::ImCoolBarConfig::effect_strength, "")
        .def("__init__",
            [](ImGui::ImCoolBarConfig * self, const std::optional<const ImVec2> & vAnchor = std::nullopt, const float & vNormalSize = 40.0f, const float & vHoveredSize = 60.0f, const float & vAnimStep = 0.15f, const float & vEffectStrength = 0.5f)
            {
                auto ctor_wrapper = [](ImGui::ImCoolBarConfig* self, const ImVec2 vAnchor = ImVec2(-1.0f, -1.0f), const float & vNormalSize = 40.0f, const float & vHoveredSize = 60.0f, const float & vAnimStep = 0.15f, const float & vEffectStrength = 0.5f) ->  void
                {
                    new(self) ImGui::ImCoolBarConfig(vAnchor, vNormalSize, vHoveredSize, vAnimStep, vEffectStrength); // placement new
                };
                auto ctor_wrapper_adapt_mutable_param_with_default_value = [&ctor_wrapper](ImGui::ImCoolBarConfig * self, const std::optional<const ImVec2> & vAnchor = std::nullopt, const float & vNormalSize = 40.0f, const float & vHoveredSize = 60.0f, const float & vAnimStep = 0.15f, const float & vEffectStrength = 0.5f)
                {

                    const ImVec2& vAnchor_or_default = [&]() -> const ImVec2 {
                        if (vAnchor.has_value())
                            return vAnchor.value();
                        else
                            return ImVec2(-1.0f, -1.0f);
                    }();

                    ctor_wrapper(self, vAnchor_or_default, vNormalSize, vHoveredSize, vAnimStep, vEffectStrength);
                };

                ctor_wrapper_adapt_mutable_param_with_default_value(self, vAnchor, vNormalSize, vHoveredSize, vAnimStep, vEffectStrength);
            },
            nb::arg("v_anchor").none() = nb::none(), nb::arg("v_normal_size") = 40.0f, nb::arg("v_hovered_size") = 60.0f, nb::arg("v_anim_step") = 0.15f, nb::arg("v_effect_strength") = 0.5f,
            "Python bindings defaults:\n    If vAnchor is None, then its default value will be: ImVec2(-1.0, -1.0)\n\n //")
        ;


    m.def("begin_cool_bar",
        [](const char * vLabel, const std::optional<const ImCoolBarFlags> & vCBFlags = std::nullopt, const std::optional<const ImGui::ImCoolBarConfig> & vConfig = std::nullopt, const std::optional<const ImGuiWindowFlags> & vFlags = std::nullopt) -> bool
        {
            auto BeginCoolBar_adapt_mutable_param_with_default_value = [](const char * vLabel, const std::optional<const ImCoolBarFlags> & vCBFlags = std::nullopt, const std::optional<const ImGui::ImCoolBarConfig> & vConfig = std::nullopt, const std::optional<const ImGuiWindowFlags> & vFlags = std::nullopt) -> bool
            {

                const ImCoolBarFlags& vCBFlags_or_default = [&]() -> const ImCoolBarFlags {
                    if (vCBFlags.has_value())
                        return vCBFlags.value();
                    else
                        return ImCoolBarFlags_Vertical;
                }();

                const ImGui::ImCoolBarConfig& vConfig_or_default = [&]() -> const ImGui::ImCoolBarConfig {
                    if (vConfig.has_value())
                        return vConfig.value();
                    else
                        return {};
                }();

                const ImGuiWindowFlags& vFlags_or_default = [&]() -> const ImGuiWindowFlags {
                    if (vFlags.has_value())
                        return vFlags.value();
                    else
                        return ImGuiWindowFlags_None;
                }();

                auto lambda_result = ImGui::BeginCoolBar(vLabel, vCBFlags_or_default, vConfig_or_default, vFlags_or_default);
                return lambda_result;
            };

            return BeginCoolBar_adapt_mutable_param_with_default_value(vLabel, vCBFlags, vConfig, vFlags);
        },
        nb::arg("v_label"), nb::arg("v_cb_flags").none() = nb::none(), nb::arg("v_config").none() = nb::none(), nb::arg("v_flags").none() = nb::none(),
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * vCBFlags: ImCoolBarFlags_.vertical\n        * vConfig: initialized with default value\n        * vFlags: WindowFlags_.none");

    m.def("end_cool_bar",
        ImGui::EndCoolBar);

    m.def("cool_bar_item",
        ImGui::CoolBarItem);

    m.def("get_cool_bar_item_width",
        ImGui::GetCoolBarItemWidth);

    m.def("get_cool_bar_item_scale",
        ImGui::GetCoolBarItemScale);

    m.def("show_cool_bar_metrics",
        ImGui::ShowCoolBarMetrics, nb::arg("v_opened"));
    ////////////////////    </generated_from:ImCoolbar.h>    ////////////////////

    // </litgen_pydef> // Autogenerated code end
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
}
