#ifdef IMGUI_BUNDLE_WITH_IMFILEDIALOG
// Part of ImGui Bundle - MIT License - Copyright (c) 2022-2024 Pascal Thomet - https://github.com/pthom/imgui_bundle
#include <nanobind/nanobind.h>
#include <nanobind/trampoline.h>
#include <nanobind/stl/array.h>
#include <nanobind/stl/string.h>
#include <nanobind/stl/vector.h>
#include <nanobind/stl/optional.h>
#include <nanobind/stl/function.h>
#include <nanobind/stl/shared_ptr.h>
#include <nanobind/stl/unique_ptr.h>
#include <nanobind/stl/map.h>
#include <nanobind/stl/tuple.h>
#include <nanobind/make_iterator.h>
#include <nanobind/ndarray.h>

#include "ImFileDialog/ImFileDialog.h"

namespace nb = nanobind;

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// <litgen_glue_code>  // Autogenerated code below! Do not edit!

// </litgen_glue_code> // Autogenerated code end
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


void py_init_module_im_file_dialog(nb::module_& m)
{
    using namespace ifd;

	nb::class_<std::filesystem::path>(m, "Path")
		.def(nb::init<std::string>())
		.def("__str__", [](const std::filesystem::path& self) { return self.string(); })
		.def("path", [](const std::filesystem::path& self) { return self.string(); })
		.def("filename", [](const std::filesystem::path& self) { return self.filename().string(); })
		.def("extension", [](const std::filesystem::path& self) { return self.extension().string(); })
		.def("parent_path", [](const std::filesystem::path& self) { return self.parent_path(); })
		;
	nb::implicitly_convertible<std::string, std::filesystem::path>();

	// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // <litgen_pydef> // Autogenerated code below! Do not edit!
    ////////////////////    <generated_from:ImFileDialog.h>    ////////////////////
    auto pyClassFileDialog =
        nb::class_<ifd::FileDialog>
            (m, "FileDialog", "");

    { // inner classes & enums of FileDialog
        auto pyClassFileDialog_ClassFileTreeNode =
            nb::class_<ifd::FileDialog::FileTreeNode>
                (pyClassFileDialog, "FileTreeNode", "")
            .def(nb::init<const std::string &>(),
                nb::arg("path"))
            .def_rw("path", &ifd::FileDialog::FileTreeNode::Path, "")
            .def_rw("read", &ifd::FileDialog::FileTreeNode::Read, "")
            .def_rw("children", &ifd::FileDialog::FileTreeNode::Children, "")
            ;
        auto pyClassFileDialog_ClassFileData =
            nb::class_<ifd::FileDialog::FileData>
                (pyClassFileDialog, "FileData", "")
            .def(nb::init<const std::filesystem::path &>(),
                nb::arg("path"))
            .def_rw("path", &ifd::FileDialog::FileData::Path, "")
            .def_rw("is_directory", &ifd::FileDialog::FileData::IsDirectory, "")
            .def_rw("size", &ifd::FileDialog::FileData::Size, "")
            .def_rw("date_modified", &ifd::FileDialog::FileData::DateModified, "")
            .def_rw("has_icon_preview", &ifd::FileDialog::FileData::HasIconPreview, "")
            .def_rw("icon_preview", &ifd::FileDialog::FileData::IconPreview, "")
            .def_rw("icon_preview_data", &ifd::FileDialog::FileData::IconPreviewData, "")
            .def_rw("icon_preview_width", &ifd::FileDialog::FileData::IconPreviewWidth, "")
            .def_rw("icon_preview_height", &ifd::FileDialog::FileData::IconPreviewHeight, "")
            ;
    } // end of inner classes & enums of FileDialog

    pyClassFileDialog
        .def_static("instance",
            &ifd::FileDialog::Instance, nb::rv_policy::reference)
        .def(nb::init<>())
        .def("save",
            &ifd::FileDialog::Save, nb::arg("key"), nb::arg("title"), nb::arg("filter"), nb::arg("starting_dir") = "")
        .def("open",
            &ifd::FileDialog::Open, nb::arg("key"), nb::arg("title"), nb::arg("filter"), nb::arg("is_multiselect") = false, nb::arg("starting_dir") = "")
        .def("is_done",
            &ifd::FileDialog::IsDone, nb::arg("key"))
        .def("has_result",
            &ifd::FileDialog::HasResult)
        .def("get_result",
            &ifd::FileDialog::GetResult)
        .def("get_results",
            &ifd::FileDialog::GetResults)
        .def("close",
            &ifd::FileDialog::Close)
        .def("remove_favorite",
            &ifd::FileDialog::RemoveFavorite, nb::arg("path"))
        .def("add_favorite",
            &ifd::FileDialog::AddFavorite, nb::arg("path"))
        .def("get_favorites",
            &ifd::FileDialog::GetFavorites)
        .def("set_zoom",
            &ifd::FileDialog::SetZoom, nb::arg("z"))
        .def("get_zoom",
            &ifd::FileDialog::GetZoom)
        ;
    ////////////////////    </generated_from:ImFileDialog.h>    ////////////////////

    // </litgen_pydef> // Autogenerated code end
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
}
#endif
