// Part of ImGui Bundle - MIT License - Copyright (c) 2022-2024 Pascal Thomet - https://github.com/pthom/imgui_bundle
#include <nanobind/nanobind.h>
#include <nanobind/trampoline.h>
#include <nanobind/stl/array.h>
#include <nanobind/stl/string.h>
#include <nanobind/stl/vector.h>
#include <nanobind/stl/optional.h>
#include <nanobind/stl/function.h>
#include <nanobind/stl/shared_ptr.h>
#include <nanobind/stl/unique_ptr.h>
#include <nanobind/stl/map.h>
#include <nanobind/stl/tuple.h>
#include <nanobind/make_iterator.h>
#include <nanobind/ndarray.h>


#include "ImGuiColorTextEdit/TextEditor.h"

namespace nb = nanobind;

typedef uint8_t Char;

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// <litgen_glue_code>  // Autogenerated code below! Do not edit!

// </litgen_glue_code> // Autogenerated code end
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


void py_init_module_imgui_color_text_edit(nb::module_& m)
{
    // You can add any code here

    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // <litgen_pydef> // Autogenerated code below! Do not edit!
    ////////////////////    <generated_from:TextEditor.h>    ////////////////////
    auto pyClassTextEditor =
        nb::class_<TextEditor>
            (m, "TextEditor", "");

    { // inner classes & enums of TextEditor
        auto pyEnumPaletteId =
            nb::enum_<TextEditor::PaletteId>(pyClassTextEditor, "PaletteId", nb::is_arithmetic(), "")
                .value("dark", TextEditor::PaletteId::Dark, "")
                .value("light", TextEditor::PaletteId::Light, "")
                .value("mariana", TextEditor::PaletteId::Mariana, "")
                .value("retro_blue", TextEditor::PaletteId::RetroBlue, "");
        auto pyEnumLanguageDefinitionId =
            nb::enum_<TextEditor::LanguageDefinitionId>(pyClassTextEditor, "LanguageDefinitionId", nb::is_arithmetic(), "")
                .value("none", TextEditor::LanguageDefinitionId::None, "")
                .value("cpp", TextEditor::LanguageDefinitionId::Cpp, "")
                .value("c", TextEditor::LanguageDefinitionId::C, "")
                .value("cs", TextEditor::LanguageDefinitionId::Cs, "")
                .value("python", TextEditor::LanguageDefinitionId::Python, "")
                .value("lua", TextEditor::LanguageDefinitionId::Lua, "")
                .value("json", TextEditor::LanguageDefinitionId::Json, "")
                .value("sql", TextEditor::LanguageDefinitionId::Sql, "")
                .value("angel_script", TextEditor::LanguageDefinitionId::AngelScript, "")
                .value("glsl", TextEditor::LanguageDefinitionId::Glsl, "")
                .value("hlsl", TextEditor::LanguageDefinitionId::Hlsl, "");
        auto pyEnumSetViewAtLineMode =
            nb::enum_<TextEditor::SetViewAtLineMode>(pyClassTextEditor, "SetViewAtLineMode", nb::is_arithmetic(), "")
                .value("first_visible_line", TextEditor::SetViewAtLineMode::FirstVisibleLine, "")
                .value("centered", TextEditor::SetViewAtLineMode::Centered, "")
                .value("last_visible_line", TextEditor::SetViewAtLineMode::LastVisibleLine, "");
    } // end of inner classes & enums of TextEditor

    pyClassTextEditor
        .def(nb::init<>())
        .def("set_read_only_enabled",
            &TextEditor::SetReadOnlyEnabled, nb::arg("a_value"))
        .def("is_read_only_enabled",
            &TextEditor::IsReadOnlyEnabled)
        .def("set_auto_indent_enabled",
            &TextEditor::SetAutoIndentEnabled, nb::arg("a_value"))
        .def("is_auto_indent_enabled",
            &TextEditor::IsAutoIndentEnabled)
        .def("set_show_whitespaces_enabled",
            &TextEditor::SetShowWhitespacesEnabled, nb::arg("a_value"))
        .def("is_show_whitespaces_enabled",
            &TextEditor::IsShowWhitespacesEnabled)
        .def("set_show_line_numbers_enabled",
            &TextEditor::SetShowLineNumbersEnabled, nb::arg("a_value"))
        .def("is_show_line_numbers_enabled",
            &TextEditor::IsShowLineNumbersEnabled)
        .def("set_short_tabs_enabled",
            &TextEditor::SetShortTabsEnabled, nb::arg("a_value"))
        .def("is_short_tabs_enabled",
            &TextEditor::IsShortTabsEnabled)
        .def("get_line_count",
            &TextEditor::GetLineCount)
        .def("set_palette",
            &TextEditor::SetPalette, nb::arg("a_value"))
        .def("get_palette",
            &TextEditor::GetPalette)
        .def("set_language_definition",
            &TextEditor::SetLanguageDefinition, nb::arg("a_value"))
        .def("get_language_definition",
            &TextEditor::GetLanguageDefinition)
        .def("get_language_definition_name",
            &TextEditor::GetLanguageDefinitionName)
        .def("set_tab_size",
            &TextEditor::SetTabSize, nb::arg("a_value"))
        .def("get_tab_size",
            &TextEditor::GetTabSize)
        .def("set_line_spacing",
            &TextEditor::SetLineSpacing, nb::arg("a_value"))
        .def("get_line_spacing",
            &TextEditor::GetLineSpacing)
        .def_static("set_default_palette",
            &TextEditor::SetDefaultPalette, nb::arg("a_value"))
        .def_static("get_default_palette",
            &TextEditor::GetDefaultPalette)
        .def("select_all",
            &TextEditor::SelectAll)
        .def("select_line",
            &TextEditor::SelectLine, nb::arg("a_line"))
        .def("select_region",
            &TextEditor::SelectRegion, nb::arg("a_start_line"), nb::arg("a_start_char"), nb::arg("a_end_line"), nb::arg("a_end_char"))
        .def("select_next_occurrence_of",
            nb::overload_cast<const char *, int, bool>(&TextEditor::SelectNextOccurrenceOf), nb::arg("a_text"), nb::arg("a_text_size"), nb::arg("a_case_sensitive") = true)
        .def("select_all_occurrences_of",
            &TextEditor::SelectAllOccurrencesOf, nb::arg("a_text"), nb::arg("a_text_size"), nb::arg("a_case_sensitive") = true)
        .def("any_cursor_has_selection",
            &TextEditor::AnyCursorHasSelection)
        .def("all_cursors_have_selection",
            &TextEditor::AllCursorsHaveSelection)
        .def("clear_extra_cursors",
            &TextEditor::ClearExtraCursors)
        .def("clear_selections",
            &TextEditor::ClearSelections)
        .def("set_cursor_position",
            nb::overload_cast<int, int>(&TextEditor::SetCursorPosition), nb::arg("a_line"), nb::arg("a_char_index"))
        .def("get_cursor_position",
            &TextEditor::GetCursorPosition, nb::arg("out_line"), nb::arg("out_column"))
        .def("get_first_visible_line",
            &TextEditor::GetFirstVisibleLine)
        .def("get_last_visible_line",
            &TextEditor::GetLastVisibleLine)
        .def("set_view_at_line",
            &TextEditor::SetViewAtLine, nb::arg("a_line"), nb::arg("a_mode"))
        .def("copy",
            &TextEditor::Copy)
        .def("cut",
            &TextEditor::Cut)
        .def("paste",
            &TextEditor::Paste)
        .def("undo",
            &TextEditor::Undo, nb::arg("a_steps") = 1)
        .def("redo",
            &TextEditor::Redo, nb::arg("a_steps") = 1)
        .def("can_undo",
            &TextEditor::CanUndo)
        .def("can_redo",
            &TextEditor::CanRedo)
        .def("get_undo_index",
            &TextEditor::GetUndoIndex)
        .def("set_text",
            &TextEditor::SetText, nb::arg("a_text"))
        .def("get_text",
            [](TextEditor & self) { return self.GetText(); })
        .def("set_text_lines",
            &TextEditor::SetTextLines, nb::arg("a_lines"))
        .def("get_text_lines",
            &TextEditor::GetTextLines)
        .def("render",
            [](TextEditor & self, const char * aTitle, bool aParentIsFocused = false, const std::optional<const ImVec2> & aSize = std::nullopt, bool aBorder = false) -> bool
            {
                auto Render_adapt_mutable_param_with_default_value = [&self](const char * aTitle, bool aParentIsFocused = false, const std::optional<const ImVec2> & aSize = std::nullopt, bool aBorder = false) -> bool
                {

                    const ImVec2& aSize_or_default = [&]() -> const ImVec2 {
                        if (aSize.has_value())
                            return aSize.value();
                        else
                            return ImVec2();
                    }();

                    auto lambda_result = self.Render(aTitle, aParentIsFocused, aSize_or_default, aBorder);
                    return lambda_result;
                };

                return Render_adapt_mutable_param_with_default_value(aTitle, aParentIsFocused, aSize, aBorder);
            },
            nb::arg("a_title"), nb::arg("a_parent_is_focused") = false, nb::arg("a_size").none() = nb::none(), nb::arg("a_border") = false,
            "Python bindings defaults:\n    If aSize is None, then its default value will be: ImVec2()")
        .def("im_gui_debug_panel",
            &TextEditor::ImGuiDebugPanel, nb::arg("panel_name") = "Debug")
        .def("unit_tests",
            &TextEditor::UnitTests)
        .def("set_selection",
            nb::overload_cast<int, int, int, int, int>(&TextEditor::SetSelection), nb::arg("a_start_line"), nb::arg("a_start_char"), nb::arg("a_end_line"), nb::arg("a_end_char"), nb::arg("a_cursor") = -1)
        .def("get_selection_start",
            &TextEditor::GetSelectionStart, nb::arg("a_cursor") = -1)
        .def("get_selection_end",
            &TextEditor::GetSelectionEnd, nb::arg("a_cursor") = -1)
        .def("get_selected_text",
            &TextEditor::GetSelectedText, nb::arg("a_cursor") = -1)
        ;
    ////////////////////    </generated_from:TextEditor.h>    ////////////////////

    // </litgen_pydef> // Autogenerated code end
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
}
