// Part of ImGui Bundle - MIT License - Copyright (c) 2022-2024 Pascal Thomet - https://github.com/pthom/imgui_bundle
#include <nanobind/nanobind.h>
#include <nanobind/trampoline.h>
#include <nanobind/stl/array.h>
#include <nanobind/stl/string.h>
#include <nanobind/stl/vector.h>
#include <nanobind/stl/optional.h>
#include <nanobind/stl/function.h>
#include <nanobind/stl/shared_ptr.h>
#include <nanobind/stl/unique_ptr.h>
#include <nanobind/stl/map.h>
#include <nanobind/stl/tuple.h>
#include <nanobind/make_iterator.h>
#include <nanobind/ndarray.h>

#include "imgui-command-palette/imcmd_command_palette.h"
#include "imgui-command-palette-py-wrapper/imgui-command-palette-py-wrapper.h"

namespace nb = nanobind;

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// <litgen_glue_code>  // Autogenerated code below! Do not edit!

// </litgen_glue_code> // Autogenerated code end
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


void py_init_module_imgui_command_palette(nb::module_& m)
{
    using namespace ImCmd;


    // <litgen_pydef> // Autogenerated code start
    ////////////////////    <generated_from:imcmd_command_palette.h>    ////////////////////
    auto pyEnumImCmdTextType =
        nb::enum_<ImCmdTextType>(m, "ImCmdTextType", nb::is_arithmetic(), "")
            .value("regular", ImCmdTextType_Regular, "")
            .value("highlight", ImCmdTextType_Highlight, "")
            .value("count", ImCmdTextType_COUNT, "");


    auto pyEnumImCmdTextFlag =
        nb::enum_<ImCmdTextFlag>(m, "ImCmdTextFlag", nb::is_arithmetic(), "")
            .value("underline", ImCmdTextFlag_Underline, "")
            .value("count", ImCmdTextFlag_COUNT, "");


    auto pyClassCommand =
        nb::class_<ImCmd::Command>
            (m, "Command", "")
        .def(nb::init<>()) // implicit default constructor
        .def_rw("name", &ImCmd::Command::Name, "")
        .def_rw("initial_callback", &ImCmd::Command::InitialCallback, "")
        .def_rw("subsequent_callback", &ImCmd::Command::SubsequentCallback, "")
        .def_rw("terminating_callback", &ImCmd::Command::TerminatingCallback, "")
        ;


    m.def("add_command",
        ImCmd::AddCommand, nb::arg("command"));

    m.def("remove_command",
        ImCmd::RemoveCommand, nb::arg("name"));

    m.def("get_style_flag",
        ImCmd::GetStyleFlag, nb::arg("type"), nb::arg("flag"));

    m.def("set_style_flag",
        ImCmd::SetStyleFlag, nb::arg("type"), nb::arg("flag"), nb::arg("enabled"));

    m.def("get_style_font",
        ImCmd::GetStyleFont, nb::arg("type"));

    m.def("set_style_font",
        ImCmd::SetStyleFont, nb::arg("type"), nb::arg("font"));

    m.def("get_style_color",
        ImCmd::GetStyleColor, nb::arg("type"));

    m.def("set_style_color",
        ImCmd::SetStyleColor, nb::arg("type"), nb::arg("color"));

    m.def("clear_style_color",
        ImCmd::ClearStyleColor,
        nb::arg("type"),
        "< Clear the style color for the given type, defaulting to ImGuiCol_Text");

    m.def("set_next_command_palette_search",
        ImCmd::SetNextCommandPaletteSearch, nb::arg("text"));

    m.def("set_next_command_palette_search_box_focused",
        ImCmd::SetNextCommandPaletteSearchBoxFocused);

    m.def("command_palette",
        ImCmd::CommandPalette, nb::arg("name"));

    m.def("is_any_item_selected",
        ImCmd::IsAnyItemSelected);

    m.def("remove_cache",
        ImCmd::RemoveCache, nb::arg("name"));

    m.def("remove_all_caches",
        ImCmd::RemoveAllCaches);

    m.def("set_next_window_affixed_top",
        ImCmd::SetNextWindowAffixedTop, nb::arg("cond") = 0);

    m.def("command_palette_window",
        [](const char * name, bool p_open) -> bool
        {
            auto CommandPaletteWindow_adapt_modifiable_immutable_to_return = [](const char * name, bool p_open) -> bool
            {
                bool * p_open_adapt_modifiable = & p_open;

                ImCmd::CommandPaletteWindow(name, p_open_adapt_modifiable);
                return p_open;
            };

            return CommandPaletteWindow_adapt_modifiable_immutable_to_return(name, p_open);
        },     nb::arg("name"), nb::arg("p_open"));

    m.def("prompt",
        ImCmd::Prompt,
        nb::arg("options"),
        "Command responses, only call these in command callbacks (except TerminatingCallback)");
    ////////////////////    </generated_from:imcmd_command_palette.h>    ////////////////////


    ////////////////////    <generated_from:imgui-command-palette-py-wrapper.h>    ////////////////////
    auto pyClassContextWrapper =
        nb::class_<ImCmd::ContextWrapper>
            (m, "ContextWrapper", "")
        .def(nb::init<>())
        ;
    ////////////////////    </generated_from:imgui-command-palette-py-wrapper.h>    ////////////////////

    // </litgen_pydef> // Autogenerated code end
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
}
