// Part of ImGui Bundle - MIT License - Copyright (c) 2022-2024 Pascal Thomet - https://github.com/pthom/imgui_bundle
#include <nanobind/nanobind.h>
#include <nanobind/trampoline.h>
#include <nanobind/stl/array.h>
#include <nanobind/stl/string.h>
#include <nanobind/stl/vector.h>
#include <nanobind/stl/optional.h>
#include <nanobind/stl/function.h>
#include <nanobind/stl/shared_ptr.h>
#include <nanobind/stl/unique_ptr.h>
#include <nanobind/stl/map.h>
#include <nanobind/stl/tuple.h>
#include <nanobind/make_iterator.h>
#include <nanobind/ndarray.h>

#include "imgui-knobs/imgui-knobs.h"  // Change this include to the library you are binding

namespace nb = nanobind;

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// <litgen_glue_code>  // Autogenerated code below! Do not edit!

// </litgen_glue_code> // Autogenerated code end
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!



void py_init_module_imgui_knobs(nb::module_& m)
{
    using namespace ImGuiKnobs;

    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // <litgen_pydef> // Autogenerated code below! Do not edit!
    ////////////////////    <generated_from:imgui-knobs.h>    ////////////////////
    auto pyEnumImGuiKnobFlags_ =
        nb::enum_<ImGuiKnobFlags_>(m, "ImGuiKnobFlags_", nb::is_arithmetic(), "")
            .value("no_title", ImGuiKnobFlags_NoTitle, "")
            .value("no_input", ImGuiKnobFlags_NoInput, "")
            .value("value_tooltip", ImGuiKnobFlags_ValueTooltip, "")
            .value("drag_horizontal", ImGuiKnobFlags_DragHorizontal, "")
            .value("drag_vertical", ImGuiKnobFlags_DragVertical, "")
            .value("logarithmic", ImGuiKnobFlags_Logarithmic, "")
            .value("always_clamp", ImGuiKnobFlags_AlwaysClamp, "");


    auto pyEnumImGuiKnobVariant_ =
        nb::enum_<ImGuiKnobVariant_>(m, "ImGuiKnobVariant_", nb::is_arithmetic(), "")
            .value("tick", ImGuiKnobVariant_Tick, "")
            .value("dot", ImGuiKnobVariant_Dot, "")
            .value("wiper", ImGuiKnobVariant_Wiper, "")
            .value("wiper_only", ImGuiKnobVariant_WiperOnly, "")
            .value("wiper_dot", ImGuiKnobVariant_WiperDot, "")
            .value("stepped", ImGuiKnobVariant_Stepped, "")
            .value("space", ImGuiKnobVariant_Space, "");


    auto pyClasscolor_set =
        nb::class_<ImGuiKnobs::color_set>
            (m, "color_set", "")
        .def_rw("base", &ImGuiKnobs::color_set::base, "")
        .def_rw("hovered", &ImGuiKnobs::color_set::hovered, "")
        .def_rw("active", &ImGuiKnobs::color_set::active, "")
        .def(nb::init<ImColor, ImColor, ImColor>(),
            nb::arg("base"), nb::arg("hovered"), nb::arg("active"))
        .def(nb::init<ImColor>(),
            nb::arg("color"))
        ;


    m.def("knob",
        [](const char * label, float p_value, float v_min, float v_max, float speed = 0, const char * format = "%.3f", const std::optional<const ImGuiKnobVariant> & variant = std::nullopt, float size = 0, ImGuiKnobFlags flags = 0, int steps = 10, float angle_min = -1, float angle_max = -1) -> std::tuple<bool, float>
        {
            auto Knob_adapt_mutable_param_with_default_value = [](const char * label, float * p_value, float v_min, float v_max, float speed = 0, const char * format = "%.3f", const std::optional<const ImGuiKnobVariant> & variant = std::nullopt, float size = 0, ImGuiKnobFlags flags = 0, int steps = 10, float angle_min = -1, float angle_max = -1) -> bool
            {

                const ImGuiKnobVariant& variant_or_default = [&]() -> const ImGuiKnobVariant {
                    if (variant.has_value())
                        return variant.value();
                    else
                        return ImGuiKnobVariant_Tick;
                }();

                auto lambda_result = ImGuiKnobs::Knob(label, p_value, v_min, v_max, speed, format, variant_or_default, size, flags, steps, angle_min, angle_max);
                return lambda_result;
            };
            auto Knob_adapt_modifiable_immutable_to_return = [&Knob_adapt_mutable_param_with_default_value](const char * label, float p_value, float v_min, float v_max, float speed = 0, const char * format = "%.3f", const std::optional<const ImGuiKnobVariant> & variant = std::nullopt, float size = 0, ImGuiKnobFlags flags = 0, int steps = 10, float angle_min = -1, float angle_max = -1) -> std::tuple<bool, float>
            {
                float * p_value_adapt_modifiable = & p_value;

                bool r = Knob_adapt_mutable_param_with_default_value(label, p_value_adapt_modifiable, v_min, v_max, speed, format, variant, size, flags, steps, angle_min, angle_max);
                return std::make_tuple(r, p_value);
            };

            return Knob_adapt_modifiable_immutable_to_return(label, p_value, v_min, v_max, speed, format, variant, size, flags, steps, angle_min, angle_max);
        },
        nb::arg("label"), nb::arg("p_value"), nb::arg("v_min"), nb::arg("v_max"), nb::arg("speed") = 0, nb::arg("format") = "%.3f", nb::arg("variant").none() = nb::none(), nb::arg("size") = 0, nb::arg("flags") = 0, nb::arg("steps") = 10, nb::arg("angle_min") = -1, nb::arg("angle_max") = -1,
        "Python bindings defaults:\n    If variant is None, then its default value will be: ImGuiKnobVariant_.tick");

    m.def("knob_int",
        [](const char * label, int p_value, int v_min, int v_max, float speed = 0, const char * format = "%i", const std::optional<const ImGuiKnobVariant> & variant = std::nullopt, float size = 0, ImGuiKnobFlags flags = 0, int steps = 10, float angle_min = -1, float angle_max = -1) -> std::tuple<bool, int>
        {
            auto KnobInt_adapt_mutable_param_with_default_value = [](const char * label, int * p_value, int v_min, int v_max, float speed = 0, const char * format = "%i", const std::optional<const ImGuiKnobVariant> & variant = std::nullopt, float size = 0, ImGuiKnobFlags flags = 0, int steps = 10, float angle_min = -1, float angle_max = -1) -> bool
            {

                const ImGuiKnobVariant& variant_or_default = [&]() -> const ImGuiKnobVariant {
                    if (variant.has_value())
                        return variant.value();
                    else
                        return ImGuiKnobVariant_Tick;
                }();

                auto lambda_result = ImGuiKnobs::KnobInt(label, p_value, v_min, v_max, speed, format, variant_or_default, size, flags, steps, angle_min, angle_max);
                return lambda_result;
            };
            auto KnobInt_adapt_modifiable_immutable_to_return = [&KnobInt_adapt_mutable_param_with_default_value](const char * label, int p_value, int v_min, int v_max, float speed = 0, const char * format = "%i", const std::optional<const ImGuiKnobVariant> & variant = std::nullopt, float size = 0, ImGuiKnobFlags flags = 0, int steps = 10, float angle_min = -1, float angle_max = -1) -> std::tuple<bool, int>
            {
                int * p_value_adapt_modifiable = & p_value;

                bool r = KnobInt_adapt_mutable_param_with_default_value(label, p_value_adapt_modifiable, v_min, v_max, speed, format, variant, size, flags, steps, angle_min, angle_max);
                return std::make_tuple(r, p_value);
            };

            return KnobInt_adapt_modifiable_immutable_to_return(label, p_value, v_min, v_max, speed, format, variant, size, flags, steps, angle_min, angle_max);
        },
        nb::arg("label"), nb::arg("p_value"), nb::arg("v_min"), nb::arg("v_max"), nb::arg("speed") = 0, nb::arg("format") = "%i", nb::arg("variant").none() = nb::none(), nb::arg("size") = 0, nb::arg("flags") = 0, nb::arg("steps") = 10, nb::arg("angle_min") = -1, nb::arg("angle_max") = -1,
        "Python bindings defaults:\n    If variant is None, then its default value will be: ImGuiKnobVariant_.tick");
    ////////////////////    </generated_from:imgui-knobs.h>    ////////////////////

    // </litgen_pydef> // Autogenerated code end
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
}
