"""Markdown for ImGui
Python bindings for https://github.com/mekhontsev/imgui_md (with an additional custom wrapper)
"""

# ruff: noqa: B008
from typing import Optional, Callable
from imgui_bundle.imgui import ImTextureID, ImVec2, ImVec4, ImFont
import numpy as np

# using VoidFunction = std::function<void(void)>;
# using StringFunction = std::function<void(std::string)>;
# using HtmlDivFunction = std::function<void(const std::string& divClass, bool openingDiv)>;
# using MarkdownImageFunction = std::function<std::optional<MarkdownImage>(const std::string&)>;

VoidFunction = Callable[[None], None]
StringFunction = Callable[[str], None]
HtmlDivFunction = Callable[[str, bool], None]
MarkdownImageFunction = Callable[[str], MarkdownImage]

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# <litgen_stub> // Autogenerated code below! Do not edit!
####################    <generated_from:imgui_md_wrapper.h>    ####################

class MarkdownFontOptions:
    font_base_path: str = "fonts/Roboto/Roboto"
    # This size is in density-independent pixels
    regular_size: float = 16.0

    # Multipliers for header sizes, from h1 to h6
    header_size_factors: (
        np.ndarray
    )  # ndarray[type=float, size=6] default:float( 1.42, 1.33, 1.24, 1.15, 1.10, 1.05 )
    def __init__(self) -> None:
        """Autogenerated default constructor"""
        pass

class MarkdownImage:
    texture_id: ImTextureID
    size: ImVec2
    uv0: ImVec2
    uv1: ImVec2
    col_tint: ImVec4
    col_border: ImVec4
    def __init__(self) -> None:
        """Autogenerated default constructor"""
        pass

class SizedFont:
    """Note: Since v1.92, Fonts can be displayed at any size:
    in order to display a font at a given size, we need to call
      ImGui::PushFont(font, size) (or call separately ImGui::PushFontSize)
    """

    font: ImFont
    size: float
    def __init__(self) -> None:
        """Autogenerated default constructor"""
        pass

def on_image_default(image_path: str) -> Optional[MarkdownImage]:
    pass

def on_open_link_default(url: str) -> None:
    pass

class MarkdownCallbacks:
    # The default version will open the link in a browser iif it starts with "http"
    on_open_link: StringFunction = on_open_link_default

    # The default version will load the image as a cached texture and display it
    on_image: MarkdownImageFunction = on_image_default

    # OnHtmlDiv does nothing by default, by you could write:
    #     In  C++:
    #        markdownOptions.callbacks.onHtmlDiv = [](const std::string& divClass, bool openingDiv)
    #        {
    #            if (divClass == "red")
    #            {
    #                if (openingDiv)
    #                    ImGui::PushStyleColor(ImGuiCol_Text, IM_COL32(255, 0, 0, 255));
    #                else
    #                    ImGui::PopStyleColor();
    #            }
    #        };
    #     In  Python:
    #        def on_html_div(div_class: str, opening_div: bool) -> None:
    #            if div_class == 'red':
    #                if opening_div:
    #                    imgui.push_style_color(imgui.Col_.text.value, imgui.ImColor(255, 0, 0, 255).value)
    #                else:
    #                    imgui.pop_style_color()
    #        md_options = imgui_md.MarkdownOptions()
    #        md_options.callbacks.on_html_div = on_html_div
    #        immapp.run(
    #            gui_function=gui, with_markdown_options=md_options #, more options here
    #        )
    on_html_div: HtmlDivFunction
    def __init__(self) -> None:
        """Autogenerated default constructor"""
        pass

class MarkdownOptions:
    font_options: MarkdownFontOptions
    callbacks: MarkdownCallbacks
    def __init__(self) -> None:
        """Autogenerated default constructor"""
        pass

# InitializeMarkdown: Call this once at application startup
# Don't forget to later call GetFontLoaderFunction(): it will return a function that you should call
# during ImGui initialization (and before rendering the first frame, since it will load the fonts)
#
# If using HelloImGui, the code would look like:
#     Python:
#        runner_params = hello_imgui.RunnerParams()
#
#        ... // Fill runner_params callbacks
#
#        # Initialize markdown and ask HelloImGui to load the required fonts
#        imgui_md.initialize_markdown()
#        runner_params.callbacks.load_additional_fonts = imgui_md.get_font_loader_function()
#
#        hello_imgui.run(runner_params)
def initialize_markdown(options: Optional[MarkdownOptions] = None) -> None:
    """Python bindings defaults:
    If options is None, then its default value will be: MarkdownOptions()
    """
    pass

def de_initialize_markdown() -> None:
    pass

def get_font_loader_function() -> VoidFunction:
    """GetFontLoaderFunction() will return a function that you should call during ImGui initialization."""
    pass

def render(markdown_string: str) -> None:
    """Renders a markdown string"""
    pass

def render_unindented(markdown_string: str) -> None:
    """Renders a markdown string (after having unindented its main indentation)"""
    pass

def get_code_font() -> SizedFont:
    pass

class MarkdownFontSpec:
    italic: bool = False
    bold: bool = False
    header_level: int = 0  # 0 means no header, 1 means h1, 2 means h2, etc.

    def __init__(
        self, italic_: bool = False, bold_: bool = False, header_level_: int = 0
    ) -> None:
        pass

def get_font(font_spec: MarkdownFontSpec) -> SizedFont:
    pass

####################    </generated_from:imgui_md_wrapper.h>    ####################

# </litgen_stub> // Autogenerated code end!
