// Part of ImGui Bundle - MIT License - Copyright (c) 2022-2024 Pascal Thomet - https://github.com/pthom/imgui_bundle
#include <nanobind/nanobind.h>
#include <nanobind/stl/string.h>
#include <nanobind/stl/array.h>
#include <nanobind/stl/optional.h>
#include <nanobind/stl/vector.h>
#include <nanobind/stl/function.h>
#include <nanobind/ndarray.h>

#define IMGUI_DEFINE_MATH_OPERATORS
#include "immapp/immapp.h"
#include "immapp/code_utils.h"
#include "immapp/snippets.h"
#include "immapp/immapp_widgets.h"
#ifdef IMGUI_BUNDLE_WITH_IMGUI_NODE_EDITOR
#include "imgui-node-editor/imgui_node_editor_internal.h"



namespace ax
{
    namespace NodeEditor
    {
        // using EditorContext = Detail::EditorContext;
        struct EditorContext: public Detail::EditorContext {};
    }
}
#endif


namespace nb = nanobind;



// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// <litgen_glue_code>  // Autogenerated code below! Do not edit!

// </litgen_glue_code> // Autogenerated code end
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


#include <string>
#include <vector>


void py_init_module_immapp_cpp(nb::module_& m)
{
    using namespace ImmApp;
    using namespace Snippets;

    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // <litgen_pydef> // Autogenerated code below! Do not edit!
    ////////////////////    <generated_from:immapp.h>    ////////////////////
    ////////////////////    </generated_from:immapp.h>    ////////////////////


    ////////////////////    <generated_from:immapp_widgets.h>    ////////////////////
    // #ifdef IMGUI_BUNDLE_WITH_IMPLOT_AND_IMGUI_NODE_EDITOR
    //

    m.def("begin_plot_in_node_editor",
        [](const char * title_id, const std::optional<const ImVec2> & size = std::nullopt, ImPlotFlags flags = 0) -> bool
        {
            auto BeginPlotInNodeEditor_adapt_mutable_param_with_default_value = [](const char * title_id, const std::optional<const ImVec2> & size = std::nullopt, ImPlotFlags flags = 0) -> bool
            {

                const ImVec2& size_or_default = [&]() -> const ImVec2 {
                    if (size.has_value())
                        return size.value();
                    else
                        return ImVec2(-1,0);
                }();

                auto lambda_result = ImmApp::BeginPlotInNodeEditor(title_id, size_or_default, flags);
                return lambda_result;
            };

            return BeginPlotInNodeEditor_adapt_mutable_param_with_default_value(title_id, size, flags);
        },
        nb::arg("title_id"), nb::arg("size").none() = nb::none(), nb::arg("flags") = 0,
        "Python bindings defaults:\n    If size is None, then its default value will be: ImVec2(-1,0)");

    m.def("end_plot_in_node_editor",
        ImmApp::EndPlotInNodeEditor);

    m.def("show_resizable_plot_in_node_editor",
        ImmApp::ShowResizablePlotInNodeEditor,
        nb::arg("title_id"), nb::arg("size_pixels"), nb::arg("plot_function"), nb::arg("flags") = 0, nb::arg("resize_handle_size_em") = 1.0f,
        " ShowResizablePlotInNodeEditor: shows a resizable plot inside a node\n Returns the new size of the plot");

    m.def("show_resizable_plot_in_node_editor_em",
        ImmApp::ShowResizablePlotInNodeEditor_Em,
        nb::arg("title_id"), nb::arg("size_em"), nb::arg("plot_function"), nb::arg("flags") = 0, nb::arg("resize_handle_size_em") = 1.0f,
        " ShowResizablePlotInNodeEditor_Em: shows a resizable plot inside a node\n Returns the new size of the plot. Units are in em.");
    // #endif
    // #ifdef IMGUI_BUNDLE_WITH_IMGUI_NODE_EDITOR
    //

    m.def("widget_with_resize_handle_in_node_editor",
        ImmApp::WidgetWithResizeHandle_InNodeEditor,
        nb::arg("id"), nb::arg("gui_function"), nb::arg("resize_handle_size_em") = 1.0f,
        " WidgetWithResizeHandle_InNodeEditor: shows a resizable widget inside a node\n Returns the new size of the widget.");

    m.def("widget_with_resize_handle_in_node_editor_em",
        ImmApp::WidgetWithResizeHandle_InNodeEditor_Em,
        nb::arg("id"), nb::arg("gui_function"), nb::arg("resize_handle_size_em") = 1.0f,
        " WidgetWithResizeHandle_InNodeEditor_Em: shows a resizable widget inside a node\n Returns the new size of the widget. Size is in em.");
    // #endif
    ////////////////////    </generated_from:immapp_widgets.h>    ////////////////////


    ////////////////////    <generated_from:runner.h>    ////////////////////
    // #ifdef IMGUI_BUNDLE_WITH_IMGUI_NODE_EDITOR
    //
    // #endif
    //


    // #ifdef IMGUI_BUNDLE_WITH_IMGUI_NODE_EDITOR
    //
    // #endif
    //


    auto pyClassAddOnsParams =
        nb::class_<ImmApp::AddOnsParams>
            (m, "AddOnsParams", "///////////////////////////////////////////////////////////////////////////////////////\n\n AddOnParams: require specific ImGuiBundle packages (markdown, node editor, texture viewer)\n to be initialized at startup.\n\n/////////////////////////////////////////////////////////////////////////////////////")
        .def("__init__", [](ImmApp::AddOnsParams * self, bool withImplot = false, bool withImplot3d = false, bool withMarkdown = false, bool withNodeEditor = false, bool withTexInspect = false, std::optional<NodeEditorConfig> withNodeEditorConfig = std::nullopt, bool updateNodeEditorColorsFromImguiColors = true, std::optional<ImGuiMd::MarkdownOptions> withMarkdownOptions = std::nullopt)
        {
            new (self) ImmApp::AddOnsParams();  // placement new
            auto r_ctor_ = self;
            r_ctor_->withImplot = withImplot;
            r_ctor_->withImplot3d = withImplot3d;
            r_ctor_->withMarkdown = withMarkdown;
            r_ctor_->withNodeEditor = withNodeEditor;
            r_ctor_->withTexInspect = withTexInspect;
            r_ctor_->withNodeEditorConfig = withNodeEditorConfig;
            r_ctor_->updateNodeEditorColorsFromImguiColors = updateNodeEditorColorsFromImguiColors;
            r_ctor_->withMarkdownOptions = withMarkdownOptions;
        },
        nb::arg("with_implot") = false, nb::arg("with_implot3d") = false, nb::arg("with_markdown") = false, nb::arg("with_node_editor") = false, nb::arg("with_tex_inspect") = false, nb::arg("with_node_editor_config").none() = nb::none(), nb::arg("update_node_editor_colors_from_imgui_colors") = true, nb::arg("with_markdown_options").none() = nb::none()
        )
        .def_rw("with_implot", &ImmApp::AddOnsParams::withImplot, "Set withImplot=True if you need to plot graphs with implot")
        .def_rw("with_implot3d", &ImmApp::AddOnsParams::withImplot3d, "Set withImplot3=True if you need to plot 3 graphs with implot3")
        .def_rw("with_markdown", &ImmApp::AddOnsParams::withMarkdown, " Set withMarkdown=True if you need to render Markdown\n (alternatively, you can set withMarkdownOptions)")
        .def_rw("with_node_editor", &ImmApp::AddOnsParams::withNodeEditor, " Set withNodeEditor=True if you need to render a node editor\n (alternatively, you can set withNodeEditorConfig)")
        .def_rw("with_tex_inspect", &ImmApp::AddOnsParams::withTexInspect, "Set withTexInspect=True if you need to use imgui_tex_inspect")
        // #ifdef IMGUI_BUNDLE_WITH_IMGUI_NODE_EDITOR
        //
        .def_rw("with_node_editor_config", &ImmApp::AddOnsParams::withNodeEditorConfig, "You can tweak NodeEditorConfig (but this is optional)")
        .def_rw("update_node_editor_colors_from_imgui_colors", &ImmApp::AddOnsParams::updateNodeEditorColorsFromImguiColors, " If True, the node editor colors will be updated from the ImGui colors\n (i.e. if using a light theme, the node editor will use a light theme, etc.)\n This is called after runnerParams.callbacks.SetupImGuiStyle, in which you can set the ImGui style.\n If you set this to False, you can set the node editor style manually.\n (Note: you can also the theme via RunnerParams.imguiParams.tweakedTheme)")
        // #endif
        //
        .def_rw("with_markdown_options", &ImmApp::AddOnsParams::withMarkdownOptions, "You can tweak MarkdownOptions (but this is optional)")
        ;


    m.def("run",
        [](HelloImGui::RunnerParams & runnerParams, const std::optional<const ImmApp::AddOnsParams> & addOnsParams = std::nullopt)
        {
            auto Run_adapt_mutable_param_with_default_value = [](HelloImGui::RunnerParams & runnerParams, const std::optional<const ImmApp::AddOnsParams> & addOnsParams = std::nullopt)
            {

                const ImmApp::AddOnsParams& addOnsParams_or_default = [&]() -> const ImmApp::AddOnsParams {
                    if (addOnsParams.has_value())
                        return addOnsParams.value();
                    else
                        return ImmApp::AddOnsParams();
                }();

                ImmApp::Run(runnerParams, addOnsParams_or_default);
            };

            Run_adapt_mutable_param_with_default_value(runnerParams, addOnsParams);
        },
        nb::arg("runner_params"), nb::arg("add_ons_params").none() = nb::none(),
        "Python bindings defaults:\n    If addOnsParams is None, then its default value will be: AddOnsParams()");

    m.def("run",
        [](const HelloImGui::SimpleRunnerParams & simpleParams, const std::optional<const ImmApp::AddOnsParams> & addOnsParams = std::nullopt)
        {
            auto Run_adapt_mutable_param_with_default_value = [](const HelloImGui::SimpleRunnerParams & simpleParams, const std::optional<const ImmApp::AddOnsParams> & addOnsParams = std::nullopt)
            {

                const ImmApp::AddOnsParams& addOnsParams_or_default = [&]() -> const ImmApp::AddOnsParams {
                    if (addOnsParams.has_value())
                        return addOnsParams.value();
                    else
                        return ImmApp::AddOnsParams();
                }();

                ImmApp::Run(simpleParams, addOnsParams_or_default);
            };

            Run_adapt_mutable_param_with_default_value(simpleParams, addOnsParams);
        },
        nb::arg("simple_params"), nb::arg("add_ons_params").none() = nb::none(),
        "Python bindings defaults:\n    If addOnsParams is None, then its default value will be: AddOnsParams()");

    m.def("run",
        [](const VoidFunction & guiFunction, const std::string & windowTitle = "", bool windowSizeAuto = false, bool windowRestorePreviousGeometry = false, const std::optional<const ScreenSize> & windowSize = std::nullopt, float fpsIdle = 10.f, bool withImplot = false, bool withImplot3d = false, bool withMarkdown = false, bool withNodeEditor = false, bool withTexInspect = false, const std::optional<NodeEditorConfig> & withNodeEditorConfig = std::nullopt, const std::optional<ImGuiMd::MarkdownOptions> & withMarkdownOptions = std::nullopt)
        {
            auto Run_adapt_mutable_param_with_default_value = [](const VoidFunction & guiFunction, const std::string & windowTitle = "", bool windowSizeAuto = false, bool windowRestorePreviousGeometry = false, const std::optional<const ScreenSize> & windowSize = std::nullopt, float fpsIdle = 10.f, bool withImplot = false, bool withImplot3d = false, bool withMarkdown = false, bool withNodeEditor = false, bool withTexInspect = false, const std::optional<NodeEditorConfig> & withNodeEditorConfig = std::nullopt, const std::optional<ImGuiMd::MarkdownOptions> & withMarkdownOptions = std::nullopt)
            {

                const ScreenSize& windowSize_or_default = [&]() -> const ScreenSize {
                    if (windowSize.has_value())
                        return windowSize.value();
                    else
                        return DefaultWindowSize;
                }();

                ImmApp::Run(guiFunction, windowTitle, windowSizeAuto, windowRestorePreviousGeometry, windowSize_or_default, fpsIdle, withImplot, withImplot3d, withMarkdown, withNodeEditor, withTexInspect, withNodeEditorConfig, withMarkdownOptions);
            };

            Run_adapt_mutable_param_with_default_value(guiFunction, windowTitle, windowSizeAuto, windowRestorePreviousGeometry, windowSize, fpsIdle, withImplot, withImplot3d, withMarkdown, withNodeEditor, withTexInspect, withNodeEditorConfig, withMarkdownOptions);
        },
        nb::arg("gui_function"), nb::arg("window_title") = "", nb::arg("window_size_auto") = false, nb::arg("window_restore_previous_geometry") = false, nb::arg("window_size").none() = nb::none(), nb::arg("fps_idle") = 10.f, nb::arg("with_implot") = false, nb::arg("with_implot3d") = false, nb::arg("with_markdown") = false, nb::arg("with_node_editor") = false, nb::arg("with_tex_inspect") = false, nb::arg("with_node_editor_config").none() = nb::none(), nb::arg("with_markdown_options").none() = nb::none(),
        "///////////////////////////////////////////////////////////////////////////////////////\n\n Helpers to run an app from Python (using named parameters)\n\n/////////////////////////////////////////////////////////////////////////////////////\n Helper to run an app inside imgui_bundle, using HelloImGui:\n\n (HelloImGui::SimpleRunnerParams)\n     - `guiFunction`: the function that will render the ImGui widgets\n     - `windowTitle`: title of the window\n     - `windowSizeAuto`: if True, autosize the window from its inner widgets\n     - `windowRestorePreviousGeometry`: if True, restore window size and position from last run\n     - `windowSize`: size of the window\n     - `fpsIdle`: fps of the application when idle\n\n (ImmApp::AddOnsParams)\n     - `with_implot`: if True, then a context for implot will be created/destroyed automatically\n     - `with_markdown` / `with_markdown_options`: if specified, then  the markdown context will be initialized\n       (i.e. required fonts will be loaded)\n     - `with_node_editor` / `with_node_editor_config`: if specified, then a context for imgui_node_editor\n       will be created automatically.\n\n\nPython bindings defaults:\n    If windowSize is None, then its default value will be: DefaultWindowSize");

    m.def("run_with_markdown",
        [](const VoidFunction & guiFunction, const std::string & windowTitle = "", bool windowSizeAuto = false, bool windowRestorePreviousGeometry = false, const std::optional<const ScreenSize> & windowSize = std::nullopt, float fpsIdle = 10.f, bool withImplot = false, bool withImplot3d = false, bool withNodeEditor = false, bool withTexInspect = false, const std::optional<NodeEditorConfig> & withNodeEditorConfig = std::nullopt, const std::optional<ImGuiMd::MarkdownOptions> & withMarkdownOptions = std::nullopt)
        {
            auto RunWithMarkdown_adapt_mutable_param_with_default_value = [](const VoidFunction & guiFunction, const std::string & windowTitle = "", bool windowSizeAuto = false, bool windowRestorePreviousGeometry = false, const std::optional<const ScreenSize> & windowSize = std::nullopt, float fpsIdle = 10.f, bool withImplot = false, bool withImplot3d = false, bool withNodeEditor = false, bool withTexInspect = false, const std::optional<NodeEditorConfig> & withNodeEditorConfig = std::nullopt, const std::optional<ImGuiMd::MarkdownOptions> & withMarkdownOptions = std::nullopt)
            {

                const ScreenSize& windowSize_or_default = [&]() -> const ScreenSize {
                    if (windowSize.has_value())
                        return windowSize.value();
                    else
                        return DefaultWindowSize;
                }();

                ImmApp::RunWithMarkdown(guiFunction, windowTitle, windowSizeAuto, windowRestorePreviousGeometry, windowSize_or_default, fpsIdle, withImplot, withImplot3d, withNodeEditor, withTexInspect, withNodeEditorConfig, withMarkdownOptions);
            };

            RunWithMarkdown_adapt_mutable_param_with_default_value(guiFunction, windowTitle, windowSizeAuto, windowRestorePreviousGeometry, windowSize, fpsIdle, withImplot, withImplot3d, withNodeEditor, withTexInspect, withNodeEditorConfig, withMarkdownOptions);
        },
        nb::arg("gui_function"), nb::arg("window_title") = "", nb::arg("window_size_auto") = false, nb::arg("window_restore_previous_geometry") = false, nb::arg("window_size").none() = nb::none(), nb::arg("fps_idle") = 10.f, nb::arg("with_implot") = false, nb::arg("with_implot3d") = false, nb::arg("with_node_editor") = false, nb::arg("with_tex_inspect") = false, nb::arg("with_node_editor_config").none() = nb::none(), nb::arg("with_markdown_options").none() = nb::none(),
        " Run an application with markdown\n\n\nPython bindings defaults:\n    If windowSize is None, then its default value will be: DefaultWindowSize");

    m.def("em_size",
        nb::overload_cast<>(ImmApp::EmSize), " EmSize() returns the visible font size on the screen. For good results on HighDPI screens, always scale your\n widgets and windows relatively to this size.\n It is somewhat comparable to the [em CSS Unit](https://lyty.dev/css/css-unit.html).\n EmSize() = ImGui::GetFontSize()");

    m.def("em_size",
        nb::overload_cast<float>(ImmApp::EmSize),
        nb::arg("nb_lines"),
        "EmSize(nbLines) returns a size corresponding to nbLines text lines");

    m.def("em_to_vec2",
        nb::overload_cast<float, float>(ImmApp::EmToVec2), nb::arg("x"), nb::arg("y"));

    m.def("em_to_vec2",
        nb::overload_cast<ImVec2>(ImmApp::EmToVec2), nb::arg("v"));

    m.def("pixels_to_em",
        ImmApp::PixelsToEm,
        nb::arg("pixels"),
        "PixelsToEm() converts a Vec2 in pixels to a Vec2 in em");

    m.def("pixel_size_to_em",
        ImmApp::PixelSizeToEm,
        nb::arg("pixel_size"),
        "PixelSizeToEm() converts a size in pixels to a size in em");
    // #ifdef IMGUI_BUNDLE_WITH_IMGUI_NODE_EDITOR
    //

    m.def("default_node_editor_context",
        ImmApp::DefaultNodeEditorContext, nb::rv_policy::reference);

    m.def("default_node_editor_config",
        ImmApp::DefaultNodeEditorConfig, nb::rv_policy::reference);

    m.def("node_editor_settings_location",
        ImmApp::NodeEditorSettingsLocation,
        nb::arg("runner_params"),
        "NodeEditorSettingsLocation returns the path to the json file for the node editor settings.");

    m.def("has_node_editor_settings",
        ImmApp::HasNodeEditorSettings,
        nb::arg("runner_params"),
        "HasNodeEditorSettings returns True if the json file for the node editor settings exists.");

    m.def("delete_node_editor_settings",
        ImmApp::DeleteNodeEditorSettings,
        nb::arg("runner_params"),
        "DeleteNodeEditorSettings deletes the json file for the node editor settings.");
    // #endif
    //

    { // <namespace ManualRender>
        nb::module_ pyNsManualRender = m.def_submodule("manual_render", "namespace ManualRender");
        pyNsManualRender.def("setup_from_runner_params",
            [](const HelloImGui::RunnerParams & runnerParams, const std::optional<const ImmApp::AddOnsParams> & addOnsParams = std::nullopt)
            {
                auto SetupFromRunnerParams_adapt_mutable_param_with_default_value = [](const HelloImGui::RunnerParams & runnerParams, const std::optional<const ImmApp::AddOnsParams> & addOnsParams = std::nullopt)
                {

                    const ImmApp::AddOnsParams& addOnsParams_or_default = [&]() -> const ImmApp::AddOnsParams {
                        if (addOnsParams.has_value())
                            return addOnsParams.value();
                        else
                            return ImmApp::AddOnsParams();
                    }();

                    ImmApp::ManualRender::SetupFromRunnerParams(runnerParams, addOnsParams_or_default);
                };

                SetupFromRunnerParams_adapt_mutable_param_with_default_value(runnerParams, addOnsParams);
            },
            nb::arg("runner_params"), nb::arg("add_ons_params").none() = nb::none(),
            " Initializes the rendering with the full customizable `RunnerParams`.\n This will initialize the platform backend (SDL, Glfw, etc.) and the rendering backend (OpenGL, Vulkan, etc.).\n A distinct copy of `RunnerParams` is stored internally.\n\n\nPython bindings defaults:\n    If addOnsParams is None, then its default value will be: AddOnsParams()");

        pyNsManualRender.def("setup_from_simple_runner_params",
            [](const HelloImGui::SimpleRunnerParams & simpleParams, const std::optional<const ImmApp::AddOnsParams> & addOnsParams = std::nullopt)
            {
                auto SetupFromSimpleRunnerParams_adapt_mutable_param_with_default_value = [](const HelloImGui::SimpleRunnerParams & simpleParams, const std::optional<const ImmApp::AddOnsParams> & addOnsParams = std::nullopt)
                {

                    const ImmApp::AddOnsParams& addOnsParams_or_default = [&]() -> const ImmApp::AddOnsParams {
                        if (addOnsParams.has_value())
                            return addOnsParams.value();
                        else
                            return ImmApp::AddOnsParams();
                    }();

                    ImmApp::ManualRender::SetupFromSimpleRunnerParams(simpleParams, addOnsParams_or_default);
                };

                SetupFromSimpleRunnerParams_adapt_mutable_param_with_default_value(simpleParams, addOnsParams);
            },
            nb::arg("simple_params"), nb::arg("add_ons_params").none() = nb::none(),
            " Initializes the rendering with `SimpleRunnerParams`.\n This will initialize the platform backend (SDL, Glfw, etc.) and the rendering backend (OpenGL, Vulkan, etc.).\n\n\nPython bindings defaults:\n    If addOnsParams is None, then its default value will be: AddOnsParams()");

        pyNsManualRender.def("setup_from_gui_function",
            [](const VoidFunction & guiFunction, const std::string & windowTitle = "", bool windowSizeAuto = false, bool windowRestorePreviousGeometry = false, const std::optional<const ScreenSize> & windowSize = std::nullopt, float fpsIdle = 10.f, bool withImplot = false, bool withImplot3d = false, bool withMarkdown = false, bool withNodeEditor = false, bool withTexInspect = false, const std::optional<NodeEditorConfig> & withNodeEditorConfig = std::nullopt, const std::optional<ImGuiMd::MarkdownOptions> & withMarkdownOptions = std::nullopt)
            {
                auto SetupFromGuiFunction_adapt_mutable_param_with_default_value = [](const VoidFunction & guiFunction, const std::string & windowTitle = "", bool windowSizeAuto = false, bool windowRestorePreviousGeometry = false, const std::optional<const ScreenSize> & windowSize = std::nullopt, float fpsIdle = 10.f, bool withImplot = false, bool withImplot3d = false, bool withMarkdown = false, bool withNodeEditor = false, bool withTexInspect = false, const std::optional<NodeEditorConfig> & withNodeEditorConfig = std::nullopt, const std::optional<ImGuiMd::MarkdownOptions> & withMarkdownOptions = std::nullopt)
                {

                    const ScreenSize& windowSize_or_default = [&]() -> const ScreenSize {
                        if (windowSize.has_value())
                            return windowSize.value();
                        else
                            return DefaultWindowSize;
                    }();

                    ImmApp::ManualRender::SetupFromGuiFunction(guiFunction, windowTitle, windowSizeAuto, windowRestorePreviousGeometry, windowSize_or_default, fpsIdle, withImplot, withImplot3d, withMarkdown, withNodeEditor, withTexInspect, withNodeEditorConfig, withMarkdownOptions);
                };

                SetupFromGuiFunction_adapt_mutable_param_with_default_value(guiFunction, windowTitle, windowSizeAuto, windowRestorePreviousGeometry, windowSize, fpsIdle, withImplot, withImplot3d, withMarkdown, withNodeEditor, withTexInspect, withNodeEditorConfig, withMarkdownOptions);
            },
            nb::arg("gui_function"), nb::arg("window_title") = "", nb::arg("window_size_auto") = false, nb::arg("window_restore_previous_geometry") = false, nb::arg("window_size").none() = nb::none(), nb::arg("fps_idle") = 10.f, nb::arg("with_implot") = false, nb::arg("with_implot3d") = false, nb::arg("with_markdown") = false, nb::arg("with_node_editor") = false, nb::arg("with_tex_inspect") = false, nb::arg("with_node_editor_config").none() = nb::none(), nb::arg("with_markdown_options").none() = nb::none(),
            " Initializes the renderer with a simple GUI function and additional parameters.\n This will initialize the platform backend (SDL, Glfw, etc.) and the rendering backend (OpenGL, Vulkan, etc.).\n\n\nPython bindings defaults:\n    If windowSize is None, then its default value will be: DefaultWindowSize");

        pyNsManualRender.def("render",
            ImmApp::ManualRender::Render, "Renders the current frame. Should be called regularly to maintain the application's responsiveness.");

        pyNsManualRender.def("tear_down",
            ImmApp::ManualRender::TearDown, " Tears down the renderer and releases all associated resources.\n This will release the platform backend (SDL, Glfw, etc.) and the rendering backend (OpenGL, Vulkan, etc.).\n After calling `TearDown()`, the InitFromXXX can be called with new parameters.");
    } // </namespace ManualRender>
    ////////////////////    </generated_from:runner.h>    ////////////////////


    ////////////////////    <generated_from:clock.h>    ////////////////////
    m.def("clock_seconds",
        ImmApp::ClockSeconds, "Chronometer in seconds");
    ////////////////////    </generated_from:clock.h>    ////////////////////


    ////////////////////    <generated_from:code_utils.h>    ////////////////////

    { // <namespace CodeUtils>
        nb::module_ pyNsCodeUtils = m.def_submodule("code_utils", "namespace CodeUtils");
        pyNsCodeUtils.def("unindent",
            CodeUtils::Unindent, nb::arg("code"), nb::arg("is_markdown"));

        pyNsCodeUtils.def("unindent_code",
            CodeUtils::UnindentCode, nb::arg("code"));

        pyNsCodeUtils.def("unindent_markdown",
            CodeUtils::UnindentMarkdown, nb::arg("code"));
    } // </namespace CodeUtils>
    ////////////////////    </generated_from:code_utils.h>    ////////////////////


    ////////////////////    <generated_from:snippets.h>    ////////////////////

    { // <namespace Snippets>
        nb::module_ pyNsSnippets = m.def_submodule("snippets", "");
        auto pyEnumSnippetLanguage =
            nb::enum_<Snippets::SnippetLanguage>(pyNsSnippets, "SnippetLanguage", nb::is_arithmetic(), "")
                .value("cpp", Snippets::SnippetLanguage::Cpp, "")
                .value("hlsl", Snippets::SnippetLanguage::Hlsl, "")
                .value("glsl", Snippets::SnippetLanguage::Glsl, "")
                .value("c", Snippets::SnippetLanguage::C, "")
                .value("sql", Snippets::SnippetLanguage::Sql, "")
                .value("angel_script", Snippets::SnippetLanguage::AngelScript, "")
                .value("lua", Snippets::SnippetLanguage::Lua, "")
                .value("python", Snippets::SnippetLanguage::Python, "");


        auto pyEnumSnippetTheme =
            nb::enum_<Snippets::SnippetTheme>(pyNsSnippets, "SnippetTheme", nb::is_arithmetic(), "")
                .value("dark", Snippets::SnippetTheme::Dark, "")
                .value("light", Snippets::SnippetTheme::Light, "")
                .value("retro_blue", Snippets::SnippetTheme::RetroBlue, "")
                .value("mariana", Snippets::SnippetTheme::Mariana, "");


        pyNsSnippets.def("default_snippet_language",
            Snippets::DefaultSnippetLanguage, "DefaultSnippetLanguage will be Cpp or Python if using python bindings.");


        auto pyNsSnippets_ClassSnippetData =
            nb::class_<Snippets::SnippetData>
                (pyNsSnippets, "SnippetData", "")
            .def("__init__", [](Snippets::SnippetData * self, std::string Code = "", Snippets::SnippetLanguage Language = Snippets::DefaultSnippetLanguage(), Snippets::SnippetTheme Palette = Snippets::SnippetTheme::Light, bool ShowCopyButton = true, bool ShowCursorPosition = true, std::string DisplayedFilename = {}, int HeightInLines = 0, int MaxHeightInLines = 40, bool ReadOnly = false, bool Border = false, bool DeIndentCode = true, bool AddFinalEmptyLine = false)
            {
                new (self) Snippets::SnippetData();  // placement new
                auto r_ctor_ = self;
                r_ctor_->Code = Code;
                r_ctor_->Language = Language;
                r_ctor_->Palette = Palette;
                r_ctor_->ShowCopyButton = ShowCopyButton;
                r_ctor_->ShowCursorPosition = ShowCursorPosition;
                r_ctor_->DisplayedFilename = DisplayedFilename;
                r_ctor_->HeightInLines = HeightInLines;
                r_ctor_->MaxHeightInLines = MaxHeightInLines;
                r_ctor_->ReadOnly = ReadOnly;
                r_ctor_->Border = Border;
                r_ctor_->DeIndentCode = DeIndentCode;
                r_ctor_->AddFinalEmptyLine = AddFinalEmptyLine;
            },
            nb::arg("code") = "", nb::arg("language") = Snippets::DefaultSnippetLanguage(), nb::arg("palette") = Snippets::SnippetTheme::Light, nb::arg("show_copy_button") = true, nb::arg("show_cursor_position") = true, nb::arg("displayed_filename") = std::string{}, nb::arg("height_in_lines") = 0, nb::arg("max_height_in_lines") = 40, nb::arg("read_only") = false, nb::arg("border") = false, nb::arg("de_indent_code") = true, nb::arg("add_final_empty_line") = false
            )
            .def_rw("code", &Snippets::SnippetData::Code, "")
            .def_rw("language", &Snippets::SnippetData::Language, "")
            .def_rw("palette", &Snippets::SnippetData::Palette, "")
            .def_rw("show_copy_button", &Snippets::SnippetData::ShowCopyButton, "Displayed on top of the editor (Top Right corner)")
            .def_rw("show_cursor_position", &Snippets::SnippetData::ShowCursorPosition, "Show line and column number")
            .def_rw("displayed_filename", &Snippets::SnippetData::DisplayedFilename, "Displayed on top of the editor")
            .def_rw("height_in_lines", &Snippets::SnippetData::HeightInLines, "Number of visible lines in the editor")
            .def_rw("max_height_in_lines", &Snippets::SnippetData::MaxHeightInLines, "If the number of lines in the code exceeds this, the editor will scroll. Set to 0 to disable.")
            .def_rw("read_only", &Snippets::SnippetData::ReadOnly, "Snippets are read-only by default")
            .def_rw("border", &Snippets::SnippetData::Border, "Draw a border around the editor")
            .def_rw("de_indent_code", &Snippets::SnippetData::DeIndentCode, "Keep the code indentation, but remove main indentation,")
            .def_rw("add_final_empty_line", &Snippets::SnippetData::AddFinalEmptyLine, "Add an empty line at the end of the code if missing")
            ;


        pyNsSnippets.def("show_editable_code_snippet",
            Snippets::ShowEditableCodeSnippet, nb::arg("label_id"), nb::arg("snippet_data"), nb::arg("width") = 0.f, nb::arg("override_height_in_lines") = 0);

        pyNsSnippets.def("show_code_snippet",
            Snippets::ShowCodeSnippet, nb::arg("snippet_data"), nb::arg("width") = 0.f, nb::arg("override_height_in_lines") = 0);

        pyNsSnippets.def("show_side_by_side_snippets",
            nb::overload_cast<const Snippets::SnippetData &, const Snippets::SnippetData &, bool, bool>(Snippets::ShowSideBySideSnippets), nb::arg("snippet1"), nb::arg("snippet2"), nb::arg("hide_if_empty") = true, nb::arg("equal_visible_lines") = true);

        pyNsSnippets.def("show_side_by_side_snippets",
            nb::overload_cast<const std::vector<Snippets::SnippetData> &, bool, bool>(Snippets::ShowSideBySideSnippets), nb::arg("snippets"), nb::arg("hide_if_empty") = true, nb::arg("equal_visible_lines") = true);
    } // </namespace Snippets>
    ////////////////////    </generated_from:snippets.h>    ////////////////////

    // </litgen_pydef> // Autogenerated code end
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
}
