// Part of ImGui Bundle - MIT License - Copyright (c) 2022-2024 Pascal Thomet - https://github.com/pthom/imgui_bundle
#ifdef IMGUI_BUNDLE_WITH_IMPLOT
#include <nanobind/nanobind.h>
#include <nanobind/stl/string.h>
#include <nanobind/stl/array.h>
#include <nanobind/stl/optional.h>
#include <nanobind/stl/vector.h>
#include <nanobind/stl/function.h>
#include <nanobind/ndarray.h>

#include "imgui.h"
#include "implot/implot.h"
#include "implot/implot_internal.h"


namespace nb = nanobind;

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// <litgen_glue_code>  // Autogenerated code below! Do not edit!

// </litgen_glue_code> // Autogenerated code end
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


void py_init_module_implot_internal(nb::module_& m)
{
    using namespace ImPlot;
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // <litgen_pydef> // Autogenerated code below! Do not edit!
    ////////////////////    <generated_from:implot_internal.h>    ////////////////////
    // #ifndef IMGUI_DISABLE
    //
    // #ifdef IMGUI_BUNDLE_PYTHON_API
    //
    // #endif
    //

    m.def("im_log10",
        nb::overload_cast<float>(ImLog10),
        nb::arg("x"),
        "(private API)");

    m.def("im_log10",
        nb::overload_cast<double>(ImLog10),
        nb::arg("x"),
        "(private API)");

    m.def("im_sinh",
        nb::overload_cast<float>(ImSinh),
        nb::arg("x"),
        "(private API)");

    m.def("im_sinh",
        nb::overload_cast<double>(ImSinh),
        nb::arg("x"),
        "(private API)");

    m.def("im_asinh",
        nb::overload_cast<float>(ImAsinh),
        nb::arg("x"),
        "(private API)");

    m.def("im_asinh",
        nb::overload_cast<double>(ImAsinh),
        nb::arg("x"),
        "(private API)");

    m.def("im_pos_mod",
        ImPosMod,
        nb::arg("l"), nb::arg("r"),
        " Returns always positive modulo (assumes r != 0)\n(private API)");

    m.def("im_nan",
        ImNan,
        nb::arg("val"),
        " Returns True if val is NAN\n(private API)");

    m.def("im_nan_or_inf",
        ImNanOrInf,
        nb::arg("val"),
        " Returns True if val is NAN or INFINITY\n(private API)");

    m.def("im_constrain_nan",
        ImConstrainNan,
        nb::arg("val"),
        " Turns NANs to 0s\n(private API)");

    m.def("im_constrain_inf",
        ImConstrainInf,
        nb::arg("val"),
        " Turns infinity to floating point maximums\n(private API)");

    m.def("im_constrain_log",
        ImConstrainLog,
        nb::arg("val"),
        " Turns numbers less than or equal to 0 to 0.001 (sort of arbitrary, is there a better way?)\n(private API)");

    m.def("im_constrain_time",
        ImConstrainTime,
        nb::arg("val"),
        " Turns numbers less than 0 to zero\n(private API)");

    m.def("im_almost_equal",
        ImAlmostEqual,
        nb::arg("v1"), nb::arg("v2"), nb::arg("ulp") = 2,
        " True if two numbers are approximately equal using units in the last place.\n(private API)");

    m.def("im_mix_u32",
        ImMixU32,
        nb::arg("a"), nb::arg("b"), nb::arg("s"),
        " Mix color a and b by factor s in [0 256]\n(private API)");

    m.def("im_lerp_u32",
        ImLerpU32,
        nb::arg("colors"), nb::arg("size"), nb::arg("t"),
        " Lerp across an array of 32-bit collors given t in [0.0 1.0]\n(private API)");

    m.def("im_alpha_u32",
        ImAlphaU32,
        nb::arg("col"), nb::arg("alpha"),
        " Set alpha channel of 32-bit color from float in range [0.0 1.0]\n(private API)");


    auto pyEnumTimeUnit_ =
        nb::enum_<ImPlotTimeUnit_>(m, "TimeUnit_", nb::is_arithmetic(), nb::is_flag(), "")
            .value("us", ImPlotTimeUnit_Us, "microsecond")
            .value("ms", ImPlotTimeUnit_Ms, "millisecond")
            .value("s", ImPlotTimeUnit_S, "second")
            .value("min", ImPlotTimeUnit_Min, "minute")
            .value("hr", ImPlotTimeUnit_Hr, "hour")
            .value("day", ImPlotTimeUnit_Day, "day")
            .value("mo", ImPlotTimeUnit_Mo, "month")
            .value("yr", ImPlotTimeUnit_Yr, "year")
            .value("count", ImPlotTimeUnit_COUNT, "");


    auto pyEnumDateFmt_ =
        nb::enum_<ImPlotDateFmt_>(m, "DateFmt_", nb::is_arithmetic(), nb::is_flag(), "")
            .value("none", ImPlotDateFmt_None, "")
            .value("day_mo", ImPlotDateFmt_DayMo, "10/3           [ --10-03      ]")
            .value("day_mo_yr", ImPlotDateFmt_DayMoYr, "10/3/91        [ 1991-10-03   ]")
            .value("mo_yr", ImPlotDateFmt_MoYr, "Oct 1991       [ 1991-10      ]")
            .value("mo", ImPlotDateFmt_Mo, "Oct            [ --10         ]")
            .value("yr", ImPlotDateFmt_Yr, "1991           [ 1991         ]");


    auto pyEnumTimeFmt_ =
        nb::enum_<ImPlotTimeFmt_>(m, "TimeFmt_", nb::is_arithmetic(), nb::is_flag(), "")
            .value("none", ImPlotTimeFmt_None, "")
            .value("us", ImPlotTimeFmt_Us, ".428 552       [ .428 552     ]")
            .value("s_us", ImPlotTimeFmt_SUs, ":29.428 552    [ :29.428 552  ]")
            .value("s_ms", ImPlotTimeFmt_SMs, ":29.428        [ :29.428      ]")
            .value("s", ImPlotTimeFmt_S, ":29            [ :29          ]")
            .value("min_s_ms", ImPlotTimeFmt_MinSMs, "21:29.428      [ 21:29.428    ]")
            .value("hr_min_s_ms", ImPlotTimeFmt_HrMinSMs, "7:21:29.428pm  [ 19:21:29.428 ]")
            .value("hr_min_s", ImPlotTimeFmt_HrMinS, "7:21:29pm      [ 19:21:29     ]")
            .value("hr_min", ImPlotTimeFmt_HrMin, "7:21pm         [ 19:21        ]")
            .value("hr", ImPlotTimeFmt_Hr, "7pm            [ 19:00        ]");


    auto pyClassImPlotDateTimeSpec =
        nb::class_<ImPlotDateTimeSpec>
            (m, "DateTimeSpec", "Combined date/time format spec")
        .def(nb::init<>())
        .def(nb::init<ImPlotDateFmt, ImPlotTimeFmt, bool, bool>(),
            nb::arg("date_fmt"), nb::arg("time_fmt"), nb::arg("use_24_hr_clk") = false, nb::arg("use_iso_8601") = false)
        .def_rw("date", &ImPlotDateTimeSpec::Date, "")
        .def_rw("time", &ImPlotDateTimeSpec::Time, "")
        .def_rw("use_iso8601", &ImPlotDateTimeSpec::UseISO8601, "")
        .def_rw("use24_hour_clock", &ImPlotDateTimeSpec::Use24HourClock, "")
        ;


    auto pyClassImPlotTime =
        nb::class_<ImPlotTime>
            (m, "Time", "Two part timestamp struct.")
        .def_rw("s", &ImPlotTime::S, "second part")
        .def_rw("us", &ImPlotTime::Us, "microsecond part")
        .def(nb::init<>())
        .def(nb::init<time_t, int>(),
            nb::arg("s"), nb::arg("us") = 0)
        .def("roll_over",
            &ImPlotTime::RollOver, "(private API)")
        .def("to_double",
            &ImPlotTime::ToDouble, "(private API)")
        .def_static("from_double",
            &ImPlotTime::FromDouble,
            nb::arg("t"),
            "(private API)")
        ;


    auto pyClassImPlotColormapData =
        nb::class_<ImPlotColormapData>
            (m, "ColormapData", "Colormap data storage")
        .def_rw("keys", &ImPlotColormapData::Keys, "")
        .def_rw("key_counts", &ImPlotColormapData::KeyCounts, "")
        .def_rw("key_offsets", &ImPlotColormapData::KeyOffsets, "")
        .def_rw("tables", &ImPlotColormapData::Tables, "")
        .def_rw("table_sizes", &ImPlotColormapData::TableSizes, "")
        .def_rw("table_offsets", &ImPlotColormapData::TableOffsets, "")
        .def_rw("text", &ImPlotColormapData::Text, "")
        .def_rw("text_offsets", &ImPlotColormapData::TextOffsets, "")
        .def_rw("map", &ImPlotColormapData::Map, "")
        .def_rw("count", &ImPlotColormapData::Count, "")
        .def(nb::init<>())
        .def("append",
            &ImPlotColormapData::Append,
            nb::arg("name"), nb::arg("keys"), nb::arg("count"), nb::arg("qual"),
            "(private API)")
        .def("_append_table",
            &ImPlotColormapData::_AppendTable,
            nb::arg("cmap"),
            "(private API)")
        .def("rebuild_tables",
            &ImPlotColormapData::RebuildTables, "(private API)")
        .def("is_qual",
            &ImPlotColormapData::IsQual,
            nb::arg("cmap"),
            "(private API)")
        .def("get_name",
            &ImPlotColormapData::GetName,
            nb::arg("cmap"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_index",
            &ImPlotColormapData::GetIndex,
            nb::arg("name"),
            "(private API)")
        .def("get_keys",
            &ImPlotColormapData::GetKeys,
            nb::arg("cmap"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_key_count",
            &ImPlotColormapData::GetKeyCount,
            nb::arg("cmap"),
            "(private API)")
        .def("get_key_color",
            &ImPlotColormapData::GetKeyColor,
            nb::arg("cmap"), nb::arg("idx"),
            "(private API)")
        .def("set_key_color",
            &ImPlotColormapData::SetKeyColor,
            nb::arg("cmap"), nb::arg("idx"), nb::arg("value"),
            "(private API)")
        .def("get_table",
            &ImPlotColormapData::GetTable,
            nb::arg("cmap"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_table_size",
            &ImPlotColormapData::GetTableSize,
            nb::arg("cmap"),
            "(private API)")
        .def("get_table_color",
            &ImPlotColormapData::GetTableColor,
            nb::arg("cmap"), nb::arg("idx"),
            "(private API)")
        .def("lerp_table",
            &ImPlotColormapData::LerpTable,
            nb::arg("cmap"), nb::arg("t"),
            "(private API)")
        ;


    auto pyClassImPlotPointError =
        nb::class_<ImPlotPointError>
            (m, "PointError", "ImPlotPoint with positive/negative error values")
        .def_rw("x", &ImPlotPointError::X, "")
        .def_rw("y", &ImPlotPointError::Y, "")
        .def_rw("neg", &ImPlotPointError::Neg, "")
        .def_rw("pos", &ImPlotPointError::Pos, "")
        .def(nb::init<double, double, double, double>(),
            nb::arg("x"), nb::arg("y"), nb::arg("neg"), nb::arg("pos"))
        ;


    auto pyClassImPlotAnnotation =
        nb::class_<ImPlotAnnotation>
            (m, "Annotation", "Interior plot label/annotation")
        .def_rw("pos", &ImPlotAnnotation::Pos, "")
        .def_rw("offset", &ImPlotAnnotation::Offset, "")
        .def_rw("color_bg", &ImPlotAnnotation::ColorBg, "")
        .def_rw("color_fg", &ImPlotAnnotation::ColorFg, "")
        .def_rw("text_offset", &ImPlotAnnotation::TextOffset, "")
        .def_rw("clamp", &ImPlotAnnotation::Clamp, "")
        .def(nb::init<>())
        ;


    auto pyClassImPlotAnnotationCollection =
        nb::class_<ImPlotAnnotationCollection>
            (m, "AnnotationCollection", "Collection of plot labels")
        .def_rw("text_buffer", &ImPlotAnnotationCollection::TextBuffer, "")
        .def_rw("size", &ImPlotAnnotationCollection::Size, "")
        .def(nb::init<>())
        .def("append",
            [](ImPlotAnnotationCollection & self, const ImVec2 & pos, const ImVec2 & off, ImU32 bg, ImU32 fg, bool clamp, const char * fmt)
            {
                auto Append_adapt_variadic_format = [&self](const ImVec2 & pos, const ImVec2 & off, ImU32 bg, ImU32 fg, bool clamp, const char * fmt)
                {
                    self.Append(pos, off, bg, fg, clamp, "%s", fmt);
                };

                Append_adapt_variadic_format(pos, off, bg, fg, clamp, fmt);
            },
            nb::arg("pos"), nb::arg("off"), nb::arg("bg"), nb::arg("fg"), nb::arg("clamp"), nb::arg("fmt"),
            "(private API)")
        .def("get_text",
            [](ImPlotAnnotationCollection & self, int idx) -> const char *
            {
                auto GetText_adapt_force_lambda = [&self](int idx) -> const char *
                {
                    auto lambda_result = self.GetText(idx);
                    return lambda_result;
                };

                return GetText_adapt_force_lambda(idx);
            },
            nb::arg("idx"),
            "(private API)",
            nb::rv_policy::reference)
        .def("reset",
            &ImPlotAnnotationCollection::Reset, "(private API)")
        ;


    auto pyClassImPlotTag =
        nb::class_<ImPlotTag>
            (m, "Tag", "")
        .def("__init__", [](ImPlotTag * self, const std::optional<const ImAxis> & Axis = std::nullopt, double Value = double(), ImU32 ColorBg = ImU32(), ImU32 ColorFg = ImU32(), int TextOffset = int())
        {
            new (self) ImPlotTag();  // placement new
            auto r_ctor_ = self;
            if (Axis.has_value())
                r_ctor_->Axis = Axis.value();
            else
                r_ctor_->Axis = ImAxis();
            r_ctor_->Value = Value;
            r_ctor_->ColorBg = ColorBg;
            r_ctor_->ColorFg = ColorFg;
            r_ctor_->TextOffset = TextOffset;
        },
        nb::arg("axis").none() = nb::none(), nb::arg("value") = double(), nb::arg("color_bg") = ImU32(), nb::arg("color_fg") = ImU32(), nb::arg("text_offset") = int()
        )
        .def_rw("axis", &ImPlotTag::Axis, "")
        .def_rw("value", &ImPlotTag::Value, "")
        .def_rw("color_bg", &ImPlotTag::ColorBg, "")
        .def_rw("color_fg", &ImPlotTag::ColorFg, "")
        .def_rw("text_offset", &ImPlotTag::TextOffset, "")
        ;


    auto pyClassImPlotTagCollection =
        nb::class_<ImPlotTagCollection>
            (m, "TagCollection", "")
        .def_rw("text_buffer", &ImPlotTagCollection::TextBuffer, "")
        .def_rw("size", &ImPlotTagCollection::Size, "")
        .def(nb::init<>())
        .def("append",
            [](ImPlotTagCollection & self, ImAxis axis, double value, ImU32 bg, ImU32 fg, const char * fmt)
            {
                auto Append_adapt_variadic_format = [&self](ImAxis axis, double value, ImU32 bg, ImU32 fg, const char * fmt)
                {
                    self.Append(axis, value, bg, fg, "%s", fmt);
                };

                Append_adapt_variadic_format(axis, value, bg, fg, fmt);
            },
            nb::arg("axis"), nb::arg("value"), nb::arg("bg"), nb::arg("fg"), nb::arg("fmt"),
            "(private API)")
        .def("get_text",
            [](ImPlotTagCollection & self, int idx) -> const char *
            {
                auto GetText_adapt_force_lambda = [&self](int idx) -> const char *
                {
                    auto lambda_result = self.GetText(idx);
                    return lambda_result;
                };

                return GetText_adapt_force_lambda(idx);
            },
            nb::arg("idx"),
            "(private API)",
            nb::rv_policy::reference)
        .def("reset",
            &ImPlotTagCollection::Reset, "(private API)")
        ;


    auto pyClassImPlotTick =
        nb::class_<ImPlotTick>
            (m, "Tick", "Tick mark info")
        .def_rw("plot_pos", &ImPlotTick::PlotPos, "")
        .def_rw("pixel_pos", &ImPlotTick::PixelPos, "")
        .def_rw("label_size", &ImPlotTick::LabelSize, "")
        .def_rw("text_offset", &ImPlotTick::TextOffset, "")
        .def_rw("major", &ImPlotTick::Major, "")
        .def_rw("show_label", &ImPlotTick::ShowLabel, "")
        .def_rw("level", &ImPlotTick::Level, "")
        .def_rw("idx", &ImPlotTick::Idx, "")
        .def(nb::init<double, bool, int, bool>(),
            nb::arg("value"), nb::arg("major"), nb::arg("level"), nb::arg("show_label"))
        ;


    auto pyClassImPlotTicker =
        nb::class_<ImPlotTicker>
            (m, "Ticker", "Collection of ticks")
        .def_rw("text_buffer", &ImPlotTicker::TextBuffer, "")
        .def_rw("max_size", &ImPlotTicker::MaxSize, "")
        .def_rw("late_size", &ImPlotTicker::LateSize, "")
        .def_rw("levels", &ImPlotTicker::Levels, "")
        .def(nb::init<>())
        .def("add_tick",
            nb::overload_cast<double, bool, int, bool, const char *>(&ImPlotTicker::AddTick),
            nb::arg("value"), nb::arg("major"), nb::arg("level"), nb::arg("show_label"), nb::arg("label"),
            "(private API)",
            nb::rv_policy::reference)
        .def("add_tick",
            nb::overload_cast<ImPlotTick>(&ImPlotTicker::AddTick),
            nb::arg("tick"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_text",
            [](const ImPlotTicker & self, int idx) -> const char *
            {
                auto GetText_adapt_force_lambda = [&self](int idx) -> const char *
                {
                    auto lambda_result = self.GetText(idx);
                    return lambda_result;
                };

                return GetText_adapt_force_lambda(idx);
            },
            nb::arg("idx"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_text",
            [](ImPlotTicker & self, const ImPlotTick & tick) -> const char *
            {
                auto GetText_adapt_force_lambda = [&self](const ImPlotTick & tick) -> const char *
                {
                    auto lambda_result = self.GetText(tick);
                    return lambda_result;
                };

                return GetText_adapt_force_lambda(tick);
            },
            nb::arg("tick"),
            "(private API)",
            nb::rv_policy::reference)
        .def("override_size_late",
            &ImPlotTicker::OverrideSizeLate,
            nb::arg("size"),
            "(private API)")
        .def("reset",
            &ImPlotTicker::Reset, "(private API)")
        .def("tick_count",
            &ImPlotTicker::TickCount, "(private API)")
        ;


    auto pyClassImPlotAxis =
        nb::class_<ImPlotAxis>
            (m, "Axis", "Axis state information that must persist after EndPlot")
        .def_rw("id_", &ImPlotAxis::ID, "")
        .def_rw("flags", &ImPlotAxis::Flags, "")
        .def_rw("previous_flags", &ImPlotAxis::PreviousFlags, "")
        .def_rw("range", &ImPlotAxis::Range, "")
        .def_rw("range_cond", &ImPlotAxis::RangeCond, "")
        .def_rw("scale", &ImPlotAxis::Scale, "")
        .def_rw("fit_extents", &ImPlotAxis::FitExtents, "")
        .def_rw("ortho_axis", &ImPlotAxis::OrthoAxis, "")
        .def_rw("constraint_range", &ImPlotAxis::ConstraintRange, "")
        .def_rw("constraint_zoom", &ImPlotAxis::ConstraintZoom, "")
        .def_rw("ticker", &ImPlotAxis::Ticker, "")
        .def_rw("formatter_data", &ImPlotAxis::FormatterData, "")
        .def_rw("linked_min", &ImPlotAxis::LinkedMin, "")
        .def_rw("linked_max", &ImPlotAxis::LinkedMax, "")
        .def_rw("picker_level", &ImPlotAxis::PickerLevel, "")
        .def_rw("picker_time_min", &ImPlotAxis::PickerTimeMin, "")
        .def_rw("picker_time_max", &ImPlotAxis::PickerTimeMax, "")
        .def_rw("transform_data", &ImPlotAxis::TransformData, "")
        .def_rw("pixel_min", &ImPlotAxis::PixelMin, "")
        .def_rw("pixel_max", &ImPlotAxis::PixelMax, "")
        .def_rw("scale_min", &ImPlotAxis::ScaleMin, "")
        .def_rw("scale_max", &ImPlotAxis::ScaleMax, "")
        .def_rw("scale_to_pixel", &ImPlotAxis::ScaleToPixel, "")
        .def_rw("datum1", &ImPlotAxis::Datum1, "")
        .def_rw("datum2", &ImPlotAxis::Datum2, "")
        .def_rw("hover_rect", &ImPlotAxis::HoverRect, "")
        .def_rw("label_offset", &ImPlotAxis::LabelOffset, "")
        .def_rw("color_maj", &ImPlotAxis::ColorMaj, "")
        .def_rw("color_min", &ImPlotAxis::ColorMin, "")
        .def_rw("color_tick", &ImPlotAxis::ColorTick, "")
        .def_rw("color_txt", &ImPlotAxis::ColorTxt, "")
        .def_rw("color_bg", &ImPlotAxis::ColorBg, "")
        .def_rw("color_hov", &ImPlotAxis::ColorHov, "")
        .def_rw("color_act", &ImPlotAxis::ColorAct, "")
        .def_rw("color_hi_li", &ImPlotAxis::ColorHiLi, "")
        .def_rw("enabled", &ImPlotAxis::Enabled, "")
        .def_rw("vertical", &ImPlotAxis::Vertical, "")
        .def_rw("fit_this_frame", &ImPlotAxis::FitThisFrame, "")
        .def_rw("has_range", &ImPlotAxis::HasRange, "")
        .def_rw("has_format_spec", &ImPlotAxis::HasFormatSpec, "")
        .def_rw("show_default_ticks", &ImPlotAxis::ShowDefaultTicks, "")
        .def_rw("hovered", &ImPlotAxis::Hovered, "")
        .def_rw("held", &ImPlotAxis::Held, "")
        .def(nb::init<>())
        .def("reset",
            &ImPlotAxis::Reset, "(private API)")
        .def("set_min",
            &ImPlotAxis::SetMin,
            nb::arg("_min"), nb::arg("force") = false,
            "(private API)")
        .def("set_max",
            &ImPlotAxis::SetMax,
            nb::arg("_max"), nb::arg("force") = false,
            "(private API)")
        .def("set_range",
            nb::overload_cast<double, double>(&ImPlotAxis::SetRange),
            nb::arg("v1"), nb::arg("v2"),
            "(private API)")
        .def("set_range",
            nb::overload_cast<const ImPlotRange &>(&ImPlotAxis::SetRange),
            nb::arg("range"),
            "(private API)")
        .def("set_aspect",
            &ImPlotAxis::SetAspect,
            nb::arg("unit_per_pix"),
            "(private API)")
        .def("pixel_size",
            &ImPlotAxis::PixelSize, "(private API)")
        .def("get_aspect",
            &ImPlotAxis::GetAspect, "(private API)")
        .def("constrain",
            &ImPlotAxis::Constrain, "(private API)")
        .def("update_transform_cache",
            &ImPlotAxis::UpdateTransformCache, "(private API)")
        .def("plot_to_pixels",
            &ImPlotAxis::PlotToPixels,
            nb::arg("plt"),
            "(private API)")
        .def("pixels_to_plot",
            &ImPlotAxis::PixelsToPlot,
            nb::arg("pix"),
            "(private API)")
        .def("extend_fit",
            &ImPlotAxis::ExtendFit,
            nb::arg("v"),
            "(private API)")
        .def("extend_fit_with",
            &ImPlotAxis::ExtendFitWith,
            nb::arg("alt"), nb::arg("v"), nb::arg("v_alt"),
            "(private API)")
        .def("apply_fit",
            &ImPlotAxis::ApplyFit,
            nb::arg("padding"),
            "(private API)")
        .def("has_label",
            &ImPlotAxis::HasLabel, "(private API)")
        .def("has_grid_lines",
            &ImPlotAxis::HasGridLines, "(private API)")
        .def("has_tick_labels",
            &ImPlotAxis::HasTickLabels, "(private API)")
        .def("has_tick_marks",
            &ImPlotAxis::HasTickMarks, "(private API)")
        .def("will_render",
            &ImPlotAxis::WillRender, "(private API)")
        .def("is_opposite",
            &ImPlotAxis::IsOpposite, "(private API)")
        .def("is_inverted",
            &ImPlotAxis::IsInverted, "(private API)")
        .def("is_foreground",
            &ImPlotAxis::IsForeground, "(private API)")
        .def("is_auto_fitting",
            &ImPlotAxis::IsAutoFitting, "(private API)")
        .def("can_init_fit",
            &ImPlotAxis::CanInitFit, "(private API)")
        .def("is_range_locked",
            &ImPlotAxis::IsRangeLocked, "(private API)")
        .def("is_locked_min",
            &ImPlotAxis::IsLockedMin, "(private API)")
        .def("is_locked_max",
            &ImPlotAxis::IsLockedMax, "(private API)")
        .def("is_locked",
            &ImPlotAxis::IsLocked, "(private API)")
        .def("is_input_locked_min",
            &ImPlotAxis::IsInputLockedMin, "(private API)")
        .def("is_input_locked_max",
            &ImPlotAxis::IsInputLockedMax, "(private API)")
        .def("is_input_locked",
            &ImPlotAxis::IsInputLocked, "(private API)")
        .def("has_menus",
            &ImPlotAxis::HasMenus, "(private API)")
        .def("is_pan_locked",
            &ImPlotAxis::IsPanLocked,
            nb::arg("increasing"),
            "(private API)")
        .def("push_links",
            &ImPlotAxis::PushLinks, "(private API)")
        .def("pull_links",
            &ImPlotAxis::PullLinks, "(private API)")
        ;


    auto pyClassImPlotAlignmentData =
        nb::class_<ImPlotAlignmentData>
            (m, "AlignmentData", "Align plots group data")
        .def_rw("vertical", &ImPlotAlignmentData::Vertical, "")
        .def_rw("pad_a", &ImPlotAlignmentData::PadA, "")
        .def_rw("pad_b", &ImPlotAlignmentData::PadB, "")
        .def_rw("pad_a_max", &ImPlotAlignmentData::PadAMax, "")
        .def_rw("pad_b_max", &ImPlotAlignmentData::PadBMax, "")
        .def(nb::init<>())
        .def("begin",
            &ImPlotAlignmentData::Begin, "(private API)")
        .def("update",
            [](ImPlotAlignmentData & self, float pad_a, float pad_b, float delta_a, float delta_b) -> std::tuple<float, float, float, float>
            {
                auto Update_adapt_modifiable_immutable_to_return = [&self](float pad_a, float pad_b, float delta_a, float delta_b) -> std::tuple<float, float, float, float>
                {
                    float & pad_a_adapt_modifiable = pad_a;
                    float & pad_b_adapt_modifiable = pad_b;
                    float & delta_a_adapt_modifiable = delta_a;
                    float & delta_b_adapt_modifiable = delta_b;

                    self.Update(pad_a_adapt_modifiable, pad_b_adapt_modifiable, delta_a_adapt_modifiable, delta_b_adapt_modifiable);
                    return std::make_tuple(pad_a, pad_b, delta_a, delta_b);
                };

                return Update_adapt_modifiable_immutable_to_return(pad_a, pad_b, delta_a, delta_b);
            },
            nb::arg("pad_a"), nb::arg("pad_b"), nb::arg("delta_a"), nb::arg("delta_b"),
            "(private API)")
        .def("end",
            &ImPlotAlignmentData::End, "(private API)")
        .def("reset",
            &ImPlotAlignmentData::Reset, "(private API)")
        ;


    auto pyClassImPlotItem =
        nb::class_<ImPlotItem>
            (m, "Item", "State information for Plot items")
        .def_rw("id_", &ImPlotItem::ID, "")
        .def_rw("color", &ImPlotItem::Color, "")
        .def_rw("legend_hover_rect", &ImPlotItem::LegendHoverRect, "")
        .def_rw("name_offset", &ImPlotItem::NameOffset, "")
        .def_rw("show", &ImPlotItem::Show, "")
        .def_rw("legend_hovered", &ImPlotItem::LegendHovered, "")
        .def_rw("seen_this_frame", &ImPlotItem::SeenThisFrame, "")
        .def(nb::init<>())
        ;


    auto pyClassImPlotLegend =
        nb::class_<ImPlotLegend>
            (m, "Legend", "Holds Legend state")
        .def_rw("flags", &ImPlotLegend::Flags, "")
        .def_rw("previous_flags", &ImPlotLegend::PreviousFlags, "")
        .def_rw("location", &ImPlotLegend::Location, "")
        .def_rw("previous_location", &ImPlotLegend::PreviousLocation, "")
        .def_rw("scroll", &ImPlotLegend::Scroll, "")
        .def_rw("indices", &ImPlotLegend::Indices, "")
        .def_rw("labels", &ImPlotLegend::Labels, "")
        .def_rw("rect", &ImPlotLegend::Rect, "")
        .def_rw("rect_clamped", &ImPlotLegend::RectClamped, "")
        .def_rw("hovered", &ImPlotLegend::Hovered, "")
        .def_rw("held", &ImPlotLegend::Held, "")
        .def_rw("can_go_inside", &ImPlotLegend::CanGoInside, "")
        .def(nb::init<>())
        .def("reset",
            &ImPlotLegend::Reset, "(private API)")
        ;


    auto pyClassImPlotItemGroup =
        nb::class_<ImPlotItemGroup>
            (m, "ItemGroup", "Holds Items and Legend data")
        .def_rw("id_", &ImPlotItemGroup::ID, "")
        .def_rw("legend", &ImPlotItemGroup::Legend, "")
        .def_rw("colormap_idx", &ImPlotItemGroup::ColormapIdx, "")
        .def(nb::init<>())
        .def("get_item_count",
            &ImPlotItemGroup::GetItemCount, "(private API)")
        .def("get_item_id",
            &ImPlotItemGroup::GetItemID,
            nb::arg("label_id"),
            "(private API)")
        .def("get_item",
            nb::overload_cast<ImGuiID>(&ImPlotItemGroup::GetItem),
            nb::arg("id_"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_item",
            nb::overload_cast<const char *>(&ImPlotItemGroup::GetItem),
            nb::arg("label_id"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_or_add_item",
            &ImPlotItemGroup::GetOrAddItem,
            nb::arg("id_"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_item_by_index",
            &ImPlotItemGroup::GetItemByIndex,
            nb::arg("i"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_item_index",
            &ImPlotItemGroup::GetItemIndex,
            nb::arg("item"),
            "(private API)")
        .def("get_legend_count",
            &ImPlotItemGroup::GetLegendCount, "(private API)")
        .def("get_legend_item",
            &ImPlotItemGroup::GetLegendItem,
            nb::arg("i"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_legend_label",
            &ImPlotItemGroup::GetLegendLabel,
            nb::arg("i"),
            "(private API)",
            nb::rv_policy::reference)
        .def("reset",
            &ImPlotItemGroup::Reset, "(private API)")
        ;


    auto pyClassImPlotPlot =
        nb::class_<ImPlotPlot>
            (m, "Plot", "Holds Plot state information that must persist after EndPlot")
        .def_rw("id_", &ImPlotPlot::ID, "")
        .def_rw("flags", &ImPlotPlot::Flags, "")
        .def_rw("previous_flags", &ImPlotPlot::PreviousFlags, "")
        .def_rw("mouse_text_location", &ImPlotPlot::MouseTextLocation, "")
        .def_rw("mouse_text_flags", &ImPlotPlot::MouseTextFlags, "")
        .def_rw("text_buffer", &ImPlotPlot::TextBuffer, "")
        .def_rw("items", &ImPlotPlot::Items, "")
        .def_rw("current_x", &ImPlotPlot::CurrentX, "")
        .def_rw("current_y", &ImPlotPlot::CurrentY, "")
        .def_rw("frame_rect", &ImPlotPlot::FrameRect, "")
        .def_rw("canvas_rect", &ImPlotPlot::CanvasRect, "")
        .def_rw("plot_rect", &ImPlotPlot::PlotRect, "")
        .def_rw("axes_rect", &ImPlotPlot::AxesRect, "")
        .def_rw("select_rect", &ImPlotPlot::SelectRect, "")
        .def_rw("select_start", &ImPlotPlot::SelectStart, "")
        .def_rw("title_offset", &ImPlotPlot::TitleOffset, "")
        .def_rw("just_created", &ImPlotPlot::JustCreated, "")
        .def_rw("initialized", &ImPlotPlot::Initialized, "")
        .def_rw("setup_locked", &ImPlotPlot::SetupLocked, "")
        .def_rw("fit_this_frame", &ImPlotPlot::FitThisFrame, "")
        .def_rw("hovered", &ImPlotPlot::Hovered, "")
        .def_rw("held", &ImPlotPlot::Held, "")
        .def_rw("selecting", &ImPlotPlot::Selecting, "")
        .def_rw("selected", &ImPlotPlot::Selected, "")
        .def_rw("context_locked", &ImPlotPlot::ContextLocked, "")
        .def(nb::init<>())
        .def("is_input_locked",
            &ImPlotPlot::IsInputLocked, "(private API)")
        .def("clear_text_buffer",
            &ImPlotPlot::ClearTextBuffer, "(private API)")
        .def("set_title",
            &ImPlotPlot::SetTitle,
            nb::arg("title"),
            "(private API)")
        .def("has_title",
            &ImPlotPlot::HasTitle, "(private API)")
        .def("get_title",
            &ImPlotPlot::GetTitle,
            "(private API)",
            nb::rv_policy::reference)
        .def("x_axis",
            nb::overload_cast<int>(&ImPlotPlot::XAxis),
            nb::arg("i"),
            "(private API)",
            nb::rv_policy::reference)
        .def("x_axis",
            nb::overload_cast<int>(&ImPlotPlot::XAxis, nb::const_),
            nb::arg("i"),
            "(private API)",
            nb::rv_policy::reference)
        .def("y_axis",
            nb::overload_cast<int>(&ImPlotPlot::YAxis),
            nb::arg("i"),
            "(private API)",
            nb::rv_policy::reference)
        .def("y_axis",
            nb::overload_cast<int>(&ImPlotPlot::YAxis, nb::const_),
            nb::arg("i"),
            "(private API)",
            nb::rv_policy::reference)
        .def("enabled_axes_x",
            &ImPlotPlot::EnabledAxesX, "(private API)")
        .def("enabled_axes_y",
            &ImPlotPlot::EnabledAxesY, "(private API)")
        .def("set_axis_label",
            &ImPlotPlot::SetAxisLabel,
            nb::arg("axis"), nb::arg("label"),
            "(private API)")
        .def("get_axis_label",
            &ImPlotPlot::GetAxisLabel,
            nb::arg("axis"),
            "(private API)",
            nb::rv_policy::reference)
        ;


    auto pyClassImPlotSubplot =
        nb::class_<ImPlotSubplot>
            (m, "Subplot", "Holds subplot data that must persist after EndSubplot")
        .def_rw("id_", &ImPlotSubplot::ID, "")
        .def_rw("flags", &ImPlotSubplot::Flags, "")
        .def_rw("previous_flags", &ImPlotSubplot::PreviousFlags, "")
        .def_rw("items", &ImPlotSubplot::Items, "")
        .def_rw("rows", &ImPlotSubplot::Rows, "")
        .def_rw("cols", &ImPlotSubplot::Cols, "")
        .def_rw("current_idx", &ImPlotSubplot::CurrentIdx, "")
        .def_rw("frame_rect", &ImPlotSubplot::FrameRect, "")
        .def_rw("grid_rect", &ImPlotSubplot::GridRect, "")
        .def_rw("cell_size", &ImPlotSubplot::CellSize, "")
        .def_rw("row_ratios", &ImPlotSubplot::RowRatios, "")
        .def_rw("col_ratios", &ImPlotSubplot::ColRatios, "")
        .def_prop_ro("temp_sizes",
            [](ImPlotSubplot &self) -> nb::ndarray<float, nb::numpy, nb::shape<2>, nb::c_contig>
            {
                return self.TempSizes;
            },
            "")
        .def_rw("frame_hovered", &ImPlotSubplot::FrameHovered, "")
        .def_rw("has_title", &ImPlotSubplot::HasTitle, "")
        .def(nb::init<>())
        ;


    auto pyClassImPlotNextPlotData =
        nb::class_<ImPlotNextPlotData>
            (m, "NextPlotData", "Temporary data storage for upcoming plot")
        .def(nb::init<>())
        .def("reset",
            &ImPlotNextPlotData::Reset, "(private API)")
        ;


    auto pyClassImPlotNextItemData =
        nb::class_<ImPlotNextItemData>
            (m, "NextItemData", "Temporary data storage for upcoming item")
        .def_rw("line_weight", &ImPlotNextItemData::LineWeight, "")
        .def_rw("marker", &ImPlotNextItemData::Marker, "")
        .def_rw("marker_size", &ImPlotNextItemData::MarkerSize, "")
        .def_rw("marker_weight", &ImPlotNextItemData::MarkerWeight, "")
        .def_rw("fill_alpha", &ImPlotNextItemData::FillAlpha, "")
        .def_rw("error_bar_size", &ImPlotNextItemData::ErrorBarSize, "")
        .def_rw("error_bar_weight", &ImPlotNextItemData::ErrorBarWeight, "")
        .def_rw("digital_bit_height", &ImPlotNextItemData::DigitalBitHeight, "")
        .def_rw("digital_bit_gap", &ImPlotNextItemData::DigitalBitGap, "")
        .def_rw("render_line", &ImPlotNextItemData::RenderLine, "")
        .def_rw("render_fill", &ImPlotNextItemData::RenderFill, "")
        .def_rw("render_marker_line", &ImPlotNextItemData::RenderMarkerLine, "")
        .def_rw("render_marker_fill", &ImPlotNextItemData::RenderMarkerFill, "")
        .def_rw("has_hidden", &ImPlotNextItemData::HasHidden, "")
        .def_rw("hidden", &ImPlotNextItemData::Hidden, "")
        .def_rw("hidden_cond", &ImPlotNextItemData::HiddenCond, "")
        .def(nb::init<>())
        .def("reset",
            &ImPlotNextItemData::Reset, "(private API)")
        ;


    auto pyClassImPlotContext =
        nb::class_<ImPlotContext>
            (m, "Context", "Holds state information that must persist between calls to BeginPlot()/EndPlot()")
        .def("__init__", [](ImPlotContext * self, const std::optional<const ImPlotTicker> & CTicker = std::nullopt, const std::optional<const ImPlotAnnotationCollection> & Annotations = std::nullopt, const std::optional<const ImPlotTagCollection> & Tags = std::nullopt, const std::optional<const ImPlotStyle> & Style = std::nullopt, const std::optional<const ImVector<ImGuiColorMod>> & ColorModifiers = std::nullopt, const std::optional<const ImVector<ImGuiStyleMod>> & StyleModifiers = std::nullopt, const std::optional<const ImPlotColormapData> & ColormapData = std::nullopt, const std::optional<const ImVector<int>> & TempInt1 = std::nullopt, int DigitalPlotItemCnt = int(), int DigitalPlotOffset = int(), const std::optional<const ImPlotNextPlotData> & NextPlotData = std::nullopt, const std::optional<const ImPlotNextItemData> & NextItemData = std::nullopt, const std::optional<const ImPlotInputMap> & InputMap = std::nullopt, bool OpenContextThisFrame = bool(), const std::optional<const ImGuiTextBuffer> & MousePosStringBuilder = std::nullopt, bool CanDragPlotInNodeEditor = false)
        {
            new (self) ImPlotContext();  // placement new
            auto r_ctor_ = self;
            if (CTicker.has_value())
                r_ctor_->CTicker = CTicker.value();
            else
                r_ctor_->CTicker = ImPlotTicker();
            if (Annotations.has_value())
                r_ctor_->Annotations = Annotations.value();
            else
                r_ctor_->Annotations = ImPlotAnnotationCollection();
            if (Tags.has_value())
                r_ctor_->Tags = Tags.value();
            else
                r_ctor_->Tags = ImPlotTagCollection();
            if (Style.has_value())
                r_ctor_->Style = Style.value();
            else
                r_ctor_->Style = ImPlotStyle();
            if (ColorModifiers.has_value())
                r_ctor_->ColorModifiers = ColorModifiers.value();
            else
                r_ctor_->ColorModifiers = ImVector<ImGuiColorMod>();
            if (StyleModifiers.has_value())
                r_ctor_->StyleModifiers = StyleModifiers.value();
            else
                r_ctor_->StyleModifiers = ImVector<ImGuiStyleMod>();
            if (ColormapData.has_value())
                r_ctor_->ColormapData = ColormapData.value();
            else
                r_ctor_->ColormapData = ImPlotColormapData();
            if (TempInt1.has_value())
                r_ctor_->TempInt1 = TempInt1.value();
            else
                r_ctor_->TempInt1 = ImVector<int>();
            r_ctor_->DigitalPlotItemCnt = DigitalPlotItemCnt;
            r_ctor_->DigitalPlotOffset = DigitalPlotOffset;
            if (NextPlotData.has_value())
                r_ctor_->NextPlotData = NextPlotData.value();
            else
                r_ctor_->NextPlotData = ImPlotNextPlotData();
            if (NextItemData.has_value())
                r_ctor_->NextItemData = NextItemData.value();
            else
                r_ctor_->NextItemData = ImPlotNextItemData();
            if (InputMap.has_value())
                r_ctor_->InputMap = InputMap.value();
            else
                r_ctor_->InputMap = ImPlotInputMap();
            r_ctor_->OpenContextThisFrame = OpenContextThisFrame;
            if (MousePosStringBuilder.has_value())
                r_ctor_->MousePosStringBuilder = MousePosStringBuilder.value();
            else
                r_ctor_->MousePosStringBuilder = ImGuiTextBuffer();
            r_ctor_->CanDragPlotInNodeEditor = CanDragPlotInNodeEditor;
        },
        nb::arg("c_ticker").none() = nb::none(), nb::arg("annotations").none() = nb::none(), nb::arg("tags").none() = nb::none(), nb::arg("style").none() = nb::none(), nb::arg("color_modifiers").none() = nb::none(), nb::arg("style_modifiers").none() = nb::none(), nb::arg("colormap_data").none() = nb::none(), nb::arg("temp_int1").none() = nb::none(), nb::arg("digital_plot_item_cnt") = int(), nb::arg("digital_plot_offset") = int(), nb::arg("next_plot_data").none() = nb::none(), nb::arg("next_item_data").none() = nb::none(), nb::arg("input_map").none() = nb::none(), nb::arg("open_context_this_frame") = bool(), nb::arg("mouse_pos_string_builder").none() = nb::none(), nb::arg("can_drag_plot_in_node_editor") = false
        )
        .def_rw("current_plot", &ImPlotContext::CurrentPlot, "")
        .def_rw("current_subplot", &ImPlotContext::CurrentSubplot, "")
        .def_rw("current_items", &ImPlotContext::CurrentItems, "")
        .def_rw("current_item", &ImPlotContext::CurrentItem, "")
        .def_rw("previous_item", &ImPlotContext::PreviousItem, "")
        .def_rw("c_ticker", &ImPlotContext::CTicker, "Tick Marks and Labels")
        .def_rw("annotations", &ImPlotContext::Annotations, "")
        .def_rw("tags", &ImPlotContext::Tags, "")
        .def_rw("style", &ImPlotContext::Style, "")
        .def_rw("color_modifiers", &ImPlotContext::ColorModifiers, "")
        .def_rw("style_modifiers", &ImPlotContext::StyleModifiers, "")
        .def_rw("colormap_data", &ImPlotContext::ColormapData, "")
        .def_rw("temp_int1", &ImPlotContext::TempInt1, "")
        .def_rw("digital_plot_item_cnt", &ImPlotContext::DigitalPlotItemCnt, "")
        .def_rw("digital_plot_offset", &ImPlotContext::DigitalPlotOffset, "")
        .def_rw("next_plot_data", &ImPlotContext::NextPlotData, "")
        .def_rw("next_item_data", &ImPlotContext::NextItemData, "")
        .def_rw("input_map", &ImPlotContext::InputMap, "")
        .def_rw("open_context_this_frame", &ImPlotContext::OpenContextThisFrame, "")
        .def_rw("mouse_pos_string_builder", &ImPlotContext::MousePosStringBuilder, "")
        .def_rw("sort_items", &ImPlotContext::SortItems, "")
        .def_rw("current_alignment_h", &ImPlotContext::CurrentAlignmentH, "")
        .def_rw("current_alignment_v", &ImPlotContext::CurrentAlignmentV, "")
        .def_rw("can_drag_plot_in_node_editor", &ImPlotContext::CanDragPlotInNodeEditor, "Specific to ImGui Bundle, when used inside imgui-node-editor")
        ;


    m.def("initialize",
        ImPlot::Initialize,
        nb::arg("ctx"),
        "Initializes an ImPlotContext");

    m.def("reset_ctx_for_next_plot",
        ImPlot::ResetCtxForNextPlot,
        nb::arg("ctx"),
        "Resets an ImPlot context for the next call to BeginPlot");

    m.def("reset_ctx_for_next_aligned_plots",
        ImPlot::ResetCtxForNextAlignedPlots,
        nb::arg("ctx"),
        "Resets an ImPlot context for the next call to BeginAlignedPlots");

    m.def("reset_ctx_for_next_subplot",
        ImPlot::ResetCtxForNextSubplot,
        nb::arg("ctx"),
        "Resets an ImPlot context for the next call to BeginSubplot");

    m.def("get_plot",
        ImPlot::GetPlot,
        nb::arg("title"),
        "Gets a plot from the current ImPlotContext",
        nb::rv_policy::reference);

    m.def("get_current_plot",
        ImPlot::GetCurrentPlot,
        "Gets the current plot from the current ImPlotContext",
        nb::rv_policy::reference);

    m.def("bust_plot_cache",
        ImPlot::BustPlotCache, "Busts the cache for every plot in the current context");

    m.def("show_plot_context_menu",
        ImPlot::ShowPlotContextMenu,
        nb::arg("plot"),
        "Shows a plot's context menu.");

    m.def("setup_lock",
        ImPlot::SetupLock, " Lock Setup and call SetupFinish if necessary.\n(private API)");

    m.def("subplot_next_cell",
        ImPlot::SubplotNextCell, "Advances to next subplot");

    m.def("show_subplots_context_menu",
        ImPlot::ShowSubplotsContextMenu,
        nb::arg("subplot"),
        "Shows a subplot's context menu.");

    m.def("begin_item",
        [](const char * label_id, ImPlotItemFlags flags = 0, const std::optional<const ImPlotCol> & recolor_from = std::nullopt) -> bool
        {
            auto BeginItem_adapt_mutable_param_with_default_value = [](const char * label_id, ImPlotItemFlags flags = 0, const std::optional<const ImPlotCol> & recolor_from = std::nullopt) -> bool
            {

                const ImPlotCol& recolor_from_or_default = [&]() -> const ImPlotCol {
                    if (recolor_from.has_value())
                        return recolor_from.value();
                    else
                        return IMPLOT_AUTO;
                }();

                auto lambda_result = ImPlot::BeginItem(label_id, flags, recolor_from_or_default);
                return lambda_result;
            };

            return BeginItem_adapt_mutable_param_with_default_value(label_id, flags, recolor_from);
        },
        nb::arg("label_id"), nb::arg("flags") = 0, nb::arg("recolor_from").none() = nb::none(),
        " Begins a new item. Returns False if the item should not be plotted. Pushes PlotClipRect.\n\n\nPython bindings defaults:\n    If recolor_from is None, then its default value will be: IMPLOT_AUTO");

    m.def("end_item",
        ImPlot::EndItem, "Ends an item (call only if BeginItem returns True). Pops PlotClipRect.");

    m.def("register_or_get_item",
        [](const char * label_id, ImPlotItemFlags flags, std::optional<bool> just_created = std::nullopt) -> std::tuple<ImPlotItem *, std::optional<bool>>
        {
            auto RegisterOrGetItem_adapt_modifiable_immutable_to_return = [](const char * label_id, ImPlotItemFlags flags, std::optional<bool> just_created = std::nullopt) -> std::tuple<ImPlotItem *, std::optional<bool>>
            {
                bool * just_created_adapt_modifiable = nullptr;
                if (just_created.has_value())
                    just_created_adapt_modifiable = & (*just_created);

                ImPlotItem * r = ImPlot::RegisterOrGetItem(label_id, flags, just_created_adapt_modifiable);
                return std::make_tuple(r, just_created);
            };

            return RegisterOrGetItem_adapt_modifiable_immutable_to_return(label_id, flags, just_created);
        },
        nb::arg("label_id"), nb::arg("flags"), nb::arg("just_created").none() = nb::none(),
        "Register or get an existing item from the current plot.",
        nb::rv_policy::reference);

    m.def("get_item",
        ImPlot::GetItem,
        nb::arg("label_id"),
        "Get a plot item from the current plot.",
        nb::rv_policy::reference);

    m.def("get_current_item",
        ImPlot::GetCurrentItem,
        "Gets the current item.",
        nb::rv_policy::reference);

    m.def("bust_item_cache",
        ImPlot::BustItemCache, "Busts the cache for every item for every plot in the current context.");

    m.def("any_axes_input_locked",
        ImPlot::AnyAxesInputLocked,
        nb::arg("axes"), nb::arg("count"),
        " Returns True if any enabled axis is locked from user input.\n(private API)");

    m.def("all_axes_input_locked",
        ImPlot::AllAxesInputLocked,
        nb::arg("axes"), nb::arg("count"),
        " Returns True if all enabled axes are locked from user input.\n(private API)");

    m.def("any_axes_held",
        ImPlot::AnyAxesHeld,
        nb::arg("axes"), nb::arg("count"),
        "(private API)");

    m.def("any_axes_hovered",
        ImPlot::AnyAxesHovered,
        nb::arg("axes"), nb::arg("count"),
        "(private API)");

    m.def("fit_this_frame",
        ImPlot::FitThisFrame, " Returns True if the user has requested data to be fit.\n(private API)");

    m.def("fit_point_x",
        ImPlot::FitPointX,
        nb::arg("x"),
        " Extends the current plot's axes so that it encompasses a vertical line at x\n(private API)");

    m.def("fit_point_y",
        ImPlot::FitPointY,
        nb::arg("y"),
        " Extends the current plot's axes so that it encompasses a horizontal line at y\n(private API)");

    m.def("fit_point",
        ImPlot::FitPoint,
        nb::arg("p"),
        " Extends the current plot's axes so that it encompasses point p\n(private API)");

    m.def("ranges_overlap",
        ImPlot::RangesOverlap,
        nb::arg("r1"), nb::arg("r2"),
        " Returns True if two ranges overlap\n(private API)");

    m.def("show_axis_context_menu",
        ImPlot::ShowAxisContextMenu,
        nb::arg("axis"), nb::arg("equal_axis"), nb::arg("time_allowed") = false,
        "Shows an axis's context menu.");

    m.def("get_location_pos",
        [](const ImRect & outer_rect, const ImVec2 & inner_size, ImPlotLocation location, const std::optional<const ImVec2> & pad = std::nullopt) -> ImVec2
        {
            auto GetLocationPos_adapt_mutable_param_with_default_value = [](const ImRect & outer_rect, const ImVec2 & inner_size, ImPlotLocation location, const std::optional<const ImVec2> & pad = std::nullopt) -> ImVec2
            {

                const ImVec2& pad_or_default = [&]() -> const ImVec2 {
                    if (pad.has_value())
                        return pad.value();
                    else
                        return ImVec2(0,0);
                }();

                auto lambda_result = ImPlot::GetLocationPos(outer_rect, inner_size, location, pad_or_default);
                return lambda_result;
            };

            return GetLocationPos_adapt_mutable_param_with_default_value(outer_rect, inner_size, location, pad);
        },
        nb::arg("outer_rect"), nb::arg("inner_size"), nb::arg("location"), nb::arg("pad").none() = nb::none(),
        " Gets the position of an inner rect that is located inside of an outer rect according to an ImPlotLocation and padding amount.\n\n\nPython bindings defaults:\n    If pad is None, then its default value will be: ImVec2(0,0)");

    m.def("calc_legend_size",
        ImPlot::CalcLegendSize,
        nb::arg("items"), nb::arg("pad"), nb::arg("spacing"), nb::arg("vertical"),
        "Calculates the bounding box size of a legend _before_ clipping.");

    m.def("clamp_legend_rect",
        ImPlot::ClampLegendRect,
        nb::arg("legend_rect"), nb::arg("outer_rect"), nb::arg("pad"),
        "Clips calculated legend size");

    m.def("show_legend_entries",
        ImPlot::ShowLegendEntries,
        nb::arg("items"), nb::arg("legend_bb"), nb::arg("interactable"), nb::arg("pad"), nb::arg("spacing"), nb::arg("vertical"), nb::arg("draw_list"),
        "Renders legend entries into a bounding box");

    m.def("show_alt_legend",
        [](const char * title_id, bool vertical = true, const std::optional<const ImVec2> & size = std::nullopt, bool interactable = true)
        {
            auto ShowAltLegend_adapt_mutable_param_with_default_value = [](const char * title_id, bool vertical = true, const std::optional<const ImVec2> & size = std::nullopt, bool interactable = true)
            {

                const ImVec2& size_or_default = [&]() -> const ImVec2 {
                    if (size.has_value())
                        return size.value();
                    else
                        return ImVec2(0,0);
                }();

                ImPlot::ShowAltLegend(title_id, vertical, size_or_default, interactable);
            };

            ShowAltLegend_adapt_mutable_param_with_default_value(title_id, vertical, size, interactable);
        },
        nb::arg("title_id"), nb::arg("vertical") = true, nb::arg("size").none() = nb::none(), nb::arg("interactable") = true,
        " Shows an alternate legend for the plot identified by #title_id, outside of the plot frame (can be called before or after of Begin/EndPlot but must occur in the same ImGui window! This is not thoroughly tested nor scrollable!).\n\n\nPython bindings defaults:\n    If size is None, then its default value will be: ImVec2(0,0)");

    m.def("show_legend_context_menu",
        ImPlot::ShowLegendContextMenu,
        nb::arg("legend"), nb::arg("visible"),
        "Shows a legend's context menu.");

    m.def("get_item_data",
        ImPlot::GetItemData,
        " Get styling data for next item (call between Begin/EndItem)\n(private API)",
        nb::rv_policy::reference);

    m.def("is_color_auto",
        nb::overload_cast<const ImVec4 &>(ImPlot::IsColorAuto),
        nb::arg("col"),
        " Returns True if a color is set to be automatically determined\n(private API)");

    m.def("is_color_auto",
        nb::overload_cast<ImPlotCol>(ImPlot::IsColorAuto),
        nb::arg("idx"),
        " Returns True if a style color is set to be automatically determined\n(private API)");

    m.def("get_auto_color",
        ImPlot::GetAutoColor,
        nb::arg("idx"),
        "Returns the automatically deduced style color");

    m.def("get_style_color_vec4",
        ImPlot::GetStyleColorVec4,
        nb::arg("idx"),
        "(private API)");

    m.def("get_style_color_u32",
        ImPlot::GetStyleColorU32,
        nb::arg("idx"),
        "(private API)");

    m.def("add_text_vertical",
        [](ImDrawList * DrawList, ImVec2 pos, ImU32 col, const char * text_begin, std::optional<std::string> text_end = std::nullopt)
        {
            auto AddTextVertical_adapt_const_char_pointer_with_default_null = [](ImDrawList * DrawList, ImVec2 pos, ImU32 col, const char * text_begin, std::optional<std::string> text_end = std::nullopt)
            {
                const char * text_end_adapt_default_null = nullptr;
                if (text_end.has_value())
                    text_end_adapt_default_null = text_end.value().c_str();

                ImPlot::AddTextVertical(DrawList, pos, col, text_begin, text_end_adapt_default_null);
            };

            AddTextVertical_adapt_const_char_pointer_with_default_null(DrawList, pos, col, text_begin, text_end);
        },
        nb::arg("draw_list"), nb::arg("pos"), nb::arg("col"), nb::arg("text_begin"), nb::arg("text_end").none() = nb::none(),
        "Draws vertical text. The position is the bottom left of the text rect.");

    m.def("add_text_centered",
        [](ImDrawList * DrawList, ImVec2 top_center, ImU32 col, const char * text_begin, std::optional<std::string> text_end = std::nullopt)
        {
            auto AddTextCentered_adapt_const_char_pointer_with_default_null = [](ImDrawList * DrawList, ImVec2 top_center, ImU32 col, const char * text_begin, std::optional<std::string> text_end = std::nullopt)
            {
                const char * text_end_adapt_default_null = nullptr;
                if (text_end.has_value())
                    text_end_adapt_default_null = text_end.value().c_str();

                ImPlot::AddTextCentered(DrawList, top_center, col, text_begin, text_end_adapt_default_null);
            };

            AddTextCentered_adapt_const_char_pointer_with_default_null(DrawList, top_center, col, text_begin, text_end);
        },
        nb::arg("draw_list"), nb::arg("top_center"), nb::arg("col"), nb::arg("text_begin"), nb::arg("text_end").none() = nb::none(),
        "Draws multiline horizontal text centered.");

    m.def("calc_text_size_vertical",
        ImPlot::CalcTextSizeVertical,
        nb::arg("text"),
        " Calculates the size of vertical text\n(private API)");

    m.def("calc_text_color",
        nb::overload_cast<const ImVec4 &>(ImPlot::CalcTextColor),
        nb::arg("bg"),
        "(private API)");

    m.def("calc_text_color",
        nb::overload_cast<ImU32>(ImPlot::CalcTextColor),
        nb::arg("bg"),
        "(private API)");

    m.def("calc_hover_color",
        ImPlot::CalcHoverColor,
        nb::arg("col"),
        " Lightens or darkens a color for hover\n(private API)");

    m.def("clamp_label_pos",
        ImPlot::ClampLabelPos,
        nb::arg("pos"), nb::arg("size"), nb::arg("min"), nb::arg("max"),
        " Clamps a label position so that it fits a rect defined by Min/Max\n(private API)");

    m.def("get_colormap_color_u32",
        ImPlot::GetColormapColorU32,
        nb::arg("idx"), nb::arg("cmap"),
        "Returns a color from the Color map given an index >= 0 (modulo will be performed).");

    m.def("next_colormap_color_u32",
        ImPlot::NextColormapColorU32, "Returns the next unused colormap color and advances the colormap. Can be used to skip colors if desired.");

    m.def("sample_colormap_u32",
        ImPlot::SampleColormapU32,
        nb::arg("t"), nb::arg("cmap"),
        "Linearly interpolates a color from the current colormap given t between 0 and 1.");

    m.def("render_color_bar",
        ImPlot::RenderColorBar,
        nb::arg("colors"), nb::arg("size"), nb::arg("draw_list"), nb::arg("bounds"), nb::arg("vert"), nb::arg("reversed"), nb::arg("continuous"),
        "Render a colormap bar");

    m.def("nice_num",
        ImPlot::NiceNum,
        nb::arg("x"), nb::arg("round"),
        "Rounds x to powers of 2,5 and 10 for generating axis labels (from Graphics Gems 1 Chapter 11.2)");

    m.def("order_of_magnitude",
        ImPlot::OrderOfMagnitude,
        nb::arg("val"),
        " Computes order of magnitude of double.\n(private API)");

    m.def("order_to_precision",
        ImPlot::OrderToPrecision,
        nb::arg("order"),
        " Returns the precision required for a order of magnitude.\n(private API)");

    m.def("precision",
        ImPlot::Precision,
        nb::arg("val"),
        " Returns a floating point precision to use given a value\n(private API)");

    m.def("round_to",
        ImPlot::RoundTo,
        nb::arg("val"), nb::arg("prec"),
        " Round a value to a given precision\n(private API)");

    m.def("intersection",
        ImPlot::Intersection,
        nb::arg("a1"), nb::arg("a2"), nb::arg("b1"), nb::arg("b2"),
        " Returns the intersection point of two lines A and B (assumes they are not parallel!)\n(private API)");

    m.def("is_leap_year",
        ImPlot::IsLeapYear,
        nb::arg("year"),
        " Returns True if year is leap year (366 days long)\n(private API)");

    m.def("get_days_in_month",
        ImPlot::GetDaysInMonth,
        nb::arg("year"), nb::arg("month"),
        " Returns the number of days in a month, accounting for Feb. leap years. #month is zero indexed.\n(private API)");

    m.def("get_time",
        ImPlot::GetTime,
        nb::arg("t"), nb::arg("ptm"),
        " Get a tm struct from a UNIX timestamp according to the current ImPlotStyle.UseLocalTime setting.\n(private API)",
        nb::rv_policy::reference);

    m.def("make_time",
        ImPlot::MakeTime,
        nb::arg("year"), nb::arg("month") = 0, nb::arg("day") = 1, nb::arg("hour") = 0, nb::arg("min") = 0, nb::arg("sec") = 0, nb::arg("us") = 0,
        " Make a timestamp from time components.\n year[1970-3000], month[0-11], day[1-31], hour[0-23], min[0-59], sec[0-59], us[0,999999]");

    m.def("get_year",
        ImPlot::GetYear,
        nb::arg("t"),
        "Get year component from timestamp [1970-3000]");

    m.def("get_month",
        ImPlot::GetMonth,
        nb::arg("t"),
        "Get month component from timestamp [0-11]");

    m.def("add_time",
        ImPlot::AddTime,
        nb::arg("t"), nb::arg("unit"), nb::arg("count"),
        "Adds or subtracts time from a timestamp. #count > 0 to add, < 0 to subtract.");

    m.def("floor_time",
        ImPlot::FloorTime,
        nb::arg("t"), nb::arg("unit"),
        "Rounds a timestamp down to nearest unit.");

    m.def("ceil_time",
        ImPlot::CeilTime,
        nb::arg("t"), nb::arg("unit"),
        "Rounds a timestamp up to the nearest unit.");

    m.def("round_time",
        ImPlot::RoundTime,
        nb::arg("t"), nb::arg("unit"),
        "Rounds a timestamp up or down to the nearest unit.");

    m.def("combine_date_time",
        ImPlot::CombineDateTime,
        nb::arg("date_part"), nb::arg("time_part"),
        "Combines the date of one timestamp with the time-of-day of another timestamp.");

    m.def("now",
        ImPlot::Now, " Get the current time as a timestamp.\n(private API)");

    m.def("today",
        ImPlot::Today, " Get the current date as a timestamp.\n(private API)");
    // #ifdef IMGUI_BUNDLE_PYTHON_API
    //

    m.def("format_time_str",
        ImPlot::FormatTimeStr,
        nb::arg("t"), nb::arg("fmt"), nb::arg("use_24_hr_clk"),
        "Formats the time part of timestamp t into a buffer according to #fmt");

    m.def("format_date_str",
        ImPlot::FormatDateStr,
        nb::arg("t"), nb::arg("fmt"), nb::arg("use_iso_8601"),
        "Formats the date part of timestamp t into a buffer according to #fmt");

    m.def("format_date_time_str",
        ImPlot::FormatDateTimeStr,
        nb::arg("t"), nb::arg("fmt"),
        "Formats the time and/or date parts of a timestamp t into a buffer according to #fmt");
    // #endif
    //

    m.def("show_date_picker",
        [](const char * id, int level, ImPlotTime * t, const ImPlotTime * t1 = nullptr, const ImPlotTime * t2 = nullptr) -> std::tuple<bool, int>
        {
            auto ShowDatePicker_adapt_modifiable_immutable_to_return = [](const char * id, int level, ImPlotTime * t, const ImPlotTime * t1 = nullptr, const ImPlotTime * t2 = nullptr) -> std::tuple<bool, int>
            {
                int * level_adapt_modifiable = & level;

                bool r = ImPlot::ShowDatePicker(id, level_adapt_modifiable, t, t1, t2);
                return std::make_tuple(r, level);
            };

            return ShowDatePicker_adapt_modifiable_immutable_to_return(id, level, t, t1, t2);
        },
        nb::arg("id_"), nb::arg("level"), nb::arg("t"), nb::arg("t1") = nb::none(), nb::arg("t2") = nb::none(),
        " Shows a date picker widget block (year/month/day).\n #level = 0 for day, 1 for month, 2 for year. Modified by user interaction.\n #t will be set when a day is clicked and the function will return True.\n #t1 and #t2 are optional dates to highlight.");

    m.def("show_time_picker",
        ImPlot::ShowTimePicker,
        nb::arg("id_"), nb::arg("t"),
        " Shows a time picker widget block (hour/min/sec).\n #t will be set when a new hour, minute, or sec is selected or am/pm is toggled, and the function will return True.");

    m.def("transform_forward_log10",
        ImPlot::TransformForward_Log10,
        nb::arg("v"), nb::arg("param_1"),
        "(private API)");

    m.def("transform_inverse_log10",
        ImPlot::TransformInverse_Log10,
        nb::arg("v"), nb::arg("param_1"),
        "(private API)");

    m.def("transform_forward_sym_log",
        ImPlot::TransformForward_SymLog,
        nb::arg("v"), nb::arg("param_1"),
        "(private API)");

    m.def("transform_inverse_sym_log",
        ImPlot::TransformInverse_SymLog,
        nb::arg("v"), nb::arg("param_1"),
        "(private API)");

    m.def("transform_forward_logit",
        ImPlot::TransformForward_Logit,
        nb::arg("v"), nb::arg("param_1"),
        "(private API)");

    m.def("transform_inverse_logit",
        ImPlot::TransformInverse_Logit,
        nb::arg("v"), nb::arg("param_1"),
        "(private API)");


    auto pyClassFormatter_Time_Data =
        nb::class_<ImPlot::Formatter_Time_Data>
            (m, "Formatter_Time_Data", "")
        .def("__init__", [](ImPlot::Formatter_Time_Data * self, const std::optional<const ImPlotTime> & Time = std::nullopt, const std::optional<const ImPlotDateTimeSpec> & Spec = std::nullopt)
        {
            new (self) ImPlot::Formatter_Time_Data();  // placement new
            auto r_ctor_ = self;
            if (Time.has_value())
                r_ctor_->Time = Time.value();
            else
                r_ctor_->Time = ImPlotTime();
            if (Spec.has_value())
                r_ctor_->Spec = Spec.value();
            else
                r_ctor_->Spec = ImPlotDateTimeSpec();
        },
        nb::arg("time").none() = nb::none(), nb::arg("spec").none() = nb::none()
        )
        .def_rw("time", &ImPlot::Formatter_Time_Data::Time, "")
        .def_rw("spec", &ImPlot::Formatter_Time_Data::Spec, "")
        .def_rw("user_formatter_data", &ImPlot::Formatter_Time_Data::UserFormatterData, "")
        ;
    // #endif
    ////////////////////    </generated_from:implot_internal.h>    ////////////////////

    // </litgen_pydef> // Autogenerated code end
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
}
#endif // #ifdef IMGUI_BUNDLE_WITH_IMPLOT
