// Part of ImGui Bundle - MIT License - Copyright (c) 2022-2024 Pascal Thomet - https://github.com/pthom/imgui_bundle
#ifdef IMGUI_BUNDLE_WITH_IMPLOT3D
#include <nanobind/nanobind.h>
#include <nanobind/stl/string.h>
#include <nanobind/stl/array.h>
#include <nanobind/stl/optional.h>
#include <nanobind/stl/vector.h>
#include <nanobind/stl/function.h>
#include <nanobind/stl/tuple.h>
#include <nanobind/stl/optional.h>
#include <nanobind/make_iterator.h>
#include <nanobind/ndarray.h>

#include "imgui.h"
#include "implot3d/implot3d.h"
#include "implot3d/implot3d_internal.h"


namespace nb = nanobind;



void implot3d_binding_manual(nb::module_& m);

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// <litgen_glue_code>  // Autogenerated code below! Do not edit!

// </litgen_glue_code> // Autogenerated code end
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

void py_init_module_implot3d(nb::module_& m)
{
    using UInt = unsigned int;

    m.attr("IMPLOT3D_AUTO") = -1.f;
    m.attr("AUTO") = -1.f;
    m.attr("IMPLOT3D_AUTO_COL") = ImVec4(0.f, 0.f, 0.f, -1.f);
    m.attr("AUTO_COL") = ImVec4(0.f, 0.f, 0.f, -1.f);

    m.attr("VERSION") = IMPLOT3D_VERSION;

    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // <litgen_pydef> // Autogenerated code below! Do not edit!
    ////////////////////    <generated_from:implot3d.h>    ////////////////////
    // #ifndef IMGUI_DISABLE
    //
    // #ifdef IMGUI_BUNDLE_PYTHON_API
    //
    // #endif
    //


    auto pyEnumFlags_ =
        nb::enum_<ImPlot3DFlags_>(m, "Flags_", nb::is_arithmetic(), nb::is_flag(), "Flags for ImPlot3D::BeginPlot()")
            .value("none", ImPlot3DFlags_None, "Default")
            .value("no_title", ImPlot3DFlags_NoTitle, "Hide plot title")
            .value("no_legend", ImPlot3DFlags_NoLegend, "Hide plot legend")
            .value("no_mouse_text", ImPlot3DFlags_NoMouseText, "Hide mouse position in plot coordinates")
            .value("no_clip", ImPlot3DFlags_NoClip, "Disable 3D box clipping")
            .value("no_menus", ImPlot3DFlags_NoMenus, "The user will not be able to open context menus")
            .value("canvas_only", ImPlot3DFlags_CanvasOnly, "");


    auto pyEnumCond_ =
        nb::enum_<ImPlot3DCond_>(m, "Cond_", nb::is_arithmetic(), nb::is_flag(), "Represents a condition for SetupAxisLimits etc. (same as ImGuiCond, but we only support a subset of those enums)")
            .value("none", ImPlot3DCond_None, "No condition (always set the variable), same as _Always")
            .value("always", ImPlot3DCond_Always, "No condition (always set the variable)")
            .value("once", ImPlot3DCond_Once, "Set the variable once per runtime session (only the first call will succeed)");


    auto pyEnumCol_ =
        nb::enum_<ImPlot3DCol_>(m, "Col_", nb::is_arithmetic(), nb::is_flag(), "")
            .value("line", ImPlot3DCol_Line, "Line color")
            .value("fill", ImPlot3DCol_Fill, "Fill color")
            .value("marker_outline", ImPlot3DCol_MarkerOutline, "Marker outline color")
            .value("marker_fill", ImPlot3DCol_MarkerFill, "Marker fill color")
            .value("title_text", ImPlot3DCol_TitleText, "Title color")
            .value("inlay_text", ImPlot3DCol_InlayText, "Color for texts appearing inside of plots")
            .value("frame_bg", ImPlot3DCol_FrameBg, "Frame background color")
            .value("plot_bg", ImPlot3DCol_PlotBg, "Plot area background color")
            .value("plot_border", ImPlot3DCol_PlotBorder, "Plot area border color")
            .value("legend_bg", ImPlot3DCol_LegendBg, "Legend background color")
            .value("legend_border", ImPlot3DCol_LegendBorder, "Legend border color")
            .value("legend_text", ImPlot3DCol_LegendText, "Legend text color")
            .value("axis_text", ImPlot3DCol_AxisText, "Axis label and tick lables color")
            .value("axis_grid", ImPlot3DCol_AxisGrid, "Axis grid color")
            .value("axis_tick", ImPlot3DCol_AxisTick, "Axis tick color (defaults to AxisGrid)")
            .value("count", ImPlot3DCol_COUNT, "");


    auto pyEnumStyleVar_ =
        nb::enum_<ImPlot3DStyleVar_>(m, "StyleVar_", nb::is_arithmetic(), nb::is_flag(), "Plot styling variables")
            .value("line_weight", ImPlot3DStyleVar_LineWeight, "float, plot item line weight in pixels")
            .value("marker", ImPlot3DStyleVar_Marker, "int,   marker specification")
            .value("marker_size", ImPlot3DStyleVar_MarkerSize, "float, marker size in pixels (roughly the marker's \"radius\")")
            .value("marker_weight", ImPlot3DStyleVar_MarkerWeight, "float, plot outline weight of markers in pixels")
            .value("fill_alpha", ImPlot3DStyleVar_FillAlpha, "float, alpha modifier applied to all plot item fills")
            .value("plot_default_size", ImPlot3DStyleVar_PlotDefaultSize, "ImVec2, default size used when ImVec2(0,0) is passed to BeginPlot")
            .value("plot_min_size", ImPlot3DStyleVar_PlotMinSize, "ImVec2, minimum size plot frame can be when shrunk")
            .value("plot_padding", ImPlot3DStyleVar_PlotPadding, "ImVec2, padding between widget frame and plot area, labels, or outside legends (i.e. main padding)")
            .value("label_padding", ImPlot3DStyleVar_LabelPadding, "ImVec2, padding between axes labels, tick labels, and plot edge")
            .value("legend_padding", ImPlot3DStyleVar_LegendPadding, "ImVec2, legend padding from plot edges")
            .value("legend_inner_padding", ImPlot3DStyleVar_LegendInnerPadding, "ImVec2, legend inner padding from legend edges")
            .value("legend_spacing", ImPlot3DStyleVar_LegendSpacing, "ImVec2, spacing between legend entries")
            .value("count", ImPlot3DStyleVar_COUNT, "");


    auto pyEnumMarker_ =
        nb::enum_<ImPlot3DMarker_>(m, "Marker_", nb::is_arithmetic(), nb::is_flag(), "")
            .value("none", ImPlot3DMarker_None, "No marker")
            .value("circle", ImPlot3DMarker_Circle, "Circle marker (default)")
            .value("square", ImPlot3DMarker_Square, "Square maker")
            .value("diamond", ImPlot3DMarker_Diamond, "Diamond marker")
            .value("up", ImPlot3DMarker_Up, "Upward-pointing triangle marker")
            .value("down", ImPlot3DMarker_Down, "Downward-pointing triangle marker")
            .value("left", ImPlot3DMarker_Left, "Leftward-pointing triangle marker")
            .value("right", ImPlot3DMarker_Right, "Rightward-pointing triangle marker")
            .value("cross", ImPlot3DMarker_Cross, "Cross marker (not fillable)")
            .value("plus", ImPlot3DMarker_Plus, "Plus marker (not fillable)")
            .value("asterisk", ImPlot3DMarker_Asterisk, "Asterisk marker (not fillable)")
            .value("count", ImPlot3DMarker_COUNT, "");


    auto pyEnumItemFlags_ =
        nb::enum_<ImPlot3DItemFlags_>(m, "ItemFlags_", nb::is_arithmetic(), nb::is_flag(), "Flags for items")
            .value("none", ImPlot3DItemFlags_None, "Default")
            .value("no_legend", ImPlot3DItemFlags_NoLegend, "The item won't have a legend entry displayed")
            .value("no_fit", ImPlot3DItemFlags_NoFit, "The item won't be considered for plot fits");


    auto pyEnumScatterFlags_ =
        nb::enum_<ImPlot3DScatterFlags_>(m, "ScatterFlags_", nb::is_arithmetic(), nb::is_flag(), "Flags for PlotScatter")
            .value("none", ImPlot3DScatterFlags_None, "Default")
            .value("no_legend", ImPlot3DScatterFlags_NoLegend, "")
            .value("no_fit", ImPlot3DScatterFlags_NoFit, "");


    auto pyEnumLineFlags_ =
        nb::enum_<ImPlot3DLineFlags_>(m, "LineFlags_", nb::is_arithmetic(), nb::is_flag(), "Flags for PlotLine")
            .value("none", ImPlot3DLineFlags_None, "Default")
            .value("no_legend", ImPlot3DLineFlags_NoLegend, "")
            .value("no_fit", ImPlot3DLineFlags_NoFit, "")
            .value("segments", ImPlot3DLineFlags_Segments, "A line segment will be rendered from every two consecutive points")
            .value("loop", ImPlot3DLineFlags_Loop, "The last and first point will be connected to form a closed loop")
            .value("skip_nan", ImPlot3DLineFlags_SkipNaN, "NaNs values will be skipped instead of rendered as missing data");


    auto pyEnumTriangleFlags_ =
        nb::enum_<ImPlot3DTriangleFlags_>(m, "TriangleFlags_", nb::is_arithmetic(), nb::is_flag(), "Flags for PlotTriangle")
            .value("none", ImPlot3DTriangleFlags_None, "Default")
            .value("no_legend", ImPlot3DTriangleFlags_NoLegend, "")
            .value("no_fit", ImPlot3DTriangleFlags_NoFit, "")
            .value("no_lines", ImPlot3DTriangleFlags_NoLines, "No lines will be rendered")
            .value("no_fill", ImPlot3DTriangleFlags_NoFill, "No fill will be rendered")
            .value("no_markers", ImPlot3DTriangleFlags_NoMarkers, "No markers will be rendered");


    auto pyEnumQuadFlags_ =
        nb::enum_<ImPlot3DQuadFlags_>(m, "QuadFlags_", nb::is_arithmetic(), nb::is_flag(), "Flags for PlotQuad")
            .value("none", ImPlot3DQuadFlags_None, "Default")
            .value("no_legend", ImPlot3DQuadFlags_NoLegend, "")
            .value("no_fit", ImPlot3DQuadFlags_NoFit, "")
            .value("no_lines", ImPlot3DQuadFlags_NoLines, "No lines will be rendered")
            .value("no_fill", ImPlot3DQuadFlags_NoFill, "No fill will be rendered")
            .value("no_markers", ImPlot3DQuadFlags_NoMarkers, "No markers will be rendered");


    auto pyEnumSurfaceFlags_ =
        nb::enum_<ImPlot3DSurfaceFlags_>(m, "SurfaceFlags_", nb::is_arithmetic(), nb::is_flag(), "Flags for PlotSurface")
            .value("none", ImPlot3DSurfaceFlags_None, "Default")
            .value("no_legend", ImPlot3DSurfaceFlags_NoLegend, "")
            .value("no_fit", ImPlot3DSurfaceFlags_NoFit, "")
            .value("no_lines", ImPlot3DSurfaceFlags_NoLines, "No lines will be rendered")
            .value("no_fill", ImPlot3DSurfaceFlags_NoFill, "No fill will be rendered")
            .value("no_markers", ImPlot3DSurfaceFlags_NoMarkers, "No markers will be rendered");


    auto pyEnumMeshFlags_ =
        nb::enum_<ImPlot3DMeshFlags_>(m, "MeshFlags_", nb::is_arithmetic(), nb::is_flag(), "Flags for PlotMesh")
            .value("none", ImPlot3DMeshFlags_None, "Default")
            .value("no_legend", ImPlot3DMeshFlags_NoLegend, "")
            .value("no_fit", ImPlot3DMeshFlags_NoFit, "")
            .value("no_lines", ImPlot3DMeshFlags_NoLines, "No lines will be rendered")
            .value("no_fill", ImPlot3DMeshFlags_NoFill, "No fill will be rendered")
            .value("no_markers", ImPlot3DMeshFlags_NoMarkers, "No markers will be rendered");


    auto pyEnumImageFlags_ =
        nb::enum_<ImPlot3DImageFlags_>(m, "ImageFlags_", nb::is_arithmetic(), nb::is_flag(), "Flags for PlotImage")
            .value("none", ImPlot3DImageFlags_None, "Default")
            .value("no_legend", ImPlot3DImageFlags_NoLegend, "")
            .value("no_fit", ImPlot3DImageFlags_NoFit, "");


    auto pyEnumLegendFlags_ =
        nb::enum_<ImPlot3DLegendFlags_>(m, "LegendFlags_", nb::is_arithmetic(), nb::is_flag(), "Flags for legends")
            .value("none", ImPlot3DLegendFlags_None, "Default")
            .value("no_buttons", ImPlot3DLegendFlags_NoButtons, "Legend icons will not function as hide/show buttons")
            .value("no_highlight_item", ImPlot3DLegendFlags_NoHighlightItem, "Plot items will not be highlighted when their legend entry is hovered")
            .value("horizontal", ImPlot3DLegendFlags_Horizontal, "Legend entries will be displayed horizontally");


    auto pyEnumLocation_ =
        nb::enum_<ImPlot3DLocation_>(m, "Location_", nb::is_arithmetic(), nb::is_flag(), "Used to position legend on a plot")
            .value("center", ImPlot3DLocation_Center, "Center-center")
            .value("north", ImPlot3DLocation_North, "Top-center")
            .value("south", ImPlot3DLocation_South, "Bottom-center")
            .value("west", ImPlot3DLocation_West, "Center-left")
            .value("east", ImPlot3DLocation_East, "Center-right")
            .value("north_west", ImPlot3DLocation_NorthWest, "Top-left")
            .value("north_east", ImPlot3DLocation_NorthEast, "Top-right")
            .value("south_west", ImPlot3DLocation_SouthWest, "Bottom-left")
            .value("south_east", ImPlot3DLocation_SouthEast, "Bottom-right");


    auto pyEnumAxisFlags_ =
        nb::enum_<ImPlot3DAxisFlags_>(m, "AxisFlags_", nb::is_arithmetic(), nb::is_flag(), "Flags for axis")
            .value("none", ImPlot3DAxisFlags_None, "Default")
            .value("no_label", ImPlot3DAxisFlags_NoLabel, "No axis label will be displayed")
            .value("no_grid_lines", ImPlot3DAxisFlags_NoGridLines, "No grid lines will be displayed")
            .value("no_tick_marks", ImPlot3DAxisFlags_NoTickMarks, "No tick marks will be displayed")
            .value("no_tick_labels", ImPlot3DAxisFlags_NoTickLabels, "No tick labels will be displayed")
            .value("lock_min", ImPlot3DAxisFlags_LockMin, "The axis minimum value will be locked when panning/zooming")
            .value("lock_max", ImPlot3DAxisFlags_LockMax, "The axis maximum value will be locked when panning/zooming")
            .value("auto_fit", ImPlot3DAxisFlags_AutoFit, "Axis will be auto-fitting to data extents")
            .value("invert", ImPlot3DAxisFlags_Invert, "The axis will be inverted")
            .value("pan_stretch", ImPlot3DAxisFlags_PanStretch, "Panning in a locked or constrained state will cause the axis to stretch if possible")
            .value("lock", ImPlot3DAxisFlags_Lock, "")
            .value("no_decorations", ImPlot3DAxisFlags_NoDecorations, "");


    auto pyEnumImAxis3D_ =
        nb::enum_<ImAxis3D_>(m, "ImAxis3D_", nb::is_arithmetic(), nb::is_flag(), "Axis indices")
            .value("x", ImAxis3D_X, "")
            .value("y", ImAxis3D_Y, "")
            .value("z", ImAxis3D_Z, "")
            .value("count", ImAxis3D_COUNT, "");


    auto pyEnumImPlane3D_ =
        nb::enum_<ImPlane3D_>(m, "ImPlane3D_", nb::is_arithmetic(), nb::is_flag(), "Plane indices")
            .value("yz", ImPlane3D_YZ, "")
            .value("xz", ImPlane3D_XZ, "")
            .value("xy", ImPlane3D_XY, "")
            .value("count", ImPlane3D_COUNT, "");


    auto pyEnumColormap_ =
        nb::enum_<ImPlot3DColormap_>(m, "Colormap_", nb::is_arithmetic(), nb::is_flag(), "Colormaps")
            .value("deep", ImPlot3DColormap_Deep, "Same as seaborn \"deep\"")
            .value("dark", ImPlot3DColormap_Dark, "Same as matplotlib \"Set1\"")
            .value("pastel", ImPlot3DColormap_Pastel, "Same as matplotlib \"Pastel1\"")
            .value("paired", ImPlot3DColormap_Paired, "Same as matplotlib \"Paired\"")
            .value("viridis", ImPlot3DColormap_Viridis, "Same as matplotlib \"viridis\"")
            .value("plasma", ImPlot3DColormap_Plasma, "Same as matplotlib \"plasma\"")
            .value("hot", ImPlot3DColormap_Hot, "Same as matplotlib/MATLAB \"hot\"")
            .value("cool", ImPlot3DColormap_Cool, "Same as matplotlib/MATLAB \"cool\"")
            .value("pink", ImPlot3DColormap_Pink, "Same as matplotlib/MATLAB \"pink\"")
            .value("jet", ImPlot3DColormap_Jet, "Same as matplotlib/MATLAB \"jet\"")
            .value("twilight", ImPlot3DColormap_Twilight, "Same as matplotlib \"twilight\"")
            .value("rd_bu", ImPlot3DColormap_RdBu, "Same as matplotlib \"RdBu\"")
            .value("br_bg", ImPlot3DColormap_BrBG, "Same as matplotlib \"BrGB\"")
            .value("pi_yg", ImPlot3DColormap_PiYG, "Same as matplotlib \"PiYG\"")
            .value("spectral", ImPlot3DColormap_Spectral, "Same as matplotlib \"Spectral\"")
            .value("greys", ImPlot3DColormap_Greys, "White/black");


    m.def("create_context",
        ImPlot3D::CreateContext, nb::rv_policy::reference);

    m.def("destroy_context",
        ImPlot3D::DestroyContext, nb::arg("ctx") = nb::none());

    m.def("get_current_context",
        ImPlot3D::GetCurrentContext, nb::rv_policy::reference);

    m.def("set_current_context",
        ImPlot3D::SetCurrentContext, nb::arg("ctx"));

    m.def("begin_plot",
        [](const char * title_id, const std::optional<const ImVec2> & size = std::nullopt, ImPlot3DFlags flags = 0) -> bool
        {
            auto BeginPlot_adapt_mutable_param_with_default_value = [](const char * title_id, const std::optional<const ImVec2> & size = std::nullopt, ImPlot3DFlags flags = 0) -> bool
            {

                const ImVec2& size_or_default = [&]() -> const ImVec2 {
                    if (size.has_value())
                        return size.value();
                    else
                        return ImVec2(-1, 0);
                }();

                auto lambda_result = ImPlot3D::BeginPlot(title_id, size_or_default, flags);
                return lambda_result;
            };

            return BeginPlot_adapt_mutable_param_with_default_value(title_id, size, flags);
        },
        nb::arg("title_id"), nb::arg("size").none() = nb::none(), nb::arg("flags") = 0,
        "Python bindings defaults:\n    If size is None, then its default value will be: ImVec2(-1, 0)");

    m.def("end_plot",
        ImPlot3D::EndPlot, "Only call if BeginPlot() returns True!");

    m.def("setup_axis",
        [](ImAxis3D axis, std::optional<std::string> label = std::nullopt, ImPlot3DAxisFlags flags = 0)
        {
            auto SetupAxis_adapt_const_char_pointer_with_default_null = [](ImAxis3D axis, std::optional<std::string> label = std::nullopt, ImPlot3DAxisFlags flags = 0)
            {
                const char * label_adapt_default_null = nullptr;
                if (label.has_value())
                    label_adapt_default_null = label.value().c_str();

                ImPlot3D::SetupAxis(axis, label_adapt_default_null, flags);
            };

            SetupAxis_adapt_const_char_pointer_with_default_null(axis, label, flags);
        },
        nb::arg("axis"), nb::arg("label").none() = nb::none(), nb::arg("flags") = 0,
        "Enables an axis or sets the label and/or flags for an existing axis. Leave #label = None for no label");

    m.def("setup_axis_limits",
        [](ImAxis3D axis, double v_min, double v_max, const std::optional<const ImPlot3DCond> & cond = std::nullopt)
        {
            auto SetupAxisLimits_adapt_mutable_param_with_default_value = [](ImAxis3D axis, double v_min, double v_max, const std::optional<const ImPlot3DCond> & cond = std::nullopt)
            {

                const ImPlot3DCond& cond_or_default = [&]() -> const ImPlot3DCond {
                    if (cond.has_value())
                        return cond.value();
                    else
                        return ImPlot3DCond_Once;
                }();

                ImPlot3D::SetupAxisLimits(axis, v_min, v_max, cond_or_default);
            };

            SetupAxisLimits_adapt_mutable_param_with_default_value(axis, v_min, v_max, cond);
        },
        nb::arg("axis"), nb::arg("v_min"), nb::arg("v_max"), nb::arg("cond").none() = nb::none(),
        "Python bindings defaults:\n    If cond is None, then its default value will be: Cond_Once");

    m.def("setup_axis_limits_constraints",
        ImPlot3D::SetupAxisLimitsConstraints,
        nb::arg("axis"), nb::arg("v_min"), nb::arg("v_max"),
        "Sets an axis' limits constraints");

    m.def("setup_axis_zoom_constraints",
        ImPlot3D::SetupAxisZoomConstraints,
        nb::arg("axis"), nb::arg("z_min"), nb::arg("z_max"),
        "Sets an axis' zoom constraints");

    m.def("setup_axes",
        ImPlot3D::SetupAxes,
        nb::arg("x_label"), nb::arg("y_label"), nb::arg("z_label"), nb::arg("x_flags") = 0, nb::arg("y_flags") = 0, nb::arg("z_flags") = 0,
        "Sets the label and/or flags for primary X/Y/Z axes (shorthand for three calls to SetupAxis)");

    m.def("setup_axes_limits",
        [](double x_min, double x_max, double y_min, double y_max, double z_min, double z_max, const std::optional<const ImPlot3DCond> & cond = std::nullopt)
        {
            auto SetupAxesLimits_adapt_mutable_param_with_default_value = [](double x_min, double x_max, double y_min, double y_max, double z_min, double z_max, const std::optional<const ImPlot3DCond> & cond = std::nullopt)
            {

                const ImPlot3DCond& cond_or_default = [&]() -> const ImPlot3DCond {
                    if (cond.has_value())
                        return cond.value();
                    else
                        return ImPlot3DCond_Once;
                }();

                ImPlot3D::SetupAxesLimits(x_min, x_max, y_min, y_max, z_min, z_max, cond_or_default);
            };

            SetupAxesLimits_adapt_mutable_param_with_default_value(x_min, x_max, y_min, y_max, z_min, z_max, cond);
        },
        nb::arg("x_min"), nb::arg("x_max"), nb::arg("y_min"), nb::arg("y_max"), nb::arg("z_min"), nb::arg("z_max"), nb::arg("cond").none() = nb::none(),
        " Sets the X/Y/Z axes range limits. If ImPlot3DCond_Always is used, the axes limits will be locked (shorthand for two calls to SetupAxisLimits)\n\n\nPython bindings defaults:\n    If cond is None, then its default value will be: Cond_Once");

    m.def("setup_box_rotation",
        [](float elevation, float azimuth, bool animate = false, const std::optional<const ImPlot3DCond> & cond = std::nullopt)
        {
            auto SetupBoxRotation_adapt_mutable_param_with_default_value = [](float elevation, float azimuth, bool animate = false, const std::optional<const ImPlot3DCond> & cond = std::nullopt)
            {

                const ImPlot3DCond& cond_or_default = [&]() -> const ImPlot3DCond {
                    if (cond.has_value())
                        return cond.value();
                    else
                        return ImPlot3DCond_Once;
                }();

                ImPlot3D::SetupBoxRotation(elevation, azimuth, animate, cond_or_default);
            };

            SetupBoxRotation_adapt_mutable_param_with_default_value(elevation, azimuth, animate, cond);
        },
        nb::arg("elevation"), nb::arg("azimuth"), nb::arg("animate") = false, nb::arg("cond").none() = nb::none(),
        " Sets the plot box rotation given the elevation and azimuth angles in degrees. If ImPlot3DCond_Always is used, the rotation will be locked\n\n\nPython bindings defaults:\n    If cond is None, then its default value will be: Cond_Once");

    m.def("setup_box_rotation",
        [](ImPlot3DQuat rotation, bool animate = false, const std::optional<const ImPlot3DCond> & cond = std::nullopt)
        {
            auto SetupBoxRotation_adapt_mutable_param_with_default_value = [](ImPlot3DQuat rotation, bool animate = false, const std::optional<const ImPlot3DCond> & cond = std::nullopt)
            {

                const ImPlot3DCond& cond_or_default = [&]() -> const ImPlot3DCond {
                    if (cond.has_value())
                        return cond.value();
                    else
                        return ImPlot3DCond_Once;
                }();

                ImPlot3D::SetupBoxRotation(rotation, animate, cond_or_default);
            };

            SetupBoxRotation_adapt_mutable_param_with_default_value(rotation, animate, cond);
        },
        nb::arg("rotation"), nb::arg("animate") = false, nb::arg("cond").none() = nb::none(),
        " Sets the plot box rotation given a quaternion. If ImPlot3DCond_Always is used, the rotation will be locked\n\n\nPython bindings defaults:\n    If cond is None, then its default value will be: Cond_Once");

    m.def("setup_box_initial_rotation",
        nb::overload_cast<float, float>(ImPlot3D::SetupBoxInitialRotation),
        nb::arg("elevation"), nb::arg("azimuth"),
        " Sets the plot box initial rotation given the elevation and azimuth angles in degrees. The initial rotation is the rotation the plot goes back to\n when a left mouse button double click happens");

    m.def("setup_box_initial_rotation",
        nb::overload_cast<ImPlot3DQuat>(ImPlot3D::SetupBoxInitialRotation),
        nb::arg("rotation"),
        " Sets the plot box initial rotation given a quaternion. The initial rotation is the rotation the plot goes back to when a left mouse button double\n click happens");

    m.def("setup_box_scale",
        ImPlot3D::SetupBoxScale,
        nb::arg("x"), nb::arg("y"), nb::arg("z"),
        "Sets the plot box X/Y/Z scale. A scale of 1.0 is the default. Values greater than 1.0 enlarge the plot, while values between 0.0 and 1.0 shrink it");

    m.def("setup_legend",
        ImPlot3D::SetupLegend, nb::arg("location"), nb::arg("flags") = 0);

    m.def("plot_scatter",
        [](const char * label_id, const nb::ndarray<> & xs, const nb::ndarray<> & ys, const nb::ndarray<> & zs, ImPlot3DScatterFlags flags = 0, int offset = 0, int stride = -1)
        {
            auto PlotScatter_adapt_c_buffers = [](const char * label_id, const nb::ndarray<> & xs, const nb::ndarray<> & ys, const nb::ndarray<> & zs, ImPlot3DScatterFlags flags = 0, int offset = 0, int stride = -1)
            {
                // Check if the array is 1D and C-contiguous
                if (! (xs.ndim() == 1 && xs.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (const)
                const void * xs_from_pyarray = xs.data();
                size_t xs_count = xs.shape(0);

                // Check if the array is 1D and C-contiguous
                if (! (ys.ndim() == 1 && ys.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (const)
                const void * ys_from_pyarray = ys.data();
                size_t ys_count = ys.shape(0);

                // Check if the array is 1D and C-contiguous
                if (! (zs.ndim() == 1 && zs.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (const)
                const void * zs_from_pyarray = zs.data();
                size_t zs_count = zs.shape(0);

                // process stride default value (which was a sizeof in C++)
                int zs_stride = stride;
                if (zs_stride == -1)
                    zs_stride = (int)zs.itemsize();

                using np_uint_l = uint64_t;
                using np_int_l = int64_t;

                // Define a lambda to compute the letter code for the buffer type
                auto _nanobind_buffer_type_to_letter_code = [](uint8_t dtype_code, size_t sizeof_item)  -> char
                {
                    #define DCODE(T) static_cast<uint8_t>(nb::dlpack::dtype_code::T)
                        const std::array<std::tuple<uint8_t, size_t, char>, 11> mappings = {{
                            {DCODE(UInt), 1, 'B'}, {DCODE(UInt), 2, 'H'}, {DCODE(UInt), 4, 'I'}, {DCODE(UInt), 8, 'L'},
                            {DCODE(Int), 1, 'b'}, {DCODE(Int), 2, 'h'}, {DCODE(Int), 4, 'i'}, {DCODE(Int), 8, 'l'},
                            {DCODE(Float), 4, 'f'}, {DCODE(Float), 8, 'd'}, {DCODE(Float), 16, 'g'}
                        }};
                    #undef DCODE
                    for (const auto& [code_val, size, letter] : mappings)
                        if (code_val == dtype_code && size == sizeof_item)
                            return letter;
                    throw std::runtime_error("Unsupported dtype");
                };

                // Compute the letter code for the buffer type
                uint8_t dtype_code_zs = zs.dtype().code;
                size_t sizeof_item_zs = zs.dtype().bits / 8;
                char zs_type = _nanobind_buffer_type_to_letter_code(dtype_code_zs, sizeof_item_zs);

                // call the correct template version by casting
                if (zs_type == 'B')
                    ImPlot3D::PlotScatter(label_id, static_cast<const uint8_t *>(xs_from_pyarray), static_cast<const uint8_t *>(ys_from_pyarray), static_cast<const uint8_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'b')
                    ImPlot3D::PlotScatter(label_id, static_cast<const int8_t *>(xs_from_pyarray), static_cast<const int8_t *>(ys_from_pyarray), static_cast<const int8_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'H')
                    ImPlot3D::PlotScatter(label_id, static_cast<const uint16_t *>(xs_from_pyarray), static_cast<const uint16_t *>(ys_from_pyarray), static_cast<const uint16_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'h')
                    ImPlot3D::PlotScatter(label_id, static_cast<const int16_t *>(xs_from_pyarray), static_cast<const int16_t *>(ys_from_pyarray), static_cast<const int16_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'I')
                    ImPlot3D::PlotScatter(label_id, static_cast<const uint32_t *>(xs_from_pyarray), static_cast<const uint32_t *>(ys_from_pyarray), static_cast<const uint32_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'i')
                    ImPlot3D::PlotScatter(label_id, static_cast<const int32_t *>(xs_from_pyarray), static_cast<const int32_t *>(ys_from_pyarray), static_cast<const int32_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'L')
                    ImPlot3D::PlotScatter(label_id, static_cast<const np_uint_l *>(xs_from_pyarray), static_cast<const np_uint_l *>(ys_from_pyarray), static_cast<const np_uint_l *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'l')
                    ImPlot3D::PlotScatter(label_id, static_cast<const np_int_l *>(xs_from_pyarray), static_cast<const np_int_l *>(ys_from_pyarray), static_cast<const np_int_l *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'f')
                    ImPlot3D::PlotScatter(label_id, static_cast<const float *>(xs_from_pyarray), static_cast<const float *>(ys_from_pyarray), static_cast<const float *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'd')
                    ImPlot3D::PlotScatter(label_id, static_cast<const double *>(xs_from_pyarray), static_cast<const double *>(ys_from_pyarray), static_cast<const double *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'g')
                    ImPlot3D::PlotScatter(label_id, static_cast<const long double *>(xs_from_pyarray), static_cast<const long double *>(ys_from_pyarray), static_cast<const long double *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'q')
                    ImPlot3D::PlotScatter(label_id, static_cast<const long long *>(xs_from_pyarray), static_cast<const long long *>(ys_from_pyarray), static_cast<const long long *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                // If we reach this point, the array type is not supported!
                else
                    throw std::runtime_error(std::string("Bad array type ('") + zs_type + "') for param zs");
            };

            PlotScatter_adapt_c_buffers(label_id, xs, ys, zs, flags, offset, stride);
        },     nb::arg("label_id"), nb::arg("xs"), nb::arg("ys"), nb::arg("zs"), nb::arg("flags") = 0, nb::arg("offset") = 0, nb::arg("stride") = -1);

    m.def("plot_line",
        [](const char * label_id, const nb::ndarray<> & xs, const nb::ndarray<> & ys, const nb::ndarray<> & zs, ImPlot3DLineFlags flags = 0, int offset = 0, int stride = -1)
        {
            auto PlotLine_adapt_c_buffers = [](const char * label_id, const nb::ndarray<> & xs, const nb::ndarray<> & ys, const nb::ndarray<> & zs, ImPlot3DLineFlags flags = 0, int offset = 0, int stride = -1)
            {
                // Check if the array is 1D and C-contiguous
                if (! (xs.ndim() == 1 && xs.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (const)
                const void * xs_from_pyarray = xs.data();
                size_t xs_count = xs.shape(0);

                // Check if the array is 1D and C-contiguous
                if (! (ys.ndim() == 1 && ys.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (const)
                const void * ys_from_pyarray = ys.data();
                size_t ys_count = ys.shape(0);

                // Check if the array is 1D and C-contiguous
                if (! (zs.ndim() == 1 && zs.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (const)
                const void * zs_from_pyarray = zs.data();
                size_t zs_count = zs.shape(0);

                // process stride default value (which was a sizeof in C++)
                int zs_stride = stride;
                if (zs_stride == -1)
                    zs_stride = (int)zs.itemsize();

                using np_uint_l = uint64_t;
                using np_int_l = int64_t;

                // Define a lambda to compute the letter code for the buffer type
                auto _nanobind_buffer_type_to_letter_code = [](uint8_t dtype_code, size_t sizeof_item)  -> char
                {
                    #define DCODE(T) static_cast<uint8_t>(nb::dlpack::dtype_code::T)
                        const std::array<std::tuple<uint8_t, size_t, char>, 11> mappings = {{
                            {DCODE(UInt), 1, 'B'}, {DCODE(UInt), 2, 'H'}, {DCODE(UInt), 4, 'I'}, {DCODE(UInt), 8, 'L'},
                            {DCODE(Int), 1, 'b'}, {DCODE(Int), 2, 'h'}, {DCODE(Int), 4, 'i'}, {DCODE(Int), 8, 'l'},
                            {DCODE(Float), 4, 'f'}, {DCODE(Float), 8, 'd'}, {DCODE(Float), 16, 'g'}
                        }};
                    #undef DCODE
                    for (const auto& [code_val, size, letter] : mappings)
                        if (code_val == dtype_code && size == sizeof_item)
                            return letter;
                    throw std::runtime_error("Unsupported dtype");
                };

                // Compute the letter code for the buffer type
                uint8_t dtype_code_zs = zs.dtype().code;
                size_t sizeof_item_zs = zs.dtype().bits / 8;
                char zs_type = _nanobind_buffer_type_to_letter_code(dtype_code_zs, sizeof_item_zs);

                // call the correct template version by casting
                if (zs_type == 'B')
                    ImPlot3D::PlotLine(label_id, static_cast<const uint8_t *>(xs_from_pyarray), static_cast<const uint8_t *>(ys_from_pyarray), static_cast<const uint8_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'b')
                    ImPlot3D::PlotLine(label_id, static_cast<const int8_t *>(xs_from_pyarray), static_cast<const int8_t *>(ys_from_pyarray), static_cast<const int8_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'H')
                    ImPlot3D::PlotLine(label_id, static_cast<const uint16_t *>(xs_from_pyarray), static_cast<const uint16_t *>(ys_from_pyarray), static_cast<const uint16_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'h')
                    ImPlot3D::PlotLine(label_id, static_cast<const int16_t *>(xs_from_pyarray), static_cast<const int16_t *>(ys_from_pyarray), static_cast<const int16_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'I')
                    ImPlot3D::PlotLine(label_id, static_cast<const uint32_t *>(xs_from_pyarray), static_cast<const uint32_t *>(ys_from_pyarray), static_cast<const uint32_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'i')
                    ImPlot3D::PlotLine(label_id, static_cast<const int32_t *>(xs_from_pyarray), static_cast<const int32_t *>(ys_from_pyarray), static_cast<const int32_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'L')
                    ImPlot3D::PlotLine(label_id, static_cast<const np_uint_l *>(xs_from_pyarray), static_cast<const np_uint_l *>(ys_from_pyarray), static_cast<const np_uint_l *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'l')
                    ImPlot3D::PlotLine(label_id, static_cast<const np_int_l *>(xs_from_pyarray), static_cast<const np_int_l *>(ys_from_pyarray), static_cast<const np_int_l *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'f')
                    ImPlot3D::PlotLine(label_id, static_cast<const float *>(xs_from_pyarray), static_cast<const float *>(ys_from_pyarray), static_cast<const float *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'd')
                    ImPlot3D::PlotLine(label_id, static_cast<const double *>(xs_from_pyarray), static_cast<const double *>(ys_from_pyarray), static_cast<const double *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'g')
                    ImPlot3D::PlotLine(label_id, static_cast<const long double *>(xs_from_pyarray), static_cast<const long double *>(ys_from_pyarray), static_cast<const long double *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'q')
                    ImPlot3D::PlotLine(label_id, static_cast<const long long *>(xs_from_pyarray), static_cast<const long long *>(ys_from_pyarray), static_cast<const long long *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                // If we reach this point, the array type is not supported!
                else
                    throw std::runtime_error(std::string("Bad array type ('") + zs_type + "') for param zs");
            };

            PlotLine_adapt_c_buffers(label_id, xs, ys, zs, flags, offset, stride);
        },     nb::arg("label_id"), nb::arg("xs"), nb::arg("ys"), nb::arg("zs"), nb::arg("flags") = 0, nb::arg("offset") = 0, nb::arg("stride") = -1);

    m.def("plot_triangle",
        [](const char * label_id, const nb::ndarray<> & xs, const nb::ndarray<> & ys, const nb::ndarray<> & zs, ImPlot3DTriangleFlags flags = 0, int offset = 0, int stride = -1)
        {
            auto PlotTriangle_adapt_c_buffers = [](const char * label_id, const nb::ndarray<> & xs, const nb::ndarray<> & ys, const nb::ndarray<> & zs, ImPlot3DTriangleFlags flags = 0, int offset = 0, int stride = -1)
            {
                // Check if the array is 1D and C-contiguous
                if (! (xs.ndim() == 1 && xs.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (const)
                const void * xs_from_pyarray = xs.data();
                size_t xs_count = xs.shape(0);

                // Check if the array is 1D and C-contiguous
                if (! (ys.ndim() == 1 && ys.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (const)
                const void * ys_from_pyarray = ys.data();
                size_t ys_count = ys.shape(0);

                // Check if the array is 1D and C-contiguous
                if (! (zs.ndim() == 1 && zs.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (const)
                const void * zs_from_pyarray = zs.data();
                size_t zs_count = zs.shape(0);

                // process stride default value (which was a sizeof in C++)
                int zs_stride = stride;
                if (zs_stride == -1)
                    zs_stride = (int)zs.itemsize();

                using np_uint_l = uint64_t;
                using np_int_l = int64_t;

                // Define a lambda to compute the letter code for the buffer type
                auto _nanobind_buffer_type_to_letter_code = [](uint8_t dtype_code, size_t sizeof_item)  -> char
                {
                    #define DCODE(T) static_cast<uint8_t>(nb::dlpack::dtype_code::T)
                        const std::array<std::tuple<uint8_t, size_t, char>, 11> mappings = {{
                            {DCODE(UInt), 1, 'B'}, {DCODE(UInt), 2, 'H'}, {DCODE(UInt), 4, 'I'}, {DCODE(UInt), 8, 'L'},
                            {DCODE(Int), 1, 'b'}, {DCODE(Int), 2, 'h'}, {DCODE(Int), 4, 'i'}, {DCODE(Int), 8, 'l'},
                            {DCODE(Float), 4, 'f'}, {DCODE(Float), 8, 'd'}, {DCODE(Float), 16, 'g'}
                        }};
                    #undef DCODE
                    for (const auto& [code_val, size, letter] : mappings)
                        if (code_val == dtype_code && size == sizeof_item)
                            return letter;
                    throw std::runtime_error("Unsupported dtype");
                };

                // Compute the letter code for the buffer type
                uint8_t dtype_code_zs = zs.dtype().code;
                size_t sizeof_item_zs = zs.dtype().bits / 8;
                char zs_type = _nanobind_buffer_type_to_letter_code(dtype_code_zs, sizeof_item_zs);

                // call the correct template version by casting
                if (zs_type == 'B')
                    ImPlot3D::PlotTriangle(label_id, static_cast<const uint8_t *>(xs_from_pyarray), static_cast<const uint8_t *>(ys_from_pyarray), static_cast<const uint8_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'b')
                    ImPlot3D::PlotTriangle(label_id, static_cast<const int8_t *>(xs_from_pyarray), static_cast<const int8_t *>(ys_from_pyarray), static_cast<const int8_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'H')
                    ImPlot3D::PlotTriangle(label_id, static_cast<const uint16_t *>(xs_from_pyarray), static_cast<const uint16_t *>(ys_from_pyarray), static_cast<const uint16_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'h')
                    ImPlot3D::PlotTriangle(label_id, static_cast<const int16_t *>(xs_from_pyarray), static_cast<const int16_t *>(ys_from_pyarray), static_cast<const int16_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'I')
                    ImPlot3D::PlotTriangle(label_id, static_cast<const uint32_t *>(xs_from_pyarray), static_cast<const uint32_t *>(ys_from_pyarray), static_cast<const uint32_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'i')
                    ImPlot3D::PlotTriangle(label_id, static_cast<const int32_t *>(xs_from_pyarray), static_cast<const int32_t *>(ys_from_pyarray), static_cast<const int32_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'L')
                    ImPlot3D::PlotTriangle(label_id, static_cast<const np_uint_l *>(xs_from_pyarray), static_cast<const np_uint_l *>(ys_from_pyarray), static_cast<const np_uint_l *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'l')
                    ImPlot3D::PlotTriangle(label_id, static_cast<const np_int_l *>(xs_from_pyarray), static_cast<const np_int_l *>(ys_from_pyarray), static_cast<const np_int_l *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'f')
                    ImPlot3D::PlotTriangle(label_id, static_cast<const float *>(xs_from_pyarray), static_cast<const float *>(ys_from_pyarray), static_cast<const float *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'd')
                    ImPlot3D::PlotTriangle(label_id, static_cast<const double *>(xs_from_pyarray), static_cast<const double *>(ys_from_pyarray), static_cast<const double *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'g')
                    ImPlot3D::PlotTriangle(label_id, static_cast<const long double *>(xs_from_pyarray), static_cast<const long double *>(ys_from_pyarray), static_cast<const long double *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'q')
                    ImPlot3D::PlotTriangle(label_id, static_cast<const long long *>(xs_from_pyarray), static_cast<const long long *>(ys_from_pyarray), static_cast<const long long *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                // If we reach this point, the array type is not supported!
                else
                    throw std::runtime_error(std::string("Bad array type ('") + zs_type + "') for param zs");
            };

            PlotTriangle_adapt_c_buffers(label_id, xs, ys, zs, flags, offset, stride);
        },     nb::arg("label_id"), nb::arg("xs"), nb::arg("ys"), nb::arg("zs"), nb::arg("flags") = 0, nb::arg("offset") = 0, nb::arg("stride") = -1);

    m.def("plot_quad",
        [](const char * label_id, const nb::ndarray<> & xs, const nb::ndarray<> & ys, const nb::ndarray<> & zs, ImPlot3DQuadFlags flags = 0, int offset = 0, int stride = -1)
        {
            auto PlotQuad_adapt_c_buffers = [](const char * label_id, const nb::ndarray<> & xs, const nb::ndarray<> & ys, const nb::ndarray<> & zs, ImPlot3DQuadFlags flags = 0, int offset = 0, int stride = -1)
            {
                // Check if the array is 1D and C-contiguous
                if (! (xs.ndim() == 1 && xs.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (const)
                const void * xs_from_pyarray = xs.data();
                size_t xs_count = xs.shape(0);

                // Check if the array is 1D and C-contiguous
                if (! (ys.ndim() == 1 && ys.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (const)
                const void * ys_from_pyarray = ys.data();
                size_t ys_count = ys.shape(0);

                // Check if the array is 1D and C-contiguous
                if (! (zs.ndim() == 1 && zs.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (const)
                const void * zs_from_pyarray = zs.data();
                size_t zs_count = zs.shape(0);

                // process stride default value (which was a sizeof in C++)
                int zs_stride = stride;
                if (zs_stride == -1)
                    zs_stride = (int)zs.itemsize();

                using np_uint_l = uint64_t;
                using np_int_l = int64_t;

                // Define a lambda to compute the letter code for the buffer type
                auto _nanobind_buffer_type_to_letter_code = [](uint8_t dtype_code, size_t sizeof_item)  -> char
                {
                    #define DCODE(T) static_cast<uint8_t>(nb::dlpack::dtype_code::T)
                        const std::array<std::tuple<uint8_t, size_t, char>, 11> mappings = {{
                            {DCODE(UInt), 1, 'B'}, {DCODE(UInt), 2, 'H'}, {DCODE(UInt), 4, 'I'}, {DCODE(UInt), 8, 'L'},
                            {DCODE(Int), 1, 'b'}, {DCODE(Int), 2, 'h'}, {DCODE(Int), 4, 'i'}, {DCODE(Int), 8, 'l'},
                            {DCODE(Float), 4, 'f'}, {DCODE(Float), 8, 'd'}, {DCODE(Float), 16, 'g'}
                        }};
                    #undef DCODE
                    for (const auto& [code_val, size, letter] : mappings)
                        if (code_val == dtype_code && size == sizeof_item)
                            return letter;
                    throw std::runtime_error("Unsupported dtype");
                };

                // Compute the letter code for the buffer type
                uint8_t dtype_code_zs = zs.dtype().code;
                size_t sizeof_item_zs = zs.dtype().bits / 8;
                char zs_type = _nanobind_buffer_type_to_letter_code(dtype_code_zs, sizeof_item_zs);

                // call the correct template version by casting
                if (zs_type == 'B')
                    ImPlot3D::PlotQuad(label_id, static_cast<const uint8_t *>(xs_from_pyarray), static_cast<const uint8_t *>(ys_from_pyarray), static_cast<const uint8_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'b')
                    ImPlot3D::PlotQuad(label_id, static_cast<const int8_t *>(xs_from_pyarray), static_cast<const int8_t *>(ys_from_pyarray), static_cast<const int8_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'H')
                    ImPlot3D::PlotQuad(label_id, static_cast<const uint16_t *>(xs_from_pyarray), static_cast<const uint16_t *>(ys_from_pyarray), static_cast<const uint16_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'h')
                    ImPlot3D::PlotQuad(label_id, static_cast<const int16_t *>(xs_from_pyarray), static_cast<const int16_t *>(ys_from_pyarray), static_cast<const int16_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'I')
                    ImPlot3D::PlotQuad(label_id, static_cast<const uint32_t *>(xs_from_pyarray), static_cast<const uint32_t *>(ys_from_pyarray), static_cast<const uint32_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'i')
                    ImPlot3D::PlotQuad(label_id, static_cast<const int32_t *>(xs_from_pyarray), static_cast<const int32_t *>(ys_from_pyarray), static_cast<const int32_t *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'L')
                    ImPlot3D::PlotQuad(label_id, static_cast<const np_uint_l *>(xs_from_pyarray), static_cast<const np_uint_l *>(ys_from_pyarray), static_cast<const np_uint_l *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'l')
                    ImPlot3D::PlotQuad(label_id, static_cast<const np_int_l *>(xs_from_pyarray), static_cast<const np_int_l *>(ys_from_pyarray), static_cast<const np_int_l *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'f')
                    ImPlot3D::PlotQuad(label_id, static_cast<const float *>(xs_from_pyarray), static_cast<const float *>(ys_from_pyarray), static_cast<const float *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'd')
                    ImPlot3D::PlotQuad(label_id, static_cast<const double *>(xs_from_pyarray), static_cast<const double *>(ys_from_pyarray), static_cast<const double *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'g')
                    ImPlot3D::PlotQuad(label_id, static_cast<const long double *>(xs_from_pyarray), static_cast<const long double *>(ys_from_pyarray), static_cast<const long double *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                else if (zs_type == 'q')
                    ImPlot3D::PlotQuad(label_id, static_cast<const long long *>(xs_from_pyarray), static_cast<const long long *>(ys_from_pyarray), static_cast<const long long *>(zs_from_pyarray), static_cast<int>(zs_count), flags, offset, zs_stride);
                // If we reach this point, the array type is not supported!
                else
                    throw std::runtime_error(std::string("Bad array type ('") + zs_type + "') for param zs");
            };

            PlotQuad_adapt_c_buffers(label_id, xs, ys, zs, flags, offset, stride);
        },     nb::arg("label_id"), nb::arg("xs"), nb::arg("ys"), nb::arg("zs"), nb::arg("flags") = 0, nb::arg("offset") = 0, nb::arg("stride") = -1);
    // #ifdef IMGUI_BUNDLE_PYTHON_API
    //

    m.def("plot_surface",
        [](const char * label_id, const nb::ndarray<> & xs, const nb::ndarray<> & ys, const nb::ndarray<> & zs, int x_count, int y_count, double scale_min = 0.0, double scale_max = 0.0, ImPlot3DSurfaceFlags flags = 0, int offset = 0, int stride = -1)
        {
            auto PlotSurface_adapt_c_buffers = [](const char * label_id, const nb::ndarray<> & xs, const nb::ndarray<> & ys, const nb::ndarray<> & zs, int x_count, int y_count, double scale_min = 0.0, double scale_max = 0.0, ImPlot3DSurfaceFlags flags = 0, int offset = 0, int stride = -1)
            {
                // Check if the array is 1D and C-contiguous
                if (! (xs.ndim() == 1 && xs.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (const)
                const void * xs_from_pyarray = xs.data();
                size_t xs_count = xs.shape(0);

                // Check if the array is 1D and C-contiguous
                if (! (ys.ndim() == 1 && ys.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (const)
                const void * ys_from_pyarray = ys.data();
                size_t ys_count = ys.shape(0);

                // Check if the array is 1D and C-contiguous
                if (! (zs.ndim() == 1 && zs.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (const)
                const void * zs_from_pyarray = zs.data();
                size_t zs_count = zs.shape(0);

                // process stride default value (which was a sizeof in C++)
                int zs_stride = stride;
                if (zs_stride == -1)
                    zs_stride = (int)zs.itemsize();

                using np_uint_l = uint64_t;
                using np_int_l = int64_t;

                // Define a lambda to compute the letter code for the buffer type
                auto _nanobind_buffer_type_to_letter_code = [](uint8_t dtype_code, size_t sizeof_item)  -> char
                {
                    #define DCODE(T) static_cast<uint8_t>(nb::dlpack::dtype_code::T)
                        const std::array<std::tuple<uint8_t, size_t, char>, 11> mappings = {{
                            {DCODE(UInt), 1, 'B'}, {DCODE(UInt), 2, 'H'}, {DCODE(UInt), 4, 'I'}, {DCODE(UInt), 8, 'L'},
                            {DCODE(Int), 1, 'b'}, {DCODE(Int), 2, 'h'}, {DCODE(Int), 4, 'i'}, {DCODE(Int), 8, 'l'},
                            {DCODE(Float), 4, 'f'}, {DCODE(Float), 8, 'd'}, {DCODE(Float), 16, 'g'}
                        }};
                    #undef DCODE
                    for (const auto& [code_val, size, letter] : mappings)
                        if (code_val == dtype_code && size == sizeof_item)
                            return letter;
                    throw std::runtime_error("Unsupported dtype");
                };

                // Compute the letter code for the buffer type
                uint8_t dtype_code_zs = zs.dtype().code;
                size_t sizeof_item_zs = zs.dtype().bits / 8;
                char zs_type = _nanobind_buffer_type_to_letter_code(dtype_code_zs, sizeof_item_zs);

                // call the correct template version by casting
                if (zs_type == 'B')
                    ImPlot3D::PlotSurface(label_id, static_cast<const uint8_t *>(xs_from_pyarray), static_cast<int>(xs_count), static_cast<const uint8_t *>(ys_from_pyarray), static_cast<int>(ys_count), static_cast<const uint8_t *>(zs_from_pyarray), static_cast<int>(zs_count), x_count, y_count, scale_min, scale_max, flags, offset, zs_stride);
                else if (zs_type == 'b')
                    ImPlot3D::PlotSurface(label_id, static_cast<const int8_t *>(xs_from_pyarray), static_cast<int>(xs_count), static_cast<const int8_t *>(ys_from_pyarray), static_cast<int>(ys_count), static_cast<const int8_t *>(zs_from_pyarray), static_cast<int>(zs_count), x_count, y_count, scale_min, scale_max, flags, offset, zs_stride);
                else if (zs_type == 'H')
                    ImPlot3D::PlotSurface(label_id, static_cast<const uint16_t *>(xs_from_pyarray), static_cast<int>(xs_count), static_cast<const uint16_t *>(ys_from_pyarray), static_cast<int>(ys_count), static_cast<const uint16_t *>(zs_from_pyarray), static_cast<int>(zs_count), x_count, y_count, scale_min, scale_max, flags, offset, zs_stride);
                else if (zs_type == 'h')
                    ImPlot3D::PlotSurface(label_id, static_cast<const int16_t *>(xs_from_pyarray), static_cast<int>(xs_count), static_cast<const int16_t *>(ys_from_pyarray), static_cast<int>(ys_count), static_cast<const int16_t *>(zs_from_pyarray), static_cast<int>(zs_count), x_count, y_count, scale_min, scale_max, flags, offset, zs_stride);
                else if (zs_type == 'I')
                    ImPlot3D::PlotSurface(label_id, static_cast<const uint32_t *>(xs_from_pyarray), static_cast<int>(xs_count), static_cast<const uint32_t *>(ys_from_pyarray), static_cast<int>(ys_count), static_cast<const uint32_t *>(zs_from_pyarray), static_cast<int>(zs_count), x_count, y_count, scale_min, scale_max, flags, offset, zs_stride);
                else if (zs_type == 'i')
                    ImPlot3D::PlotSurface(label_id, static_cast<const int32_t *>(xs_from_pyarray), static_cast<int>(xs_count), static_cast<const int32_t *>(ys_from_pyarray), static_cast<int>(ys_count), static_cast<const int32_t *>(zs_from_pyarray), static_cast<int>(zs_count), x_count, y_count, scale_min, scale_max, flags, offset, zs_stride);
                else if (zs_type == 'L')
                    ImPlot3D::PlotSurface(label_id, static_cast<const np_uint_l *>(xs_from_pyarray), static_cast<int>(xs_count), static_cast<const np_uint_l *>(ys_from_pyarray), static_cast<int>(ys_count), static_cast<const np_uint_l *>(zs_from_pyarray), static_cast<int>(zs_count), x_count, y_count, scale_min, scale_max, flags, offset, zs_stride);
                else if (zs_type == 'l')
                    ImPlot3D::PlotSurface(label_id, static_cast<const np_int_l *>(xs_from_pyarray), static_cast<int>(xs_count), static_cast<const np_int_l *>(ys_from_pyarray), static_cast<int>(ys_count), static_cast<const np_int_l *>(zs_from_pyarray), static_cast<int>(zs_count), x_count, y_count, scale_min, scale_max, flags, offset, zs_stride);
                else if (zs_type == 'f')
                    ImPlot3D::PlotSurface(label_id, static_cast<const float *>(xs_from_pyarray), static_cast<int>(xs_count), static_cast<const float *>(ys_from_pyarray), static_cast<int>(ys_count), static_cast<const float *>(zs_from_pyarray), static_cast<int>(zs_count), x_count, y_count, scale_min, scale_max, flags, offset, zs_stride);
                else if (zs_type == 'd')
                    ImPlot3D::PlotSurface(label_id, static_cast<const double *>(xs_from_pyarray), static_cast<int>(xs_count), static_cast<const double *>(ys_from_pyarray), static_cast<int>(ys_count), static_cast<const double *>(zs_from_pyarray), static_cast<int>(zs_count), x_count, y_count, scale_min, scale_max, flags, offset, zs_stride);
                else if (zs_type == 'g')
                    ImPlot3D::PlotSurface(label_id, static_cast<const long double *>(xs_from_pyarray), static_cast<int>(xs_count), static_cast<const long double *>(ys_from_pyarray), static_cast<int>(ys_count), static_cast<const long double *>(zs_from_pyarray), static_cast<int>(zs_count), x_count, y_count, scale_min, scale_max, flags, offset, zs_stride);
                else if (zs_type == 'q')
                    ImPlot3D::PlotSurface(label_id, static_cast<const long long *>(xs_from_pyarray), static_cast<int>(xs_count), static_cast<const long long *>(ys_from_pyarray), static_cast<int>(ys_count), static_cast<const long long *>(zs_from_pyarray), static_cast<int>(zs_count), x_count, y_count, scale_min, scale_max, flags, offset, zs_stride);
                // If we reach this point, the array type is not supported!
                else
                    throw std::runtime_error(std::string("Bad array type ('") + zs_type + "') for param zs");
            };

            PlotSurface_adapt_c_buffers(label_id, xs, ys, zs, x_count, y_count, scale_min, scale_max, flags, offset, stride);
        },
        nb::arg("label_id"), nb::arg("xs"), nb::arg("ys"), nb::arg("zs"), nb::arg("x_count"), nb::arg("y_count"), nb::arg("scale_min") = 0.0, nb::arg("scale_max") = 0.0, nb::arg("flags") = 0, nb::arg("offset") = 0, nb::arg("stride") = -1,
        " Plot the surface defined by a grid of vertices. The grid is defined by the x and y arrays,\n and the z array contains the height of each vertex.\n A total of x_count * y_count vertices are expected for each array.\n Leave #scale_min and #scale_max both at 0 for automatic color scaling, or set them to a predefined range.");
    // #endif
    //
    // #ifdef IMGUI_BUNDLE_PYTHON_API
    //


    auto pyClassMesh =
        nb::class_<ImPlot3D::Mesh>
            (m, "Mesh", "")
        .def("__init__", [](ImPlot3D::Mesh * self, const std::optional<const std::vector<ImPlot3DPoint>> & Points = std::nullopt, const std::optional<const std::vector<UInt>> & Idx = std::nullopt)
        {
            new (self) ImPlot3D::Mesh();  // placement new
            auto r_ctor_ = self;
            if (Points.has_value())
                r_ctor_->Points = Points.value();
            else
                r_ctor_->Points = std::vector<ImPlot3DPoint>();
            if (Idx.has_value())
                r_ctor_->Idx = Idx.value();
            else
                r_ctor_->Idx = std::vector<UInt>();
        },
        nb::arg("points").none() = nb::none(), nb::arg("idx").none() = nb::none()
        )
        .def_rw("points", &ImPlot3D::Mesh::Points, "")
        .def_rw("idx", &ImPlot3D::Mesh::Idx, "")
        ;


    m.def("plot_mesh",
        [](const char * label_id, const ImPlot3D::Mesh & mesh, ImPlot3DMeshFlags flags = 0)
        {
            auto PlotMesh_adapt_force_lambda = [](const char * label_id, const ImPlot3D::Mesh & mesh, ImPlot3DMeshFlags flags = 0)
            {
                ImPlot3D::PlotMesh(label_id, mesh, flags);
            };

            PlotMesh_adapt_force_lambda(label_id, mesh, flags);
        },     nb::arg("label_id"), nb::arg("mesh"), nb::arg("flags") = 0);
    // #endif
    //

    m.def("plot_image",
        [](const char * label_id, ImTextureRef tex_ref, const ImPlot3DPoint & center, const ImPlot3DPoint & axis_u, const ImPlot3DPoint & axis_v, const std::optional<const ImVec2> & uv0 = std::nullopt, const std::optional<const ImVec2> & uv1 = std::nullopt, const std::optional<const ImVec4> & tint_col = std::nullopt, ImPlot3DImageFlags flags = 0)
        {
            auto PlotImage_adapt_mutable_param_with_default_value = [](const char * label_id, ImTextureRef tex_ref, const ImPlot3DPoint & center, const ImPlot3DPoint & axis_u, const ImPlot3DPoint & axis_v, const std::optional<const ImVec2> & uv0 = std::nullopt, const std::optional<const ImVec2> & uv1 = std::nullopt, const std::optional<const ImVec4> & tint_col = std::nullopt, ImPlot3DImageFlags flags = 0)
            {

                const ImVec2& uv0_or_default = [&]() -> const ImVec2 {
                    if (uv0.has_value())
                        return uv0.value();
                    else
                        return ImVec2(0, 0);
                }();

                const ImVec2& uv1_or_default = [&]() -> const ImVec2 {
                    if (uv1.has_value())
                        return uv1.value();
                    else
                        return ImVec2(1, 1);
                }();

                const ImVec4& tint_col_or_default = [&]() -> const ImVec4 {
                    if (tint_col.has_value())
                        return tint_col.value();
                    else
                        return ImVec4(1, 1, 1, 1);
                }();

                ImPlot3D::PlotImage(label_id, tex_ref, center, axis_u, axis_v, uv0_or_default, uv1_or_default, tint_col_or_default, flags);
            };

            PlotImage_adapt_mutable_param_with_default_value(label_id, tex_ref, center, axis_u, axis_v, uv0, uv1, tint_col, flags);
        },
        nb::arg("label_id"), nb::arg("tex_ref"), nb::arg("center"), nb::arg("axis_u"), nb::arg("axis_v"), nb::arg("uv0").none() = nb::none(), nb::arg("uv1").none() = nb::none(), nb::arg("tint_col").none() = nb::none(), nb::arg("flags") = 0,
        " Plots a rectangular image in 3D defined by its center and two direction vectors (axes).\n #center is the center of the rectangle in plot coordinates.\n #axis_u and #axis_v define the local axes and half-extents of the rectangle in 3D space.\n The rectangle is formed by moving from the center along ±axis_u and ±axis_v.\n #uv0 and #uv1 define the texture mapping.\n #tint_col can be used to tint the image.\n\n\nPython bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * uv0: ImVec2(0, 0)\n        * uv1: ImVec2(1, 1)\n        * tint_col: ImVec4(1, 1, 1, 1)");

    m.def("plot_image",
        [](const char * label_id, ImTextureRef tex_ref, const ImPlot3DPoint & p0, const ImPlot3DPoint & p1, const ImPlot3DPoint & p2, const ImPlot3DPoint & p3, const std::optional<const ImVec2> & uv0 = std::nullopt, const std::optional<const ImVec2> & uv1 = std::nullopt, const std::optional<const ImVec2> & uv2 = std::nullopt, const std::optional<const ImVec2> & uv3 = std::nullopt, const std::optional<const ImVec4> & tint_col = std::nullopt, ImPlot3DImageFlags flags = 0)
        {
            auto PlotImage_adapt_mutable_param_with_default_value = [](const char * label_id, ImTextureRef tex_ref, const ImPlot3DPoint & p0, const ImPlot3DPoint & p1, const ImPlot3DPoint & p2, const ImPlot3DPoint & p3, const std::optional<const ImVec2> & uv0 = std::nullopt, const std::optional<const ImVec2> & uv1 = std::nullopt, const std::optional<const ImVec2> & uv2 = std::nullopt, const std::optional<const ImVec2> & uv3 = std::nullopt, const std::optional<const ImVec4> & tint_col = std::nullopt, ImPlot3DImageFlags flags = 0)
            {

                const ImVec2& uv0_or_default = [&]() -> const ImVec2 {
                    if (uv0.has_value())
                        return uv0.value();
                    else
                        return ImVec2(0, 0);
                }();

                const ImVec2& uv1_or_default = [&]() -> const ImVec2 {
                    if (uv1.has_value())
                        return uv1.value();
                    else
                        return ImVec2(1, 0);
                }();

                const ImVec2& uv2_or_default = [&]() -> const ImVec2 {
                    if (uv2.has_value())
                        return uv2.value();
                    else
                        return ImVec2(1, 1);
                }();

                const ImVec2& uv3_or_default = [&]() -> const ImVec2 {
                    if (uv3.has_value())
                        return uv3.value();
                    else
                        return ImVec2(0, 1);
                }();

                const ImVec4& tint_col_or_default = [&]() -> const ImVec4 {
                    if (tint_col.has_value())
                        return tint_col.value();
                    else
                        return ImVec4(1, 1, 1, 1);
                }();

                ImPlot3D::PlotImage(label_id, tex_ref, p0, p1, p2, p3, uv0_or_default, uv1_or_default, uv2_or_default, uv3_or_default, tint_col_or_default, flags);
            };

            PlotImage_adapt_mutable_param_with_default_value(label_id, tex_ref, p0, p1, p2, p3, uv0, uv1, uv2, uv3, tint_col, flags);
        },
        nb::arg("label_id"), nb::arg("tex_ref"), nb::arg("p0"), nb::arg("p1"), nb::arg("p2"), nb::arg("p3"), nb::arg("uv0").none() = nb::none(), nb::arg("uv1").none() = nb::none(), nb::arg("uv2").none() = nb::none(), nb::arg("uv3").none() = nb::none(), nb::arg("tint_col").none() = nb::none(), nb::arg("flags") = 0,
        " Plots an image using four arbitrary 3D points that define a quad in space.\n Each corner (p0 to p3) corresponds to a corner in the image, and #uv0 to #uv3 are the texture coordinates for each.\n This overload allows full control over orientation, shape, and distortion.\n Note: The quad is internally split into two triangles, so non-rectangular quads may produce rendering artifacts\n since distortion is interpolated per triangle rather than over the full quad.\n\n\nPython bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * uv0: ImVec2(0, 0)\n        * uv1: ImVec2(1, 0)\n        * uv2: ImVec2(1, 1)\n        * uv3: ImVec2(0, 1)\n        * tint_col: ImVec4(1, 1, 1, 1)");

    m.def("plot_text",
        [](const char * text, float x, float y, float z, float angle = 0.0f, const std::optional<const ImVec2> & pix_offset = std::nullopt)
        {
            auto PlotText_adapt_mutable_param_with_default_value = [](const char * text, float x, float y, float z, float angle = 0.0f, const std::optional<const ImVec2> & pix_offset = std::nullopt)
            {

                const ImVec2& pix_offset_or_default = [&]() -> const ImVec2 {
                    if (pix_offset.has_value())
                        return pix_offset.value();
                    else
                        return ImVec2(0, 0);
                }();

                ImPlot3D::PlotText(text, x, y, z, angle, pix_offset_or_default);
            };

            PlotText_adapt_mutable_param_with_default_value(text, x, y, z, angle, pix_offset);
        },
        nb::arg("text"), nb::arg("x"), nb::arg("y"), nb::arg("z"), nb::arg("angle") = 0.0f, nb::arg("pix_offset").none() = nb::none(),
        " Plots a centered text label at point x,y,z. It is possible to set the text angle in radians and offset in pixels\n\n\nPython bindings defaults:\n    If pix_offset is None, then its default value will be: ImVec2(0, 0)");

    m.def("plot_to_pixels",
        nb::overload_cast<const ImPlot3DPoint &>(ImPlot3D::PlotToPixels), nb::arg("point"));

    m.def("plot_to_pixels",
        nb::overload_cast<double, double, double>(ImPlot3D::PlotToPixels), nb::arg("x"), nb::arg("y"), nb::arg("z"));

    m.def("pixels_to_plot_ray",
        nb::overload_cast<const ImVec2 &>(ImPlot3D::PixelsToPlotRay), nb::arg("pix"));

    m.def("pixels_to_plot_ray",
        nb::overload_cast<double, double>(ImPlot3D::PixelsToPlotRay), nb::arg("x"), nb::arg("y"));

    m.def("pixels_to_plot_plane",
        nb::overload_cast<const ImVec2 &, ImPlane3D, bool>(ImPlot3D::PixelsToPlotPlane), nb::arg("pix"), nb::arg("plane"), nb::arg("mask") = true);

    m.def("pixels_to_plot_plane",
        nb::overload_cast<double, double, ImPlane3D, bool>(ImPlot3D::PixelsToPlotPlane), nb::arg("x"), nb::arg("y"), nb::arg("plane"), nb::arg("mask") = true);

    m.def("get_plot_pos",
        ImPlot3D::GetPlotPos, "Get the current plot position (top-left) in pixels");

    m.def("get_plot_size",
        ImPlot3D::GetPlotSize, "Get the current plot size in pixels");

    m.def("get_plot_draw_list",
        nb::overload_cast<>(ImPlot3D::GetPlotDrawList), nb::rv_policy::reference);

    m.def("get_style",
        ImPlot3D::GetStyle, nb::rv_policy::reference);

    m.def("set_style",
        ImPlot3D::SetStyle, nb::arg("style"));

    m.def("style_colors_auto",
        ImPlot3D::StyleColorsAuto,
        nb::arg("dst") = nb::none(),
        "Set colors with ImGui style");

    m.def("style_colors_dark",
        ImPlot3D::StyleColorsDark,
        nb::arg("dst") = nb::none(),
        "Set colors with dark style");

    m.def("style_colors_light",
        ImPlot3D::StyleColorsLight,
        nb::arg("dst") = nb::none(),
        "Set colors with light style");

    m.def("style_colors_classic",
        ImPlot3D::StyleColorsClassic,
        nb::arg("dst") = nb::none(),
        "Set colors with classic style");

    m.def("push_style_color",
        nb::overload_cast<ImPlot3DCol, ImU32>(ImPlot3D::PushStyleColor), nb::arg("idx"), nb::arg("col"));

    m.def("push_style_color",
        nb::overload_cast<ImPlot3DCol, const ImVec4 &>(ImPlot3D::PushStyleColor), nb::arg("idx"), nb::arg("col"));

    m.def("pop_style_color",
        ImPlot3D::PopStyleColor,
        nb::arg("count") = 1,
        "Undo temporary style color modification(s). Undo multiple pushes at once by increasing count");

    m.def("push_style_var",
        nb::overload_cast<ImPlot3DStyleVar, float>(ImPlot3D::PushStyleVar),
        nb::arg("idx"), nb::arg("val"),
        "Temporarily modify a style variable of float type. Don't forget to call PopStyleVar!");

    m.def("push_style_var",
        nb::overload_cast<ImPlot3DStyleVar, int>(ImPlot3D::PushStyleVar),
        nb::arg("idx"), nb::arg("val"),
        "Temporarily modify a style variable of int type. Don't forget to call PopStyleVar!");

    m.def("push_style_var",
        nb::overload_cast<ImPlot3DStyleVar, const ImVec2 &>(ImPlot3D::PushStyleVar),
        nb::arg("idx"), nb::arg("val"),
        "Temporarily modify a style variable of ImVec2 type. Don't forget to call PopStyleVar!");

    m.def("pop_style_var",
        ImPlot3D::PopStyleVar,
        nb::arg("count") = 1,
        "Undo temporary style variable modification(s). Undo multiple pushes at once by increasing count");

    m.def("set_next_line_style",
        [](const std::optional<const ImVec4> & col = std::nullopt, float weight = IMPLOT3D_AUTO)
        {
            auto SetNextLineStyle_adapt_mutable_param_with_default_value = [](const std::optional<const ImVec4> & col = std::nullopt, float weight = IMPLOT3D_AUTO)
            {

                const ImVec4& col_or_default = [&]() -> const ImVec4 {
                    if (col.has_value())
                        return col.value();
                    else
                        return IMPLOT3D_AUTO_COL;
                }();

                ImPlot3D::SetNextLineStyle(col_or_default, weight);
            };

            SetNextLineStyle_adapt_mutable_param_with_default_value(col, weight);
        },
        nb::arg("col").none() = nb::none(), nb::arg("weight") = IMPLOT3D_AUTO,
        " Set the line color and weight for the next item only\n\n\nPython bindings defaults:\n    If col is None, then its default value will be: IMPLOT3D_AUTO_COL");

    m.def("set_next_fill_style",
        [](const std::optional<const ImVec4> & col = std::nullopt, float alpha_mod = IMPLOT3D_AUTO)
        {
            auto SetNextFillStyle_adapt_mutable_param_with_default_value = [](const std::optional<const ImVec4> & col = std::nullopt, float alpha_mod = IMPLOT3D_AUTO)
            {

                const ImVec4& col_or_default = [&]() -> const ImVec4 {
                    if (col.has_value())
                        return col.value();
                    else
                        return IMPLOT3D_AUTO_COL;
                }();

                ImPlot3D::SetNextFillStyle(col_or_default, alpha_mod);
            };

            SetNextFillStyle_adapt_mutable_param_with_default_value(col, alpha_mod);
        },
        nb::arg("col").none() = nb::none(), nb::arg("alpha_mod") = IMPLOT3D_AUTO,
        " Set the fill color for the next item only\n\n\nPython bindings defaults:\n    If col is None, then its default value will be: IMPLOT3D_AUTO_COL");

    m.def("set_next_marker_style",
        [](const std::optional<const ImPlot3DMarker> & marker = std::nullopt, float size = IMPLOT3D_AUTO, const std::optional<const ImVec4> & fill = std::nullopt, float weight = IMPLOT3D_AUTO, const std::optional<const ImVec4> & outline = std::nullopt)
        {
            auto SetNextMarkerStyle_adapt_mutable_param_with_default_value = [](const std::optional<const ImPlot3DMarker> & marker = std::nullopt, float size = IMPLOT3D_AUTO, const std::optional<const ImVec4> & fill = std::nullopt, float weight = IMPLOT3D_AUTO, const std::optional<const ImVec4> & outline = std::nullopt)
            {

                const ImPlot3DMarker& marker_or_default = [&]() -> const ImPlot3DMarker {
                    if (marker.has_value())
                        return marker.value();
                    else
                        return IMPLOT3D_AUTO;
                }();

                const ImVec4& fill_or_default = [&]() -> const ImVec4 {
                    if (fill.has_value())
                        return fill.value();
                    else
                        return IMPLOT3D_AUTO_COL;
                }();

                const ImVec4& outline_or_default = [&]() -> const ImVec4 {
                    if (outline.has_value())
                        return outline.value();
                    else
                        return IMPLOT3D_AUTO_COL;
                }();

                ImPlot3D::SetNextMarkerStyle(marker_or_default, size, fill_or_default, weight, outline_or_default);
            };

            SetNextMarkerStyle_adapt_mutable_param_with_default_value(marker, size, fill, weight, outline);
        },
        nb::arg("marker").none() = nb::none(), nb::arg("size") = IMPLOT3D_AUTO, nb::arg("fill").none() = nb::none(), nb::arg("weight") = IMPLOT3D_AUTO, nb::arg("outline").none() = nb::none(),
        " Set the marker style for the next item only\n\n\nPython bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * marker: IMPLOT3D_AUTO\n        * fill: IMPLOT3D_AUTO_COL\n        * outline: IMPLOT3D_AUTO_COL");

    m.def("get_style_color_vec4",
        ImPlot3D::GetStyleColorVec4, nb::arg("idx"));

    m.def("get_style_color_u32",
        ImPlot3D::GetStyleColorU32, nb::arg("idx"));

    m.def("add_colormap",
        nb::overload_cast<const char *, const ImVec4 *, int, bool>(ImPlot3D::AddColormap), nb::arg("name"), nb::arg("cols"), nb::arg("size"), nb::arg("qual") = true);

    m.def("add_colormap",
        nb::overload_cast<const char *, const ImU32 *, int, bool>(ImPlot3D::AddColormap), nb::arg("name"), nb::arg("cols"), nb::arg("size"), nb::arg("qual") = true);

    m.def("get_colormap_count",
        ImPlot3D::GetColormapCount, "Returns the number of available colormaps (i.e. the built-in + user-added count)");

    m.def("get_colormap_name",
        ImPlot3D::GetColormapName,
        nb::arg("cmap"),
        "Returns a null terminated string name for a colormap given an index. Returns None if index is invalid",
        nb::rv_policy::reference);

    m.def("get_colormap_index",
        ImPlot3D::GetColormapIndex,
        nb::arg("name"),
        "Returns an index number for a colormap given a valid string name. Returns -1 if name is invalid");

    m.def("push_colormap",
        nb::overload_cast<ImPlot3DColormap>(ImPlot3D::PushColormap),
        nb::arg("cmap"),
        " Temporarily switch to one of the built-in (i.e. ImPlot3DColormap_XXX) or user-added colormaps (i.e. a return value of AddColormap). Don't forget to\n call PopColormap!");

    m.def("push_colormap",
        nb::overload_cast<const char *>(ImPlot3D::PushColormap),
        nb::arg("name"),
        " Push a colormap by string name. Use built-in names such as \"Default\", \"Deep\", \"Jet\", etc. or a string you provided to AddColormap. Don't forget to\n call PopColormap!");

    m.def("pop_colormap",
        ImPlot3D::PopColormap,
        nb::arg("count") = 1,
        "Undo temporary colormap modification(s). Undo multiple pushes at once by increasing count");

    m.def("next_colormap_color",
        ImPlot3D::NextColormapColor, " Returns the next color from the current colormap and advances the colormap for the current plot\n Can also be used with no return value to skip colors if desired. You need to call it between Begin/EndPlot!");

    m.def("get_colormap_size",
        [](const std::optional<const ImPlot3DColormap> & cmap = std::nullopt) -> int
        {
            auto GetColormapSize_adapt_mutable_param_with_default_value = [](const std::optional<const ImPlot3DColormap> & cmap = std::nullopt) -> int
            {

                const ImPlot3DColormap& cmap_or_default = [&]() -> const ImPlot3DColormap {
                    if (cmap.has_value())
                        return cmap.value();
                    else
                        return IMPLOT3D_AUTO;
                }();

                auto lambda_result = ImPlot3D::GetColormapSize(cmap_or_default);
                return lambda_result;
            };

            return GetColormapSize_adapt_mutable_param_with_default_value(cmap);
        },
        nb::arg("cmap").none() = nb::none(),
        " Returns the size of a colormap\n\n\nPython bindings defaults:\n    If cmap is None, then its default value will be: IMPLOT3D_AUTO");

    m.def("get_colormap_color",
        [](int idx, const std::optional<const ImPlot3DColormap> & cmap = std::nullopt) -> ImVec4
        {
            auto GetColormapColor_adapt_mutable_param_with_default_value = [](int idx, const std::optional<const ImPlot3DColormap> & cmap = std::nullopt) -> ImVec4
            {

                const ImPlot3DColormap& cmap_or_default = [&]() -> const ImPlot3DColormap {
                    if (cmap.has_value())
                        return cmap.value();
                    else
                        return IMPLOT3D_AUTO;
                }();

                auto lambda_result = ImPlot3D::GetColormapColor(idx, cmap_or_default);
                return lambda_result;
            };

            return GetColormapColor_adapt_mutable_param_with_default_value(idx, cmap);
        },
        nb::arg("idx"), nb::arg("cmap").none() = nb::none(),
        " Returns a color from a colormap given an index >= 0 (modulo will be performed)\n\n\nPython bindings defaults:\n    If cmap is None, then its default value will be: IMPLOT3D_AUTO");

    m.def("sample_colormap",
        [](float t, const std::optional<const ImPlot3DColormap> & cmap = std::nullopt) -> ImVec4
        {
            auto SampleColormap_adapt_mutable_param_with_default_value = [](float t, const std::optional<const ImPlot3DColormap> & cmap = std::nullopt) -> ImVec4
            {

                const ImPlot3DColormap& cmap_or_default = [&]() -> const ImPlot3DColormap {
                    if (cmap.has_value())
                        return cmap.value();
                    else
                        return IMPLOT3D_AUTO;
                }();

                auto lambda_result = ImPlot3D::SampleColormap(t, cmap_or_default);
                return lambda_result;
            };

            return SampleColormap_adapt_mutable_param_with_default_value(t, cmap);
        },
        nb::arg("t"), nb::arg("cmap").none() = nb::none(),
        " Sample a color from the current colormap given t between 0 and 1\n\n\nPython bindings defaults:\n    If cmap is None, then its default value will be: IMPLOT3D_AUTO");

    m.def("show_demo_window",
        [](std::optional<bool> p_open = std::nullopt) -> std::optional<bool>
        {
            auto ShowDemoWindow_adapt_modifiable_immutable_to_return = [](std::optional<bool> p_open = std::nullopt) -> std::optional<bool>
            {
                bool * p_open_adapt_modifiable = nullptr;
                if (p_open.has_value())
                    p_open_adapt_modifiable = & (*p_open);

                ImPlot3D::ShowDemoWindow(p_open_adapt_modifiable);
                return p_open;
            };

            return ShowDemoWindow_adapt_modifiable_immutable_to_return(p_open);
        },
        nb::arg("p_open").none() = nb::none(),
        "Shows the ImPlot3D demo window");

    m.def("show_all_demos",
        ImPlot3D::ShowAllDemos, "Shows all ImPlot3D demos, without enclosing window");

    m.def("show_style_editor",
        ImPlot3D::ShowStyleEditor,
        nb::arg("ref") = nb::none(),
        "Shows ImPlot3D style editor block (not a window)");

    m.def("show_metrics_window",
        [](std::optional<bool> p_popen = std::nullopt) -> std::optional<bool>
        {
            auto ShowMetricsWindow_adapt_modifiable_immutable_to_return = [](std::optional<bool> p_popen = std::nullopt) -> std::optional<bool>
            {
                bool * p_popen_adapt_modifiable = nullptr;
                if (p_popen.has_value())
                    p_popen_adapt_modifiable = & (*p_popen);

                ImPlot3D::ShowMetricsWindow(p_popen_adapt_modifiable);
                return p_popen;
            };

            return ShowMetricsWindow_adapt_modifiable_immutable_to_return(p_popen);
        },
        nb::arg("p_popen").none() = nb::none(),
        "Shows ImPlot3D metrics/debug information window.");


    auto pyClassImPlot3DPoint =
        nb::class_<ImPlot3DPoint>
            (m, "Point", "ImPlot3DPoint: 3D vector to store points in 3D")
        .def_rw("x", &ImPlot3DPoint::x, "")
        .def_rw("y", &ImPlot3DPoint::y, "")
        .def_rw("z", &ImPlot3DPoint::z, "")
        .def(nb::init<>())
        .def(nb::init<float, float, float>(),
            nb::arg("_x"), nb::arg("_y"), nb::arg("_z"))
        .def("__getitem__",
            nb::overload_cast<size_t>(&ImPlot3DPoint::operator[]),
            nb::arg("idx"),
            "(private API)",
            nb::rv_policy::reference)
        .def("__getitem__",
            nb::overload_cast<size_t>(&ImPlot3DPoint::operator[], nb::const_),
            nb::arg("idx"),
            "(private API)")
        .def("__mul__",
            nb::overload_cast<float>(&ImPlot3DPoint::operator*, nb::const_), nb::arg("rhs"))
        .def("__truediv__",
            nb::overload_cast<float>(&ImPlot3DPoint::operator/, nb::const_), nb::arg("rhs"))
        .def("__add__",
            &ImPlot3DPoint::operator+, nb::arg("rhs"))
        .def("__sub__",
            nb::overload_cast<const ImPlot3DPoint &>(&ImPlot3DPoint::operator-, nb::const_), nb::arg("rhs"))
        .def("__mul__",
            nb::overload_cast<const ImPlot3DPoint &>(&ImPlot3DPoint::operator*, nb::const_), nb::arg("rhs"))
        .def("__truediv__",
            nb::overload_cast<const ImPlot3DPoint &>(&ImPlot3DPoint::operator/, nb::const_), nb::arg("rhs"))
        .def("__neg__",
            [](ImPlot3DPoint & self) { return self.operator-(); }, "Unary operator")
        .def("__imul__",
            nb::overload_cast<float>(&ImPlot3DPoint::operator*=),
            nb::arg("rhs"),
            nb::rv_policy::reference)
        .def("__itruediv__",
            nb::overload_cast<float>(&ImPlot3DPoint::operator/=),
            nb::arg("rhs"),
            nb::rv_policy::reference)
        .def("__iadd__",
            &ImPlot3DPoint::operator+=,
            nb::arg("rhs"),
            nb::rv_policy::reference)
        .def("__isub__",
            &ImPlot3DPoint::operator-=,
            nb::arg("rhs"),
            nb::rv_policy::reference)
        .def("__imul__",
            nb::overload_cast<const ImPlot3DPoint &>(&ImPlot3DPoint::operator*=),
            nb::arg("rhs"),
            nb::rv_policy::reference)
        .def("__itruediv__",
            nb::overload_cast<const ImPlot3DPoint &>(&ImPlot3DPoint::operator/=),
            nb::arg("rhs"),
            nb::rv_policy::reference)
        .def("__eq__",
            &ImPlot3DPoint::operator==, nb::arg("rhs"))
        .def("__ne__",
            &ImPlot3DPoint::operator!=, nb::arg("rhs"))
        .def("dot",
            &ImPlot3DPoint::Dot,
            nb::arg("rhs"),
            "Dot product")
        .def("cross",
            &ImPlot3DPoint::Cross,
            nb::arg("rhs"),
            "Cross product")
        .def("length",
            &ImPlot3DPoint::Length, "Get vector length")
        .def("length_squared",
            &ImPlot3DPoint::LengthSquared, "Get vector squared length")
        .def("normalize",
            &ImPlot3DPoint::Normalize, "Normalize to unit length")
        .def("normalized",
            &ImPlot3DPoint::Normalized, "Return vector normalized to unit length")
        .def("is_nan",
            &ImPlot3DPoint::IsNaN, "Check if the point is NaN")
        ;


    auto pyClassImPlot3DRay =
        nb::class_<ImPlot3DRay>
            (m, "Ray", "")
        .def("__init__", [](ImPlot3DRay * self, const std::optional<const ImPlot3DPoint> & Origin = std::nullopt, const std::optional<const ImPlot3DPoint> & Direction = std::nullopt)
        {
            new (self) ImPlot3DRay();  // placement new
            auto r_ctor_ = self;
            if (Origin.has_value())
                r_ctor_->Origin = Origin.value();
            else
                r_ctor_->Origin = ImPlot3DPoint();
            if (Direction.has_value())
                r_ctor_->Direction = Direction.value();
            else
                r_ctor_->Direction = ImPlot3DPoint();
        },
        nb::arg("origin").none() = nb::none(), nb::arg("direction").none() = nb::none()
        )
        .def_rw("origin", &ImPlot3DRay::Origin, "")
        .def_rw("direction", &ImPlot3DRay::Direction, "")
        ;


    auto pyClassImPlot3DPlane =
        nb::class_<ImPlot3DPlane>
            (m, "Plane", "")
        .def("__init__", [](ImPlot3DPlane * self, const std::optional<const ImPlot3DPoint> & Point = std::nullopt, const std::optional<const ImPlot3DPoint> & Normal = std::nullopt)
        {
            new (self) ImPlot3DPlane();  // placement new
            auto r_ctor_ = self;
            if (Point.has_value())
                r_ctor_->Point = Point.value();
            else
                r_ctor_->Point = ImPlot3DPoint();
            if (Normal.has_value())
                r_ctor_->Normal = Normal.value();
            else
                r_ctor_->Normal = ImPlot3DPoint();
        },
        nb::arg("point").none() = nb::none(), nb::arg("normal").none() = nb::none()
        )
        .def_rw("point", &ImPlot3DPlane::Point, "")
        .def_rw("normal", &ImPlot3DPlane::Normal, "")
        ;


    auto pyClassImPlot3DBox =
        nb::class_<ImPlot3DBox>
            (m, "Box", "")
        .def_rw("min", &ImPlot3DBox::Min, "")
        .def_rw("max", &ImPlot3DBox::Max, "")
        .def(nb::init<>(),
            "Default constructor")
        .def(nb::init<const ImPlot3DPoint &, const ImPlot3DPoint &>(),
            nb::arg("min"), nb::arg("max"),
            "Constructor with two points")
        .def("expand",
            &ImPlot3DBox::Expand,
            nb::arg("point"),
            "Method to expand the box to include a point")
        .def("contains",
            &ImPlot3DBox::Contains,
            nb::arg("point"),
            "Method to check if a point is inside the box")
        .def("clip_line_segment",
            &ImPlot3DBox::ClipLineSegment,
            nb::arg("p0"), nb::arg("p1"), nb::arg("p0_clipped"), nb::arg("p1_clipped"),
            "Method to clip a line segment against the box")
        ;


    auto pyClassImPlot3DRange =
        nb::class_<ImPlot3DRange>
            (m, "Range", "")
        .def_rw("min", &ImPlot3DRange::Min, "")
        .def_rw("max", &ImPlot3DRange::Max, "")
        .def(nb::init<>())
        .def(nb::init<float, float>(),
            nb::arg("min"), nb::arg("max"))
        .def("expand",
            &ImPlot3DRange::Expand, nb::arg("value"))
        .def("contains",
            &ImPlot3DRange::Contains, nb::arg("value"))
        .def("size",
            &ImPlot3DRange::Size, "(private API)")
        ;


    auto pyClassImPlot3DQuat =
        nb::class_<ImPlot3DQuat>
            (m, "Quat", "")
        .def_rw("x", &ImPlot3DQuat::x, "")
        .def_rw("y", &ImPlot3DQuat::y, "")
        .def_rw("z", &ImPlot3DQuat::z, "")
        .def_rw("w", &ImPlot3DQuat::w, "")
        .def(nb::init<>())
        .def(nb::init<float, float, float, float>(),
            nb::arg("_x"), nb::arg("_y"), nb::arg("_z"), nb::arg("_w"))
        .def(nb::init<float, const ImPlot3DPoint &>(),
            nb::arg("_angle"), nb::arg("_axis"))
        .def_static("from_two_vectors",
            &ImPlot3DQuat::FromTwoVectors,
            nb::arg("v0"), nb::arg("v1"),
            "Set quaternion from two vectors")
        .def_static("from_el_az",
            &ImPlot3DQuat::FromElAz,
            nb::arg("elevation"), nb::arg("azimuth"),
            "Set quaternion given elevation and azimuth angles in radians")
        .def("length",
            &ImPlot3DQuat::Length, "Get quaternion length")
        .def("normalized",
            &ImPlot3DQuat::Normalized, "Get normalized quaternion")
        .def("conjugate",
            &ImPlot3DQuat::Conjugate, "Conjugate of the quaternion")
        .def("inverse",
            &ImPlot3DQuat::Inverse, "Inverse of the quaternion")
        .def("__mul__",
            nb::overload_cast<const ImPlot3DQuat &>(&ImPlot3DQuat::operator*, nb::const_),
            nb::arg("rhs"),
            "Binary operators")
        .def("normalize",
            &ImPlot3DQuat::Normalize,
            "Normalize the quaternion in place",
            nb::rv_policy::reference)
        .def("__mul__",
            nb::overload_cast<const ImPlot3DPoint &>(&ImPlot3DQuat::operator*, nb::const_),
            nb::arg("point"),
            "Rotate a 3D point using the quaternion")
        .def("__eq__",
            &ImPlot3DQuat::operator==, nb::arg("rhs"))
        .def("__ne__",
            &ImPlot3DQuat::operator!=, nb::arg("rhs"))
        .def_static("slerp",
            &ImPlot3DQuat::Slerp,
            nb::arg("q1"), nb::arg("q2"), nb::arg("t"),
            "Interpolate between two quaternions")
        .def("dot",
            &ImPlot3DQuat::Dot,
            nb::arg("rhs"),
            "Get quaternion dot product")
        ;


    auto pyClassImPlot3DStyle =
        nb::class_<ImPlot3DStyle>
            (m, "Style", "\n(has support for copy.copy)")
        .def_rw("line_weight", &ImPlot3DStyle::LineWeight, "Line weight in pixels")
        .def_rw("marker", &ImPlot3DStyle::Marker, "Default marker type (ImPlot3DMarker_None)")
        .def_rw("marker_size", &ImPlot3DStyle::MarkerSize, "Marker size in pixels (roughly the marker's \"radius\")")
        .def_rw("marker_weight", &ImPlot3DStyle::MarkerWeight, "Marker outline weight in pixels")
        .def_rw("fill_alpha", &ImPlot3DStyle::FillAlpha, "Alpha modifier applied to plot fills")
        .def_rw("plot_default_size", &ImPlot3DStyle::PlotDefaultSize, "")
        .def_rw("plot_min_size", &ImPlot3DStyle::PlotMinSize, "")
        .def_rw("plot_padding", &ImPlot3DStyle::PlotPadding, "")
        .def_rw("label_padding", &ImPlot3DStyle::LabelPadding, "")
        .def_rw("legend_padding", &ImPlot3DStyle::LegendPadding, "Legend padding from plot edges")
        .def_rw("legend_inner_padding", &ImPlot3DStyle::LegendInnerPadding, "Legend inner padding from legend edges")
        .def_rw("legend_spacing", &ImPlot3DStyle::LegendSpacing, "Spacing between legend entries")
        .def("get_color",
            &ImPlot3DStyle::GetColor,
            nb::arg("idx"),
            "(private API)")
        .def("set_color",
            &ImPlot3DStyle::SetColor,
            nb::arg("idx"), nb::arg("col"),
            "(private API)")
        .def_rw("colormap", &ImPlot3DStyle::Colormap, "The current colormap. Set this to either an ImPlot3DColormap_ enum or an index returned by AddColormap")
        .def(nb::init<>(),
            "Constructor")
        .def(nb::init<const ImPlot3DStyle &>(),
            nb::arg("other"))
        .def("__copy__",  [](const ImPlot3DStyle &self) {
            return ImPlot3DStyle(self);
        })    ;
    // #endif
    ////////////////////    </generated_from:implot3d.h>    ////////////////////

    // </litgen_pydef> // Autogenerated code end
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


    ///////////////////////////////////////////////////////////////////////////
    // MANUAL BINDINGS BELOW
    ///////////////////////////////////////////////////////////////////////////
    //pyClassImPlotPointPtr = & pyClassImPlotPoint;
    implot3d_binding_manual(m);
}


void implot3d_binding_manual(nb::module_& m)
{
        m.def("setup_axis_ticks",
          [](ImAxis3D axis, double v_min, double v_max, int n_ticks,
              const std::optional<std::vector<std::string>>& labels = std::nullopt, bool keep_default=false)
          {
              if (!labels.has_value() || labels.value().empty())
                  ImPlot3D::SetupAxisTicks(axis, v_min, v_max, n_ticks, nullptr, keep_default);
              else
              {
                  IM_ASSERT(labels.value().size() == n_ticks && "The number of labels should match the number of ticks");
                  std::vector<const char*> label_char;
                  for (std::string const& str : labels.value()){
                      label_char.push_back(str.c_str());
                  }
                  ImPlot3D::SetupAxisTicks(axis, v_min, v_max, n_ticks, label_char.data(), keep_default);
              }
          }, nb::arg("axis"), nb::arg("v_min"), nb::arg("v_max"), nb::arg("n_ticks"), nb::arg("labels"), nb::arg("keep_default"),
          "Sets an axis' ticks and optionally the labels for the next plot. To keep the default ticks, set #keep_default=true."
    );
    m.def("setup_axis_ticks",
          [](ImAxis3D axis, std::vector<double> values,
              const std::optional<std::vector<std::string>>& labels = std::nullopt, bool keep_default=false)
          {
              int n_ticks = static_cast<int>(values.size());

              if (!labels.has_value() || labels.value().empty())
                  ImPlot3D::SetupAxisTicks(axis, values.data(), n_ticks, nullptr, keep_default);
              else
              {
                  std::vector<const char*> label_char;
                  for (std::string const& str : labels.value()){
                      label_char.push_back(str.c_str());
                  }
                  ImPlot3D::SetupAxisTicks(axis, values.data(), n_ticks, label_char.data(), keep_default);
              }
          }, nb::arg("axis"), nb::arg("values"), nb::arg("labels"), nb::arg("keep_default"),
          "Sets an axis' ticks and optionally the labels for the next plot. To keep the default ticks, set #keep_default=true."
    );

}
#endif // IMGUI_BUNDLE_WITH_IMPLOT3D
