// Part of ImGui Bundle - MIT License - Copyright (c) 2022-2024 Pascal Thomet - https://github.com/pthom/imgui_bundle
#ifdef IMGUI_BUNDLE_WITH_IMPLOT
#include <nanobind/nanobind.h>
#include <nanobind/stl/string.h>
#include <nanobind/stl/array.h>
#include <nanobind/stl/optional.h>
#include <nanobind/stl/vector.h>
#include <nanobind/stl/function.h>
#include <nanobind/ndarray.h>

#include "imgui.h"
#include "implot3d/implot3d.h"
#include "implot3d/implot3d_internal.h"


namespace nb = nanobind;

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// <litgen_glue_code>  // Autogenerated code below! Do not edit!

// </litgen_glue_code> // Autogenerated code end
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


void py_init_module_implot3d_internal(nb::module_& m)
{
    using namespace ImPlot3D;
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // <litgen_pydef> // Autogenerated code below! Do not edit!
    ////////////////////    <generated_from:implot3d_internal.h>    ////////////////////
    // #ifndef IMGUI_DISABLE
    //


    m.def("im_log10",
        ImPlot3D::ImLog10,
        nb::arg("x"),
        " Computes the common (base-10) logarithm\n(private API)");

    m.def("im_nan",
        ImPlot3D::ImNan,
        nb::arg("val"),
        " Returns True if val is NAN\n(private API)");

    m.def("im_nan_or_inf",
        ImPlot3D::ImNanOrInf,
        nb::arg("val"),
        " Returns True if val is NAN or INFINITY\n(private API)");

    m.def("im_constrain_nan",
        ImPlot3D::ImConstrainNan,
        nb::arg("val"),
        " Turns NANs to 0s\n(private API)");

    m.def("im_constrain_inf",
        ImPlot3D::ImConstrainInf,
        nb::arg("val"),
        " Turns infinity to floating point maximums\n(private API)");

    m.def("im_almost_equal",
        ImPlot3D::ImAlmostEqual,
        nb::arg("v1"), nb::arg("v2"), nb::arg("ulp") = 2,
        " True if two numbers are approximately equal using units in the last place.\n(private API)");

    m.def("im_alpha_u32",
        ImPlot3D::ImAlphaU32,
        nb::arg("col"), nb::arg("alpha"),
        " Set alpha channel of 32-bit color from float in range [0.0 1.0]\n(private API)");

    m.def("im_mix_u32",
        ImPlot3D::ImMixU32,
        nb::arg("a"), nb::arg("b"), nb::arg("s"),
        " Mix color a and b by factor s in [0 256]\n(private API)");


    auto pyClassImPlot3DNextItemData =
        nb::class_<ImPlot3DNextItemData>
            (m, "NextItemData", "")
        .def_rw("line_weight", &ImPlot3DNextItemData::LineWeight, "")
        .def_rw("marker", &ImPlot3DNextItemData::Marker, "")
        .def_rw("marker_size", &ImPlot3DNextItemData::MarkerSize, "")
        .def_rw("marker_weight", &ImPlot3DNextItemData::MarkerWeight, "")
        .def_rw("fill_alpha", &ImPlot3DNextItemData::FillAlpha, "")
        .def_rw("render_line", &ImPlot3DNextItemData::RenderLine, "")
        .def_rw("render_fill", &ImPlot3DNextItemData::RenderFill, "")
        .def_rw("render_marker_line", &ImPlot3DNextItemData::RenderMarkerLine, "")
        .def_rw("render_marker_fill", &ImPlot3DNextItemData::RenderMarkerFill, "")
        .def_rw("is_auto_fill", &ImPlot3DNextItemData::IsAutoFill, "")
        .def_rw("is_auto_line", &ImPlot3DNextItemData::IsAutoLine, "")
        .def_rw("hidden", &ImPlot3DNextItemData::Hidden, "")
        .def(nb::init<>())
        .def("reset",
            &ImPlot3DNextItemData::Reset, "(private API)")
        ;


    auto pyClassImPlot3DColormapData =
        nb::class_<ImPlot3DColormapData>
            (m, "ColormapData", "Colormap data storage")
        .def_rw("count", &ImPlot3DColormapData::Count, "")
        .def(nb::init<>())
        .def("append",
            &ImPlot3DColormapData::Append,
            nb::arg("name"), nb::arg("keys"), nb::arg("count"), nb::arg("qual"),
            "(private API)")
        .def("_append_table",
            &ImPlot3DColormapData::_AppendTable,
            nb::arg("cmap"),
            "(private API)")
        .def("rebuild_tables",
            &ImPlot3DColormapData::RebuildTables, "(private API)")
        .def("is_qual",
            &ImPlot3DColormapData::IsQual,
            nb::arg("cmap"),
            "(private API)")
        .def("get_name",
            &ImPlot3DColormapData::GetName,
            nb::arg("cmap"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_index",
            &ImPlot3DColormapData::GetIndex,
            nb::arg("name"),
            "(private API)")
        .def("get_keys",
            &ImPlot3DColormapData::GetKeys,
            nb::arg("cmap"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_key_count",
            &ImPlot3DColormapData::GetKeyCount,
            nb::arg("cmap"),
            "(private API)")
        .def("get_key_color",
            &ImPlot3DColormapData::GetKeyColor,
            nb::arg("cmap"), nb::arg("idx"),
            "(private API)")
        .def("set_key_color",
            &ImPlot3DColormapData::SetKeyColor,
            nb::arg("cmap"), nb::arg("idx"), nb::arg("value"),
            "(private API)")
        .def("get_table",
            &ImPlot3DColormapData::GetTable,
            nb::arg("cmap"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_table_size",
            &ImPlot3DColormapData::GetTableSize,
            nb::arg("cmap"),
            "(private API)")
        .def("get_table_color",
            &ImPlot3DColormapData::GetTableColor,
            nb::arg("cmap"), nb::arg("idx"),
            "(private API)")
        .def("lerp_table",
            &ImPlot3DColormapData::LerpTable,
            nb::arg("cmap"), nb::arg("t"),
            "(private API)")
        ;


    auto pyClassImPlot3DItem =
        nb::class_<ImPlot3DItem>
            (m, "Item", "State information for plot items")
        .def_rw("id_", &ImPlot3DItem::ID, "")
        .def_rw("color", &ImPlot3DItem::Color, "")
        .def_rw("name_offset", &ImPlot3DItem::NameOffset, "")
        .def_rw("show", &ImPlot3DItem::Show, "")
        .def_rw("legend_hovered", &ImPlot3DItem::LegendHovered, "")
        .def_rw("seen_this_frame", &ImPlot3DItem::SeenThisFrame, "")
        .def(nb::init<>())
        ;


    auto pyClassImPlot3DLegend =
        nb::class_<ImPlot3DLegend>
            (m, "Legend", "Holds legend state")
        .def_rw("flags", &ImPlot3DLegend::Flags, "")
        .def_rw("previous_flags", &ImPlot3DLegend::PreviousFlags, "")
        .def_rw("location", &ImPlot3DLegend::Location, "")
        .def_rw("previous_location", &ImPlot3DLegend::PreviousLocation, "")
        .def_rw("rect", &ImPlot3DLegend::Rect, "")
        .def_rw("hovered", &ImPlot3DLegend::Hovered, "")
        .def_rw("held", &ImPlot3DLegend::Held, "")
        .def(nb::init<>())
        .def("reset",
            &ImPlot3DLegend::Reset, "(private API)")
        ;


    auto pyClassImPlot3DItemGroup =
        nb::class_<ImPlot3DItemGroup>
            (m, "ItemGroup", "Holds items")
        .def_rw("legend", &ImPlot3DItemGroup::Legend, "")
        .def_rw("colormap_idx", &ImPlot3DItemGroup::ColormapIdx, "")
        .def(nb::init<>())
        .def("get_item_count",
            &ImPlot3DItemGroup::GetItemCount, "(private API)")
        .def("get_item_id",
            &ImPlot3DItemGroup::GetItemID,
            nb::arg("label_id"),
            "(private API)")
        .def("get_item",
            nb::overload_cast<ImGuiID>(&ImPlot3DItemGroup::GetItem),
            nb::arg("id_"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_item",
            nb::overload_cast<const char *>(&ImPlot3DItemGroup::GetItem),
            nb::arg("label_id"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_or_add_item",
            &ImPlot3DItemGroup::GetOrAddItem,
            nb::arg("id_"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_item_by_index",
            &ImPlot3DItemGroup::GetItemByIndex,
            nb::arg("i"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_item_index",
            &ImPlot3DItemGroup::GetItemIndex,
            nb::arg("item"),
            "(private API)")
        .def("get_legend_count",
            &ImPlot3DItemGroup::GetLegendCount, "(private API)")
        .def("get_legend_item",
            &ImPlot3DItemGroup::GetLegendItem,
            nb::arg("i"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_legend_label",
            &ImPlot3DItemGroup::GetLegendLabel,
            nb::arg("i"),
            "(private API)",
            nb::rv_policy::reference)
        .def("reset",
            &ImPlot3DItemGroup::Reset, "(private API)")
        ;


    auto pyClassImPlot3DTick =
        nb::class_<ImPlot3DTick>
            (m, "Tick", "Tick mark info")
        .def_rw("plot_pos", &ImPlot3DTick::PlotPos, "")
        .def_rw("major", &ImPlot3DTick::Major, "")
        .def_rw("show_label", &ImPlot3DTick::ShowLabel, "")
        .def_rw("label_size", &ImPlot3DTick::LabelSize, "")
        .def_rw("text_offset", &ImPlot3DTick::TextOffset, "")
        .def_rw("idx", &ImPlot3DTick::Idx, "")
        .def(nb::init<double, bool, bool>(),
            nb::arg("value"), nb::arg("major"), nb::arg("show_label"))
        ;


    auto pyClassImPlot3DTicker =
        nb::class_<ImPlot3DTicker>
            (m, "Ticker", "Collection of ticks")
        .def(nb::init<>())
        .def("add_tick",
            nb::overload_cast<double, bool, bool, const char *>(&ImPlot3DTicker::AddTick),
            nb::arg("value"), nb::arg("major"), nb::arg("show_label"), nb::arg("label"),
            "(private API)",
            nb::rv_policy::reference)
        .def("add_tick",
            nb::overload_cast<ImPlot3DTick>(&ImPlot3DTicker::AddTick),
            nb::arg("tick"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_text",
            nb::overload_cast<int>(&ImPlot3DTicker::GetText, nb::const_),
            nb::arg("idx"),
            "(private API)",
            nb::rv_policy::reference)
        .def("get_text",
            nb::overload_cast<const ImPlot3DTick &>(&ImPlot3DTicker::GetText, nb::const_),
            nb::arg("tick"),
            "(private API)",
            nb::rv_policy::reference)
        .def("reset",
            &ImPlot3DTicker::Reset, "(private API)")
        .def("tick_count",
            &ImPlot3DTicker::TickCount, "(private API)")
        ;


    auto pyClassImPlot3DAxis =
        nb::class_<ImPlot3DAxis>
            (m, "Axis", "Holds axis information")
        .def_rw("flags", &ImPlot3DAxis::Flags, "")
        .def_rw("previous_flags", &ImPlot3DAxis::PreviousFlags, "")
        .def_rw("range", &ImPlot3DAxis::Range, "")
        .def_rw("range_cond", &ImPlot3DAxis::RangeCond, "")
        .def_rw("ticker", &ImPlot3DAxis::Ticker, "")
        .def_rw("formatter_data", &ImPlot3DAxis::FormatterData, "")
        .def_rw("show_default_ticks", &ImPlot3DAxis::ShowDefaultTicks, "")
        .def_rw("fit_this_frame", &ImPlot3DAxis::FitThisFrame, "")
        .def_rw("fit_extents", &ImPlot3DAxis::FitExtents, "")
        .def_rw("constraint_range", &ImPlot3DAxis::ConstraintRange, "")
        .def_rw("constraint_zoom", &ImPlot3DAxis::ConstraintZoom, "")
        .def_rw("hovered", &ImPlot3DAxis::Hovered, "")
        .def_rw("held", &ImPlot3DAxis::Held, "")
        .def(nb::init<>(),
            "Constructor")
        .def("reset",
            &ImPlot3DAxis::Reset, "(private API)")
        .def("set_range",
            &ImPlot3DAxis::SetRange,
            nb::arg("v1"), nb::arg("v2"),
            "(private API)")
        .def("set_min",
            &ImPlot3DAxis::SetMin,
            nb::arg("_min"), nb::arg("force") = false,
            "(private API)")
        .def("set_max",
            &ImPlot3DAxis::SetMax,
            nb::arg("_max"), nb::arg("force") = false,
            "(private API)")
        .def("constrain",
            &ImPlot3DAxis::Constrain, "(private API)")
        .def("is_range_locked",
            &ImPlot3DAxis::IsRangeLocked, "(private API)")
        .def("is_locked_min",
            &ImPlot3DAxis::IsLockedMin, "(private API)")
        .def("is_locked_max",
            &ImPlot3DAxis::IsLockedMax, "(private API)")
        .def("is_locked",
            &ImPlot3DAxis::IsLocked, "(private API)")
        .def("is_input_locked_min",
            &ImPlot3DAxis::IsInputLockedMin, "(private API)")
        .def("is_input_locked_max",
            &ImPlot3DAxis::IsInputLockedMax, "(private API)")
        .def("is_input_locked",
            &ImPlot3DAxis::IsInputLocked, "(private API)")
        .def("is_pan_locked",
            &ImPlot3DAxis::IsPanLocked,
            nb::arg("increasing"),
            "(private API)")
        .def("set_label",
            &ImPlot3DAxis::SetLabel,
            nb::arg("label"),
            "(private API)")
        .def("get_label",
            &ImPlot3DAxis::GetLabel,
            "(private API)",
            nb::rv_policy::reference)
        .def("has_label",
            &ImPlot3DAxis::HasLabel, "(private API)")
        .def("has_grid_lines",
            &ImPlot3DAxis::HasGridLines, "(private API)")
        .def("has_tick_labels",
            &ImPlot3DAxis::HasTickLabels, "(private API)")
        .def("has_tick_marks",
            &ImPlot3DAxis::HasTickMarks, "(private API)")
        .def("is_auto_fitting",
            &ImPlot3DAxis::IsAutoFitting, "(private API)")
        .def("extend_fit",
            &ImPlot3DAxis::ExtendFit,
            nb::arg("value"),
            "(private API)")
        .def("apply_fit",
            &ImPlot3DAxis::ApplyFit, "(private API)")
        ;


    auto pyClassImPlot3DPlot =
        nb::class_<ImPlot3DPlot>
            (m, "Plot", "Holds plot state information that must persist after EndPlot")
        .def_rw("id_", &ImPlot3DPlot::ID, "")
        .def_rw("flags", &ImPlot3DPlot::Flags, "")
        .def_rw("previous_flags", &ImPlot3DPlot::PreviousFlags, "")
        .def_rw("just_created", &ImPlot3DPlot::JustCreated, "")
        .def_rw("initialized", &ImPlot3DPlot::Initialized, "")
        .def_rw("frame_rect", &ImPlot3DPlot::FrameRect, "Outermost bounding rectangle that encapsulates whole the plot/title/padding/etc")
        .def_rw("canvas_rect", &ImPlot3DPlot::CanvasRect, "Frame rectangle reduced by padding")
        .def_rw("plot_rect", &ImPlot3DPlot::PlotRect, "Bounding rectangle for the actual plot area")
        .def_rw("initial_rotation", &ImPlot3DPlot::InitialRotation, "Initial rotation quaternion")
        .def_rw("rotation", &ImPlot3DPlot::Rotation, "Current rotation quaternion")
        .def_rw("rotation_cond", &ImPlot3DPlot::RotationCond, "")
        .def_rw("box_scale", &ImPlot3DPlot::BoxScale, "Scale factor for plot box X, Y, Z axes")
        .def_rw("animation_time", &ImPlot3DPlot::AnimationTime, "Remaining animation time")
        .def_rw("rotation_animation_end", &ImPlot3DPlot::RotationAnimationEnd, "End rotation for animation")
        .def_rw("setup_locked", &ImPlot3DPlot::SetupLocked, "")
        .def_rw("hovered", &ImPlot3DPlot::Hovered, "")
        .def_rw("held", &ImPlot3DPlot::Held, "")
        .def_rw("held_edge_idx", &ImPlot3DPlot::HeldEdgeIdx, "Index of the edge being held")
        .def_rw("held_plane_idx", &ImPlot3DPlot::HeldPlaneIdx, "Index of the plane being held")
        .def_rw("fit_this_frame", &ImPlot3DPlot::FitThisFrame, "Fit data")
        .def_rw("items", &ImPlot3DPlot::Items, "Items")
        .def_rw("context_click", &ImPlot3DPlot::ContextClick, "True if context button was clicked (to distinguish from double click)")
        .def_rw("open_context_this_frame", &ImPlot3DPlot::OpenContextThisFrame, "")
        .def(nb::init<>())
        .def("set_title",
            &ImPlot3DPlot::SetTitle,
            nb::arg("title"),
            "(private API)")
        .def("has_title",
            &ImPlot3DPlot::HasTitle, "(private API)")
        .def("get_title",
            &ImPlot3DPlot::GetTitle,
            "(private API)",
            nb::rv_policy::reference)
        .def("is_rotation_locked",
            &ImPlot3DPlot::IsRotationLocked, "(private API)")
        .def("extend_fit",
            &ImPlot3DPlot::ExtendFit,
            nb::arg("point"),
            "(private API)")
        .def("range_min",
            &ImPlot3DPlot::RangeMin, "(private API)")
        .def("range_max",
            &ImPlot3DPlot::RangeMax, "(private API)")
        .def("range_center",
            &ImPlot3DPlot::RangeCenter, "(private API)")
        .def("set_range",
            &ImPlot3DPlot::SetRange,
            nb::arg("min"), nb::arg("max"),
            "(private API)")
        .def("get_box_zoom",
            &ImPlot3DPlot::GetBoxZoom, "(private API)")
        ;


    auto pyClassImPlot3DContext =
        nb::class_<ImPlot3DContext>
            (m, "Context", "")
        .def("__init__", [](ImPlot3DContext * self, const std::optional<const ImPlot3DNextItemData> & NextItemData = std::nullopt, const std::optional<const ImPlot3DStyle> & Style = std::nullopt, const std::optional<const ImPlot3DColormapData> & ColormapData = std::nullopt)
        {
            new (self) ImPlot3DContext();  // placement new
            auto r_ctor_ = self;
            if (NextItemData.has_value())
                r_ctor_->NextItemData = NextItemData.value();
            else
                r_ctor_->NextItemData = ImPlot3DNextItemData();
            if (Style.has_value())
                r_ctor_->Style = Style.value();
            else
                r_ctor_->Style = ImPlot3DStyle();
            if (ColormapData.has_value())
                r_ctor_->ColormapData = ColormapData.value();
            else
                r_ctor_->ColormapData = ImPlot3DColormapData();
        },
        nb::arg("next_item_data").none() = nb::none(), nb::arg("style").none() = nb::none(), nb::arg("colormap_data").none() = nb::none()
        )
        .def_rw("current_plot", &ImPlot3DContext::CurrentPlot, "")
        .def_rw("current_items", &ImPlot3DContext::CurrentItems, "")
        .def_rw("current_item", &ImPlot3DContext::CurrentItem, "")
        .def_rw("next_item_data", &ImPlot3DContext::NextItemData, "")
        .def_rw("style", &ImPlot3DContext::Style, "")
        .def_rw("colormap_data", &ImPlot3DContext::ColormapData, "")
        ;


    m.def("initialize_context",
        ImPlot3D::InitializeContext,
        nb::arg("ctx"),
        "Initialize ImPlot3DContext");

    m.def("reset_context",
        ImPlot3D::ResetContext,
        nb::arg("ctx"),
        "Reset ImPlot3DContext");

    m.def("is_color_auto",
        nb::overload_cast<const ImVec4 &>(ImPlot3D::IsColorAuto), nb::arg("col"));

    m.def("is_color_auto",
        nb::overload_cast<ImPlot3DCol>(ImPlot3D::IsColorAuto), nb::arg("idx"));

    m.def("get_auto_color",
        ImPlot3D::GetAutoColor, nb::arg("idx"));

    m.def("get_style_color_name",
        ImPlot3D::GetStyleColorName,
        nb::arg("idx"),
        nb::rv_policy::reference);

    m.def("calc_text_color",
        nb::overload_cast<const ImVec4 &>(ImPlot3D::CalcTextColor),
        nb::arg("bg"),
        "(private API)");

    m.def("calc_text_color",
        nb::overload_cast<ImU32>(ImPlot3D::CalcTextColor),
        nb::arg("bg"),
        "(private API)");

    m.def("get_item_data",
        ImPlot3D::GetItemData,
        "Get styling data for next item (call between BeginItem/EndItem)",
        nb::rv_policy::reference);

    m.def("get_colormap_color_u32",
        ImPlot3D::GetColormapColorU32,
        nb::arg("idx"), nb::arg("cmap"),
        "Returns a color from the Color map given an index >= 0 (modulo will be performed)");

    m.def("next_colormap_color_u32",
        ImPlot3D::NextColormapColorU32, "Returns the next unused colormap color and advances the colormap. Can be used to skip colors if desired");

    m.def("render_color_bar",
        ImPlot3D::RenderColorBar,
        nb::arg("colors"), nb::arg("size"), nb::arg("draw_list"), nb::arg("bounds"), nb::arg("vert"), nb::arg("reversed"), nb::arg("continuous"),
        "Render a colormap bar");

    m.def("begin_item",
        [](const char * label_id, ImPlot3DItemFlags flags = 0, const std::optional<const ImPlot3DCol> & recolor_from = std::nullopt) -> bool
        {
            auto BeginItem_adapt_mutable_param_with_default_value = [](const char * label_id, ImPlot3DItemFlags flags = 0, const std::optional<const ImPlot3DCol> & recolor_from = std::nullopt) -> bool
            {

                const ImPlot3DCol& recolor_from_or_default = [&]() -> const ImPlot3DCol {
                    if (recolor_from.has_value())
                        return recolor_from.value();
                    else
                        return IMPLOT3D_AUTO;
                }();

                auto lambda_result = ImPlot3D::BeginItem(label_id, flags, recolor_from_or_default);
                return lambda_result;
            };

            return BeginItem_adapt_mutable_param_with_default_value(label_id, flags, recolor_from);
        },
        nb::arg("label_id"), nb::arg("flags") = 0, nb::arg("recolor_from").none() = nb::none(),
        "Python bindings defaults:\n    If recolor_from is None, then its default value will be: IMPLOT3D_AUTO");

    m.def("end_item",
        ImPlot3D::EndItem);

    m.def("register_or_get_item",
        [](const char * label_id, ImPlot3DItemFlags flags, std::optional<bool> just_created = std::nullopt) -> std::tuple<ImPlot3DItem *, std::optional<bool>>
        {
            auto RegisterOrGetItem_adapt_modifiable_immutable_to_return = [](const char * label_id, ImPlot3DItemFlags flags, std::optional<bool> just_created = std::nullopt) -> std::tuple<ImPlot3DItem *, std::optional<bool>>
            {
                bool * just_created_adapt_modifiable = nullptr;
                if (just_created.has_value())
                    just_created_adapt_modifiable = & (*just_created);

                ImPlot3DItem * r = ImPlot3D::RegisterOrGetItem(label_id, flags, just_created_adapt_modifiable);
                return std::make_tuple(r, just_created);
            };

            return RegisterOrGetItem_adapt_modifiable_immutable_to_return(label_id, flags, just_created);
        },
        nb::arg("label_id"), nb::arg("flags"), nb::arg("just_created").none() = nb::none(),
        "Register or get an existing item from the current plot",
        nb::rv_policy::reference);

    m.def("get_current_item",
        ImPlot3D::GetCurrentItem,
        "Gets the current item from ImPlot3DContext",
        nb::rv_policy::reference);

    m.def("bust_item_cache",
        ImPlot3D::BustItemCache, "Busts the cache for every item for every plot in the current context");

    m.def("add_text_rotated",
        [](ImDrawList * draw_list, ImVec2 pos, float angle, ImU32 col, const char * text_begin, std::optional<std::string> text_end = std::nullopt)
        {
            auto AddTextRotated_adapt_const_char_pointer_with_default_null = [](ImDrawList * draw_list, ImVec2 pos, float angle, ImU32 col, const char * text_begin, std::optional<std::string> text_end = std::nullopt)
            {
                const char * text_end_adapt_default_null = nullptr;
                if (text_end.has_value())
                    text_end_adapt_default_null = text_end.value().c_str();

                ImPlot3D::AddTextRotated(draw_list, pos, angle, col, text_begin, text_end_adapt_default_null);
            };

            AddTextRotated_adapt_const_char_pointer_with_default_null(draw_list, pos, angle, col, text_begin, text_end);
        },
        nb::arg("draw_list"), nb::arg("pos"), nb::arg("angle"), nb::arg("col"), nb::arg("text_begin"), nb::arg("text_end").none() = nb::none(),
        "TODO move to another place");

    m.def("get_current_plot",
        ImPlot3D::GetCurrentPlot,
        "Gets the current plot from ImPlot3DContext",
        nb::rv_policy::reference);

    m.def("bust_plot_cache",
        ImPlot3D::BustPlotCache, "Busts the cache for every plot in the current context");

    m.def("get_frame_pos",
        ImPlot3D::GetFramePos, "Get the current frame position (top-left) in pixels");

    m.def("get_frame_size",
        ImPlot3D::GetFrameSize, "Get the current frame size in pixels");

    m.def("plot_to_ndc",
        ImPlot3D::PlotToNDC, nb::arg("point"));

    m.def("ndc_to_plot",
        ImPlot3D::NDCToPlot, nb::arg("point"));

    m.def("ndc_to_pixels",
        ImPlot3D::NDCToPixels,
        nb::arg("point"),
        "Convert a position in the current plot's NDC to pixels");

    m.def("pixels_to_ndc_ray",
        ImPlot3D::PixelsToNDCRay,
        nb::arg("pix"),
        "Convert a pixel coordinate to a ray in the NDC");

    m.def("ndc_ray_to_plot_ray",
        ImPlot3D::NDCRayToPlotRay,
        nb::arg("ray"),
        "Convert a ray in the NDC to a ray in the current plot's coordinate system");

    m.def("setup_lock",
        ImPlot3D::SetupLock);
    // #endif
    ////////////////////    </generated_from:implot3d_internal.h>    ////////////////////

    // </litgen_pydef> // Autogenerated code end
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
}
#endif // #ifdef IMGUI_BUNDLE_WITH_IMPLOT
