// Part of ImGui Bundle - MIT License - Copyright (c) 2022-2024 Pascal Thomet - https://github.com/pthom/imgui_bundle
#include <nanobind/nanobind.h>
#include <nanobind/stl/string.h>
#include <nanobind/stl/array.h>
#include <nanobind/stl/optional.h>
#include <nanobind/stl/vector.h>
#include <nanobind/stl/function.h>
#include <nanobind/ndarray.h>

#include "imspinner/imspinner.h"  // Change this include to the library you are binding

namespace nb = nanobind;

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// <litgen_glue_code>  // Autogenerated code below! Do not edit!

// </litgen_glue_code> // Autogenerated code end
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!



void py_init_module_imspinner(nb::module_& m)
{
    using namespace ImSpinner;
    m.attr("IM_PI") = IM_PI;
    m.def("demo_spinners", ImSpinner::demoSpinners);

    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // <litgen_pydef> // Autogenerated code below! Do not edit!
    ////////////////////    <generated_from:imspinner.h>    ////////////////////
    // #ifndef _IMSPINNER_H_
    //


    m.attr("white") = ImColor (1.f, 1.f, 1.f, 1.f);
    m.attr("half_white") = ImColor(1.f, 1.f, 1.f, 0.5f);
    m.attr("red") = ImColor(1.f, 0.f, 0.f, 1.f);


    auto pyEnumSpinnerTypeT =
        nb::enum_<ImSpinner::SpinnerTypeT>(m, "SpinnerTypeT", nb::is_arithmetic(), "")
            .value("e_st_rainbow", ImSpinner::e_st_rainbow, "")
            .value("e_st_angle", ImSpinner::e_st_angle, "")
            .value("e_st_dots", ImSpinner::e_st_dots, "")
            .value("e_st_ang", ImSpinner::e_st_ang, "")
            .value("e_st_vdots", ImSpinner::e_st_vdots, "")
            .value("e_st_bounce_ball", ImSpinner::e_st_bounce_ball, "")
            .value("e_st_eclipse", ImSpinner::e_st_eclipse, "")
            .value("e_st_ingyang", ImSpinner::e_st_ingyang, "")
            .value("e_st_barchartsine", ImSpinner::e_st_barchartsine, "")
            .value("e_st_count", ImSpinner::e_st_count, "");
    m.attr("PI_DIV_4") = (float) IM_PI / 4.f;
    m.attr("PI_DIV_2") = (float) IM_PI / 2.f;
    m.attr("PI_2") = (float) IM_PI * 2.f;

    m.def("color_alpha",
        ImSpinner::color_alpha, nb::arg("c"), nb::arg("alpha"));

    m.def("damped_spring",
        ImSpinner::damped_spring, nb::arg("mass"), nb::arg("stiffness"), nb::arg("damping"), nb::arg("time"), nb::arg("a") = ImSpinner::PI_DIV_2, nb::arg("b") = ImSpinner::PI_DIV_2);

    m.def("damped_gravity",
        ImSpinner::damped_gravity, nb::arg("limtime"));

    m.def("damped_trifolium",
        ImSpinner::damped_trifolium, nb::arg("limtime"), nb::arg("a") = 0.f, nb::arg("b") = 1.f);

    m.def("damped_inoutelastic",
        ImSpinner::damped_inoutelastic, nb::arg("t"), nb::arg("amplitude"), nb::arg("period"));

    m.def("damped_infinity",
        ImSpinner::damped_infinity, nb::arg("t"), nb::arg("a"));

    m.def("ease_inquad",
        ImSpinner::ease_inquad, nb::arg("time"));

    m.def("ease_outquad",
        ImSpinner::ease_outquad, nb::arg("time"));

    m.def("ease_inoutquad",
        nb::overload_cast<float>(ImSpinner::ease_inoutquad), nb::arg("t"));

    m.def("ease_inoutquad",
        nb::overload_cast<float *>(ImSpinner::ease_inoutquad), nb::arg("p"));

    m.def("ease_outcubic",
        ImSpinner::ease_outcubic, nb::arg("t"));

    m.def("ease_inexpo",
        ImSpinner::ease_inexpo, nb::arg("t"));

    m.def("ease_inoutexpo",
        nb::overload_cast<float>(ImSpinner::ease_inoutexpo), nb::arg("t"));

    m.def("ease_inoutexpo",
        nb::overload_cast<float *>(ImSpinner::ease_inoutexpo), nb::arg("p"));

    m.def("ease_spring",
        ImSpinner::ease_spring, nb::arg("p"));

    m.def("ease_gravity",
        ImSpinner::ease_gravity, nb::arg("p"));

    m.def("ease_infinity",
        ImSpinner::ease_infinity, nb::arg("p"));

    m.def("ease_inoutelastic",
        ImSpinner::ease_inoutelastic, nb::arg("p"));

    m.def("ease_sine",
        ImSpinner::ease_sine, nb::arg("p"));

    m.def("ease_damping",
        ImSpinner::ease_damping, nb::arg("p"));


    auto pyEnumease_mode =
        nb::enum_<ImSpinner::ease_mode>(m, "ease_mode", nb::is_arithmetic(), "")
            .value("e_ease_none", ImSpinner::e_ease_none, "")
            .value("e_ease_inoutquad", ImSpinner::e_ease_inoutquad, "")
            .value("e_ease_inoutexpo", ImSpinner::e_ease_inoutexpo, "")
            .value("e_ease_spring", ImSpinner::e_ease_spring, "")
            .value("e_ease_gravity", ImSpinner::e_ease_gravity, "")
            .value("e_ease_infinity", ImSpinner::e_ease_infinity, "")
            .value("e_ease_elastic", ImSpinner::e_ease_elastic, "")
            .value("e_ease_sine", ImSpinner::e_ease_sine, "")
            .value("e_ease_damping", ImSpinner::e_ease_damping, "");


    m.def("spinner_rainbow",
        ImSpinner::SpinnerRainbow,
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color"), nb::arg("speed"), nb::arg("ang_min") = 0.f, nb::arg("ang_max") = ImSpinner::PI_2, nb::arg("arcs") = 1, nb::arg("mode") = 0,
        "\n        const char *label: A string label for the spinner, used to identify it in ImGui.\n        float radius: The radius of the spinner.\n        float thickness: The thickness of the spinner's border.\n        const ImColor &color: The color of the spinner.\n        float speed: The speed of the spinning animation.\n        float ang_min: Minimum angle of spinning.\n        float ang_max: Maximum angle of spinning.\n        int arcs: Number of arcs of the spinner.\n");


    m.def("spinner_rainbow_mix",
        SpinnerRainbowMix, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color"), nb::arg("speed"), nb::arg("ang_min") = 0.f, nb::arg("ang_max") = PI_2, nb::arg("arcs") = 1, nb::arg("mode") = 0);

    m.def("spinner_rotating_heart",
        SpinnerRotatingHeart,
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color"), nb::arg("speed"), nb::arg("ang_min") = 0.f,
        "This function draws a rotating heart spinner.");

    m.def("spinner_ang",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, float angle = IM_PI, int mode = 0)
        {
            auto SpinnerAng_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, float angle = IM_PI, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return white;
                }();

                SpinnerAng(label, radius, thickness, color_or_default, bg_or_default, speed, angle, mode);
            };

            SpinnerAng_adapt_mutable_param_with_default_value(label, radius, thickness, color, bg, speed, angle, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("angle") = IM_PI, nb::arg("mode") = 0,
        " SpinnerAng is a function that draws a spinner widget with a given angle.\n\n\nPython bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color: white\n        * bg: white");

    m.def("spinner_ang8",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, float angle = IM_PI, int mode = 0, float rkoef = 0.5f)
        {
            auto SpinnerAng8_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, float angle = IM_PI, int mode = 0, float rkoef = 0.5f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return white;
                }();

                SpinnerAng8(label, radius, thickness, color_or_default, bg_or_default, speed, angle, mode, rkoef);
            };

            SpinnerAng8_adapt_mutable_param_with_default_value(label, radius, thickness, color, bg, speed, angle, mode, rkoef);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("angle") = IM_PI, nb::arg("mode") = 0, nb::arg("rkoef") = 0.5f,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color: white\n        * bg: white");

    m.def("spinner_ang_mix",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, float angle = IM_PI, int arcs = 4, int mode = 0)
        {
            auto SpinnerAngMix_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, float angle = IM_PI, int arcs = 4, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerAngMix(label, radius, thickness, color_or_default, speed, angle, arcs, mode);
            };

            SpinnerAngMix_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, angle, arcs, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("angle") = IM_PI, nb::arg("arcs") = 4, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_loading_ring",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, int segments = 5)
        {
            auto SpinnerLoadingRing_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, int segments = 5)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return half_white;
                }();

                SpinnerLoadingRing(label, radius, thickness, color_or_default, bg_or_default, speed, segments);
            };

            SpinnerLoadingRing_adapt_mutable_param_with_default_value(label, radius, thickness, color, bg, speed, segments);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("segments") = 5,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color: white\n        * bg: half_white");

    m.def("spinner_clock",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f)
        {
            auto SpinnerClock_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return half_white;
                }();

                SpinnerClock(label, radius, thickness, color_or_default, bg_or_default, speed);
            };

            SpinnerClock_adapt_mutable_param_with_default_value(label, radius, thickness, color, bg, speed);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color: white\n        * bg: half_white");

    m.def("spinner_pulsar",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, bool sequence = true, float angle = 0.f, int mode = 0)
        {
            auto SpinnerPulsar_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, bool sequence = true, float angle = 0.f, int mode = 0)
            {

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return half_white;
                }();

                SpinnerPulsar(label, radius, thickness, bg_or_default, speed, sequence, angle, mode);
            };

            SpinnerPulsar_adapt_mutable_param_with_default_value(label, radius, thickness, bg, speed, sequence, angle, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("sequence") = true, nb::arg("angle") = 0.f, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If bg is None, then its default value will be: half_white");

    m.def("spinner_double_fade_pulsar",
        [](const char * label, float radius, float param_2, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f)
        {
            auto SpinnerDoubleFadePulsar_adapt_mutable_param_with_default_value = [](const char * label, float radius, float param_2, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f)
            {

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return half_white;
                }();

                SpinnerDoubleFadePulsar(label, radius, param_2, bg_or_default, speed);
            };

            SpinnerDoubleFadePulsar_adapt_mutable_param_with_default_value(label, radius, param_2, bg, speed);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("param_2"), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f,
        "Python bindings defaults:\n    If bg is None, then its default value will be: half_white");

    m.def("spinner_twin_pulsar",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int rings = 2, int mode = 0)
        {
            auto SpinnerTwinPulsar_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int rings = 2, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerTwinPulsar(label, radius, thickness, color_or_default, speed, rings, mode);
            };

            SpinnerTwinPulsar_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, rings, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("rings") = 2, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_fade_pulsar",
        [](const char * label, float radius, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int rings = 2, int mode = 0)
        {
            auto SpinnerFadePulsar_adapt_mutable_param_with_default_value = [](const char * label, float radius, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int rings = 2, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerFadePulsar(label, radius, color_or_default, speed, rings, mode);
            };

            SpinnerFadePulsar_adapt_mutable_param_with_default_value(label, radius, color, speed, rings, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("rings") = 2, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_fade_pulsar_square",
        [](const char * label, float radius, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int rings = 2, int mode = 0)
        {
            auto SpinnerFadePulsarSquare_adapt_mutable_param_with_default_value = [](const char * label, float radius, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int rings = 2, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerFadePulsarSquare(label, radius, color_or_default, speed, rings, mode);
            };

            SpinnerFadePulsarSquare_adapt_mutable_param_with_default_value(label, radius, color, speed, rings, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("rings") = 2, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_circular_lines",
        [](const char * label, float radius, const std::optional<const ImColor> & color = std::nullopt, float speed = 1.8f, int lines = 8, int mode = 0)
        {
            auto SpinnerCircularLines_adapt_mutable_param_with_default_value = [](const char * label, float radius, const std::optional<const ImColor> & color = std::nullopt, float speed = 1.8f, int lines = 8, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerCircularLines(label, radius, color_or_default, speed, lines, mode);
            };

            SpinnerCircularLines_adapt_mutable_param_with_default_value(label, radius, color, speed, lines, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 1.8f, nb::arg("lines") = 8, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_dots",
        [](const char * label, float * nextdot, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dots = 12, float minth = -1.f, int mode = 0)
        {
            auto SpinnerDots_adapt_mutable_param_with_default_value = [](const char * label, float * nextdot, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dots = 12, float minth = -1.f, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerDots(label, nextdot, radius, thickness, color_or_default, speed, dots, minth, mode);
            };

            SpinnerDots_adapt_mutable_param_with_default_value(label, nextdot, radius, thickness, color, speed, dots, minth, mode);
        },
        nb::arg("label"), nb::arg("nextdot"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("dots") = 12, nb::arg("minth") = -1.f, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_v_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bgcolor = std::nullopt, float speed = 2.8f, size_t dots = 12, size_t mdots = 6, int mode = 0)
        {
            auto SpinnerVDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bgcolor = std::nullopt, float speed = 2.8f, size_t dots = 12, size_t mdots = 6, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                const ImColor& bgcolor_or_default = [&]() -> const ImColor {
                    if (bgcolor.has_value())
                        return bgcolor.value();
                    else
                        return white;
                }();

                SpinnerVDots(label, radius, thickness, color_or_default, bgcolor_or_default, speed, dots, mdots, mode);
            };

            SpinnerVDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, bgcolor, speed, dots, mdots, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("bgcolor").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("dots") = 12, nb::arg("mdots") = 6, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color: white\n        * bgcolor: white");

    m.def("spinner_bounce_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dots = 3, int mode = 0)
        {
            auto SpinnerBounceDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dots = 3, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerBounceDots(label, radius, thickness, color_or_default, speed, dots, mode);
            };

            SpinnerBounceDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, dots, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("dots") = 3, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_zip_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dots = 5)
        {
            auto SpinnerZipDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dots = 5)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerZipDots(label, radius, thickness, color_or_default, speed, dots);
            };

            SpinnerZipDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, dots);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("dots") = 5,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_dots_to_points",
        [](const char * label, float radius, float thickness, float offset_k, const std::optional<const ImColor> & color = std::nullopt, float speed = 1.8f, size_t dots = 5)
        {
            auto SpinnerDotsToPoints_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, float offset_k, const std::optional<const ImColor> & color = std::nullopt, float speed = 1.8f, size_t dots = 5)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerDotsToPoints(label, radius, thickness, offset_k, color_or_default, speed, dots);
            };

            SpinnerDotsToPoints_adapt_mutable_param_with_default_value(label, radius, thickness, offset_k, color, speed, dots);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("offset_k"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 1.8f, nb::arg("dots") = 5,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_dots_to_bar",
        [](const char * label, float radius, float thickness, float offset_k, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dots = 5)
        {
            auto SpinnerDotsToBar_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, float offset_k, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dots = 5)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerDotsToBar(label, radius, thickness, offset_k, color_or_default, speed, dots);
            };

            SpinnerDotsToBar_adapt_mutable_param_with_default_value(label, radius, thickness, offset_k, color, speed, dots);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("offset_k"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("dots") = 5,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_wave_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int lt = 8)
        {
            auto SpinnerWaveDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int lt = 8)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerWaveDots(label, radius, thickness, color_or_default, speed, lt);
            };

            SpinnerWaveDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, lt);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("lt") = 8,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_fade_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int lt = 8, int mode = 0)
        {
            auto SpinnerFadeDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int lt = 8, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerFadeDots(label, radius, thickness, color_or_default, speed, lt, mode);
            };

            SpinnerFadeDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, lt, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("lt") = 8, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_three_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int lt = 8)
        {
            auto SpinnerThreeDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int lt = 8)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerThreeDots(label, radius, thickness, color_or_default, speed, lt);
            };

            SpinnerThreeDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, lt);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("lt") = 8,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_five_dots",
        SpinnerFiveDots, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color") = 0xffffffff, nb::arg("speed") = 2.8f, nb::arg("lt") = 8);

    m.def("spinner4_caleidospcope",
        Spinner4Caleidospcope, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color") = 0xffffffff, nb::arg("speed") = 2.8f, nb::arg("lt") = 8);

    m.def("spinner_multi_fade_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int lt = 8)
        {
            auto SpinnerMultiFadeDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int lt = 8)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerMultiFadeDots(label, radius, thickness, color_or_default, speed, lt);
            };

            SpinnerMultiFadeDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, lt);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("lt") = 8,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_thick_to_sin",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int nt = 1, int lt = 8, int mode = 0)
        {
            auto SpinnerThickToSin_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int nt = 1, int lt = 8, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerThickToSin(label, radius, thickness, color_or_default, speed, nt, lt, mode);
            };

            SpinnerThickToSin_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, nt, lt, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("nt") = 1, nb::arg("lt") = 8, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_scale_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int lt = 8)
        {
            auto SpinnerScaleDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int lt = 8)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerScaleDots(label, radius, thickness, color_or_default, speed, lt);
            };

            SpinnerScaleDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, lt);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("lt") = 8,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_square_spins",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
        {
            auto SpinnerSquareSpins_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerSquareSpins(label, radius, thickness, color_or_default, speed);
            };

            SpinnerSquareSpins_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_moving_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dots = 3)
        {
            auto SpinnerMovingDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dots = 3)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerMovingDots(label, radius, thickness, color_or_default, speed, dots);
            };

            SpinnerMovingDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, dots);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("dots") = 3,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_rotate_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int dots = 2, int mode = 0)
        {
            auto SpinnerRotateDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int dots = 2, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerRotateDots(label, radius, thickness, color_or_default, speed, dots, mode);
            };

            SpinnerRotateDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, dots, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("dots") = 2, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_orion_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int arcs = 4)
        {
            auto SpinnerOrionDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int arcs = 4)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerOrionDots(label, radius, thickness, color_or_default, speed, arcs);
            };

            SpinnerOrionDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, arcs);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("arcs") = 4,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_galaxy_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int arcs = 4)
        {
            auto SpinnerGalaxyDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int arcs = 4)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerGalaxyDots(label, radius, thickness, color_or_default, speed, arcs);
            };

            SpinnerGalaxyDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, arcs);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("arcs") = 4,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_twin_ang",
        [](const char * label, float radius1, float radius2, float thickness, const std::optional<const ImColor> & color1 = std::nullopt, const std::optional<const ImColor> & color2 = std::nullopt, float speed = 2.8f, float angle = IM_PI, int mode = 0)
        {
            auto SpinnerTwinAng_adapt_mutable_param_with_default_value = [](const char * label, float radius1, float radius2, float thickness, const std::optional<const ImColor> & color1 = std::nullopt, const std::optional<const ImColor> & color2 = std::nullopt, float speed = 2.8f, float angle = IM_PI, int mode = 0)
            {

                const ImColor& color1_or_default = [&]() -> const ImColor {
                    if (color1.has_value())
                        return color1.value();
                    else
                        return white;
                }();

                const ImColor& color2_or_default = [&]() -> const ImColor {
                    if (color2.has_value())
                        return color2.value();
                    else
                        return red;
                }();

                SpinnerTwinAng(label, radius1, radius2, thickness, color1_or_default, color2_or_default, speed, angle, mode);
            };

            SpinnerTwinAng_adapt_mutable_param_with_default_value(label, radius1, radius2, thickness, color1, color2, speed, angle, mode);
        },
        nb::arg("label"), nb::arg("radius1"), nb::arg("radius2"), nb::arg("thickness"), nb::arg("color1").none() = nb::none(), nb::arg("color2").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("angle") = IM_PI, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color1: white\n        * color2: red");

    m.def("spinner_filling",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color1 = std::nullopt, const std::optional<const ImColor> & color2 = std::nullopt, float speed = 2.8f)
        {
            auto SpinnerFilling_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color1 = std::nullopt, const std::optional<const ImColor> & color2 = std::nullopt, float speed = 2.8f)
            {

                const ImColor& color1_or_default = [&]() -> const ImColor {
                    if (color1.has_value())
                        return color1.value();
                    else
                        return white;
                }();

                const ImColor& color2_or_default = [&]() -> const ImColor {
                    if (color2.has_value())
                        return color2.value();
                    else
                        return red;
                }();

                SpinnerFilling(label, radius, thickness, color1_or_default, color2_or_default, speed);
            };

            SpinnerFilling_adapt_mutable_param_with_default_value(label, radius, thickness, color1, color2, speed);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color1").none() = nb::none(), nb::arg("color2").none() = nb::none(), nb::arg("speed") = 2.8f,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color1: white\n        * color2: red");

    m.def("spinner_filling_mem",
        SpinnerFillingMem, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color"), nb::arg("colorbg"), nb::arg("speed"));

    m.def("spinner_topup",
        [](const char * label, float radius1, float radius2, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & fg = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f)
        {
            auto SpinnerTopup_adapt_mutable_param_with_default_value = [](const char * label, float radius1, float radius2, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & fg = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return red;
                }();

                const ImColor& fg_or_default = [&]() -> const ImColor {
                    if (fg.has_value())
                        return fg.value();
                    else
                        return white;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return white;
                }();

                SpinnerTopup(label, radius1, radius2, color_or_default, fg_or_default, bg_or_default, speed);
            };

            SpinnerTopup_adapt_mutable_param_with_default_value(label, radius1, radius2, color, fg, bg, speed);
        },
        nb::arg("label"), nb::arg("radius1"), nb::arg("radius2"), nb::arg("color").none() = nb::none(), nb::arg("fg").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color: red\n        * fg: white\n        * bg: white");

    m.def("spinner_twin_ang180",
        [](const char * label, float radius1, float radius2, float thickness, const std::optional<const ImColor> & color1 = std::nullopt, const std::optional<const ImColor> & color2 = std::nullopt, float speed = 2.8f, float angle = PI_DIV_4, int mode = 0)
        {
            auto SpinnerTwinAng180_adapt_mutable_param_with_default_value = [](const char * label, float radius1, float radius2, float thickness, const std::optional<const ImColor> & color1 = std::nullopt, const std::optional<const ImColor> & color2 = std::nullopt, float speed = 2.8f, float angle = PI_DIV_4, int mode = 0)
            {

                const ImColor& color1_or_default = [&]() -> const ImColor {
                    if (color1.has_value())
                        return color1.value();
                    else
                        return white;
                }();

                const ImColor& color2_or_default = [&]() -> const ImColor {
                    if (color2.has_value())
                        return color2.value();
                    else
                        return red;
                }();

                SpinnerTwinAng180(label, radius1, radius2, thickness, color1_or_default, color2_or_default, speed, angle, mode);
            };

            SpinnerTwinAng180_adapt_mutable_param_with_default_value(label, radius1, radius2, thickness, color1, color2, speed, angle, mode);
        },
        nb::arg("label"), nb::arg("radius1"), nb::arg("radius2"), nb::arg("thickness"), nb::arg("color1").none() = nb::none(), nb::arg("color2").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("angle") = PI_DIV_4, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color1: white\n        * color2: red");

    m.def("spinner_twin_ang360",
        [](const char * label, float radius1, float radius2, float thickness, const std::optional<const ImColor> & color1 = std::nullopt, const std::optional<const ImColor> & color2 = std::nullopt, float speed1 = 2.8f, float speed2 = 2.5f, int mode = 0)
        {
            auto SpinnerTwinAng360_adapt_mutable_param_with_default_value = [](const char * label, float radius1, float radius2, float thickness, const std::optional<const ImColor> & color1 = std::nullopt, const std::optional<const ImColor> & color2 = std::nullopt, float speed1 = 2.8f, float speed2 = 2.5f, int mode = 0)
            {

                const ImColor& color1_or_default = [&]() -> const ImColor {
                    if (color1.has_value())
                        return color1.value();
                    else
                        return white;
                }();

                const ImColor& color2_or_default = [&]() -> const ImColor {
                    if (color2.has_value())
                        return color2.value();
                    else
                        return red;
                }();

                SpinnerTwinAng360(label, radius1, radius2, thickness, color1_or_default, color2_or_default, speed1, speed2, mode);
            };

            SpinnerTwinAng360_adapt_mutable_param_with_default_value(label, radius1, radius2, thickness, color1, color2, speed1, speed2, mode);
        },
        nb::arg("label"), nb::arg("radius1"), nb::arg("radius2"), nb::arg("thickness"), nb::arg("color1").none() = nb::none(), nb::arg("color2").none() = nb::none(), nb::arg("speed1") = 2.8f, nb::arg("speed2") = 2.5f, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color1: white\n        * color2: red");

    m.def("spinner_inc_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dots = 6)
        {
            auto SpinnerIncDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dots = 6)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerIncDots(label, radius, thickness, color_or_default, speed, dots);
            };

            SpinnerIncDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, dots);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("dots") = 6,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_inc_full_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dots = 4)
        {
            auto SpinnerIncFullDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dots = 4)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerIncFullDots(label, radius, thickness, color_or_default, speed, dots);
            };

            SpinnerIncFullDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, dots);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("dots") = 4,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_fade_bars",
        [](const char * label, float w, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t bars = 3, bool scale = false)
        {
            auto SpinnerFadeBars_adapt_mutable_param_with_default_value = [](const char * label, float w, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t bars = 3, bool scale = false)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerFadeBars(label, w, color_or_default, speed, bars, scale);
            };

            SpinnerFadeBars_adapt_mutable_param_with_default_value(label, w, color, speed, bars, scale);
        },
        nb::arg("label"), nb::arg("w"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("bars") = 3, nb::arg("scale") = false,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_fade_tris",
        [](const char * label, float radius, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dim = 2, bool scale = false, int mode = 0)
        {
            auto SpinnerFadeTris_adapt_mutable_param_with_default_value = [](const char * label, float radius, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dim = 2, bool scale = false, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerFadeTris(label, radius, color_or_default, speed, dim, scale, mode);
            };

            SpinnerFadeTris_adapt_mutable_param_with_default_value(label, radius, color, speed, dim, scale, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("dim") = 2, nb::arg("scale") = false, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_bars_rotate_fade",
        [](const char * label, float rmin, float rmax, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t bars = 6)
        {
            auto SpinnerBarsRotateFade_adapt_mutable_param_with_default_value = [](const char * label, float rmin, float rmax, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t bars = 6)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerBarsRotateFade(label, rmin, rmax, thickness, color_or_default, speed, bars);
            };

            SpinnerBarsRotateFade_adapt_mutable_param_with_default_value(label, rmin, rmax, thickness, color, speed, bars);
        },
        nb::arg("label"), nb::arg("rmin"), nb::arg("rmax"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("bars") = 6,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_bars_scale_middle",
        [](const char * label, float w, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t bars = 3)
        {
            auto SpinnerBarsScaleMiddle_adapt_mutable_param_with_default_value = [](const char * label, float w, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t bars = 3)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerBarsScaleMiddle(label, w, color_or_default, speed, bars);
            };

            SpinnerBarsScaleMiddle_adapt_mutable_param_with_default_value(label, w, color, speed, bars);
        },
        nb::arg("label"), nb::arg("w"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("bars") = 3,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_ang_twin",
        [](const char * label, float radius1, float radius2, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, float angle = IM_PI, size_t arcs = 1, int mode = 0)
        {
            auto SpinnerAngTwin_adapt_mutable_param_with_default_value = [](const char * label, float radius1, float radius2, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, float angle = IM_PI, size_t arcs = 1, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return half_white;
                }();

                SpinnerAngTwin(label, radius1, radius2, thickness, color_or_default, bg_or_default, speed, angle, arcs, mode);
            };

            SpinnerAngTwin_adapt_mutable_param_with_default_value(label, radius1, radius2, thickness, color, bg, speed, angle, arcs, mode);
        },
        nb::arg("label"), nb::arg("radius1"), nb::arg("radius2"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("angle") = IM_PI, nb::arg("arcs") = 1, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color: white\n        * bg: half_white");

    m.def("spinner_arc_rotation",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4, int mode = 0)
        {
            auto SpinnerArcRotation_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerArcRotation(label, radius, thickness, color_or_default, speed, arcs, mode);
            };

            SpinnerArcRotation_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, arcs, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("arcs") = 4, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_arc_fade",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4, int mode = 0)
        {
            auto SpinnerArcFade_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerArcFade(label, radius, thickness, color_or_default, speed, arcs, mode);
            };

            SpinnerArcFade_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, arcs, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("arcs") = 4, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_simple_arc_fade",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
        {
            auto SpinnerSimpleArcFade_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerSimpleArcFade(label, radius, thickness, color_or_default, speed);
            };

            SpinnerSimpleArcFade_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_square_stroke_fade",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
        {
            auto SpinnerSquareStrokeFade_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerSquareStrokeFade(label, radius, thickness, color_or_default, speed);
            };

            SpinnerSquareStrokeFade_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_ascii_symbol_points",
        [](const char * label, const char * text, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
        {
            auto SpinnerAsciiSymbolPoints_adapt_mutable_param_with_default_value = [](const char * label, const char * text, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerAsciiSymbolPoints(label, text, radius, thickness, color_or_default, speed);
            };

            SpinnerAsciiSymbolPoints_adapt_mutable_param_with_default_value(label, text, radius, thickness, color, speed);
        },
        nb::arg("label"), nb::arg("text"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_text_fading",
        [](const char * label, const char * text, float radius, float fsize, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
        {
            auto SpinnerTextFading_adapt_mutable_param_with_default_value = [](const char * label, const char * text, float radius, float fsize, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerTextFading(label, text, radius, fsize, color_or_default, speed);
            };

            SpinnerTextFading_adapt_mutable_param_with_default_value(label, text, radius, fsize, color, speed);
        },
        nb::arg("label"), nb::arg("text"), nb::arg("radius"), nb::arg("fsize"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_seven_segments",
        [](const char * label, const char * text, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
        {
            auto SpinnerSevenSegments_adapt_mutable_param_with_default_value = [](const char * label, const char * text, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerSevenSegments(label, text, radius, thickness, color_or_default, speed);
            };

            SpinnerSevenSegments_adapt_mutable_param_with_default_value(label, text, radius, thickness, color, speed);
        },
        nb::arg("label"), nb::arg("text"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_square_stroke_fill",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
        {
            auto SpinnerSquareStrokeFill_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerSquareStrokeFill(label, radius, thickness, color_or_default, speed);
            };

            SpinnerSquareStrokeFill_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_square_stroke_loading",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
        {
            auto SpinnerSquareStrokeLoading_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerSquareStrokeLoading(label, radius, thickness, color_or_default, speed);
            };

            SpinnerSquareStrokeLoading_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_square_loading",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
        {
            auto SpinnerSquareLoading_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerSquareLoading(label, radius, thickness, color_or_default, speed);
            };

            SpinnerSquareLoading_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_filled_arc_fade",
        [](const char * label, float radius, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4, int mode = 0)
        {
            auto SpinnerFilledArcFade_adapt_mutable_param_with_default_value = [](const char * label, float radius, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerFilledArcFade(label, radius, color_or_default, speed, arcs, mode);
            };

            SpinnerFilledArcFade_adapt_mutable_param_with_default_value(label, radius, color, speed, arcs, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("arcs") = 4, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_points_roller",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t points = 8, int circles = 2, float rspeed = 1.f)
        {
            auto SpinnerPointsRoller_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t points = 8, int circles = 2, float rspeed = 1.f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerPointsRoller(label, radius, thickness, color_or_default, speed, points, circles, rspeed);
            };

            SpinnerPointsRoller_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, points, circles, rspeed);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("points") = 8, nb::arg("circles") = 2, nb::arg("rspeed") = 1.f,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_points_arc_bounce",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t points = 4, int circles = 2, float rspeed = 0.f)
        {
            auto SpinnerPointsArcBounce_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t points = 4, int circles = 2, float rspeed = 0.f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerPointsArcBounce(label, radius, thickness, color_or_default, speed, points, circles, rspeed);
            };

            SpinnerPointsArcBounce_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, points, circles, rspeed);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("points") = 4, nb::arg("circles") = 2, nb::arg("rspeed") = 0.f,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_filled_arc_color",
        [](const char * label, float radius, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, size_t arcs = 4)
        {
            auto SpinnerFilledArcColor_adapt_mutable_param_with_default_value = [](const char * label, float radius, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, size_t arcs = 4)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return red;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return white;
                }();

                SpinnerFilledArcColor(label, radius, color_or_default, bg_or_default, speed, arcs);
            };

            SpinnerFilledArcColor_adapt_mutable_param_with_default_value(label, radius, color, bg, speed, arcs);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("color").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("arcs") = 4,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color: red\n        * bg: white");

    m.def("spinner_filled_arc_ring",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, size_t arcs = 4)
        {
            auto SpinnerFilledArcRing_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, size_t arcs = 4)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return red;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return white;
                }();

                SpinnerFilledArcRing(label, radius, thickness, color_or_default, bg_or_default, speed, arcs);
            };

            SpinnerFilledArcRing_adapt_mutable_param_with_default_value(label, radius, thickness, color, bg, speed, arcs);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("arcs") = 4,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color: red\n        * bg: white");

    m.def("spinner_arc_wedges",
        [](const char * label, float radius, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4, int mode = 0)
        {
            auto SpinnerArcWedges_adapt_mutable_param_with_default_value = [](const char * label, float radius, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return red;
                }();

                SpinnerArcWedges(label, radius, color_or_default, speed, arcs, mode);
            };

            SpinnerArcWedges_adapt_mutable_param_with_default_value(label, radius, color, speed, arcs, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("arcs") = 4, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: red");

    m.def("spinner_twin_ball",
        [](const char * label, float radius1, float radius2, float thickness, float b_thickness, const std::optional<const ImColor> & ball = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, size_t balls = 2, int mode = 0)
        {
            auto SpinnerTwinBall_adapt_mutable_param_with_default_value = [](const char * label, float radius1, float radius2, float thickness, float b_thickness, const std::optional<const ImColor> & ball = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, size_t balls = 2, int mode = 0)
            {

                const ImColor& ball_or_default = [&]() -> const ImColor {
                    if (ball.has_value())
                        return ball.value();
                    else
                        return white;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return half_white;
                }();

                SpinnerTwinBall(label, radius1, radius2, thickness, b_thickness, ball_or_default, bg_or_default, speed, balls, mode);
            };

            SpinnerTwinBall_adapt_mutable_param_with_default_value(label, radius1, radius2, thickness, b_thickness, ball, bg, speed, balls, mode);
        },
        nb::arg("label"), nb::arg("radius1"), nb::arg("radius2"), nb::arg("thickness"), nb::arg("b_thickness"), nb::arg("ball").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("balls") = 2, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * ball: white\n        * bg: half_white");

    m.def("spinner_solar_balls",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & ball = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, size_t balls = 4)
        {
            auto SpinnerSolarBalls_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & ball = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, size_t balls = 4)
            {

                const ImColor& ball_or_default = [&]() -> const ImColor {
                    if (ball.has_value())
                        return ball.value();
                    else
                        return white;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return half_white;
                }();

                SpinnerSolarBalls(label, radius, thickness, ball_or_default, bg_or_default, speed, balls);
            };

            SpinnerSolarBalls_adapt_mutable_param_with_default_value(label, radius, thickness, ball, bg, speed, balls);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("ball").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("balls") = 4,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * ball: white\n        * bg: half_white");

    m.def("spinner_solar_scale_balls",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & ball = std::nullopt, float speed = 2.8f, size_t balls = 4)
        {
            auto SpinnerSolarScaleBalls_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & ball = std::nullopt, float speed = 2.8f, size_t balls = 4)
            {

                const ImColor& ball_or_default = [&]() -> const ImColor {
                    if (ball.has_value())
                        return ball.value();
                    else
                        return white;
                }();

                SpinnerSolarScaleBalls(label, radius, thickness, ball_or_default, speed, balls);
            };

            SpinnerSolarScaleBalls_adapt_mutable_param_with_default_value(label, radius, thickness, ball, speed, balls);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("ball").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("balls") = 4,
        "Python bindings defaults:\n    If ball is None, then its default value will be: white");

    m.def("spinner_solar_arcs",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & ball = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, size_t balls = 4)
        {
            auto SpinnerSolarArcs_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & ball = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, size_t balls = 4)
            {

                const ImColor& ball_or_default = [&]() -> const ImColor {
                    if (ball.has_value())
                        return ball.value();
                    else
                        return white;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return half_white;
                }();

                SpinnerSolarArcs(label, radius, thickness, ball_or_default, bg_or_default, speed, balls);
            };

            SpinnerSolarArcs_adapt_mutable_param_with_default_value(label, radius, thickness, ball, bg, speed, balls);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("ball").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("balls") = 4,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * ball: white\n        * bg: half_white");

    m.def("spinner_moving_arcs",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4)
        {
            auto SpinnerMovingArcs_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerMovingArcs(label, radius, thickness, color_or_default, speed, arcs);
            };

            SpinnerMovingArcs_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, arcs);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("arcs") = 4,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_rainbow_circle",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4, float mode = 1)
        {
            auto SpinnerRainbowCircle_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4, float mode = 1)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerRainbowCircle(label, radius, thickness, color_or_default, speed, arcs, mode);
            };

            SpinnerRainbowCircle_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, arcs, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("arcs") = 4, nb::arg("mode") = 1,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_bounce_ball",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int dots = 1, bool shadow = false)
        {
            auto SpinnerBounceBall_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int dots = 1, bool shadow = false)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerBounceBall(label, radius, thickness, color_or_default, speed, dots, shadow);
            };

            SpinnerBounceBall_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, dots, shadow);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("dots") = 1, nb::arg("shadow") = false,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_pulsar_ball",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, bool shadow = false, int mode = 0)
        {
            auto SpinnerPulsarBall_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, bool shadow = false, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerPulsarBall(label, radius, thickness, color_or_default, speed, shadow, mode);
            };

            SpinnerPulsarBall_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, shadow, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("shadow") = false, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_inc_scale_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dots = 6, float angle = 0.f, int mode = 0)
        {
            auto SpinnerIncScaleDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dots = 6, float angle = 0.f, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerIncScaleDots(label, radius, thickness, color_or_default, speed, dots, angle, mode);
            };

            SpinnerIncScaleDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, dots, angle, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("dots") = 6, nb::arg("angle") = 0.f, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_some_scale_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dots = 6, int mode = 0)
        {
            auto SpinnerSomeScaleDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t dots = 6, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerSomeScaleDots(label, radius, thickness, color_or_default, speed, dots, mode);
            };

            SpinnerSomeScaleDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, dots, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("dots") = 6, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_ang_triple",
        [](const char * label, float radius1, float radius2, float radius3, float thickness, const std::optional<const ImColor> & c1 = std::nullopt, const std::optional<const ImColor> & c2 = std::nullopt, const std::optional<const ImColor> & c3 = std::nullopt, float speed = 2.8f, float angle = IM_PI)
        {
            auto SpinnerAngTriple_adapt_mutable_param_with_default_value = [](const char * label, float radius1, float radius2, float radius3, float thickness, const std::optional<const ImColor> & c1 = std::nullopt, const std::optional<const ImColor> & c2 = std::nullopt, const std::optional<const ImColor> & c3 = std::nullopt, float speed = 2.8f, float angle = IM_PI)
            {

                const ImColor& c1_or_default = [&]() -> const ImColor {
                    if (c1.has_value())
                        return c1.value();
                    else
                        return white;
                }();

                const ImColor& c2_or_default = [&]() -> const ImColor {
                    if (c2.has_value())
                        return c2.value();
                    else
                        return half_white;
                }();

                const ImColor& c3_or_default = [&]() -> const ImColor {
                    if (c3.has_value())
                        return c3.value();
                    else
                        return white;
                }();

                SpinnerAngTriple(label, radius1, radius2, radius3, thickness, c1_or_default, c2_or_default, c3_or_default, speed, angle);
            };

            SpinnerAngTriple_adapt_mutable_param_with_default_value(label, radius1, radius2, radius3, thickness, c1, c2, c3, speed, angle);
        },
        nb::arg("label"), nb::arg("radius1"), nb::arg("radius2"), nb::arg("radius3"), nb::arg("thickness"), nb::arg("c1").none() = nb::none(), nb::arg("c2").none() = nb::none(), nb::arg("c3").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("angle") = IM_PI,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * c1: white\n        * c2: half_white\n        * c3: white");

    m.def("spinner_ang_eclipse",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, float angle = IM_PI)
        {
            auto SpinnerAngEclipse_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, float angle = IM_PI)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerAngEclipse(label, radius, thickness, color_or_default, speed, angle);
            };

            SpinnerAngEclipse_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, angle);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("angle") = IM_PI,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_ing_yang",
        [](const char * label, float radius, float thickness, bool reverse, float yang_detlta_r, const std::optional<const ImColor> & colorI = std::nullopt, const std::optional<const ImColor> & colorY = std::nullopt, float speed = 2.8f, float angle = IM_PI * 0.7f, int mode = 0)
        {
            auto SpinnerIngYang_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, bool reverse, float yang_detlta_r, const std::optional<const ImColor> & colorI = std::nullopt, const std::optional<const ImColor> & colorY = std::nullopt, float speed = 2.8f, float angle = IM_PI * 0.7f, int mode = 0)
            {

                const ImColor& colorI_or_default = [&]() -> const ImColor {
                    if (colorI.has_value())
                        return colorI.value();
                    else
                        return white;
                }();

                const ImColor& colorY_or_default = [&]() -> const ImColor {
                    if (colorY.has_value())
                        return colorY.value();
                    else
                        return white;
                }();

                SpinnerIngYang(label, radius, thickness, reverse, yang_detlta_r, colorI_or_default, colorY_or_default, speed, angle, mode);
            };

            SpinnerIngYang_adapt_mutable_param_with_default_value(label, radius, thickness, reverse, yang_detlta_r, colorI, colorY, speed, angle, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("reverse"), nb::arg("yang_detlta_r"), nb::arg("color_i").none() = nb::none(), nb::arg("color_y").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("angle") = IM_PI * 0.7f, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * colorI: white\n        * colorY: white");

    m.def("spinner_gooey_balls",
        SpinnerGooeyBalls, nb::arg("label"), nb::arg("radius"), nb::arg("color"), nb::arg("speed"), nb::arg("mode") = 0);

    m.def("spinner_dots_loading",
        SpinnerDotsLoading, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color"), nb::arg("bg"), nb::arg("speed"));

    m.def("spinner_rotate_gooey_balls",
        SpinnerRotateGooeyBalls, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color"), nb::arg("speed"), nb::arg("balls"), nb::arg("mode") = 0);

    m.def("spinner_herbert_balls",
        SpinnerHerbertBalls, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color"), nb::arg("speed"), nb::arg("balls"));

    m.def("spinner_herbert_balls3_d",
        SpinnerHerbertBalls3D, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color"), nb::arg("speed"));

    m.def("spinner_rotate_triangles",
        SpinnerRotateTriangles, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color"), nb::arg("speed"), nb::arg("tris"), nb::arg("mode") = 0);

    m.def("spinner_rotate_shapes",
        SpinnerRotateShapes, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color"), nb::arg("speed"), nb::arg("shapes"), nb::arg("pnt"));

    m.def("spinner_sin_squares",
        SpinnerSinSquares, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color"), nb::arg("speed"), nb::arg("mode") = 0);

    m.def("spinner_moon_line",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, float angle = IM_PI)
        {
            auto SpinnerMoonLine_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, float angle = IM_PI)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return red;
                }();

                SpinnerMoonLine(label, radius, thickness, color_or_default, bg_or_default, speed, angle);
            };

            SpinnerMoonLine_adapt_mutable_param_with_default_value(label, radius, thickness, color, bg, speed, angle);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("angle") = IM_PI,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color: white\n        * bg: red");

    m.def("spinner_circle_drop",
        [](const char * label, float radius, float thickness, float thickness_drop, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, float angle = IM_PI)
        {
            auto SpinnerCircleDrop_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, float thickness_drop, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, float angle = IM_PI)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return half_white;
                }();

                SpinnerCircleDrop(label, radius, thickness, thickness_drop, color_or_default, bg_or_default, speed, angle);
            };

            SpinnerCircleDrop_adapt_mutable_param_with_default_value(label, radius, thickness, thickness_drop, color, bg, speed, angle);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("thickness_drop"), nb::arg("color").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("angle") = IM_PI,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color: white\n        * bg: half_white");

    m.def("spinner_surrounded_indicator",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f)
        {
            auto SpinnerSurroundedIndicator_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return half_white;
                }();

                SpinnerSurroundedIndicator(label, radius, thickness, color_or_default, bg_or_default, speed);
            };

            SpinnerSurroundedIndicator_adapt_mutable_param_with_default_value(label, radius, thickness, color, bg, speed);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color: white\n        * bg: half_white");

    m.def("spinner_wifi_indicator",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, float cangle = 0.f, int dots = 3)
        {
            auto SpinnerWifiIndicator_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, float cangle = 0.f, int dots = 3)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return red;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return half_white;
                }();

                SpinnerWifiIndicator(label, radius, thickness, color_or_default, bg_or_default, speed, cangle, dots);
            };

            SpinnerWifiIndicator_adapt_mutable_param_with_default_value(label, radius, thickness, color, bg, speed, cangle, dots);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("cangle") = 0.f, nb::arg("dots") = 3,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color: red\n        * bg: half_white");

    m.def("spinner_triangles_selector",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, size_t bars = 8)
        {
            auto SpinnerTrianglesSelector_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, size_t bars = 8)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return half_white;
                }();

                SpinnerTrianglesSelector(label, radius, thickness, color_or_default, bg_or_default, speed, bars);
            };

            SpinnerTrianglesSelector_adapt_mutable_param_with_default_value(label, radius, thickness, color, bg, speed, bars);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("bars") = 8,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color: white\n        * bg: half_white");

    m.def("spinner_flowing_gradient",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, float angle = IM_PI)
        {
            auto SpinnerFlowingGradient_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, float angle = IM_PI)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return red;
                }();

                SpinnerFlowingGradient(label, radius, thickness, color_or_default, bg_or_default, speed, angle);
            };

            SpinnerFlowingGradient_adapt_mutable_param_with_default_value(label, radius, thickness, color, bg, speed, angle);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("angle") = IM_PI,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color: white\n        * bg: red");

    m.def("spinner_rotate_segments",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4, size_t layers = 1, int mode = 0)
        {
            auto SpinnerRotateSegments_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4, size_t layers = 1, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerRotateSegments(label, radius, thickness, color_or_default, speed, arcs, layers, mode);
            };

            SpinnerRotateSegments_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, arcs, layers, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("arcs") = 4, nb::arg("layers") = 1, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_lemniscate",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, float angle = IM_PI / 2.0f)
        {
            auto SpinnerLemniscate_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, float angle = IM_PI / 2.0f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerLemniscate(label, radius, thickness, color_or_default, speed, angle);
            };

            SpinnerLemniscate_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, angle);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("angle") = IM_PI / 2.0f,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_rotate_gear",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t pins = 12)
        {
            auto SpinnerRotateGear_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t pins = 12)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerRotateGear(label, radius, thickness, color_or_default, speed, pins);
            };

            SpinnerRotateGear_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, pins);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("pins") = 12,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_rotate_wheel",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & bg_color = std::nullopt, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t pins = 12)
        {
            auto SpinnerRotateWheel_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & bg_color = std::nullopt, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t pins = 12)
            {

                const ImColor& bg_color_or_default = [&]() -> const ImColor {
                    if (bg_color.has_value())
                        return bg_color.value();
                    else
                        return white;
                }();

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerRotateWheel(label, radius, thickness, bg_color_or_default, color_or_default, speed, pins);
            };

            SpinnerRotateWheel_adapt_mutable_param_with_default_value(label, radius, thickness, bg_color, color, speed, pins);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("bg_color").none() = nb::none(), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("pins") = 12,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * bg_color: white\n        * color: white");

    m.def("spinner_atom",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int elipses = 3)
        {
            auto SpinnerAtom_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int elipses = 3)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerAtom(label, radius, thickness, color_or_default, speed, elipses);
            };

            SpinnerAtom_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, elipses);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("elipses") = 3,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_pattern_rings",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int elipses = 3)
        {
            auto SpinnerPatternRings_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int elipses = 3)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerPatternRings(label, radius, thickness, color_or_default, speed, elipses);
            };

            SpinnerPatternRings_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, elipses);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("elipses") = 3,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_pattern_eclipse",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int elipses = 3, float delta_a = 2.f, float delta_y = 0.f)
        {
            auto SpinnerPatternEclipse_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int elipses = 3, float delta_a = 2.f, float delta_y = 0.f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerPatternEclipse(label, radius, thickness, color_or_default, speed, elipses, delta_a, delta_y);
            };

            SpinnerPatternEclipse_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, elipses, delta_a, delta_y);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("elipses") = 3, nb::arg("delta_a") = 2.f, nb::arg("delta_y") = 0.f,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_pattern_sphere",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int elipses = 3)
        {
            auto SpinnerPatternSphere_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int elipses = 3)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerPatternSphere(label, radius, thickness, color_or_default, speed, elipses);
            };

            SpinnerPatternSphere_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, elipses);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("elipses") = 3,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_ring_synchronous",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int elipses = 3)
        {
            auto SpinnerRingSynchronous_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int elipses = 3)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerRingSynchronous(label, radius, thickness, color_or_default, speed, elipses);
            };

            SpinnerRingSynchronous_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, elipses);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("elipses") = 3,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_ring_watermarks",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int elipses = 3)
        {
            auto SpinnerRingWatermarks_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int elipses = 3)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerRingWatermarks(label, radius, thickness, color_or_default, speed, elipses);
            };

            SpinnerRingWatermarks_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, elipses);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("elipses") = 3,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_rotated_atom",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int elipses = 3, int mode = 0)
        {
            auto SpinnerRotatedAtom_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int elipses = 3, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerRotatedAtom(label, radius, thickness, color_or_default, speed, elipses, mode);
            };

            SpinnerRotatedAtom_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, elipses, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("elipses") = 3, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_rainbow_balls",
        SpinnerRainbowBalls, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color"), nb::arg("speed"), nb::arg("balls") = 5, nb::arg("mode") = 0, nb::arg("rings") = 1, nb::arg("mx") = 1);

    m.def("spinner_rainbow_shot",
        SpinnerRainbowShot, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color"), nb::arg("speed"), nb::arg("balls") = 5);

    m.def("spinner_spiral",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4)
        {
            auto SpinnerSpiral_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerSpiral(label, radius, thickness, color_or_default, speed, arcs);
            };

            SpinnerSpiral_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, arcs);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("arcs") = 4,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_spiral_eye",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
        {
            auto SpinnerSpiralEye_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerSpiralEye(label, radius, thickness, color_or_default, speed);
            };

            SpinnerSpiralEye_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_bar_chart_sine",
        SpinnerBarChartSine, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color"), nb::arg("speed"), nb::arg("bars") = 5, nb::arg("mode") = 0);

    m.def("spinner_bar_chart_adv_sine",
        SpinnerBarChartAdvSine, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color"), nb::arg("speed"), nb::arg("mode") = 0);

    m.def("spinner_bar_chart_adv_sine_fade",
        SpinnerBarChartAdvSineFade, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color"), nb::arg("speed"), nb::arg("mode") = 0);

    m.def("spinner_bar_chart_rainbow",
        SpinnerBarChartRainbow, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color"), nb::arg("speed"), nb::arg("bars") = 5, nb::arg("mode") = 0);

    m.def("spinner_blocks",
        SpinnerBlocks, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("bg"), nb::arg("color"), nb::arg("speed"));

    m.def("spinner_twin_blocks",
        SpinnerTwinBlocks, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("bg"), nb::arg("color"), nb::arg("speed"));

    m.def("spinner_square_random_dots",
        SpinnerSquareRandomDots, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("bg"), nb::arg("color"), nb::arg("speed"));

    m.def("spinner_scale_blocks",
        SpinnerScaleBlocks, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color"), nb::arg("speed"), nb::arg("mode") = 0);

    m.def("spinner_scale_squares",
        SpinnerScaleSquares, nb::arg("label"), nb::arg("radius"), nb::arg("thikness"), nb::arg("color"), nb::arg("speed"));

    m.def("spinner_squish_square",
        SpinnerSquishSquare, nb::arg("label"), nb::arg("radius"), nb::arg("color"), nb::arg("speed"));

    m.def("spinner_fluid",
        SpinnerFluid, nb::arg("label"), nb::arg("radius"), nb::arg("color"), nb::arg("speed"), nb::arg("bars") = 3);

    m.def("spinner_fluid_points",
        SpinnerFluidPoints, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color"), nb::arg("speed"), nb::arg("dots") = 6, nb::arg("delta") = 0.35f);

    m.def("spinner_arc_polar_fade",
        [](const char * label, float radius, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4, int mode = 0)
        {
            auto SpinnerArcPolarFade_adapt_mutable_param_with_default_value = [](const char * label, float radius, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerArcPolarFade(label, radius, color_or_default, speed, arcs, mode);
            };

            SpinnerArcPolarFade_adapt_mutable_param_with_default_value(label, radius, color, speed, arcs, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("arcs") = 4, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_arc_polar_radius",
        [](const char * label, float radius, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4, int mode = 0)
        {
            auto SpinnerArcPolarRadius_adapt_mutable_param_with_default_value = [](const char * label, float radius, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerArcPolarRadius(label, radius, color_or_default, speed, arcs, mode);
            };

            SpinnerArcPolarRadius_adapt_mutable_param_with_default_value(label, radius, color, speed, arcs, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("arcs") = 4, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_caleidoscope",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 6, int mode = 0)
        {
            auto SpinnerCaleidoscope_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 6, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerCaleidoscope(label, radius, thickness, color_or_default, speed, arcs, mode);
            };

            SpinnerCaleidoscope_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, arcs, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("arcs") = 6, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_hbo_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float minfade = 0.0f, float ryk = 0.f, float speed = 1.1f, size_t dots = 6, int mode = 0)
        {
            auto SpinnerHboDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float minfade = 0.0f, float ryk = 0.f, float speed = 1.1f, size_t dots = 6, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerHboDots(label, radius, thickness, color_or_default, minfade, ryk, speed, dots, mode);
            };

            SpinnerHboDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, minfade, ryk, speed, dots, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("minfade") = 0.0f, nb::arg("ryk") = 0.f, nb::arg("speed") = 1.1f, nb::arg("dots") = 6, nb::arg("mode") = 0,
        " spinner idea by nitz 'Chris Dailey'\n\n\nPython bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_moon_dots",
        SpinnerMoonDots, nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("first"), nb::arg("second"), nb::arg("speed") = 1.1f);

    m.def("spinner_twin_hbo_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float minfade = 0.0f, float ryk = 0.f, float speed = 1.1f, size_t dots = 6, float delta = 0.f)
        {
            auto SpinnerTwinHboDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float minfade = 0.0f, float ryk = 0.f, float speed = 1.1f, size_t dots = 6, float delta = 0.f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerTwinHboDots(label, radius, thickness, color_or_default, minfade, ryk, speed, dots, delta);
            };

            SpinnerTwinHboDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, minfade, ryk, speed, dots, delta);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("minfade") = 0.0f, nb::arg("ryk") = 0.f, nb::arg("speed") = 1.1f, nb::arg("dots") = 6, nb::arg("delta") = 0.f,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_three_dots_star",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float minfade = 0.0f, float ryk = 0.f, float speed = 1.1f, float delta = 0.f)
        {
            auto SpinnerThreeDotsStar_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float minfade = 0.0f, float ryk = 0.f, float speed = 1.1f, float delta = 0.f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerThreeDotsStar(label, radius, thickness, color_or_default, minfade, ryk, speed, delta);
            };

            SpinnerThreeDotsStar_adapt_mutable_param_with_default_value(label, radius, thickness, color, minfade, ryk, speed, delta);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("minfade") = 0.0f, nb::arg("ryk") = 0.f, nb::arg("speed") = 1.1f, nb::arg("delta") = 0.f,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_sine_arcs",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
        {
            auto SpinnerSineArcs_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerSineArcs(label, radius, thickness, color_or_default, speed);
            };

            SpinnerSineArcs_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_triangles_shift",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, size_t bars = 8)
        {
            auto SpinnerTrianglesShift_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, size_t bars = 8)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return half_white;
                }();

                SpinnerTrianglesShift(label, radius, thickness, color_or_default, bg_or_default, speed, bars);
            };

            SpinnerTrianglesShift_adapt_mutable_param_with_default_value(label, radius, thickness, color, bg, speed, bars);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("bars") = 8,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color: white\n        * bg: half_white");

    m.def("spinner_points_shift",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, size_t bars = 8)
        {
            auto SpinnerPointsShift_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, size_t bars = 8)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return half_white;
                }();

                SpinnerPointsShift(label, radius, thickness, color_or_default, bg_or_default, speed, bars);
            };

            SpinnerPointsShift_adapt_mutable_param_with_default_value(label, radius, thickness, color, bg, speed, bars);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("bars") = 8,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color: white\n        * bg: half_white");

    m.def("spinner_swing_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
        {
            auto SpinnerSwingDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerSwingDots(label, radius, thickness, color_or_default, speed);
            };

            SpinnerSwingDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_circular_points",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 1.8f, int lines = 8)
        {
            auto SpinnerCircularPoints_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 1.8f, int lines = 8)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerCircularPoints(label, radius, thickness, color_or_default, speed, lines);
            };

            SpinnerCircularPoints_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, lines);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 1.8f, nb::arg("lines") = 8,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_curved_circle",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t circles = 1)
        {
            auto SpinnerCurvedCircle_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t circles = 1)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerCurvedCircle(label, radius, thickness, color_or_default, speed, circles);
            };

            SpinnerCurvedCircle_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, circles);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("circles") = 1,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_mod_circle",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float ang_min = 1.f, float ang_max = 1.f, float speed = 2.8f)
        {
            auto SpinnerModCircle_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float ang_min = 1.f, float ang_max = 1.f, float speed = 2.8f)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerModCircle(label, radius, thickness, color_or_default, ang_min, ang_max, speed);
            };

            SpinnerModCircle_adapt_mutable_param_with_default_value(label, radius, thickness, color, ang_min, ang_max, speed);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("ang_min") = 1.f, nb::arg("ang_max") = 1.f, nb::arg("speed") = 2.8f,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_dna_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int lt = 8, float delta = 0.5f, bool mode = 0)
        {
            auto SpinnerDnaDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, int lt = 8, float delta = 0.5f, bool mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerDnaDots(label, radius, thickness, color_or_default, speed, lt, delta, mode);
            };

            SpinnerDnaDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, lt, delta, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("lt") = 8, nb::arg("delta") = 0.5f, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner3_smuggle_dots",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 4.8f, int lt = 8, float delta = 0.5f, bool mode = 0)
        {
            auto Spinner3SmuggleDots_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 4.8f, int lt = 8, float delta = 0.5f, bool mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                Spinner3SmuggleDots(label, radius, thickness, color_or_default, speed, lt, delta, mode);
            };

            Spinner3SmuggleDots_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, lt, delta, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 4.8f, nb::arg("lt") = 8, nb::arg("delta") = 0.5f, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_rotate_segments_pulsar",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4, size_t layers = 1)
        {
            auto SpinnerRotateSegmentsPulsar_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, float speed = 2.8f, size_t arcs = 4, size_t layers = 1)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                SpinnerRotateSegmentsPulsar(label, radius, thickness, color_or_default, speed, arcs, layers);
            };

            SpinnerRotateSegmentsPulsar_adapt_mutable_param_with_default_value(label, radius, thickness, color, speed, arcs, layers);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("arcs") = 4, nb::arg("layers") = 1,
        "Python bindings defaults:\n    If color is None, then its default value will be: white");

    m.def("spinner_spline_ang",
        [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, float angle = IM_PI, int mode = 0)
        {
            auto SpinnerSplineAng_adapt_mutable_param_with_default_value = [](const char * label, float radius, float thickness, const std::optional<const ImColor> & color = std::nullopt, const std::optional<const ImColor> & bg = std::nullopt, float speed = 2.8f, float angle = IM_PI, int mode = 0)
            {

                const ImColor& color_or_default = [&]() -> const ImColor {
                    if (color.has_value())
                        return color.value();
                    else
                        return white;
                }();

                const ImColor& bg_or_default = [&]() -> const ImColor {
                    if (bg.has_value())
                        return bg.value();
                    else
                        return white;
                }();

                SpinnerSplineAng(label, radius, thickness, color_or_default, bg_or_default, speed, angle, mode);
            };

            SpinnerSplineAng_adapt_mutable_param_with_default_value(label, radius, thickness, color, bg, speed, angle, mode);
        },
        nb::arg("label"), nb::arg("radius"), nb::arg("thickness"), nb::arg("color").none() = nb::none(), nb::arg("bg").none() = nb::none(), nb::arg("speed") = 2.8f, nb::arg("angle") = IM_PI, nb::arg("mode") = 0,
        "Python bindings defaults:\n    If any of the params below is None, then its default value below will be used:\n        * color: white\n        * bg: white");
    // #endif
    // #endif
    ////////////////////    </generated_from:imspinner.h>    ////////////////////

    // </litgen_pydef> // Autogenerated code end
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
}
