// Part of ImGui Bundle - MIT License - Copyright (c) 2022-2024 Pascal Thomet - https://github.com/pthom/imgui_bundle
#ifdef IMGUI_BUNDLE_WITH_NANOVG
#include <nanobind/nanobind.h>
#include <nanobind/stl/string.h>
#include <nanobind/stl/array.h>
#include <nanobind/stl/optional.h>
#include <nanobind/stl/tuple.h>
#include <nanobind/stl/vector.h>
#include <nanobind/stl/function.h>
#include <nanobind/ndarray.h>

#include "nanovg.h"
#include "nvg_imgui/nvg_imgui.h"
#include "nvg_imgui/nvg_cpp_text.h"


namespace nb = nanobind;

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// <litgen_glue_code>  // Autogenerated code below! Do not edit!

// </litgen_glue_code> // Autogenerated code end
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


struct NVGcontext {};

void py_init_module_nanovg(nb::module_& m)
{
    using namespace NvgImgui;
    // NVGcontext is an opaque pointer
    // See litgen option:
    //   options.fn_return_force_policy_reference_for_pointers__regex = "CreateNvgContext_HelloImGui"
    nb::class_<NVGcontext>(m, "Context", "Dummy definition (NVGcontext is an opaque pointer)");

    auto pyClassNVGcolor =
        nb::class_<NVGcolor>
            (m, "Color", "")
            .def("__init__", ([](NVGcolor &self, float r = 0.f, float g = 0.f, float b = 0.f, float a = 0.f)
                 {
                     new (&self) NVGcolor();  // placement new
                     self.r = r;
                     self.g = g;
                     self.b = b;
                     self.a = a;

                 }),
                 nb::arg("r") = 0.f, nb::arg("g") = 0.f, nb::arg("b") = 0.f, nb::arg("a") = 0.f
            )

            .def("__init__", ([](NVGcolor &self, std::array<float, 4> color_array)
                 {
                     new (&self) NVGcolor();  // placement new
                     self.r = color_array[0];
                     self.g = color_array[0];
                     self.b = color_array[0];
                     self.a = color_array[0];
                 }),
                 nb::arg("color_array")

            )

            .def_rw("r", &NVGcolor::r, "")
            .def_rw("g", &NVGcolor::g, "")
            .def_rw("b", &NVGcolor::b, "")
            .def_rw("a", &NVGcolor::a, "")

    ;

    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // <litgen_pydef> // Autogenerated code below! Do not edit!
    ////////////////////    <generated_from:nanovg.h>    ////////////////////
    // #ifndef NANOVG_H
    //
    // #ifdef __cplusplus
    //
    // #endif
    //


    auto pyClassNVGpaint =
        nb::class_<NVGpaint>
            (m, "Paint", "")
        .def("__init__", [](NVGpaint * self, float radius = float(), float feather = float(), const std::optional<const NVGcolor> & innerColor = std::nullopt, const std::optional<const NVGcolor> & outerColor = std::nullopt, int image = int())
        {
            new (self) NVGpaint();  // placement new
            auto r_ctor_ = self;
            r_ctor_->radius = radius;
            r_ctor_->feather = feather;
            if (innerColor.has_value())
                r_ctor_->innerColor = innerColor.value();
            else
                r_ctor_->innerColor = NVGcolor();
            if (outerColor.has_value())
                r_ctor_->outerColor = outerColor.value();
            else
                r_ctor_->outerColor = NVGcolor();
            r_ctor_->image = image;
        },
        nb::arg("radius") = float(), nb::arg("feather") = float(), nb::arg("inner_color").none() = nb::none(), nb::arg("outer_color").none() = nb::none(), nb::arg("image") = int()
        )
        .def_prop_ro("xform",
            [](NVGpaint &self) -> nb::ndarray<float, nb::numpy, nb::shape<6>, nb::c_contig>
            {
                return self.xform;
            },
            "")
        .def_prop_ro("extent",
            [](NVGpaint &self) -> nb::ndarray<float, nb::numpy, nb::shape<2>, nb::c_contig>
            {
                return self.extent;
            },
            "")
        .def_rw("radius", &NVGpaint::radius, "")
        .def_rw("feather", &NVGpaint::feather, "")
        .def_rw("inner_color", &NVGpaint::innerColor, "")
        .def_rw("outer_color", &NVGpaint::outerColor, "")
        .def_rw("image", &NVGpaint::image, "")
        ;


    auto pyEnumWinding =
        nb::enum_<NVGwinding>(m, "Winding", nb::is_arithmetic(), "")
            .value("ccw", NVG_CCW, "Winding for solid shapes")
            .value("cw", NVG_CW, "Winding for holes");


    auto pyEnumSolidity =
        nb::enum_<NVGsolidity>(m, "Solidity", nb::is_arithmetic(), "")
            .value("solid", NVG_SOLID, "CCW")
            .value("hole", NVG_HOLE, "CW");


    auto pyEnumLineCap =
        nb::enum_<NVGlineCap>(m, "LineCap", nb::is_arithmetic(), "")
            .value("butt", NVG_BUTT, "")
            .value("round", NVG_ROUND, "")
            .value("square", NVG_SQUARE, "")
            .value("bevel", NVG_BEVEL, "")
            .value("miter", NVG_MITER, "");


    auto pyEnumAlign =
        nb::enum_<NVGalign>(m, "Align", nb::is_arithmetic(), "")
            .value("align_left", NVG_ALIGN_LEFT, "Default, align text horizontally to left.")
            .value("align_center", NVG_ALIGN_CENTER, "Align text horizontally to center.")
            .value("align_right", NVG_ALIGN_RIGHT, "Align text horizontally to right.")
            .value("align_top", NVG_ALIGN_TOP, "Align text vertically to top.")
            .value("align_middle", NVG_ALIGN_MIDDLE, "Align text vertically to middle.")
            .value("align_bottom", NVG_ALIGN_BOTTOM, "Align text vertically to bottom.")
            .value("align_baseline", NVG_ALIGN_BASELINE, "Default, align text vertically to baseline.");


    auto pyEnumBlendFactor =
        nb::enum_<NVGblendFactor>(m, "BlendFactor", nb::is_arithmetic(), "")
            .value("zero", NVG_ZERO, "")
            .value("one", NVG_ONE, "")
            .value("src_color", NVG_SRC_COLOR, "")
            .value("one_minus_src_color", NVG_ONE_MINUS_SRC_COLOR, "")
            .value("dst_color", NVG_DST_COLOR, "")
            .value("one_minus_dst_color", NVG_ONE_MINUS_DST_COLOR, "")
            .value("src_alpha", NVG_SRC_ALPHA, "")
            .value("one_minus_src_alpha", NVG_ONE_MINUS_SRC_ALPHA, "")
            .value("dst_alpha", NVG_DST_ALPHA, "")
            .value("one_minus_dst_alpha", NVG_ONE_MINUS_DST_ALPHA, "")
            .value("src_alpha_saturate", NVG_SRC_ALPHA_SATURATE, "");


    auto pyEnumCompositeOperation =
        nb::enum_<NVGcompositeOperation>(m, "CompositeOperation", nb::is_arithmetic(), "")
            .value("source_over", NVG_SOURCE_OVER, "")
            .value("source_in", NVG_SOURCE_IN, "")
            .value("source_out", NVG_SOURCE_OUT, "")
            .value("atop", NVG_ATOP, "")
            .value("destination_over", NVG_DESTINATION_OVER, "")
            .value("destination_in", NVG_DESTINATION_IN, "")
            .value("destination_out", NVG_DESTINATION_OUT, "")
            .value("destination_atop", NVG_DESTINATION_ATOP, "")
            .value("lighter", NVG_LIGHTER, "")
            .value("copy", NVG_COPY, "")
            .value("xor", NVG_XOR, "");


    auto pyClassNVGcompositeOperationState =
        nb::class_<NVGcompositeOperationState>
            (m, "CompositeOperationState", "")
        .def("__init__", [](NVGcompositeOperationState * self, int srcRGB = int(), int dstRGB = int(), int srcAlpha = int(), int dstAlpha = int())
        {
            new (self) NVGcompositeOperationState();  // placement new
            auto r_ctor_ = self;
            r_ctor_->srcRGB = srcRGB;
            r_ctor_->dstRGB = dstRGB;
            r_ctor_->srcAlpha = srcAlpha;
            r_ctor_->dstAlpha = dstAlpha;
        },
        nb::arg("src_rgb") = int(), nb::arg("dst_rgb") = int(), nb::arg("src_alpha") = int(), nb::arg("dst_alpha") = int()
        )
        .def_rw("src_rgb", &NVGcompositeOperationState::srcRGB, "")
        .def_rw("dst_rgb", &NVGcompositeOperationState::dstRGB, "")
        .def_rw("src_alpha", &NVGcompositeOperationState::srcAlpha, "")
        .def_rw("dst_alpha", &NVGcompositeOperationState::dstAlpha, "")
        ;


    auto pyClassNVGglyphPosition =
        nb::class_<NVGglyphPosition>
            (m, "GlyphPosition", "")
        .def("__init__", [](NVGglyphPosition * self, float x = float(), float minx = float(), float maxx = float())
        {
            new (self) NVGglyphPosition();  // placement new
            auto r_ctor_ = self;
            r_ctor_->x = x;
            r_ctor_->minx = minx;
            r_ctor_->maxx = maxx;
        },
        nb::arg("x") = float(), nb::arg("minx") = float(), nb::arg("maxx") = float()
        )
        .def_ro("str", &NVGglyphPosition::str, "Position of the glyph in the input string.")
        .def_rw("x", &NVGglyphPosition::x, "The x-coordinate of the logical glyph position.")
        .def_rw("minx", &NVGglyphPosition::minx, "The bounds of the glyph shape.")
        .def_rw("maxx", &NVGglyphPosition::maxx, "The bounds of the glyph shape.")
        ;


    auto pyClassNVGtextRow =
        nb::class_<NVGtextRow>
            (m, "TextRow", "")
        .def("__init__", [](NVGtextRow * self, float width = float(), float minx = float(), float maxx = float())
        {
            new (self) NVGtextRow();  // placement new
            auto r_ctor_ = self;
            r_ctor_->width = width;
            r_ctor_->minx = minx;
            r_ctor_->maxx = maxx;
        },
        nb::arg("width") = float(), nb::arg("minx") = float(), nb::arg("maxx") = float()
        )
        .def_ro("start", &NVGtextRow::start, "Pointer to the input text where the row starts.")
        .def_ro("end", &NVGtextRow::end, "Pointer to the input text where the row ends (one past the last character).")
        .def_ro("next", &NVGtextRow::next, "Pointer to the beginning of the next row.")
        .def_rw("width", &NVGtextRow::width, "Logical width of the row.")
        .def_rw("minx", &NVGtextRow::minx, "Actual bounds of the row. Logical with and bounds can differ because of kerning and some parts over extending.")
        .def_rw("maxx", &NVGtextRow::maxx, "Actual bounds of the row. Logical with and bounds can differ because of kerning and some parts over extending.")
        ;


    auto pyEnumImageFlags =
        nb::enum_<NVGimageFlags>(m, "ImageFlags", nb::is_arithmetic(), "")
            .value("image_generate_mipmaps", NVG_IMAGE_GENERATE_MIPMAPS, "Generate mipmaps during creation of the image.")
            .value("image_repeatx", NVG_IMAGE_REPEATX, "Repeat image in X direction.")
            .value("image_repeaty", NVG_IMAGE_REPEATY, "Repeat image in Y direction.")
            .value("image_flipy", NVG_IMAGE_FLIPY, "Flips (inverses) image in Y direction when rendered.")
            .value("image_premultiplied", NVG_IMAGE_PREMULTIPLIED, "Image data has premultiplied alpha.")
            .value("image_nearest", NVG_IMAGE_NEAREST, "Image interpolation is Nearest instead Linear");


    m.def("begin_frame",
        nvgBeginFrame,
        nb::arg("ctx"), nb::arg("window_width"), nb::arg("window_height"), nb::arg("device_pixel_ratio"),
        " Begin drawing a new frame\n Calls to nanovg drawing API should be wrapped in nvgBeginFrame() & nvgEndFrame()\n nvgBeginFrame() defines the size of the window to render to in relation currently\n set viewport (i.e. glViewport on GL backends). Device pixel ration allows to\n control the rendering on Hi-DPI devices.\n For example, GLFW returns two dimension for an opened window: window size and\n frame buffer size. In that case you would set windowWidth/Height to the window size\n devicePixelRatio to: frameBufferWidth / windowWidth.");

    m.def("cancel_frame",
        nvgCancelFrame,
        nb::arg("ctx"),
        "Cancels drawing the current frame.");

    m.def("end_frame",
        nvgEndFrame,
        nb::arg("ctx"),
        "Ends drawing flushing remaining render state.");

    m.def("global_composite_operation",
        nvgGlobalCompositeOperation,
        nb::arg("ctx"), nb::arg("op"),
        "Sets the composite operation. The op parameter should be one of NVGcompositeOperation.");

    m.def("global_composite_blend_func",
        nvgGlobalCompositeBlendFunc,
        nb::arg("ctx"), nb::arg("sfactor"), nb::arg("dfactor"),
        "Sets the composite operation with custom pixel arithmetic. The parameters should be one of NVGblendFactor.");

    m.def("global_composite_blend_func_separate",
        nvgGlobalCompositeBlendFuncSeparate,
        nb::arg("ctx"), nb::arg("src_rgb"), nb::arg("dst_rgb"), nb::arg("src_alpha"), nb::arg("dst_alpha"),
        "Sets the composite operation with custom pixel arithmetic for RGB and alpha components separately. The parameters should be one of NVGblendFactor.");

    m.def("rgb",
        nvgRGB,
        nb::arg("r"), nb::arg("g"), nb::arg("b"),
        "Returns a color value from red, green, blue values. Alpha will be set to 255 (1.0).");

    m.def("rgb_f",
        nvgRGBf,
        nb::arg("r"), nb::arg("g"), nb::arg("b"),
        "Returns a color value from red, green, blue values. Alpha will be set to 1.0.");

    m.def("rgba",
        nvgRGBA,
        nb::arg("r"), nb::arg("g"), nb::arg("b"), nb::arg("a"),
        "Returns a color value from red, green, blue and alpha values.");

    m.def("rgba_f",
        nvgRGBAf,
        nb::arg("r"), nb::arg("g"), nb::arg("b"), nb::arg("a"),
        "Returns a color value from red, green, blue and alpha values.");

    m.def("lerp_rgba",
        nvgLerpRGBA,
        nb::arg("c0"), nb::arg("c1"), nb::arg("u"),
        "Linearly interpolates from color c0 to c1, and returns resulting color value.");

    m.def("trans_rgba",
        nvgTransRGBA,
        nb::arg("c0"), nb::arg("a"),
        "Sets transparency of a color value.");

    m.def("trans_rgb_af",
        nvgTransRGBAf,
        nb::arg("c0"), nb::arg("a"),
        "Sets transparency of a color value.");

    m.def("hsl",
        nvgHSL,
        nb::arg("h"), nb::arg("s"), nb::arg("l"),
        " Returns color value specified by hue, saturation and lightness.\n HSL values are all in range [0..1], alpha will be set to 255.");

    m.def("hsla",
        nvgHSLA,
        nb::arg("h"), nb::arg("s"), nb::arg("l"), nb::arg("a"),
        " Returns color value specified by hue, saturation and lightness and alpha.\n HSL values are all in range [0..1], alpha in range [0..255]");

    m.def("save",
        nvgSave,
        nb::arg("ctx"),
        " Pushes and saves the current render state into a state stack.\n A matching nvgRestore() must be used to restore the state.");

    m.def("restore",
        nvgRestore,
        nb::arg("ctx"),
        "Pops and restores current render state.");

    m.def("reset",
        nvgReset,
        nb::arg("ctx"),
        "Resets current render state to default values. Does not affect the render state stack.");

    m.def("shape_anti_alias",
        nvgShapeAntiAlias,
        nb::arg("ctx"), nb::arg("enabled"),
        "Sets whether to draw antialias for nvgStroke() and nvgFill(). It's enabled by default.");

    m.def("stroke_color",
        nvgStrokeColor,
        nb::arg("ctx"), nb::arg("color"),
        "Sets current stroke style to a solid color.");

    m.def("stroke_paint",
        nvgStrokePaint,
        nb::arg("ctx"), nb::arg("paint"),
        "Sets current stroke style to a paint, which can be a one of the gradients or a pattern.");

    m.def("fill_color",
        nvgFillColor,
        nb::arg("ctx"), nb::arg("color"),
        "Sets current fill style to a solid color.");

    m.def("fill_paint",
        nvgFillPaint,
        nb::arg("ctx"), nb::arg("paint"),
        "Sets current fill style to a paint, which can be a one of the gradients or a pattern.");

    m.def("miter_limit",
        nvgMiterLimit,
        nb::arg("ctx"), nb::arg("limit"),
        " Sets the miter limit of the stroke style.\n Miter limit controls when a sharp corner is beveled.");

    m.def("stroke_width",
        nvgStrokeWidth,
        nb::arg("ctx"), nb::arg("size"),
        "Sets the stroke width of the stroke style.");

    m.def("line_cap",
        nvgLineCap,
        nb::arg("ctx"), nb::arg("cap"),
        " Sets how the end of the line (cap) is drawn,\n Can be one of: NVG_BUTT (default), NVG_ROUND, NVG_SQUARE.");

    m.def("line_join",
        nvgLineJoin,
        nb::arg("ctx"), nb::arg("join"),
        " Sets how sharp path corners are drawn.\n Can be one of NVG_MITER (default), NVG_ROUND, NVG_BEVEL.");

    m.def("global_alpha",
        nvgGlobalAlpha,
        nb::arg("ctx"), nb::arg("alpha"),
        " Sets the transparency applied to all rendered shapes.\n Already transparent paths will get proportionally more transparent as well.");

    m.def("reset_transform",
        nvgResetTransform,
        nb::arg("ctx"),
        "Resets current transform to a identity matrix.");

    m.def("transform",
        nvgTransform,
        nb::arg("ctx"), nb::arg("a"), nb::arg("b"), nb::arg("c"), nb::arg("d"), nb::arg("e"), nb::arg("f"),
        " Premultiplies current coordinate system by specified matrix.\n The parameters are interpreted as matrix as follows:\n   [a c e]\n   [b d f]\n   [0 0 1]");

    m.def("translate",
        nvgTranslate,
        nb::arg("ctx"), nb::arg("x"), nb::arg("y"),
        "Translates current coordinate system.");

    m.def("rotate",
        nvgRotate,
        nb::arg("ctx"), nb::arg("angle"),
        "Rotates current coordinate system. Angle is specified in radians.");

    m.def("skew_x",
        nvgSkewX,
        nb::arg("ctx"), nb::arg("angle"),
        "Skews the current coordinate system along X axis. Angle is specified in radians.");

    m.def("skew_y",
        nvgSkewY,
        nb::arg("ctx"), nb::arg("angle"),
        "Skews the current coordinate system along Y axis. Angle is specified in radians.");

    m.def("scale",
        nvgScale,
        nb::arg("ctx"), nb::arg("x"), nb::arg("y"),
        "Scales the current coordinate system.");

    m.def("current_transform",
        nvgCurrentTransform,
        nb::arg("ctx"), nb::arg("xform"),
        " Stores the top part (a-f) of the current transformation matrix in to the specified buffer.\n   [a c e]\n   [b d f]\n   [0 0 1]\n There should be space for 6 floats in the return buffer for the values a-f.");

    m.def("transform_identity",
        nvgTransformIdentity,
        nb::arg("dst"),
        "Sets the transform to identity matrix.");

    m.def("transform_translate",
        nvgTransformTranslate,
        nb::arg("dst"), nb::arg("tx"), nb::arg("ty"),
        "Sets the transform to translation matrix matrix.");

    m.def("transform_scale",
        nvgTransformScale,
        nb::arg("dst"), nb::arg("sx"), nb::arg("sy"),
        "Sets the transform to scale matrix.");

    m.def("transform_rotate",
        nvgTransformRotate,
        nb::arg("dst"), nb::arg("a"),
        "Sets the transform to rotate matrix. Angle is specified in radians.");

    m.def("transform_skew_x",
        nvgTransformSkewX,
        nb::arg("dst"), nb::arg("a"),
        "Sets the transform to skew-x matrix. Angle is specified in radians.");

    m.def("transform_skew_y",
        nvgTransformSkewY,
        nb::arg("dst"), nb::arg("a"),
        "Sets the transform to skew-y matrix. Angle is specified in radians.");

    m.def("transform_multiply",
        nvgTransformMultiply,
        nb::arg("dst"), nb::arg("src"),
        "Sets the transform to the result of multiplication of two transforms, of A = A*B.");

    m.def("transform_premultiply",
        nvgTransformPremultiply,
        nb::arg("dst"), nb::arg("src"),
        "Sets the transform to the result of multiplication of two transforms, of A = B*A.");

    m.def("transform_inverse",
        nvgTransformInverse,
        nb::arg("dst"), nb::arg("src"),
        " Sets the destination to inverse of specified transform.\n Returns 1 if the inverse could be calculated, else 0.");

    m.def("transform_point",
        nvgTransformPoint,
        nb::arg("dstx"), nb::arg("dsty"), nb::arg("xform"), nb::arg("srcx"), nb::arg("srcy"),
        "Transform a point by given transform.");

    m.def("deg_to_rad",
        nvgDegToRad, nb::arg("deg"));

    m.def("rad_to_deg",
        nvgRadToDeg, nb::arg("rad"));

    m.def("create_image",
        nvgCreateImage,
        nb::arg("ctx"), nb::arg("filename"), nb::arg("image_flags"),
        " Creates image by loading it from the disk from specified file name.\n Returns handle to the image.");

    m.def("create_image_mem",
        nvgCreateImageMem,
        nb::arg("ctx"), nb::arg("image_flags"), nb::arg("data"), nb::arg("ndata"),
        " Creates image by loading it from the specified chunk of memory.\n Returns handle to the image.");

    m.def("create_image_rgba",
        nvgCreateImageRGBA,
        nb::arg("ctx"), nb::arg("w"), nb::arg("h"), nb::arg("image_flags"), nb::arg("data"),
        " Creates image from specified image data.\n Returns handle to the image.");

    m.def("update_image",
        nvgUpdateImage,
        nb::arg("ctx"), nb::arg("image"), nb::arg("data"),
        "Updates image data specified by image handle.");

    m.def("delete_image",
        nvgDeleteImage,
        nb::arg("ctx"), nb::arg("image"),
        "Deletes created image.");

    m.def("linear_gradient",
        nvgLinearGradient,
        nb::arg("ctx"), nb::arg("sx"), nb::arg("sy"), nb::arg("ex"), nb::arg("ey"), nb::arg("icol"), nb::arg("ocol"),
        " Creates and returns a linear gradient. Parameters (sx,sy)-(ex,ey) specify the start and end coordinates\n of the linear gradient, icol specifies the start color and ocol the end color.\n The gradient is transformed by the current transform when it is passed to nvgFillPaint() or nvgStrokePaint().");

    m.def("box_gradient",
        nvgBoxGradient,
        nb::arg("ctx"), nb::arg("x"), nb::arg("y"), nb::arg("w"), nb::arg("h"), nb::arg("r"), nb::arg("f"), nb::arg("icol"), nb::arg("ocol"),
        " Creates and returns a box gradient. Box gradient is a feathered rounded rectangle, it is useful for rendering\n drop shadows or highlights for boxes. Parameters (x,y) define the top-left corner of the rectangle,\n (w,h) define the size of the rectangle, r defines the corner radius, and f feather. Feather defines how blurry\n the border of the rectangle is. Parameter icol specifies the inner color and ocol the outer color of the gradient.\n The gradient is transformed by the current transform when it is passed to nvgFillPaint() or nvgStrokePaint().");

    m.def("radial_gradient",
        nvgRadialGradient,
        nb::arg("ctx"), nb::arg("cx"), nb::arg("cy"), nb::arg("inr"), nb::arg("outr"), nb::arg("icol"), nb::arg("ocol"),
        " Creates and returns a radial gradient. Parameters (cx,cy) specify the center, inr and outr specify\n the inner and outer radius of the gradient, icol specifies the start color and ocol the end color.\n The gradient is transformed by the current transform when it is passed to nvgFillPaint() or nvgStrokePaint().");

    m.def("image_pattern",
        nvgImagePattern,
        nb::arg("ctx"), nb::arg("ox"), nb::arg("oy"), nb::arg("ex"), nb::arg("ey"), nb::arg("angle"), nb::arg("image"), nb::arg("alpha"),
        " Creates and returns an image pattern. Parameters (ox,oy) specify the left-top location of the image pattern,\n (ex,ey) the size of one image, angle rotation around the top-left corner, image is handle to the image to render.\n The gradient is transformed by the current transform when it is passed to nvgFillPaint() or nvgStrokePaint().");

    m.def("scissor",
        nvgScissor,
        nb::arg("ctx"), nb::arg("x"), nb::arg("y"), nb::arg("w"), nb::arg("h"),
        " Sets the current scissor rectangle.\n The scissor rectangle is transformed by the current transform.");

    m.def("intersect_scissor",
        nvgIntersectScissor,
        nb::arg("ctx"), nb::arg("x"), nb::arg("y"), nb::arg("w"), nb::arg("h"),
        " Intersects current scissor rectangle with the specified rectangle.\n The scissor rectangle is transformed by the current transform.\n Note: in case the rotation of previous scissor rect differs from\n the current one, the intersection will be done between the specified\n rectangle and the previous scissor rectangle transformed in the current\n transform space. The resulting shape is always rectangle.");

    m.def("reset_scissor",
        nvgResetScissor,
        nb::arg("ctx"),
        "Reset and disables scissoring.");

    m.def("begin_path",
        nvgBeginPath,
        nb::arg("ctx"),
        "Clears the current path and sub-paths.");

    m.def("move_to",
        nvgMoveTo,
        nb::arg("ctx"), nb::arg("x"), nb::arg("y"),
        "Starts new sub-path with specified point as first point.");

    m.def("line_to",
        nvgLineTo,
        nb::arg("ctx"), nb::arg("x"), nb::arg("y"),
        "Adds line segment from the last point in the path to the specified point.");

    m.def("bezier_to",
        nvgBezierTo,
        nb::arg("ctx"), nb::arg("c1x"), nb::arg("c1y"), nb::arg("c2x"), nb::arg("c2y"), nb::arg("x"), nb::arg("y"),
        "Adds cubic bezier segment from last point in the path via two control points to the specified point.");

    m.def("quad_to",
        nvgQuadTo,
        nb::arg("ctx"), nb::arg("cx"), nb::arg("cy"), nb::arg("x"), nb::arg("y"),
        "Adds quadratic bezier segment from last point in the path via a control point to the specified point.");

    m.def("arc_to",
        nvgArcTo,
        nb::arg("ctx"), nb::arg("x1"), nb::arg("y1"), nb::arg("x2"), nb::arg("y2"), nb::arg("radius"),
        "Adds an arc segment at the corner defined by the last path point, and two specified points.");

    m.def("close_path",
        nvgClosePath,
        nb::arg("ctx"),
        "Closes current sub-path with a line segment.");

    m.def("path_winding",
        nvgPathWinding,
        nb::arg("ctx"), nb::arg("dir"),
        "Sets the current sub-path winding, see NVGwinding and NVGsolidity.");

    m.def("arc",
        nvgArc,
        nb::arg("ctx"), nb::arg("cx"), nb::arg("cy"), nb::arg("r"), nb::arg("a0"), nb::arg("a1"), nb::arg("dir"),
        " Creates new circle arc shaped sub-path. The arc center is at cx,cy, the arc radius is r,\n and the arc is drawn from angle a0 to a1, and swept in direction dir (NVG_CCW, or NVG_CW).\n Angles are specified in radians.");

    m.def("rect",
        nvgRect,
        nb::arg("ctx"), nb::arg("x"), nb::arg("y"), nb::arg("w"), nb::arg("h"),
        "Creates new rectangle shaped sub-path.");

    m.def("rounded_rect",
        nvgRoundedRect,
        nb::arg("ctx"), nb::arg("x"), nb::arg("y"), nb::arg("w"), nb::arg("h"), nb::arg("r"),
        "Creates new rounded rectangle shaped sub-path.");

    m.def("rounded_rect_varying",
        nvgRoundedRectVarying,
        nb::arg("ctx"), nb::arg("x"), nb::arg("y"), nb::arg("w"), nb::arg("h"), nb::arg("rad_top_left"), nb::arg("rad_top_right"), nb::arg("rad_bottom_right"), nb::arg("rad_bottom_left"),
        "Creates new rounded rectangle shaped sub-path with varying radii for each corner.");

    m.def("ellipse",
        nvgEllipse,
        nb::arg("ctx"), nb::arg("cx"), nb::arg("cy"), nb::arg("rx"), nb::arg("ry"),
        "Creates new ellipse shaped sub-path.");

    m.def("circle",
        nvgCircle,
        nb::arg("ctx"), nb::arg("cx"), nb::arg("cy"), nb::arg("r"),
        "Creates new circle shaped sub-path.");

    m.def("fill",
        nvgFill,
        nb::arg("ctx"),
        "Fills the current path with current fill style.");

    m.def("stroke",
        nvgStroke,
        nb::arg("ctx"),
        "Fills the current path with current stroke style.");

    m.def("create_font",
        nvgCreateFont,
        nb::arg("ctx"), nb::arg("name"), nb::arg("filename"),
        " Creates font by loading it from the disk from specified file name.\n Returns handle to the font.");

    m.def("create_font_at_index",
        nvgCreateFontAtIndex,
        nb::arg("ctx"), nb::arg("name"), nb::arg("filename"), nb::arg("font_index"),
        "fontIndex specifies which font face to load from a .ttf/.ttc file.");

    m.def("create_font_mem",
        nvgCreateFontMem,
        nb::arg("ctx"), nb::arg("name"), nb::arg("data"), nb::arg("ndata"), nb::arg("free_data"),
        " Creates font by loading it from the specified memory chunk.\n Returns handle to the font.");

    m.def("create_font_mem_at_index",
        nvgCreateFontMemAtIndex,
        nb::arg("ctx"), nb::arg("name"), nb::arg("data"), nb::arg("ndata"), nb::arg("free_data"), nb::arg("font_index"),
        "fontIndex specifies which font face to load from a .ttf/.ttc file.");

    m.def("find_font",
        nvgFindFont,
        nb::arg("ctx"), nb::arg("name"),
        "Finds a loaded font of specified name, and returns handle to it, or -1 if the font is not found.");

    m.def("add_fallback_font_id",
        nvgAddFallbackFontId,
        nb::arg("ctx"), nb::arg("base_font"), nb::arg("fallback_font"),
        "Adds a fallback font by handle.");

    m.def("add_fallback_font",
        nvgAddFallbackFont,
        nb::arg("ctx"), nb::arg("base_font"), nb::arg("fallback_font"),
        "Adds a fallback font by name.");

    m.def("reset_fallback_fonts_id",
        nvgResetFallbackFontsId,
        nb::arg("ctx"), nb::arg("base_font"),
        "Resets fallback fonts by handle.");

    m.def("reset_fallback_fonts",
        nvgResetFallbackFonts,
        nb::arg("ctx"), nb::arg("base_font"),
        "Resets fallback fonts by name.");

    m.def("font_size",
        nvgFontSize,
        nb::arg("ctx"), nb::arg("size"),
        "Sets the font size of current text style.");

    m.def("font_blur",
        nvgFontBlur,
        nb::arg("ctx"), nb::arg("blur"),
        "Sets the blur of current text style.");

    m.def("font_face_id",
        nvgFontFaceId,
        nb::arg("ctx"), nb::arg("font"),
        "Sets the font face based on specified id of current text style.");

    m.def("font_face",
        nvgFontFace,
        nb::arg("ctx"), nb::arg("font"),
        "Sets the font face based on specified name of current text style.");


    auto pyEnumTexture =
        nb::enum_<NVGtexture>(m, "Texture", nb::is_arithmetic(), "\n Internal Render API\n")
            .value("texture_alpha", NVG_TEXTURE_ALPHA, "")
            .value("texture_rgba", NVG_TEXTURE_RGBA, "");


    auto pyClassNVGscissor =
        nb::class_<NVGscissor>
            (m, "Scissor", "")
        .def(nb::init<>()) // implicit default constructor
        .def_prop_ro("xform",
            [](NVGscissor &self) -> nb::ndarray<float, nb::numpy, nb::shape<6>, nb::c_contig>
            {
                return self.xform;
            },
            "")
        .def_prop_ro("extent",
            [](NVGscissor &self) -> nb::ndarray<float, nb::numpy, nb::shape<2>, nb::c_contig>
            {
                return self.extent;
            },
            "")
        ;


    auto pyClassNVGvertex =
        nb::class_<NVGvertex>
            (m, "Vertex", "")
        .def("__init__", [](NVGvertex * self, float x = float(), float y = float(), float u = float(), float v = float())
        {
            new (self) NVGvertex();  // placement new
            auto r_ctor_ = self;
            r_ctor_->x = x;
            r_ctor_->y = y;
            r_ctor_->u = u;
            r_ctor_->v = v;
        },
        nb::arg("x") = float(), nb::arg("y") = float(), nb::arg("u") = float(), nb::arg("v") = float()
        )
        .def_rw("x", &NVGvertex::x, "")
        .def_rw("y", &NVGvertex::y, "")
        .def_rw("u", &NVGvertex::u, "")
        .def_rw("v", &NVGvertex::v, "")
        ;


    auto pyClassNVGpath =
        nb::class_<NVGpath>
            (m, "Path", "")
        .def("__init__", [](NVGpath * self, int first = int(), int count = int(), int nbevel = int(), int nfill = int(), int nstroke = int(), int winding = int(), int convex = int())
        {
            new (self) NVGpath();  // placement new
            auto r_ctor_ = self;
            r_ctor_->first = first;
            r_ctor_->count = count;
            r_ctor_->nbevel = nbevel;
            r_ctor_->nfill = nfill;
            r_ctor_->nstroke = nstroke;
            r_ctor_->winding = winding;
            r_ctor_->convex = convex;
        },
        nb::arg("first") = int(), nb::arg("count") = int(), nb::arg("nbevel") = int(), nb::arg("nfill") = int(), nb::arg("nstroke") = int(), nb::arg("winding") = int(), nb::arg("convex") = int()
        )
        .def_rw("first", &NVGpath::first, "")
        .def_rw("count", &NVGpath::count, "")
        .def_rw("closed", &NVGpath::closed, "")
        .def_rw("nbevel", &NVGpath::nbevel, "")
        .def_rw("fill", &NVGpath::fill, "")
        .def_rw("nfill", &NVGpath::nfill, "")
        .def_rw("stroke", &NVGpath::stroke, "")
        .def_rw("nstroke", &NVGpath::nstroke, "")
        .def_rw("winding", &NVGpath::winding, "")
        .def_rw("convex", &NVGpath::convex, "")
        ;


    auto pyClassNVGparams =
        nb::class_<NVGparams>
            (m, "Params", "")
        .def("__init__", [](NVGparams * self, int edgeAntiAlias = int())
        {
            new (self) NVGparams();  // placement new
            auto r_ctor_ = self;
            r_ctor_->edgeAntiAlias = edgeAntiAlias;
        },
        nb::arg("edge_anti_alias") = int()
        )
        .def_rw("user_ptr", &NVGparams::userPtr, "")
        .def_rw("edge_anti_alias", &NVGparams::edgeAntiAlias, "")
        ;


    m.def("create_internal",
        nvgCreateInternal, nb::arg("params"));

    m.def("delete_internal",
        nvgDeleteInternal, nb::arg("ctx"));

    m.def("internal_params",
        nvgInternalParams, nb::arg("ctx"));

    m.def("debug_dump_path_cache",
        nvgDebugDumpPathCache,
        nb::arg("ctx"),
        "Debug function to dump cached path data.");
    // #ifdef __cplusplus
    //
    // #endif
    //
    // #endif
    ////////////////////    </generated_from:nanovg.h>    ////////////////////


    ////////////////////    <generated_from:nvg_imgui.h>    ////////////////////
    // #ifdef IMGUI_BUNDLE_WITH_NANOVG
    //
    // #endif

    { // <namespace NvgImgui>
        nb::module_ pyNsNvgImgui = m.def_submodule("nvg_imgui", "");
        auto pyEnumNvgCreateFlags =
            nb::enum_<NvgImgui::NvgCreateFlags>(pyNsNvgImgui, "NvgCreateFlags", nb::is_arithmetic(), "Combination of NVGcreateFlags in nanovg_gl.h + nanovg_mtl.h")
                .value("antialias", NvgImgui::NVG_ANTIALIAS, "Flag indicating if geometry based antialiasing is used (may not be needed when using MSAA).")
                .value("stencil_strokes", NvgImgui::NVG_STENCIL_STROKES, " Flag indicating if strokes should be drawn using stencil buffer. The rendering will be a little\n slower, but path overlaps (i.e. self-intersecting or sharp turns) will be drawn just once.")
                .value("debug", NvgImgui::NVG_DEBUG, "Flag indicating that additional debug checks are done.")
                .value("double_buffer", NvgImgui::NVG_DOUBLE_BUFFER, "Flag indicating if double buffering scheme is used (Metal only!)")
                .value("triple_buffer", NvgImgui::NVG_TRIPLE_BUFFER, "Flag indicating if triple buffering scheme is used (Metal only!)");


        pyNsNvgImgui.def("create_nvg_context_hello_imgui",
            NvgImgui::CreateNvgContext_HelloImGui,
            nb::arg("flags") = 0,
            nb::rv_policy::reference);

        pyNsNvgImgui.def("delete_nvg_context_hello_imgui",
            NvgImgui::DeleteNvgContext_HelloImGui, nb::arg("vg"));


        auto pyNsNvgImgui_ClassNvgFramebuffer =
            nb::class_<NvgImgui::NvgFramebuffer>
                (pyNsNvgImgui, "NvgFramebuffer", " NvgFramebuffer: a framebuffer that can be used by NanoVG + ImGui\n Internally stored inside the renderer backend (e.g. OpenGL)\n Note: this class can be instantiated only after a valid renderer backend (OpenGL) has been created")
            .def_rw("vg", &NvgImgui::NvgFramebuffer::vg, "")
            .def_rw("width", &NvgImgui::NvgFramebuffer::Width, "")
            .def_rw("height", &NvgImgui::NvgFramebuffer::Height, "")
            .def_rw("nvg_image_flags", &NvgImgui::NvgFramebuffer::NvgImageFlags, "")
            .def_rw("texture_id", &NvgImgui::NvgFramebuffer::TextureId, "")
            .def(nb::init<NVGcontext *, int, int, int>(),
                nb::arg("vg"), nb::arg("width"), nb::arg("height"), nb::arg("nvg_image_flags"),
                "See NVGimageFlags")
            .def("bind",
                &NvgImgui::NvgFramebuffer::Bind, "Make the framebuffer the current render target")
            .def("unbind",
                &NvgImgui::NvgFramebuffer::Unbind, "Restore the previous render target")
            ;


        pyNsNvgImgui.def("render_nvg_to_background",
            [](NVGcontext * vg, NvgDrawingFunction nvgDrawingFunction, const std::optional<const ImVec4> & clearColor = std::nullopt)
            {
                auto RenderNvgToBackground_adapt_mutable_param_with_default_value = [](NVGcontext * vg, NvgDrawingFunction nvgDrawingFunction, const std::optional<const ImVec4> & clearColor = std::nullopt)
                {

                    const ImVec4& clearColor_or_default = [&]() -> const ImVec4 {
                        if (clearColor.has_value())
                            return clearColor.value();
                        else
                            return ImVec4(0.f, 0.f, 0.f, 1.f);
                    }();

                    NvgImgui::RenderNvgToBackground(vg, nvgDrawingFunction, clearColor_or_default);
                };

                RenderNvgToBackground_adapt_mutable_param_with_default_value(vg, nvgDrawingFunction, clearColor);
            },
            nb::arg("vg"), nb::arg("nvg_drawing_function"), nb::arg("clear_color").none() = nb::none(),
            " Render the given drawing function to the background of the application\n (i.e. the main viewport)\n If clearColor.w > 0., the background will be cleared with this color\n\n\nPython bindings defaults:\n    If clearColor is None, then its default value will be: ImVec4(0., 0., 0., 1.)");

        pyNsNvgImgui.def("render_nvg_to_frame_buffer",
            [](NVGcontext * vg, NvgImgui::NvgFramebuffer & texture, NvgDrawingFunction drawFunc, const std::optional<const ImVec4> & clearColor = std::nullopt)
            {
                auto RenderNvgToFrameBuffer_adapt_mutable_param_with_default_value = [](NVGcontext * vg, NvgImgui::NvgFramebuffer & texture, NvgDrawingFunction drawFunc, const std::optional<const ImVec4> & clearColor = std::nullopt)
                {

                    const ImVec4& clearColor_or_default = [&]() -> const ImVec4 {
                        if (clearColor.has_value())
                            return clearColor.value();
                        else
                            return ImVec4(0.f, 0.f, 0.f, 1.f);
                    }();

                    NvgImgui::RenderNvgToFrameBuffer(vg, texture, drawFunc, clearColor_or_default);
                };

                RenderNvgToFrameBuffer_adapt_mutable_param_with_default_value(vg, texture, drawFunc, clearColor);
            },
            nb::arg("vg"), nb::arg("texture"), nb::arg("draw_func"), nb::arg("clear_color").none() = nb::none(),
            " Render the given drawing function to the given framebuffer\n If clearColor.w > 0., the background will be cleared with this color\n\n\nPython bindings defaults:\n    If clearColor is None, then its default value will be: ImVec4(0., 0., 0., 1.)");
    } // </namespace NvgImgui>
    ////////////////////    </generated_from:nvg_imgui.h>    ////////////////////


    ////////////////////    <generated_from:nvg_cpp_text.h>    ////////////////////
    m.def("text",
        nvgcpp_Text,
        nb::arg("ctx"), nb::arg("x"), nb::arg("y"), nb::arg("text"),
        "Draws text string at specified location. If end is specified only the sub-string up to the end is drawn.");

    m.def("text_box",
        nvgcpp_TextBox,
        nb::arg("ctx"), nb::arg("x"), nb::arg("y"), nb::arg("break_row_width"), nb::arg("text"),
        " Draws multi-line text string at specified location wrapped at the specified width. If end is specified only the sub-string up to the end is drawn.\n White space is stripped at the beginning of the rows, the text is split at word boundaries or when new-line characters are encountered.\n Words longer than the max width are split at nearest character (i.e. no hyphenation).");

    m.def("text_bounds",
        nvgcpp_TextBounds,
        nb::arg("ctx"), nb::arg("x"), nb::arg("y"), nb::arg("text"),
        " Measures the specified text string. Parameter bounds should be a pointer to float[4],\n if the bounding box of the text should be returned. The bounds value are [xmin,ymin, xmax,ymax]\n Returns the bounds + the horizontal advance of the measured text (i.e. where the next character should drawn)\n Measured values are returned in local coordinate space.");

    m.def("text_box_bounds",
        nvgcpp_TextBoxBounds,
        nb::arg("ctx"), nb::arg("x"), nb::arg("y"), nb::arg("break_row_width"), nb::arg("text"),
        " Measures the specified multi-text string. Parameter bounds should be a pointer to float[4],\n if the bounding box of the text should be returned. The bounds value are [xmin,ymin, xmax,ymax]\n Measured values are returned in local coordinate space.");

    m.def("text_glyph_positions",
        nvgcpp_TextGlyphPositions,
        nb::arg("ctx"), nb::arg("x"), nb::arg("y"), nb::arg("text"),
        " Calculates the glyph x positions of the specified text. If end is specified only the sub-string will be used.\n Measured values are returned in local coordinate space.");


    auto pyClassTextMetricsData =
        nb::class_<TextMetricsData>
            (m, "TextMetricsData", "")
        .def("__init__", [](TextMetricsData * self, float ascender = float(), float descender = float(), float lineh = float())
        {
            new (self) TextMetricsData();  // placement new
            auto r_ctor_ = self;
            r_ctor_->ascender = ascender;
            r_ctor_->descender = descender;
            r_ctor_->lineh = lineh;
        },
        nb::arg("ascender") = float(), nb::arg("descender") = float(), nb::arg("lineh") = float()
        )
        .def_rw("ascender", &TextMetricsData::ascender, "")
        .def_rw("descender", &TextMetricsData::descender, "")
        .def_rw("lineh", &TextMetricsData::lineh, "")
        ;


    m.def("text_metrics",
        nvgcpp_TextMetrics,
        nb::arg("ctx"),
        " Returns the vertical metrics based on the current text style.\n Measured values are returned in local coordinate space.");


    auto pyClassNVGtextRowSimple =
        nb::class_<NVGtextRowSimple>
            (m, "TextRowSimple", "")
        .def("__init__", [](NVGtextRowSimple * self, std::string row_text = std::string(), float width = float(), float minx = float(), float maxx = float())
        {
            new (self) NVGtextRowSimple();  // placement new
            auto r_ctor_ = self;
            r_ctor_->row_text = row_text;
            r_ctor_->width = width;
            r_ctor_->minx = minx;
            r_ctor_->maxx = maxx;
        },
        nb::arg("row_text") = std::string(), nb::arg("width") = float(), nb::arg("minx") = float(), nb::arg("maxx") = float()
        )
        .def_rw("row_text", &NVGtextRowSimple::row_text, "")
        .def_rw("width", &NVGtextRowSimple::width, "Logical width of the row.")
        .def_rw("minx", &NVGtextRowSimple::minx, "Actual bounds of the row. Logical with and bounds can differ because of kerning and some parts over extending.")
        .def_rw("maxx", &NVGtextRowSimple::maxx, "Actual bounds of the row. Logical with and bounds can differ because of kerning and some parts over extending.")
        ;


    m.def("text_break_lines",
        nvgcpp_TextBreakLines,
        nb::arg("ctx"), nb::arg("text"), nb::arg("break_row_width"),
        " Breaks the specified text into lines. If end is specified only the sub-string will be used.\n White space is stripped at the beginning of the rows, the text is split at word boundaries or when new-line characters are encountered.\n Words longer than the max width are split at nearest character (i.e. no hyphenation).");

    m.def("text_align",
        nvgcpp_TextAlign,
        nb::arg("ctx"), nb::arg("align"),
        "Sets the text align of current text style, see NVGalign for options.");

    m.def("text_line_height",
        nvgcpp_TextLineHeight,
        nb::arg("ctx"), nb::arg("line_height"),
        "Sets the proportional line height of current text style. The line height is specified as multiple of font size.");

    m.def("image_size",
        nvgcpp_ImageSize,
        nb::arg("ctx"), nb::arg("image"),
        "Returns the dimensions of a created image.");
    ////////////////////    </generated_from:nvg_cpp_text.h>    ////////////////////

    // </litgen_pydef> // Autogenerated code end
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
}
#endif // IMGUI_BUNDLE_WITH_NANOVG
