// Part of ImGui Bundle - MIT License - Copyright (c) 2022-2024 Pascal Thomet - https://github.com/pthom/imgui_bundle
#include <nanobind/nanobind.h>
#include <nanobind/stl/string.h>
#include <nanobind/stl/array.h>
#include <nanobind/stl/optional.h>
#include <nanobind/stl/vector.h>
#include <nanobind/stl/function.h>
#include <nanobind/ndarray.h>

#include "portable_file_dialogs/portable_file_dialogs.h"
namespace nb = nanobind;


// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// <litgen_glue_code>  // Autogenerated code below! Do not edit!

// </litgen_glue_code> // Autogenerated code end
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

namespace pfd {
    std::vector<std::string> all_files_filter() {
        return {"All files", "*"};
    }
}


void py_init_module_portable_file_dialogs(nb::module_& m)
{
    using namespace pfd;
    auto default_wait_timeout = pfd::internal::default_wait_timeout;

    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // <litgen_pydef> // Autogenerated code below! Do not edit!
    ////////////////////    <generated_from:portable_file_dialogs_simplified.h>    ////////////////////
    auto pyEnumbutton =
        nb::enum_<pfd::button>(m, "button", nb::is_arithmetic(), "")
            .value("cancel", pfd::button::cancel, "")
            .value("ok", pfd::button::ok, "")
            .value("yes", pfd::button::yes, "")
            .value("no", pfd::button::no, "")
            .value("abort", pfd::button::abort, "")
            .value("retry", pfd::button::retry, "")
            .value("ignore", pfd::button::ignore, "");


    auto pyEnumchoice =
        nb::enum_<pfd::choice>(m, "choice", nb::is_arithmetic(), "")
            .value("ok", pfd::choice::ok, "")
            .value("ok_cancel", pfd::choice::ok_cancel, "")
            .value("yes_no", pfd::choice::yes_no, "")
            .value("yes_no_cancel", pfd::choice::yes_no_cancel, "")
            .value("retry_cancel", pfd::choice::retry_cancel, "")
            .value("abort_retry_ignore", pfd::choice::abort_retry_ignore, "");


    auto pyEnumicon =
        nb::enum_<pfd::icon>(m, "icon", nb::is_arithmetic(), "")
            .value("info", pfd::icon::info, "")
            .value("warning", pfd::icon::warning, "")
            .value("error", pfd::icon::error, "")
            .value("question", pfd::icon::question, "");


    auto pyEnumopt =
        nb::enum_<pfd::opt>(m, "opt", nb::is_arithmetic(), "Additional option flags for various dialog constructors")
            .value("none", pfd::opt::none, "")
            .value("multiselect", pfd::opt::multiselect, "For file open, allow multiselect.")
            .value("force_overwrite", pfd::opt::force_overwrite, "For file save, force overwrite and disable the confirmation dialog.")
            .value("force_path", pfd::opt::force_path, " For folder select, force path to be the provided argument instead\n of the last opened directory, which is the Microsoft-recommended,\n user-friendly behaviour.");


    auto pyClassnotify =
        nb::class_<pfd::notify>
            (m, "notify", "\n The notify widget\n")
        .def(nb::init<const std::string &, const std::string &, pfd::icon>(),
            nb::arg("title"), nb::arg("message"), nb::arg("_icon") = pfd::icon::info)
        .def("ready",
            &pfd::notify::ready, nb::arg("timeout") = default_wait_timeout)
        .def("kill",
            &pfd::notify::kill)
        ;


    auto pyClassmessage =
        nb::class_<pfd::message>
            (m, "message", "\n The message widget\n")
        .def(nb::init<const std::string &, const std::string &, pfd::choice, pfd::icon>(),
            nb::arg("title"), nb::arg("text"), nb::arg("_choice") = pfd::choice::ok_cancel, nb::arg("_icon") = pfd::icon::info)
        .def("result",
            &pfd::message::result)
        .def("ready",
            &pfd::message::ready, nb::arg("timeout") = default_wait_timeout)
        .def("kill",
            &pfd::message::kill)
        ;


    m.def("all_files_filter",
        pfd::all_files_filter);


    auto pyClassopen_file =
        nb::class_<pfd::open_file>
            (m, "open_file", "\n The open_file, save_file, and open_folder widgets\n")
        .def("__init__",
            [](pfd::open_file * self, const std::string & title, const std::string & default_path = "", const std::optional<const std::vector<std::string>> & filters = std::nullopt, pfd::opt options = pfd::opt::none)
            {
                auto ctor_wrapper = [](pfd::open_file* self, const std::string & title, const std::string & default_path = "", const std::vector<std::string> & filters = pfd::all_files_filter(), pfd::opt options = pfd::opt::none) ->  void
                {
                    new(self) pfd::open_file(title, default_path, filters, options); // placement new
                };
                auto ctor_wrapper_adapt_mutable_param_with_default_value = [&ctor_wrapper](pfd::open_file * self, const std::string & title, const std::string & default_path = "", const std::optional<const std::vector<std::string>> & filters = std::nullopt, pfd::opt options = pfd::opt::none)
                {

                    const std::vector<std::string>& filters_or_default = [&]() -> const std::vector<std::string> {
                        if (filters.has_value())
                            return filters.value();
                        else
                            return pfd::all_files_filter();
                    }();

                    ctor_wrapper(self, title, default_path, filters_or_default, options);
                };

                ctor_wrapper_adapt_mutable_param_with_default_value(self, title, default_path, filters, options);
            },
            nb::arg("title"), nb::arg("default_path") = "", nb::arg("filters").none() = nb::none(), nb::arg("options") = pfd::opt::none,
            "Python bindings defaults:\n    If filters is None, then its default value will be: all_files_filter()")
        .def("ready",
            &pfd::open_file::ready, nb::arg("timeout") = default_wait_timeout)
        .def("kill",
            &pfd::open_file::kill)
        .def("result",
            &pfd::open_file::result)
        ;


    auto pyClasssave_file =
        nb::class_<pfd::save_file>
            (m, "save_file", "")
        .def("__init__",
            [](pfd::save_file * self, const std::string & title, const std::string & default_path = "", const std::optional<const std::vector<std::string>> & filters = std::nullopt, pfd::opt options = pfd::opt::none)
            {
                auto ctor_wrapper = [](pfd::save_file* self, const std::string & title, const std::string & default_path = "", const std::vector<std::string> & filters = pfd::all_files_filter(), pfd::opt options = pfd::opt::none) ->  void
                {
                    new(self) pfd::save_file(title, default_path, filters, options); // placement new
                };
                auto ctor_wrapper_adapt_mutable_param_with_default_value = [&ctor_wrapper](pfd::save_file * self, const std::string & title, const std::string & default_path = "", const std::optional<const std::vector<std::string>> & filters = std::nullopt, pfd::opt options = pfd::opt::none)
                {

                    const std::vector<std::string>& filters_or_default = [&]() -> const std::vector<std::string> {
                        if (filters.has_value())
                            return filters.value();
                        else
                            return pfd::all_files_filter();
                    }();

                    ctor_wrapper(self, title, default_path, filters_or_default, options);
                };

                ctor_wrapper_adapt_mutable_param_with_default_value(self, title, default_path, filters, options);
            },
            nb::arg("title"), nb::arg("default_path") = "", nb::arg("filters").none() = nb::none(), nb::arg("options") = pfd::opt::none,
            "Python bindings defaults:\n    If filters is None, then its default value will be: all_files_filter()")
        .def("ready",
            &pfd::save_file::ready, nb::arg("timeout") = default_wait_timeout)
        .def("kill",
            &pfd::save_file::kill)
        .def("result",
            &pfd::save_file::result)
        ;


    auto pyClassselect_folder =
        nb::class_<pfd::select_folder>
            (m, "select_folder", "")
        .def(nb::init<const std::string &, const std::string &, pfd::opt>(),
            nb::arg("title"), nb::arg("default_path") = "", nb::arg("options") = pfd::opt::none)
        .def("ready",
            &pfd::select_folder::ready, nb::arg("timeout") = default_wait_timeout)
        .def("kill",
            &pfd::select_folder::kill)
        .def("result",
            &pfd::select_folder::result)
        ;
    ////////////////////    </generated_from:portable_file_dialogs_simplified.h>    ////////////////////

    // </litgen_pydef> // Autogenerated code end
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
}
