# optimized for <=10000 samples and <=500 features, with a GPU present
hyperparameter_portfolio_zeroshot_2025_small = {
    "TABPFNV2": [
        {
            "ag_args": {'name_suffix': '_r143', 'priority': -1},
            "average_before_softmax": False,
            "classification_model_path": 'tabpfn-v2-classifier-od3j1g5m.ckpt',
            "inference_config/FINGERPRINT_FEATURE": False,
            "inference_config/OUTLIER_REMOVAL_STD": None,
            "inference_config/POLYNOMIAL_FEATURES": 'no',
            "inference_config/PREPROCESS_TRANSFORMS": [{'append_original': True, 'categorical_name': 'ordinal_very_common_categories_shuffled', 'global_transformer_name': None, 'name': 'safepower', 'subsample_features': -1}, {'append_original': True, 'categorical_name': 'ordinal_very_common_categories_shuffled', 'global_transformer_name': None, 'name': 'quantile_uni', 'subsample_features': -1}],
            "inference_config/REGRESSION_Y_PREPROCESS_TRANSFORMS": [None, 'power'],
            "inference_config/SUBSAMPLE_SAMPLES": 0.99,
            "model_type": 'single',
            "n_ensemble_repeats": 4,
            "regression_model_path": 'tabpfn-v2-regressor-wyl4o83o.ckpt',
            "softmax_temperature": 0.75,
        },
        {
            "ag_args": {'name_suffix': '_r94', 'priority': -3},
            "average_before_softmax": True,
            "classification_model_path": 'tabpfn-v2-classifier-vutqq28w.ckpt',
            "inference_config/FINGERPRINT_FEATURE": True,
            "inference_config/OUTLIER_REMOVAL_STD": None,
            "inference_config/POLYNOMIAL_FEATURES": 'no',
            "inference_config/PREPROCESS_TRANSFORMS": [{'append_original': True, 'categorical_name': 'ordinal_very_common_categories_shuffled', 'global_transformer_name': None, 'name': 'quantile_uni', 'subsample_features': 0.99}],
            "inference_config/REGRESSION_Y_PREPROCESS_TRANSFORMS": [None],
            "inference_config/SUBSAMPLE_SAMPLES": None,
            "model_type": 'single',
            "n_ensemble_repeats": 4,
            "regression_model_path": 'tabpfn-v2-regressor-5wof9ojf.ckpt',
            "softmax_temperature": 0.9,
        },
        {
            "ag_args": {'name_suffix': '_r181', 'priority': -4},
            "average_before_softmax": False,
            "classification_model_path": 'tabpfn-v2-classifier-llderlii.ckpt',
            "inference_config/FINGERPRINT_FEATURE": False,
            "inference_config/OUTLIER_REMOVAL_STD": 9.0,
            "inference_config/POLYNOMIAL_FEATURES": 50,
            "inference_config/PREPROCESS_TRANSFORMS": [{'append_original': True, 'categorical_name': 'onehot', 'global_transformer_name': 'svd', 'name': 'quantile_uni_coarse', 'subsample_features': 0.99}],
            "inference_config/REGRESSION_Y_PREPROCESS_TRANSFORMS": ['power'],
            "inference_config/SUBSAMPLE_SAMPLES": None,
            "model_type": 'single',
            "n_ensemble_repeats": 4,
            "regression_model_path": 'tabpfn-v2-regressor.ckpt',
            "softmax_temperature": 0.95,
        },
    ],
    "GBM": [
        {
            "ag_args": {'name_suffix': '_r33', 'priority': -2},
            "bagging_fraction": 0.9625293420216,
            "bagging_freq": 1,
            "cat_l2": 0.1236875455555,
            "cat_smooth": 68.8584757332856,
            "extra_trees": False,
            "feature_fraction": 0.6189215809382,
            "lambda_l1": 0.1641757352921,
            "lambda_l2": 0.6937755557881,
            "learning_rate": 0.0154031028561,
            "max_cat_to_onehot": 17,
            "min_data_in_leaf": 1,
            "min_data_per_group": 30,
            "num_leaves": 68,
        },
        {
            "ag_args": {'name_suffix': '_r21', 'priority': -16},
            "bagging_fraction": 0.7218730663234,
            "bagging_freq": 1,
            "cat_l2": 0.0296205152578,
            "cat_smooth": 0.0010255271303,
            "extra_trees": False,
            "feature_fraction": 0.4557131604374,
            "lambda_l1": 0.5219704038237,
            "lambda_l2": 0.1070959487853,
            "learning_rate": 0.0055891584996,
            "max_cat_to_onehot": 71,
            "min_data_in_leaf": 50,
            "min_data_per_group": 10,
            "num_leaves": 30,
        },
        {
            "ag_args": {'name_suffix': '_r11', 'priority': -19},
            "bagging_fraction": 0.775784726514,
            "bagging_freq": 1,
            "cat_l2": 0.3888471449178,
            "cat_smooth": 0.0057144748021,
            "extra_trees": True,
            "feature_fraction": 0.7732354787904,
            "lambda_l1": 0.2211002452568,
            "lambda_l2": 1.1318405980187,
            "learning_rate": 0.0090151778542,
            "max_cat_to_onehot": 15,
            "min_data_in_leaf": 4,
            "min_data_per_group": 15,
            "num_leaves": 2,
        },
    ],
    "CAT": [
        {
            "ag_args": {'priority': -5},
        },
        {
            "ag_args": {'name_suffix': '_r51', 'priority': -10},
            "boosting_type": 'Plain',
            "bootstrap_type": 'Bernoulli',
            "colsample_bylevel": 0.8771035272558,
            "depth": 7,
            "grow_policy": 'SymmetricTree',
            "l2_leaf_reg": 2.0107286863021,
            "leaf_estimation_iterations": 2,
            "learning_rate": 0.0058424016622,
            "max_bin": 254,
            "max_ctr_complexity": 4,
            "model_size_reg": 0.1307400355809,
            "one_hot_max_size": 23,
            "subsample": 0.809527841437,
        },
        {
            "ag_args": {'name_suffix': '_r10', 'priority': -12},
            "boosting_type": 'Plain',
            "bootstrap_type": 'Bernoulli',
            "colsample_bylevel": 0.8994502668431,
            "depth": 6,
            "grow_policy": 'Depthwise',
            "l2_leaf_reg": 1.8187025215896,
            "leaf_estimation_iterations": 7,
            "learning_rate": 0.005177304142,
            "max_bin": 254,
            "max_ctr_complexity": 4,
            "model_size_reg": 0.5247386875068,
            "one_hot_max_size": 53,
            "subsample": 0.8705228845742,
        },
        {
            "ag_args": {'name_suffix': '_r24', 'priority': -15},
            "boosting_type": 'Plain',
            "bootstrap_type": 'Bernoulli',
            "colsample_bylevel": 0.8597809376276,
            "depth": 8,
            "grow_policy": 'Depthwise',
            "l2_leaf_reg": 0.3628261923976,
            "leaf_estimation_iterations": 5,
            "learning_rate": 0.016851077771,
            "max_bin": 254,
            "max_ctr_complexity": 4,
            "model_size_reg": 0.1253820547902,
            "one_hot_max_size": 20,
            "subsample": 0.8120271122061,
        },
        {
            "ag_args": {'name_suffix': '_r91', 'priority': -17},
            "boosting_type": 'Plain',
            "bootstrap_type": 'Bernoulli',
            "colsample_bylevel": 0.8959275863514,
            "depth": 4,
            "grow_policy": 'SymmetricTree',
            "l2_leaf_reg": 0.0026915894253,
            "leaf_estimation_iterations": 12,
            "learning_rate": 0.0475233791203,
            "max_bin": 254,
            "max_ctr_complexity": 5,
            "model_size_reg": 0.1633175256924,
            "one_hot_max_size": 11,
            "subsample": 0.798554178926,
        },
    ],
    "TABM": [
        {
            "ag_args": {'name_suffix': '_r184', 'priority': -6},
            "amp": False,
            "arch_type": 'tabm-mini',
            "batch_size": 'auto',
            "d_block": 864,
            "d_embedding": 24,
            "dropout": 0.0,
            "gradient_clipping_norm": 1.0,
            "lr": 0.0019256819924656217,
            "n_blocks": 3,
            "num_emb_n_bins": 3,
            "num_emb_type": 'pwl',
            "patience": 16,
            "share_training_batches": False,
            "tabm_k": 32,
            "weight_decay": 0.0,
        },
        {
            "ag_args": {'name_suffix': '_r69', 'priority': -7},
            "amp": False,
            "arch_type": 'tabm-mini',
            "batch_size": 'auto',
            "d_block": 848,
            "d_embedding": 28,
            "dropout": 0.40215621636031007,
            "gradient_clipping_norm": 1.0,
            "lr": 0.0010413640454559532,
            "n_blocks": 3,
            "num_emb_n_bins": 18,
            "num_emb_type": 'pwl',
            "patience": 16,
            "share_training_batches": False,
            "tabm_k": 32,
            "weight_decay": 0.0,
        },
        {
            "ag_args": {'name_suffix': '_r52', 'priority': -11},
            "amp": False,
            "arch_type": 'tabm-mini',
            "batch_size": 'auto',
            "d_block": 1024,
            "d_embedding": 32,
            "dropout": 0.0,
            "gradient_clipping_norm": 1.0,
            "lr": 0.0006297851297842611,
            "n_blocks": 4,
            "num_emb_n_bins": 22,
            "num_emb_type": 'pwl',
            "patience": 16,
            "share_training_batches": False,
            "tabm_k": 32,
            "weight_decay": 0.06900108498839816,
        },
        {
            "ag_args": {'priority': -13},
        },
        {
            "ag_args": {'name_suffix': '_r191', 'priority': -14},
            "amp": False,
            "arch_type": 'tabm-mini',
            "batch_size": 'auto',
            "d_block": 864,
            "d_embedding": 8,
            "dropout": 0.45321529282058803,
            "gradient_clipping_norm": 1.0,
            "lr": 0.0003781238075322413,
            "n_blocks": 4,
            "num_emb_n_bins": 27,
            "num_emb_type": 'pwl',
            "patience": 16,
            "share_training_batches": False,
            "tabm_k": 32,
            "weight_decay": 0.01766851962579851,
        },
        {
            "ag_args": {'name_suffix': '_r49', 'priority': -20},
            "amp": False,
            "arch_type": 'tabm-mini',
            "batch_size": 'auto',
            "d_block": 640,
            "d_embedding": 28,
            "dropout": 0.15296207419190627,
            "gradient_clipping_norm": 1.0,
            "lr": 0.002277678490593717,
            "n_blocks": 3,
            "num_emb_n_bins": 48,
            "num_emb_type": 'pwl',
            "patience": 16,
            "share_training_batches": False,
            "tabm_k": 32,
            "weight_decay": 0.0578159148243893,
        },
    ],
    "TABICL": [
        {
            "ag_args": {'priority': -8},
        },
    ],
    "XGB": [
        {
            "ag_args": {'name_suffix': '_r171', 'priority': -9},
            "colsample_bylevel": 0.9213705632288,
            "colsample_bynode": 0.6443385965381,
            "enable_categorical": True,
            "grow_policy": 'lossguide',
            "learning_rate": 0.0068171645251,
            "max_cat_to_onehot": 8,
            "max_depth": 6,
            "max_leaves": 10,
            "min_child_weight": 0.0507304250576,
            "reg_alpha": 4.2446346389037,
            "reg_lambda": 1.4800570021253,
            "subsample": 0.9656290596647,
        },
        {
            "ag_args": {'name_suffix': '_r40', 'priority': -18},
            "colsample_bylevel": 0.6377491713202,
            "colsample_bynode": 0.9237625621103,
            "enable_categorical": True,
            "grow_policy": 'lossguide',
            "learning_rate": 0.0112462621131,
            "max_cat_to_onehot": 33,
            "max_depth": 10,
            "max_leaves": 35,
            "min_child_weight": 0.1403464856034,
            "reg_alpha": 3.4960653958503,
            "reg_lambda": 1.3062320805235,
            "subsample": 0.6948898835178,
        },
    ],
    "MITRA": [
        {
            "n_estimators": 1,
            "fine_tune": True,
            "fine_tune_steps": 50,
            "ag.num_gpus": 1,
            "ag_args": {'priority': -21},
        },
    ],
}
