"""
AUTO-GENERATED BY Testing Kit v1

Routine tests for the public population API surface.
"""
#import pytest

from pyparticle import build_population, ParticlePopulation


def test_build_population_missing_type_raises():
    cfg = {}
    with pytest.raises(ValueError):
        build_population(cfg)


def test_build_monodisperse_happy_path():
    # Minimal monodisperse config matching the builder contract
    cfg = {
        'type': 'monodisperse',
        'aero_spec_names': [['SO4']],
        'N': [1.0],
        'D': [1e-7],
        # per-particle fraction arrays (one list per particle)
        'aero_spec_fracs': [[1.0]],
    }
    pop = build_population(cfg)
    assert isinstance(pop, ParticlePopulation)
    # Ntot should equal the single provided concentration (approximately)
    assert pytest.approx(pop.get_Ntot(), rel=1e-6) == 1.0


def test_population_get_mass_conc_and_errors():
    cfg = {
        'type': 'monodisperse',
        'aero_spec_names': [['SO4']],
        'N': [2.0],
        'D': [1e-7],
        'aero_spec_fracs': [[1.0]],
    }
    pop = build_population(cfg)
    # mass conc for a species that exists should be numeric
    m = pop.get_mass_conc('SO4')
    assert isinstance(m, float)
    # requesting a nonexistent particle id should raise
    with pytest.raises(ValueError):
        pop.get_particle(999999)
