"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _InstrumentType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _InstrumentTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_InstrumentType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INSTRUMENT_TYPE_UNSPECIFIED: _InstrumentType.ValueType  # 0
    INSTRUMENT_TYPE_BOND: _InstrumentType.ValueType  # 1
    """Облигация."""
    INSTRUMENT_TYPE_SHARE: _InstrumentType.ValueType  # 2
    """Акция."""
    INSTRUMENT_TYPE_CURRENCY: _InstrumentType.ValueType  # 3
    """Валюта."""
    INSTRUMENT_TYPE_ETF: _InstrumentType.ValueType  # 4
    """Exchange-traded fund. Фонд."""
    INSTRUMENT_TYPE_FUTURES: _InstrumentType.ValueType  # 5
    """Фьючерс."""
    INSTRUMENT_TYPE_SP: _InstrumentType.ValueType  # 6
    """Структурная нота."""
    INSTRUMENT_TYPE_OPTION: _InstrumentType.ValueType  # 7
    """Опцион."""
    INSTRUMENT_TYPE_CLEARING_CERTIFICATE: _InstrumentType.ValueType  # 8
    """Clearing certificate."""
    INSTRUMENT_TYPE_INDEX: _InstrumentType.ValueType  # 9
    """Индекс."""
    INSTRUMENT_TYPE_COMMODITY: _InstrumentType.ValueType  # 10
    """Товар."""

class InstrumentType(_InstrumentType, metaclass=_InstrumentTypeEnumTypeWrapper):
    """Тип инструмента."""

INSTRUMENT_TYPE_UNSPECIFIED: InstrumentType.ValueType  # 0
INSTRUMENT_TYPE_BOND: InstrumentType.ValueType  # 1
"""Облигация."""
INSTRUMENT_TYPE_SHARE: InstrumentType.ValueType  # 2
"""Акция."""
INSTRUMENT_TYPE_CURRENCY: InstrumentType.ValueType  # 3
"""Валюта."""
INSTRUMENT_TYPE_ETF: InstrumentType.ValueType  # 4
"""Exchange-traded fund. Фонд."""
INSTRUMENT_TYPE_FUTURES: InstrumentType.ValueType  # 5
"""Фьючерс."""
INSTRUMENT_TYPE_SP: InstrumentType.ValueType  # 6
"""Структурная нота."""
INSTRUMENT_TYPE_OPTION: InstrumentType.ValueType  # 7
"""Опцион."""
INSTRUMENT_TYPE_CLEARING_CERTIFICATE: InstrumentType.ValueType  # 8
"""Clearing certificate."""
INSTRUMENT_TYPE_INDEX: InstrumentType.ValueType  # 9
"""Индекс."""
INSTRUMENT_TYPE_COMMODITY: InstrumentType.ValueType  # 10
"""Товар."""
global___InstrumentType = InstrumentType

class _InstrumentStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _InstrumentStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_InstrumentStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INSTRUMENT_STATUS_UNSPECIFIED: _InstrumentStatus.ValueType  # 0
    """Значение не определено."""
    INSTRUMENT_STATUS_BASE: _InstrumentStatus.ValueType  # 1
    """По умолчанию — базовый список инструментов, которыми можно торговать через T-Invest API. Сейчас списки доступных бумаг в API и других интерфейсах совпадают — кроме внебиржевых бумаг, но в будущем списки могут различаться."""
    INSTRUMENT_STATUS_ALL: _InstrumentStatus.ValueType  # 2
    """Список всех инструментов."""

class InstrumentStatus(_InstrumentStatus, metaclass=_InstrumentStatusEnumTypeWrapper):
    """Статус запрашиваемых инструментов."""

INSTRUMENT_STATUS_UNSPECIFIED: InstrumentStatus.ValueType  # 0
"""Значение не определено."""
INSTRUMENT_STATUS_BASE: InstrumentStatus.ValueType  # 1
"""По умолчанию — базовый список инструментов, которыми можно торговать через T-Invest API. Сейчас списки доступных бумаг в API и других интерфейсах совпадают — кроме внебиржевых бумаг, но в будущем списки могут различаться."""
INSTRUMENT_STATUS_ALL: InstrumentStatus.ValueType  # 2
"""Список всех инструментов."""
global___InstrumentStatus = InstrumentStatus

class _SecurityTradingStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SecurityTradingStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SecurityTradingStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SECURITY_TRADING_STATUS_UNSPECIFIED: _SecurityTradingStatus.ValueType  # 0
    """Торговый статус не определен."""
    SECURITY_TRADING_STATUS_NOT_AVAILABLE_FOR_TRADING: _SecurityTradingStatus.ValueType  # 1
    """Недоступен для торгов."""
    SECURITY_TRADING_STATUS_OPENING_PERIOD: _SecurityTradingStatus.ValueType  # 2
    """Период открытия торгов."""
    SECURITY_TRADING_STATUS_CLOSING_PERIOD: _SecurityTradingStatus.ValueType  # 3
    """Период закрытия торгов."""
    SECURITY_TRADING_STATUS_BREAK_IN_TRADING: _SecurityTradingStatus.ValueType  # 4
    """Перерыв в торговле."""
    SECURITY_TRADING_STATUS_NORMAL_TRADING: _SecurityTradingStatus.ValueType  # 5
    """Нормальная торговля."""
    SECURITY_TRADING_STATUS_CLOSING_AUCTION: _SecurityTradingStatus.ValueType  # 6
    """Аукцион закрытия."""
    SECURITY_TRADING_STATUS_DARK_POOL_AUCTION: _SecurityTradingStatus.ValueType  # 7
    """Аукцион крупных пакетов."""
    SECURITY_TRADING_STATUS_DISCRETE_AUCTION: _SecurityTradingStatus.ValueType  # 8
    """Дискретный аукцион."""
    SECURITY_TRADING_STATUS_OPENING_AUCTION_PERIOD: _SecurityTradingStatus.ValueType  # 9
    """Аукцион открытия."""
    SECURITY_TRADING_STATUS_TRADING_AT_CLOSING_AUCTION_PRICE: _SecurityTradingStatus.ValueType  # 10
    """Период торгов по цене аукциона закрытия."""
    SECURITY_TRADING_STATUS_SESSION_ASSIGNED: _SecurityTradingStatus.ValueType  # 11
    """Сессия назначена."""
    SECURITY_TRADING_STATUS_SESSION_CLOSE: _SecurityTradingStatus.ValueType  # 12
    """Сессия закрыта."""
    SECURITY_TRADING_STATUS_SESSION_OPEN: _SecurityTradingStatus.ValueType  # 13
    """Сессия открыта."""
    SECURITY_TRADING_STATUS_DEALER_NORMAL_TRADING: _SecurityTradingStatus.ValueType  # 14
    """Доступна торговля в режиме внутренней ликвидности брокера."""
    SECURITY_TRADING_STATUS_DEALER_BREAK_IN_TRADING: _SecurityTradingStatus.ValueType  # 15
    """Перерыв торговли в режиме внутренней ликвидности брокера."""
    SECURITY_TRADING_STATUS_DEALER_NOT_AVAILABLE_FOR_TRADING: _SecurityTradingStatus.ValueType  # 16
    """Недоступна торговля в режиме внутренней ликвидности брокера."""

class SecurityTradingStatus(_SecurityTradingStatus, metaclass=_SecurityTradingStatusEnumTypeWrapper):
    """Режим торгов инструмента"""

SECURITY_TRADING_STATUS_UNSPECIFIED: SecurityTradingStatus.ValueType  # 0
"""Торговый статус не определен."""
SECURITY_TRADING_STATUS_NOT_AVAILABLE_FOR_TRADING: SecurityTradingStatus.ValueType  # 1
"""Недоступен для торгов."""
SECURITY_TRADING_STATUS_OPENING_PERIOD: SecurityTradingStatus.ValueType  # 2
"""Период открытия торгов."""
SECURITY_TRADING_STATUS_CLOSING_PERIOD: SecurityTradingStatus.ValueType  # 3
"""Период закрытия торгов."""
SECURITY_TRADING_STATUS_BREAK_IN_TRADING: SecurityTradingStatus.ValueType  # 4
"""Перерыв в торговле."""
SECURITY_TRADING_STATUS_NORMAL_TRADING: SecurityTradingStatus.ValueType  # 5
"""Нормальная торговля."""
SECURITY_TRADING_STATUS_CLOSING_AUCTION: SecurityTradingStatus.ValueType  # 6
"""Аукцион закрытия."""
SECURITY_TRADING_STATUS_DARK_POOL_AUCTION: SecurityTradingStatus.ValueType  # 7
"""Аукцион крупных пакетов."""
SECURITY_TRADING_STATUS_DISCRETE_AUCTION: SecurityTradingStatus.ValueType  # 8
"""Дискретный аукцион."""
SECURITY_TRADING_STATUS_OPENING_AUCTION_PERIOD: SecurityTradingStatus.ValueType  # 9
"""Аукцион открытия."""
SECURITY_TRADING_STATUS_TRADING_AT_CLOSING_AUCTION_PRICE: SecurityTradingStatus.ValueType  # 10
"""Период торгов по цене аукциона закрытия."""
SECURITY_TRADING_STATUS_SESSION_ASSIGNED: SecurityTradingStatus.ValueType  # 11
"""Сессия назначена."""
SECURITY_TRADING_STATUS_SESSION_CLOSE: SecurityTradingStatus.ValueType  # 12
"""Сессия закрыта."""
SECURITY_TRADING_STATUS_SESSION_OPEN: SecurityTradingStatus.ValueType  # 13
"""Сессия открыта."""
SECURITY_TRADING_STATUS_DEALER_NORMAL_TRADING: SecurityTradingStatus.ValueType  # 14
"""Доступна торговля в режиме внутренней ликвидности брокера."""
SECURITY_TRADING_STATUS_DEALER_BREAK_IN_TRADING: SecurityTradingStatus.ValueType  # 15
"""Перерыв торговли в режиме внутренней ликвидности брокера."""
SECURITY_TRADING_STATUS_DEALER_NOT_AVAILABLE_FOR_TRADING: SecurityTradingStatus.ValueType  # 16
"""Недоступна торговля в режиме внутренней ликвидности брокера."""
global___SecurityTradingStatus = SecurityTradingStatus

class _PriceType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PriceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PriceType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PRICE_TYPE_UNSPECIFIED: _PriceType.ValueType  # 0
    """Значение не определено."""
    PRICE_TYPE_POINT: _PriceType.ValueType  # 1
    """Цена в пунктах (только для фьючерсов и облигаций)."""
    PRICE_TYPE_CURRENCY: _PriceType.ValueType  # 2
    """Цена в валюте расчетов по инструменту."""

class PriceType(_PriceType, metaclass=_PriceTypeEnumTypeWrapper):
    """Тип цены."""

PRICE_TYPE_UNSPECIFIED: PriceType.ValueType  # 0
"""Значение не определено."""
PRICE_TYPE_POINT: PriceType.ValueType  # 1
"""Цена в пунктах (только для фьючерсов и облигаций)."""
PRICE_TYPE_CURRENCY: PriceType.ValueType  # 2
"""Цена в валюте расчетов по инструменту."""
global___PriceType = PriceType

class _ResultSubscriptionStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ResultSubscriptionStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ResultSubscriptionStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    RESULT_SUBSCRIPTION_STATUS_UNSPECIFIED: _ResultSubscriptionStatus.ValueType  # 0
    """Статус подписки не определен."""
    RESULT_SUBSCRIPTION_STATUS_OK: _ResultSubscriptionStatus.ValueType  # 1
    """Подписка успешно установлена."""
    RESULT_SUBSCRIPTION_STATUS_ERROR: _ResultSubscriptionStatus.ValueType  # 13
    """Ошибка подписки"""

class ResultSubscriptionStatus(_ResultSubscriptionStatus, metaclass=_ResultSubscriptionStatusEnumTypeWrapper): ...

RESULT_SUBSCRIPTION_STATUS_UNSPECIFIED: ResultSubscriptionStatus.ValueType  # 0
"""Статус подписки не определен."""
RESULT_SUBSCRIPTION_STATUS_OK: ResultSubscriptionStatus.ValueType  # 1
"""Подписка успешно установлена."""
RESULT_SUBSCRIPTION_STATUS_ERROR: ResultSubscriptionStatus.ValueType  # 13
"""Ошибка подписки"""
global___ResultSubscriptionStatus = ResultSubscriptionStatus

class _RealExchange:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _RealExchangeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_RealExchange.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    REAL_EXCHANGE_UNSPECIFIED: _RealExchange.ValueType  # 0
    """Тип не определен."""
    REAL_EXCHANGE_MOEX: _RealExchange.ValueType  # 1
    """Московская биржа."""
    REAL_EXCHANGE_RTS: _RealExchange.ValueType  # 2
    """Санкт-Петербургская биржа."""
    REAL_EXCHANGE_OTC: _RealExchange.ValueType  # 3
    """Внебиржевой инструмент."""
    REAL_EXCHANGE_DEALER: _RealExchange.ValueType  # 4
    """Инструмент, торгуемый на площадке брокера."""

class RealExchange(_RealExchange, metaclass=_RealExchangeEnumTypeWrapper):
    """Реальная площадка исполнения расчетов."""

REAL_EXCHANGE_UNSPECIFIED: RealExchange.ValueType  # 0
"""Тип не определен."""
REAL_EXCHANGE_MOEX: RealExchange.ValueType  # 1
"""Московская биржа."""
REAL_EXCHANGE_RTS: RealExchange.ValueType  # 2
"""Санкт-Петербургская биржа."""
REAL_EXCHANGE_OTC: RealExchange.ValueType  # 3
"""Внебиржевой инструмент."""
REAL_EXCHANGE_DEALER: RealExchange.ValueType  # 4
"""Инструмент, торгуемый на площадке брокера."""
global___RealExchange = RealExchange

@typing.final
class MoneyValue(google.protobuf.message.Message):
    """Денежная сумма в определенной валюте."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CURRENCY_FIELD_NUMBER: builtins.int
    UNITS_FIELD_NUMBER: builtins.int
    NANO_FIELD_NUMBER: builtins.int
    currency: builtins.str
    """Строковый ISO-код валюты."""
    units: builtins.int
    """Целая часть суммы, может быть отрицательным числом."""
    nano: builtins.int
    """Дробная часть суммы, может быть отрицательным числом."""
    def __init__(
        self,
        *,
        currency: builtins.str = ...,
        units: builtins.int = ...,
        nano: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["currency", b"currency", "nano", b"nano", "units", b"units"]) -> None: ...

global___MoneyValue = MoneyValue

@typing.final
class Quotation(google.protobuf.message.Message):
    """Котировка — денежная сумма без указания валюты."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UNITS_FIELD_NUMBER: builtins.int
    NANO_FIELD_NUMBER: builtins.int
    units: builtins.int
    """Целая часть суммы, может быть отрицательным числом."""
    nano: builtins.int
    """Дробная часть суммы, может быть отрицательным числом."""
    def __init__(
        self,
        *,
        units: builtins.int = ...,
        nano: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["nano", b"nano", "units", b"units"]) -> None: ...

global___Quotation = Quotation

@typing.final
class PingRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIME_FIELD_NUMBER: builtins.int
    @property
    def time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время формирования запроса."""

    def __init__(
        self,
        *,
        time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_time", b"_time", "time", b"time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_time", b"_time", "time", b"time"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_time", b"_time"]) -> typing.Literal["time"] | None: ...

global___PingRequest = PingRequest

@typing.final
class PingDelaySettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PING_DELAY_MS_FIELD_NUMBER: builtins.int
    ping_delay_ms: builtins.int
    """Задержка (пинг) сообщений:  5000–180 000 миллисекунд. Значение по умолчанию — 120 000."""
    def __init__(
        self,
        *,
        ping_delay_ms: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_ping_delay_ms", b"_ping_delay_ms", "ping_delay_ms", b"ping_delay_ms"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_ping_delay_ms", b"_ping_delay_ms", "ping_delay_ms", b"ping_delay_ms"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_ping_delay_ms", b"_ping_delay_ms"]) -> typing.Literal["ping_delay_ms"] | None: ...

global___PingDelaySettings = PingDelaySettings

@typing.final
class Ping(google.protobuf.message.Message):
    """Проверка активности стрима."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIME_FIELD_NUMBER: builtins.int
    STREAM_ID_FIELD_NUMBER: builtins.int
    PING_REQUEST_TIME_FIELD_NUMBER: builtins.int
    stream_id: builtins.str
    """Идентификатор соединения."""
    @property
    def time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время проверки."""

    @property
    def ping_request_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время формирования запроса."""

    def __init__(
        self,
        *,
        time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        stream_id: builtins.str = ...,
        ping_request_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_ping_request_time", b"_ping_request_time", "ping_request_time", b"ping_request_time", "time", b"time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_ping_request_time", b"_ping_request_time", "ping_request_time", b"ping_request_time", "stream_id", b"stream_id", "time", b"time"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_ping_request_time", b"_ping_request_time"]) -> typing.Literal["ping_request_time"] | None: ...

global___Ping = Ping

@typing.final
class Page(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIMIT_FIELD_NUMBER: builtins.int
    PAGE_NUMBER_FIELD_NUMBER: builtins.int
    limit: builtins.int
    """Максимальное число возвращаемых записей."""
    page_number: builtins.int
    """Порядковый номер страницы, начиная с 0."""
    def __init__(
        self,
        *,
        limit: builtins.int = ...,
        page_number: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["limit", b"limit", "page_number", b"page_number"]) -> None: ...

global___Page = Page

@typing.final
class PageResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIMIT_FIELD_NUMBER: builtins.int
    PAGE_NUMBER_FIELD_NUMBER: builtins.int
    TOTAL_COUNT_FIELD_NUMBER: builtins.int
    limit: builtins.int
    """Максимальное число возвращаемых записей."""
    page_number: builtins.int
    """Порядковый номер страницы, начиная с 0."""
    total_count: builtins.int
    """Общее количество записей."""
    def __init__(
        self,
        *,
        limit: builtins.int = ...,
        page_number: builtins.int = ...,
        total_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["limit", b"limit", "page_number", b"page_number", "total_count", b"total_count"]) -> None: ...

global___PageResponse = PageResponse

@typing.final
class ResponseMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRACKING_ID_FIELD_NUMBER: builtins.int
    SERVER_TIME_FIELD_NUMBER: builtins.int
    tracking_id: builtins.str
    """Идентификатор трекинга."""
    @property
    def server_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Серверное время."""

    def __init__(
        self,
        *,
        tracking_id: builtins.str = ...,
        server_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["server_time", b"server_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["server_time", b"server_time", "tracking_id", b"tracking_id"]) -> None: ...

global___ResponseMetadata = ResponseMetadata

@typing.final
class BrandData(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOGO_NAME_FIELD_NUMBER: builtins.int
    LOGO_BASE_COLOR_FIELD_NUMBER: builtins.int
    TEXT_COLOR_FIELD_NUMBER: builtins.int
    logo_name: builtins.str
    """Логотип инструмента. Имя файла для получения логотипа."""
    logo_base_color: builtins.str
    """	Цвет бренда."""
    text_color: builtins.str
    """Цвет текста для цвета логотипа бренда."""
    def __init__(
        self,
        *,
        logo_name: builtins.str = ...,
        logo_base_color: builtins.str = ...,
        text_color: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["logo_base_color", b"logo_base_color", "logo_name", b"logo_name", "text_color", b"text_color"]) -> None: ...

global___BrandData = BrandData

@typing.final
class ErrorDetail(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CODE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    code: builtins.str
    """Код ошибки."""
    message: builtins.str
    """Описание ошибки."""
    def __init__(
        self,
        *,
        code: builtins.str = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["code", b"code", "message", b"message"]) -> None: ...

global___ErrorDetail = ErrorDetail
