"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import tinkoff.invest.grpc.common_pb2
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _CouponType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CouponTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CouponType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    COUPON_TYPE_UNSPECIFIED: _CouponType.ValueType  # 0
    """Неопределенное значение."""
    COUPON_TYPE_CONSTANT: _CouponType.ValueType  # 1
    """Постоянный."""
    COUPON_TYPE_FLOATING: _CouponType.ValueType  # 2
    """Плавающий."""
    COUPON_TYPE_DISCOUNT: _CouponType.ValueType  # 3
    """Дисконт."""
    COUPON_TYPE_MORTGAGE: _CouponType.ValueType  # 4
    """Ипотечный."""
    COUPON_TYPE_FIX: _CouponType.ValueType  # 5
    """Фиксированный."""
    COUPON_TYPE_VARIABLE: _CouponType.ValueType  # 6
    """Переменный."""
    COUPON_TYPE_OTHER: _CouponType.ValueType  # 7
    """Прочее."""

class CouponType(_CouponType, metaclass=_CouponTypeEnumTypeWrapper):
    """Тип купонов."""

COUPON_TYPE_UNSPECIFIED: CouponType.ValueType  # 0
"""Неопределенное значение."""
COUPON_TYPE_CONSTANT: CouponType.ValueType  # 1
"""Постоянный."""
COUPON_TYPE_FLOATING: CouponType.ValueType  # 2
"""Плавающий."""
COUPON_TYPE_DISCOUNT: CouponType.ValueType  # 3
"""Дисконт."""
COUPON_TYPE_MORTGAGE: CouponType.ValueType  # 4
"""Ипотечный."""
COUPON_TYPE_FIX: CouponType.ValueType  # 5
"""Фиксированный."""
COUPON_TYPE_VARIABLE: CouponType.ValueType  # 6
"""Переменный."""
COUPON_TYPE_OTHER: CouponType.ValueType  # 7
"""Прочее."""
global___CouponType = CouponType

class _OptionDirection:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _OptionDirectionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_OptionDirection.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    OPTION_DIRECTION_UNSPECIFIED: _OptionDirection.ValueType  # 0
    """Тип не определен."""
    OPTION_DIRECTION_PUT: _OptionDirection.ValueType  # 1
    """Опцион на продажу."""
    OPTION_DIRECTION_CALL: _OptionDirection.ValueType  # 2
    """Опцион на покупку."""

class OptionDirection(_OptionDirection, metaclass=_OptionDirectionEnumTypeWrapper):
    """Тип опциона по направлению сделки."""

OPTION_DIRECTION_UNSPECIFIED: OptionDirection.ValueType  # 0
"""Тип не определен."""
OPTION_DIRECTION_PUT: OptionDirection.ValueType  # 1
"""Опцион на продажу."""
OPTION_DIRECTION_CALL: OptionDirection.ValueType  # 2
"""Опцион на покупку."""
global___OptionDirection = OptionDirection

class _OptionPaymentType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _OptionPaymentTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_OptionPaymentType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    OPTION_PAYMENT_TYPE_UNSPECIFIED: _OptionPaymentType.ValueType  # 0
    """Тип не определен."""
    OPTION_PAYMENT_TYPE_PREMIUM: _OptionPaymentType.ValueType  # 1
    """Опционы с использованием премии в расчетах."""
    OPTION_PAYMENT_TYPE_MARGINAL: _OptionPaymentType.ValueType  # 2
    """Маржируемые опционы."""

class OptionPaymentType(_OptionPaymentType, metaclass=_OptionPaymentTypeEnumTypeWrapper):
    """Тип расчетов по опциону."""

OPTION_PAYMENT_TYPE_UNSPECIFIED: OptionPaymentType.ValueType  # 0
"""Тип не определен."""
OPTION_PAYMENT_TYPE_PREMIUM: OptionPaymentType.ValueType  # 1
"""Опционы с использованием премии в расчетах."""
OPTION_PAYMENT_TYPE_MARGINAL: OptionPaymentType.ValueType  # 2
"""Маржируемые опционы."""
global___OptionPaymentType = OptionPaymentType

class _OptionStyle:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _OptionStyleEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_OptionStyle.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    OPTION_STYLE_UNSPECIFIED: _OptionStyle.ValueType  # 0
    """Тип не определен."""
    OPTION_STYLE_AMERICAN: _OptionStyle.ValueType  # 1
    """Американский опцион."""
    OPTION_STYLE_EUROPEAN: _OptionStyle.ValueType  # 2
    """Европейский опцион."""

class OptionStyle(_OptionStyle, metaclass=_OptionStyleEnumTypeWrapper):
    """Тип опциона по стилю."""

OPTION_STYLE_UNSPECIFIED: OptionStyle.ValueType  # 0
"""Тип не определен."""
OPTION_STYLE_AMERICAN: OptionStyle.ValueType  # 1
"""Американский опцион."""
OPTION_STYLE_EUROPEAN: OptionStyle.ValueType  # 2
"""Европейский опцион."""
global___OptionStyle = OptionStyle

class _OptionSettlementType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _OptionSettlementTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_OptionSettlementType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    OPTION_EXECUTION_TYPE_UNSPECIFIED: _OptionSettlementType.ValueType  # 0
    """Тип не определен."""
    OPTION_EXECUTION_TYPE_PHYSICAL_DELIVERY: _OptionSettlementType.ValueType  # 1
    """Поставочный тип опциона."""
    OPTION_EXECUTION_TYPE_CASH_SETTLEMENT: _OptionSettlementType.ValueType  # 2
    """Расчетный тип опциона."""

class OptionSettlementType(_OptionSettlementType, metaclass=_OptionSettlementTypeEnumTypeWrapper):
    """Тип опциона по способу исполнения."""

OPTION_EXECUTION_TYPE_UNSPECIFIED: OptionSettlementType.ValueType  # 0
"""Тип не определен."""
OPTION_EXECUTION_TYPE_PHYSICAL_DELIVERY: OptionSettlementType.ValueType  # 1
"""Поставочный тип опциона."""
OPTION_EXECUTION_TYPE_CASH_SETTLEMENT: OptionSettlementType.ValueType  # 2
"""Расчетный тип опциона."""
global___OptionSettlementType = OptionSettlementType

class _InstrumentIdType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _InstrumentIdTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_InstrumentIdType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INSTRUMENT_ID_UNSPECIFIED: _InstrumentIdType.ValueType  # 0
    """Значение не определено."""
    INSTRUMENT_ID_TYPE_FIGI: _InstrumentIdType.ValueType  # 1
    """FIGI."""
    INSTRUMENT_ID_TYPE_TICKER: _InstrumentIdType.ValueType  # 2
    """Ticker."""
    INSTRUMENT_ID_TYPE_UID: _InstrumentIdType.ValueType  # 3
    """Уникальный идентификатор."""
    INSTRUMENT_ID_TYPE_POSITION_UID: _InstrumentIdType.ValueType  # 4
    """Идентификатор позиции."""

class InstrumentIdType(_InstrumentIdType, metaclass=_InstrumentIdTypeEnumTypeWrapper):
    """Тип идентификатора инструмента. [Подробнее об идентификации инструментов](./faq_identification/)."""

INSTRUMENT_ID_UNSPECIFIED: InstrumentIdType.ValueType  # 0
"""Значение не определено."""
INSTRUMENT_ID_TYPE_FIGI: InstrumentIdType.ValueType  # 1
"""FIGI."""
INSTRUMENT_ID_TYPE_TICKER: InstrumentIdType.ValueType  # 2
"""Ticker."""
INSTRUMENT_ID_TYPE_UID: InstrumentIdType.ValueType  # 3
"""Уникальный идентификатор."""
INSTRUMENT_ID_TYPE_POSITION_UID: InstrumentIdType.ValueType  # 4
"""Идентификатор позиции."""
global___InstrumentIdType = InstrumentIdType

class _ShareType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ShareTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ShareType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SHARE_TYPE_UNSPECIFIED: _ShareType.ValueType  # 0
    """Значение не определено."""
    SHARE_TYPE_COMMON: _ShareType.ValueType  # 1
    """Обыкновенная."""
    SHARE_TYPE_PREFERRED: _ShareType.ValueType  # 2
    """Привилегированная."""
    SHARE_TYPE_ADR: _ShareType.ValueType  # 3
    """Американские депозитарные расписки."""
    SHARE_TYPE_GDR: _ShareType.ValueType  # 4
    """Глобальные депозитарные расписки."""
    SHARE_TYPE_MLP: _ShareType.ValueType  # 5
    """Товарищество с ограниченной ответственностью."""
    SHARE_TYPE_NY_REG_SHRS: _ShareType.ValueType  # 6
    """Акции из реестра Нью-Йорка."""
    SHARE_TYPE_CLOSED_END_FUND: _ShareType.ValueType  # 7
    """Закрытый инвестиционный фонд."""
    SHARE_TYPE_REIT: _ShareType.ValueType  # 8
    """Траст недвижимости."""

class ShareType(_ShareType, metaclass=_ShareTypeEnumTypeWrapper):
    """Тип акций."""

SHARE_TYPE_UNSPECIFIED: ShareType.ValueType  # 0
"""Значение не определено."""
SHARE_TYPE_COMMON: ShareType.ValueType  # 1
"""Обыкновенная."""
SHARE_TYPE_PREFERRED: ShareType.ValueType  # 2
"""Привилегированная."""
SHARE_TYPE_ADR: ShareType.ValueType  # 3
"""Американские депозитарные расписки."""
SHARE_TYPE_GDR: ShareType.ValueType  # 4
"""Глобальные депозитарные расписки."""
SHARE_TYPE_MLP: ShareType.ValueType  # 5
"""Товарищество с ограниченной ответственностью."""
SHARE_TYPE_NY_REG_SHRS: ShareType.ValueType  # 6
"""Акции из реестра Нью-Йорка."""
SHARE_TYPE_CLOSED_END_FUND: ShareType.ValueType  # 7
"""Закрытый инвестиционный фонд."""
SHARE_TYPE_REIT: ShareType.ValueType  # 8
"""Траст недвижимости."""
global___ShareType = ShareType

class _AssetType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AssetTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AssetType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ASSET_TYPE_UNSPECIFIED: _AssetType.ValueType  # 0
    """Тип не определен."""
    ASSET_TYPE_CURRENCY: _AssetType.ValueType  # 1
    """Валюта."""
    ASSET_TYPE_COMMODITY: _AssetType.ValueType  # 2
    """Товар."""
    ASSET_TYPE_INDEX: _AssetType.ValueType  # 3
    """Индекс."""
    ASSET_TYPE_SECURITY: _AssetType.ValueType  # 4
    """Ценная бумага."""

class AssetType(_AssetType, metaclass=_AssetTypeEnumTypeWrapper):
    """Тип актива."""

ASSET_TYPE_UNSPECIFIED: AssetType.ValueType  # 0
"""Тип не определен."""
ASSET_TYPE_CURRENCY: AssetType.ValueType  # 1
"""Валюта."""
ASSET_TYPE_COMMODITY: AssetType.ValueType  # 2
"""Товар."""
ASSET_TYPE_INDEX: AssetType.ValueType  # 3
"""Индекс."""
ASSET_TYPE_SECURITY: AssetType.ValueType  # 4
"""Ценная бумага."""
global___AssetType = AssetType

class _StructuredProductType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _StructuredProductTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_StructuredProductType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SP_TYPE_UNSPECIFIED: _StructuredProductType.ValueType  # 0
    """Тип не определен."""
    SP_TYPE_DELIVERABLE: _StructuredProductType.ValueType  # 1
    """Поставочный."""
    SP_TYPE_NON_DELIVERABLE: _StructuredProductType.ValueType  # 2
    """Беспоставочный."""

class StructuredProductType(_StructuredProductType, metaclass=_StructuredProductTypeEnumTypeWrapper):
    """Тип структурной ноты."""

SP_TYPE_UNSPECIFIED: StructuredProductType.ValueType  # 0
"""Тип не определен."""
SP_TYPE_DELIVERABLE: StructuredProductType.ValueType  # 1
"""Поставочный."""
SP_TYPE_NON_DELIVERABLE: StructuredProductType.ValueType  # 2
"""Беспоставочный."""
global___StructuredProductType = StructuredProductType

class _EditFavoritesActionType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _EditFavoritesActionTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_EditFavoritesActionType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    EDIT_FAVORITES_ACTION_TYPE_UNSPECIFIED: _EditFavoritesActionType.ValueType  # 0
    """Тип не определен."""
    EDIT_FAVORITES_ACTION_TYPE_ADD: _EditFavoritesActionType.ValueType  # 1
    """Добавить в список."""
    EDIT_FAVORITES_ACTION_TYPE_DEL: _EditFavoritesActionType.ValueType  # 2
    """Удалить из списка."""

class EditFavoritesActionType(_EditFavoritesActionType, metaclass=_EditFavoritesActionTypeEnumTypeWrapper):
    """Тип действия со списком избранных инструментов."""

EDIT_FAVORITES_ACTION_TYPE_UNSPECIFIED: EditFavoritesActionType.ValueType  # 0
"""Тип не определен."""
EDIT_FAVORITES_ACTION_TYPE_ADD: EditFavoritesActionType.ValueType  # 1
"""Добавить в список."""
EDIT_FAVORITES_ACTION_TYPE_DEL: EditFavoritesActionType.ValueType  # 2
"""Удалить из списка."""
global___EditFavoritesActionType = EditFavoritesActionType

class _Recommendation:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _RecommendationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Recommendation.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    RECOMMENDATION_UNSPECIFIED: _Recommendation.ValueType  # 0
    """Не определено."""
    RECOMMENDATION_BUY: _Recommendation.ValueType  # 1
    """Покупать."""
    RECOMMENDATION_HOLD: _Recommendation.ValueType  # 2
    """Держать."""
    RECOMMENDATION_SELL: _Recommendation.ValueType  # 3
    """Продавать."""

class Recommendation(_Recommendation, metaclass=_RecommendationEnumTypeWrapper): ...

RECOMMENDATION_UNSPECIFIED: Recommendation.ValueType  # 0
"""Не определено."""
RECOMMENDATION_BUY: Recommendation.ValueType  # 1
"""Покупать."""
RECOMMENDATION_HOLD: Recommendation.ValueType  # 2
"""Держать."""
RECOMMENDATION_SELL: Recommendation.ValueType  # 3
"""Продавать."""
global___Recommendation = Recommendation

class _RiskLevel:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _RiskLevelEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_RiskLevel.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    RISK_LEVEL_UNSPECIFIED: _RiskLevel.ValueType  # 0
    """Не указан."""
    RISK_LEVEL_LOW: _RiskLevel.ValueType  # 1
    """Низкий уровень риска."""
    RISK_LEVEL_MODERATE: _RiskLevel.ValueType  # 2
    """Средний уровень риска."""
    RISK_LEVEL_HIGH: _RiskLevel.ValueType  # 3
    """Высокий уровень риска."""

class RiskLevel(_RiskLevel, metaclass=_RiskLevelEnumTypeWrapper):
    """Уровень риска облигации."""

RISK_LEVEL_UNSPECIFIED: RiskLevel.ValueType  # 0
"""Не указан."""
RISK_LEVEL_LOW: RiskLevel.ValueType  # 1
"""Низкий уровень риска."""
RISK_LEVEL_MODERATE: RiskLevel.ValueType  # 2
"""Средний уровень риска."""
RISK_LEVEL_HIGH: RiskLevel.ValueType  # 3
"""Высокий уровень риска."""
global___RiskLevel = RiskLevel

class _BondType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _BondTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_BondType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    BOND_TYPE_UNSPECIFIED: _BondType.ValueType  # 0
    """Тип облигации не определен."""
    BOND_TYPE_REPLACED: _BondType.ValueType  # 1
    """Замещающая облигация."""

class BondType(_BondType, metaclass=_BondTypeEnumTypeWrapper): ...

BOND_TYPE_UNSPECIFIED: BondType.ValueType  # 0
"""Тип облигации не определен."""
BOND_TYPE_REPLACED: BondType.ValueType  # 1
"""Замещающая облигация."""
global___BondType = BondType

class _InstrumentExchangeType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _InstrumentExchangeTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_InstrumentExchangeType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INSTRUMENT_EXCHANGE_UNSPECIFIED: _InstrumentExchangeType.ValueType  # 0
    """Площадка торговли не определена."""
    INSTRUMENT_EXCHANGE_DEALER: _InstrumentExchangeType.ValueType  # 1
    """Бумага, торгуемая у дилера."""

class InstrumentExchangeType(_InstrumentExchangeType, metaclass=_InstrumentExchangeTypeEnumTypeWrapper):
    """Площадка торговли."""

INSTRUMENT_EXCHANGE_UNSPECIFIED: InstrumentExchangeType.ValueType  # 0
"""Площадка торговли не определена."""
INSTRUMENT_EXCHANGE_DEALER: InstrumentExchangeType.ValueType  # 1
"""Бумага, торгуемая у дилера."""
global___InstrumentExchangeType = InstrumentExchangeType

@typing.final
class TradingSchedulesRequest(google.protobuf.message.Message):
    """Запрос расписания торгов."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXCHANGE_FIELD_NUMBER: builtins.int
    FROM_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    exchange: builtins.str
    """Наименование биржи или расчетного календаря. <br/>Если не передается, возвращается информация по всем доступным торговым площадкам."""
    @property
    def to(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Окончание периода по UTC."""

    def __init__(
        self,
        *,
        exchange: builtins.str | None = ...,
        to: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_exchange", b"_exchange", "_from", b"_from", "_to", b"_to", "exchange", b"exchange", "from", b"from", "to", b"to"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_exchange", b"_exchange", "_from", b"_from", "_to", b"_to", "exchange", b"exchange", "from", b"from", "to", b"to"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_exchange", b"_exchange"]) -> typing.Literal["exchange"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_from", b"_from"]) -> typing.Literal["from"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_to", b"_to"]) -> typing.Literal["to"] | None: ...

global___TradingSchedulesRequest = TradingSchedulesRequest

@typing.final
class TradingSchedulesResponse(google.protobuf.message.Message):
    """Список торговых площадок."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXCHANGES_FIELD_NUMBER: builtins.int
    @property
    def exchanges(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TradingSchedule]:
        """Список торговых площадок и режимов торгов."""

    def __init__(
        self,
        *,
        exchanges: collections.abc.Iterable[global___TradingSchedule] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["exchanges", b"exchanges"]) -> None: ...

global___TradingSchedulesResponse = TradingSchedulesResponse

@typing.final
class TradingSchedule(google.protobuf.message.Message):
    """Данные по торговой площадке."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXCHANGE_FIELD_NUMBER: builtins.int
    DAYS_FIELD_NUMBER: builtins.int
    exchange: builtins.str
    """Наименование торговой площадки."""
    @property
    def days(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TradingDay]:
        """Массив с торговыми и неторговыми днями."""

    def __init__(
        self,
        *,
        exchange: builtins.str = ...,
        days: collections.abc.Iterable[global___TradingDay] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["days", b"days", "exchange", b"exchange"]) -> None: ...

global___TradingSchedule = TradingSchedule

@typing.final
class TradingDay(google.protobuf.message.Message):
    """Информация о времени торгов."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATE_FIELD_NUMBER: builtins.int
    IS_TRADING_DAY_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    OPENING_AUCTION_START_TIME_FIELD_NUMBER: builtins.int
    CLOSING_AUCTION_END_TIME_FIELD_NUMBER: builtins.int
    EVENING_OPENING_AUCTION_START_TIME_FIELD_NUMBER: builtins.int
    EVENING_START_TIME_FIELD_NUMBER: builtins.int
    EVENING_END_TIME_FIELD_NUMBER: builtins.int
    CLEARING_START_TIME_FIELD_NUMBER: builtins.int
    CLEARING_END_TIME_FIELD_NUMBER: builtins.int
    PREMARKET_START_TIME_FIELD_NUMBER: builtins.int
    PREMARKET_END_TIME_FIELD_NUMBER: builtins.int
    CLOSING_AUCTION_START_TIME_FIELD_NUMBER: builtins.int
    OPENING_AUCTION_END_TIME_FIELD_NUMBER: builtins.int
    INTERVALS_FIELD_NUMBER: builtins.int
    is_trading_day: builtins.bool
    """Признак торгового дня на бирже."""
    @property
    def date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата."""

    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время начала торгов по UTC."""

    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время окончания торгов по UTC."""

    @property
    def opening_auction_start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время начала аукциона открытия по UTC."""

    @property
    def closing_auction_end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время окончания аукциона закрытия по UTC."""

    @property
    def evening_opening_auction_start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время начала аукциона открытия вечерней сессии по UTC."""

    @property
    def evening_start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время начала вечерней сессии по UTC."""

    @property
    def evening_end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время окончания вечерней сессии по UTC."""

    @property
    def clearing_start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время начала основного клиринга по UTC."""

    @property
    def clearing_end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время окончания основного клиринга по UTC."""

    @property
    def premarket_start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время начала премаркета по UTC."""

    @property
    def premarket_end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время окончания премаркета по UTC."""

    @property
    def closing_auction_start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время начала аукциона закрытия по UTC."""

    @property
    def opening_auction_end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время окончания аукциона открытия по UTC."""

    @property
    def intervals(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TradingInterval]:
        """Торговые интервалы."""

    def __init__(
        self,
        *,
        date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        is_trading_day: builtins.bool = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        opening_auction_start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        closing_auction_end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        evening_opening_auction_start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        evening_start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        evening_end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        clearing_start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        clearing_end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        premarket_start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        premarket_end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        closing_auction_start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        opening_auction_end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        intervals: collections.abc.Iterable[global___TradingInterval] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["clearing_end_time", b"clearing_end_time", "clearing_start_time", b"clearing_start_time", "closing_auction_end_time", b"closing_auction_end_time", "closing_auction_start_time", b"closing_auction_start_time", "date", b"date", "end_time", b"end_time", "evening_end_time", b"evening_end_time", "evening_opening_auction_start_time", b"evening_opening_auction_start_time", "evening_start_time", b"evening_start_time", "opening_auction_end_time", b"opening_auction_end_time", "opening_auction_start_time", b"opening_auction_start_time", "premarket_end_time", b"premarket_end_time", "premarket_start_time", b"premarket_start_time", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["clearing_end_time", b"clearing_end_time", "clearing_start_time", b"clearing_start_time", "closing_auction_end_time", b"closing_auction_end_time", "closing_auction_start_time", b"closing_auction_start_time", "date", b"date", "end_time", b"end_time", "evening_end_time", b"evening_end_time", "evening_opening_auction_start_time", b"evening_opening_auction_start_time", "evening_start_time", b"evening_start_time", "intervals", b"intervals", "is_trading_day", b"is_trading_day", "opening_auction_end_time", b"opening_auction_end_time", "opening_auction_start_time", b"opening_auction_start_time", "premarket_end_time", b"premarket_end_time", "premarket_start_time", b"premarket_start_time", "start_time", b"start_time"]) -> None: ...

global___TradingDay = TradingDay

@typing.final
class InstrumentRequest(google.protobuf.message.Message):
    """Запрос получения инструмента по идентификатору."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_TYPE_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    id_type: global___InstrumentIdType.ValueType
    """Тип идентификатора инструмента. Возможные значения — `figi`, `ticker`. [Подробнее об идентификации инструментов](./faq_identification/)."""
    class_code: builtins.str
    """Идентификатор `class_code`. Обязательный, если `id_type = ticker`."""
    id: builtins.str
    """Идентификатор запрашиваемого инструмента."""
    def __init__(
        self,
        *,
        id_type: global___InstrumentIdType.ValueType = ...,
        class_code: builtins.str | None = ...,
        id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_class_code", b"_class_code", "class_code", b"class_code"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_class_code", b"_class_code", "class_code", b"class_code", "id", b"id", "id_type", b"id_type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_class_code", b"_class_code"]) -> typing.Literal["class_code"] | None: ...

global___InstrumentRequest = InstrumentRequest

@typing.final
class InstrumentsRequest(google.protobuf.message.Message):
    """Запрос получения инструментов."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_STATUS_FIELD_NUMBER: builtins.int
    INSTRUMENT_EXCHANGE_FIELD_NUMBER: builtins.int
    instrument_status: tinkoff.invest.grpc.common_pb2.InstrumentStatus.ValueType
    """Статус запрашиваемых инструментов. [Возможные значения](#instrumentstatus)."""
    instrument_exchange: global___InstrumentExchangeType.ValueType
    """Тип площадки торговли. [Возможные значения](#instrumentexchangetype)."""
    def __init__(
        self,
        *,
        instrument_status: tinkoff.invest.grpc.common_pb2.InstrumentStatus.ValueType | None = ...,
        instrument_exchange: global___InstrumentExchangeType.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_instrument_exchange", b"_instrument_exchange", "_instrument_status", b"_instrument_status", "instrument_exchange", b"instrument_exchange", "instrument_status", b"instrument_status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_instrument_exchange", b"_instrument_exchange", "_instrument_status", b"_instrument_status", "instrument_exchange", b"instrument_exchange", "instrument_status", b"instrument_status"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_instrument_exchange", b"_instrument_exchange"]) -> typing.Literal["instrument_exchange"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_instrument_status", b"_instrument_status"]) -> typing.Literal["instrument_status"] | None: ...

global___InstrumentsRequest = InstrumentsRequest

@typing.final
class FilterOptionsRequest(google.protobuf.message.Message):
    """Параметры фильтрации опционов."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BASIC_ASSET_UID_FIELD_NUMBER: builtins.int
    BASIC_ASSET_POSITION_UID_FIELD_NUMBER: builtins.int
    basic_asset_uid: builtins.str
    """Идентификатор базового актива опциона.  Обязательный параметр."""
    basic_asset_position_uid: builtins.str
    """Идентификатор позиции базового актива опциона."""
    def __init__(
        self,
        *,
        basic_asset_uid: builtins.str | None = ...,
        basic_asset_position_uid: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_basic_asset_position_uid", b"_basic_asset_position_uid", "_basic_asset_uid", b"_basic_asset_uid", "basic_asset_position_uid", b"basic_asset_position_uid", "basic_asset_uid", b"basic_asset_uid"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_basic_asset_position_uid", b"_basic_asset_position_uid", "_basic_asset_uid", b"_basic_asset_uid", "basic_asset_position_uid", b"basic_asset_position_uid", "basic_asset_uid", b"basic_asset_uid"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_basic_asset_position_uid", b"_basic_asset_position_uid"]) -> typing.Literal["basic_asset_position_uid"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_basic_asset_uid", b"_basic_asset_uid"]) -> typing.Literal["basic_asset_uid"] | None: ...

global___FilterOptionsRequest = FilterOptionsRequest

@typing.final
class BondResponse(google.protobuf.message.Message):
    """Информация об облигации."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_FIELD_NUMBER: builtins.int
    @property
    def instrument(self) -> global___Bond:
        """Информация об облигации."""

    def __init__(
        self,
        *,
        instrument: global___Bond | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["instrument", b"instrument"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["instrument", b"instrument"]) -> None: ...

global___BondResponse = BondResponse

@typing.final
class BondsResponse(google.protobuf.message.Message):
    """Список облигаций."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENTS_FIELD_NUMBER: builtins.int
    @property
    def instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Bond]:
        """Массив облигаций."""

    def __init__(
        self,
        *,
        instruments: collections.abc.Iterable[global___Bond] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instruments", b"instruments"]) -> None: ...

global___BondsResponse = BondsResponse

@typing.final
class GetBondCouponsRequest(google.protobuf.message.Message):
    """Запрос купонов по облигации."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    FROM_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    instrument_id: builtins.str
    """Идентификатор инструмента — `figi` или `instrument_uid`."""
    @property
    def to(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Окончание запрашиваемого периода по UTC. Фильтрация по `coupon_date` — дата выплаты купона."""

    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        to: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        instrument_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_from", b"_from", "_to", b"_to", "from", b"from", "to", b"to"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_from", b"_from", "_to", b"_to", "figi", b"figi", "from", b"from", "instrument_id", b"instrument_id", "to", b"to"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_from", b"_from"]) -> typing.Literal["from"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_to", b"_to"]) -> typing.Literal["to"] | None: ...

global___GetBondCouponsRequest = GetBondCouponsRequest

@typing.final
class GetBondCouponsResponse(google.protobuf.message.Message):
    """Купоны по облигации."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EVENTS_FIELD_NUMBER: builtins.int
    @property
    def events(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Coupon]: ...
    def __init__(
        self,
        *,
        events: collections.abc.Iterable[global___Coupon] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["events", b"events"]) -> None: ...

global___GetBondCouponsResponse = GetBondCouponsResponse

@typing.final
class GetBondEventsRequest(google.protobuf.message.Message):
    """События по облигации."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _EventType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EventTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[GetBondEventsRequest._EventType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        EVENT_TYPE_UNSPECIFIED: GetBondEventsRequest._EventType.ValueType  # 0
        """Неопределенное значение."""
        EVENT_TYPE_CPN: GetBondEventsRequest._EventType.ValueType  # 1
        """Купон."""
        EVENT_TYPE_CALL: GetBondEventsRequest._EventType.ValueType  # 2
        """Опцион (оферта)."""
        EVENT_TYPE_MTY: GetBondEventsRequest._EventType.ValueType  # 3
        """Погашение."""
        EVENT_TYPE_CONV: GetBondEventsRequest._EventType.ValueType  # 4
        """Конвертация."""

    class EventType(_EventType, metaclass=_EventTypeEnumTypeWrapper): ...
    EVENT_TYPE_UNSPECIFIED: GetBondEventsRequest.EventType.ValueType  # 0
    """Неопределенное значение."""
    EVENT_TYPE_CPN: GetBondEventsRequest.EventType.ValueType  # 1
    """Купон."""
    EVENT_TYPE_CALL: GetBondEventsRequest.EventType.ValueType  # 2
    """Опцион (оферта)."""
    EVENT_TYPE_MTY: GetBondEventsRequest.EventType.ValueType  # 3
    """Погашение."""
    EVENT_TYPE_CONV: GetBondEventsRequest.EventType.ValueType  # 4
    """Конвертация."""

    FROM_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    instrument_id: builtins.str
    """Идентификатор инструмента — `figi` или `instrument_uid`."""
    type: global___GetBondEventsRequest.EventType.ValueType
    """Тип события"""
    @property
    def to(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Окончание запрашиваемого периода по UTC."""

    def __init__(
        self,
        *,
        to: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        instrument_id: builtins.str = ...,
        type: global___GetBondEventsRequest.EventType.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_from", b"_from", "_to", b"_to", "from", b"from", "to", b"to"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_from", b"_from", "_to", b"_to", "from", b"from", "instrument_id", b"instrument_id", "to", b"to", "type", b"type"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_from", b"_from"]) -> typing.Literal["from"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_to", b"_to"]) -> typing.Literal["to"] | None: ...

global___GetBondEventsRequest = GetBondEventsRequest

@typing.final
class GetBondEventsResponse(google.protobuf.message.Message):
    """Объект передачи информации о событии облигации."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class BondEvent(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        INSTRUMENT_ID_FIELD_NUMBER: builtins.int
        EVENT_NUMBER_FIELD_NUMBER: builtins.int
        EVENT_DATE_FIELD_NUMBER: builtins.int
        EVENT_TYPE_FIELD_NUMBER: builtins.int
        EVENT_TOTAL_VOL_FIELD_NUMBER: builtins.int
        FIX_DATE_FIELD_NUMBER: builtins.int
        RATE_DATE_FIELD_NUMBER: builtins.int
        DEFAULT_DATE_FIELD_NUMBER: builtins.int
        REAL_PAY_DATE_FIELD_NUMBER: builtins.int
        PAY_DATE_FIELD_NUMBER: builtins.int
        PAY_ONE_BOND_FIELD_NUMBER: builtins.int
        MONEY_FLOW_VAL_FIELD_NUMBER: builtins.int
        EXECUTION_FIELD_NUMBER: builtins.int
        OPERATION_TYPE_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        NOTE_FIELD_NUMBER: builtins.int
        CONVERT_TO_FIN_TOOL_ID_FIELD_NUMBER: builtins.int
        COUPON_START_DATE_FIELD_NUMBER: builtins.int
        COUPON_END_DATE_FIELD_NUMBER: builtins.int
        COUPON_PERIOD_FIELD_NUMBER: builtins.int
        COUPON_INTEREST_RATE_FIELD_NUMBER: builtins.int
        instrument_id: builtins.str
        """Идентификатор инструмента."""
        event_number: builtins.int
        """Номер события для данного типа события."""
        event_type: global___GetBondEventsRequest.EventType.ValueType
        """Тип события."""
        execution: builtins.str
        """Признак исполнения."""
        operation_type: builtins.str
        """Тип операции."""
        note: builtins.str
        """Примечание."""
        convert_to_fin_tool_id: builtins.str
        """ID выпуска бумаг, в который произведена конвертация (для конвертаций)."""
        coupon_period: builtins.int
        """Купонный период."""
        @property
        def event_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Дата события."""

        @property
        def event_total_vol(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Полное количество бумаг, задействованных в событии."""

        @property
        def fix_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Дата фиксации владельцев для участия в событии."""

        @property
        def rate_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Дата определения даты или факта события."""

        @property
        def default_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Дата дефолта, если применимо."""

        @property
        def real_pay_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Дата реального исполнения обязательства."""

        @property
        def pay_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Дата выплаты."""

        @property
        def pay_one_bond(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
            """Выплата на одну облигацию."""

        @property
        def money_flow_val(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
            """Выплаты на все бумаги, задействованные в событии."""

        @property
        def value(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Стоимость операции — ставка купона, доля номинала, цена выкупа или коэффициент конвертации."""

        @property
        def coupon_start_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Начало купонного периода."""

        @property
        def coupon_end_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Окончание купонного периода."""

        @property
        def coupon_interest_rate(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Ставка купона, процентов годовых."""

        def __init__(
            self,
            *,
            instrument_id: builtins.str = ...,
            event_number: builtins.int = ...,
            event_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            event_type: global___GetBondEventsRequest.EventType.ValueType = ...,
            event_total_vol: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            fix_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            rate_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            default_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            real_pay_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            pay_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            pay_one_bond: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
            money_flow_val: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
            execution: builtins.str = ...,
            operation_type: builtins.str = ...,
            value: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            note: builtins.str = ...,
            convert_to_fin_tool_id: builtins.str = ...,
            coupon_start_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            coupon_end_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            coupon_period: builtins.int = ...,
            coupon_interest_rate: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["coupon_end_date", b"coupon_end_date", "coupon_interest_rate", b"coupon_interest_rate", "coupon_start_date", b"coupon_start_date", "default_date", b"default_date", "event_date", b"event_date", "event_total_vol", b"event_total_vol", "fix_date", b"fix_date", "money_flow_val", b"money_flow_val", "pay_date", b"pay_date", "pay_one_bond", b"pay_one_bond", "rate_date", b"rate_date", "real_pay_date", b"real_pay_date", "value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["convert_to_fin_tool_id", b"convert_to_fin_tool_id", "coupon_end_date", b"coupon_end_date", "coupon_interest_rate", b"coupon_interest_rate", "coupon_period", b"coupon_period", "coupon_start_date", b"coupon_start_date", "default_date", b"default_date", "event_date", b"event_date", "event_number", b"event_number", "event_total_vol", b"event_total_vol", "event_type", b"event_type", "execution", b"execution", "fix_date", b"fix_date", "instrument_id", b"instrument_id", "money_flow_val", b"money_flow_val", "note", b"note", "operation_type", b"operation_type", "pay_date", b"pay_date", "pay_one_bond", b"pay_one_bond", "rate_date", b"rate_date", "real_pay_date", b"real_pay_date", "value", b"value"]) -> None: ...

    EVENTS_FIELD_NUMBER: builtins.int
    @property
    def events(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetBondEventsResponse.BondEvent]: ...
    def __init__(
        self,
        *,
        events: collections.abc.Iterable[global___GetBondEventsResponse.BondEvent] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["events", b"events"]) -> None: ...

global___GetBondEventsResponse = GetBondEventsResponse

@typing.final
class Coupon(google.protobuf.message.Message):
    """Объект передачи информации о купоне облигации."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    COUPON_DATE_FIELD_NUMBER: builtins.int
    COUPON_NUMBER_FIELD_NUMBER: builtins.int
    FIX_DATE_FIELD_NUMBER: builtins.int
    PAY_ONE_BOND_FIELD_NUMBER: builtins.int
    COUPON_TYPE_FIELD_NUMBER: builtins.int
    COUPON_START_DATE_FIELD_NUMBER: builtins.int
    COUPON_END_DATE_FIELD_NUMBER: builtins.int
    COUPON_PERIOD_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    coupon_number: builtins.int
    """Номер купона."""
    coupon_type: global___CouponType.ValueType
    """Тип купона."""
    coupon_period: builtins.int
    """Купонный период в днях."""
    @property
    def coupon_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата выплаты купона."""

    @property
    def fix_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата фиксации реестра для выплаты купона — опционально."""

    @property
    def pay_one_bond(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Выплата на одну облигацию."""

    @property
    def coupon_start_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Начало купонного периода."""

    @property
    def coupon_end_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Окончание купонного периода."""

    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        coupon_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        coupon_number: builtins.int = ...,
        fix_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        pay_one_bond: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        coupon_type: global___CouponType.ValueType = ...,
        coupon_start_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        coupon_end_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        coupon_period: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["coupon_date", b"coupon_date", "coupon_end_date", b"coupon_end_date", "coupon_start_date", b"coupon_start_date", "fix_date", b"fix_date", "pay_one_bond", b"pay_one_bond"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["coupon_date", b"coupon_date", "coupon_end_date", b"coupon_end_date", "coupon_number", b"coupon_number", "coupon_period", b"coupon_period", "coupon_start_date", b"coupon_start_date", "coupon_type", b"coupon_type", "figi", b"figi", "fix_date", b"fix_date", "pay_one_bond", b"pay_one_bond"]) -> None: ...

global___Coupon = Coupon

@typing.final
class CurrencyResponse(google.protobuf.message.Message):
    """Данные по валюте."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_FIELD_NUMBER: builtins.int
    @property
    def instrument(self) -> global___Currency:
        """Информация о валюте."""

    def __init__(
        self,
        *,
        instrument: global___Currency | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["instrument", b"instrument"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["instrument", b"instrument"]) -> None: ...

global___CurrencyResponse = CurrencyResponse

@typing.final
class CurrenciesResponse(google.protobuf.message.Message):
    """Данные по валютам."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENTS_FIELD_NUMBER: builtins.int
    @property
    def instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Currency]:
        """Массив валют."""

    def __init__(
        self,
        *,
        instruments: collections.abc.Iterable[global___Currency] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instruments", b"instruments"]) -> None: ...

global___CurrenciesResponse = CurrenciesResponse

@typing.final
class EtfResponse(google.protobuf.message.Message):
    """Данные по фонду."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_FIELD_NUMBER: builtins.int
    @property
    def instrument(self) -> global___Etf:
        """Информация о фонде."""

    def __init__(
        self,
        *,
        instrument: global___Etf | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["instrument", b"instrument"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["instrument", b"instrument"]) -> None: ...

global___EtfResponse = EtfResponse

@typing.final
class EtfsResponse(google.protobuf.message.Message):
    """Данные по фондам."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENTS_FIELD_NUMBER: builtins.int
    @property
    def instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Etf]:
        """Массив фондов."""

    def __init__(
        self,
        *,
        instruments: collections.abc.Iterable[global___Etf] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instruments", b"instruments"]) -> None: ...

global___EtfsResponse = EtfsResponse

@typing.final
class FutureResponse(google.protobuf.message.Message):
    """Данные по фьючерсу."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_FIELD_NUMBER: builtins.int
    @property
    def instrument(self) -> global___Future:
        """Информация о фьючерсу."""

    def __init__(
        self,
        *,
        instrument: global___Future | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["instrument", b"instrument"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["instrument", b"instrument"]) -> None: ...

global___FutureResponse = FutureResponse

@typing.final
class FuturesResponse(google.protobuf.message.Message):
    """Данные по фьючерсам."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENTS_FIELD_NUMBER: builtins.int
    @property
    def instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Future]:
        """Массив фьючерсов."""

    def __init__(
        self,
        *,
        instruments: collections.abc.Iterable[global___Future] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instruments", b"instruments"]) -> None: ...

global___FuturesResponse = FuturesResponse

@typing.final
class OptionResponse(google.protobuf.message.Message):
    """Данные по опциону."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_FIELD_NUMBER: builtins.int
    @property
    def instrument(self) -> global___Option:
        """Информация по опциону."""

    def __init__(
        self,
        *,
        instrument: global___Option | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["instrument", b"instrument"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["instrument", b"instrument"]) -> None: ...

global___OptionResponse = OptionResponse

@typing.final
class OptionsResponse(google.protobuf.message.Message):
    """Данные по опционам."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENTS_FIELD_NUMBER: builtins.int
    @property
    def instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Option]:
        """Массив данных по опциону."""

    def __init__(
        self,
        *,
        instruments: collections.abc.Iterable[global___Option] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instruments", b"instruments"]) -> None: ...

global___OptionsResponse = OptionsResponse

@typing.final
class Option(google.protobuf.message.Message):
    """Опцион."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UID_FIELD_NUMBER: builtins.int
    POSITION_UID_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    BASIC_ASSET_POSITION_UID_FIELD_NUMBER: builtins.int
    TRADING_STATUS_FIELD_NUMBER: builtins.int
    REAL_EXCHANGE_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    PAYMENT_TYPE_FIELD_NUMBER: builtins.int
    STYLE_FIELD_NUMBER: builtins.int
    SETTLEMENT_TYPE_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    CURRENCY_FIELD_NUMBER: builtins.int
    SETTLEMENT_CURRENCY_FIELD_NUMBER: builtins.int
    ASSET_TYPE_FIELD_NUMBER: builtins.int
    BASIC_ASSET_FIELD_NUMBER: builtins.int
    EXCHANGE_FIELD_NUMBER: builtins.int
    COUNTRY_OF_RISK_FIELD_NUMBER: builtins.int
    COUNTRY_OF_RISK_NAME_FIELD_NUMBER: builtins.int
    SECTOR_FIELD_NUMBER: builtins.int
    BRAND_FIELD_NUMBER: builtins.int
    LOT_FIELD_NUMBER: builtins.int
    BASIC_ASSET_SIZE_FIELD_NUMBER: builtins.int
    KLONG_FIELD_NUMBER: builtins.int
    KSHORT_FIELD_NUMBER: builtins.int
    DLONG_FIELD_NUMBER: builtins.int
    DSHORT_FIELD_NUMBER: builtins.int
    DLONG_MIN_FIELD_NUMBER: builtins.int
    DSHORT_MIN_FIELD_NUMBER: builtins.int
    MIN_PRICE_INCREMENT_FIELD_NUMBER: builtins.int
    STRIKE_PRICE_FIELD_NUMBER: builtins.int
    DLONG_CLIENT_FIELD_NUMBER: builtins.int
    DSHORT_CLIENT_FIELD_NUMBER: builtins.int
    EXPIRATION_DATE_FIELD_NUMBER: builtins.int
    FIRST_TRADE_DATE_FIELD_NUMBER: builtins.int
    LAST_TRADE_DATE_FIELD_NUMBER: builtins.int
    FIRST_1MIN_CANDLE_DATE_FIELD_NUMBER: builtins.int
    FIRST_1DAY_CANDLE_DATE_FIELD_NUMBER: builtins.int
    SHORT_ENABLED_FLAG_FIELD_NUMBER: builtins.int
    FOR_IIS_FLAG_FIELD_NUMBER: builtins.int
    OTC_FLAG_FIELD_NUMBER: builtins.int
    BUY_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    SELL_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    FOR_QUAL_INVESTOR_FLAG_FIELD_NUMBER: builtins.int
    WEEKEND_FLAG_FIELD_NUMBER: builtins.int
    BLOCKED_TCA_FLAG_FIELD_NUMBER: builtins.int
    API_TRADE_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    REQUIRED_TESTS_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """Уникальный идентификатор инструмента."""
    position_uid: builtins.str
    """Уникальный идентификатор позиции."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код."""
    basic_asset_position_uid: builtins.str
    """Уникальный идентификатор позиции основного инструмента."""
    trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType
    """Текущий режим торгов инструмента."""
    real_exchange: tinkoff.invest.grpc.common_pb2.RealExchange.ValueType
    """Реальная площадка исполнения расчетов (биржа)."""
    direction: global___OptionDirection.ValueType
    """Направление опциона."""
    payment_type: global___OptionPaymentType.ValueType
    """Тип расчетов по опциону."""
    style: global___OptionStyle.ValueType
    """Стиль опциона."""
    settlement_type: global___OptionSettlementType.ValueType
    """Способ исполнения опциона."""
    name: builtins.str
    """Название инструмента."""
    currency: builtins.str
    """Валюта."""
    settlement_currency: builtins.str
    """Валюта, в которой оценивается контракт."""
    asset_type: builtins.str
    """Тип актива."""
    basic_asset: builtins.str
    """Основной актив."""
    exchange: builtins.str
    """Tорговая площадка (секция биржи)."""
    country_of_risk: builtins.str
    """Код страны рисков."""
    country_of_risk_name: builtins.str
    """Наименование страны рисков."""
    sector: builtins.str
    """Сектор экономики."""
    lot: builtins.int
    """Количество бумаг в лоте."""
    short_enabled_flag: builtins.bool
    """Признак доступности для операций шорт."""
    for_iis_flag: builtins.bool
    """Возможность покупки или продажи на ИИС."""
    otc_flag: builtins.bool
    """Флаг, используемый ранее для определения внебиржевых инструментов. На данный момент не используется для торгуемых через API инструментов. Может использоваться как фильтр для операций, совершавшихся некоторое время назад на ОТС площадке."""
    buy_available_flag: builtins.bool
    """Признак доступности для покупки."""
    sell_available_flag: builtins.bool
    """Признак доступности для продажи."""
    for_qual_investor_flag: builtins.bool
    """Флаг, отображающий доступность торговли инструментом только для квалифицированных инвесторов."""
    weekend_flag: builtins.bool
    """Флаг, отображающий доступность торговли инструментом по выходным."""
    blocked_tca_flag: builtins.bool
    """Флаг заблокированного ТКС."""
    api_trade_available_flag: builtins.bool
    """Возможность торговать инструментом через API."""
    @property
    def brand(self) -> tinkoff.invest.grpc.common_pb2.BrandData:
        """Информация о бренде."""

    @property
    def basic_asset_size(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Размер основного актива."""

    @property
    def klong(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Коэффициент ставки риска длинной позиции по клиенту. 2 – клиент со стандартным уровнем риска (КСУР); 1 – клиент с повышенным уровнем риска (КПУР)."""

    @property
    def kshort(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Коэффициент ставки риска короткой позиции по клиенту. 2 – клиент со стандартным уровнем риска (КСУР); 1 – клиент с повышенным уровнем риска (КПУР)."""

    @property
    def dlong(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КСУР лонг. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КСУР шорт. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dlong_min(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КПУР лонг. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort_min(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КПУР шорт. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def min_price_increment(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Минимальный шаг цены."""

    @property
    def strike_price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Цена страйка."""

    @property
    def dlong_client(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска в лонг с учетом текущего уровня риска портфеля клиента. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort_client(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска в шорт с учетом текущего уровня риска портфеля клиента. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def expiration_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата истечения срока в формате UTC."""

    @property
    def first_trade_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата начала обращения контракта в формате UTC."""

    @property
    def last_trade_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата исполнения в формате UTC."""

    @property
    def first_1min_candle_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата первой минутной свечи в формате UTC."""

    @property
    def first_1day_candle_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата первой дневной свечи в формате UTC."""

    @property
    def required_tests(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Тесты, которые необходимо пройти клиенту, чтобы совершать сделки по инструменту."""

    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        position_uid: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        basic_asset_position_uid: builtins.str = ...,
        trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType = ...,
        real_exchange: tinkoff.invest.grpc.common_pb2.RealExchange.ValueType = ...,
        direction: global___OptionDirection.ValueType = ...,
        payment_type: global___OptionPaymentType.ValueType = ...,
        style: global___OptionStyle.ValueType = ...,
        settlement_type: global___OptionSettlementType.ValueType = ...,
        name: builtins.str = ...,
        currency: builtins.str = ...,
        settlement_currency: builtins.str = ...,
        asset_type: builtins.str = ...,
        basic_asset: builtins.str = ...,
        exchange: builtins.str = ...,
        country_of_risk: builtins.str = ...,
        country_of_risk_name: builtins.str = ...,
        sector: builtins.str = ...,
        brand: tinkoff.invest.grpc.common_pb2.BrandData | None = ...,
        lot: builtins.int = ...,
        basic_asset_size: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        klong: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        kshort: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dlong: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dlong_min: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort_min: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        min_price_increment: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        strike_price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        dlong_client: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort_client: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        expiration_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        first_trade_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_trade_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        first_1min_candle_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        first_1day_candle_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        short_enabled_flag: builtins.bool = ...,
        for_iis_flag: builtins.bool = ...,
        otc_flag: builtins.bool = ...,
        buy_available_flag: builtins.bool = ...,
        sell_available_flag: builtins.bool = ...,
        for_qual_investor_flag: builtins.bool = ...,
        weekend_flag: builtins.bool = ...,
        blocked_tca_flag: builtins.bool = ...,
        api_trade_available_flag: builtins.bool = ...,
        required_tests: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["basic_asset_size", b"basic_asset_size", "brand", b"brand", "dlong", b"dlong", "dlong_client", b"dlong_client", "dlong_min", b"dlong_min", "dshort", b"dshort", "dshort_client", b"dshort_client", "dshort_min", b"dshort_min", "expiration_date", b"expiration_date", "first_1day_candle_date", b"first_1day_candle_date", "first_1min_candle_date", b"first_1min_candle_date", "first_trade_date", b"first_trade_date", "klong", b"klong", "kshort", b"kshort", "last_trade_date", b"last_trade_date", "min_price_increment", b"min_price_increment", "strike_price", b"strike_price"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["api_trade_available_flag", b"api_trade_available_flag", "asset_type", b"asset_type", "basic_asset", b"basic_asset", "basic_asset_position_uid", b"basic_asset_position_uid", "basic_asset_size", b"basic_asset_size", "blocked_tca_flag", b"blocked_tca_flag", "brand", b"brand", "buy_available_flag", b"buy_available_flag", "class_code", b"class_code", "country_of_risk", b"country_of_risk", "country_of_risk_name", b"country_of_risk_name", "currency", b"currency", "direction", b"direction", "dlong", b"dlong", "dlong_client", b"dlong_client", "dlong_min", b"dlong_min", "dshort", b"dshort", "dshort_client", b"dshort_client", "dshort_min", b"dshort_min", "exchange", b"exchange", "expiration_date", b"expiration_date", "first_1day_candle_date", b"first_1day_candle_date", "first_1min_candle_date", b"first_1min_candle_date", "first_trade_date", b"first_trade_date", "for_iis_flag", b"for_iis_flag", "for_qual_investor_flag", b"for_qual_investor_flag", "klong", b"klong", "kshort", b"kshort", "last_trade_date", b"last_trade_date", "lot", b"lot", "min_price_increment", b"min_price_increment", "name", b"name", "otc_flag", b"otc_flag", "payment_type", b"payment_type", "position_uid", b"position_uid", "real_exchange", b"real_exchange", "required_tests", b"required_tests", "sector", b"sector", "sell_available_flag", b"sell_available_flag", "settlement_currency", b"settlement_currency", "settlement_type", b"settlement_type", "short_enabled_flag", b"short_enabled_flag", "strike_price", b"strike_price", "style", b"style", "ticker", b"ticker", "trading_status", b"trading_status", "uid", b"uid", "weekend_flag", b"weekend_flag"]) -> None: ...

global___Option = Option

@typing.final
class ShareResponse(google.protobuf.message.Message):
    """Данные по акции."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_FIELD_NUMBER: builtins.int
    @property
    def instrument(self) -> global___Share:
        """Информация об акции."""

    def __init__(
        self,
        *,
        instrument: global___Share | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["instrument", b"instrument"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["instrument", b"instrument"]) -> None: ...

global___ShareResponse = ShareResponse

@typing.final
class SharesResponse(google.protobuf.message.Message):
    """Данные по акциям."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENTS_FIELD_NUMBER: builtins.int
    @property
    def instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Share]:
        """Массив акций."""

    def __init__(
        self,
        *,
        instruments: collections.abc.Iterable[global___Share] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instruments", b"instruments"]) -> None: ...

global___SharesResponse = SharesResponse

@typing.final
class StructuredNoteResponse(google.protobuf.message.Message):
    """Данные по структурной ноте."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_FIELD_NUMBER: builtins.int
    @property
    def instrument(self) -> global___StructuredNote:
        """Информация о структурной ноте."""

    def __init__(
        self,
        *,
        instrument: global___StructuredNote | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["instrument", b"instrument"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["instrument", b"instrument"]) -> None: ...

global___StructuredNoteResponse = StructuredNoteResponse

@typing.final
class StructuredNotesResponse(google.protobuf.message.Message):
    """Данные по структурным нотам."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENTS_FIELD_NUMBER: builtins.int
    @property
    def instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StructuredNote]:
        """Массив структурных нот."""

    def __init__(
        self,
        *,
        instruments: collections.abc.Iterable[global___StructuredNote] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instruments", b"instruments"]) -> None: ...

global___StructuredNotesResponse = StructuredNotesResponse

@typing.final
class Bond(google.protobuf.message.Message):
    """Объект передачи информации об облигации."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    ISIN_FIELD_NUMBER: builtins.int
    LOT_FIELD_NUMBER: builtins.int
    CURRENCY_FIELD_NUMBER: builtins.int
    KLONG_FIELD_NUMBER: builtins.int
    KSHORT_FIELD_NUMBER: builtins.int
    DLONG_FIELD_NUMBER: builtins.int
    DSHORT_FIELD_NUMBER: builtins.int
    DLONG_MIN_FIELD_NUMBER: builtins.int
    DSHORT_MIN_FIELD_NUMBER: builtins.int
    SHORT_ENABLED_FLAG_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    EXCHANGE_FIELD_NUMBER: builtins.int
    COUPON_QUANTITY_PER_YEAR_FIELD_NUMBER: builtins.int
    MATURITY_DATE_FIELD_NUMBER: builtins.int
    NOMINAL_FIELD_NUMBER: builtins.int
    INITIAL_NOMINAL_FIELD_NUMBER: builtins.int
    STATE_REG_DATE_FIELD_NUMBER: builtins.int
    PLACEMENT_DATE_FIELD_NUMBER: builtins.int
    PLACEMENT_PRICE_FIELD_NUMBER: builtins.int
    ACI_VALUE_FIELD_NUMBER: builtins.int
    COUNTRY_OF_RISK_FIELD_NUMBER: builtins.int
    COUNTRY_OF_RISK_NAME_FIELD_NUMBER: builtins.int
    SECTOR_FIELD_NUMBER: builtins.int
    ISSUE_KIND_FIELD_NUMBER: builtins.int
    ISSUE_SIZE_FIELD_NUMBER: builtins.int
    ISSUE_SIZE_PLAN_FIELD_NUMBER: builtins.int
    TRADING_STATUS_FIELD_NUMBER: builtins.int
    OTC_FLAG_FIELD_NUMBER: builtins.int
    BUY_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    SELL_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    FLOATING_COUPON_FLAG_FIELD_NUMBER: builtins.int
    PERPETUAL_FLAG_FIELD_NUMBER: builtins.int
    AMORTIZATION_FLAG_FIELD_NUMBER: builtins.int
    MIN_PRICE_INCREMENT_FIELD_NUMBER: builtins.int
    API_TRADE_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    REAL_EXCHANGE_FIELD_NUMBER: builtins.int
    POSITION_UID_FIELD_NUMBER: builtins.int
    ASSET_UID_FIELD_NUMBER: builtins.int
    REQUIRED_TESTS_FIELD_NUMBER: builtins.int
    FOR_IIS_FLAG_FIELD_NUMBER: builtins.int
    FOR_QUAL_INVESTOR_FLAG_FIELD_NUMBER: builtins.int
    WEEKEND_FLAG_FIELD_NUMBER: builtins.int
    BLOCKED_TCA_FLAG_FIELD_NUMBER: builtins.int
    SUBORDINATED_FLAG_FIELD_NUMBER: builtins.int
    LIQUIDITY_FLAG_FIELD_NUMBER: builtins.int
    FIRST_1MIN_CANDLE_DATE_FIELD_NUMBER: builtins.int
    FIRST_1DAY_CANDLE_DATE_FIELD_NUMBER: builtins.int
    RISK_LEVEL_FIELD_NUMBER: builtins.int
    BRAND_FIELD_NUMBER: builtins.int
    BOND_TYPE_FIELD_NUMBER: builtins.int
    CALL_DATE_FIELD_NUMBER: builtins.int
    DLONG_CLIENT_FIELD_NUMBER: builtins.int
    DSHORT_CLIENT_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    isin: builtins.str
    """ISIN-идентификатор инструмента."""
    lot: builtins.int
    """Лотность инструмента. Возможно совершение операций только на количества ценной бумаги, кратные параметру `lot`. [Подробнее](./glossary#lot)."""
    currency: builtins.str
    """Валюта расчетов."""
    short_enabled_flag: builtins.bool
    """Признак доступности для операций в шорт."""
    name: builtins.str
    """Название инструмента."""
    exchange: builtins.str
    """Tорговая площадка (секция биржи)."""
    coupon_quantity_per_year: builtins.int
    """Количество выплат по купонам в год."""
    country_of_risk: builtins.str
    """Код страны риска — то есть страны, в которой компания ведет основной бизнес."""
    country_of_risk_name: builtins.str
    """Наименование страны риска — то есть страны, в которой компания ведет основной бизнес."""
    sector: builtins.str
    """Сектор экономики."""
    issue_kind: builtins.str
    """Форма выпуска. Возможные значения: <br/>**documentary** — документарная; <br/>**non_documentary** — бездокументарная."""
    issue_size: builtins.int
    """Размер выпуска."""
    issue_size_plan: builtins.int
    """Плановый размер выпуска."""
    trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType
    """Текущий режим торгов инструмента."""
    otc_flag: builtins.bool
    """Флаг, используемый ранее для определения внебиржевых инструментов. На данный момент не используется для торгуемых через API инструментов. Может использоваться как фильтр для операций, совершавшихся некоторое время назад на ОТС площадке."""
    buy_available_flag: builtins.bool
    """Признак доступности для покупки."""
    sell_available_flag: builtins.bool
    """Признак доступности для продажи."""
    floating_coupon_flag: builtins.bool
    """Признак облигации с плавающим купоном."""
    perpetual_flag: builtins.bool
    """Признак бессрочной облигации."""
    amortization_flag: builtins.bool
    """Признак облигации с амортизацией долга."""
    api_trade_available_flag: builtins.bool
    """Параметр указывает на возможность торговать инструментом через API."""
    uid: builtins.str
    """Уникальный идентификатор инструмента."""
    real_exchange: tinkoff.invest.grpc.common_pb2.RealExchange.ValueType
    """Реальная площадка исполнения расчетов. (биржа)"""
    position_uid: builtins.str
    """Уникальный идентификатор позиции инструмента."""
    asset_uid: builtins.str
    """Уникальный идентификатор актива."""
    for_iis_flag: builtins.bool
    """Признак доступности для ИИС."""
    for_qual_investor_flag: builtins.bool
    """Флаг, отображающий доступность торговли инструментом только для квалифицированных инвесторов."""
    weekend_flag: builtins.bool
    """Флаг, отображающий доступность торговли инструментом по выходным."""
    blocked_tca_flag: builtins.bool
    """Флаг заблокированного ТКС."""
    subordinated_flag: builtins.bool
    """Признак субординированной облигации."""
    liquidity_flag: builtins.bool
    """Флаг достаточной ликвидности."""
    risk_level: global___RiskLevel.ValueType
    """Уровень риска."""
    bond_type: global___BondType.ValueType
    """Тип облигации."""
    @property
    def klong(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Коэффициент ставки риска длинной позиции по клиенту. 2 – клиент со стандартным уровнем риска (КСУР); 1 – клиент с повышенным уровнем риска (КПУР)."""

    @property
    def kshort(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Коэффициент ставки риска короткой позиции по клиенту. 2 – клиент со стандартным уровнем риска (КСУР); 1 – клиент с повышенным уровнем риска (КПУР)."""

    @property
    def dlong(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КСУР лонг. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КСУР шорт. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dlong_min(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КПУР лонг. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort_min(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КПУР шорт. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def maturity_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата погашения облигации по UTC."""

    @property
    def nominal(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Номинал облигации."""

    @property
    def initial_nominal(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Первоначальный номинал облигации."""

    @property
    def state_reg_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата выпуска облигации по UTC."""

    @property
    def placement_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата размещения по UTC."""

    @property
    def placement_price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Цена размещения."""

    @property
    def aci_value(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Значение НКД (накопленного купонного дохода) на дату."""

    @property
    def min_price_increment(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Шаг цены."""

    @property
    def required_tests(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Тесты, которые необходимо пройти клиенту, чтобы совершать сделки по инструменту."""

    @property
    def first_1min_candle_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата первой минутной свечи."""

    @property
    def first_1day_candle_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата первой дневной свечи."""

    @property
    def brand(self) -> tinkoff.invest.grpc.common_pb2.BrandData:
        """Информация о бренде."""

    @property
    def call_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата погашения облигации."""

    @property
    def dlong_client(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска в лонг с учетом текущего уровня риска портфеля клиента. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort_client(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска в шорт с учетом текущего уровня риска портфеля клиента. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        isin: builtins.str = ...,
        lot: builtins.int = ...,
        currency: builtins.str = ...,
        klong: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        kshort: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dlong: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dlong_min: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort_min: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        short_enabled_flag: builtins.bool = ...,
        name: builtins.str = ...,
        exchange: builtins.str = ...,
        coupon_quantity_per_year: builtins.int = ...,
        maturity_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        nominal: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        initial_nominal: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        state_reg_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        placement_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        placement_price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        aci_value: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        country_of_risk: builtins.str = ...,
        country_of_risk_name: builtins.str = ...,
        sector: builtins.str = ...,
        issue_kind: builtins.str = ...,
        issue_size: builtins.int = ...,
        issue_size_plan: builtins.int = ...,
        trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType = ...,
        otc_flag: builtins.bool = ...,
        buy_available_flag: builtins.bool = ...,
        sell_available_flag: builtins.bool = ...,
        floating_coupon_flag: builtins.bool = ...,
        perpetual_flag: builtins.bool = ...,
        amortization_flag: builtins.bool = ...,
        min_price_increment: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        api_trade_available_flag: builtins.bool = ...,
        uid: builtins.str = ...,
        real_exchange: tinkoff.invest.grpc.common_pb2.RealExchange.ValueType = ...,
        position_uid: builtins.str = ...,
        asset_uid: builtins.str = ...,
        required_tests: collections.abc.Iterable[builtins.str] | None = ...,
        for_iis_flag: builtins.bool = ...,
        for_qual_investor_flag: builtins.bool = ...,
        weekend_flag: builtins.bool = ...,
        blocked_tca_flag: builtins.bool = ...,
        subordinated_flag: builtins.bool = ...,
        liquidity_flag: builtins.bool = ...,
        first_1min_candle_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        first_1day_candle_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        risk_level: global___RiskLevel.ValueType = ...,
        brand: tinkoff.invest.grpc.common_pb2.BrandData | None = ...,
        bond_type: global___BondType.ValueType = ...,
        call_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        dlong_client: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort_client: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["aci_value", b"aci_value", "brand", b"brand", "call_date", b"call_date", "dlong", b"dlong", "dlong_client", b"dlong_client", "dlong_min", b"dlong_min", "dshort", b"dshort", "dshort_client", b"dshort_client", "dshort_min", b"dshort_min", "first_1day_candle_date", b"first_1day_candle_date", "first_1min_candle_date", b"first_1min_candle_date", "initial_nominal", b"initial_nominal", "klong", b"klong", "kshort", b"kshort", "maturity_date", b"maturity_date", "min_price_increment", b"min_price_increment", "nominal", b"nominal", "placement_date", b"placement_date", "placement_price", b"placement_price", "state_reg_date", b"state_reg_date"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["aci_value", b"aci_value", "amortization_flag", b"amortization_flag", "api_trade_available_flag", b"api_trade_available_flag", "asset_uid", b"asset_uid", "blocked_tca_flag", b"blocked_tca_flag", "bond_type", b"bond_type", "brand", b"brand", "buy_available_flag", b"buy_available_flag", "call_date", b"call_date", "class_code", b"class_code", "country_of_risk", b"country_of_risk", "country_of_risk_name", b"country_of_risk_name", "coupon_quantity_per_year", b"coupon_quantity_per_year", "currency", b"currency", "dlong", b"dlong", "dlong_client", b"dlong_client", "dlong_min", b"dlong_min", "dshort", b"dshort", "dshort_client", b"dshort_client", "dshort_min", b"dshort_min", "exchange", b"exchange", "figi", b"figi", "first_1day_candle_date", b"first_1day_candle_date", "first_1min_candle_date", b"first_1min_candle_date", "floating_coupon_flag", b"floating_coupon_flag", "for_iis_flag", b"for_iis_flag", "for_qual_investor_flag", b"for_qual_investor_flag", "initial_nominal", b"initial_nominal", "isin", b"isin", "issue_kind", b"issue_kind", "issue_size", b"issue_size", "issue_size_plan", b"issue_size_plan", "klong", b"klong", "kshort", b"kshort", "liquidity_flag", b"liquidity_flag", "lot", b"lot", "maturity_date", b"maturity_date", "min_price_increment", b"min_price_increment", "name", b"name", "nominal", b"nominal", "otc_flag", b"otc_flag", "perpetual_flag", b"perpetual_flag", "placement_date", b"placement_date", "placement_price", b"placement_price", "position_uid", b"position_uid", "real_exchange", b"real_exchange", "required_tests", b"required_tests", "risk_level", b"risk_level", "sector", b"sector", "sell_available_flag", b"sell_available_flag", "short_enabled_flag", b"short_enabled_flag", "state_reg_date", b"state_reg_date", "subordinated_flag", b"subordinated_flag", "ticker", b"ticker", "trading_status", b"trading_status", "uid", b"uid", "weekend_flag", b"weekend_flag"]) -> None: ...

global___Bond = Bond

@typing.final
class Currency(google.protobuf.message.Message):
    """Объект передачи информации о валюте."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    ISIN_FIELD_NUMBER: builtins.int
    LOT_FIELD_NUMBER: builtins.int
    CURRENCY_FIELD_NUMBER: builtins.int
    KLONG_FIELD_NUMBER: builtins.int
    KSHORT_FIELD_NUMBER: builtins.int
    DLONG_FIELD_NUMBER: builtins.int
    DSHORT_FIELD_NUMBER: builtins.int
    DLONG_MIN_FIELD_NUMBER: builtins.int
    DSHORT_MIN_FIELD_NUMBER: builtins.int
    SHORT_ENABLED_FLAG_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    EXCHANGE_FIELD_NUMBER: builtins.int
    NOMINAL_FIELD_NUMBER: builtins.int
    COUNTRY_OF_RISK_FIELD_NUMBER: builtins.int
    COUNTRY_OF_RISK_NAME_FIELD_NUMBER: builtins.int
    TRADING_STATUS_FIELD_NUMBER: builtins.int
    OTC_FLAG_FIELD_NUMBER: builtins.int
    BUY_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    SELL_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    ISO_CURRENCY_NAME_FIELD_NUMBER: builtins.int
    MIN_PRICE_INCREMENT_FIELD_NUMBER: builtins.int
    API_TRADE_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    REAL_EXCHANGE_FIELD_NUMBER: builtins.int
    POSITION_UID_FIELD_NUMBER: builtins.int
    REQUIRED_TESTS_FIELD_NUMBER: builtins.int
    FOR_IIS_FLAG_FIELD_NUMBER: builtins.int
    FOR_QUAL_INVESTOR_FLAG_FIELD_NUMBER: builtins.int
    WEEKEND_FLAG_FIELD_NUMBER: builtins.int
    BLOCKED_TCA_FLAG_FIELD_NUMBER: builtins.int
    FIRST_1MIN_CANDLE_DATE_FIELD_NUMBER: builtins.int
    FIRST_1DAY_CANDLE_DATE_FIELD_NUMBER: builtins.int
    BRAND_FIELD_NUMBER: builtins.int
    DLONG_CLIENT_FIELD_NUMBER: builtins.int
    DSHORT_CLIENT_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    isin: builtins.str
    """ISIN-идентификатор инструмента."""
    lot: builtins.int
    """Лотность инструмента. Возможно совершение операций только на количества ценной бумаги, кратные параметру `lot`. [Подробнее](./glossary#lot)."""
    currency: builtins.str
    """Валюта расчетов."""
    short_enabled_flag: builtins.bool
    """Признак доступности для операций в шорт."""
    name: builtins.str
    """Название инструмента."""
    exchange: builtins.str
    """Tорговая площадка (секция биржи)."""
    country_of_risk: builtins.str
    """Код страны риска — то есть страны, в которой компания ведет основной бизнес."""
    country_of_risk_name: builtins.str
    """Наименование страны риска — то есть страны, в которой компания ведет основной бизнес."""
    trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType
    """Текущий режим торгов инструмента."""
    otc_flag: builtins.bool
    """Флаг, используемый ранее для определения внебиржевых инструментов. На данный момент не используется для торгуемых через API инструментов. Может использоваться как фильтр для операций, совершавшихся некоторое время назад на ОТС площадке."""
    buy_available_flag: builtins.bool
    """Признак доступности для покупки."""
    sell_available_flag: builtins.bool
    """Признак доступности для продажи."""
    iso_currency_name: builtins.str
    """Строковый ISO-код валюты."""
    api_trade_available_flag: builtins.bool
    """Параметр указывает на возможность торговать инструментом через API."""
    uid: builtins.str
    """Уникальный идентификатор инструмента."""
    real_exchange: tinkoff.invest.grpc.common_pb2.RealExchange.ValueType
    """Реальная площадка исполнения расчетов (биржа)."""
    position_uid: builtins.str
    """Уникальный идентификатор позиции инструмента."""
    for_iis_flag: builtins.bool
    """Признак доступности для ИИС."""
    for_qual_investor_flag: builtins.bool
    """Флаг, отображающий доступность торговли инструментом только для квалифицированных инвесторов."""
    weekend_flag: builtins.bool
    """Флаг, отображающий доступность торговли инструментом по выходным."""
    blocked_tca_flag: builtins.bool
    """Флаг заблокированного ТКС."""
    @property
    def klong(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Коэффициент ставки риска длинной позиции по клиенту. 2 – клиент со стандартным уровнем риска (КСУР); 1 – клиент с повышенным уровнем риска (КПУР)."""

    @property
    def kshort(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Коэффициент ставки риска короткой позиции по клиенту. 2 – клиент со стандартным уровнем риска (КСУР); 1 – клиент с повышенным уровнем риска (КПУР)."""

    @property
    def dlong(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КСУР лонг. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КСУР шорт. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dlong_min(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КПУР лонг. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort_min(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КПУР шорт. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def nominal(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Номинал."""

    @property
    def min_price_increment(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Шаг цены."""

    @property
    def required_tests(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Тесты, которые необходимо пройти клиенту, чтобы совершать сделки по инструменту."""

    @property
    def first_1min_candle_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата первой минутной свечи."""

    @property
    def first_1day_candle_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата первой дневной свечи."""

    @property
    def brand(self) -> tinkoff.invest.grpc.common_pb2.BrandData:
        """Информация о бренде."""

    @property
    def dlong_client(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска в лонг с учетом текущего уровня риска портфеля клиента. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort_client(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска в шорт с учетом текущего уровня риска портфеля клиента. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        isin: builtins.str = ...,
        lot: builtins.int = ...,
        currency: builtins.str = ...,
        klong: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        kshort: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dlong: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dlong_min: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort_min: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        short_enabled_flag: builtins.bool = ...,
        name: builtins.str = ...,
        exchange: builtins.str = ...,
        nominal: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        country_of_risk: builtins.str = ...,
        country_of_risk_name: builtins.str = ...,
        trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType = ...,
        otc_flag: builtins.bool = ...,
        buy_available_flag: builtins.bool = ...,
        sell_available_flag: builtins.bool = ...,
        iso_currency_name: builtins.str = ...,
        min_price_increment: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        api_trade_available_flag: builtins.bool = ...,
        uid: builtins.str = ...,
        real_exchange: tinkoff.invest.grpc.common_pb2.RealExchange.ValueType = ...,
        position_uid: builtins.str = ...,
        required_tests: collections.abc.Iterable[builtins.str] | None = ...,
        for_iis_flag: builtins.bool = ...,
        for_qual_investor_flag: builtins.bool = ...,
        weekend_flag: builtins.bool = ...,
        blocked_tca_flag: builtins.bool = ...,
        first_1min_candle_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        first_1day_candle_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        brand: tinkoff.invest.grpc.common_pb2.BrandData | None = ...,
        dlong_client: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort_client: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["brand", b"brand", "dlong", b"dlong", "dlong_client", b"dlong_client", "dlong_min", b"dlong_min", "dshort", b"dshort", "dshort_client", b"dshort_client", "dshort_min", b"dshort_min", "first_1day_candle_date", b"first_1day_candle_date", "first_1min_candle_date", b"first_1min_candle_date", "klong", b"klong", "kshort", b"kshort", "min_price_increment", b"min_price_increment", "nominal", b"nominal"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["api_trade_available_flag", b"api_trade_available_flag", "blocked_tca_flag", b"blocked_tca_flag", "brand", b"brand", "buy_available_flag", b"buy_available_flag", "class_code", b"class_code", "country_of_risk", b"country_of_risk", "country_of_risk_name", b"country_of_risk_name", "currency", b"currency", "dlong", b"dlong", "dlong_client", b"dlong_client", "dlong_min", b"dlong_min", "dshort", b"dshort", "dshort_client", b"dshort_client", "dshort_min", b"dshort_min", "exchange", b"exchange", "figi", b"figi", "first_1day_candle_date", b"first_1day_candle_date", "first_1min_candle_date", b"first_1min_candle_date", "for_iis_flag", b"for_iis_flag", "for_qual_investor_flag", b"for_qual_investor_flag", "isin", b"isin", "iso_currency_name", b"iso_currency_name", "klong", b"klong", "kshort", b"kshort", "lot", b"lot", "min_price_increment", b"min_price_increment", "name", b"name", "nominal", b"nominal", "otc_flag", b"otc_flag", "position_uid", b"position_uid", "real_exchange", b"real_exchange", "required_tests", b"required_tests", "sell_available_flag", b"sell_available_flag", "short_enabled_flag", b"short_enabled_flag", "ticker", b"ticker", "trading_status", b"trading_status", "uid", b"uid", "weekend_flag", b"weekend_flag"]) -> None: ...

global___Currency = Currency

@typing.final
class Etf(google.protobuf.message.Message):
    """Объект передачи информации об инвестиционном фонде."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    ISIN_FIELD_NUMBER: builtins.int
    LOT_FIELD_NUMBER: builtins.int
    CURRENCY_FIELD_NUMBER: builtins.int
    KLONG_FIELD_NUMBER: builtins.int
    KSHORT_FIELD_NUMBER: builtins.int
    DLONG_FIELD_NUMBER: builtins.int
    DSHORT_FIELD_NUMBER: builtins.int
    DLONG_MIN_FIELD_NUMBER: builtins.int
    DSHORT_MIN_FIELD_NUMBER: builtins.int
    SHORT_ENABLED_FLAG_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    EXCHANGE_FIELD_NUMBER: builtins.int
    FIXED_COMMISSION_FIELD_NUMBER: builtins.int
    FOCUS_TYPE_FIELD_NUMBER: builtins.int
    RELEASED_DATE_FIELD_NUMBER: builtins.int
    NUM_SHARES_FIELD_NUMBER: builtins.int
    COUNTRY_OF_RISK_FIELD_NUMBER: builtins.int
    COUNTRY_OF_RISK_NAME_FIELD_NUMBER: builtins.int
    SECTOR_FIELD_NUMBER: builtins.int
    REBALANCING_FREQ_FIELD_NUMBER: builtins.int
    TRADING_STATUS_FIELD_NUMBER: builtins.int
    OTC_FLAG_FIELD_NUMBER: builtins.int
    BUY_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    SELL_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    MIN_PRICE_INCREMENT_FIELD_NUMBER: builtins.int
    API_TRADE_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    REAL_EXCHANGE_FIELD_NUMBER: builtins.int
    POSITION_UID_FIELD_NUMBER: builtins.int
    ASSET_UID_FIELD_NUMBER: builtins.int
    INSTRUMENT_EXCHANGE_FIELD_NUMBER: builtins.int
    REQUIRED_TESTS_FIELD_NUMBER: builtins.int
    FOR_IIS_FLAG_FIELD_NUMBER: builtins.int
    FOR_QUAL_INVESTOR_FLAG_FIELD_NUMBER: builtins.int
    WEEKEND_FLAG_FIELD_NUMBER: builtins.int
    BLOCKED_TCA_FLAG_FIELD_NUMBER: builtins.int
    LIQUIDITY_FLAG_FIELD_NUMBER: builtins.int
    FIRST_1MIN_CANDLE_DATE_FIELD_NUMBER: builtins.int
    FIRST_1DAY_CANDLE_DATE_FIELD_NUMBER: builtins.int
    BRAND_FIELD_NUMBER: builtins.int
    DLONG_CLIENT_FIELD_NUMBER: builtins.int
    DSHORT_CLIENT_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    isin: builtins.str
    """ISIN-идентификатор инструмента."""
    lot: builtins.int
    """Лотность инструмента. Возможно совершение операций только на количества ценной бумаги, кратные параметру `lot`. [Подробнее](./glossary#lot)."""
    currency: builtins.str
    """Валюта расчетов."""
    short_enabled_flag: builtins.bool
    """Признак доступности для операций в шорт."""
    name: builtins.str
    """Название инструмента."""
    exchange: builtins.str
    """Tорговая площадка (секция биржи)."""
    focus_type: builtins.str
    """Возможные значения: <br/>**equity** — акции;<br/>**fixed_income** — облигации;<br/>**mixed_allocation** — смешанный;<br/>**money_market** — денежный рынок;<br/>**real_estate** — недвижимость;<br/>**commodity** — товары;<br/>**specialty** — специальный;<br/>**private_equity** — private equity;<br/>**alternative_investment** — альтернативные инвестиции."""
    country_of_risk: builtins.str
    """Код страны риска — то есть страны, в которой компания ведет основной бизнес."""
    country_of_risk_name: builtins.str
    """Наименование страны риска — то есть страны, в которой компания ведет основной бизнес."""
    sector: builtins.str
    """Сектор экономики."""
    rebalancing_freq: builtins.str
    """Частота ребалансировки."""
    trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType
    """Текущий режим торгов инструмента."""
    otc_flag: builtins.bool
    """Флаг, используемый ранее для определения внебиржевых инструментов. На данный момент не используется для торгуемых через API инструментов. Может использоваться как фильтр для операций, совершавшихся некоторое время назад на ОТС площадке."""
    buy_available_flag: builtins.bool
    """Признак доступности для покупки."""
    sell_available_flag: builtins.bool
    """Признак доступности для продажи."""
    api_trade_available_flag: builtins.bool
    """Параметр указывает на возможность торговать инструментом через API."""
    uid: builtins.str
    """Уникальный идентификатор инструмента."""
    real_exchange: tinkoff.invest.grpc.common_pb2.RealExchange.ValueType
    """Реальная площадка исполнения расчетов (биржа)."""
    position_uid: builtins.str
    """Уникальный идентификатор позиции инструмента."""
    asset_uid: builtins.str
    """Уникальный идентификатор актива."""
    instrument_exchange: global___InstrumentExchangeType.ValueType
    """Тип площадки торговли."""
    for_iis_flag: builtins.bool
    """Признак доступности для ИИС."""
    for_qual_investor_flag: builtins.bool
    """Флаг, отображающий доступность торговли инструментом только для квалифицированных инвесторов."""
    weekend_flag: builtins.bool
    """ФлагФлаг, отображающий доступность торговли инструментом по выходным."""
    blocked_tca_flag: builtins.bool
    """Флаг заблокированного ТКС."""
    liquidity_flag: builtins.bool
    """Флаг достаточной ликвидности."""
    @property
    def klong(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Коэффициент ставки риска длинной позиции по клиенту. 2 – клиент со стандартным уровнем риска (КСУР); 1 – клиент с повышенным уровнем риска (КПУР)."""

    @property
    def kshort(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Коэффициент ставки риска короткой позиции по клиенту. 2 – клиент со стандартным уровнем риска (КСУР); 1 – клиент с повышенным уровнем риска (КПУР)."""

    @property
    def dlong(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КСУР лонг. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КСУР шорт. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dlong_min(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КПУР лонг. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort_min(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КПУР шорт. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def fixed_commission(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Размер фиксированной комиссии фонда."""

    @property
    def released_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата выпуска по UTC."""

    @property
    def num_shares(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Количество паев фонда в обращении."""

    @property
    def min_price_increment(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Шаг цены."""

    @property
    def required_tests(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Тесты, которые необходимо пройти клиенту, чтобы совершать сделки по инструменту."""

    @property
    def first_1min_candle_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата первой минутной свечи."""

    @property
    def first_1day_candle_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата первой дневной свечи."""

    @property
    def brand(self) -> tinkoff.invest.grpc.common_pb2.BrandData:
        """Информация о бренде."""

    @property
    def dlong_client(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска в лонг с учетом текущего уровня риска портфеля клиента. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort_client(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска в шорт с учетом текущего уровня риска портфеля клиента. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        isin: builtins.str = ...,
        lot: builtins.int = ...,
        currency: builtins.str = ...,
        klong: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        kshort: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dlong: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dlong_min: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort_min: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        short_enabled_flag: builtins.bool = ...,
        name: builtins.str = ...,
        exchange: builtins.str = ...,
        fixed_commission: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        focus_type: builtins.str = ...,
        released_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        num_shares: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        country_of_risk: builtins.str = ...,
        country_of_risk_name: builtins.str = ...,
        sector: builtins.str = ...,
        rebalancing_freq: builtins.str = ...,
        trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType = ...,
        otc_flag: builtins.bool = ...,
        buy_available_flag: builtins.bool = ...,
        sell_available_flag: builtins.bool = ...,
        min_price_increment: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        api_trade_available_flag: builtins.bool = ...,
        uid: builtins.str = ...,
        real_exchange: tinkoff.invest.grpc.common_pb2.RealExchange.ValueType = ...,
        position_uid: builtins.str = ...,
        asset_uid: builtins.str = ...,
        instrument_exchange: global___InstrumentExchangeType.ValueType = ...,
        required_tests: collections.abc.Iterable[builtins.str] | None = ...,
        for_iis_flag: builtins.bool = ...,
        for_qual_investor_flag: builtins.bool = ...,
        weekend_flag: builtins.bool = ...,
        blocked_tca_flag: builtins.bool = ...,
        liquidity_flag: builtins.bool = ...,
        first_1min_candle_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        first_1day_candle_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        brand: tinkoff.invest.grpc.common_pb2.BrandData | None = ...,
        dlong_client: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort_client: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["brand", b"brand", "dlong", b"dlong", "dlong_client", b"dlong_client", "dlong_min", b"dlong_min", "dshort", b"dshort", "dshort_client", b"dshort_client", "dshort_min", b"dshort_min", "first_1day_candle_date", b"first_1day_candle_date", "first_1min_candle_date", b"first_1min_candle_date", "fixed_commission", b"fixed_commission", "klong", b"klong", "kshort", b"kshort", "min_price_increment", b"min_price_increment", "num_shares", b"num_shares", "released_date", b"released_date"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["api_trade_available_flag", b"api_trade_available_flag", "asset_uid", b"asset_uid", "blocked_tca_flag", b"blocked_tca_flag", "brand", b"brand", "buy_available_flag", b"buy_available_flag", "class_code", b"class_code", "country_of_risk", b"country_of_risk", "country_of_risk_name", b"country_of_risk_name", "currency", b"currency", "dlong", b"dlong", "dlong_client", b"dlong_client", "dlong_min", b"dlong_min", "dshort", b"dshort", "dshort_client", b"dshort_client", "dshort_min", b"dshort_min", "exchange", b"exchange", "figi", b"figi", "first_1day_candle_date", b"first_1day_candle_date", "first_1min_candle_date", b"first_1min_candle_date", "fixed_commission", b"fixed_commission", "focus_type", b"focus_type", "for_iis_flag", b"for_iis_flag", "for_qual_investor_flag", b"for_qual_investor_flag", "instrument_exchange", b"instrument_exchange", "isin", b"isin", "klong", b"klong", "kshort", b"kshort", "liquidity_flag", b"liquidity_flag", "lot", b"lot", "min_price_increment", b"min_price_increment", "name", b"name", "num_shares", b"num_shares", "otc_flag", b"otc_flag", "position_uid", b"position_uid", "real_exchange", b"real_exchange", "rebalancing_freq", b"rebalancing_freq", "released_date", b"released_date", "required_tests", b"required_tests", "sector", b"sector", "sell_available_flag", b"sell_available_flag", "short_enabled_flag", b"short_enabled_flag", "ticker", b"ticker", "trading_status", b"trading_status", "uid", b"uid", "weekend_flag", b"weekend_flag"]) -> None: ...

global___Etf = Etf

@typing.final
class Future(google.protobuf.message.Message):
    """Объект передачи информации о фьючерсе."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    LOT_FIELD_NUMBER: builtins.int
    CURRENCY_FIELD_NUMBER: builtins.int
    KLONG_FIELD_NUMBER: builtins.int
    KSHORT_FIELD_NUMBER: builtins.int
    DLONG_FIELD_NUMBER: builtins.int
    DSHORT_FIELD_NUMBER: builtins.int
    DLONG_MIN_FIELD_NUMBER: builtins.int
    DSHORT_MIN_FIELD_NUMBER: builtins.int
    SHORT_ENABLED_FLAG_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    EXCHANGE_FIELD_NUMBER: builtins.int
    FIRST_TRADE_DATE_FIELD_NUMBER: builtins.int
    LAST_TRADE_DATE_FIELD_NUMBER: builtins.int
    FUTURES_TYPE_FIELD_NUMBER: builtins.int
    ASSET_TYPE_FIELD_NUMBER: builtins.int
    BASIC_ASSET_FIELD_NUMBER: builtins.int
    BASIC_ASSET_SIZE_FIELD_NUMBER: builtins.int
    COUNTRY_OF_RISK_FIELD_NUMBER: builtins.int
    COUNTRY_OF_RISK_NAME_FIELD_NUMBER: builtins.int
    SECTOR_FIELD_NUMBER: builtins.int
    EXPIRATION_DATE_FIELD_NUMBER: builtins.int
    TRADING_STATUS_FIELD_NUMBER: builtins.int
    OTC_FLAG_FIELD_NUMBER: builtins.int
    BUY_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    SELL_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    MIN_PRICE_INCREMENT_FIELD_NUMBER: builtins.int
    API_TRADE_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    REAL_EXCHANGE_FIELD_NUMBER: builtins.int
    POSITION_UID_FIELD_NUMBER: builtins.int
    BASIC_ASSET_POSITION_UID_FIELD_NUMBER: builtins.int
    REQUIRED_TESTS_FIELD_NUMBER: builtins.int
    FOR_IIS_FLAG_FIELD_NUMBER: builtins.int
    FOR_QUAL_INVESTOR_FLAG_FIELD_NUMBER: builtins.int
    WEEKEND_FLAG_FIELD_NUMBER: builtins.int
    BLOCKED_TCA_FLAG_FIELD_NUMBER: builtins.int
    FIRST_1MIN_CANDLE_DATE_FIELD_NUMBER: builtins.int
    FIRST_1DAY_CANDLE_DATE_FIELD_NUMBER: builtins.int
    INITIAL_MARGIN_ON_BUY_FIELD_NUMBER: builtins.int
    INITIAL_MARGIN_ON_SELL_FIELD_NUMBER: builtins.int
    MIN_PRICE_INCREMENT_AMOUNT_FIELD_NUMBER: builtins.int
    BRAND_FIELD_NUMBER: builtins.int
    DLONG_CLIENT_FIELD_NUMBER: builtins.int
    DSHORT_CLIENT_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    lot: builtins.int
    """Лотность инструмента. Возможно совершение операций только на количества ценной бумаги, кратные параметру `lot`. [Подробнее](./glossary#lot)."""
    currency: builtins.str
    """Валюта расчетов."""
    short_enabled_flag: builtins.bool
    """Признак доступности для операций шорт."""
    name: builtins.str
    """Название инструмента."""
    exchange: builtins.str
    """Tорговая площадка (секция биржи)."""
    futures_type: builtins.str
    """Тип фьючерса. Возможные значения: <br/>**physical_delivery** — физические поставки; <br/>**cash_settlement** — денежный эквивалент."""
    asset_type: builtins.str
    """Тип актива. Возможные значения: <br/>**commodity** — товар; <br/>**currency** — валюта; <br/>**security** — ценная бумага; <br/>**index** — индекс."""
    basic_asset: builtins.str
    """Основной актив."""
    country_of_risk: builtins.str
    """Код страны риска — то есть страны, в которой компания ведет основной бизнес."""
    country_of_risk_name: builtins.str
    """Наименование страны риска — то есть страны, в которой компания ведет основной бизнес."""
    sector: builtins.str
    """Сектор экономики."""
    trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType
    """Текущий режим торгов инструмента."""
    otc_flag: builtins.bool
    """Флаг, используемый ранее для определения внебиржевых инструментов. На данный момент не используется для торгуемых через API инструментов. Может использоваться как фильтр для операций, совершавшихся некоторое время назад на ОТС площадке."""
    buy_available_flag: builtins.bool
    """Признак доступности для покупки."""
    sell_available_flag: builtins.bool
    """Признак доступности для продажи."""
    api_trade_available_flag: builtins.bool
    """Параметр указывает на возможность торговать инструментом через API."""
    uid: builtins.str
    """Уникальный идентификатор инструмента."""
    real_exchange: tinkoff.invest.grpc.common_pb2.RealExchange.ValueType
    """Реальная площадка исполнения расчетов (биржа)."""
    position_uid: builtins.str
    """Уникальный идентификатор позиции инструмента."""
    basic_asset_position_uid: builtins.str
    """Уникальный идентификатор позиции основного инструмента."""
    for_iis_flag: builtins.bool
    """Признак доступности для ИИС."""
    for_qual_investor_flag: builtins.bool
    """Флаг, отображающий доступность торговли инструментом только для квалифицированных инвесторов."""
    weekend_flag: builtins.bool
    """Флаг, отображающий доступность торговли инструментом по выходным."""
    blocked_tca_flag: builtins.bool
    """Флаг заблокированного ТКС."""
    @property
    def klong(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Коэффициент ставки риска длинной позиции по клиенту. 2 – клиент со стандартным уровнем риска (КСУР); 1 – клиент с повышенным уровнем риска (КПУР)."""

    @property
    def kshort(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Коэффициент ставки риска короткой позиции по клиенту. 2 – клиент со стандартным уровнем риска (КСУР); 1 – клиент с повышенным уровнем риска (КПУР)."""

    @property
    def dlong(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КСУР лонг. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КСУР шорт. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dlong_min(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КПУР лонг. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort_min(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КПУР шорт. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def first_trade_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата начала обращения контракта по UTC."""

    @property
    def last_trade_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата по UTC, до которой возможно проведение операций с фьючерсом."""

    @property
    def basic_asset_size(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Размер основного актива."""

    @property
    def expiration_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата истечения срока в часов поясе UTC."""

    @property
    def min_price_increment(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Шаг цены."""

    @property
    def required_tests(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Тесты, которые необходимо пройти клиенту, чтобы совершать сделки по инструменту."""

    @property
    def first_1min_candle_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата первой минутной свечи."""

    @property
    def first_1day_candle_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата первой дневной свечи."""

    @property
    def initial_margin_on_buy(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Гарантийное обеспечение при покупке."""

    @property
    def initial_margin_on_sell(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Гарантийное обеспечение при продаже."""

    @property
    def min_price_increment_amount(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Стоимость шага цены."""

    @property
    def brand(self) -> tinkoff.invest.grpc.common_pb2.BrandData:
        """Информация о бренде."""

    @property
    def dlong_client(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска в лонг с учетом текущего уровня риска портфеля клиента. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort_client(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска в шорт с учетом текущего уровня риска портфеля клиента. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        lot: builtins.int = ...,
        currency: builtins.str = ...,
        klong: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        kshort: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dlong: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dlong_min: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort_min: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        short_enabled_flag: builtins.bool = ...,
        name: builtins.str = ...,
        exchange: builtins.str = ...,
        first_trade_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_trade_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        futures_type: builtins.str = ...,
        asset_type: builtins.str = ...,
        basic_asset: builtins.str = ...,
        basic_asset_size: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        country_of_risk: builtins.str = ...,
        country_of_risk_name: builtins.str = ...,
        sector: builtins.str = ...,
        expiration_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType = ...,
        otc_flag: builtins.bool = ...,
        buy_available_flag: builtins.bool = ...,
        sell_available_flag: builtins.bool = ...,
        min_price_increment: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        api_trade_available_flag: builtins.bool = ...,
        uid: builtins.str = ...,
        real_exchange: tinkoff.invest.grpc.common_pb2.RealExchange.ValueType = ...,
        position_uid: builtins.str = ...,
        basic_asset_position_uid: builtins.str = ...,
        required_tests: collections.abc.Iterable[builtins.str] | None = ...,
        for_iis_flag: builtins.bool = ...,
        for_qual_investor_flag: builtins.bool = ...,
        weekend_flag: builtins.bool = ...,
        blocked_tca_flag: builtins.bool = ...,
        first_1min_candle_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        first_1day_candle_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        initial_margin_on_buy: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        initial_margin_on_sell: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        min_price_increment_amount: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        brand: tinkoff.invest.grpc.common_pb2.BrandData | None = ...,
        dlong_client: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort_client: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["basic_asset_size", b"basic_asset_size", "brand", b"brand", "dlong", b"dlong", "dlong_client", b"dlong_client", "dlong_min", b"dlong_min", "dshort", b"dshort", "dshort_client", b"dshort_client", "dshort_min", b"dshort_min", "expiration_date", b"expiration_date", "first_1day_candle_date", b"first_1day_candle_date", "first_1min_candle_date", b"first_1min_candle_date", "first_trade_date", b"first_trade_date", "initial_margin_on_buy", b"initial_margin_on_buy", "initial_margin_on_sell", b"initial_margin_on_sell", "klong", b"klong", "kshort", b"kshort", "last_trade_date", b"last_trade_date", "min_price_increment", b"min_price_increment", "min_price_increment_amount", b"min_price_increment_amount"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["api_trade_available_flag", b"api_trade_available_flag", "asset_type", b"asset_type", "basic_asset", b"basic_asset", "basic_asset_position_uid", b"basic_asset_position_uid", "basic_asset_size", b"basic_asset_size", "blocked_tca_flag", b"blocked_tca_flag", "brand", b"brand", "buy_available_flag", b"buy_available_flag", "class_code", b"class_code", "country_of_risk", b"country_of_risk", "country_of_risk_name", b"country_of_risk_name", "currency", b"currency", "dlong", b"dlong", "dlong_client", b"dlong_client", "dlong_min", b"dlong_min", "dshort", b"dshort", "dshort_client", b"dshort_client", "dshort_min", b"dshort_min", "exchange", b"exchange", "expiration_date", b"expiration_date", "figi", b"figi", "first_1day_candle_date", b"first_1day_candle_date", "first_1min_candle_date", b"first_1min_candle_date", "first_trade_date", b"first_trade_date", "for_iis_flag", b"for_iis_flag", "for_qual_investor_flag", b"for_qual_investor_flag", "futures_type", b"futures_type", "initial_margin_on_buy", b"initial_margin_on_buy", "initial_margin_on_sell", b"initial_margin_on_sell", "klong", b"klong", "kshort", b"kshort", "last_trade_date", b"last_trade_date", "lot", b"lot", "min_price_increment", b"min_price_increment", "min_price_increment_amount", b"min_price_increment_amount", "name", b"name", "otc_flag", b"otc_flag", "position_uid", b"position_uid", "real_exchange", b"real_exchange", "required_tests", b"required_tests", "sector", b"sector", "sell_available_flag", b"sell_available_flag", "short_enabled_flag", b"short_enabled_flag", "ticker", b"ticker", "trading_status", b"trading_status", "uid", b"uid", "weekend_flag", b"weekend_flag"]) -> None: ...

global___Future = Future

@typing.final
class Share(google.protobuf.message.Message):
    """Объект передачи информации об акции."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    ISIN_FIELD_NUMBER: builtins.int
    LOT_FIELD_NUMBER: builtins.int
    CURRENCY_FIELD_NUMBER: builtins.int
    KLONG_FIELD_NUMBER: builtins.int
    KSHORT_FIELD_NUMBER: builtins.int
    DLONG_FIELD_NUMBER: builtins.int
    DSHORT_FIELD_NUMBER: builtins.int
    DLONG_MIN_FIELD_NUMBER: builtins.int
    DSHORT_MIN_FIELD_NUMBER: builtins.int
    SHORT_ENABLED_FLAG_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    EXCHANGE_FIELD_NUMBER: builtins.int
    IPO_DATE_FIELD_NUMBER: builtins.int
    ISSUE_SIZE_FIELD_NUMBER: builtins.int
    COUNTRY_OF_RISK_FIELD_NUMBER: builtins.int
    COUNTRY_OF_RISK_NAME_FIELD_NUMBER: builtins.int
    SECTOR_FIELD_NUMBER: builtins.int
    ISSUE_SIZE_PLAN_FIELD_NUMBER: builtins.int
    NOMINAL_FIELD_NUMBER: builtins.int
    TRADING_STATUS_FIELD_NUMBER: builtins.int
    OTC_FLAG_FIELD_NUMBER: builtins.int
    BUY_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    SELL_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    DIV_YIELD_FLAG_FIELD_NUMBER: builtins.int
    SHARE_TYPE_FIELD_NUMBER: builtins.int
    MIN_PRICE_INCREMENT_FIELD_NUMBER: builtins.int
    API_TRADE_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    REAL_EXCHANGE_FIELD_NUMBER: builtins.int
    POSITION_UID_FIELD_NUMBER: builtins.int
    ASSET_UID_FIELD_NUMBER: builtins.int
    INSTRUMENT_EXCHANGE_FIELD_NUMBER: builtins.int
    REQUIRED_TESTS_FIELD_NUMBER: builtins.int
    FOR_IIS_FLAG_FIELD_NUMBER: builtins.int
    FOR_QUAL_INVESTOR_FLAG_FIELD_NUMBER: builtins.int
    WEEKEND_FLAG_FIELD_NUMBER: builtins.int
    BLOCKED_TCA_FLAG_FIELD_NUMBER: builtins.int
    LIQUIDITY_FLAG_FIELD_NUMBER: builtins.int
    FIRST_1MIN_CANDLE_DATE_FIELD_NUMBER: builtins.int
    FIRST_1DAY_CANDLE_DATE_FIELD_NUMBER: builtins.int
    BRAND_FIELD_NUMBER: builtins.int
    DLONG_CLIENT_FIELD_NUMBER: builtins.int
    DSHORT_CLIENT_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    isin: builtins.str
    """ISIN-идентификатор инструмента."""
    lot: builtins.int
    """Лотность инструмента. Возможно совершение операций только на количества ценной бумаги, кратные параметру `lot`. [Подробнее](./glossary#lot)"""
    currency: builtins.str
    """Валюта расчетов."""
    short_enabled_flag: builtins.bool
    """Признак доступности для операций в шорт."""
    name: builtins.str
    """Название инструмента."""
    exchange: builtins.str
    """Tорговая площадка (секция биржи)."""
    issue_size: builtins.int
    """Размер выпуска."""
    country_of_risk: builtins.str
    """Код страны риска — то есть страны, в которой компания ведет основной бизнес."""
    country_of_risk_name: builtins.str
    """Наименование страны риска — то есть страны, в которой компания ведет основной бизнес."""
    sector: builtins.str
    """Сектор экономики."""
    issue_size_plan: builtins.int
    """Плановый размер выпуска."""
    trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType
    """Текущий режим торгов инструмента."""
    otc_flag: builtins.bool
    """Флаг, используемый ранее для определения внебиржевых инструментов. На данный момент не используется для торгуемых через API инструментов. Может использоваться как фильтр для операций, совершавшихся некоторое время назад на ОТС площадке."""
    buy_available_flag: builtins.bool
    """Признак доступности для покупки."""
    sell_available_flag: builtins.bool
    """Признак доступности для продажи."""
    div_yield_flag: builtins.bool
    """Признак наличия дивидендной доходности."""
    share_type: global___ShareType.ValueType
    """Тип акции. Возможные значения — `[ShareType](./instruments#sharetype)`."""
    api_trade_available_flag: builtins.bool
    """Возможность торговать инструментом через API."""
    uid: builtins.str
    """Уникальный идентификатор инструмента."""
    real_exchange: tinkoff.invest.grpc.common_pb2.RealExchange.ValueType
    """Реальная площадка исполнения расчетов (биржа)."""
    position_uid: builtins.str
    """Уникальный идентификатор позиции инструмента."""
    asset_uid: builtins.str
    """Уникальный идентификатор актива."""
    instrument_exchange: global___InstrumentExchangeType.ValueType
    """Тип площадки торговли."""
    for_iis_flag: builtins.bool
    """Признак доступности для ИИС."""
    for_qual_investor_flag: builtins.bool
    """Флаг, отображающий доступность торговли инструментом только для квалифицированных инвесторов."""
    weekend_flag: builtins.bool
    """Флаг, отображающий доступность торговли инструментом по выходным."""
    blocked_tca_flag: builtins.bool
    """Флаг заблокированного ТКС."""
    liquidity_flag: builtins.bool
    """Флаг достаточной ликвидности."""
    @property
    def klong(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Коэффициент ставки риска длинной позиции по клиенту. 2 – клиент со стандартным уровнем риска (КСУР); 1 – клиент с повышенным уровнем риска (КПУР)."""

    @property
    def kshort(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Коэффициент ставки риска короткой позиции по клиенту. 2 – клиент со стандартным уровнем риска (КСУР); 1 – клиент с повышенным уровнем риска (КПУР)."""

    @property
    def dlong(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КСУР лонг. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КСУР шорт. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dlong_min(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КПУР лонг. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort_min(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КПУР шорт. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def ipo_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата IPO акции по UTC."""

    @property
    def nominal(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Номинал."""

    @property
    def min_price_increment(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Шаг цены."""

    @property
    def required_tests(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Тесты, которые необходимо пройти клиенту, чтобы совершать сделки по инструменту."""

    @property
    def first_1min_candle_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата первой минутной свечи."""

    @property
    def first_1day_candle_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата первой дневной свечи."""

    @property
    def brand(self) -> tinkoff.invest.grpc.common_pb2.BrandData:
        """Информация о бренде."""

    @property
    def dlong_client(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска в лонг с учетом текущего уровня риска портфеля клиента. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort_client(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска в шорт с учетом текущего уровня риска портфеля клиента. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        isin: builtins.str = ...,
        lot: builtins.int = ...,
        currency: builtins.str = ...,
        klong: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        kshort: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dlong: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dlong_min: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort_min: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        short_enabled_flag: builtins.bool = ...,
        name: builtins.str = ...,
        exchange: builtins.str = ...,
        ipo_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        issue_size: builtins.int = ...,
        country_of_risk: builtins.str = ...,
        country_of_risk_name: builtins.str = ...,
        sector: builtins.str = ...,
        issue_size_plan: builtins.int = ...,
        nominal: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType = ...,
        otc_flag: builtins.bool = ...,
        buy_available_flag: builtins.bool = ...,
        sell_available_flag: builtins.bool = ...,
        div_yield_flag: builtins.bool = ...,
        share_type: global___ShareType.ValueType = ...,
        min_price_increment: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        api_trade_available_flag: builtins.bool = ...,
        uid: builtins.str = ...,
        real_exchange: tinkoff.invest.grpc.common_pb2.RealExchange.ValueType = ...,
        position_uid: builtins.str = ...,
        asset_uid: builtins.str = ...,
        instrument_exchange: global___InstrumentExchangeType.ValueType = ...,
        required_tests: collections.abc.Iterable[builtins.str] | None = ...,
        for_iis_flag: builtins.bool = ...,
        for_qual_investor_flag: builtins.bool = ...,
        weekend_flag: builtins.bool = ...,
        blocked_tca_flag: builtins.bool = ...,
        liquidity_flag: builtins.bool = ...,
        first_1min_candle_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        first_1day_candle_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        brand: tinkoff.invest.grpc.common_pb2.BrandData | None = ...,
        dlong_client: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort_client: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["brand", b"brand", "dlong", b"dlong", "dlong_client", b"dlong_client", "dlong_min", b"dlong_min", "dshort", b"dshort", "dshort_client", b"dshort_client", "dshort_min", b"dshort_min", "first_1day_candle_date", b"first_1day_candle_date", "first_1min_candle_date", b"first_1min_candle_date", "ipo_date", b"ipo_date", "klong", b"klong", "kshort", b"kshort", "min_price_increment", b"min_price_increment", "nominal", b"nominal"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["api_trade_available_flag", b"api_trade_available_flag", "asset_uid", b"asset_uid", "blocked_tca_flag", b"blocked_tca_flag", "brand", b"brand", "buy_available_flag", b"buy_available_flag", "class_code", b"class_code", "country_of_risk", b"country_of_risk", "country_of_risk_name", b"country_of_risk_name", "currency", b"currency", "div_yield_flag", b"div_yield_flag", "dlong", b"dlong", "dlong_client", b"dlong_client", "dlong_min", b"dlong_min", "dshort", b"dshort", "dshort_client", b"dshort_client", "dshort_min", b"dshort_min", "exchange", b"exchange", "figi", b"figi", "first_1day_candle_date", b"first_1day_candle_date", "first_1min_candle_date", b"first_1min_candle_date", "for_iis_flag", b"for_iis_flag", "for_qual_investor_flag", b"for_qual_investor_flag", "instrument_exchange", b"instrument_exchange", "ipo_date", b"ipo_date", "isin", b"isin", "issue_size", b"issue_size", "issue_size_plan", b"issue_size_plan", "klong", b"klong", "kshort", b"kshort", "liquidity_flag", b"liquidity_flag", "lot", b"lot", "min_price_increment", b"min_price_increment", "name", b"name", "nominal", b"nominal", "otc_flag", b"otc_flag", "position_uid", b"position_uid", "real_exchange", b"real_exchange", "required_tests", b"required_tests", "sector", b"sector", "sell_available_flag", b"sell_available_flag", "share_type", b"share_type", "short_enabled_flag", b"short_enabled_flag", "ticker", b"ticker", "trading_status", b"trading_status", "uid", b"uid", "weekend_flag", b"weekend_flag"]) -> None: ...

global___Share = Share

@typing.final
class StructuredNote(google.protobuf.message.Message):
    """Объект передачи информации о структурной ноте."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _LogicPortfolio:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _LogicPortfolioEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StructuredNote._LogicPortfolio.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        LOGIC_PORTFOLIO_UNSPECIFIED: StructuredNote._LogicPortfolio.ValueType  # 0
        """Стратегия портфеля не определена."""
        LOGIC_PORTFOLIO_VOLATILITY: StructuredNote._LogicPortfolio.ValueType  # 1
        """Волатильность."""
        LOGIC_PORTFOLIO_CORRELATION: StructuredNote._LogicPortfolio.ValueType  # 2
        """Корреляция."""

    class LogicPortfolio(_LogicPortfolio, metaclass=_LogicPortfolioEnumTypeWrapper):
        """Стратегия портфеля."""

    LOGIC_PORTFOLIO_UNSPECIFIED: StructuredNote.LogicPortfolio.ValueType  # 0
    """Стратегия портфеля не определена."""
    LOGIC_PORTFOLIO_VOLATILITY: StructuredNote.LogicPortfolio.ValueType  # 1
    """Волатильность."""
    LOGIC_PORTFOLIO_CORRELATION: StructuredNote.LogicPortfolio.ValueType  # 2
    """Корреляция."""

    class _ObservationPrinciple:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ObservationPrincipleEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StructuredNote._ObservationPrinciple.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        OBSERVATION_PRINCIPLE_UNSPECIFIED: StructuredNote._ObservationPrinciple.ValueType  # 0
        """Принцип наблюдений не определен."""
        OBSERVATION_PRINCIPLE_WORST_BASIC_ASSET: StructuredNote._ObservationPrinciple.ValueType  # 1
        """По худшему базовому активу."""
        OBSERVATION_PRINCIPLE_BEST_BASIC_ASSET: StructuredNote._ObservationPrinciple.ValueType  # 2
        """По лучшему базовому активу."""
        OBSERVATION_PRINCIPLE_AVERAGE_OF_BASIC_ASSETS: StructuredNote._ObservationPrinciple.ValueType  # 3
        """Среднее значение по базовым активам."""
        OBSERVATION_PRINCIPLE_SINGLE_BASIC_ASSET_PERFORMANCE: StructuredNote._ObservationPrinciple.ValueType  # 4
        """Динамика актива (только если у ноты один базовый актив)."""

    class ObservationPrinciple(_ObservationPrinciple, metaclass=_ObservationPrincipleEnumTypeWrapper):
        """Принцип наблюдений."""

    OBSERVATION_PRINCIPLE_UNSPECIFIED: StructuredNote.ObservationPrinciple.ValueType  # 0
    """Принцип наблюдений не определен."""
    OBSERVATION_PRINCIPLE_WORST_BASIC_ASSET: StructuredNote.ObservationPrinciple.ValueType  # 1
    """По худшему базовому активу."""
    OBSERVATION_PRINCIPLE_BEST_BASIC_ASSET: StructuredNote.ObservationPrinciple.ValueType  # 2
    """По лучшему базовому активу."""
    OBSERVATION_PRINCIPLE_AVERAGE_OF_BASIC_ASSETS: StructuredNote.ObservationPrinciple.ValueType  # 3
    """Среднее значение по базовым активам."""
    OBSERVATION_PRINCIPLE_SINGLE_BASIC_ASSET_PERFORMANCE: StructuredNote.ObservationPrinciple.ValueType  # 4
    """Динамика актива (только если у ноты один базовый актив)."""

    class _YieldType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _YieldTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StructuredNote._YieldType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        YIELD_TYPE_UNSPECIFIED: StructuredNote._YieldType.ValueType  # 0
        """Тип доходности не определен."""
        YIELD_TYPE_GUARANTED_COUPON: StructuredNote._YieldType.ValueType  # 1
        """Гарантированный купон."""
        YIELD_TYPE_CONDITIONAL_COUPON: StructuredNote._YieldType.ValueType  # 2
        """Условный купон."""
        YIELD_TYPE_PARTICIPATION: StructuredNote._YieldType.ValueType  # 3
        """Участие в росте."""

    class YieldType(_YieldType, metaclass=_YieldTypeEnumTypeWrapper):
        """Тип доходности."""

    YIELD_TYPE_UNSPECIFIED: StructuredNote.YieldType.ValueType  # 0
    """Тип доходности не определен."""
    YIELD_TYPE_GUARANTED_COUPON: StructuredNote.YieldType.ValueType  # 1
    """Гарантированный купон."""
    YIELD_TYPE_CONDITIONAL_COUPON: StructuredNote.YieldType.ValueType  # 2
    """Условный купон."""
    YIELD_TYPE_PARTICIPATION: StructuredNote.YieldType.ValueType  # 3
    """Участие в росте."""

    @typing.final
    class BasicAsset(google.protobuf.message.Message):
        """Базовый актив."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        UID_FIELD_NUMBER: builtins.int
        TYPE_FIELD_NUMBER: builtins.int
        INITIAL_PRICE_FIELD_NUMBER: builtins.int
        uid: builtins.str
        """Уникальный идентификатор базового актива."""
        type: global___AssetType.ValueType
        """Тип базового актива."""
        @property
        def initial_price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Начальная цена базового актива."""

        def __init__(
            self,
            *,
            uid: builtins.str = ...,
            type: global___AssetType.ValueType = ...,
            initial_price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["initial_price", b"initial_price"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["initial_price", b"initial_price", "type", b"type", "uid", b"uid"]) -> None: ...

    @typing.final
    class Yield(google.protobuf.message.Message):
        """Доходность."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TYPE_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        type: global___StructuredNote.YieldType.ValueType
        """Тип доходности."""
        @property
        def value(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Значение доходности."""

        def __init__(
            self,
            *,
            type: global___StructuredNote.YieldType.ValueType = ...,
            value: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["type", b"type", "value", b"value"]) -> None: ...

    UID_FIELD_NUMBER: builtins.int
    FIGI_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    ISIN_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    ASSET_UID_FIELD_NUMBER: builtins.int
    POSITION_UID_FIELD_NUMBER: builtins.int
    MIN_PRICE_INCREMENT_FIELD_NUMBER: builtins.int
    LOT_FIELD_NUMBER: builtins.int
    NOMINAL_FIELD_NUMBER: builtins.int
    CURRENCY_FIELD_NUMBER: builtins.int
    MATURITY_DATE_FIELD_NUMBER: builtins.int
    PLACEMENT_DATE_FIELD_NUMBER: builtins.int
    ISSUE_KIND_FIELD_NUMBER: builtins.int
    ISSUE_SIZE_FIELD_NUMBER: builtins.int
    ISSUE_SIZE_PLAN_FIELD_NUMBER: builtins.int
    DLONG_CLIENT_FIELD_NUMBER: builtins.int
    DSHORT_CLIENT_FIELD_NUMBER: builtins.int
    SHORT_ENABLED_FLAG_FIELD_NUMBER: builtins.int
    EXCHANGE_FIELD_NUMBER: builtins.int
    TRADING_STATUS_FIELD_NUMBER: builtins.int
    API_TRADE_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    BUY_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    SELL_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    LIMIT_ORDER_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    MARKET_ORDER_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    BESTPRICE_ORDER_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    WEEKEND_FLAG_FIELD_NUMBER: builtins.int
    LIQUIDITY_FLAG_FIELD_NUMBER: builtins.int
    FOR_IIS_FLAG_FIELD_NUMBER: builtins.int
    FOR_QUAL_INVESTOR_FLAG_FIELD_NUMBER: builtins.int
    PAWNSHOP_LIST_FLAG_FIELD_NUMBER: builtins.int
    REAL_EXCHANGE_FIELD_NUMBER: builtins.int
    FIRST_1MIN_CANDLE_DATE_FIELD_NUMBER: builtins.int
    FIRST_1DAY_CANDLE_DATE_FIELD_NUMBER: builtins.int
    BORROW_NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    LOGIC_PORTFOLIO_FIELD_NUMBER: builtins.int
    ASSET_TYPE_FIELD_NUMBER: builtins.int
    BASIC_ASSETS_FIELD_NUMBER: builtins.int
    SAFETY_BARRIER_FIELD_NUMBER: builtins.int
    COUPON_PERIOD_BASE_FIELD_NUMBER: builtins.int
    OBSERVATION_PRINCIPLE_FIELD_NUMBER: builtins.int
    OBSERVATION_FREQUENCY_FIELD_NUMBER: builtins.int
    INITIAL_PRICE_FIXING_DATE_FIELD_NUMBER: builtins.int
    YIELD_FIELD_NUMBER: builtins.int
    COUPON_SAVING_FLAG_FIELD_NUMBER: builtins.int
    SECTOR_FIELD_NUMBER: builtins.int
    COUNTRY_OF_RISK_FIELD_NUMBER: builtins.int
    COUNTRY_OF_RISK_NAME_FIELD_NUMBER: builtins.int
    LOGO_NAME_FIELD_NUMBER: builtins.int
    REQUIRED_TESTS_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """Уникальный идентификатор инструмента."""
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    isin: builtins.str
    """ISIN-идентификатор инструмента."""
    name: builtins.str
    """Название инструмента."""
    asset_uid: builtins.str
    """Уникальный идентификатор актива."""
    position_uid: builtins.str
    """Уникальный идентификатор позиции."""
    lot: builtins.int
    """Лотность инструмента."""
    currency: builtins.str
    """Валюта расчетов."""
    issue_kind: builtins.str
    """Форма выпуска."""
    issue_size: builtins.int
    """Размер выпуска."""
    issue_size_plan: builtins.int
    """Плановый размер выпуска."""
    short_enabled_flag: builtins.bool
    """Признак доступности для операций в шорт."""
    exchange: builtins.str
    """Торговая площадка (секция биржи)."""
    trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType
    """Текущий режим торгов инструмента."""
    api_trade_available_flag: builtins.bool
    """Признак доступности торгов по бумаге через API."""
    buy_available_flag: builtins.bool
    """Признак доступности для покупки."""
    sell_available_flag: builtins.bool
    """Признак доступности для продажи."""
    limit_order_available_flag: builtins.bool
    """Признак доступности выставления лимитной заявки по инструменту."""
    market_order_available_flag: builtins.bool
    """Признак доступности выставления рыночной заявки по инструменту."""
    bestprice_order_available_flag: builtins.bool
    """Признак доступности выставления bestprice заявки по инструменту."""
    weekend_flag: builtins.bool
    """Флаг отображающий доступность торговли инструментом по выходным."""
    liquidity_flag: builtins.bool
    """Флаг достаточной ликвидности."""
    for_iis_flag: builtins.bool
    """Возможность покупки/продажи на ИИС."""
    for_qual_investor_flag: builtins.bool
    """Флаг отображающий доступность торговли инструментом только для квалифицированных инвесторов."""
    pawnshop_list_flag: builtins.bool
    """Признак ФИ, включенного в ломбардный список."""
    real_exchange: tinkoff.invest.grpc.common_pb2.RealExchange.ValueType
    """Реальная площадка исполнения расчётов."""
    borrow_name: builtins.str
    """Название заемщика."""
    type: builtins.str
    """Тип структурной ноты."""
    logic_portfolio: global___StructuredNote.LogicPortfolio.ValueType
    """Стратегия портфеля."""
    asset_type: global___AssetType.ValueType
    """Тип базового актива."""
    coupon_period_base: builtins.str
    """Базис расчета НКД."""
    observation_principle: global___StructuredNote.ObservationPrinciple.ValueType
    """Принцип наблюдений."""
    observation_frequency: builtins.str
    """Частота наблюдений."""
    coupon_saving_flag: builtins.bool
    """Признак сохранения купонов."""
    sector: builtins.str
    """Сектор экономики."""
    country_of_risk: builtins.str
    """Код страны рисков."""
    country_of_risk_name: builtins.str
    """Наименование страны рисков."""
    logo_name: builtins.str
    """Имя файла логотипа эмитента."""
    @property
    def min_price_increment(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Шаг цены."""

    @property
    def nominal(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Номинал."""

    @property
    def maturity_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата погашения облигации в формате UTC."""

    @property
    def placement_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата размещения в формате UTC."""

    @property
    def dlong_client(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска клиента по инструменту лонг."""

    @property
    def dshort_client(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска клиента по инструменту шорт."""

    @property
    def first_1min_candle_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата первой минутной свечи."""

    @property
    def first_1day_candle_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата первой дневной свечи."""

    @property
    def basic_assets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StructuredNote.BasicAsset]:
        """Базовые активы, входящие в ноту."""

    @property
    def safety_barrier(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Барьер сохранности (в процентах)."""

    @property
    def initial_price_fixing_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата фиксации цен базовых активов."""

    @property
    def required_tests(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Тесты, которые необходимо пройти клиенту, чтобы совершать покупки по бумаге."""

    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        figi: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        isin: builtins.str = ...,
        name: builtins.str = ...,
        asset_uid: builtins.str = ...,
        position_uid: builtins.str = ...,
        min_price_increment: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        lot: builtins.int = ...,
        nominal: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        currency: builtins.str = ...,
        maturity_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        placement_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        issue_kind: builtins.str = ...,
        issue_size: builtins.int = ...,
        issue_size_plan: builtins.int = ...,
        dlong_client: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort_client: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        short_enabled_flag: builtins.bool = ...,
        exchange: builtins.str = ...,
        trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType = ...,
        api_trade_available_flag: builtins.bool = ...,
        buy_available_flag: builtins.bool = ...,
        sell_available_flag: builtins.bool = ...,
        limit_order_available_flag: builtins.bool = ...,
        market_order_available_flag: builtins.bool = ...,
        bestprice_order_available_flag: builtins.bool = ...,
        weekend_flag: builtins.bool = ...,
        liquidity_flag: builtins.bool = ...,
        for_iis_flag: builtins.bool = ...,
        for_qual_investor_flag: builtins.bool = ...,
        pawnshop_list_flag: builtins.bool = ...,
        real_exchange: tinkoff.invest.grpc.common_pb2.RealExchange.ValueType = ...,
        first_1min_candle_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        first_1day_candle_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        borrow_name: builtins.str = ...,
        type: builtins.str = ...,
        logic_portfolio: global___StructuredNote.LogicPortfolio.ValueType = ...,
        asset_type: global___AssetType.ValueType = ...,
        basic_assets: collections.abc.Iterable[global___StructuredNote.BasicAsset] | None = ...,
        safety_barrier: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        coupon_period_base: builtins.str = ...,
        observation_principle: global___StructuredNote.ObservationPrinciple.ValueType = ...,
        observation_frequency: builtins.str = ...,
        initial_price_fixing_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        coupon_saving_flag: builtins.bool = ...,
        sector: builtins.str = ...,
        country_of_risk: builtins.str = ...,
        country_of_risk_name: builtins.str = ...,
        logo_name: builtins.str = ...,
        required_tests: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["dlong_client", b"dlong_client", "dshort_client", b"dshort_client", "first_1day_candle_date", b"first_1day_candle_date", "first_1min_candle_date", b"first_1min_candle_date", "initial_price_fixing_date", b"initial_price_fixing_date", "maturity_date", b"maturity_date", "min_price_increment", b"min_price_increment", "nominal", b"nominal", "placement_date", b"placement_date", "safety_barrier", b"safety_barrier"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["api_trade_available_flag", b"api_trade_available_flag", "asset_type", b"asset_type", "asset_uid", b"asset_uid", "basic_assets", b"basic_assets", "bestprice_order_available_flag", b"bestprice_order_available_flag", "borrow_name", b"borrow_name", "buy_available_flag", b"buy_available_flag", "class_code", b"class_code", "country_of_risk", b"country_of_risk", "country_of_risk_name", b"country_of_risk_name", "coupon_period_base", b"coupon_period_base", "coupon_saving_flag", b"coupon_saving_flag", "currency", b"currency", "dlong_client", b"dlong_client", "dshort_client", b"dshort_client", "exchange", b"exchange", "figi", b"figi", "first_1day_candle_date", b"first_1day_candle_date", "first_1min_candle_date", b"first_1min_candle_date", "for_iis_flag", b"for_iis_flag", "for_qual_investor_flag", b"for_qual_investor_flag", "initial_price_fixing_date", b"initial_price_fixing_date", "isin", b"isin", "issue_kind", b"issue_kind", "issue_size", b"issue_size", "issue_size_plan", b"issue_size_plan", "limit_order_available_flag", b"limit_order_available_flag", "liquidity_flag", b"liquidity_flag", "logic_portfolio", b"logic_portfolio", "logo_name", b"logo_name", "lot", b"lot", "market_order_available_flag", b"market_order_available_flag", "maturity_date", b"maturity_date", "min_price_increment", b"min_price_increment", "name", b"name", "nominal", b"nominal", "observation_frequency", b"observation_frequency", "observation_principle", b"observation_principle", "pawnshop_list_flag", b"pawnshop_list_flag", "placement_date", b"placement_date", "position_uid", b"position_uid", "real_exchange", b"real_exchange", "required_tests", b"required_tests", "safety_barrier", b"safety_barrier", "sector", b"sector", "sell_available_flag", b"sell_available_flag", "short_enabled_flag", b"short_enabled_flag", "ticker", b"ticker", "trading_status", b"trading_status", "type", b"type", "uid", b"uid", "weekend_flag", b"weekend_flag", "yield", b"yield"]) -> None: ...

global___StructuredNote = StructuredNote

@typing.final
class GetAccruedInterestsRequest(google.protobuf.message.Message):
    """Запрос НКД по облигации."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    FROM_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    instrument_id: builtins.str
    """Идентификатор инструмента — `figi` или `instrument_uid`."""
    @property
    def to(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Окончание запрашиваемого периода по UTC."""

    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        to: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        instrument_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["from", b"from", "to", b"to"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["figi", b"figi", "from", b"from", "instrument_id", b"instrument_id", "to", b"to"]) -> None: ...

global___GetAccruedInterestsRequest = GetAccruedInterestsRequest

@typing.final
class GetAccruedInterestsResponse(google.protobuf.message.Message):
    """НКД облигации."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCRUED_INTERESTS_FIELD_NUMBER: builtins.int
    @property
    def accrued_interests(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AccruedInterest]:
        """Массив операций начисления купонов."""

    def __init__(
        self,
        *,
        accrued_interests: collections.abc.Iterable[global___AccruedInterest] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["accrued_interests", b"accrued_interests"]) -> None: ...

global___GetAccruedInterestsResponse = GetAccruedInterestsResponse

@typing.final
class AccruedInterest(google.protobuf.message.Message):
    """Операция начисления купонов."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATE_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    VALUE_PERCENT_FIELD_NUMBER: builtins.int
    NOMINAL_FIELD_NUMBER: builtins.int
    @property
    def date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата и время выплаты по UTC."""

    @property
    def value(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Величина выплаты."""

    @property
    def value_percent(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Величина выплаты в процентах от номинала."""

    @property
    def nominal(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Номинал облигации."""

    def __init__(
        self,
        *,
        date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        value: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        value_percent: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        nominal: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["date", b"date", "nominal", b"nominal", "value", b"value", "value_percent", b"value_percent"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["date", b"date", "nominal", b"nominal", "value", b"value", "value_percent", b"value_percent"]) -> None: ...

global___AccruedInterest = AccruedInterest

@typing.final
class GetFuturesMarginRequest(google.protobuf.message.Message):
    """Запрос информации о фьючерсе"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """Идентификатор инструмента."""
    instrument_id: builtins.str
    """Идентификатор инструмента — `figi` или `instrument_uid`."""
    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        instrument_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["figi", b"figi", "instrument_id", b"instrument_id"]) -> None: ...

global___GetFuturesMarginRequest = GetFuturesMarginRequest

@typing.final
class GetFuturesMarginResponse(google.protobuf.message.Message):
    """Данные по фьючерсу"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INITIAL_MARGIN_ON_BUY_FIELD_NUMBER: builtins.int
    INITIAL_MARGIN_ON_SELL_FIELD_NUMBER: builtins.int
    MIN_PRICE_INCREMENT_FIELD_NUMBER: builtins.int
    MIN_PRICE_INCREMENT_AMOUNT_FIELD_NUMBER: builtins.int
    @property
    def initial_margin_on_buy(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Гарантийное обеспечение при покупке."""

    @property
    def initial_margin_on_sell(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Гарантийное обеспечение при продаже."""

    @property
    def min_price_increment(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Шаг цены."""

    @property
    def min_price_increment_amount(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Стоимость шага цены."""

    def __init__(
        self,
        *,
        initial_margin_on_buy: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        initial_margin_on_sell: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        min_price_increment: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        min_price_increment_amount: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["initial_margin_on_buy", b"initial_margin_on_buy", "initial_margin_on_sell", b"initial_margin_on_sell", "min_price_increment", b"min_price_increment", "min_price_increment_amount", b"min_price_increment_amount"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["initial_margin_on_buy", b"initial_margin_on_buy", "initial_margin_on_sell", b"initial_margin_on_sell", "min_price_increment", b"min_price_increment", "min_price_increment_amount", b"min_price_increment_amount"]) -> None: ...

global___GetFuturesMarginResponse = GetFuturesMarginResponse

@typing.final
class InstrumentResponse(google.protobuf.message.Message):
    """Данные по инструменту."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_FIELD_NUMBER: builtins.int
    @property
    def instrument(self) -> global___Instrument:
        """Основная информация об инструменте."""

    def __init__(
        self,
        *,
        instrument: global___Instrument | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["instrument", b"instrument"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["instrument", b"instrument"]) -> None: ...

global___InstrumentResponse = InstrumentResponse

@typing.final
class Instrument(google.protobuf.message.Message):
    """Объект передачи основной информации об инструменте."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    ISIN_FIELD_NUMBER: builtins.int
    LOT_FIELD_NUMBER: builtins.int
    CURRENCY_FIELD_NUMBER: builtins.int
    KLONG_FIELD_NUMBER: builtins.int
    KSHORT_FIELD_NUMBER: builtins.int
    DLONG_FIELD_NUMBER: builtins.int
    DSHORT_FIELD_NUMBER: builtins.int
    DLONG_MIN_FIELD_NUMBER: builtins.int
    DSHORT_MIN_FIELD_NUMBER: builtins.int
    SHORT_ENABLED_FLAG_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    EXCHANGE_FIELD_NUMBER: builtins.int
    COUNTRY_OF_RISK_FIELD_NUMBER: builtins.int
    COUNTRY_OF_RISK_NAME_FIELD_NUMBER: builtins.int
    INSTRUMENT_TYPE_FIELD_NUMBER: builtins.int
    TRADING_STATUS_FIELD_NUMBER: builtins.int
    OTC_FLAG_FIELD_NUMBER: builtins.int
    BUY_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    SELL_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    MIN_PRICE_INCREMENT_FIELD_NUMBER: builtins.int
    API_TRADE_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    REAL_EXCHANGE_FIELD_NUMBER: builtins.int
    POSITION_UID_FIELD_NUMBER: builtins.int
    ASSET_UID_FIELD_NUMBER: builtins.int
    REQUIRED_TESTS_FIELD_NUMBER: builtins.int
    FOR_IIS_FLAG_FIELD_NUMBER: builtins.int
    FOR_QUAL_INVESTOR_FLAG_FIELD_NUMBER: builtins.int
    WEEKEND_FLAG_FIELD_NUMBER: builtins.int
    BLOCKED_TCA_FLAG_FIELD_NUMBER: builtins.int
    INSTRUMENT_KIND_FIELD_NUMBER: builtins.int
    FIRST_1MIN_CANDLE_DATE_FIELD_NUMBER: builtins.int
    FIRST_1DAY_CANDLE_DATE_FIELD_NUMBER: builtins.int
    BRAND_FIELD_NUMBER: builtins.int
    DLONG_CLIENT_FIELD_NUMBER: builtins.int
    DSHORT_CLIENT_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код инструмента."""
    isin: builtins.str
    """ISIN-идентификатор инструмента."""
    lot: builtins.int
    """Лотность инструмента. Возможно совершение операций только на количества ценной бумаги, кратные параметру `lot`. [Подробнее](./glossary#lot)."""
    currency: builtins.str
    """Валюта расчетов."""
    short_enabled_flag: builtins.bool
    """Признак доступности для операций в шорт."""
    name: builtins.str
    """Название инструмента."""
    exchange: builtins.str
    """Tорговая площадка (секция биржи)."""
    country_of_risk: builtins.str
    """Код страны риска — то есть страны, в которой компания ведет основной бизнес."""
    country_of_risk_name: builtins.str
    """Наименование страны риска — то есть страны, в которой компания ведет основной бизнес."""
    instrument_type: builtins.str
    """Тип инструмента."""
    trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType
    """Текущий режим торгов инструмента."""
    otc_flag: builtins.bool
    """Флаг, используемый ранее для определения внебиржевых инструментов. На данный момент не используется для торгуемых через API инструментов. Может использоваться как фильтр для операций, совершавшихся некоторое время назад на ОТС площадке."""
    buy_available_flag: builtins.bool
    """Признак доступности для покупки."""
    sell_available_flag: builtins.bool
    """Признак доступности для продажи."""
    api_trade_available_flag: builtins.bool
    """Параметр указывает на возможность торговать инструментом через API."""
    uid: builtins.str
    """Уникальный идентификатор инструмента."""
    real_exchange: tinkoff.invest.grpc.common_pb2.RealExchange.ValueType
    """Реальная площадка исполнения расчетов (биржа)."""
    position_uid: builtins.str
    """Уникальный идентификатор позиции инструмента."""
    asset_uid: builtins.str
    """Уникальный идентификатор актива."""
    for_iis_flag: builtins.bool
    """Признак доступности для ИИС."""
    for_qual_investor_flag: builtins.bool
    """Флаг, отображающий доступность торговли инструментом только для квалифицированных инвесторов."""
    weekend_flag: builtins.bool
    """Флаг, отображающий доступность торговли инструментом по выходным."""
    blocked_tca_flag: builtins.bool
    """Флаг заблокированного ТКС."""
    instrument_kind: tinkoff.invest.grpc.common_pb2.InstrumentType.ValueType
    """Тип инструмента."""
    @property
    def klong(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Коэффициент ставки риска длинной позиции по клиенту. 2 – клиент со стандартным уровнем риска (КСУР); 1 – клиент с повышенным уровнем риска (КПУР)."""

    @property
    def kshort(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Коэффициент ставки риска короткой позиции по клиенту. 2 – клиент со стандартным уровнем риска (КСУР); 1 – клиент с повышенным уровнем риска (КПУР)."""

    @property
    def dlong(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КСУР лонг. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КСУР шорт. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dlong_min(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КПУР лонг. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort_min(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска начальной маржи для КПУР шорт. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def min_price_increment(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Шаг цены."""

    @property
    def required_tests(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Тесты, которые необходимо пройти клиенту, чтобы совершать сделки по инструменту."""

    @property
    def first_1min_candle_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата первой минутной свечи."""

    @property
    def first_1day_candle_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата первой дневной свечи."""

    @property
    def brand(self) -> tinkoff.invest.grpc.common_pb2.BrandData:
        """Информация о бренде."""

    @property
    def dlong_client(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска в лонг с учетом текущего уровня риска портфеля клиента. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    @property
    def dshort_client(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка риска в шорт с учетом текущего уровня риска портфеля клиента. [Подробнее про ставки риска](https://www.tbank.ru/invest/help/brokerage/account/margin/about/#q5)."""

    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        isin: builtins.str = ...,
        lot: builtins.int = ...,
        currency: builtins.str = ...,
        klong: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        kshort: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dlong: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dlong_min: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort_min: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        short_enabled_flag: builtins.bool = ...,
        name: builtins.str = ...,
        exchange: builtins.str = ...,
        country_of_risk: builtins.str = ...,
        country_of_risk_name: builtins.str = ...,
        instrument_type: builtins.str = ...,
        trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType = ...,
        otc_flag: builtins.bool = ...,
        buy_available_flag: builtins.bool = ...,
        sell_available_flag: builtins.bool = ...,
        min_price_increment: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        api_trade_available_flag: builtins.bool = ...,
        uid: builtins.str = ...,
        real_exchange: tinkoff.invest.grpc.common_pb2.RealExchange.ValueType = ...,
        position_uid: builtins.str = ...,
        asset_uid: builtins.str = ...,
        required_tests: collections.abc.Iterable[builtins.str] | None = ...,
        for_iis_flag: builtins.bool = ...,
        for_qual_investor_flag: builtins.bool = ...,
        weekend_flag: builtins.bool = ...,
        blocked_tca_flag: builtins.bool = ...,
        instrument_kind: tinkoff.invest.grpc.common_pb2.InstrumentType.ValueType = ...,
        first_1min_candle_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        first_1day_candle_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        brand: tinkoff.invest.grpc.common_pb2.BrandData | None = ...,
        dlong_client: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dshort_client: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["brand", b"brand", "dlong", b"dlong", "dlong_client", b"dlong_client", "dlong_min", b"dlong_min", "dshort", b"dshort", "dshort_client", b"dshort_client", "dshort_min", b"dshort_min", "first_1day_candle_date", b"first_1day_candle_date", "first_1min_candle_date", b"first_1min_candle_date", "klong", b"klong", "kshort", b"kshort", "min_price_increment", b"min_price_increment"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["api_trade_available_flag", b"api_trade_available_flag", "asset_uid", b"asset_uid", "blocked_tca_flag", b"blocked_tca_flag", "brand", b"brand", "buy_available_flag", b"buy_available_flag", "class_code", b"class_code", "country_of_risk", b"country_of_risk", "country_of_risk_name", b"country_of_risk_name", "currency", b"currency", "dlong", b"dlong", "dlong_client", b"dlong_client", "dlong_min", b"dlong_min", "dshort", b"dshort", "dshort_client", b"dshort_client", "dshort_min", b"dshort_min", "exchange", b"exchange", "figi", b"figi", "first_1day_candle_date", b"first_1day_candle_date", "first_1min_candle_date", b"first_1min_candle_date", "for_iis_flag", b"for_iis_flag", "for_qual_investor_flag", b"for_qual_investor_flag", "instrument_kind", b"instrument_kind", "instrument_type", b"instrument_type", "isin", b"isin", "klong", b"klong", "kshort", b"kshort", "lot", b"lot", "min_price_increment", b"min_price_increment", "name", b"name", "otc_flag", b"otc_flag", "position_uid", b"position_uid", "real_exchange", b"real_exchange", "required_tests", b"required_tests", "sell_available_flag", b"sell_available_flag", "short_enabled_flag", b"short_enabled_flag", "ticker", b"ticker", "trading_status", b"trading_status", "uid", b"uid", "weekend_flag", b"weekend_flag"]) -> None: ...

global___Instrument = Instrument

@typing.final
class GetDividendsRequest(google.protobuf.message.Message):
    """Запрос дивидендов."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    FROM_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    instrument_id: builtins.str
    """Идентификатор инструмента — `figi` или `instrument_uid`."""
    @property
    def to(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Окончание запрашиваемого периода по UTC. Фильтрация происходит по параметру `record_date` — дата фиксации реестра."""

    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        to: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        instrument_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_from", b"_from", "_to", b"_to", "from", b"from", "to", b"to"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_from", b"_from", "_to", b"_to", "figi", b"figi", "from", b"from", "instrument_id", b"instrument_id", "to", b"to"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_from", b"_from"]) -> typing.Literal["from"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_to", b"_to"]) -> typing.Literal["to"] | None: ...

global___GetDividendsRequest = GetDividendsRequest

@typing.final
class GetDividendsResponse(google.protobuf.message.Message):
    """Дивиденды."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DIVIDENDS_FIELD_NUMBER: builtins.int
    @property
    def dividends(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Dividend]: ...
    def __init__(
        self,
        *,
        dividends: collections.abc.Iterable[global___Dividend] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dividends", b"dividends"]) -> None: ...

global___GetDividendsResponse = GetDividendsResponse

@typing.final
class Dividend(google.protobuf.message.Message):
    """Информация о выплате."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DIVIDEND_NET_FIELD_NUMBER: builtins.int
    PAYMENT_DATE_FIELD_NUMBER: builtins.int
    DECLARED_DATE_FIELD_NUMBER: builtins.int
    LAST_BUY_DATE_FIELD_NUMBER: builtins.int
    DIVIDEND_TYPE_FIELD_NUMBER: builtins.int
    RECORD_DATE_FIELD_NUMBER: builtins.int
    REGULARITY_FIELD_NUMBER: builtins.int
    CLOSE_PRICE_FIELD_NUMBER: builtins.int
    YIELD_VALUE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    dividend_type: builtins.str
    """Тип выплаты. Возможные значения: `Regular Cash` – регулярные выплаты, `Cancelled` – выплата отменена, `Daily Accrual` – ежедневное начисление, `Return of Capital` – возврат капитала, прочие типы выплат."""
    regularity: builtins.str
    """Регулярность выплаты. Возможные значения: `Annual` – ежегодная, `Semi-Anl` – каждые полгода, прочие типы выплат."""
    @property
    def dividend_net(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Величина дивиденда на 1 ценную бумагу (включая валюту)."""

    @property
    def payment_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата фактических выплат по UTC."""

    @property
    def declared_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата объявления дивидендов по UTC."""

    @property
    def last_buy_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Последний день (включительно) покупки для получения выплаты по UTC."""

    @property
    def record_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата фиксации реестра по UTC."""

    @property
    def close_price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Цена закрытия инструмента на момент `ex_dividend_date`."""

    @property
    def yield_value(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Величина доходности."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата и время создания записи по UTC."""

    def __init__(
        self,
        *,
        dividend_net: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        payment_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        declared_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_buy_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        dividend_type: builtins.str = ...,
        record_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        regularity: builtins.str = ...,
        close_price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        yield_value: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["close_price", b"close_price", "created_at", b"created_at", "declared_date", b"declared_date", "dividend_net", b"dividend_net", "last_buy_date", b"last_buy_date", "payment_date", b"payment_date", "record_date", b"record_date", "yield_value", b"yield_value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["close_price", b"close_price", "created_at", b"created_at", "declared_date", b"declared_date", "dividend_net", b"dividend_net", "dividend_type", b"dividend_type", "last_buy_date", b"last_buy_date", "payment_date", b"payment_date", "record_date", b"record_date", "regularity", b"regularity", "yield_value", b"yield_value"]) -> None: ...

global___Dividend = Dividend

@typing.final
class AssetRequest(google.protobuf.message.Message):
    """Запрос актива по идентификатору."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """UID-идентификатор актива."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["id", b"id"]) -> None: ...

global___AssetRequest = AssetRequest

@typing.final
class AssetResponse(google.protobuf.message.Message):
    """Данные по активу."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSET_FIELD_NUMBER: builtins.int
    @property
    def asset(self) -> global___AssetFull:
        """Актив."""

    def __init__(
        self,
        *,
        asset: global___AssetFull | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["asset", b"asset"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["asset", b"asset"]) -> None: ...

global___AssetResponse = AssetResponse

@typing.final
class AssetsRequest(google.protobuf.message.Message):
    """Запрос списка активов."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_TYPE_FIELD_NUMBER: builtins.int
    INSTRUMENT_STATUS_FIELD_NUMBER: builtins.int
    instrument_type: tinkoff.invest.grpc.common_pb2.InstrumentType.ValueType
    instrument_status: tinkoff.invest.grpc.common_pb2.InstrumentStatus.ValueType
    """Статус запрашиваемых инструментов. [Возможные значения](#instrumentstatus)."""
    def __init__(
        self,
        *,
        instrument_type: tinkoff.invest.grpc.common_pb2.InstrumentType.ValueType | None = ...,
        instrument_status: tinkoff.invest.grpc.common_pb2.InstrumentStatus.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_instrument_status", b"_instrument_status", "_instrument_type", b"_instrument_type", "instrument_status", b"instrument_status", "instrument_type", b"instrument_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_instrument_status", b"_instrument_status", "_instrument_type", b"_instrument_type", "instrument_status", b"instrument_status", "instrument_type", b"instrument_type"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_instrument_status", b"_instrument_status"]) -> typing.Literal["instrument_status"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_instrument_type", b"_instrument_type"]) -> typing.Literal["instrument_type"] | None: ...

global___AssetsRequest = AssetsRequest

@typing.final
class AssetsResponse(google.protobuf.message.Message):
    """Список активов."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSETS_FIELD_NUMBER: builtins.int
    @property
    def assets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Asset]:
        """Активы."""

    def __init__(
        self,
        *,
        assets: collections.abc.Iterable[global___Asset] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["assets", b"assets"]) -> None: ...

global___AssetsResponse = AssetsResponse

@typing.final
class AssetFull(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UID_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    NAME_BRIEF_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    DELETED_AT_FIELD_NUMBER: builtins.int
    REQUIRED_TESTS_FIELD_NUMBER: builtins.int
    CURRENCY_FIELD_NUMBER: builtins.int
    SECURITY_FIELD_NUMBER: builtins.int
    GOS_REG_CODE_FIELD_NUMBER: builtins.int
    CFI_FIELD_NUMBER: builtins.int
    CODE_NSD_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    BRAND_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    BR_CODE_FIELD_NUMBER: builtins.int
    BR_CODE_NAME_FIELD_NUMBER: builtins.int
    INSTRUMENTS_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """Уникальный идентификатор актива."""
    type: global___AssetType.ValueType
    """Тип актива."""
    name: builtins.str
    """Наименование актива."""
    name_brief: builtins.str
    """Короткое наименование актива."""
    description: builtins.str
    """Описание актива."""
    gos_reg_code: builtins.str
    """Номер государственной регистрации."""
    cfi: builtins.str
    """Код CFI."""
    code_nsd: builtins.str
    """Код НРД инструмента."""
    status: builtins.str
    """Статус актива."""
    br_code: builtins.str
    """Код типа ц.б. по классификации Банка России."""
    br_code_name: builtins.str
    """Наименование кода типа ц.б. по классификации Банка России."""
    @property
    def deleted_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата и время удаления актива."""

    @property
    def required_tests(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Тестирование клиентов."""

    @property
    def currency(self) -> global___AssetCurrency:
        """Валюта. Обязательно и заполняется только для `type = ASSET_TYPE_CURRENCY`."""

    @property
    def security(self) -> global___AssetSecurity:
        """Ценная бумага. Обязательно и заполняется только для `type = ASSET_TYPE_SECURITY`."""

    @property
    def brand(self) -> global___Brand:
        """Бренд."""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата и время последнего обновления записи."""

    @property
    def instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AssetInstrument]:
        """Массив идентификаторов инструментов."""

    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        type: global___AssetType.ValueType = ...,
        name: builtins.str = ...,
        name_brief: builtins.str = ...,
        description: builtins.str = ...,
        deleted_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        required_tests: collections.abc.Iterable[builtins.str] | None = ...,
        currency: global___AssetCurrency | None = ...,
        security: global___AssetSecurity | None = ...,
        gos_reg_code: builtins.str = ...,
        cfi: builtins.str = ...,
        code_nsd: builtins.str = ...,
        status: builtins.str = ...,
        brand: global___Brand | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        br_code: builtins.str = ...,
        br_code_name: builtins.str = ...,
        instruments: collections.abc.Iterable[global___AssetInstrument] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["brand", b"brand", "currency", b"currency", "deleted_at", b"deleted_at", "ext", b"ext", "security", b"security", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["br_code", b"br_code", "br_code_name", b"br_code_name", "brand", b"brand", "cfi", b"cfi", "code_nsd", b"code_nsd", "currency", b"currency", "deleted_at", b"deleted_at", "description", b"description", "ext", b"ext", "gos_reg_code", b"gos_reg_code", "instruments", b"instruments", "name", b"name", "name_brief", b"name_brief", "required_tests", b"required_tests", "security", b"security", "status", b"status", "type", b"type", "uid", b"uid", "updated_at", b"updated_at"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["ext", b"ext"]) -> typing.Literal["currency", "security"] | None: ...

global___AssetFull = AssetFull

@typing.final
class Asset(google.protobuf.message.Message):
    """Информация об активе."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UID_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    INSTRUMENTS_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """Уникальный идентификатор актива."""
    type: global___AssetType.ValueType
    """Тип актива."""
    name: builtins.str
    """Наименование актива."""
    @property
    def instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AssetInstrument]:
        """Массив идентификаторов инструментов."""

    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        type: global___AssetType.ValueType = ...,
        name: builtins.str = ...,
        instruments: collections.abc.Iterable[global___AssetInstrument] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instruments", b"instruments", "name", b"name", "type", b"type", "uid", b"uid"]) -> None: ...

global___Asset = Asset

@typing.final
class AssetCurrency(google.protobuf.message.Message):
    """Валюта."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BASE_CURRENCY_FIELD_NUMBER: builtins.int
    base_currency: builtins.str
    """ISO-код валюты."""
    def __init__(
        self,
        *,
        base_currency: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["base_currency", b"base_currency"]) -> None: ...

global___AssetCurrency = AssetCurrency

@typing.final
class AssetSecurity(google.protobuf.message.Message):
    """Ценная бумага."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ISIN_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    INSTRUMENT_KIND_FIELD_NUMBER: builtins.int
    SHARE_FIELD_NUMBER: builtins.int
    BOND_FIELD_NUMBER: builtins.int
    SP_FIELD_NUMBER: builtins.int
    ETF_FIELD_NUMBER: builtins.int
    CLEARING_CERTIFICATE_FIELD_NUMBER: builtins.int
    isin: builtins.str
    """ISIN-идентификатор ценной бумаги."""
    type: builtins.str
    """Тип ценной бумаги."""
    instrument_kind: tinkoff.invest.grpc.common_pb2.InstrumentType.ValueType
    """Тип инструмента."""
    @property
    def share(self) -> global___AssetShare:
        """Акция. Заполняется только для акций — тип актива `asset.type = ASSET_TYPE_SECURITY` и `security.type = share`."""

    @property
    def bond(self) -> global___AssetBond:
        """Облигация. Заполняется только для облигаций — тип актива `asset.type = ASSET_TYPE_SECURITY` и `security.type = bond`."""

    @property
    def sp(self) -> global___AssetStructuredProduct:
        """Структурная нота. Заполняется только для структурных продуктов — тип актива `asset.type = ASSET_TYPE_SECURITY` и `security.type = sp`."""

    @property
    def etf(self) -> global___AssetEtf:
        """Фонд. Заполняется только для фондов — тип актива `asset.type = ASSET_TYPE_SECURITY` и `security.type = etf`."""

    @property
    def clearing_certificate(self) -> global___AssetClearingCertificate:
        """Клиринговый сертификат участия. Заполняется только для клиринговых сертификатов — тип актива `asset.type = ASSET_TYPE_SECURITY` и security.type = `clearing_certificate`."""

    def __init__(
        self,
        *,
        isin: builtins.str = ...,
        type: builtins.str = ...,
        instrument_kind: tinkoff.invest.grpc.common_pb2.InstrumentType.ValueType = ...,
        share: global___AssetShare | None = ...,
        bond: global___AssetBond | None = ...,
        sp: global___AssetStructuredProduct | None = ...,
        etf: global___AssetEtf | None = ...,
        clearing_certificate: global___AssetClearingCertificate | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["bond", b"bond", "clearing_certificate", b"clearing_certificate", "etf", b"etf", "ext", b"ext", "share", b"share", "sp", b"sp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["bond", b"bond", "clearing_certificate", b"clearing_certificate", "etf", b"etf", "ext", b"ext", "instrument_kind", b"instrument_kind", "isin", b"isin", "share", b"share", "sp", b"sp", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["ext", b"ext"]) -> typing.Literal["share", "bond", "sp", "etf", "clearing_certificate"] | None: ...

global___AssetSecurity = AssetSecurity

@typing.final
class AssetShare(google.protobuf.message.Message):
    """Акция."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    ISSUE_SIZE_FIELD_NUMBER: builtins.int
    NOMINAL_FIELD_NUMBER: builtins.int
    NOMINAL_CURRENCY_FIELD_NUMBER: builtins.int
    PRIMARY_INDEX_FIELD_NUMBER: builtins.int
    DIVIDEND_RATE_FIELD_NUMBER: builtins.int
    PREFERRED_SHARE_TYPE_FIELD_NUMBER: builtins.int
    IPO_DATE_FIELD_NUMBER: builtins.int
    REGISTRY_DATE_FIELD_NUMBER: builtins.int
    DIV_YIELD_FLAG_FIELD_NUMBER: builtins.int
    ISSUE_KIND_FIELD_NUMBER: builtins.int
    PLACEMENT_DATE_FIELD_NUMBER: builtins.int
    REPRES_ISIN_FIELD_NUMBER: builtins.int
    ISSUE_SIZE_PLAN_FIELD_NUMBER: builtins.int
    TOTAL_FLOAT_FIELD_NUMBER: builtins.int
    type: global___ShareType.ValueType
    """Тип акции."""
    nominal_currency: builtins.str
    """Валюта номинала."""
    primary_index: builtins.str
    """Индекс (Bloomberg)."""
    preferred_share_type: builtins.str
    """Тип привилегированных акций."""
    div_yield_flag: builtins.bool
    """Признак наличия дивидендной доходности."""
    issue_kind: builtins.str
    """Форма выпуска ФИ."""
    repres_isin: builtins.str
    """ISIN базового актива."""
    @property
    def issue_size(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Объем выпуска (шт.)."""

    @property
    def nominal(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Номинал."""

    @property
    def dividend_rate(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка дивиденда (для привилегированных акций)."""

    @property
    def ipo_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата IPO."""

    @property
    def registry_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата регистрации."""

    @property
    def placement_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата размещения акции."""

    @property
    def issue_size_plan(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Объявленное количество, шт."""

    @property
    def total_float(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Количество акций в свободном обращении."""

    def __init__(
        self,
        *,
        type: global___ShareType.ValueType = ...,
        issue_size: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        nominal: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        nominal_currency: builtins.str = ...,
        primary_index: builtins.str = ...,
        dividend_rate: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        preferred_share_type: builtins.str = ...,
        ipo_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        registry_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        div_yield_flag: builtins.bool = ...,
        issue_kind: builtins.str = ...,
        placement_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        repres_isin: builtins.str = ...,
        issue_size_plan: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        total_float: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["dividend_rate", b"dividend_rate", "ipo_date", b"ipo_date", "issue_size", b"issue_size", "issue_size_plan", b"issue_size_plan", "nominal", b"nominal", "placement_date", b"placement_date", "registry_date", b"registry_date", "total_float", b"total_float"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["div_yield_flag", b"div_yield_flag", "dividend_rate", b"dividend_rate", "ipo_date", b"ipo_date", "issue_kind", b"issue_kind", "issue_size", b"issue_size", "issue_size_plan", b"issue_size_plan", "nominal", b"nominal", "nominal_currency", b"nominal_currency", "placement_date", b"placement_date", "preferred_share_type", b"preferred_share_type", "primary_index", b"primary_index", "registry_date", b"registry_date", "repres_isin", b"repres_isin", "total_float", b"total_float", "type", b"type"]) -> None: ...

global___AssetShare = AssetShare

@typing.final
class AssetBond(google.protobuf.message.Message):
    """Облигация."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CURRENT_NOMINAL_FIELD_NUMBER: builtins.int
    BORROW_NAME_FIELD_NUMBER: builtins.int
    ISSUE_SIZE_FIELD_NUMBER: builtins.int
    NOMINAL_FIELD_NUMBER: builtins.int
    NOMINAL_CURRENCY_FIELD_NUMBER: builtins.int
    ISSUE_KIND_FIELD_NUMBER: builtins.int
    INTEREST_KIND_FIELD_NUMBER: builtins.int
    COUPON_QUANTITY_PER_YEAR_FIELD_NUMBER: builtins.int
    INDEXED_NOMINAL_FLAG_FIELD_NUMBER: builtins.int
    SUBORDINATED_FLAG_FIELD_NUMBER: builtins.int
    COLLATERAL_FLAG_FIELD_NUMBER: builtins.int
    TAX_FREE_FLAG_FIELD_NUMBER: builtins.int
    AMORTIZATION_FLAG_FIELD_NUMBER: builtins.int
    FLOATING_COUPON_FLAG_FIELD_NUMBER: builtins.int
    PERPETUAL_FLAG_FIELD_NUMBER: builtins.int
    MATURITY_DATE_FIELD_NUMBER: builtins.int
    RETURN_CONDITION_FIELD_NUMBER: builtins.int
    STATE_REG_DATE_FIELD_NUMBER: builtins.int
    PLACEMENT_DATE_FIELD_NUMBER: builtins.int
    PLACEMENT_PRICE_FIELD_NUMBER: builtins.int
    ISSUE_SIZE_PLAN_FIELD_NUMBER: builtins.int
    borrow_name: builtins.str
    """Наименование заемщика."""
    nominal_currency: builtins.str
    """Валюта номинала."""
    issue_kind: builtins.str
    """Форма выпуска облигации."""
    interest_kind: builtins.str
    """Форма дохода облигации."""
    coupon_quantity_per_year: builtins.int
    """Количество выплат в год."""
    indexed_nominal_flag: builtins.bool
    """Признак облигации с индексируемым номиналом."""
    subordinated_flag: builtins.bool
    """Признак субординированной облигации."""
    collateral_flag: builtins.bool
    """Признак обеспеченной облигации."""
    tax_free_flag: builtins.bool
    """Признак показывает, что купоны облигации не облагаются налогом — для mass market."""
    amortization_flag: builtins.bool
    """Признак облигации с амортизацией долга."""
    floating_coupon_flag: builtins.bool
    """Признак облигации с плавающим купоном."""
    perpetual_flag: builtins.bool
    """Признак бессрочной облигации."""
    return_condition: builtins.str
    """Описание и условия получения дополнительного дохода."""
    @property
    def current_nominal(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Текущий номинал."""

    @property
    def issue_size(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Объем эмиссии облигации (стоимость)."""

    @property
    def nominal(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Номинал облигации."""

    @property
    def maturity_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата погашения облигации."""

    @property
    def state_reg_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата выпуска облигации."""

    @property
    def placement_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата размещения облигации."""

    @property
    def placement_price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена размещения облигации."""

    @property
    def issue_size_plan(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Объявленное количество, шт."""

    def __init__(
        self,
        *,
        current_nominal: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        borrow_name: builtins.str = ...,
        issue_size: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        nominal: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        nominal_currency: builtins.str = ...,
        issue_kind: builtins.str = ...,
        interest_kind: builtins.str = ...,
        coupon_quantity_per_year: builtins.int = ...,
        indexed_nominal_flag: builtins.bool = ...,
        subordinated_flag: builtins.bool = ...,
        collateral_flag: builtins.bool = ...,
        tax_free_flag: builtins.bool = ...,
        amortization_flag: builtins.bool = ...,
        floating_coupon_flag: builtins.bool = ...,
        perpetual_flag: builtins.bool = ...,
        maturity_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        return_condition: builtins.str = ...,
        state_reg_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        placement_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        placement_price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        issue_size_plan: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["current_nominal", b"current_nominal", "issue_size", b"issue_size", "issue_size_plan", b"issue_size_plan", "maturity_date", b"maturity_date", "nominal", b"nominal", "placement_date", b"placement_date", "placement_price", b"placement_price", "state_reg_date", b"state_reg_date"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["amortization_flag", b"amortization_flag", "borrow_name", b"borrow_name", "collateral_flag", b"collateral_flag", "coupon_quantity_per_year", b"coupon_quantity_per_year", "current_nominal", b"current_nominal", "floating_coupon_flag", b"floating_coupon_flag", "indexed_nominal_flag", b"indexed_nominal_flag", "interest_kind", b"interest_kind", "issue_kind", b"issue_kind", "issue_size", b"issue_size", "issue_size_plan", b"issue_size_plan", "maturity_date", b"maturity_date", "nominal", b"nominal", "nominal_currency", b"nominal_currency", "perpetual_flag", b"perpetual_flag", "placement_date", b"placement_date", "placement_price", b"placement_price", "return_condition", b"return_condition", "state_reg_date", b"state_reg_date", "subordinated_flag", b"subordinated_flag", "tax_free_flag", b"tax_free_flag"]) -> None: ...

global___AssetBond = AssetBond

@typing.final
class AssetStructuredProduct(google.protobuf.message.Message):
    """Структурная нота."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BORROW_NAME_FIELD_NUMBER: builtins.int
    NOMINAL_FIELD_NUMBER: builtins.int
    NOMINAL_CURRENCY_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    LOGIC_PORTFOLIO_FIELD_NUMBER: builtins.int
    ASSET_TYPE_FIELD_NUMBER: builtins.int
    BASIC_ASSET_FIELD_NUMBER: builtins.int
    SAFETY_BARRIER_FIELD_NUMBER: builtins.int
    MATURITY_DATE_FIELD_NUMBER: builtins.int
    ISSUE_SIZE_PLAN_FIELD_NUMBER: builtins.int
    ISSUE_SIZE_FIELD_NUMBER: builtins.int
    PLACEMENT_DATE_FIELD_NUMBER: builtins.int
    ISSUE_KIND_FIELD_NUMBER: builtins.int
    borrow_name: builtins.str
    """Наименование заемщика."""
    nominal_currency: builtins.str
    """Валюта номинала."""
    type: global___StructuredProductType.ValueType
    """Тип структурной ноты."""
    logic_portfolio: builtins.str
    """Стратегия портфеля."""
    asset_type: global___AssetType.ValueType
    """Тип базового актива."""
    basic_asset: builtins.str
    """Вид базового актива в зависимости от типа базового актива."""
    issue_kind: builtins.str
    """Форма выпуска."""
    @property
    def nominal(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Номинал."""

    @property
    def safety_barrier(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Барьер сохранности в процентах."""

    @property
    def maturity_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата погашения."""

    @property
    def issue_size_plan(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Объявленное количество, шт."""

    @property
    def issue_size(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Объем размещения."""

    @property
    def placement_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата размещения ноты."""

    def __init__(
        self,
        *,
        borrow_name: builtins.str = ...,
        nominal: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        nominal_currency: builtins.str = ...,
        type: global___StructuredProductType.ValueType = ...,
        logic_portfolio: builtins.str = ...,
        asset_type: global___AssetType.ValueType = ...,
        basic_asset: builtins.str = ...,
        safety_barrier: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        maturity_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        issue_size_plan: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        issue_size: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        placement_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        issue_kind: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["issue_size", b"issue_size", "issue_size_plan", b"issue_size_plan", "maturity_date", b"maturity_date", "nominal", b"nominal", "placement_date", b"placement_date", "safety_barrier", b"safety_barrier"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["asset_type", b"asset_type", "basic_asset", b"basic_asset", "borrow_name", b"borrow_name", "issue_kind", b"issue_kind", "issue_size", b"issue_size", "issue_size_plan", b"issue_size_plan", "logic_portfolio", b"logic_portfolio", "maturity_date", b"maturity_date", "nominal", b"nominal", "nominal_currency", b"nominal_currency", "placement_date", b"placement_date", "safety_barrier", b"safety_barrier", "type", b"type"]) -> None: ...

global___AssetStructuredProduct = AssetStructuredProduct

@typing.final
class AssetEtf(google.protobuf.message.Message):
    """Фонд."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOTAL_EXPENSE_FIELD_NUMBER: builtins.int
    HURDLE_RATE_FIELD_NUMBER: builtins.int
    PERFORMANCE_FEE_FIELD_NUMBER: builtins.int
    FIXED_COMMISSION_FIELD_NUMBER: builtins.int
    PAYMENT_TYPE_FIELD_NUMBER: builtins.int
    WATERMARK_FLAG_FIELD_NUMBER: builtins.int
    BUY_PREMIUM_FIELD_NUMBER: builtins.int
    SELL_DISCOUNT_FIELD_NUMBER: builtins.int
    REBALANCING_FLAG_FIELD_NUMBER: builtins.int
    REBALANCING_FREQ_FIELD_NUMBER: builtins.int
    MANAGEMENT_TYPE_FIELD_NUMBER: builtins.int
    PRIMARY_INDEX_FIELD_NUMBER: builtins.int
    FOCUS_TYPE_FIELD_NUMBER: builtins.int
    LEVERAGED_FLAG_FIELD_NUMBER: builtins.int
    NUM_SHARE_FIELD_NUMBER: builtins.int
    UCITS_FLAG_FIELD_NUMBER: builtins.int
    RELEASED_DATE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    PRIMARY_INDEX_DESCRIPTION_FIELD_NUMBER: builtins.int
    PRIMARY_INDEX_COMPANY_FIELD_NUMBER: builtins.int
    INDEX_RECOVERY_PERIOD_FIELD_NUMBER: builtins.int
    INAV_CODE_FIELD_NUMBER: builtins.int
    DIV_YIELD_FLAG_FIELD_NUMBER: builtins.int
    EXPENSE_COMMISSION_FIELD_NUMBER: builtins.int
    PRIMARY_INDEX_TRACKING_ERROR_FIELD_NUMBER: builtins.int
    REBALANCING_PLAN_FIELD_NUMBER: builtins.int
    TAX_RATE_FIELD_NUMBER: builtins.int
    REBALANCING_DATES_FIELD_NUMBER: builtins.int
    ISSUE_KIND_FIELD_NUMBER: builtins.int
    NOMINAL_FIELD_NUMBER: builtins.int
    NOMINAL_CURRENCY_FIELD_NUMBER: builtins.int
    payment_type: builtins.str
    """Тип распределения доходов от выплат по бумагам."""
    watermark_flag: builtins.bool
    """Признак необходимости выхода фонда в плюс для получения комиссии."""
    rebalancing_flag: builtins.bool
    """Признак ребалансируемости портфеля фонда."""
    rebalancing_freq: builtins.str
    """Периодичность ребалансировки."""
    management_type: builtins.str
    """Тип управления."""
    primary_index: builtins.str
    """Индекс, который реплицирует (старается копировать) фонд."""
    focus_type: builtins.str
    """База ETF."""
    leveraged_flag: builtins.bool
    """Признак использования заемных активов (плечо)."""
    ucits_flag: builtins.bool
    """Признак обязательства по отчетности перед регулятором."""
    description: builtins.str
    """Описание фонда."""
    primary_index_description: builtins.str
    """Описание индекса, за которым следует фонд."""
    primary_index_company: builtins.str
    """Основные компании, в которые вкладывается фонд."""
    inav_code: builtins.str
    """IVAV-код."""
    div_yield_flag: builtins.bool
    """Признак наличия дивидендной доходности."""
    rebalancing_plan: builtins.str
    """Плановая ребалансировка портфеля."""
    tax_rate: builtins.str
    """Ставки налогообложения дивидендов и купонов."""
    issue_kind: builtins.str
    """Форма выпуска."""
    nominal_currency: builtins.str
    """Валюта номинала."""
    @property
    def total_expense(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Суммарные расходы фонда в процентах."""

    @property
    def hurdle_rate(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Барьерная ставка доходности, после которой фонд имеет право на perfomance fee — в процентах."""

    @property
    def performance_fee(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Комиссия за успешные результаты фонда в процентах."""

    @property
    def fixed_commission(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Фиксированная комиссия за управление в процентах."""

    @property
    def buy_premium(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Премия (надбавка к цене) при покупке доли в фонде — в процентах."""

    @property
    def sell_discount(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка дисконта (вычет из цены) при продаже доли в фонде — в процентах."""

    @property
    def num_share(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Количество акций в обращении."""

    @property
    def released_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата выпуска."""

    @property
    def index_recovery_period(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Срок восстановления индекса после просадки."""

    @property
    def expense_commission(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Комиссия на покрытие расходов фонда в процентах."""

    @property
    def primary_index_tracking_error(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ошибка следования за индексом в процентах."""

    @property
    def rebalancing_dates(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.timestamp_pb2.Timestamp]:
        """Даты ребалансировок."""

    @property
    def nominal(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Номинал."""

    def __init__(
        self,
        *,
        total_expense: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        hurdle_rate: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        performance_fee: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        fixed_commission: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        payment_type: builtins.str = ...,
        watermark_flag: builtins.bool = ...,
        buy_premium: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        sell_discount: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        rebalancing_flag: builtins.bool = ...,
        rebalancing_freq: builtins.str = ...,
        management_type: builtins.str = ...,
        primary_index: builtins.str = ...,
        focus_type: builtins.str = ...,
        leveraged_flag: builtins.bool = ...,
        num_share: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        ucits_flag: builtins.bool = ...,
        released_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        description: builtins.str = ...,
        primary_index_description: builtins.str = ...,
        primary_index_company: builtins.str = ...,
        index_recovery_period: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        inav_code: builtins.str = ...,
        div_yield_flag: builtins.bool = ...,
        expense_commission: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        primary_index_tracking_error: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        rebalancing_plan: builtins.str = ...,
        tax_rate: builtins.str = ...,
        rebalancing_dates: collections.abc.Iterable[google.protobuf.timestamp_pb2.Timestamp] | None = ...,
        issue_kind: builtins.str = ...,
        nominal: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        nominal_currency: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["buy_premium", b"buy_premium", "expense_commission", b"expense_commission", "fixed_commission", b"fixed_commission", "hurdle_rate", b"hurdle_rate", "index_recovery_period", b"index_recovery_period", "nominal", b"nominal", "num_share", b"num_share", "performance_fee", b"performance_fee", "primary_index_tracking_error", b"primary_index_tracking_error", "released_date", b"released_date", "sell_discount", b"sell_discount", "total_expense", b"total_expense"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["buy_premium", b"buy_premium", "description", b"description", "div_yield_flag", b"div_yield_flag", "expense_commission", b"expense_commission", "fixed_commission", b"fixed_commission", "focus_type", b"focus_type", "hurdle_rate", b"hurdle_rate", "inav_code", b"inav_code", "index_recovery_period", b"index_recovery_period", "issue_kind", b"issue_kind", "leveraged_flag", b"leveraged_flag", "management_type", b"management_type", "nominal", b"nominal", "nominal_currency", b"nominal_currency", "num_share", b"num_share", "payment_type", b"payment_type", "performance_fee", b"performance_fee", "primary_index", b"primary_index", "primary_index_company", b"primary_index_company", "primary_index_description", b"primary_index_description", "primary_index_tracking_error", b"primary_index_tracking_error", "rebalancing_dates", b"rebalancing_dates", "rebalancing_flag", b"rebalancing_flag", "rebalancing_freq", b"rebalancing_freq", "rebalancing_plan", b"rebalancing_plan", "released_date", b"released_date", "sell_discount", b"sell_discount", "tax_rate", b"tax_rate", "total_expense", b"total_expense", "ucits_flag", b"ucits_flag", "watermark_flag", b"watermark_flag"]) -> None: ...

global___AssetEtf = AssetEtf

@typing.final
class AssetClearingCertificate(google.protobuf.message.Message):
    """Клиринговый сертификат участия."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NOMINAL_FIELD_NUMBER: builtins.int
    NOMINAL_CURRENCY_FIELD_NUMBER: builtins.int
    nominal_currency: builtins.str
    """Валюта номинала."""
    @property
    def nominal(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Номинал."""

    def __init__(
        self,
        *,
        nominal: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        nominal_currency: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["nominal", b"nominal"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["nominal", b"nominal", "nominal_currency", b"nominal_currency"]) -> None: ...

global___AssetClearingCertificate = AssetClearingCertificate

@typing.final
class Brand(google.protobuf.message.Message):
    """Бренд."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    COMPANY_FIELD_NUMBER: builtins.int
    SECTOR_FIELD_NUMBER: builtins.int
    COUNTRY_OF_RISK_FIELD_NUMBER: builtins.int
    COUNTRY_OF_RISK_NAME_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """UID-идентификатор бренда."""
    name: builtins.str
    """Наименование бренда."""
    description: builtins.str
    """Описание."""
    info: builtins.str
    """Информация о бренде."""
    company: builtins.str
    """Компания."""
    sector: builtins.str
    """Сектор."""
    country_of_risk: builtins.str
    """Код страны риска."""
    country_of_risk_name: builtins.str
    """Наименование страны риска."""
    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        info: builtins.str = ...,
        company: builtins.str = ...,
        sector: builtins.str = ...,
        country_of_risk: builtins.str = ...,
        country_of_risk_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["company", b"company", "country_of_risk", b"country_of_risk", "country_of_risk_name", b"country_of_risk_name", "description", b"description", "info", b"info", "name", b"name", "sector", b"sector", "uid", b"uid"]) -> None: ...

global___Brand = Brand

@typing.final
class AssetInstrument(google.protobuf.message.Message):
    """Идентификаторы инструмента."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UID_FIELD_NUMBER: builtins.int
    FIGI_FIELD_NUMBER: builtins.int
    INSTRUMENT_TYPE_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    LINKS_FIELD_NUMBER: builtins.int
    INSTRUMENT_KIND_FIELD_NUMBER: builtins.int
    POSITION_UID_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """UID-идентификатор инструмента."""
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    instrument_type: builtins.str
    """Тип инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    instrument_kind: tinkoff.invest.grpc.common_pb2.InstrumentType.ValueType
    """Тип инструмента."""
    position_uid: builtins.str
    """ID позиции."""
    @property
    def links(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___InstrumentLink]:
        """Массив связанных инструментов."""

    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        figi: builtins.str = ...,
        instrument_type: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        links: collections.abc.Iterable[global___InstrumentLink] | None = ...,
        instrument_kind: tinkoff.invest.grpc.common_pb2.InstrumentType.ValueType = ...,
        position_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["class_code", b"class_code", "figi", b"figi", "instrument_kind", b"instrument_kind", "instrument_type", b"instrument_type", "links", b"links", "position_uid", b"position_uid", "ticker", b"ticker", "uid", b"uid"]) -> None: ...

global___AssetInstrument = AssetInstrument

@typing.final
class InstrumentLink(google.protobuf.message.Message):
    """Связь с другим инструментом."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    type: builtins.str
    """Тип связи."""
    instrument_uid: builtins.str
    """UID-идентификатор связанного инструмента."""
    def __init__(
        self,
        *,
        type: builtins.str = ...,
        instrument_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instrument_uid", b"instrument_uid", "type", b"type"]) -> None: ...

global___InstrumentLink = InstrumentLink

@typing.final
class GetFavoritesRequest(google.protobuf.message.Message):
    """Запрос списка избранных инструментов, входные параметры не требуются."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """Уникальный идентификатор группы."""
    def __init__(
        self,
        *,
        group_id: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_group_id", b"_group_id", "group_id", b"group_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_group_id", b"_group_id", "group_id", b"group_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_group_id", b"_group_id"]) -> typing.Literal["group_id"] | None: ...

global___GetFavoritesRequest = GetFavoritesRequest

@typing.final
class GetFavoritesResponse(google.protobuf.message.Message):
    """В ответ передается список избранных инструментов в качестве массива."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FAVORITE_INSTRUMENTS_FIELD_NUMBER: builtins.int
    GROUP_ID_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """Уникальный идентификатор группы."""
    @property
    def favorite_instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FavoriteInstrument]:
        """Массив инструментов."""

    def __init__(
        self,
        *,
        favorite_instruments: collections.abc.Iterable[global___FavoriteInstrument] | None = ...,
        group_id: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_group_id", b"_group_id", "group_id", b"group_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_group_id", b"_group_id", "favorite_instruments", b"favorite_instruments", "group_id", b"group_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_group_id", b"_group_id"]) -> typing.Literal["group_id"] | None: ...

global___GetFavoritesResponse = GetFavoritesResponse

@typing.final
class FavoriteInstrument(google.protobuf.message.Message):
    """Массив избранных инструментов."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    ISIN_FIELD_NUMBER: builtins.int
    INSTRUMENT_TYPE_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    OTC_FLAG_FIELD_NUMBER: builtins.int
    API_TRADE_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    INSTRUMENT_KIND_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код инструмента."""
    isin: builtins.str
    """ISIN-идентификатор инструмента."""
    instrument_type: builtins.str
    """Тип инструмента."""
    name: builtins.str
    """Название инструмента."""
    uid: builtins.str
    """Уникальный идентификатор инструмента."""
    otc_flag: builtins.bool
    """Флаг, используемый ранее для определения внебиржевых инструментов. На данный момент не используется для торгуемых через API инструментов. Может использоваться как фильтр для операций, совершавшихся некоторое время назад на ОТС площадке."""
    api_trade_available_flag: builtins.bool
    """Возможность торговать инструментом через API."""
    instrument_kind: tinkoff.invest.grpc.common_pb2.InstrumentType.ValueType
    """Тип инструмента."""
    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        isin: builtins.str = ...,
        instrument_type: builtins.str = ...,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        otc_flag: builtins.bool = ...,
        api_trade_available_flag: builtins.bool = ...,
        instrument_kind: tinkoff.invest.grpc.common_pb2.InstrumentType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["api_trade_available_flag", b"api_trade_available_flag", "class_code", b"class_code", "figi", b"figi", "instrument_kind", b"instrument_kind", "instrument_type", b"instrument_type", "isin", b"isin", "name", b"name", "otc_flag", b"otc_flag", "ticker", b"ticker", "uid", b"uid"]) -> None: ...

global___FavoriteInstrument = FavoriteInstrument

@typing.final
class EditFavoritesRequest(google.protobuf.message.Message):
    """Запрос редактирования списка избранных инструментов."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENTS_FIELD_NUMBER: builtins.int
    ACTION_TYPE_FIELD_NUMBER: builtins.int
    GROUP_ID_FIELD_NUMBER: builtins.int
    action_type: global___EditFavoritesActionType.ValueType
    """Тип действия со списком."""
    group_id: builtins.str
    """Уникальный идентификатор группы."""
    @property
    def instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___EditFavoritesRequestInstrument]:
        """Массив инструментов."""

    def __init__(
        self,
        *,
        instruments: collections.abc.Iterable[global___EditFavoritesRequestInstrument] | None = ...,
        action_type: global___EditFavoritesActionType.ValueType = ...,
        group_id: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_group_id", b"_group_id", "group_id", b"group_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_group_id", b"_group_id", "action_type", b"action_type", "group_id", b"group_id", "instruments", b"instruments"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_group_id", b"_group_id"]) -> typing.Literal["group_id"] | None: ...

global___EditFavoritesRequest = EditFavoritesRequest

@typing.final
class EditFavoritesRequestInstrument(google.protobuf.message.Message):
    """Массив инструментов для редактирования списка избранных инструментов."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    instrument_id: builtins.str
    """Идентификатор инструмента — `figi` или `instrument_uid`."""
    def __init__(
        self,
        *,
        figi: builtins.str | None = ...,
        instrument_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_figi", b"_figi", "figi", b"figi"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_figi", b"_figi", "figi", b"figi", "instrument_id", b"instrument_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_figi", b"_figi"]) -> typing.Literal["figi"] | None: ...

global___EditFavoritesRequestInstrument = EditFavoritesRequestInstrument

@typing.final
class EditFavoritesResponse(google.protobuf.message.Message):
    """Результат редактирования списка избранных инструментов."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FAVORITE_INSTRUMENTS_FIELD_NUMBER: builtins.int
    GROUP_ID_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """Уникальный идентификатор группы."""
    @property
    def favorite_instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FavoriteInstrument]:
        """Массив инструментов."""

    def __init__(
        self,
        *,
        favorite_instruments: collections.abc.Iterable[global___FavoriteInstrument] | None = ...,
        group_id: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_group_id", b"_group_id", "group_id", b"group_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_group_id", b"_group_id", "favorite_instruments", b"favorite_instruments", "group_id", b"group_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_group_id", b"_group_id"]) -> typing.Literal["group_id"] | None: ...

global___EditFavoritesResponse = EditFavoritesResponse

@typing.final
class CreateFavoriteGroupRequest(google.protobuf.message.Message):
    """Запрос создания новой группы избранных инструментов."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_NAME_FIELD_NUMBER: builtins.int
    GROUP_COLOR_FIELD_NUMBER: builtins.int
    NOTE_FIELD_NUMBER: builtins.int
    group_name: builtins.str
    """Название группы, не более 255 символов."""
    group_color: builtins.str
    """Цвет группы. Принимает значения в HEX-формате, от "000000" до "FFFFFF" """
    note: builtins.str
    """Описание"""
    def __init__(
        self,
        *,
        group_name: builtins.str = ...,
        group_color: builtins.str = ...,
        note: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_note", b"_note", "note", b"note"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_note", b"_note", "group_color", b"group_color", "group_name", b"group_name", "note", b"note"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_note", b"_note"]) -> typing.Literal["note"] | None: ...

global___CreateFavoriteGroupRequest = CreateFavoriteGroupRequest

@typing.final
class CreateFavoriteGroupResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    GROUP_NAME_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """Уникальный идентификатор группы."""
    group_name: builtins.str
    """Название группы."""
    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
        group_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["group_id", b"group_id", "group_name", b"group_name"]) -> None: ...

global___CreateFavoriteGroupResponse = CreateFavoriteGroupResponse

@typing.final
class DeleteFavoriteGroupRequest(google.protobuf.message.Message):
    """Запрос удаления избранной группы"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """Уникальный идентификатор группы."""
    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["group_id", b"group_id"]) -> None: ...

global___DeleteFavoriteGroupRequest = DeleteFavoriteGroupRequest

@typing.final
class DeleteFavoriteGroupResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteFavoriteGroupResponse = DeleteFavoriteGroupResponse

@typing.final
class GetFavoriteGroupsRequest(google.protobuf.message.Message):
    """Запрос получения списка избранных групп"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    EXCLUDED_GROUP_ID_FIELD_NUMBER: builtins.int
    @property
    def instrument_id(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Массив идентификаторов инструментов. Принимает значение `figi` или `instrument_uid`. Если в группе будет хотя бы один из инструментов массива, то в ответе у группы вернется признак `containsInstrument = true`."""

    @property
    def excluded_group_id(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Массив идентификаторов групп, которые необходимо исключить из ответа."""

    def __init__(
        self,
        *,
        instrument_id: collections.abc.Iterable[builtins.str] | None = ...,
        excluded_group_id: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["excluded_group_id", b"excluded_group_id", "instrument_id", b"instrument_id"]) -> None: ...

global___GetFavoriteGroupsRequest = GetFavoriteGroupsRequest

@typing.final
class GetFavoriteGroupsResponse(google.protobuf.message.Message):
    """Избранные группы"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class FavoriteGroup(google.protobuf.message.Message):
        """Избранная группа"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        GROUP_ID_FIELD_NUMBER: builtins.int
        GROUP_NAME_FIELD_NUMBER: builtins.int
        COLOR_FIELD_NUMBER: builtins.int
        SIZE_FIELD_NUMBER: builtins.int
        CONTAINS_INSTRUMENT_FIELD_NUMBER: builtins.int
        group_id: builtins.str
        """Уникальный идентификатор группы."""
        group_name: builtins.str
        """Название группы."""
        color: builtins.str
        """Цвет группы в HEX-формате."""
        size: builtins.int
        """Количество инструментов в группе."""
        contains_instrument: builtins.bool
        """Признак наличия в группе хотя бы одного инструмента из запроса."""
        def __init__(
            self,
            *,
            group_id: builtins.str = ...,
            group_name: builtins.str = ...,
            color: builtins.str = ...,
            size: builtins.int = ...,
            contains_instrument: builtins.bool | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["_contains_instrument", b"_contains_instrument", "contains_instrument", b"contains_instrument"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["_contains_instrument", b"_contains_instrument", "color", b"color", "contains_instrument", b"contains_instrument", "group_id", b"group_id", "group_name", b"group_name", "size", b"size"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["_contains_instrument", b"_contains_instrument"]) -> typing.Literal["contains_instrument"] | None: ...

    GROUPS_FIELD_NUMBER: builtins.int
    @property
    def groups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetFavoriteGroupsResponse.FavoriteGroup]:
        """Массив групп избранных списков инструментов."""

    def __init__(
        self,
        *,
        groups: collections.abc.Iterable[global___GetFavoriteGroupsResponse.FavoriteGroup] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["groups", b"groups"]) -> None: ...

global___GetFavoriteGroupsResponse = GetFavoriteGroupsResponse

@typing.final
class GetCountriesRequest(google.protobuf.message.Message):
    """Запрос справочника стран."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GetCountriesRequest = GetCountriesRequest

@typing.final
class GetCountriesResponse(google.protobuf.message.Message):
    """Справочник стран."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COUNTRIES_FIELD_NUMBER: builtins.int
    @property
    def countries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CountryResponse]:
        """Массив стран."""

    def __init__(
        self,
        *,
        countries: collections.abc.Iterable[global___CountryResponse] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["countries", b"countries"]) -> None: ...

global___GetCountriesResponse = GetCountriesResponse

@typing.final
class IndicativesRequest(google.protobuf.message.Message):
    """Запрос справочника индексов и товаров"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___IndicativesRequest = IndicativesRequest

@typing.final
class IndicativesResponse(google.protobuf.message.Message):
    """Справочник индексов и товаров"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENTS_FIELD_NUMBER: builtins.int
    @property
    def instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___IndicativeResponse]:
        """Массив инструментов."""

    def __init__(
        self,
        *,
        instruments: collections.abc.Iterable[global___IndicativeResponse] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instruments", b"instruments"]) -> None: ...

global___IndicativesResponse = IndicativesResponse

@typing.final
class IndicativeResponse(google.protobuf.message.Message):
    """Индикатив"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    CURRENCY_FIELD_NUMBER: builtins.int
    INSTRUMENT_KIND_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    EXCHANGE_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    BUY_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    SELL_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код инструмента."""
    currency: builtins.str
    """Валюта расчетов."""
    instrument_kind: tinkoff.invest.grpc.common_pb2.InstrumentType.ValueType
    """Тип инструмента."""
    name: builtins.str
    """Название инструмента."""
    exchange: builtins.str
    """Tорговая площадка (секция биржи)."""
    uid: builtins.str
    """Уникальный идентификатор инструмента."""
    buy_available_flag: builtins.bool
    """Признак доступности для покупки."""
    sell_available_flag: builtins.bool
    """Признак доступности для продажи."""
    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        currency: builtins.str = ...,
        instrument_kind: tinkoff.invest.grpc.common_pb2.InstrumentType.ValueType = ...,
        name: builtins.str = ...,
        exchange: builtins.str = ...,
        uid: builtins.str = ...,
        buy_available_flag: builtins.bool = ...,
        sell_available_flag: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["buy_available_flag", b"buy_available_flag", "class_code", b"class_code", "currency", b"currency", "exchange", b"exchange", "figi", b"figi", "instrument_kind", b"instrument_kind", "name", b"name", "sell_available_flag", b"sell_available_flag", "ticker", b"ticker", "uid", b"uid"]) -> None: ...

global___IndicativeResponse = IndicativeResponse

@typing.final
class CountryResponse(google.protobuf.message.Message):
    """Данные о стране."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ALFA_TWO_FIELD_NUMBER: builtins.int
    ALFA_THREE_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    NAME_BRIEF_FIELD_NUMBER: builtins.int
    alfa_two: builtins.str
    """Двухбуквенный код страны."""
    alfa_three: builtins.str
    """Трехбуквенный код страны."""
    name: builtins.str
    """Наименование страны."""
    name_brief: builtins.str
    """Краткое наименование страны."""
    def __init__(
        self,
        *,
        alfa_two: builtins.str = ...,
        alfa_three: builtins.str = ...,
        name: builtins.str = ...,
        name_brief: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["alfa_three", b"alfa_three", "alfa_two", b"alfa_two", "name", b"name", "name_brief", b"name_brief"]) -> None: ...

global___CountryResponse = CountryResponse

@typing.final
class FindInstrumentRequest(google.protobuf.message.Message):
    """Запрос на поиск инструментов."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUERY_FIELD_NUMBER: builtins.int
    INSTRUMENT_KIND_FIELD_NUMBER: builtins.int
    API_TRADE_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    query: builtins.str
    """Строка поиска."""
    instrument_kind: tinkoff.invest.grpc.common_pb2.InstrumentType.ValueType
    """Фильтр по типу инструмента."""
    api_trade_available_flag: builtins.bool
    """Фильтр для отображения только торговых инструментов."""
    def __init__(
        self,
        *,
        query: builtins.str = ...,
        instrument_kind: tinkoff.invest.grpc.common_pb2.InstrumentType.ValueType | None = ...,
        api_trade_available_flag: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_api_trade_available_flag", b"_api_trade_available_flag", "_instrument_kind", b"_instrument_kind", "api_trade_available_flag", b"api_trade_available_flag", "instrument_kind", b"instrument_kind"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_api_trade_available_flag", b"_api_trade_available_flag", "_instrument_kind", b"_instrument_kind", "api_trade_available_flag", b"api_trade_available_flag", "instrument_kind", b"instrument_kind", "query", b"query"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_api_trade_available_flag", b"_api_trade_available_flag"]) -> typing.Literal["api_trade_available_flag"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_instrument_kind", b"_instrument_kind"]) -> typing.Literal["instrument_kind"] | None: ...

global___FindInstrumentRequest = FindInstrumentRequest

@typing.final
class FindInstrumentResponse(google.protobuf.message.Message):
    """Результат поиска инструментов."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENTS_FIELD_NUMBER: builtins.int
    @property
    def instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___InstrumentShort]:
        """Массив инструментов, удовлетворяющих условиям поиска."""

    def __init__(
        self,
        *,
        instruments: collections.abc.Iterable[global___InstrumentShort] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instruments", b"instruments"]) -> None: ...

global___FindInstrumentResponse = FindInstrumentResponse

@typing.final
class InstrumentShort(google.protobuf.message.Message):
    """Краткая информация об инструменте."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ISIN_FIELD_NUMBER: builtins.int
    FIGI_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    INSTRUMENT_TYPE_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    POSITION_UID_FIELD_NUMBER: builtins.int
    INSTRUMENT_KIND_FIELD_NUMBER: builtins.int
    API_TRADE_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    FOR_IIS_FLAG_FIELD_NUMBER: builtins.int
    FIRST_1MIN_CANDLE_DATE_FIELD_NUMBER: builtins.int
    FIRST_1DAY_CANDLE_DATE_FIELD_NUMBER: builtins.int
    FOR_QUAL_INVESTOR_FLAG_FIELD_NUMBER: builtins.int
    WEEKEND_FLAG_FIELD_NUMBER: builtins.int
    BLOCKED_TCA_FLAG_FIELD_NUMBER: builtins.int
    LOT_FIELD_NUMBER: builtins.int
    isin: builtins.str
    """ISIN инструмента."""
    figi: builtins.str
    """FIGI инструмента."""
    ticker: builtins.str
    """Ticker инструмента."""
    class_code: builtins.str
    """ClassCode инструмента."""
    instrument_type: builtins.str
    """Тип инструмента."""
    name: builtins.str
    """Название инструмента."""
    uid: builtins.str
    """Уникальный идентификатор инструмента."""
    position_uid: builtins.str
    """Уникальный идентификатор позиции инструмента."""
    instrument_kind: tinkoff.invest.grpc.common_pb2.InstrumentType.ValueType
    """Тип инструмента."""
    api_trade_available_flag: builtins.bool
    """Возможность торговать инструментом через API."""
    for_iis_flag: builtins.bool
    """Признак доступности для ИИС."""
    for_qual_investor_flag: builtins.bool
    """Флаг, отображающий доступность торговли инструментом только для квалифицированных инвесторов."""
    weekend_flag: builtins.bool
    """Флаг, отображающий доступность торговли инструментом по выходным."""
    blocked_tca_flag: builtins.bool
    """Флаг заблокированного ТКС."""
    lot: builtins.int
    """Количество бумаг в лоте."""
    @property
    def first_1min_candle_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата первой минутной свечи."""

    @property
    def first_1day_candle_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата первой дневной свечи."""

    def __init__(
        self,
        *,
        isin: builtins.str = ...,
        figi: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        instrument_type: builtins.str = ...,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        position_uid: builtins.str = ...,
        instrument_kind: tinkoff.invest.grpc.common_pb2.InstrumentType.ValueType = ...,
        api_trade_available_flag: builtins.bool = ...,
        for_iis_flag: builtins.bool = ...,
        first_1min_candle_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        first_1day_candle_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        for_qual_investor_flag: builtins.bool = ...,
        weekend_flag: builtins.bool = ...,
        blocked_tca_flag: builtins.bool = ...,
        lot: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["first_1day_candle_date", b"first_1day_candle_date", "first_1min_candle_date", b"first_1min_candle_date"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["api_trade_available_flag", b"api_trade_available_flag", "blocked_tca_flag", b"blocked_tca_flag", "class_code", b"class_code", "figi", b"figi", "first_1day_candle_date", b"first_1day_candle_date", "first_1min_candle_date", b"first_1min_candle_date", "for_iis_flag", b"for_iis_flag", "for_qual_investor_flag", b"for_qual_investor_flag", "instrument_kind", b"instrument_kind", "instrument_type", b"instrument_type", "isin", b"isin", "lot", b"lot", "name", b"name", "position_uid", b"position_uid", "ticker", b"ticker", "uid", b"uid", "weekend_flag", b"weekend_flag"]) -> None: ...

global___InstrumentShort = InstrumentShort

@typing.final
class GetBrandsRequest(google.protobuf.message.Message):
    """Запрос списка брендов."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGING_FIELD_NUMBER: builtins.int
    @property
    def paging(self) -> tinkoff.invest.grpc.common_pb2.Page:
        """Настройки пагинации."""

    def __init__(
        self,
        *,
        paging: tinkoff.invest.grpc.common_pb2.Page | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["paging", b"paging"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["paging", b"paging"]) -> None: ...

global___GetBrandsRequest = GetBrandsRequest

@typing.final
class GetBrandRequest(google.protobuf.message.Message):
    """Запрос бренда."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """UID-идентификатор бренда."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["id", b"id"]) -> None: ...

global___GetBrandRequest = GetBrandRequest

@typing.final
class GetBrandsResponse(google.protobuf.message.Message):
    """Список брендов."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BRANDS_FIELD_NUMBER: builtins.int
    PAGING_FIELD_NUMBER: builtins.int
    @property
    def brands(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Brand]:
        """Массив брендов."""

    @property
    def paging(self) -> tinkoff.invest.grpc.common_pb2.PageResponse:
        """Данные по пагинации."""

    def __init__(
        self,
        *,
        brands: collections.abc.Iterable[global___Brand] | None = ...,
        paging: tinkoff.invest.grpc.common_pb2.PageResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["paging", b"paging"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["brands", b"brands", "paging", b"paging"]) -> None: ...

global___GetBrandsResponse = GetBrandsResponse

@typing.final
class GetAssetFundamentalsRequest(google.protobuf.message.Message):
    """Запрос фундаментальных показателей"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSETS_FIELD_NUMBER: builtins.int
    @property
    def assets(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Массив идентификаторов активов, не более 100 шт."""

    def __init__(
        self,
        *,
        assets: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["assets", b"assets"]) -> None: ...

global___GetAssetFundamentalsRequest = GetAssetFundamentalsRequest

@typing.final
class GetAssetFundamentalsResponse(google.protobuf.message.Message):
    """Фундаментальные показатели"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class StatisticResponse(google.protobuf.message.Message):
        """Фундаментальные показатели по активу"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ASSET_UID_FIELD_NUMBER: builtins.int
        CURRENCY_FIELD_NUMBER: builtins.int
        MARKET_CAPITALIZATION_FIELD_NUMBER: builtins.int
        HIGH_PRICE_LAST_52_WEEKS_FIELD_NUMBER: builtins.int
        LOW_PRICE_LAST_52_WEEKS_FIELD_NUMBER: builtins.int
        AVERAGE_DAILY_VOLUME_LAST_10_DAYS_FIELD_NUMBER: builtins.int
        AVERAGE_DAILY_VOLUME_LAST_4_WEEKS_FIELD_NUMBER: builtins.int
        BETA_FIELD_NUMBER: builtins.int
        FREE_FLOAT_FIELD_NUMBER: builtins.int
        FORWARD_ANNUAL_DIVIDEND_YIELD_FIELD_NUMBER: builtins.int
        SHARES_OUTSTANDING_FIELD_NUMBER: builtins.int
        REVENUE_TTM_FIELD_NUMBER: builtins.int
        EBITDA_TTM_FIELD_NUMBER: builtins.int
        NET_INCOME_TTM_FIELD_NUMBER: builtins.int
        EPS_TTM_FIELD_NUMBER: builtins.int
        DILUTED_EPS_TTM_FIELD_NUMBER: builtins.int
        FREE_CASH_FLOW_TTM_FIELD_NUMBER: builtins.int
        FIVE_YEAR_ANNUAL_REVENUE_GROWTH_RATE_FIELD_NUMBER: builtins.int
        THREE_YEAR_ANNUAL_REVENUE_GROWTH_RATE_FIELD_NUMBER: builtins.int
        PE_RATIO_TTM_FIELD_NUMBER: builtins.int
        PRICE_TO_SALES_TTM_FIELD_NUMBER: builtins.int
        PRICE_TO_BOOK_TTM_FIELD_NUMBER: builtins.int
        PRICE_TO_FREE_CASH_FLOW_TTM_FIELD_NUMBER: builtins.int
        TOTAL_ENTERPRISE_VALUE_MRQ_FIELD_NUMBER: builtins.int
        EV_TO_EBITDA_MRQ_FIELD_NUMBER: builtins.int
        NET_MARGIN_MRQ_FIELD_NUMBER: builtins.int
        NET_INTEREST_MARGIN_MRQ_FIELD_NUMBER: builtins.int
        ROE_FIELD_NUMBER: builtins.int
        ROA_FIELD_NUMBER: builtins.int
        ROIC_FIELD_NUMBER: builtins.int
        TOTAL_DEBT_MRQ_FIELD_NUMBER: builtins.int
        TOTAL_DEBT_TO_EQUITY_MRQ_FIELD_NUMBER: builtins.int
        TOTAL_DEBT_TO_EBITDA_MRQ_FIELD_NUMBER: builtins.int
        FREE_CASH_FLOW_TO_PRICE_FIELD_NUMBER: builtins.int
        NET_DEBT_TO_EBITDA_FIELD_NUMBER: builtins.int
        CURRENT_RATIO_MRQ_FIELD_NUMBER: builtins.int
        FIXED_CHARGE_COVERAGE_RATIO_FY_FIELD_NUMBER: builtins.int
        DIVIDEND_YIELD_DAILY_TTM_FIELD_NUMBER: builtins.int
        DIVIDEND_RATE_TTM_FIELD_NUMBER: builtins.int
        DIVIDENDS_PER_SHARE_FIELD_NUMBER: builtins.int
        FIVE_YEARS_AVERAGE_DIVIDEND_YIELD_FIELD_NUMBER: builtins.int
        FIVE_YEAR_ANNUAL_DIVIDEND_GROWTH_RATE_FIELD_NUMBER: builtins.int
        DIVIDEND_PAYOUT_RATIO_FY_FIELD_NUMBER: builtins.int
        BUY_BACK_TTM_FIELD_NUMBER: builtins.int
        ONE_YEAR_ANNUAL_REVENUE_GROWTH_RATE_FIELD_NUMBER: builtins.int
        DOMICILE_INDICATOR_CODE_FIELD_NUMBER: builtins.int
        ADR_TO_COMMON_SHARE_RATIO_FIELD_NUMBER: builtins.int
        NUMBER_OF_EMPLOYEES_FIELD_NUMBER: builtins.int
        EX_DIVIDEND_DATE_FIELD_NUMBER: builtins.int
        FISCAL_PERIOD_START_DATE_FIELD_NUMBER: builtins.int
        FISCAL_PERIOD_END_DATE_FIELD_NUMBER: builtins.int
        REVENUE_CHANGE_FIVE_YEARS_FIELD_NUMBER: builtins.int
        EPS_CHANGE_FIVE_YEARS_FIELD_NUMBER: builtins.int
        EBITDA_CHANGE_FIVE_YEARS_FIELD_NUMBER: builtins.int
        TOTAL_DEBT_CHANGE_FIVE_YEARS_FIELD_NUMBER: builtins.int
        EV_TO_SALES_FIELD_NUMBER: builtins.int
        asset_uid: builtins.str
        """Идентификатор актива."""
        currency: builtins.str
        """Валюта."""
        market_capitalization: builtins.float
        """Рыночная капитализация."""
        high_price_last_52_weeks: builtins.float
        """Максимум за год."""
        low_price_last_52_weeks: builtins.float
        """Минимум за год."""
        average_daily_volume_last_10_days: builtins.float
        """Средний объем торгов за 10 дней."""
        average_daily_volume_last_4_weeks: builtins.float
        """Средний объем торгов за месяц."""
        beta: builtins.float
        free_float: builtins.float
        """Доля акций в свободном обращении."""
        forward_annual_dividend_yield: builtins.float
        """Процент форвардной дивидендной доходности по отношению к цене акций."""
        shares_outstanding: builtins.float
        """Количество акций в обращении."""
        revenue_ttm: builtins.float
        """Выручка."""
        ebitda_ttm: builtins.float
        """EBITDA — прибыль до вычета процентов, налогов, износа и амортизации."""
        net_income_ttm: builtins.float
        """Чистая прибыль."""
        eps_ttm: builtins.float
        """EPS — величина чистой прибыли компании, которая приходится на каждую обыкновенную акцию."""
        diluted_eps_ttm: builtins.float
        """EPS компании с допущением, что все конвертируемые ценные бумаги компании были сконвертированы в обыкновенные акции."""
        free_cash_flow_ttm: builtins.float
        """Свободный денежный поток."""
        five_year_annual_revenue_growth_rate: builtins.float
        """Среднегодовой  рocт выручки за 5 лет."""
        three_year_annual_revenue_growth_rate: builtins.float
        """Среднегодовой  рocт выручки за 3 года."""
        pe_ratio_ttm: builtins.float
        """Соотношение рыночной капитализации компании к ее чистой прибыли."""
        price_to_sales_ttm: builtins.float
        """Соотношение рыночной капитализации компании к ее выручке."""
        price_to_book_ttm: builtins.float
        """Соотношение рыночной капитализации компании к ее балансовой стоимости."""
        price_to_free_cash_flow_ttm: builtins.float
        """Соотношение рыночной капитализации компании к ее свободному денежному потоку."""
        total_enterprise_value_mrq: builtins.float
        """Рыночная стоимость компании."""
        ev_to_ebitda_mrq: builtins.float
        """Соотношение EV и EBITDA."""
        net_margin_mrq: builtins.float
        """Маржа чистой прибыли."""
        net_interest_margin_mrq: builtins.float
        """Рентабельность чистой прибыли."""
        roe: builtins.float
        """Рентабельность собственного капитала."""
        roa: builtins.float
        """Рентабельность активов."""
        roic: builtins.float
        """Рентабельность активов."""
        total_debt_mrq: builtins.float
        """Сумма краткосрочных и долгосрочных обязательств компании."""
        total_debt_to_equity_mrq: builtins.float
        """Соотношение долга к собственному капиталу."""
        total_debt_to_ebitda_mrq: builtins.float
        """Total Debt/EBITDA."""
        free_cash_flow_to_price: builtins.float
        """Отношение свободногоо кэша к стоимости."""
        net_debt_to_ebitda: builtins.float
        """Отношение чистого долга к EBITDA."""
        current_ratio_mrq: builtins.float
        """Коэффициент текущей ликвидности."""
        fixed_charge_coverage_ratio_fy: builtins.float
        """Коэффициент покрытия фиксированных платежей — FCCR."""
        dividend_yield_daily_ttm: builtins.float
        """Дивидендная доходность за 12 месяцев."""
        dividend_rate_ttm: builtins.float
        """Выплаченные дивиденды за 12 месяцев."""
        dividends_per_share: builtins.float
        """Значение дивидендов на акцию."""
        five_years_average_dividend_yield: builtins.float
        """Средняя дивидендная доходность за 5 лет."""
        five_year_annual_dividend_growth_rate: builtins.float
        """Среднегодовой рост дивидендов за 5 лет."""
        dividend_payout_ratio_fy: builtins.float
        """Процент чистой прибыли, уходящий на выплату дивидендов."""
        buy_back_ttm: builtins.float
        """Деньги, потраченные на обратный выкуп акций."""
        one_year_annual_revenue_growth_rate: builtins.float
        """Рост выручки за 1 год."""
        domicile_indicator_code: builtins.str
        """Код страны."""
        adr_to_common_share_ratio: builtins.float
        """Соотношение депозитарной расписки к акциям."""
        number_of_employees: builtins.float
        """Количество сотрудников."""
        revenue_change_five_years: builtins.float
        """Изменение общего дохода за 5 лет."""
        eps_change_five_years: builtins.float
        """Изменение EPS за 5 лет."""
        ebitda_change_five_years: builtins.float
        """Изменение EBIDTA за 5 лет."""
        total_debt_change_five_years: builtins.float
        """Изменение общей задолжности за 5 лет."""
        ev_to_sales: builtins.float
        """Отношение EV к выручке."""
        @property
        def ex_dividend_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
        @property
        def fiscal_period_start_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Начало фискального периода."""

        @property
        def fiscal_period_end_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Окончание фискального периода."""

        def __init__(
            self,
            *,
            asset_uid: builtins.str = ...,
            currency: builtins.str = ...,
            market_capitalization: builtins.float = ...,
            high_price_last_52_weeks: builtins.float = ...,
            low_price_last_52_weeks: builtins.float = ...,
            average_daily_volume_last_10_days: builtins.float = ...,
            average_daily_volume_last_4_weeks: builtins.float = ...,
            beta: builtins.float = ...,
            free_float: builtins.float = ...,
            forward_annual_dividend_yield: builtins.float = ...,
            shares_outstanding: builtins.float = ...,
            revenue_ttm: builtins.float = ...,
            ebitda_ttm: builtins.float = ...,
            net_income_ttm: builtins.float = ...,
            eps_ttm: builtins.float = ...,
            diluted_eps_ttm: builtins.float = ...,
            free_cash_flow_ttm: builtins.float = ...,
            five_year_annual_revenue_growth_rate: builtins.float = ...,
            three_year_annual_revenue_growth_rate: builtins.float = ...,
            pe_ratio_ttm: builtins.float = ...,
            price_to_sales_ttm: builtins.float = ...,
            price_to_book_ttm: builtins.float = ...,
            price_to_free_cash_flow_ttm: builtins.float = ...,
            total_enterprise_value_mrq: builtins.float = ...,
            ev_to_ebitda_mrq: builtins.float = ...,
            net_margin_mrq: builtins.float = ...,
            net_interest_margin_mrq: builtins.float = ...,
            roe: builtins.float = ...,
            roa: builtins.float = ...,
            roic: builtins.float = ...,
            total_debt_mrq: builtins.float = ...,
            total_debt_to_equity_mrq: builtins.float = ...,
            total_debt_to_ebitda_mrq: builtins.float = ...,
            free_cash_flow_to_price: builtins.float = ...,
            net_debt_to_ebitda: builtins.float = ...,
            current_ratio_mrq: builtins.float = ...,
            fixed_charge_coverage_ratio_fy: builtins.float = ...,
            dividend_yield_daily_ttm: builtins.float = ...,
            dividend_rate_ttm: builtins.float = ...,
            dividends_per_share: builtins.float = ...,
            five_years_average_dividend_yield: builtins.float = ...,
            five_year_annual_dividend_growth_rate: builtins.float = ...,
            dividend_payout_ratio_fy: builtins.float = ...,
            buy_back_ttm: builtins.float = ...,
            one_year_annual_revenue_growth_rate: builtins.float = ...,
            domicile_indicator_code: builtins.str = ...,
            adr_to_common_share_ratio: builtins.float = ...,
            number_of_employees: builtins.float = ...,
            ex_dividend_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            fiscal_period_start_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            fiscal_period_end_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            revenue_change_five_years: builtins.float = ...,
            eps_change_five_years: builtins.float = ...,
            ebitda_change_five_years: builtins.float = ...,
            total_debt_change_five_years: builtins.float = ...,
            ev_to_sales: builtins.float = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["ex_dividend_date", b"ex_dividend_date", "fiscal_period_end_date", b"fiscal_period_end_date", "fiscal_period_start_date", b"fiscal_period_start_date"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["adr_to_common_share_ratio", b"adr_to_common_share_ratio", "asset_uid", b"asset_uid", "average_daily_volume_last_10_days", b"average_daily_volume_last_10_days", "average_daily_volume_last_4_weeks", b"average_daily_volume_last_4_weeks", "beta", b"beta", "buy_back_ttm", b"buy_back_ttm", "currency", b"currency", "current_ratio_mrq", b"current_ratio_mrq", "diluted_eps_ttm", b"diluted_eps_ttm", "dividend_payout_ratio_fy", b"dividend_payout_ratio_fy", "dividend_rate_ttm", b"dividend_rate_ttm", "dividend_yield_daily_ttm", b"dividend_yield_daily_ttm", "dividends_per_share", b"dividends_per_share", "domicile_indicator_code", b"domicile_indicator_code", "ebitda_change_five_years", b"ebitda_change_five_years", "ebitda_ttm", b"ebitda_ttm", "eps_change_five_years", b"eps_change_five_years", "eps_ttm", b"eps_ttm", "ev_to_ebitda_mrq", b"ev_to_ebitda_mrq", "ev_to_sales", b"ev_to_sales", "ex_dividend_date", b"ex_dividend_date", "fiscal_period_end_date", b"fiscal_period_end_date", "fiscal_period_start_date", b"fiscal_period_start_date", "five_year_annual_dividend_growth_rate", b"five_year_annual_dividend_growth_rate", "five_year_annual_revenue_growth_rate", b"five_year_annual_revenue_growth_rate", "five_years_average_dividend_yield", b"five_years_average_dividend_yield", "fixed_charge_coverage_ratio_fy", b"fixed_charge_coverage_ratio_fy", "forward_annual_dividend_yield", b"forward_annual_dividend_yield", "free_cash_flow_to_price", b"free_cash_flow_to_price", "free_cash_flow_ttm", b"free_cash_flow_ttm", "free_float", b"free_float", "high_price_last_52_weeks", b"high_price_last_52_weeks", "low_price_last_52_weeks", b"low_price_last_52_weeks", "market_capitalization", b"market_capitalization", "net_debt_to_ebitda", b"net_debt_to_ebitda", "net_income_ttm", b"net_income_ttm", "net_interest_margin_mrq", b"net_interest_margin_mrq", "net_margin_mrq", b"net_margin_mrq", "number_of_employees", b"number_of_employees", "one_year_annual_revenue_growth_rate", b"one_year_annual_revenue_growth_rate", "pe_ratio_ttm", b"pe_ratio_ttm", "price_to_book_ttm", b"price_to_book_ttm", "price_to_free_cash_flow_ttm", b"price_to_free_cash_flow_ttm", "price_to_sales_ttm", b"price_to_sales_ttm", "revenue_change_five_years", b"revenue_change_five_years", "revenue_ttm", b"revenue_ttm", "roa", b"roa", "roe", b"roe", "roic", b"roic", "shares_outstanding", b"shares_outstanding", "three_year_annual_revenue_growth_rate", b"three_year_annual_revenue_growth_rate", "total_debt_change_five_years", b"total_debt_change_five_years", "total_debt_mrq", b"total_debt_mrq", "total_debt_to_ebitda_mrq", b"total_debt_to_ebitda_mrq", "total_debt_to_equity_mrq", b"total_debt_to_equity_mrq", "total_enterprise_value_mrq", b"total_enterprise_value_mrq"]) -> None: ...

    FUNDAMENTALS_FIELD_NUMBER: builtins.int
    @property
    def fundamentals(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetAssetFundamentalsResponse.StatisticResponse]: ...
    def __init__(
        self,
        *,
        fundamentals: collections.abc.Iterable[global___GetAssetFundamentalsResponse.StatisticResponse] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["fundamentals", b"fundamentals"]) -> None: ...

global___GetAssetFundamentalsResponse = GetAssetFundamentalsResponse

@typing.final
class GetAssetReportsRequest(google.protobuf.message.Message):
    """Запрос отчетов эмитентов"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    FROM_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    instrument_id: builtins.str
    """Идентификатор инструмента в формате UID."""
    @property
    def to(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Окончание запрашиваемого периода по UTC."""

    def __init__(
        self,
        *,
        instrument_id: builtins.str = ...,
        to: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_from", b"_from", "_to", b"_to", "from", b"from", "to", b"to"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_from", b"_from", "_to", b"_to", "from", b"from", "instrument_id", b"instrument_id", "to", b"to"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_from", b"_from"]) -> typing.Literal["from"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_to", b"_to"]) -> typing.Literal["to"] | None: ...

global___GetAssetReportsRequest = GetAssetReportsRequest

@typing.final
class GetAssetReportsResponse(google.protobuf.message.Message):
    """Отчеты эмитентов"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _AssetReportPeriodType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AssetReportPeriodTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[GetAssetReportsResponse._AssetReportPeriodType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PERIOD_TYPE_UNSPECIFIED: GetAssetReportsResponse._AssetReportPeriodType.ValueType  # 0
        """Не указан."""
        PERIOD_TYPE_QUARTER: GetAssetReportsResponse._AssetReportPeriodType.ValueType  # 1
        """Квартальный."""
        PERIOD_TYPE_SEMIANNUAL: GetAssetReportsResponse._AssetReportPeriodType.ValueType  # 2
        """Полугодовой."""
        PERIOD_TYPE_ANNUAL: GetAssetReportsResponse._AssetReportPeriodType.ValueType  # 3
        """Годовой."""

    class AssetReportPeriodType(_AssetReportPeriodType, metaclass=_AssetReportPeriodTypeEnumTypeWrapper): ...
    PERIOD_TYPE_UNSPECIFIED: GetAssetReportsResponse.AssetReportPeriodType.ValueType  # 0
    """Не указан."""
    PERIOD_TYPE_QUARTER: GetAssetReportsResponse.AssetReportPeriodType.ValueType  # 1
    """Квартальный."""
    PERIOD_TYPE_SEMIANNUAL: GetAssetReportsResponse.AssetReportPeriodType.ValueType  # 2
    """Полугодовой."""
    PERIOD_TYPE_ANNUAL: GetAssetReportsResponse.AssetReportPeriodType.ValueType  # 3
    """Годовой."""

    @typing.final
    class GetAssetReportsEvent(google.protobuf.message.Message):
        """Отчет"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        INSTRUMENT_ID_FIELD_NUMBER: builtins.int
        REPORT_DATE_FIELD_NUMBER: builtins.int
        PERIOD_YEAR_FIELD_NUMBER: builtins.int
        PERIOD_NUM_FIELD_NUMBER: builtins.int
        PERIOD_TYPE_FIELD_NUMBER: builtins.int
        CREATED_AT_FIELD_NUMBER: builtins.int
        instrument_id: builtins.str
        """Идентификатор инструмента."""
        period_year: builtins.int
        """Год периода отчета."""
        period_num: builtins.int
        """Номер периода."""
        period_type: global___GetAssetReportsResponse.AssetReportPeriodType.ValueType
        """Тип отчета."""
        @property
        def report_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Дата публикации отчета."""

        @property
        def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Дата создания записи."""

        def __init__(
            self,
            *,
            instrument_id: builtins.str = ...,
            report_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            period_year: builtins.int = ...,
            period_num: builtins.int = ...,
            period_type: global___GetAssetReportsResponse.AssetReportPeriodType.ValueType = ...,
            created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["created_at", b"created_at", "report_date", b"report_date"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "instrument_id", b"instrument_id", "period_num", b"period_num", "period_type", b"period_type", "period_year", b"period_year", "report_date", b"report_date"]) -> None: ...

    EVENTS_FIELD_NUMBER: builtins.int
    @property
    def events(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetAssetReportsResponse.GetAssetReportsEvent]:
        """Массив событий по облигации."""

    def __init__(
        self,
        *,
        events: collections.abc.Iterable[global___GetAssetReportsResponse.GetAssetReportsEvent] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["events", b"events"]) -> None: ...

global___GetAssetReportsResponse = GetAssetReportsResponse

@typing.final
class GetConsensusForecastsRequest(google.protobuf.message.Message):
    """Запрос консенсус-прогнозов"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGING_FIELD_NUMBER: builtins.int
    @property
    def paging(self) -> tinkoff.invest.grpc.common_pb2.Page:
        """Настройки пагинации."""

    def __init__(
        self,
        *,
        paging: tinkoff.invest.grpc.common_pb2.Page | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_paging", b"_paging", "paging", b"paging"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_paging", b"_paging", "paging", b"paging"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_paging", b"_paging"]) -> typing.Literal["paging"] | None: ...

global___GetConsensusForecastsRequest = GetConsensusForecastsRequest

@typing.final
class GetConsensusForecastsResponse(google.protobuf.message.Message):
    """Консенсус-прогнозы"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ConsensusForecastsItem(google.protobuf.message.Message):
        """Прогноз"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        UID_FIELD_NUMBER: builtins.int
        ASSET_UID_FIELD_NUMBER: builtins.int
        CREATED_AT_FIELD_NUMBER: builtins.int
        BEST_TARGET_PRICE_FIELD_NUMBER: builtins.int
        BEST_TARGET_LOW_FIELD_NUMBER: builtins.int
        BEST_TARGET_HIGH_FIELD_NUMBER: builtins.int
        TOTAL_BUY_RECOMMEND_FIELD_NUMBER: builtins.int
        TOTAL_HOLD_RECOMMEND_FIELD_NUMBER: builtins.int
        TOTAL_SELL_RECOMMEND_FIELD_NUMBER: builtins.int
        CURRENCY_FIELD_NUMBER: builtins.int
        CONSENSUS_FIELD_NUMBER: builtins.int
        PROGNOSIS_DATE_FIELD_NUMBER: builtins.int
        uid: builtins.str
        """UID-идентификатор."""
        asset_uid: builtins.str
        """UID-идентификатор актива."""
        total_buy_recommend: builtins.int
        """Количество аналитиков рекомендующих покупать."""
        total_hold_recommend: builtins.int
        """Количество аналитиков рекомендующих держать."""
        total_sell_recommend: builtins.int
        """Количество аналитиков рекомендующих продавать."""
        currency: builtins.str
        """Валюта прогнозов инструмента."""
        consensus: global___Recommendation.ValueType
        """Консенсус-прогноз."""
        @property
        def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Дата и время создания записи."""

        @property
        def best_target_price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Целевая цена на 12 месяцев."""

        @property
        def best_target_low(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Минимальная прогнозная цена."""

        @property
        def best_target_high(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Максимальная прогнозная цена."""

        @property
        def prognosis_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Дата прогноза."""

        def __init__(
            self,
            *,
            uid: builtins.str = ...,
            asset_uid: builtins.str = ...,
            created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            best_target_price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            best_target_low: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            best_target_high: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            total_buy_recommend: builtins.int = ...,
            total_hold_recommend: builtins.int = ...,
            total_sell_recommend: builtins.int = ...,
            currency: builtins.str = ...,
            consensus: global___Recommendation.ValueType = ...,
            prognosis_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["best_target_high", b"best_target_high", "best_target_low", b"best_target_low", "best_target_price", b"best_target_price", "created_at", b"created_at", "prognosis_date", b"prognosis_date"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["asset_uid", b"asset_uid", "best_target_high", b"best_target_high", "best_target_low", b"best_target_low", "best_target_price", b"best_target_price", "consensus", b"consensus", "created_at", b"created_at", "currency", b"currency", "prognosis_date", b"prognosis_date", "total_buy_recommend", b"total_buy_recommend", "total_hold_recommend", b"total_hold_recommend", "total_sell_recommend", b"total_sell_recommend", "uid", b"uid"]) -> None: ...

    ITEMS_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetConsensusForecastsResponse.ConsensusForecastsItem]:
        """Массив прогнозов."""

    @property
    def page(self) -> tinkoff.invest.grpc.common_pb2.PageResponse:
        """Данные по пагинации."""

    def __init__(
        self,
        *,
        items: collections.abc.Iterable[global___GetConsensusForecastsResponse.ConsensusForecastsItem] | None = ...,
        page: tinkoff.invest.grpc.common_pb2.PageResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["page", b"page"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["items", b"items", "page", b"page"]) -> None: ...

global___GetConsensusForecastsResponse = GetConsensusForecastsResponse

@typing.final
class GetForecastRequest(google.protobuf.message.Message):
    """Запрос прогнозов инвестдомов."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    instrument_id: builtins.str
    """Идентификатор инструмента."""
    def __init__(
        self,
        *,
        instrument_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instrument_id", b"instrument_id"]) -> None: ...

global___GetForecastRequest = GetForecastRequest

@typing.final
class GetForecastResponse(google.protobuf.message.Message):
    """Прогнозы инвестдомов по инструменту."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class TargetItem(google.protobuf.message.Message):
        """Прогноз"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        UID_FIELD_NUMBER: builtins.int
        TICKER_FIELD_NUMBER: builtins.int
        COMPANY_FIELD_NUMBER: builtins.int
        RECOMMENDATION_FIELD_NUMBER: builtins.int
        RECOMMENDATION_DATE_FIELD_NUMBER: builtins.int
        CURRENCY_FIELD_NUMBER: builtins.int
        CURRENT_PRICE_FIELD_NUMBER: builtins.int
        TARGET_PRICE_FIELD_NUMBER: builtins.int
        PRICE_CHANGE_FIELD_NUMBER: builtins.int
        PRICE_CHANGE_REL_FIELD_NUMBER: builtins.int
        SHOW_NAME_FIELD_NUMBER: builtins.int
        uid: builtins.str
        """Уникальный идентификатор инструмента."""
        ticker: builtins.str
        """Тикер инструмента."""
        company: builtins.str
        """Название компании, давшей прогноз."""
        recommendation: global___Recommendation.ValueType
        """Прогноз."""
        currency: builtins.str
        """Валюта."""
        show_name: builtins.str
        """Наименование инструмента."""
        @property
        def recommendation_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Дата прогноза."""

        @property
        def current_price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Текущая цена."""

        @property
        def target_price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Прогнозируемая цена."""

        @property
        def price_change(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Изменение цены."""

        @property
        def price_change_rel(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Относительное изменение цены."""

        def __init__(
            self,
            *,
            uid: builtins.str = ...,
            ticker: builtins.str = ...,
            company: builtins.str = ...,
            recommendation: global___Recommendation.ValueType = ...,
            recommendation_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            currency: builtins.str = ...,
            current_price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            target_price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            price_change: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            price_change_rel: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            show_name: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["current_price", b"current_price", "price_change", b"price_change", "price_change_rel", b"price_change_rel", "recommendation_date", b"recommendation_date", "target_price", b"target_price"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["company", b"company", "currency", b"currency", "current_price", b"current_price", "price_change", b"price_change", "price_change_rel", b"price_change_rel", "recommendation", b"recommendation", "recommendation_date", b"recommendation_date", "show_name", b"show_name", "target_price", b"target_price", "ticker", b"ticker", "uid", b"uid"]) -> None: ...

    @typing.final
    class ConsensusItem(google.protobuf.message.Message):
        """Консенсус-прогноз."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        UID_FIELD_NUMBER: builtins.int
        TICKER_FIELD_NUMBER: builtins.int
        RECOMMENDATION_FIELD_NUMBER: builtins.int
        CURRENCY_FIELD_NUMBER: builtins.int
        CURRENT_PRICE_FIELD_NUMBER: builtins.int
        CONSENSUS_FIELD_NUMBER: builtins.int
        MIN_TARGET_FIELD_NUMBER: builtins.int
        MAX_TARGET_FIELD_NUMBER: builtins.int
        PRICE_CHANGE_FIELD_NUMBER: builtins.int
        PRICE_CHANGE_REL_FIELD_NUMBER: builtins.int
        uid: builtins.str
        """Уникальный идентификатор инструмента."""
        ticker: builtins.str
        """Тикер инструмента."""
        recommendation: global___Recommendation.ValueType
        """Прогноз."""
        currency: builtins.str
        """Валюта."""
        @property
        def current_price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Текущая цена."""

        @property
        def consensus(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Прогнозируемая цена."""

        @property
        def min_target(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Минимальная цена прогноза."""

        @property
        def max_target(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Максимальная цена прогноза."""

        @property
        def price_change(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Изменение цены."""

        @property
        def price_change_rel(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Относительное изменение цены."""

        def __init__(
            self,
            *,
            uid: builtins.str = ...,
            ticker: builtins.str = ...,
            recommendation: global___Recommendation.ValueType = ...,
            currency: builtins.str = ...,
            current_price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            consensus: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            min_target: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            max_target: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            price_change: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            price_change_rel: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["consensus", b"consensus", "current_price", b"current_price", "max_target", b"max_target", "min_target", b"min_target", "price_change", b"price_change", "price_change_rel", b"price_change_rel"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["consensus", b"consensus", "currency", b"currency", "current_price", b"current_price", "max_target", b"max_target", "min_target", b"min_target", "price_change", b"price_change", "price_change_rel", b"price_change_rel", "recommendation", b"recommendation", "ticker", b"ticker", "uid", b"uid"]) -> None: ...

    TARGETS_FIELD_NUMBER: builtins.int
    CONSENSUS_FIELD_NUMBER: builtins.int
    @property
    def targets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetForecastResponse.TargetItem]:
        """Массив прогнозов."""

    @property
    def consensus(self) -> global___GetForecastResponse.ConsensusItem:
        """Согласованный прогноз."""

    def __init__(
        self,
        *,
        targets: collections.abc.Iterable[global___GetForecastResponse.TargetItem] | None = ...,
        consensus: global___GetForecastResponse.ConsensusItem | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["consensus", b"consensus"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["consensus", b"consensus", "targets", b"targets"]) -> None: ...

global___GetForecastResponse = GetForecastResponse

@typing.final
class RiskRatesRequest(google.protobuf.message.Message):
    """Запрос ставок риска"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    @property
    def instrument_id(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Идентификаторы инструментов."""

    def __init__(
        self,
        *,
        instrument_id: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instrument_id", b"instrument_id"]) -> None: ...

global___RiskRatesRequest = RiskRatesRequest

@typing.final
class RiskRatesResponse(google.protobuf.message.Message):
    """Ставки риска"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class RiskRateResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        INSTRUMENT_UID_FIELD_NUMBER: builtins.int
        SHORT_RISK_RATE_FIELD_NUMBER: builtins.int
        LONG_RISK_RATE_FIELD_NUMBER: builtins.int
        SHORT_RISK_RATES_FIELD_NUMBER: builtins.int
        LONG_RISK_RATES_FIELD_NUMBER: builtins.int
        ERROR_FIELD_NUMBER: builtins.int
        instrument_uid: builtins.str
        error: builtins.str
        """Ошибка."""
        @property
        def short_risk_rate(self) -> global___RiskRatesResponse.RiskRate:
            """Ставка риска пользователя  в шорт"""

        @property
        def long_risk_rate(self) -> global___RiskRatesResponse.RiskRate:
            """Ставка риска пользователя в лонг"""

        @property
        def short_risk_rates(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RiskRatesResponse.RiskRate]:
            """Доступные ставки риска в шорт"""

        @property
        def long_risk_rates(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RiskRatesResponse.RiskRate]:
            """Доступные ставки риска в лонг"""

        def __init__(
            self,
            *,
            instrument_uid: builtins.str = ...,
            short_risk_rate: global___RiskRatesResponse.RiskRate | None = ...,
            long_risk_rate: global___RiskRatesResponse.RiskRate | None = ...,
            short_risk_rates: collections.abc.Iterable[global___RiskRatesResponse.RiskRate] | None = ...,
            long_risk_rates: collections.abc.Iterable[global___RiskRatesResponse.RiskRate] | None = ...,
            error: builtins.str | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["_error", b"_error", "_long_risk_rate", b"_long_risk_rate", "_short_risk_rate", b"_short_risk_rate", "error", b"error", "long_risk_rate", b"long_risk_rate", "short_risk_rate", b"short_risk_rate"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["_error", b"_error", "_long_risk_rate", b"_long_risk_rate", "_short_risk_rate", b"_short_risk_rate", "error", b"error", "instrument_uid", b"instrument_uid", "long_risk_rate", b"long_risk_rate", "long_risk_rates", b"long_risk_rates", "short_risk_rate", b"short_risk_rate", "short_risk_rates", b"short_risk_rates"]) -> None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing.Literal["_error", b"_error"]) -> typing.Literal["error"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing.Literal["_long_risk_rate", b"_long_risk_rate"]) -> typing.Literal["long_risk_rate"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing.Literal["_short_risk_rate", b"_short_risk_rate"]) -> typing.Literal["short_risk_rate"] | None: ...

    @typing.final
    class RiskRate(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        RISK_LEVEL_CODE_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        risk_level_code: builtins.str
        """Категория риска."""
        @property
        def value(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Значение ставки риска."""

        def __init__(
            self,
            *,
            risk_level_code: builtins.str = ...,
            value: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["risk_level_code", b"risk_level_code", "value", b"value"]) -> None: ...

    INSTRUMENT_RISK_RATES_FIELD_NUMBER: builtins.int
    @property
    def instrument_risk_rates(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RiskRatesResponse.RiskRateResult]: ...
    def __init__(
        self,
        *,
        instrument_risk_rates: collections.abc.Iterable[global___RiskRatesResponse.RiskRateResult] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instrument_risk_rates", b"instrument_risk_rates"]) -> None: ...

global___RiskRatesResponse = RiskRatesResponse

@typing.final
class TradingInterval(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class TimeInterval(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        START_TS_FIELD_NUMBER: builtins.int
        END_TS_FIELD_NUMBER: builtins.int
        @property
        def start_ts(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Время начала интервала."""

        @property
        def end_ts(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Время окончания интервала."""

        def __init__(
            self,
            *,
            start_ts: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            end_ts: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["end_ts", b"end_ts", "start_ts", b"start_ts"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["end_ts", b"end_ts", "start_ts", b"start_ts"]) -> None: ...

    TYPE_FIELD_NUMBER: builtins.int
    INTERVAL_FIELD_NUMBER: builtins.int
    type: builtins.str
    """Название интервала."""
    @property
    def interval(self) -> global___TradingInterval.TimeInterval:
        """Интервал."""

    def __init__(
        self,
        *,
        type: builtins.str = ...,
        interval: global___TradingInterval.TimeInterval | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["interval", b"interval"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["interval", b"interval", "type", b"type"]) -> None: ...

global___TradingInterval = TradingInterval

@typing.final
class GetInsiderDealsRequest(google.protobuf.message.Message):
    """Запрос сделок по инсайдерам"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    NEXT_CURSOR_FIELD_NUMBER: builtins.int
    instrument_id: builtins.str
    limit: builtins.int
    next_cursor: builtins.str
    def __init__(
        self,
        *,
        instrument_id: builtins.str = ...,
        limit: builtins.int = ...,
        next_cursor: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_next_cursor", b"_next_cursor", "next_cursor", b"next_cursor"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_next_cursor", b"_next_cursor", "instrument_id", b"instrument_id", "limit", b"limit", "next_cursor", b"next_cursor"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_next_cursor", b"_next_cursor"]) -> typing.Literal["next_cursor"] | None: ...

global___GetInsiderDealsRequest = GetInsiderDealsRequest

@typing.final
class GetInsiderDealsResponse(google.protobuf.message.Message):
    """сделки инсайдеров"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _TradeDirection:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TradeDirectionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[GetInsiderDealsResponse._TradeDirection.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TRADE_DIRECTION_UNSPECIFIED: GetInsiderDealsResponse._TradeDirection.ValueType  # 0
        """Не определено."""
        TRADE_DIRECTION_BUY: GetInsiderDealsResponse._TradeDirection.ValueType  # 1
        """Покупка."""
        TRADE_DIRECTION_SELL: GetInsiderDealsResponse._TradeDirection.ValueType  # 2
        """Продажа."""
        TRADE_DIRECTION_INCREASE: GetInsiderDealsResponse._TradeDirection.ValueType  # 3
        """Увеличение доли."""
        TRADE_DIRECTION_DECREASE: GetInsiderDealsResponse._TradeDirection.ValueType  # 4
        """Уменьшение доли."""

    class TradeDirection(_TradeDirection, metaclass=_TradeDirectionEnumTypeWrapper): ...
    TRADE_DIRECTION_UNSPECIFIED: GetInsiderDealsResponse.TradeDirection.ValueType  # 0
    """Не определено."""
    TRADE_DIRECTION_BUY: GetInsiderDealsResponse.TradeDirection.ValueType  # 1
    """Покупка."""
    TRADE_DIRECTION_SELL: GetInsiderDealsResponse.TradeDirection.ValueType  # 2
    """Продажа."""
    TRADE_DIRECTION_INCREASE: GetInsiderDealsResponse.TradeDirection.ValueType  # 3
    """Увеличение доли."""
    TRADE_DIRECTION_DECREASE: GetInsiderDealsResponse.TradeDirection.ValueType  # 4
    """Уменьшение доли."""

    @typing.final
    class InsiderDeal(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TRADE_ID_FIELD_NUMBER: builtins.int
        DIRECTION_FIELD_NUMBER: builtins.int
        CURRENCY_FIELD_NUMBER: builtins.int
        DATE_FIELD_NUMBER: builtins.int
        QUANTITY_FIELD_NUMBER: builtins.int
        PRICE_FIELD_NUMBER: builtins.int
        INSTRUMENT_UID_FIELD_NUMBER: builtins.int
        TICKER_FIELD_NUMBER: builtins.int
        INVESTOR_NAME_FIELD_NUMBER: builtins.int
        INVESTOR_POSITION_FIELD_NUMBER: builtins.int
        PERCENTAGE_FIELD_NUMBER: builtins.int
        IS_OPTION_EXECUTION_FIELD_NUMBER: builtins.int
        DISCLOSURE_DATE_FIELD_NUMBER: builtins.int
        trade_id: builtins.int
        """Уникальный идентификатор сделки."""
        direction: global___GetInsiderDealsResponse.TradeDirection.ValueType
        """Направление сделки."""
        currency: builtins.str
        """Валюта сделки."""
        quantity: builtins.int
        """Количество."""
        instrument_uid: builtins.str
        """Уникальный идентификатор инструмента."""
        ticker: builtins.str
        """Тикер инструмента."""
        investor_name: builtins.str
        """Имя инвестора."""
        investor_position: builtins.str
        """Какое отношение покупатель/продавец имеет к эмитенту"""
        percentage: builtins.float
        """Купленный/проданный объём от общего количества ценных бумаг на рынке"""
        is_option_execution: builtins.bool
        """Признак является ли сделка реализацией опциона"""
        @property
        def date(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Дата сделки."""

        @property
        def price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Цена."""

        @property
        def disclosure_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Дата раскрытия сделки."""

        def __init__(
            self,
            *,
            trade_id: builtins.int = ...,
            direction: global___GetInsiderDealsResponse.TradeDirection.ValueType = ...,
            currency: builtins.str = ...,
            date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            quantity: builtins.int = ...,
            price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            instrument_uid: builtins.str = ...,
            ticker: builtins.str = ...,
            investor_name: builtins.str = ...,
            investor_position: builtins.str = ...,
            percentage: builtins.float = ...,
            is_option_execution: builtins.bool = ...,
            disclosure_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["date", b"date", "disclosure_date", b"disclosure_date", "price", b"price"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["currency", b"currency", "date", b"date", "direction", b"direction", "disclosure_date", b"disclosure_date", "instrument_uid", b"instrument_uid", "investor_name", b"investor_name", "investor_position", b"investor_position", "is_option_execution", b"is_option_execution", "percentage", b"percentage", "price", b"price", "quantity", b"quantity", "ticker", b"ticker", "trade_id", b"trade_id"]) -> None: ...

    INSIDER_DEALS_FIELD_NUMBER: builtins.int
    NEXT_CURSOR_FIELD_NUMBER: builtins.int
    next_cursor: builtins.str
    """Курсор для получения следующей страницы."""
    @property
    def insider_deals(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetInsiderDealsResponse.InsiderDeal]:
        """Массив сделок."""

    def __init__(
        self,
        *,
        insider_deals: collections.abc.Iterable[global___GetInsiderDealsResponse.InsiderDeal] | None = ...,
        next_cursor: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_next_cursor", b"_next_cursor", "next_cursor", b"next_cursor"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_next_cursor", b"_next_cursor", "insider_deals", b"insider_deals", "next_cursor", b"next_cursor"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_next_cursor", b"_next_cursor"]) -> typing.Literal["next_cursor"] | None: ...

global___GetInsiderDealsResponse = GetInsiderDealsResponse
