"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import tinkoff.invest.grpc.common_pb2
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _SubscriptionAction:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SubscriptionActionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SubscriptionAction.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SUBSCRIPTION_ACTION_UNSPECIFIED: _SubscriptionAction.ValueType  # 0
    """Статус подписки не определен."""
    SUBSCRIPTION_ACTION_SUBSCRIBE: _SubscriptionAction.ValueType  # 1
    """Подписаться."""
    SUBSCRIPTION_ACTION_UNSUBSCRIBE: _SubscriptionAction.ValueType  # 2
    """Отписаться."""

class SubscriptionAction(_SubscriptionAction, metaclass=_SubscriptionActionEnumTypeWrapper):
    """Тип операции со списком подписок."""

SUBSCRIPTION_ACTION_UNSPECIFIED: SubscriptionAction.ValueType  # 0
"""Статус подписки не определен."""
SUBSCRIPTION_ACTION_SUBSCRIBE: SubscriptionAction.ValueType  # 1
"""Подписаться."""
SUBSCRIPTION_ACTION_UNSUBSCRIBE: SubscriptionAction.ValueType  # 2
"""Отписаться."""
global___SubscriptionAction = SubscriptionAction

class _SubscriptionInterval:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SubscriptionIntervalEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SubscriptionInterval.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SUBSCRIPTION_INTERVAL_UNSPECIFIED: _SubscriptionInterval.ValueType  # 0
    """Интервал свечи не определен."""
    SUBSCRIPTION_INTERVAL_ONE_MINUTE: _SubscriptionInterval.ValueType  # 1
    """Минутные свечи."""
    SUBSCRIPTION_INTERVAL_FIVE_MINUTES: _SubscriptionInterval.ValueType  # 2
    """Пятиминутные свечи."""
    SUBSCRIPTION_INTERVAL_FIFTEEN_MINUTES: _SubscriptionInterval.ValueType  # 3
    """Пятнадцатиминутные свечи."""
    SUBSCRIPTION_INTERVAL_ONE_HOUR: _SubscriptionInterval.ValueType  # 4
    """Часовые свечи."""
    SUBSCRIPTION_INTERVAL_ONE_DAY: _SubscriptionInterval.ValueType  # 5
    """Дневные свечи."""
    SUBSCRIPTION_INTERVAL_2_MIN: _SubscriptionInterval.ValueType  # 6
    """Двухминутные свечи."""
    SUBSCRIPTION_INTERVAL_3_MIN: _SubscriptionInterval.ValueType  # 7
    """Трехминутные свечи."""
    SUBSCRIPTION_INTERVAL_10_MIN: _SubscriptionInterval.ValueType  # 8
    """Десятиминутные свечи."""
    SUBSCRIPTION_INTERVAL_30_MIN: _SubscriptionInterval.ValueType  # 9
    """Тридцатиминутные свечи."""
    SUBSCRIPTION_INTERVAL_2_HOUR: _SubscriptionInterval.ValueType  # 10
    """Двухчасовые свечи."""
    SUBSCRIPTION_INTERVAL_4_HOUR: _SubscriptionInterval.ValueType  # 11
    """Четырехчасовые свечи."""
    SUBSCRIPTION_INTERVAL_WEEK: _SubscriptionInterval.ValueType  # 12
    """Недельные свечи."""
    SUBSCRIPTION_INTERVAL_MONTH: _SubscriptionInterval.ValueType  # 13
    """Месячные свечи."""

class SubscriptionInterval(_SubscriptionInterval, metaclass=_SubscriptionIntervalEnumTypeWrapper):
    """Интервал свечи."""

SUBSCRIPTION_INTERVAL_UNSPECIFIED: SubscriptionInterval.ValueType  # 0
"""Интервал свечи не определен."""
SUBSCRIPTION_INTERVAL_ONE_MINUTE: SubscriptionInterval.ValueType  # 1
"""Минутные свечи."""
SUBSCRIPTION_INTERVAL_FIVE_MINUTES: SubscriptionInterval.ValueType  # 2
"""Пятиминутные свечи."""
SUBSCRIPTION_INTERVAL_FIFTEEN_MINUTES: SubscriptionInterval.ValueType  # 3
"""Пятнадцатиминутные свечи."""
SUBSCRIPTION_INTERVAL_ONE_HOUR: SubscriptionInterval.ValueType  # 4
"""Часовые свечи."""
SUBSCRIPTION_INTERVAL_ONE_DAY: SubscriptionInterval.ValueType  # 5
"""Дневные свечи."""
SUBSCRIPTION_INTERVAL_2_MIN: SubscriptionInterval.ValueType  # 6
"""Двухминутные свечи."""
SUBSCRIPTION_INTERVAL_3_MIN: SubscriptionInterval.ValueType  # 7
"""Трехминутные свечи."""
SUBSCRIPTION_INTERVAL_10_MIN: SubscriptionInterval.ValueType  # 8
"""Десятиминутные свечи."""
SUBSCRIPTION_INTERVAL_30_MIN: SubscriptionInterval.ValueType  # 9
"""Тридцатиминутные свечи."""
SUBSCRIPTION_INTERVAL_2_HOUR: SubscriptionInterval.ValueType  # 10
"""Двухчасовые свечи."""
SUBSCRIPTION_INTERVAL_4_HOUR: SubscriptionInterval.ValueType  # 11
"""Четырехчасовые свечи."""
SUBSCRIPTION_INTERVAL_WEEK: SubscriptionInterval.ValueType  # 12
"""Недельные свечи."""
SUBSCRIPTION_INTERVAL_MONTH: SubscriptionInterval.ValueType  # 13
"""Месячные свечи."""
global___SubscriptionInterval = SubscriptionInterval

class _SubscriptionStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SubscriptionStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SubscriptionStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SUBSCRIPTION_STATUS_UNSPECIFIED: _SubscriptionStatus.ValueType  # 0
    """Статус подписки не определен."""
    SUBSCRIPTION_STATUS_SUCCESS: _SubscriptionStatus.ValueType  # 1
    """Успешно."""
    SUBSCRIPTION_STATUS_INSTRUMENT_NOT_FOUND: _SubscriptionStatus.ValueType  # 2
    """Инструмент не найден."""
    SUBSCRIPTION_STATUS_SUBSCRIPTION_ACTION_IS_INVALID: _SubscriptionStatus.ValueType  # 3
    """Некорректный статус подписки. [Список возможных значений](./marketdata#subscriptionaction)."""
    SUBSCRIPTION_STATUS_DEPTH_IS_INVALID: _SubscriptionStatus.ValueType  # 4
    """Некорректная глубина стакана. Доступные значения — 1, 10, 20, 30, 40, 50."""
    SUBSCRIPTION_STATUS_INTERVAL_IS_INVALID: _SubscriptionStatus.ValueType  # 5
    """Некорректный интервал свечей. [Список возможных значений](./marketdata#subscriptioninterval)."""
    SUBSCRIPTION_STATUS_LIMIT_IS_EXCEEDED: _SubscriptionStatus.ValueType  # 6
    """Превышен лимит на общее количество подписок в рамках стрима. [Лимитная политика](./limits/)."""
    SUBSCRIPTION_STATUS_INTERNAL_ERROR: _SubscriptionStatus.ValueType  # 7
    """Внутренняя ошибка сервиса."""
    SUBSCRIPTION_STATUS_TOO_MANY_REQUESTS: _SubscriptionStatus.ValueType  # 8
    """Превышен лимит на количество запросов на подписки в течение установленного отрезка времени."""
    SUBSCRIPTION_STATUS_SUBSCRIPTION_NOT_FOUND: _SubscriptionStatus.ValueType  # 9
    """Активная подписка не найдена. Ошибка может возникнуть только при отписке от несуществующей подписки."""
    SUBSCRIPTION_STATUS_SOURCE_IS_INVALID: _SubscriptionStatus.ValueType  # 10
    """Указан некорректный источник."""

class SubscriptionStatus(_SubscriptionStatus, metaclass=_SubscriptionStatusEnumTypeWrapper):
    """Результат подписки."""

SUBSCRIPTION_STATUS_UNSPECIFIED: SubscriptionStatus.ValueType  # 0
"""Статус подписки не определен."""
SUBSCRIPTION_STATUS_SUCCESS: SubscriptionStatus.ValueType  # 1
"""Успешно."""
SUBSCRIPTION_STATUS_INSTRUMENT_NOT_FOUND: SubscriptionStatus.ValueType  # 2
"""Инструмент не найден."""
SUBSCRIPTION_STATUS_SUBSCRIPTION_ACTION_IS_INVALID: SubscriptionStatus.ValueType  # 3
"""Некорректный статус подписки. [Список возможных значений](./marketdata#subscriptionaction)."""
SUBSCRIPTION_STATUS_DEPTH_IS_INVALID: SubscriptionStatus.ValueType  # 4
"""Некорректная глубина стакана. Доступные значения — 1, 10, 20, 30, 40, 50."""
SUBSCRIPTION_STATUS_INTERVAL_IS_INVALID: SubscriptionStatus.ValueType  # 5
"""Некорректный интервал свечей. [Список возможных значений](./marketdata#subscriptioninterval)."""
SUBSCRIPTION_STATUS_LIMIT_IS_EXCEEDED: SubscriptionStatus.ValueType  # 6
"""Превышен лимит на общее количество подписок в рамках стрима. [Лимитная политика](./limits/)."""
SUBSCRIPTION_STATUS_INTERNAL_ERROR: SubscriptionStatus.ValueType  # 7
"""Внутренняя ошибка сервиса."""
SUBSCRIPTION_STATUS_TOO_MANY_REQUESTS: SubscriptionStatus.ValueType  # 8
"""Превышен лимит на количество запросов на подписки в течение установленного отрезка времени."""
SUBSCRIPTION_STATUS_SUBSCRIPTION_NOT_FOUND: SubscriptionStatus.ValueType  # 9
"""Активная подписка не найдена. Ошибка может возникнуть только при отписке от несуществующей подписки."""
SUBSCRIPTION_STATUS_SOURCE_IS_INVALID: SubscriptionStatus.ValueType  # 10
"""Указан некорректный источник."""
global___SubscriptionStatus = SubscriptionStatus

class _TradeSourceType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _TradeSourceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_TradeSourceType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TRADE_SOURCE_UNSPECIFIED: _TradeSourceType.ValueType  # 0
    """Тип источника сделки не определён."""
    TRADE_SOURCE_EXCHANGE: _TradeSourceType.ValueType  # 1
    """Биржевые сделки."""
    TRADE_SOURCE_DEALER: _TradeSourceType.ValueType  # 2
    """Сделки дилера."""
    TRADE_SOURCE_ALL: _TradeSourceType.ValueType  # 3
    """Все сделки."""

class TradeSourceType(_TradeSourceType, metaclass=_TradeSourceTypeEnumTypeWrapper):
    """Типы источников сделок."""

TRADE_SOURCE_UNSPECIFIED: TradeSourceType.ValueType  # 0
"""Тип источника сделки не определён."""
TRADE_SOURCE_EXCHANGE: TradeSourceType.ValueType  # 1
"""Биржевые сделки."""
TRADE_SOURCE_DEALER: TradeSourceType.ValueType  # 2
"""Сделки дилера."""
TRADE_SOURCE_ALL: TradeSourceType.ValueType  # 3
"""Все сделки."""
global___TradeSourceType = TradeSourceType

class _TradeDirection:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _TradeDirectionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_TradeDirection.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TRADE_DIRECTION_UNSPECIFIED: _TradeDirection.ValueType  # 0
    """Направление сделки не определено."""
    TRADE_DIRECTION_BUY: _TradeDirection.ValueType  # 1
    """Покупка."""
    TRADE_DIRECTION_SELL: _TradeDirection.ValueType  # 2
    """Продажа."""

class TradeDirection(_TradeDirection, metaclass=_TradeDirectionEnumTypeWrapper):
    """Направление сделки."""

TRADE_DIRECTION_UNSPECIFIED: TradeDirection.ValueType  # 0
"""Направление сделки не определено."""
TRADE_DIRECTION_BUY: TradeDirection.ValueType  # 1
"""Покупка."""
TRADE_DIRECTION_SELL: TradeDirection.ValueType  # 2
"""Продажа."""
global___TradeDirection = TradeDirection

class _CandleInterval:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CandleIntervalEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CandleInterval.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CANDLE_INTERVAL_UNSPECIFIED: _CandleInterval.ValueType  # 0
    """Интервал не определен."""
    CANDLE_INTERVAL_1_MIN: _CandleInterval.ValueType  # 1
    """От 1 минуты до 1 дня. Максимальное значение `limit` — 2400."""
    CANDLE_INTERVAL_5_MIN: _CandleInterval.ValueType  # 2
    """От 5 минут до недели. Максимальное значение `limit` — 2400."""
    CANDLE_INTERVAL_15_MIN: _CandleInterval.ValueType  # 3
    """От 15 минут до 3 недель. Максимальное значение `limit` — 2400."""
    CANDLE_INTERVAL_HOUR: _CandleInterval.ValueType  # 4
    """От 1 часа до 3 месяцев. Максимальное значение `limit` — 2400."""
    CANDLE_INTERVAL_DAY: _CandleInterval.ValueType  # 5
    """От 1 дня до 6 лет. Максимальное значение `limit` — 2400."""
    CANDLE_INTERVAL_2_MIN: _CandleInterval.ValueType  # 6
    """От 2 минут до 1 дня. Максимальное значение `limit` — 1200."""
    CANDLE_INTERVAL_3_MIN: _CandleInterval.ValueType  # 7
    """От 3 минут до 1 дня. Максимальное значение `limit` — 750."""
    CANDLE_INTERVAL_10_MIN: _CandleInterval.ValueType  # 8
    """От 10 минут до недели. Максимальное значение `limit` — 1200."""
    CANDLE_INTERVAL_30_MIN: _CandleInterval.ValueType  # 9
    """От 30 минут до 3 недель. Максимальное значение `limit` — 1200."""
    CANDLE_INTERVAL_2_HOUR: _CandleInterval.ValueType  # 10
    """От 2 часов до 3 месяцев. Максимальное значение `limit` — 2400."""
    CANDLE_INTERVAL_4_HOUR: _CandleInterval.ValueType  # 11
    """От 4 часов до 3 месяцев. Максимальное значение `limit` — 700."""
    CANDLE_INTERVAL_WEEK: _CandleInterval.ValueType  # 12
    """От 1 недели до 5 лет. Максимальное значение `limit` — 300."""
    CANDLE_INTERVAL_MONTH: _CandleInterval.ValueType  # 13
    """От 1 месяца до 10 лет. Максимальное значение `limit` — 120."""
    CANDLE_INTERVAL_5_SEC: _CandleInterval.ValueType  # 14
    """От 5 секунд до 200 минут. Максимальное значение `limit` — 2500."""
    CANDLE_INTERVAL_10_SEC: _CandleInterval.ValueType  # 15
    """От 10 секунд до 200 минут. Максимальное значение `limit` — 1250."""
    CANDLE_INTERVAL_30_SEC: _CandleInterval.ValueType  # 16
    """От 30 секунд до 20 часов. Максимальное значение `limit` — 2500."""

class CandleInterval(_CandleInterval, metaclass=_CandleIntervalEnumTypeWrapper):
    """Интервал свечей. Максимальное значение интервала приведено ориентировочно, может отличаться в большую сторону в зависимости от параметров запроса."""

CANDLE_INTERVAL_UNSPECIFIED: CandleInterval.ValueType  # 0
"""Интервал не определен."""
CANDLE_INTERVAL_1_MIN: CandleInterval.ValueType  # 1
"""От 1 минуты до 1 дня. Максимальное значение `limit` — 2400."""
CANDLE_INTERVAL_5_MIN: CandleInterval.ValueType  # 2
"""От 5 минут до недели. Максимальное значение `limit` — 2400."""
CANDLE_INTERVAL_15_MIN: CandleInterval.ValueType  # 3
"""От 15 минут до 3 недель. Максимальное значение `limit` — 2400."""
CANDLE_INTERVAL_HOUR: CandleInterval.ValueType  # 4
"""От 1 часа до 3 месяцев. Максимальное значение `limit` — 2400."""
CANDLE_INTERVAL_DAY: CandleInterval.ValueType  # 5
"""От 1 дня до 6 лет. Максимальное значение `limit` — 2400."""
CANDLE_INTERVAL_2_MIN: CandleInterval.ValueType  # 6
"""От 2 минут до 1 дня. Максимальное значение `limit` — 1200."""
CANDLE_INTERVAL_3_MIN: CandleInterval.ValueType  # 7
"""От 3 минут до 1 дня. Максимальное значение `limit` — 750."""
CANDLE_INTERVAL_10_MIN: CandleInterval.ValueType  # 8
"""От 10 минут до недели. Максимальное значение `limit` — 1200."""
CANDLE_INTERVAL_30_MIN: CandleInterval.ValueType  # 9
"""От 30 минут до 3 недель. Максимальное значение `limit` — 1200."""
CANDLE_INTERVAL_2_HOUR: CandleInterval.ValueType  # 10
"""От 2 часов до 3 месяцев. Максимальное значение `limit` — 2400."""
CANDLE_INTERVAL_4_HOUR: CandleInterval.ValueType  # 11
"""От 4 часов до 3 месяцев. Максимальное значение `limit` — 700."""
CANDLE_INTERVAL_WEEK: CandleInterval.ValueType  # 12
"""От 1 недели до 5 лет. Максимальное значение `limit` — 300."""
CANDLE_INTERVAL_MONTH: CandleInterval.ValueType  # 13
"""От 1 месяца до 10 лет. Максимальное значение `limit` — 120."""
CANDLE_INTERVAL_5_SEC: CandleInterval.ValueType  # 14
"""От 5 секунд до 200 минут. Максимальное значение `limit` — 2500."""
CANDLE_INTERVAL_10_SEC: CandleInterval.ValueType  # 15
"""От 10 секунд до 200 минут. Максимальное значение `limit` — 1250."""
CANDLE_INTERVAL_30_SEC: CandleInterval.ValueType  # 16
"""От 30 секунд до 20 часов. Максимальное значение `limit` — 2500."""
global___CandleInterval = CandleInterval

class _CandleSource:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CandleSourceEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CandleSource.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CANDLE_SOURCE_UNSPECIFIED: _CandleSource.ValueType  # 0
    """Источник свечей не определен."""
    CANDLE_SOURCE_EXCHANGE: _CandleSource.ValueType  # 1
    """Биржевые свечи."""
    CANDLE_SOURCE_DEALER_WEEKEND: _CandleSource.ValueType  # 2
    """Свечи  дилера в результате торговли по выходным."""

class CandleSource(_CandleSource, metaclass=_CandleSourceEnumTypeWrapper): ...

CANDLE_SOURCE_UNSPECIFIED: CandleSource.ValueType  # 0
"""Источник свечей не определен."""
CANDLE_SOURCE_EXCHANGE: CandleSource.ValueType  # 1
"""Биржевые свечи."""
CANDLE_SOURCE_DEALER_WEEKEND: CandleSource.ValueType  # 2
"""Свечи  дилера в результате торговли по выходным."""
global___CandleSource = CandleSource

class _MarketValueType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _MarketValueTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MarketValueType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INSTRUMENT_VALUE_UNSPECIFIED: _MarketValueType.ValueType  # 0
    """Не определен."""
    INSTRUMENT_VALUE_LAST_PRICE: _MarketValueType.ValueType  # 1
    """Последняя биржевая цена."""
    INSTRUMENT_VALUE_LAST_PRICE_DEALER: _MarketValueType.ValueType  # 2
    """Последняя цена дилера."""
    INSTRUMENT_VALUE_CLOSE_PRICE: _MarketValueType.ValueType  # 3
    """Цена закрытия."""
    INSTRUMENT_VALUE_EVENING_SESSION_PRICE: _MarketValueType.ValueType  # 4
    """Цена последней сделки с вечерней сессии."""
    INSTRUMENT_VALUE_OPEN_INTEREST: _MarketValueType.ValueType  # 5
    """Открытый интерес, возвращается только для фьючерсов."""
    INSTRUMENT_VALUE_THEOR_PRICE: _MarketValueType.ValueType  # 6
    """Теоретическая цена, возвращается только для опционов."""
    INSTRUMENT_VALUE_YIELD: _MarketValueType.ValueType  # 7
    """Доходность"""

class MarketValueType(_MarketValueType, metaclass=_MarketValueTypeEnumTypeWrapper): ...

INSTRUMENT_VALUE_UNSPECIFIED: MarketValueType.ValueType  # 0
"""Не определен."""
INSTRUMENT_VALUE_LAST_PRICE: MarketValueType.ValueType  # 1
"""Последняя биржевая цена."""
INSTRUMENT_VALUE_LAST_PRICE_DEALER: MarketValueType.ValueType  # 2
"""Последняя цена дилера."""
INSTRUMENT_VALUE_CLOSE_PRICE: MarketValueType.ValueType  # 3
"""Цена закрытия."""
INSTRUMENT_VALUE_EVENING_SESSION_PRICE: MarketValueType.ValueType  # 4
"""Цена последней сделки с вечерней сессии."""
INSTRUMENT_VALUE_OPEN_INTEREST: MarketValueType.ValueType  # 5
"""Открытый интерес, возвращается только для фьючерсов."""
INSTRUMENT_VALUE_THEOR_PRICE: MarketValueType.ValueType  # 6
"""Теоретическая цена, возвращается только для опционов."""
INSTRUMENT_VALUE_YIELD: MarketValueType.ValueType  # 7
"""Доходность"""
global___MarketValueType = MarketValueType

class _OrderBookType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _OrderBookTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_OrderBookType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ORDERBOOK_TYPE_UNSPECIFIED: _OrderBookType.ValueType  # 0
    """Не определен."""
    ORDERBOOK_TYPE_EXCHANGE: _OrderBookType.ValueType  # 1
    """Биржевой стакан."""
    ORDERBOOK_TYPE_DEALER: _OrderBookType.ValueType  # 2
    """Стакан дилера."""
    ORDERBOOK_TYPE_ALL: _OrderBookType.ValueType  # 3
    """Стакан биржевой и дилера."""

class OrderBookType(_OrderBookType, metaclass=_OrderBookTypeEnumTypeWrapper): ...

ORDERBOOK_TYPE_UNSPECIFIED: OrderBookType.ValueType  # 0
"""Не определен."""
ORDERBOOK_TYPE_EXCHANGE: OrderBookType.ValueType  # 1
"""Биржевой стакан."""
ORDERBOOK_TYPE_DEALER: OrderBookType.ValueType  # 2
"""Стакан дилера."""
ORDERBOOK_TYPE_ALL: OrderBookType.ValueType  # 3
"""Стакан биржевой и дилера."""
global___OrderBookType = OrderBookType

class _LastPriceType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _LastPriceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_LastPriceType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    LAST_PRICE_UNSPECIFIED: _LastPriceType.ValueType  # 0
    """Не определен."""
    LAST_PRICE_EXCHANGE: _LastPriceType.ValueType  # 1
    """Цена биржи."""
    LAST_PRICE_DEALER: _LastPriceType.ValueType  # 2
    """Цена дилера"""

class LastPriceType(_LastPriceType, metaclass=_LastPriceTypeEnumTypeWrapper):
    """Тип последней цены"""

LAST_PRICE_UNSPECIFIED: LastPriceType.ValueType  # 0
"""Не определен."""
LAST_PRICE_EXCHANGE: LastPriceType.ValueType  # 1
"""Цена биржи."""
LAST_PRICE_DEALER: LastPriceType.ValueType  # 2
"""Цена дилера"""
global___LastPriceType = LastPriceType

@typing.final
class MarketDataRequest(google.protobuf.message.Message):
    """Запрос подписки или отписки на определенные биржевые данные."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBSCRIBE_CANDLES_REQUEST_FIELD_NUMBER: builtins.int
    SUBSCRIBE_ORDER_BOOK_REQUEST_FIELD_NUMBER: builtins.int
    SUBSCRIBE_TRADES_REQUEST_FIELD_NUMBER: builtins.int
    SUBSCRIBE_INFO_REQUEST_FIELD_NUMBER: builtins.int
    SUBSCRIBE_LAST_PRICE_REQUEST_FIELD_NUMBER: builtins.int
    GET_MY_SUBSCRIPTIONS_FIELD_NUMBER: builtins.int
    PING_FIELD_NUMBER: builtins.int
    PING_SETTINGS_FIELD_NUMBER: builtins.int
    @property
    def subscribe_candles_request(self) -> global___SubscribeCandlesRequest:
        """Запрос подписки на свечи."""

    @property
    def subscribe_order_book_request(self) -> global___SubscribeOrderBookRequest:
        """Запрос подписки на стаканы."""

    @property
    def subscribe_trades_request(self) -> global___SubscribeTradesRequest:
        """Запрос подписки на ленту обезличенных сделок."""

    @property
    def subscribe_info_request(self) -> global___SubscribeInfoRequest:
        """Запрос подписки на торговые статусы инструментов."""

    @property
    def subscribe_last_price_request(self) -> global___SubscribeLastPriceRequest:
        """Запрос подписки на цены последних сделок."""

    @property
    def get_my_subscriptions(self) -> global___GetMySubscriptions:
        """Запрос своих подписок."""

    @property
    def ping(self) -> tinkoff.invest.grpc.common_pb2.PingRequest:
        """Запрос проверки активности соединения."""

    @property
    def ping_settings(self) -> tinkoff.invest.grpc.common_pb2.PingDelaySettings:
        """Запрос настройки пинга."""

    def __init__(
        self,
        *,
        subscribe_candles_request: global___SubscribeCandlesRequest | None = ...,
        subscribe_order_book_request: global___SubscribeOrderBookRequest | None = ...,
        subscribe_trades_request: global___SubscribeTradesRequest | None = ...,
        subscribe_info_request: global___SubscribeInfoRequest | None = ...,
        subscribe_last_price_request: global___SubscribeLastPriceRequest | None = ...,
        get_my_subscriptions: global___GetMySubscriptions | None = ...,
        ping: tinkoff.invest.grpc.common_pb2.PingRequest | None = ...,
        ping_settings: tinkoff.invest.grpc.common_pb2.PingDelaySettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["get_my_subscriptions", b"get_my_subscriptions", "payload", b"payload", "ping", b"ping", "ping_settings", b"ping_settings", "subscribe_candles_request", b"subscribe_candles_request", "subscribe_info_request", b"subscribe_info_request", "subscribe_last_price_request", b"subscribe_last_price_request", "subscribe_order_book_request", b"subscribe_order_book_request", "subscribe_trades_request", b"subscribe_trades_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["get_my_subscriptions", b"get_my_subscriptions", "payload", b"payload", "ping", b"ping", "ping_settings", b"ping_settings", "subscribe_candles_request", b"subscribe_candles_request", "subscribe_info_request", b"subscribe_info_request", "subscribe_last_price_request", b"subscribe_last_price_request", "subscribe_order_book_request", b"subscribe_order_book_request", "subscribe_trades_request", b"subscribe_trades_request"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["payload", b"payload"]) -> typing.Literal["subscribe_candles_request", "subscribe_order_book_request", "subscribe_trades_request", "subscribe_info_request", "subscribe_last_price_request", "get_my_subscriptions", "ping", "ping_settings"] | None: ...

global___MarketDataRequest = MarketDataRequest

@typing.final
class MarketDataServerSideStreamRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBSCRIBE_CANDLES_REQUEST_FIELD_NUMBER: builtins.int
    SUBSCRIBE_ORDER_BOOK_REQUEST_FIELD_NUMBER: builtins.int
    SUBSCRIBE_TRADES_REQUEST_FIELD_NUMBER: builtins.int
    SUBSCRIBE_INFO_REQUEST_FIELD_NUMBER: builtins.int
    SUBSCRIBE_LAST_PRICE_REQUEST_FIELD_NUMBER: builtins.int
    PING_SETTINGS_FIELD_NUMBER: builtins.int
    @property
    def subscribe_candles_request(self) -> global___SubscribeCandlesRequest:
        """Запрос подписки на свечи."""

    @property
    def subscribe_order_book_request(self) -> global___SubscribeOrderBookRequest:
        """Запрос подписки на стаканы."""

    @property
    def subscribe_trades_request(self) -> global___SubscribeTradesRequest:
        """Запрос подписки на ленту обезличенных сделок."""

    @property
    def subscribe_info_request(self) -> global___SubscribeInfoRequest:
        """Запрос подписки на торговые статусы инструментов."""

    @property
    def subscribe_last_price_request(self) -> global___SubscribeLastPriceRequest:
        """Запрос подписки на цены последних сделок."""

    @property
    def ping_settings(self) -> tinkoff.invest.grpc.common_pb2.PingDelaySettings:
        """Запрос настройки пинга."""

    def __init__(
        self,
        *,
        subscribe_candles_request: global___SubscribeCandlesRequest | None = ...,
        subscribe_order_book_request: global___SubscribeOrderBookRequest | None = ...,
        subscribe_trades_request: global___SubscribeTradesRequest | None = ...,
        subscribe_info_request: global___SubscribeInfoRequest | None = ...,
        subscribe_last_price_request: global___SubscribeLastPriceRequest | None = ...,
        ping_settings: tinkoff.invest.grpc.common_pb2.PingDelaySettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ping_settings", b"ping_settings", "subscribe_candles_request", b"subscribe_candles_request", "subscribe_info_request", b"subscribe_info_request", "subscribe_last_price_request", b"subscribe_last_price_request", "subscribe_order_book_request", b"subscribe_order_book_request", "subscribe_trades_request", b"subscribe_trades_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["ping_settings", b"ping_settings", "subscribe_candles_request", b"subscribe_candles_request", "subscribe_info_request", b"subscribe_info_request", "subscribe_last_price_request", b"subscribe_last_price_request", "subscribe_order_book_request", b"subscribe_order_book_request", "subscribe_trades_request", b"subscribe_trades_request"]) -> None: ...

global___MarketDataServerSideStreamRequest = MarketDataServerSideStreamRequest

@typing.final
class MarketDataResponse(google.protobuf.message.Message):
    """Пакет биржевой информации по подписке."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBSCRIBE_CANDLES_RESPONSE_FIELD_NUMBER: builtins.int
    SUBSCRIBE_ORDER_BOOK_RESPONSE_FIELD_NUMBER: builtins.int
    SUBSCRIBE_TRADES_RESPONSE_FIELD_NUMBER: builtins.int
    SUBSCRIBE_INFO_RESPONSE_FIELD_NUMBER: builtins.int
    CANDLE_FIELD_NUMBER: builtins.int
    TRADE_FIELD_NUMBER: builtins.int
    ORDERBOOK_FIELD_NUMBER: builtins.int
    TRADING_STATUS_FIELD_NUMBER: builtins.int
    PING_FIELD_NUMBER: builtins.int
    SUBSCRIBE_LAST_PRICE_RESPONSE_FIELD_NUMBER: builtins.int
    LAST_PRICE_FIELD_NUMBER: builtins.int
    OPEN_INTEREST_FIELD_NUMBER: builtins.int
    @property
    def subscribe_candles_response(self) -> global___SubscribeCandlesResponse:
        """Результат подписки на свечи."""

    @property
    def subscribe_order_book_response(self) -> global___SubscribeOrderBookResponse:
        """Результат подписки на стаканы."""

    @property
    def subscribe_trades_response(self) -> global___SubscribeTradesResponse:
        """Результат подписки на поток обезличенных сделок."""

    @property
    def subscribe_info_response(self) -> global___SubscribeInfoResponse:
        """Результат подписки на торговые статусы инструментов."""

    @property
    def candle(self) -> global___Candle:
        """Свеча."""

    @property
    def trade(self) -> global___Trade:
        """Сделки."""

    @property
    def orderbook(self) -> global___OrderBook:
        """Стакан."""

    @property
    def trading_status(self) -> global___TradingStatus:
        """Торговый статус."""

    @property
    def ping(self) -> tinkoff.invest.grpc.common_pb2.Ping:
        """Проверка активности стрима."""

    @property
    def subscribe_last_price_response(self) -> global___SubscribeLastPriceResponse:
        """Результат подписки на цены последние сделок по инструментам."""

    @property
    def last_price(self) -> global___LastPrice:
        """Цена последней сделки."""

    @property
    def open_interest(self) -> global___OpenInterest:
        """Открытый интерес."""

    def __init__(
        self,
        *,
        subscribe_candles_response: global___SubscribeCandlesResponse | None = ...,
        subscribe_order_book_response: global___SubscribeOrderBookResponse | None = ...,
        subscribe_trades_response: global___SubscribeTradesResponse | None = ...,
        subscribe_info_response: global___SubscribeInfoResponse | None = ...,
        candle: global___Candle | None = ...,
        trade: global___Trade | None = ...,
        orderbook: global___OrderBook | None = ...,
        trading_status: global___TradingStatus | None = ...,
        ping: tinkoff.invest.grpc.common_pb2.Ping | None = ...,
        subscribe_last_price_response: global___SubscribeLastPriceResponse | None = ...,
        last_price: global___LastPrice | None = ...,
        open_interest: global___OpenInterest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["candle", b"candle", "last_price", b"last_price", "open_interest", b"open_interest", "orderbook", b"orderbook", "payload", b"payload", "ping", b"ping", "subscribe_candles_response", b"subscribe_candles_response", "subscribe_info_response", b"subscribe_info_response", "subscribe_last_price_response", b"subscribe_last_price_response", "subscribe_order_book_response", b"subscribe_order_book_response", "subscribe_trades_response", b"subscribe_trades_response", "trade", b"trade", "trading_status", b"trading_status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["candle", b"candle", "last_price", b"last_price", "open_interest", b"open_interest", "orderbook", b"orderbook", "payload", b"payload", "ping", b"ping", "subscribe_candles_response", b"subscribe_candles_response", "subscribe_info_response", b"subscribe_info_response", "subscribe_last_price_response", b"subscribe_last_price_response", "subscribe_order_book_response", b"subscribe_order_book_response", "subscribe_trades_response", b"subscribe_trades_response", "trade", b"trade", "trading_status", b"trading_status"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["payload", b"payload"]) -> typing.Literal["subscribe_candles_response", "subscribe_order_book_response", "subscribe_trades_response", "subscribe_info_response", "candle", "trade", "orderbook", "trading_status", "ping", "subscribe_last_price_response", "last_price", "open_interest"] | None: ...

global___MarketDataResponse = MarketDataResponse

@typing.final
class SubscribeCandlesRequest(google.protobuf.message.Message):
    """subscribeCandles | Изменения статуса подписки на свечи."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBSCRIPTION_ACTION_FIELD_NUMBER: builtins.int
    INSTRUMENTS_FIELD_NUMBER: builtins.int
    WAITING_CLOSE_FIELD_NUMBER: builtins.int
    CANDLE_SOURCE_TYPE_FIELD_NUMBER: builtins.int
    subscription_action: global___SubscriptionAction.ValueType
    """Изменение статуса подписки."""
    waiting_close: builtins.bool
    """Флаг ожидания закрытия временного интервала для отправки свечи."""
    candle_source_type: global___GetCandlesRequest.CandleSource.ValueType
    """Источник свечей."""
    @property
    def instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CandleInstrument]:
        """Массив инструментов для подписки на свечи."""

    def __init__(
        self,
        *,
        subscription_action: global___SubscriptionAction.ValueType = ...,
        instruments: collections.abc.Iterable[global___CandleInstrument] | None = ...,
        waiting_close: builtins.bool = ...,
        candle_source_type: global___GetCandlesRequest.CandleSource.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_candle_source_type", b"_candle_source_type", "candle_source_type", b"candle_source_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_candle_source_type", b"_candle_source_type", "candle_source_type", b"candle_source_type", "instruments", b"instruments", "subscription_action", b"subscription_action", "waiting_close", b"waiting_close"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_candle_source_type", b"_candle_source_type"]) -> typing.Literal["candle_source_type"] | None: ...

global___SubscribeCandlesRequest = SubscribeCandlesRequest

@typing.final
class CandleInstrument(google.protobuf.message.Message):
    """Запрос изменения статус подписки на свечи."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    INTERVAL_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """Deprecated FIGI-идентификатор инструмента. Используйте `instrument_id`."""
    interval: global___SubscriptionInterval.ValueType
    """Интервал свечей. Двухчасовые и четырехчасовые свечи в стриме отсчитываются с 0:00 по UTC."""
    instrument_id: builtins.str
    """Идентификатор инструмента. Принимает значение `figi`, `instrument_uid` или `ticker + '_' + class_code`."""
    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        interval: global___SubscriptionInterval.ValueType = ...,
        instrument_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["figi", b"figi", "instrument_id", b"instrument_id", "interval", b"interval"]) -> None: ...

global___CandleInstrument = CandleInstrument

@typing.final
class SubscribeCandlesResponse(google.protobuf.message.Message):
    """Результат изменения статус подписки на свечи."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRACKING_ID_FIELD_NUMBER: builtins.int
    CANDLES_SUBSCRIPTIONS_FIELD_NUMBER: builtins.int
    tracking_id: builtins.str
    """Уникальный идентификатор запроса. [Подробнее](./grpc#tracking-id)."""
    @property
    def candles_subscriptions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CandleSubscription]:
        """Массив статусов подписки на свечи."""

    def __init__(
        self,
        *,
        tracking_id: builtins.str = ...,
        candles_subscriptions: collections.abc.Iterable[global___CandleSubscription] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["candles_subscriptions", b"candles_subscriptions", "tracking_id", b"tracking_id"]) -> None: ...

global___SubscribeCandlesResponse = SubscribeCandlesResponse

@typing.final
class CandleSubscription(google.protobuf.message.Message):
    """Статус подписки на свечи."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    INTERVAL_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_STATUS_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    WAITING_CLOSE_FIELD_NUMBER: builtins.int
    STREAM_ID_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_ID_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_ACTION_FIELD_NUMBER: builtins.int
    CANDLE_SOURCE_TYPE_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    interval: global___SubscriptionInterval.ValueType
    """Интервал свечей."""
    subscription_status: global___SubscriptionStatus.ValueType
    """Статус подписки."""
    instrument_uid: builtins.str
    """UID инструмента."""
    waiting_close: builtins.bool
    """Флаг ожидания закрытия временного интервала для отправки свечи."""
    stream_id: builtins.str
    """Идентификатор открытого соединения."""
    subscription_id: builtins.str
    """Идентификатор подписки в формате `UUID`."""
    subscription_action: global___SubscriptionAction.ValueType
    """Действие подписки."""
    candle_source_type: global___GetCandlesRequest.CandleSource.ValueType
    """Источник свечей."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        interval: global___SubscriptionInterval.ValueType = ...,
        subscription_status: global___SubscriptionStatus.ValueType = ...,
        instrument_uid: builtins.str = ...,
        waiting_close: builtins.bool = ...,
        stream_id: builtins.str = ...,
        subscription_id: builtins.str = ...,
        subscription_action: global___SubscriptionAction.ValueType = ...,
        candle_source_type: global___GetCandlesRequest.CandleSource.ValueType | None = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_candle_source_type", b"_candle_source_type", "candle_source_type", b"candle_source_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_candle_source_type", b"_candle_source_type", "candle_source_type", b"candle_source_type", "class_code", b"class_code", "figi", b"figi", "instrument_uid", b"instrument_uid", "interval", b"interval", "stream_id", b"stream_id", "subscription_action", b"subscription_action", "subscription_id", b"subscription_id", "subscription_status", b"subscription_status", "ticker", b"ticker", "waiting_close", b"waiting_close"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_candle_source_type", b"_candle_source_type"]) -> typing.Literal["candle_source_type"] | None: ...

global___CandleSubscription = CandleSubscription

@typing.final
class SubscribeOrderBookRequest(google.protobuf.message.Message):
    """Запрос на изменение статуса подписки на стаканы."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBSCRIPTION_ACTION_FIELD_NUMBER: builtins.int
    INSTRUMENTS_FIELD_NUMBER: builtins.int
    subscription_action: global___SubscriptionAction.ValueType
    """Изменение статуса подписки."""
    @property
    def instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OrderBookInstrument]:
        """Массив инструментов для подписки на стаканы."""

    def __init__(
        self,
        *,
        subscription_action: global___SubscriptionAction.ValueType = ...,
        instruments: collections.abc.Iterable[global___OrderBookInstrument] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instruments", b"instruments", "subscription_action", b"subscription_action"]) -> None: ...

global___SubscribeOrderBookRequest = SubscribeOrderBookRequest

@typing.final
class OrderBookInstrument(google.protobuf.message.Message):
    """Запрос подписки на стаканы."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    DEPTH_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    ORDER_BOOK_TYPE_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """Deprecated FIGI-идентификатор инструмента. Используйте `instrument_id`."""
    depth: builtins.int
    """Глубина стакана."""
    instrument_id: builtins.str
    """Идентификатор инструмента. Принимает значение `figi`, `instrument_uid` или `ticker + '_' + class_code`."""
    order_book_type: global___OrderBookType.ValueType
    """Тип стакана. Значение по умолчанию — `ORDERBOOK_TYPE_ALL`, стакан биржевой и дилера."""
    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        depth: builtins.int = ...,
        instrument_id: builtins.str = ...,
        order_book_type: global___OrderBookType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["depth", b"depth", "figi", b"figi", "instrument_id", b"instrument_id", "order_book_type", b"order_book_type"]) -> None: ...

global___OrderBookInstrument = OrderBookInstrument

@typing.final
class SubscribeOrderBookResponse(google.protobuf.message.Message):
    """Результат изменения статуса подписки на стаканы."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRACKING_ID_FIELD_NUMBER: builtins.int
    ORDER_BOOK_SUBSCRIPTIONS_FIELD_NUMBER: builtins.int
    tracking_id: builtins.str
    """Уникальный идентификатор запроса. [Подробнее](./grpc#tracking-id)."""
    @property
    def order_book_subscriptions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OrderBookSubscription]:
        """Массив статусов подписки на стаканы."""

    def __init__(
        self,
        *,
        tracking_id: builtins.str = ...,
        order_book_subscriptions: collections.abc.Iterable[global___OrderBookSubscription] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["order_book_subscriptions", b"order_book_subscriptions", "tracking_id", b"tracking_id"]) -> None: ...

global___SubscribeOrderBookResponse = SubscribeOrderBookResponse

@typing.final
class OrderBookSubscription(google.protobuf.message.Message):
    """Статус подписки."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    DEPTH_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_STATUS_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    STREAM_ID_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_ID_FIELD_NUMBER: builtins.int
    ORDER_BOOK_TYPE_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_ACTION_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    depth: builtins.int
    """Глубина стакана."""
    subscription_status: global___SubscriptionStatus.ValueType
    """Статус подписки."""
    instrument_uid: builtins.str
    """UID инструмента."""
    stream_id: builtins.str
    """Идентификатор открытого соединения."""
    subscription_id: builtins.str
    """Идентификатор подписки в формате `UUID`."""
    order_book_type: global___OrderBookType.ValueType
    """Тип стакана."""
    subscription_action: global___SubscriptionAction.ValueType
    """Действие подписки."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        depth: builtins.int = ...,
        subscription_status: global___SubscriptionStatus.ValueType = ...,
        instrument_uid: builtins.str = ...,
        stream_id: builtins.str = ...,
        subscription_id: builtins.str = ...,
        order_book_type: global___OrderBookType.ValueType = ...,
        subscription_action: global___SubscriptionAction.ValueType = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["class_code", b"class_code", "depth", b"depth", "figi", b"figi", "instrument_uid", b"instrument_uid", "order_book_type", b"order_book_type", "stream_id", b"stream_id", "subscription_action", b"subscription_action", "subscription_id", b"subscription_id", "subscription_status", b"subscription_status", "ticker", b"ticker"]) -> None: ...

global___OrderBookSubscription = OrderBookSubscription

@typing.final
class SubscribeTradesRequest(google.protobuf.message.Message):
    """Изменение статуса подписки на поток обезличенных сделок."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBSCRIPTION_ACTION_FIELD_NUMBER: builtins.int
    INSTRUMENTS_FIELD_NUMBER: builtins.int
    TRADE_SOURCE_FIELD_NUMBER: builtins.int
    WITH_OPEN_INTEREST_FIELD_NUMBER: builtins.int
    subscription_action: global___SubscriptionAction.ValueType
    """Изменение статуса подписки."""
    trade_source: global___TradeSourceType.ValueType
    """Тип источника сделок. Значение по умолчанию — `TRADE_SOURCE_ALL`, все сделки."""
    with_open_interest: builtins.bool
    """Флаг открытого интереса. **true** - в стриме дополнительно передается информация об открытом интересе для фьючерсов"""
    @property
    def instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TradeInstrument]:
        """Массив инструментов для подписки на поток обезличенных сделок."""

    def __init__(
        self,
        *,
        subscription_action: global___SubscriptionAction.ValueType = ...,
        instruments: collections.abc.Iterable[global___TradeInstrument] | None = ...,
        trade_source: global___TradeSourceType.ValueType = ...,
        with_open_interest: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instruments", b"instruments", "subscription_action", b"subscription_action", "trade_source", b"trade_source", "with_open_interest", b"with_open_interest"]) -> None: ...

global___SubscribeTradesRequest = SubscribeTradesRequest

@typing.final
class TradeInstrument(google.protobuf.message.Message):
    """Запрос подписки на поток обезличенных сделок."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """Deprecated FIGI-идентификатор инструмента. Используйте instrument_id`."""
    instrument_id: builtins.str
    """Идентификатор инструмента. Принимает значение `figi`, `instrument_uid` или `ticker + '_' + class_code`."""
    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        instrument_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["figi", b"figi", "instrument_id", b"instrument_id"]) -> None: ...

global___TradeInstrument = TradeInstrument

@typing.final
class SubscribeTradesResponse(google.protobuf.message.Message):
    """Результат изменения статуса подписки на поток обезличенных сделок."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRACKING_ID_FIELD_NUMBER: builtins.int
    TRADE_SUBSCRIPTIONS_FIELD_NUMBER: builtins.int
    TRADE_SOURCE_FIELD_NUMBER: builtins.int
    tracking_id: builtins.str
    """Уникальный идентификатор запроса. [Подробнее](./grpc#tracking-id)."""
    trade_source: global___TradeSourceType.ValueType
    """Тип источника сделок."""
    @property
    def trade_subscriptions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TradeSubscription]:
        """Массив статусов подписки на поток сделок."""

    def __init__(
        self,
        *,
        tracking_id: builtins.str = ...,
        trade_subscriptions: collections.abc.Iterable[global___TradeSubscription] | None = ...,
        trade_source: global___TradeSourceType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["tracking_id", b"tracking_id", "trade_source", b"trade_source", "trade_subscriptions", b"trade_subscriptions"]) -> None: ...

global___SubscribeTradesResponse = SubscribeTradesResponse

@typing.final
class TradeSubscription(google.protobuf.message.Message):
    """Статус подписки."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_STATUS_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    STREAM_ID_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_ID_FIELD_NUMBER: builtins.int
    WITH_OPEN_INTEREST_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_ACTION_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    subscription_status: global___SubscriptionStatus.ValueType
    """Статус подписки."""
    instrument_uid: builtins.str
    """UID инструмента."""
    stream_id: builtins.str
    """Идентификатор открытого соединения."""
    subscription_id: builtins.str
    """Идентификатор подписки в формате UUID."""
    with_open_interest: builtins.bool
    """Флаг открытого интереса. **true** - в стриме дополнительно передается информация об открытом интересе для фьючерсов"""
    subscription_action: global___SubscriptionAction.ValueType
    """Действие подписки."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        subscription_status: global___SubscriptionStatus.ValueType = ...,
        instrument_uid: builtins.str = ...,
        stream_id: builtins.str = ...,
        subscription_id: builtins.str = ...,
        with_open_interest: builtins.bool = ...,
        subscription_action: global___SubscriptionAction.ValueType = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["class_code", b"class_code", "figi", b"figi", "instrument_uid", b"instrument_uid", "stream_id", b"stream_id", "subscription_action", b"subscription_action", "subscription_id", b"subscription_id", "subscription_status", b"subscription_status", "ticker", b"ticker", "with_open_interest", b"with_open_interest"]) -> None: ...

global___TradeSubscription = TradeSubscription

@typing.final
class SubscribeInfoRequest(google.protobuf.message.Message):
    """Изменение статуса подписки на торговый статус инструмента."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBSCRIPTION_ACTION_FIELD_NUMBER: builtins.int
    INSTRUMENTS_FIELD_NUMBER: builtins.int
    subscription_action: global___SubscriptionAction.ValueType
    """Изменение статуса подписки."""
    @property
    def instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___InfoInstrument]:
        """Массив инструментов для подписки на торговый статус."""

    def __init__(
        self,
        *,
        subscription_action: global___SubscriptionAction.ValueType = ...,
        instruments: collections.abc.Iterable[global___InfoInstrument] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instruments", b"instruments", "subscription_action", b"subscription_action"]) -> None: ...

global___SubscribeInfoRequest = SubscribeInfoRequest

@typing.final
class InfoInstrument(google.protobuf.message.Message):
    """Запрос подписки на торговый статус."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """Deprecated FIGI-идентификатор инструмента. Используйте instrument_id`."""
    instrument_id: builtins.str
    """Идентификатор инструмента. Принимает значение `figi`, `instrument_uid` или `ticker + '_' + class_code`."""
    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        instrument_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["figi", b"figi", "instrument_id", b"instrument_id"]) -> None: ...

global___InfoInstrument = InfoInstrument

@typing.final
class SubscribeInfoResponse(google.protobuf.message.Message):
    """Результат изменения статуса подписки на торговый статус."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRACKING_ID_FIELD_NUMBER: builtins.int
    INFO_SUBSCRIPTIONS_FIELD_NUMBER: builtins.int
    tracking_id: builtins.str
    """Уникальный идентификатор запроса. [Подробнее](./grpc#tracking-id)."""
    @property
    def info_subscriptions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___InfoSubscription]:
        """Массив статусов подписки на торговый статус."""

    def __init__(
        self,
        *,
        tracking_id: builtins.str = ...,
        info_subscriptions: collections.abc.Iterable[global___InfoSubscription] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["info_subscriptions", b"info_subscriptions", "tracking_id", b"tracking_id"]) -> None: ...

global___SubscribeInfoResponse = SubscribeInfoResponse

@typing.final
class InfoSubscription(google.protobuf.message.Message):
    """Статус подписки."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_STATUS_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    STREAM_ID_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_ID_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_ACTION_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    subscription_status: global___SubscriptionStatus.ValueType
    """Статус подписки."""
    instrument_uid: builtins.str
    """UID инструмента."""
    stream_id: builtins.str
    """Идентификатор открытого соединения."""
    subscription_id: builtins.str
    """Идентификатор подписки в формате UUID."""
    subscription_action: global___SubscriptionAction.ValueType
    """Действие подписки."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        subscription_status: global___SubscriptionStatus.ValueType = ...,
        instrument_uid: builtins.str = ...,
        stream_id: builtins.str = ...,
        subscription_id: builtins.str = ...,
        subscription_action: global___SubscriptionAction.ValueType = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["class_code", b"class_code", "figi", b"figi", "instrument_uid", b"instrument_uid", "stream_id", b"stream_id", "subscription_action", b"subscription_action", "subscription_id", b"subscription_id", "subscription_status", b"subscription_status", "ticker", b"ticker"]) -> None: ...

global___InfoSubscription = InfoSubscription

@typing.final
class SubscribeLastPriceRequest(google.protobuf.message.Message):
    """Изменение статуса подписки на цену последней сделки по инструменту."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBSCRIPTION_ACTION_FIELD_NUMBER: builtins.int
    INSTRUMENTS_FIELD_NUMBER: builtins.int
    subscription_action: global___SubscriptionAction.ValueType
    """Изменение статуса подписки."""
    @property
    def instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LastPriceInstrument]:
        """Массив инструментов для подписки на цену последней сделки."""

    def __init__(
        self,
        *,
        subscription_action: global___SubscriptionAction.ValueType = ...,
        instruments: collections.abc.Iterable[global___LastPriceInstrument] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instruments", b"instruments", "subscription_action", b"subscription_action"]) -> None: ...

global___SubscribeLastPriceRequest = SubscribeLastPriceRequest

@typing.final
class LastPriceInstrument(google.protobuf.message.Message):
    """Запрос подписки на последнюю цену."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """Deprecated FIGI-идентификатор инструмента. Используйте instrument_id`."""
    instrument_id: builtins.str
    """Идентификатор инструмента. Принимает значение `figi`, `instrument_uid` или `ticker + '_' + class_code`."""
    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        instrument_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["figi", b"figi", "instrument_id", b"instrument_id"]) -> None: ...

global___LastPriceInstrument = LastPriceInstrument

@typing.final
class SubscribeLastPriceResponse(google.protobuf.message.Message):
    """Результат изменения статуса подписки на цену последней сделки."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRACKING_ID_FIELD_NUMBER: builtins.int
    LAST_PRICE_SUBSCRIPTIONS_FIELD_NUMBER: builtins.int
    tracking_id: builtins.str
    """Уникальный идентификатор запроса. [Подробнее](./grpc#tracking-id)."""
    @property
    def last_price_subscriptions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LastPriceSubscription]:
        """Массив статусов подписки на цену последней сделки."""

    def __init__(
        self,
        *,
        tracking_id: builtins.str = ...,
        last_price_subscriptions: collections.abc.Iterable[global___LastPriceSubscription] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["last_price_subscriptions", b"last_price_subscriptions", "tracking_id", b"tracking_id"]) -> None: ...

global___SubscribeLastPriceResponse = SubscribeLastPriceResponse

@typing.final
class LastPriceSubscription(google.protobuf.message.Message):
    """Статус подписки на цену последней сделки."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_STATUS_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    STREAM_ID_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_ID_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_ACTION_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    subscription_status: global___SubscriptionStatus.ValueType
    """Статус подписки."""
    instrument_uid: builtins.str
    """UID инструмента."""
    stream_id: builtins.str
    """Идентификатор открытого соединения."""
    subscription_id: builtins.str
    """Идентификатор подписки в формате `UUID`."""
    subscription_action: global___SubscriptionAction.ValueType
    """Действие подписки."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        subscription_status: global___SubscriptionStatus.ValueType = ...,
        instrument_uid: builtins.str = ...,
        stream_id: builtins.str = ...,
        subscription_id: builtins.str = ...,
        subscription_action: global___SubscriptionAction.ValueType = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["class_code", b"class_code", "figi", b"figi", "instrument_uid", b"instrument_uid", "stream_id", b"stream_id", "subscription_action", b"subscription_action", "subscription_id", b"subscription_id", "subscription_status", b"subscription_status", "ticker", b"ticker"]) -> None: ...

global___LastPriceSubscription = LastPriceSubscription

@typing.final
class Candle(google.protobuf.message.Message):
    """Пакет свечей в рамках стрима."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    INTERVAL_FIELD_NUMBER: builtins.int
    OPEN_FIELD_NUMBER: builtins.int
    HIGH_FIELD_NUMBER: builtins.int
    LOW_FIELD_NUMBER: builtins.int
    CLOSE_FIELD_NUMBER: builtins.int
    VOLUME_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    LAST_TRADE_TS_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    VOLUME_BUY_FIELD_NUMBER: builtins.int
    VOLUME_SELL_FIELD_NUMBER: builtins.int
    CANDLE_SOURCE_TYPE_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    interval: global___SubscriptionInterval.ValueType
    """Интервал свечи."""
    volume: builtins.int
    """Объем сделок в лотах."""
    instrument_uid: builtins.str
    """UID инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    volume_buy: builtins.int
    """Объем торгов на покупку."""
    volume_sell: builtins.int
    """Объём торгов на продажу."""
    candle_source_type: global___CandleSource.ValueType
    """Источник свечей."""
    @property
    def open(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена открытия за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента. [Подробнее про перевод цен в валюту](./faq_marketdata/#_15)."""

    @property
    def high(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Максимальная цена за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента. [Подробнее про перевод цен в валюту](./faq_marketdata/#_15)."""

    @property
    def low(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Минимальная цена за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента. [Подробнее про перевод цен в валюту](./faq_marketdata/#_15)."""

    @property
    def close(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена закрытия за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента. [Подробнее про перевод цен в валюту](./faq_marketdata/#_15)."""

    @property
    def time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время начала интервала свечи по UTC."""

    @property
    def last_trade_ts(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время последней сделки, вошедшей в свечу по UTC."""

    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        interval: global___SubscriptionInterval.ValueType = ...,
        open: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        high: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        low: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        close: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        volume: builtins.int = ...,
        time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_trade_ts: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        instrument_uid: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        volume_buy: builtins.int = ...,
        volume_sell: builtins.int = ...,
        candle_source_type: global___CandleSource.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["close", b"close", "high", b"high", "last_trade_ts", b"last_trade_ts", "low", b"low", "open", b"open", "time", b"time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["candle_source_type", b"candle_source_type", "class_code", b"class_code", "close", b"close", "figi", b"figi", "high", b"high", "instrument_uid", b"instrument_uid", "interval", b"interval", "last_trade_ts", b"last_trade_ts", "low", b"low", "open", b"open", "ticker", b"ticker", "time", b"time", "volume", b"volume", "volume_buy", b"volume_buy", "volume_sell", b"volume_sell"]) -> None: ...

global___Candle = Candle

@typing.final
class OrderBook(google.protobuf.message.Message):
    """Пакет стаканов в рамках стрима."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    DEPTH_FIELD_NUMBER: builtins.int
    IS_CONSISTENT_FIELD_NUMBER: builtins.int
    BIDS_FIELD_NUMBER: builtins.int
    ASKS_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    LIMIT_UP_FIELD_NUMBER: builtins.int
    LIMIT_DOWN_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    ORDER_BOOK_TYPE_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    depth: builtins.int
    """Глубина стакана."""
    is_consistent: builtins.bool
    """Флаг консистентности стакана. **false** — не все заявки попали в стакан из-за сетевых задержек или нарушения порядка доставки."""
    instrument_uid: builtins.str
    """UID инструмента."""
    order_book_type: global___OrderBookType.ValueType
    """Тип стакана."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    @property
    def bids(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Order]:
        """Массив предложений."""

    @property
    def asks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Order]:
        """Массив спроса."""

    @property
    def time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время формирования стакана в часовом поясе UTC по времени биржи."""

    @property
    def limit_up(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Верхний лимит цены за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента. [Подробнее про перевод цен в валюту](./faq_marketdata/#_15)."""

    @property
    def limit_down(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Нижний лимит цены за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента. [Подробнее про перевод цен в валюту](./faq_marketdata/#_15)."""

    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        depth: builtins.int = ...,
        is_consistent: builtins.bool = ...,
        bids: collections.abc.Iterable[global___Order] | None = ...,
        asks: collections.abc.Iterable[global___Order] | None = ...,
        time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        limit_up: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        limit_down: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        instrument_uid: builtins.str = ...,
        order_book_type: global___OrderBookType.ValueType = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["limit_down", b"limit_down", "limit_up", b"limit_up", "time", b"time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["asks", b"asks", "bids", b"bids", "class_code", b"class_code", "depth", b"depth", "figi", b"figi", "instrument_uid", b"instrument_uid", "is_consistent", b"is_consistent", "limit_down", b"limit_down", "limit_up", b"limit_up", "order_book_type", b"order_book_type", "ticker", b"ticker", "time", b"time"]) -> None: ...

global___OrderBook = OrderBook

@typing.final
class Order(google.protobuf.message.Message):
    """Массив предложений/спроса."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PRICE_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    quantity: builtins.int
    """Количество в лотах."""
    @property
    def price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента. [Подробнее про перевод цен в валюту](./faq_marketdata/#_15)."""

    def __init__(
        self,
        *,
        price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        quantity: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["price", b"price"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["price", b"price", "quantity", b"quantity"]) -> None: ...

global___Order = Order

@typing.final
class Trade(google.protobuf.message.Message):
    """Информация о сделке."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    PRICE_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    TRADE_SOURCE_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    direction: global___TradeDirection.ValueType
    """Направление сделки."""
    quantity: builtins.int
    """Количество лотов."""
    instrument_uid: builtins.str
    """UID инструмента."""
    trade_source: global___TradeSourceType.ValueType
    """Тип источника сделки."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    @property
    def price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента. [Подробнее про перевод цен в валюту](./faq_marketdata/#_15)."""

    @property
    def time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время сделки в часовом поясе UTC по времени биржи."""

    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        direction: global___TradeDirection.ValueType = ...,
        price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        quantity: builtins.int = ...,
        time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        instrument_uid: builtins.str = ...,
        trade_source: global___TradeSourceType.ValueType = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["price", b"price", "time", b"time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["class_code", b"class_code", "direction", b"direction", "figi", b"figi", "instrument_uid", b"instrument_uid", "price", b"price", "quantity", b"quantity", "ticker", b"ticker", "time", b"time", "trade_source", b"trade_source"]) -> None: ...

global___Trade = Trade

@typing.final
class TradingStatus(google.protobuf.message.Message):
    """Пакет изменения торгового статуса."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    TRADING_STATUS_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    LIMIT_ORDER_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    MARKET_ORDER_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType
    """Статус торговли инструментом."""
    limit_order_available_flag: builtins.bool
    """Признак доступности выставления лимитной заявки по инструменту."""
    market_order_available_flag: builtins.bool
    """Признак доступности выставления рыночной заявки по инструменту."""
    instrument_uid: builtins.str
    """UID инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    @property
    def time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время изменения торгового статуса по UTC."""

    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType = ...,
        time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        limit_order_available_flag: builtins.bool = ...,
        market_order_available_flag: builtins.bool = ...,
        instrument_uid: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["time", b"time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["class_code", b"class_code", "figi", b"figi", "instrument_uid", b"instrument_uid", "limit_order_available_flag", b"limit_order_available_flag", "market_order_available_flag", b"market_order_available_flag", "ticker", b"ticker", "time", b"time", "trading_status", b"trading_status"]) -> None: ...

global___TradingStatus = TradingStatus

@typing.final
class GetCandlesRequest(google.protobuf.message.Message):
    """Запрос исторических свечей."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _CandleSource:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _CandleSourceEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[GetCandlesRequest._CandleSource.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        CANDLE_SOURCE_UNSPECIFIED: GetCandlesRequest._CandleSource.ValueType  # 0
        """Все свечи."""
        CANDLE_SOURCE_EXCHANGE: GetCandlesRequest._CandleSource.ValueType  # 1
        """Биржевые свечи."""
        CANDLE_SOURCE_INCLUDE_WEEKEND: GetCandlesRequest._CandleSource.ValueType  # 3
        """Все свечи с учетом торговли по выходным."""

    class CandleSource(_CandleSource, metaclass=_CandleSourceEnumTypeWrapper): ...
    CANDLE_SOURCE_UNSPECIFIED: GetCandlesRequest.CandleSource.ValueType  # 0
    """Все свечи."""
    CANDLE_SOURCE_EXCHANGE: GetCandlesRequest.CandleSource.ValueType  # 1
    """Биржевые свечи."""
    CANDLE_SOURCE_INCLUDE_WEEKEND: GetCandlesRequest.CandleSource.ValueType  # 3
    """Все свечи с учетом торговли по выходным."""

    FIGI_FIELD_NUMBER: builtins.int
    FROM_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    INTERVAL_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    CANDLE_SOURCE_TYPE_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """Deprecated FIGI-идентификатор инструмента. Используйте `instrument_id`."""
    interval: global___CandleInterval.ValueType
    """Интервал запрошенных свечей."""
    instrument_id: builtins.str
    """Идентификатор инструмента. Принимает значение `figi`, `instrument_uid` или `ticker + '_' + class_code`."""
    candle_source_type: global___GetCandlesRequest.CandleSource.ValueType
    """Тип источника свечи."""
    limit: builtins.int
    """Максимальное количество свечей в ответе."""
    @property
    def to(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Окончание запрашиваемого периода по UTC."""

    def __init__(
        self,
        *,
        figi: builtins.str | None = ...,
        to: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        interval: global___CandleInterval.ValueType = ...,
        instrument_id: builtins.str | None = ...,
        candle_source_type: global___GetCandlesRequest.CandleSource.ValueType | None = ...,
        limit: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_candle_source_type", b"_candle_source_type", "_figi", b"_figi", "_instrument_id", b"_instrument_id", "_limit", b"_limit", "candle_source_type", b"candle_source_type", "figi", b"figi", "from", b"from", "instrument_id", b"instrument_id", "limit", b"limit", "to", b"to"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_candle_source_type", b"_candle_source_type", "_figi", b"_figi", "_instrument_id", b"_instrument_id", "_limit", b"_limit", "candle_source_type", b"candle_source_type", "figi", b"figi", "from", b"from", "instrument_id", b"instrument_id", "interval", b"interval", "limit", b"limit", "to", b"to"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_candle_source_type", b"_candle_source_type"]) -> typing.Literal["candle_source_type"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_figi", b"_figi"]) -> typing.Literal["figi"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_instrument_id", b"_instrument_id"]) -> typing.Literal["instrument_id"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_limit", b"_limit"]) -> typing.Literal["limit"] | None: ...

global___GetCandlesRequest = GetCandlesRequest

@typing.final
class GetCandlesResponse(google.protobuf.message.Message):
    """Список свечей."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CANDLES_FIELD_NUMBER: builtins.int
    @property
    def candles(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HistoricCandle]:
        """Массив свечей."""

    def __init__(
        self,
        *,
        candles: collections.abc.Iterable[global___HistoricCandle] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["candles", b"candles"]) -> None: ...

global___GetCandlesResponse = GetCandlesResponse

@typing.final
class HistoricCandle(google.protobuf.message.Message):
    """Информация о свече."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPEN_FIELD_NUMBER: builtins.int
    HIGH_FIELD_NUMBER: builtins.int
    LOW_FIELD_NUMBER: builtins.int
    CLOSE_FIELD_NUMBER: builtins.int
    VOLUME_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    IS_COMPLETE_FIELD_NUMBER: builtins.int
    CANDLE_SOURCE_FIELD_NUMBER: builtins.int
    VOLUME_BUY_FIELD_NUMBER: builtins.int
    VOLUME_SELL_FIELD_NUMBER: builtins.int
    volume: builtins.int
    """Объем торгов в лотах."""
    is_complete: builtins.bool
    """Признак завершенности свечи. **false** — свеча за текущие интервал еще сформирована не полностью."""
    candle_source: global___CandleSource.ValueType
    """Тип источника свечи"""
    volume_buy: builtins.int
    """Объем торгов на покупку."""
    volume_sell: builtins.int
    """Объём торгов на продажу."""
    @property
    def open(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена открытия за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента. [Подробнее про перевод цен в валюту](./faq_marketdata/#_15)."""

    @property
    def high(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Максимальная цена за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента. [Подробнее про перевод цен в валюту](./faq_marketdata/#_15)."""

    @property
    def low(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Минимальная цена за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента. [Подробнее про перевод цен в валюту](./faq_marketdata/#_15)."""

    @property
    def close(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена закрытия за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента. [Подробнее про перевод цен в валюту](./faq_marketdata/#_15)."""

    @property
    def time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время свечи в часовом поясе UTC."""

    def __init__(
        self,
        *,
        open: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        high: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        low: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        close: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        volume: builtins.int = ...,
        time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        is_complete: builtins.bool = ...,
        candle_source: global___CandleSource.ValueType = ...,
        volume_buy: builtins.int = ...,
        volume_sell: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["close", b"close", "high", b"high", "low", b"low", "open", b"open", "time", b"time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["candle_source", b"candle_source", "close", b"close", "high", b"high", "is_complete", b"is_complete", "low", b"low", "open", b"open", "time", b"time", "volume", b"volume", "volume_buy", b"volume_buy", "volume_sell", b"volume_sell"]) -> None: ...

global___HistoricCandle = HistoricCandle

@typing.final
class GetLastPricesRequest(google.protobuf.message.Message):
    """Запрос получения цен последних сделок."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    LAST_PRICE_TYPE_FIELD_NUMBER: builtins.int
    INSTRUMENT_STATUS_FIELD_NUMBER: builtins.int
    last_price_type: global___LastPriceType.ValueType
    """Тип запрашиваемой последней цены."""
    instrument_status: tinkoff.invest.grpc.common_pb2.InstrumentStatus.ValueType
    """Статус запрашиваемых инструментов. [Возможные значения](#instrumentstatus)."""
    @property
    def figi(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Deprecated FIGI-идентификатор инструмента. Используйте `instrument_id`."""

    @property
    def instrument_id(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Массив идентификаторов инструмента. Принимает значения `figi`, `instrument_uid` или `ticker + '_' + class_code`."""

    def __init__(
        self,
        *,
        figi: collections.abc.Iterable[builtins.str] | None = ...,
        instrument_id: collections.abc.Iterable[builtins.str] | None = ...,
        last_price_type: global___LastPriceType.ValueType = ...,
        instrument_status: tinkoff.invest.grpc.common_pb2.InstrumentStatus.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_instrument_status", b"_instrument_status", "instrument_status", b"instrument_status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_instrument_status", b"_instrument_status", "figi", b"figi", "instrument_id", b"instrument_id", "instrument_status", b"instrument_status", "last_price_type", b"last_price_type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_instrument_status", b"_instrument_status"]) -> typing.Literal["instrument_status"] | None: ...

global___GetLastPricesRequest = GetLastPricesRequest

@typing.final
class GetLastPricesResponse(google.protobuf.message.Message):
    """Список цен последних сделок."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LAST_PRICES_FIELD_NUMBER: builtins.int
    @property
    def last_prices(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LastPrice]:
        """Массив цен последних сделок."""

    def __init__(
        self,
        *,
        last_prices: collections.abc.Iterable[global___LastPrice] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["last_prices", b"last_prices"]) -> None: ...

global___GetLastPricesResponse = GetLastPricesResponse

@typing.final
class LastPrice(google.protobuf.message.Message):
    """Информация о цене последней сделки."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    PRICE_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    LAST_PRICE_TYPE_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    instrument_uid: builtins.str
    """UID инструмента."""
    last_price_type: global___LastPriceType.ValueType
    """Тип последней цены."""
    @property
    def price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена последней сделки за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента. [Подробнее про перевод цен в валюту](./faq_marketdata/#_15)."""

    @property
    def time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время получения последней цены в часовом поясе UTC по времени биржи."""

    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        instrument_uid: builtins.str = ...,
        last_price_type: global___LastPriceType.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["price", b"price", "time", b"time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["class_code", b"class_code", "figi", b"figi", "instrument_uid", b"instrument_uid", "last_price_type", b"last_price_type", "price", b"price", "ticker", b"ticker", "time", b"time"]) -> None: ...

global___LastPrice = LastPrice

@typing.final
class OpenInterest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    OPEN_INTEREST_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    instrument_uid: builtins.str
    """UID инструмента."""
    open_interest: builtins.int
    """Открытый интерес."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    @property
    def time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время получения открытого интереса в часовом поясе UTC по времени биржи."""

    def __init__(
        self,
        *,
        instrument_uid: builtins.str = ...,
        time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        open_interest: builtins.int = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["time", b"time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["class_code", b"class_code", "instrument_uid", b"instrument_uid", "open_interest", b"open_interest", "ticker", b"ticker", "time", b"time"]) -> None: ...

global___OpenInterest = OpenInterest

@typing.final
class GetOrderBookRequest(google.protobuf.message.Message):
    """Запрос стакана."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    DEPTH_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """Deprecated FIGI-идентификатор инструмента. Используйте `instrument_id`."""
    depth: builtins.int
    """Глубина стакана."""
    instrument_id: builtins.str
    """Идентификатор инструмента. Принимает значение `figi`, `instrument_uid` или `ticker + '_' + class_code`."""
    def __init__(
        self,
        *,
        figi: builtins.str | None = ...,
        depth: builtins.int = ...,
        instrument_id: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_figi", b"_figi", "_instrument_id", b"_instrument_id", "figi", b"figi", "instrument_id", b"instrument_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_figi", b"_figi", "_instrument_id", b"_instrument_id", "depth", b"depth", "figi", b"figi", "instrument_id", b"instrument_id"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_figi", b"_figi"]) -> typing.Literal["figi"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_instrument_id", b"_instrument_id"]) -> typing.Literal["instrument_id"] | None: ...

global___GetOrderBookRequest = GetOrderBookRequest

@typing.final
class GetOrderBookResponse(google.protobuf.message.Message):
    """Информация о стакане."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    DEPTH_FIELD_NUMBER: builtins.int
    BIDS_FIELD_NUMBER: builtins.int
    ASKS_FIELD_NUMBER: builtins.int
    LAST_PRICE_FIELD_NUMBER: builtins.int
    CLOSE_PRICE_FIELD_NUMBER: builtins.int
    LIMIT_UP_FIELD_NUMBER: builtins.int
    LIMIT_DOWN_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    LAST_PRICE_TS_FIELD_NUMBER: builtins.int
    CLOSE_PRICE_TS_FIELD_NUMBER: builtins.int
    ORDERBOOK_TS_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    depth: builtins.int
    """Глубина стакана."""
    instrument_uid: builtins.str
    """UID инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    @property
    def bids(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Order]:
        """Множество пар значений на покупку."""

    @property
    def asks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Order]:
        """Множество пар значений на продажу."""

    @property
    def last_price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена последней сделки за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента. [Подробнее про перевод цен в валюту](./faq_marketdata/#_15)."""

    @property
    def close_price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена закрытия за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента. [Подробнее про перевод цен в валюту](./faq_marketdata/#_15)."""

    @property
    def limit_up(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Верхний лимит цены за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента. [Подробнее про перевод цен в валюту](./faq_marketdata/#_15)."""

    @property
    def limit_down(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Нижний лимит цены за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента. [Подробнее про перевод цен в валюту](./faq_marketdata/#_15)."""

    @property
    def last_price_ts(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время получения цены последней сделки."""

    @property
    def close_price_ts(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время получения цены закрытия."""

    @property
    def orderbook_ts(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время формирования стакана на бирже."""

    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        depth: builtins.int = ...,
        bids: collections.abc.Iterable[global___Order] | None = ...,
        asks: collections.abc.Iterable[global___Order] | None = ...,
        last_price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        close_price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        limit_up: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        limit_down: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        instrument_uid: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        last_price_ts: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        close_price_ts: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        orderbook_ts: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["close_price", b"close_price", "close_price_ts", b"close_price_ts", "last_price", b"last_price", "last_price_ts", b"last_price_ts", "limit_down", b"limit_down", "limit_up", b"limit_up", "orderbook_ts", b"orderbook_ts"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["asks", b"asks", "bids", b"bids", "class_code", b"class_code", "close_price", b"close_price", "close_price_ts", b"close_price_ts", "depth", b"depth", "figi", b"figi", "instrument_uid", b"instrument_uid", "last_price", b"last_price", "last_price_ts", b"last_price_ts", "limit_down", b"limit_down", "limit_up", b"limit_up", "orderbook_ts", b"orderbook_ts", "ticker", b"ticker"]) -> None: ...

global___GetOrderBookResponse = GetOrderBookResponse

@typing.final
class GetTradingStatusRequest(google.protobuf.message.Message):
    """Запрос получения торгового статуса."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """Deprecated FIGI-идентификатор инструмента. Используйте `instrument_id`."""
    instrument_id: builtins.str
    """Идентификатор инструмента. Принимает значение `figi`, `instrument_uid` или `ticker + '_' + class_code`"""
    def __init__(
        self,
        *,
        figi: builtins.str | None = ...,
        instrument_id: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_figi", b"_figi", "_instrument_id", b"_instrument_id", "figi", b"figi", "instrument_id", b"instrument_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_figi", b"_figi", "_instrument_id", b"_instrument_id", "figi", b"figi", "instrument_id", b"instrument_id"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_figi", b"_figi"]) -> typing.Literal["figi"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_instrument_id", b"_instrument_id"]) -> typing.Literal["instrument_id"] | None: ...

global___GetTradingStatusRequest = GetTradingStatusRequest

@typing.final
class GetTradingStatusesRequest(google.protobuf.message.Message):
    """Запрос получения торгового статуса."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    @property
    def instrument_id(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Идентификатор инструмента. Принимает значение `figi`, `instrument_uid` или `ticker + '_' + class_code`"""

    def __init__(
        self,
        *,
        instrument_id: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instrument_id", b"instrument_id"]) -> None: ...

global___GetTradingStatusesRequest = GetTradingStatusesRequest

@typing.final
class GetTradingStatusesResponse(google.protobuf.message.Message):
    """Информация о торговом статусе."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRADING_STATUSES_FIELD_NUMBER: builtins.int
    @property
    def trading_statuses(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetTradingStatusResponse]:
        """Массив информации о торговых статусах."""

    def __init__(
        self,
        *,
        trading_statuses: collections.abc.Iterable[global___GetTradingStatusResponse] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["trading_statuses", b"trading_statuses"]) -> None: ...

global___GetTradingStatusesResponse = GetTradingStatusesResponse

@typing.final
class GetTradingStatusResponse(google.protobuf.message.Message):
    """Информация о торговом статусе."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    TRADING_STATUS_FIELD_NUMBER: builtins.int
    LIMIT_ORDER_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    MARKET_ORDER_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    API_TRADE_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    BESTPRICE_ORDER_AVAILABLE_FLAG_FIELD_NUMBER: builtins.int
    ONLY_BEST_PRICE_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType
    """Статус торговли инструментом."""
    limit_order_available_flag: builtins.bool
    """Признак доступности выставления лимитной заявки по инструменту."""
    market_order_available_flag: builtins.bool
    """Признак доступности выставления рыночной заявки по инструменту."""
    api_trade_available_flag: builtins.bool
    """Признак доступности торгов через API."""
    instrument_uid: builtins.str
    """UID инструмента."""
    bestprice_order_available_flag: builtins.bool
    """Признак доступности завяки по лучшей цене."""
    only_best_price: builtins.bool
    """Признак доступности только заявки по лучшей цене."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        trading_status: tinkoff.invest.grpc.common_pb2.SecurityTradingStatus.ValueType = ...,
        limit_order_available_flag: builtins.bool = ...,
        market_order_available_flag: builtins.bool = ...,
        api_trade_available_flag: builtins.bool = ...,
        instrument_uid: builtins.str = ...,
        bestprice_order_available_flag: builtins.bool = ...,
        only_best_price: builtins.bool = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["api_trade_available_flag", b"api_trade_available_flag", "bestprice_order_available_flag", b"bestprice_order_available_flag", "class_code", b"class_code", "figi", b"figi", "instrument_uid", b"instrument_uid", "limit_order_available_flag", b"limit_order_available_flag", "market_order_available_flag", b"market_order_available_flag", "only_best_price", b"only_best_price", "ticker", b"ticker", "trading_status", b"trading_status"]) -> None: ...

global___GetTradingStatusResponse = GetTradingStatusResponse

@typing.final
class GetLastTradesRequest(google.protobuf.message.Message):
    """Запрос обезличенных сделок за последний час."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    FROM_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    TRADE_SOURCE_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """Deprecated FIGI-идентификатор инструмента. Используйте `instrument_id`."""
    instrument_id: builtins.str
    """Идентификатор инструмента. Принимает значение `figi`, `instrument_uid` или `ticker + '_' + class_code`"""
    trade_source: global___TradeSourceType.ValueType
    """Тип источника сделок. Значение по умолчанию — `TRADE_SOURCE_ALL`, все сделки."""
    @property
    def to(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Окончание запрашиваемого периода по UTC."""

    def __init__(
        self,
        *,
        figi: builtins.str | None = ...,
        to: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        instrument_id: builtins.str | None = ...,
        trade_source: global___TradeSourceType.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_figi", b"_figi", "_instrument_id", b"_instrument_id", "figi", b"figi", "from", b"from", "instrument_id", b"instrument_id", "to", b"to"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_figi", b"_figi", "_instrument_id", b"_instrument_id", "figi", b"figi", "from", b"from", "instrument_id", b"instrument_id", "to", b"to", "trade_source", b"trade_source"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_figi", b"_figi"]) -> typing.Literal["figi"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_instrument_id", b"_instrument_id"]) -> typing.Literal["instrument_id"] | None: ...

global___GetLastTradesRequest = GetLastTradesRequest

@typing.final
class GetLastTradesResponse(google.protobuf.message.Message):
    """Обезличенных сделок за последний час."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRADES_FIELD_NUMBER: builtins.int
    @property
    def trades(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Trade]:
        """Массив сделок."""

    def __init__(
        self,
        *,
        trades: collections.abc.Iterable[global___Trade] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["trades", b"trades"]) -> None: ...

global___GetLastTradesResponse = GetLastTradesResponse

@typing.final
class GetMySubscriptions(google.protobuf.message.Message):
    """Запрос активных подписок. Возвращает по одному сообщению на каждый тип активных подписок — `SubscribeLastPriceResponse`, `SubscribeInfoResponse`, `SubscribeTradesResponse`, `SubscribeOrderBookResponse`, `SubscribeCandlesResponse`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GetMySubscriptions = GetMySubscriptions

@typing.final
class GetClosePricesRequest(google.protobuf.message.Message):
    """Запрос цен закрытия торговой сессии по инструментам."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENTS_FIELD_NUMBER: builtins.int
    INSTRUMENT_STATUS_FIELD_NUMBER: builtins.int
    instrument_status: tinkoff.invest.grpc.common_pb2.InstrumentStatus.ValueType
    """Статус запрашиваемых инструментов. [Возможные значения](#instrumentstatus)."""
    @property
    def instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___InstrumentClosePriceRequest]:
        """Массив по инструментам."""

    def __init__(
        self,
        *,
        instruments: collections.abc.Iterable[global___InstrumentClosePriceRequest] | None = ...,
        instrument_status: tinkoff.invest.grpc.common_pb2.InstrumentStatus.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_instrument_status", b"_instrument_status", "instrument_status", b"instrument_status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_instrument_status", b"_instrument_status", "instrument_status", b"instrument_status", "instruments", b"instruments"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_instrument_status", b"_instrument_status"]) -> typing.Literal["instrument_status"] | None: ...

global___GetClosePricesRequest = GetClosePricesRequest

@typing.final
class InstrumentClosePriceRequest(google.protobuf.message.Message):
    """Запрос цен закрытия торговой сессии по инструменту."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    instrument_id: builtins.str
    """Идентификатор инструмента. Принимает значение `figi`, `instrument_uid` или `ticker + '_' + class_code`"""
    def __init__(
        self,
        *,
        instrument_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instrument_id", b"instrument_id"]) -> None: ...

global___InstrumentClosePriceRequest = InstrumentClosePriceRequest

@typing.final
class GetClosePricesResponse(google.protobuf.message.Message):
    """Цены закрытия торговой сессии по инструментам."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLOSE_PRICES_FIELD_NUMBER: builtins.int
    @property
    def close_prices(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___InstrumentClosePriceResponse]:
        """Массив по инструментам."""

    def __init__(
        self,
        *,
        close_prices: collections.abc.Iterable[global___InstrumentClosePriceResponse] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["close_prices", b"close_prices"]) -> None: ...

global___GetClosePricesResponse = GetClosePricesResponse

@typing.final
class InstrumentClosePriceResponse(google.protobuf.message.Message):
    """Цена закрытия торговой сессии по инструменту."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    PRICE_FIELD_NUMBER: builtins.int
    EVENING_SESSION_PRICE_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    EVENING_SESSION_PRICE_TIME_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI инструмента."""
    instrument_uid: builtins.str
    """UID инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    @property
    def price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена закрытия торговой сессии."""

    @property
    def evening_session_price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена последней сделки с вечерней сессии. Цена публикуется биржей по торговым дням и в нерабочие дни не обновляется."""

    @property
    def time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата совершения торгов."""

    @property
    def evening_session_price_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата цены закрытия вечерней сессии."""

    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        instrument_uid: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        evening_session_price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        evening_session_price_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["evening_session_price", b"evening_session_price", "evening_session_price_time", b"evening_session_price_time", "price", b"price", "time", b"time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["class_code", b"class_code", "evening_session_price", b"evening_session_price", "evening_session_price_time", b"evening_session_price_time", "figi", b"figi", "instrument_uid", b"instrument_uid", "price", b"price", "ticker", b"ticker", "time", b"time"]) -> None: ...

global___InstrumentClosePriceResponse = InstrumentClosePriceResponse

@typing.final
class GetTechAnalysisRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _IndicatorInterval:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _IndicatorIntervalEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[GetTechAnalysisRequest._IndicatorInterval.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        INDICATOR_INTERVAL_UNSPECIFIED: GetTechAnalysisRequest._IndicatorInterval.ValueType  # 0
        """Интервал не определен."""
        INDICATOR_INTERVAL_ONE_MINUTE: GetTechAnalysisRequest._IndicatorInterval.ValueType  # 1
        """1 минута."""
        INDICATOR_INTERVAL_FIVE_MINUTES: GetTechAnalysisRequest._IndicatorInterval.ValueType  # 2
        """5 минут."""
        INDICATOR_INTERVAL_FIFTEEN_MINUTES: GetTechAnalysisRequest._IndicatorInterval.ValueType  # 3
        """15 минут."""
        INDICATOR_INTERVAL_ONE_HOUR: GetTechAnalysisRequest._IndicatorInterval.ValueType  # 4
        """1 час."""
        INDICATOR_INTERVAL_ONE_DAY: GetTechAnalysisRequest._IndicatorInterval.ValueType  # 5
        """1 день."""
        INDICATOR_INTERVAL_2_MIN: GetTechAnalysisRequest._IndicatorInterval.ValueType  # 6
        """2 минуты."""
        INDICATOR_INTERVAL_3_MIN: GetTechAnalysisRequest._IndicatorInterval.ValueType  # 7
        """3 минуты."""
        INDICATOR_INTERVAL_10_MIN: GetTechAnalysisRequest._IndicatorInterval.ValueType  # 8
        """10 минут."""
        INDICATOR_INTERVAL_30_MIN: GetTechAnalysisRequest._IndicatorInterval.ValueType  # 9
        """30 минут."""
        INDICATOR_INTERVAL_2_HOUR: GetTechAnalysisRequest._IndicatorInterval.ValueType  # 10
        """2 часа."""
        INDICATOR_INTERVAL_4_HOUR: GetTechAnalysisRequest._IndicatorInterval.ValueType  # 11
        """4 часа."""
        INDICATOR_INTERVAL_WEEK: GetTechAnalysisRequest._IndicatorInterval.ValueType  # 12
        """Неделя."""
        INDICATOR_INTERVAL_MONTH: GetTechAnalysisRequest._IndicatorInterval.ValueType  # 13
        """Месяц."""

    class IndicatorInterval(_IndicatorInterval, metaclass=_IndicatorIntervalEnumTypeWrapper):
        """Интервал свечи."""

    INDICATOR_INTERVAL_UNSPECIFIED: GetTechAnalysisRequest.IndicatorInterval.ValueType  # 0
    """Интервал не определен."""
    INDICATOR_INTERVAL_ONE_MINUTE: GetTechAnalysisRequest.IndicatorInterval.ValueType  # 1
    """1 минута."""
    INDICATOR_INTERVAL_FIVE_MINUTES: GetTechAnalysisRequest.IndicatorInterval.ValueType  # 2
    """5 минут."""
    INDICATOR_INTERVAL_FIFTEEN_MINUTES: GetTechAnalysisRequest.IndicatorInterval.ValueType  # 3
    """15 минут."""
    INDICATOR_INTERVAL_ONE_HOUR: GetTechAnalysisRequest.IndicatorInterval.ValueType  # 4
    """1 час."""
    INDICATOR_INTERVAL_ONE_DAY: GetTechAnalysisRequest.IndicatorInterval.ValueType  # 5
    """1 день."""
    INDICATOR_INTERVAL_2_MIN: GetTechAnalysisRequest.IndicatorInterval.ValueType  # 6
    """2 минуты."""
    INDICATOR_INTERVAL_3_MIN: GetTechAnalysisRequest.IndicatorInterval.ValueType  # 7
    """3 минуты."""
    INDICATOR_INTERVAL_10_MIN: GetTechAnalysisRequest.IndicatorInterval.ValueType  # 8
    """10 минут."""
    INDICATOR_INTERVAL_30_MIN: GetTechAnalysisRequest.IndicatorInterval.ValueType  # 9
    """30 минут."""
    INDICATOR_INTERVAL_2_HOUR: GetTechAnalysisRequest.IndicatorInterval.ValueType  # 10
    """2 часа."""
    INDICATOR_INTERVAL_4_HOUR: GetTechAnalysisRequest.IndicatorInterval.ValueType  # 11
    """4 часа."""
    INDICATOR_INTERVAL_WEEK: GetTechAnalysisRequest.IndicatorInterval.ValueType  # 12
    """Неделя."""
    INDICATOR_INTERVAL_MONTH: GetTechAnalysisRequest.IndicatorInterval.ValueType  # 13
    """Месяц."""

    class _TypeOfPrice:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeOfPriceEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[GetTechAnalysisRequest._TypeOfPrice.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_OF_PRICE_UNSPECIFIED: GetTechAnalysisRequest._TypeOfPrice.ValueType  # 0
        """Не указано."""
        TYPE_OF_PRICE_CLOSE: GetTechAnalysisRequest._TypeOfPrice.ValueType  # 1
        """Цена закрытия."""
        TYPE_OF_PRICE_OPEN: GetTechAnalysisRequest._TypeOfPrice.ValueType  # 2
        """Цена открытия."""
        TYPE_OF_PRICE_HIGH: GetTechAnalysisRequest._TypeOfPrice.ValueType  # 3
        """Максимальное значение за выбранный интервал."""
        TYPE_OF_PRICE_LOW: GetTechAnalysisRequest._TypeOfPrice.ValueType  # 4
        """Минимальное значение за выбранный интервал."""
        TYPE_OF_PRICE_AVG: GetTechAnalysisRequest._TypeOfPrice.ValueType  # 5
        """Среднее значение по показателям [ (close + open + high + low) / 4 ]."""

    class TypeOfPrice(_TypeOfPrice, metaclass=_TypeOfPriceEnumTypeWrapper): ...
    TYPE_OF_PRICE_UNSPECIFIED: GetTechAnalysisRequest.TypeOfPrice.ValueType  # 0
    """Не указано."""
    TYPE_OF_PRICE_CLOSE: GetTechAnalysisRequest.TypeOfPrice.ValueType  # 1
    """Цена закрытия."""
    TYPE_OF_PRICE_OPEN: GetTechAnalysisRequest.TypeOfPrice.ValueType  # 2
    """Цена открытия."""
    TYPE_OF_PRICE_HIGH: GetTechAnalysisRequest.TypeOfPrice.ValueType  # 3
    """Максимальное значение за выбранный интервал."""
    TYPE_OF_PRICE_LOW: GetTechAnalysisRequest.TypeOfPrice.ValueType  # 4
    """Минимальное значение за выбранный интервал."""
    TYPE_OF_PRICE_AVG: GetTechAnalysisRequest.TypeOfPrice.ValueType  # 5
    """Среднее значение по показателям [ (close + open + high + low) / 4 ]."""

    class _IndicatorType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _IndicatorTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[GetTechAnalysisRequest._IndicatorType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        INDICATOR_TYPE_UNSPECIFIED: GetTechAnalysisRequest._IndicatorType.ValueType  # 0
        """Не определен."""
        INDICATOR_TYPE_BB: GetTechAnalysisRequest._IndicatorType.ValueType  # 1
        """Bollinger Bands — линия Боллинжера."""
        INDICATOR_TYPE_EMA: GetTechAnalysisRequest._IndicatorType.ValueType  # 2
        """Exponential Moving Average — EMA, экспоненциальная скользящая средняя."""
        INDICATOR_TYPE_RSI: GetTechAnalysisRequest._IndicatorType.ValueType  # 3
        """Relative Strength Index — индекс относительной силы."""
        INDICATOR_TYPE_MACD: GetTechAnalysisRequest._IndicatorType.ValueType  # 4
        """Moving Average Convergence/Divergence — схождение/расхождение скользящих средних."""
        INDICATOR_TYPE_SMA: GetTechAnalysisRequest._IndicatorType.ValueType  # 5
        """Simple Moving Average — простое скользящее среднее."""

    class IndicatorType(_IndicatorType, metaclass=_IndicatorTypeEnumTypeWrapper): ...
    INDICATOR_TYPE_UNSPECIFIED: GetTechAnalysisRequest.IndicatorType.ValueType  # 0
    """Не определен."""
    INDICATOR_TYPE_BB: GetTechAnalysisRequest.IndicatorType.ValueType  # 1
    """Bollinger Bands — линия Боллинжера."""
    INDICATOR_TYPE_EMA: GetTechAnalysisRequest.IndicatorType.ValueType  # 2
    """Exponential Moving Average — EMA, экспоненциальная скользящая средняя."""
    INDICATOR_TYPE_RSI: GetTechAnalysisRequest.IndicatorType.ValueType  # 3
    """Relative Strength Index — индекс относительной силы."""
    INDICATOR_TYPE_MACD: GetTechAnalysisRequest.IndicatorType.ValueType  # 4
    """Moving Average Convergence/Divergence — схождение/расхождение скользящих средних."""
    INDICATOR_TYPE_SMA: GetTechAnalysisRequest.IndicatorType.ValueType  # 5
    """Simple Moving Average — простое скользящее среднее."""

    @typing.final
    class Smoothing(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        FAST_LENGTH_FIELD_NUMBER: builtins.int
        SLOW_LENGTH_FIELD_NUMBER: builtins.int
        SIGNAL_SMOOTHING_FIELD_NUMBER: builtins.int
        fast_length: builtins.int
        """Короткий период сглаживания для первой экспоненциальной скользящей средней (EMA)."""
        slow_length: builtins.int
        """Длинный период сглаживания для второй экспоненциальной скользящей средней (EMA)."""
        signal_smoothing: builtins.int
        """Период сглаживания для третьей экспоненциальной скользящей средней (EMA)"""
        def __init__(
            self,
            *,
            fast_length: builtins.int = ...,
            slow_length: builtins.int = ...,
            signal_smoothing: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["fast_length", b"fast_length", "signal_smoothing", b"signal_smoothing", "slow_length", b"slow_length"]) -> None: ...

    @typing.final
    class Deviation(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DEVIATION_MULTIPLIER_FIELD_NUMBER: builtins.int
        @property
        def deviation_multiplier(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Количество стандартных отклонений, на которые отступают верхняя и нижняя границы."""

        def __init__(
            self,
            *,
            deviation_multiplier: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["deviation_multiplier", b"deviation_multiplier"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["deviation_multiplier", b"deviation_multiplier"]) -> None: ...

    INDICATOR_TYPE_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    FROM_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    INTERVAL_FIELD_NUMBER: builtins.int
    TYPE_OF_PRICE_FIELD_NUMBER: builtins.int
    LENGTH_FIELD_NUMBER: builtins.int
    DEVIATION_FIELD_NUMBER: builtins.int
    SMOOTHING_FIELD_NUMBER: builtins.int
    indicator_type: global___GetTechAnalysisRequest.IndicatorType.ValueType
    """Тип технического индикатора."""
    instrument_uid: builtins.str
    """UID инструмента."""
    interval: global___GetTechAnalysisRequest.IndicatorInterval.ValueType
    """Интервал, за который рассчитывается индикатор."""
    type_of_price: global___GetTechAnalysisRequest.TypeOfPrice.ValueType
    """Тип цены, который используется при расчете индикатора."""
    length: builtins.int
    """Торговый период, за который рассчитывается индикатор."""
    @property
    def to(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Окончание запрашиваемого периода по UTC."""

    @property
    def deviation(self) -> global___GetTechAnalysisRequest.Deviation:
        """Параметры отклонения."""

    @property
    def smoothing(self) -> global___GetTechAnalysisRequest.Smoothing:
        """Параметры сглаживания."""

    def __init__(
        self,
        *,
        indicator_type: global___GetTechAnalysisRequest.IndicatorType.ValueType = ...,
        instrument_uid: builtins.str = ...,
        to: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        interval: global___GetTechAnalysisRequest.IndicatorInterval.ValueType = ...,
        type_of_price: global___GetTechAnalysisRequest.TypeOfPrice.ValueType = ...,
        length: builtins.int = ...,
        deviation: global___GetTechAnalysisRequest.Deviation | None = ...,
        smoothing: global___GetTechAnalysisRequest.Smoothing | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["deviation", b"deviation", "from", b"from", "smoothing", b"smoothing", "to", b"to"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["deviation", b"deviation", "from", b"from", "indicator_type", b"indicator_type", "instrument_uid", b"instrument_uid", "interval", b"interval", "length", b"length", "smoothing", b"smoothing", "to", b"to", "type_of_price", b"type_of_price"]) -> None: ...

global___GetTechAnalysisRequest = GetTechAnalysisRequest

@typing.final
class GetTechAnalysisResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class TechAnalysisItem(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TIMESTAMP_FIELD_NUMBER: builtins.int
        MIDDLE_BAND_FIELD_NUMBER: builtins.int
        UPPER_BAND_FIELD_NUMBER: builtins.int
        LOWER_BAND_FIELD_NUMBER: builtins.int
        SIGNAL_FIELD_NUMBER: builtins.int
        MACD_FIELD_NUMBER: builtins.int
        @property
        def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Временная метка по UTC, для которой были рассчитаны значения индикатора."""

        @property
        def middle_band(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Значение простого скользящего среднего (средней линии)."""

        @property
        def upper_band(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Значение верхней линии Боллинджера."""

        @property
        def lower_band(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Значение нижней линии Боллинджера."""

        @property
        def signal(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Значение сигнальной линии."""

        @property
        def macd(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Значение линии MACD."""

        def __init__(
            self,
            *,
            timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            middle_band: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            upper_band: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            lower_band: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            signal: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            macd: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["_lower_band", b"_lower_band", "_macd", b"_macd", "_middle_band", b"_middle_band", "_signal", b"_signal", "_upper_band", b"_upper_band", "lower_band", b"lower_band", "macd", b"macd", "middle_band", b"middle_band", "signal", b"signal", "timestamp", b"timestamp", "upper_band", b"upper_band"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["_lower_band", b"_lower_band", "_macd", b"_macd", "_middle_band", b"_middle_band", "_signal", b"_signal", "_upper_band", b"_upper_band", "lower_band", b"lower_band", "macd", b"macd", "middle_band", b"middle_band", "signal", b"signal", "timestamp", b"timestamp", "upper_band", b"upper_band"]) -> None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing.Literal["_lower_band", b"_lower_band"]) -> typing.Literal["lower_band"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing.Literal["_macd", b"_macd"]) -> typing.Literal["macd"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing.Literal["_middle_band", b"_middle_band"]) -> typing.Literal["middle_band"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing.Literal["_signal", b"_signal"]) -> typing.Literal["signal"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing.Literal["_upper_band", b"_upper_band"]) -> typing.Literal["upper_band"] | None: ...

    TECHNICAL_INDICATORS_FIELD_NUMBER: builtins.int
    @property
    def technical_indicators(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetTechAnalysisResponse.TechAnalysisItem]:
        """Массив значений результатов технического анализа."""

    def __init__(
        self,
        *,
        technical_indicators: collections.abc.Iterable[global___GetTechAnalysisResponse.TechAnalysisItem] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["technical_indicators", b"technical_indicators"]) -> None: ...

global___GetTechAnalysisResponse = GetTechAnalysisResponse

@typing.final
class GetMarketValuesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    VALUES_FIELD_NUMBER: builtins.int
    @property
    def instrument_id(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Массив идентификаторов инструментов. Принимает значения `figi`, `instrument_uid` или `ticker + '_' + class_code`."""

    @property
    def values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___MarketValueType.ValueType]:
        """Массив запрашиваемых параметров."""

    def __init__(
        self,
        *,
        instrument_id: collections.abc.Iterable[builtins.str] | None = ...,
        values: collections.abc.Iterable[global___MarketValueType.ValueType] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instrument_id", b"instrument_id", "values", b"values"]) -> None: ...

global___GetMarketValuesRequest = GetMarketValuesRequest

@typing.final
class GetMarketValuesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENTS_FIELD_NUMBER: builtins.int
    @property
    def instruments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MarketValueInstrument]:
        """Массив значений параметров."""

    def __init__(
        self,
        *,
        instruments: collections.abc.Iterable[global___MarketValueInstrument] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instruments", b"instruments"]) -> None: ...

global___GetMarketValuesResponse = GetMarketValuesResponse

@typing.final
class MarketValueInstrument(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    VALUES_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    instrument_uid: builtins.str
    """Идентификатор инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    @property
    def values(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MarketValue]:
        """Массив параметров инструмента."""

    def __init__(
        self,
        *,
        instrument_uid: builtins.str = ...,
        values: collections.abc.Iterable[global___MarketValue] | None = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["class_code", b"class_code", "instrument_uid", b"instrument_uid", "ticker", b"ticker", "values", b"values"]) -> None: ...

global___MarketValueInstrument = MarketValueInstrument

@typing.final
class MarketValue(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    type: global___MarketValueType.ValueType
    """Тип параметра."""
    @property
    def value(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Значение."""

    @property
    def time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата и время."""

    def __init__(
        self,
        *,
        type: global___MarketValueType.ValueType | None = ...,
        value: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_time", b"_time", "_type", b"_type", "_value", b"_value", "time", b"time", "type", b"type", "value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_time", b"_time", "_type", b"_type", "_value", b"_value", "time", b"time", "type", b"type", "value", b"value"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_time", b"_time"]) -> typing.Literal["time"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_type", b"_type"]) -> typing.Literal["type"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_value", b"_value"]) -> typing.Literal["value"] | None: ...

global___MarketValue = MarketValue
