"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import tinkoff.invest.grpc.common_pb2
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _OperationState:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _OperationStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_OperationState.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    OPERATION_STATE_UNSPECIFIED: _OperationState.ValueType  # 0
    """Статус операции не определен."""
    OPERATION_STATE_EXECUTED: _OperationState.ValueType  # 1
    """Исполнена частично или полностью."""
    OPERATION_STATE_CANCELED: _OperationState.ValueType  # 2
    """Отменена."""
    OPERATION_STATE_PROGRESS: _OperationState.ValueType  # 3
    """Исполняется."""

class OperationState(_OperationState, metaclass=_OperationStateEnumTypeWrapper):
    """Статус запрашиваемых операций."""

OPERATION_STATE_UNSPECIFIED: OperationState.ValueType  # 0
"""Статус операции не определен."""
OPERATION_STATE_EXECUTED: OperationState.ValueType  # 1
"""Исполнена частично или полностью."""
OPERATION_STATE_CANCELED: OperationState.ValueType  # 2
"""Отменена."""
OPERATION_STATE_PROGRESS: OperationState.ValueType  # 3
"""Исполняется."""
global___OperationState = OperationState

class _OperationType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _OperationTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_OperationType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    OPERATION_TYPE_UNSPECIFIED: _OperationType.ValueType  # 0
    """Тип операции не определен."""
    OPERATION_TYPE_INPUT: _OperationType.ValueType  # 1
    """Пополнение брокерского счета."""
    OPERATION_TYPE_BOND_TAX: _OperationType.ValueType  # 2
    """Удержание НДФЛ по купонам."""
    OPERATION_TYPE_OUTPUT_SECURITIES: _OperationType.ValueType  # 3
    """Вывод ЦБ."""
    OPERATION_TYPE_OVERNIGHT: _OperationType.ValueType  # 4
    """Доход по сделке РЕПО овернайт."""
    OPERATION_TYPE_TAX: _OperationType.ValueType  # 5
    """Удержание налога."""
    OPERATION_TYPE_BOND_REPAYMENT_FULL: _OperationType.ValueType  # 6
    """Полное погашение облигаций."""
    OPERATION_TYPE_SELL_CARD: _OperationType.ValueType  # 7
    """Продажа ЦБ с карты."""
    OPERATION_TYPE_DIVIDEND_TAX: _OperationType.ValueType  # 8
    """Удержание налога по дивидендам."""
    OPERATION_TYPE_OUTPUT: _OperationType.ValueType  # 9
    """Вывод денежных средств."""
    OPERATION_TYPE_BOND_REPAYMENT: _OperationType.ValueType  # 10
    """Частичное погашение облигаций."""
    OPERATION_TYPE_TAX_CORRECTION: _OperationType.ValueType  # 11
    """Корректировка налога."""
    OPERATION_TYPE_SERVICE_FEE: _OperationType.ValueType  # 12
    """Удержание комиссии за обслуживание брокерского счета."""
    OPERATION_TYPE_BENEFIT_TAX: _OperationType.ValueType  # 13
    """Удержание налога за материальную выгоду."""
    OPERATION_TYPE_MARGIN_FEE: _OperationType.ValueType  # 14
    """Удержание комиссии за непокрытую позицию."""
    OPERATION_TYPE_BUY: _OperationType.ValueType  # 15
    """Покупка ЦБ."""
    OPERATION_TYPE_BUY_CARD: _OperationType.ValueType  # 16
    """Покупка ЦБ с карты."""
    OPERATION_TYPE_INPUT_SECURITIES: _OperationType.ValueType  # 17
    """Перевод ценных бумаг из другого депозитария."""
    OPERATION_TYPE_SELL_MARGIN: _OperationType.ValueType  # 18
    """Продажа в результате Margin-call."""
    OPERATION_TYPE_BROKER_FEE: _OperationType.ValueType  # 19
    """Удержание комиссии за операцию."""
    OPERATION_TYPE_BUY_MARGIN: _OperationType.ValueType  # 20
    """Покупка в результате Margin-call."""
    OPERATION_TYPE_DIVIDEND: _OperationType.ValueType  # 21
    """Выплата дивидендов."""
    OPERATION_TYPE_SELL: _OperationType.ValueType  # 22
    """Продажа ЦБ."""
    OPERATION_TYPE_COUPON: _OperationType.ValueType  # 23
    """Выплата купонов."""
    OPERATION_TYPE_SUCCESS_FEE: _OperationType.ValueType  # 24
    """Удержание комиссии SuccessFee."""
    OPERATION_TYPE_DIVIDEND_TRANSFER: _OperationType.ValueType  # 25
    """Передача дивидендного дохода."""
    OPERATION_TYPE_ACCRUING_VARMARGIN: _OperationType.ValueType  # 26
    """Зачисление вариационной маржи."""
    OPERATION_TYPE_WRITING_OFF_VARMARGIN: _OperationType.ValueType  # 27
    """Списание вариационной маржи."""
    OPERATION_TYPE_DELIVERY_BUY: _OperationType.ValueType  # 28
    """Покупка в рамках экспирации фьючерсного контракта."""
    OPERATION_TYPE_DELIVERY_SELL: _OperationType.ValueType  # 29
    """Продажа в рамках экспирации фьючерсного контракта."""
    OPERATION_TYPE_TRACK_MFEE: _OperationType.ValueType  # 30
    """Комиссия за управление по счету автоследования."""
    OPERATION_TYPE_TRACK_PFEE: _OperationType.ValueType  # 31
    """Комиссия за результат по счету автоследования."""
    OPERATION_TYPE_TAX_PROGRESSIVE: _OperationType.ValueType  # 32
    """Удержание налога по ставке 15%."""
    OPERATION_TYPE_BOND_TAX_PROGRESSIVE: _OperationType.ValueType  # 33
    """Удержание налога по купонам по ставке 15%."""
    OPERATION_TYPE_DIVIDEND_TAX_PROGRESSIVE: _OperationType.ValueType  # 34
    """Удержание налога по дивидендам по ставке 15%."""
    OPERATION_TYPE_BENEFIT_TAX_PROGRESSIVE: _OperationType.ValueType  # 35
    """Удержание налога за материальную выгоду по ставке 15%."""
    OPERATION_TYPE_TAX_CORRECTION_PROGRESSIVE: _OperationType.ValueType  # 36
    """Корректировка налога по ставке 15%."""
    OPERATION_TYPE_TAX_REPO_PROGRESSIVE: _OperationType.ValueType  # 37
    """Удержание налога за возмещение по сделкам РЕПО по ставке 15%."""
    OPERATION_TYPE_TAX_REPO: _OperationType.ValueType  # 38
    """Удержание налога за возмещение по сделкам РЕПО."""
    OPERATION_TYPE_TAX_REPO_HOLD: _OperationType.ValueType  # 39
    """Удержание налога по сделкам РЕПО."""
    OPERATION_TYPE_TAX_REPO_REFUND: _OperationType.ValueType  # 40
    """Возврат налога по сделкам РЕПО."""
    OPERATION_TYPE_TAX_REPO_HOLD_PROGRESSIVE: _OperationType.ValueType  # 41
    """Удержание налога по сделкам РЕПО по ставке 15%."""
    OPERATION_TYPE_TAX_REPO_REFUND_PROGRESSIVE: _OperationType.ValueType  # 42
    """Возврат налога по сделкам РЕПО по ставке 15%."""
    OPERATION_TYPE_DIV_EXT: _OperationType.ValueType  # 43
    """Выплата дивидендов на карту."""
    OPERATION_TYPE_TAX_CORRECTION_COUPON: _OperationType.ValueType  # 44
    """Корректировка налога по купонам."""
    OPERATION_TYPE_CASH_FEE: _OperationType.ValueType  # 45
    """Комиссия за валютный остаток."""
    OPERATION_TYPE_OUT_FEE: _OperationType.ValueType  # 46
    """Комиссия за вывод валюты с брокерского счета."""
    OPERATION_TYPE_OUT_STAMP_DUTY: _OperationType.ValueType  # 47
    """Гербовый сбор."""
    OPERATION_TYPE_OUTPUT_SWIFT: _OperationType.ValueType  # 50
    """	SWIFT-перевод."""
    OPERATION_TYPE_INPUT_SWIFT: _OperationType.ValueType  # 51
    """	SWIFT-перевод."""
    OPERATION_TYPE_OUTPUT_ACQUIRING: _OperationType.ValueType  # 53
    """ Перевод на карту."""
    OPERATION_TYPE_INPUT_ACQUIRING: _OperationType.ValueType  # 54
    """	Перевод с карты."""
    OPERATION_TYPE_OUTPUT_PENALTY: _OperationType.ValueType  # 55
    """	Комиссия за вывод средств."""
    OPERATION_TYPE_ADVICE_FEE: _OperationType.ValueType  # 56
    """	Списание оплаты за сервис Советов."""
    OPERATION_TYPE_TRANS_IIS_BS: _OperationType.ValueType  # 57
    """ Перевод ценных бумаг с ИИС на брокерский счет."""
    OPERATION_TYPE_TRANS_BS_BS: _OperationType.ValueType  # 58
    """ Перевод ценных бумаг с одного брокерского счета на другой."""
    OPERATION_TYPE_OUT_MULTI: _OperationType.ValueType  # 59
    """ Вывод денежных средств со счета."""
    OPERATION_TYPE_INP_MULTI: _OperationType.ValueType  # 60
    """ Пополнение денежных средств со счета."""
    OPERATION_TYPE_OVER_PLACEMENT: _OperationType.ValueType  # 61
    """ Размещение биржевого овернайта."""
    OPERATION_TYPE_OVER_COM: _OperationType.ValueType  # 62
    """ Списание комиссии."""
    OPERATION_TYPE_OVER_INCOME: _OperationType.ValueType  # 63
    """ Доход от оверанайта."""
    OPERATION_TYPE_OPTION_EXPIRATION: _OperationType.ValueType  # 64
    """Экспирация опциона."""
    OPERATION_TYPE_FUTURE_EXPIRATION: _OperationType.ValueType  # 65
    """Экспирация фьючерса."""

class OperationType(_OperationType, metaclass=_OperationTypeEnumTypeWrapper):
    """Тип операции."""

OPERATION_TYPE_UNSPECIFIED: OperationType.ValueType  # 0
"""Тип операции не определен."""
OPERATION_TYPE_INPUT: OperationType.ValueType  # 1
"""Пополнение брокерского счета."""
OPERATION_TYPE_BOND_TAX: OperationType.ValueType  # 2
"""Удержание НДФЛ по купонам."""
OPERATION_TYPE_OUTPUT_SECURITIES: OperationType.ValueType  # 3
"""Вывод ЦБ."""
OPERATION_TYPE_OVERNIGHT: OperationType.ValueType  # 4
"""Доход по сделке РЕПО овернайт."""
OPERATION_TYPE_TAX: OperationType.ValueType  # 5
"""Удержание налога."""
OPERATION_TYPE_BOND_REPAYMENT_FULL: OperationType.ValueType  # 6
"""Полное погашение облигаций."""
OPERATION_TYPE_SELL_CARD: OperationType.ValueType  # 7
"""Продажа ЦБ с карты."""
OPERATION_TYPE_DIVIDEND_TAX: OperationType.ValueType  # 8
"""Удержание налога по дивидендам."""
OPERATION_TYPE_OUTPUT: OperationType.ValueType  # 9
"""Вывод денежных средств."""
OPERATION_TYPE_BOND_REPAYMENT: OperationType.ValueType  # 10
"""Частичное погашение облигаций."""
OPERATION_TYPE_TAX_CORRECTION: OperationType.ValueType  # 11
"""Корректировка налога."""
OPERATION_TYPE_SERVICE_FEE: OperationType.ValueType  # 12
"""Удержание комиссии за обслуживание брокерского счета."""
OPERATION_TYPE_BENEFIT_TAX: OperationType.ValueType  # 13
"""Удержание налога за материальную выгоду."""
OPERATION_TYPE_MARGIN_FEE: OperationType.ValueType  # 14
"""Удержание комиссии за непокрытую позицию."""
OPERATION_TYPE_BUY: OperationType.ValueType  # 15
"""Покупка ЦБ."""
OPERATION_TYPE_BUY_CARD: OperationType.ValueType  # 16
"""Покупка ЦБ с карты."""
OPERATION_TYPE_INPUT_SECURITIES: OperationType.ValueType  # 17
"""Перевод ценных бумаг из другого депозитария."""
OPERATION_TYPE_SELL_MARGIN: OperationType.ValueType  # 18
"""Продажа в результате Margin-call."""
OPERATION_TYPE_BROKER_FEE: OperationType.ValueType  # 19
"""Удержание комиссии за операцию."""
OPERATION_TYPE_BUY_MARGIN: OperationType.ValueType  # 20
"""Покупка в результате Margin-call."""
OPERATION_TYPE_DIVIDEND: OperationType.ValueType  # 21
"""Выплата дивидендов."""
OPERATION_TYPE_SELL: OperationType.ValueType  # 22
"""Продажа ЦБ."""
OPERATION_TYPE_COUPON: OperationType.ValueType  # 23
"""Выплата купонов."""
OPERATION_TYPE_SUCCESS_FEE: OperationType.ValueType  # 24
"""Удержание комиссии SuccessFee."""
OPERATION_TYPE_DIVIDEND_TRANSFER: OperationType.ValueType  # 25
"""Передача дивидендного дохода."""
OPERATION_TYPE_ACCRUING_VARMARGIN: OperationType.ValueType  # 26
"""Зачисление вариационной маржи."""
OPERATION_TYPE_WRITING_OFF_VARMARGIN: OperationType.ValueType  # 27
"""Списание вариационной маржи."""
OPERATION_TYPE_DELIVERY_BUY: OperationType.ValueType  # 28
"""Покупка в рамках экспирации фьючерсного контракта."""
OPERATION_TYPE_DELIVERY_SELL: OperationType.ValueType  # 29
"""Продажа в рамках экспирации фьючерсного контракта."""
OPERATION_TYPE_TRACK_MFEE: OperationType.ValueType  # 30
"""Комиссия за управление по счету автоследования."""
OPERATION_TYPE_TRACK_PFEE: OperationType.ValueType  # 31
"""Комиссия за результат по счету автоследования."""
OPERATION_TYPE_TAX_PROGRESSIVE: OperationType.ValueType  # 32
"""Удержание налога по ставке 15%."""
OPERATION_TYPE_BOND_TAX_PROGRESSIVE: OperationType.ValueType  # 33
"""Удержание налога по купонам по ставке 15%."""
OPERATION_TYPE_DIVIDEND_TAX_PROGRESSIVE: OperationType.ValueType  # 34
"""Удержание налога по дивидендам по ставке 15%."""
OPERATION_TYPE_BENEFIT_TAX_PROGRESSIVE: OperationType.ValueType  # 35
"""Удержание налога за материальную выгоду по ставке 15%."""
OPERATION_TYPE_TAX_CORRECTION_PROGRESSIVE: OperationType.ValueType  # 36
"""Корректировка налога по ставке 15%."""
OPERATION_TYPE_TAX_REPO_PROGRESSIVE: OperationType.ValueType  # 37
"""Удержание налога за возмещение по сделкам РЕПО по ставке 15%."""
OPERATION_TYPE_TAX_REPO: OperationType.ValueType  # 38
"""Удержание налога за возмещение по сделкам РЕПО."""
OPERATION_TYPE_TAX_REPO_HOLD: OperationType.ValueType  # 39
"""Удержание налога по сделкам РЕПО."""
OPERATION_TYPE_TAX_REPO_REFUND: OperationType.ValueType  # 40
"""Возврат налога по сделкам РЕПО."""
OPERATION_TYPE_TAX_REPO_HOLD_PROGRESSIVE: OperationType.ValueType  # 41
"""Удержание налога по сделкам РЕПО по ставке 15%."""
OPERATION_TYPE_TAX_REPO_REFUND_PROGRESSIVE: OperationType.ValueType  # 42
"""Возврат налога по сделкам РЕПО по ставке 15%."""
OPERATION_TYPE_DIV_EXT: OperationType.ValueType  # 43
"""Выплата дивидендов на карту."""
OPERATION_TYPE_TAX_CORRECTION_COUPON: OperationType.ValueType  # 44
"""Корректировка налога по купонам."""
OPERATION_TYPE_CASH_FEE: OperationType.ValueType  # 45
"""Комиссия за валютный остаток."""
OPERATION_TYPE_OUT_FEE: OperationType.ValueType  # 46
"""Комиссия за вывод валюты с брокерского счета."""
OPERATION_TYPE_OUT_STAMP_DUTY: OperationType.ValueType  # 47
"""Гербовый сбор."""
OPERATION_TYPE_OUTPUT_SWIFT: OperationType.ValueType  # 50
"""	SWIFT-перевод."""
OPERATION_TYPE_INPUT_SWIFT: OperationType.ValueType  # 51
"""	SWIFT-перевод."""
OPERATION_TYPE_OUTPUT_ACQUIRING: OperationType.ValueType  # 53
""" Перевод на карту."""
OPERATION_TYPE_INPUT_ACQUIRING: OperationType.ValueType  # 54
"""	Перевод с карты."""
OPERATION_TYPE_OUTPUT_PENALTY: OperationType.ValueType  # 55
"""	Комиссия за вывод средств."""
OPERATION_TYPE_ADVICE_FEE: OperationType.ValueType  # 56
"""	Списание оплаты за сервис Советов."""
OPERATION_TYPE_TRANS_IIS_BS: OperationType.ValueType  # 57
""" Перевод ценных бумаг с ИИС на брокерский счет."""
OPERATION_TYPE_TRANS_BS_BS: OperationType.ValueType  # 58
""" Перевод ценных бумаг с одного брокерского счета на другой."""
OPERATION_TYPE_OUT_MULTI: OperationType.ValueType  # 59
""" Вывод денежных средств со счета."""
OPERATION_TYPE_INP_MULTI: OperationType.ValueType  # 60
""" Пополнение денежных средств со счета."""
OPERATION_TYPE_OVER_PLACEMENT: OperationType.ValueType  # 61
""" Размещение биржевого овернайта."""
OPERATION_TYPE_OVER_COM: OperationType.ValueType  # 62
""" Списание комиссии."""
OPERATION_TYPE_OVER_INCOME: OperationType.ValueType  # 63
""" Доход от оверанайта."""
OPERATION_TYPE_OPTION_EXPIRATION: OperationType.ValueType  # 64
"""Экспирация опциона."""
OPERATION_TYPE_FUTURE_EXPIRATION: OperationType.ValueType  # 65
"""Экспирация фьючерса."""
global___OperationType = OperationType

class _PortfolioSubscriptionStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PortfolioSubscriptionStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PortfolioSubscriptionStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PORTFOLIO_SUBSCRIPTION_STATUS_UNSPECIFIED: _PortfolioSubscriptionStatus.ValueType  # 0
    """Тип не определен."""
    PORTFOLIO_SUBSCRIPTION_STATUS_SUCCESS: _PortfolioSubscriptionStatus.ValueType  # 1
    """Успешно."""
    PORTFOLIO_SUBSCRIPTION_STATUS_ACCOUNT_NOT_FOUND: _PortfolioSubscriptionStatus.ValueType  # 2
    """Счет не найден или недостаточно прав."""
    PORTFOLIO_SUBSCRIPTION_STATUS_INTERNAL_ERROR: _PortfolioSubscriptionStatus.ValueType  # 3
    """Произошла ошибка."""

class PortfolioSubscriptionStatus(_PortfolioSubscriptionStatus, metaclass=_PortfolioSubscriptionStatusEnumTypeWrapper):
    """Результат подписки."""

PORTFOLIO_SUBSCRIPTION_STATUS_UNSPECIFIED: PortfolioSubscriptionStatus.ValueType  # 0
"""Тип не определен."""
PORTFOLIO_SUBSCRIPTION_STATUS_SUCCESS: PortfolioSubscriptionStatus.ValueType  # 1
"""Успешно."""
PORTFOLIO_SUBSCRIPTION_STATUS_ACCOUNT_NOT_FOUND: PortfolioSubscriptionStatus.ValueType  # 2
"""Счет не найден или недостаточно прав."""
PORTFOLIO_SUBSCRIPTION_STATUS_INTERNAL_ERROR: PortfolioSubscriptionStatus.ValueType  # 3
"""Произошла ошибка."""
global___PortfolioSubscriptionStatus = PortfolioSubscriptionStatus

class _PositionsAccountSubscriptionStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PositionsAccountSubscriptionStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PositionsAccountSubscriptionStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    POSITIONS_SUBSCRIPTION_STATUS_UNSPECIFIED: _PositionsAccountSubscriptionStatus.ValueType  # 0
    """Тип не определен."""
    POSITIONS_SUBSCRIPTION_STATUS_SUCCESS: _PositionsAccountSubscriptionStatus.ValueType  # 1
    """Успешно."""
    POSITIONS_SUBSCRIPTION_STATUS_ACCOUNT_NOT_FOUND: _PositionsAccountSubscriptionStatus.ValueType  # 2
    """Счет не найден или недостаточно прав."""
    POSITIONS_SUBSCRIPTION_STATUS_INTERNAL_ERROR: _PositionsAccountSubscriptionStatus.ValueType  # 3
    """Произошла ошибка."""

class PositionsAccountSubscriptionStatus(_PositionsAccountSubscriptionStatus, metaclass=_PositionsAccountSubscriptionStatusEnumTypeWrapper):
    """Результат подписки."""

POSITIONS_SUBSCRIPTION_STATUS_UNSPECIFIED: PositionsAccountSubscriptionStatus.ValueType  # 0
"""Тип не определен."""
POSITIONS_SUBSCRIPTION_STATUS_SUCCESS: PositionsAccountSubscriptionStatus.ValueType  # 1
"""Успешно."""
POSITIONS_SUBSCRIPTION_STATUS_ACCOUNT_NOT_FOUND: PositionsAccountSubscriptionStatus.ValueType  # 2
"""Счет не найден или недостаточно прав."""
POSITIONS_SUBSCRIPTION_STATUS_INTERNAL_ERROR: PositionsAccountSubscriptionStatus.ValueType  # 3
"""Произошла ошибка."""
global___PositionsAccountSubscriptionStatus = PositionsAccountSubscriptionStatus

@typing.final
class OperationsRequest(google.protobuf.message.Message):
    """Запрос получения списка операций по счету."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    FROM_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    FIGI_FIELD_NUMBER: builtins.int
    account_id: builtins.str
    """Идентификатор счета клиента."""
    state: global___OperationState.ValueType
    """Статус запрашиваемых операций."""
    figi: builtins.str
    """FIGI-идентификатор инструмента для фильтрации."""
    @property
    def to(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Окончание периода по UTC."""

    def __init__(
        self,
        *,
        account_id: builtins.str = ...,
        to: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        state: global___OperationState.ValueType | None = ...,
        figi: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_figi", b"_figi", "_from", b"_from", "_state", b"_state", "_to", b"_to", "figi", b"figi", "from", b"from", "state", b"state", "to", b"to"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_figi", b"_figi", "_from", b"_from", "_state", b"_state", "_to", b"_to", "account_id", b"account_id", "figi", b"figi", "from", b"from", "state", b"state", "to", b"to"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_figi", b"_figi"]) -> typing.Literal["figi"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_from", b"_from"]) -> typing.Literal["from"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_state", b"_state"]) -> typing.Literal["state"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_to", b"_to"]) -> typing.Literal["to"] | None: ...

global___OperationsRequest = OperationsRequest

@typing.final
class OperationsResponse(google.protobuf.message.Message):
    """Список операций."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Operation]:
        """Массив операций."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[global___Operation] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["operations", b"operations"]) -> None: ...

global___OperationsResponse = OperationsResponse

@typing.final
class Operation(google.protobuf.message.Message):
    """Данные по операции."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    PARENT_OPERATION_ID_FIELD_NUMBER: builtins.int
    CURRENCY_FIELD_NUMBER: builtins.int
    PAYMENT_FIELD_NUMBER: builtins.int
    PRICE_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    QUANTITY_REST_FIELD_NUMBER: builtins.int
    FIGI_FIELD_NUMBER: builtins.int
    INSTRUMENT_TYPE_FIELD_NUMBER: builtins.int
    DATE_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    OPERATION_TYPE_FIELD_NUMBER: builtins.int
    TRADES_FIELD_NUMBER: builtins.int
    ASSET_UID_FIELD_NUMBER: builtins.int
    POSITION_UID_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    CHILD_OPERATIONS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Идентификатор операции."""
    parent_operation_id: builtins.str
    """Идентификатор родительской операции."""
    currency: builtins.str
    """Валюта операции."""
    state: global___OperationState.ValueType
    """Статус операции."""
    quantity: builtins.int
    """Количество единиц инструмента."""
    quantity_rest: builtins.int
    """Неисполненный остаток по сделке."""
    figi: builtins.str
    """FIGI-идентификатор инструмента, связанного с операцией."""
    instrument_type: builtins.str
    """Тип инструмента. Возможные значения: <br/><br/>`bond` — облигация; <br/>`share` — акция; <br/>`currency` — валюта; <br/>`etf` — фонд; <br/>`futures` — фьючерс."""
    type: builtins.str
    """Текстовое описание типа операции."""
    operation_type: global___OperationType.ValueType
    """Тип операции."""
    asset_uid: builtins.str
    """Идентификатор актива"""
    position_uid: builtins.str
    """Уникальный идентификатор позиции."""
    instrument_uid: builtins.str
    """Уникальный идентификатор инструмента."""
    @property
    def payment(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Сумма операции."""

    @property
    def price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Цена операции за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента."""

    @property
    def date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата и время операции в формате часовом поясе UTC."""

    @property
    def trades(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OperationTrade]:
        """Массив сделок."""

    @property
    def child_operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChildOperationItem]:
        """Массив дочерних операций."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        parent_operation_id: builtins.str = ...,
        currency: builtins.str = ...,
        payment: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        state: global___OperationState.ValueType = ...,
        quantity: builtins.int = ...,
        quantity_rest: builtins.int = ...,
        figi: builtins.str = ...,
        instrument_type: builtins.str = ...,
        date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        type: builtins.str = ...,
        operation_type: global___OperationType.ValueType = ...,
        trades: collections.abc.Iterable[global___OperationTrade] | None = ...,
        asset_uid: builtins.str = ...,
        position_uid: builtins.str = ...,
        instrument_uid: builtins.str = ...,
        child_operations: collections.abc.Iterable[global___ChildOperationItem] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["date", b"date", "payment", b"payment", "price", b"price"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["asset_uid", b"asset_uid", "child_operations", b"child_operations", "currency", b"currency", "date", b"date", "figi", b"figi", "id", b"id", "instrument_type", b"instrument_type", "instrument_uid", b"instrument_uid", "operation_type", b"operation_type", "parent_operation_id", b"parent_operation_id", "payment", b"payment", "position_uid", b"position_uid", "price", b"price", "quantity", b"quantity", "quantity_rest", b"quantity_rest", "state", b"state", "trades", b"trades", "type", b"type"]) -> None: ...

global___Operation = Operation

@typing.final
class OperationTrade(google.protobuf.message.Message):
    """Сделка по операции."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRADE_ID_FIELD_NUMBER: builtins.int
    DATE_TIME_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    PRICE_FIELD_NUMBER: builtins.int
    trade_id: builtins.str
    """Идентификатор сделки."""
    quantity: builtins.int
    """Количество инструментов."""
    @property
    def date_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата и время сделки по UTC."""

    @property
    def price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Цена за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента."""

    def __init__(
        self,
        *,
        trade_id: builtins.str = ...,
        date_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        quantity: builtins.int = ...,
        price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["date_time", b"date_time", "price", b"price"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["date_time", b"date_time", "price", b"price", "quantity", b"quantity", "trade_id", b"trade_id"]) -> None: ...

global___OperationTrade = OperationTrade

@typing.final
class PortfolioRequest(google.protobuf.message.Message):
    """Запрос получения текущего портфеля по счету."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _CurrencyRequest:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _CurrencyRequestEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PortfolioRequest._CurrencyRequest.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        RUB: PortfolioRequest._CurrencyRequest.ValueType  # 0
        """Рубли"""
        USD: PortfolioRequest._CurrencyRequest.ValueType  # 1
        """Доллары"""
        EUR: PortfolioRequest._CurrencyRequest.ValueType  # 2
        """Евро"""

    class CurrencyRequest(_CurrencyRequest, metaclass=_CurrencyRequestEnumTypeWrapper): ...
    RUB: PortfolioRequest.CurrencyRequest.ValueType  # 0
    """Рубли"""
    USD: PortfolioRequest.CurrencyRequest.ValueType  # 1
    """Доллары"""
    EUR: PortfolioRequest.CurrencyRequest.ValueType  # 2
    """Евро"""

    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    CURRENCY_FIELD_NUMBER: builtins.int
    account_id: builtins.str
    """Идентификатор счета пользователя."""
    currency: global___PortfolioRequest.CurrencyRequest.ValueType
    """Валюта, в которой нужно рассчитать портфель."""
    def __init__(
        self,
        *,
        account_id: builtins.str = ...,
        currency: global___PortfolioRequest.CurrencyRequest.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_currency", b"_currency", "currency", b"currency"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_currency", b"_currency", "account_id", b"account_id", "currency", b"currency"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_currency", b"_currency"]) -> typing.Literal["currency"] | None: ...

global___PortfolioRequest = PortfolioRequest

@typing.final
class PortfolioResponse(google.protobuf.message.Message):
    """Текущий портфель по счету."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOTAL_AMOUNT_SHARES_FIELD_NUMBER: builtins.int
    TOTAL_AMOUNT_BONDS_FIELD_NUMBER: builtins.int
    TOTAL_AMOUNT_ETF_FIELD_NUMBER: builtins.int
    TOTAL_AMOUNT_CURRENCIES_FIELD_NUMBER: builtins.int
    TOTAL_AMOUNT_FUTURES_FIELD_NUMBER: builtins.int
    EXPECTED_YIELD_FIELD_NUMBER: builtins.int
    POSITIONS_FIELD_NUMBER: builtins.int
    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    TOTAL_AMOUNT_OPTIONS_FIELD_NUMBER: builtins.int
    TOTAL_AMOUNT_SP_FIELD_NUMBER: builtins.int
    TOTAL_AMOUNT_PORTFOLIO_FIELD_NUMBER: builtins.int
    VIRTUAL_POSITIONS_FIELD_NUMBER: builtins.int
    DAILY_YIELD_FIELD_NUMBER: builtins.int
    DAILY_YIELD_RELATIVE_FIELD_NUMBER: builtins.int
    account_id: builtins.str
    """Идентификатор счета пользователя."""
    @property
    def total_amount_shares(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Общая стоимость акций в портфеле."""

    @property
    def total_amount_bonds(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Общая стоимость облигаций в портфеле."""

    @property
    def total_amount_etf(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Общая стоимость фондов в портфеле."""

    @property
    def total_amount_currencies(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Общая стоимость валют в портфеле."""

    @property
    def total_amount_futures(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Общая стоимость фьючерсов в портфеле."""

    @property
    def expected_yield(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Текущая относительная доходность портфеля в %."""

    @property
    def positions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PortfolioPosition]:
        """Список позиций портфеля."""

    @property
    def total_amount_options(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Общая стоимость опционов в портфеле."""

    @property
    def total_amount_sp(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Общая стоимость структурных нот в портфеле."""

    @property
    def total_amount_portfolio(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Общая стоимость портфеля."""

    @property
    def virtual_positions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___VirtualPortfolioPosition]:
        """Массив виртуальных позиций портфеля."""

    @property
    def daily_yield(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Рассчитанная доходность портфеля за день в рублях."""

    @property
    def daily_yield_relative(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Относительная доходность в день в %."""

    def __init__(
        self,
        *,
        total_amount_shares: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        total_amount_bonds: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        total_amount_etf: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        total_amount_currencies: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        total_amount_futures: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        expected_yield: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        positions: collections.abc.Iterable[global___PortfolioPosition] | None = ...,
        account_id: builtins.str = ...,
        total_amount_options: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        total_amount_sp: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        total_amount_portfolio: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        virtual_positions: collections.abc.Iterable[global___VirtualPortfolioPosition] | None = ...,
        daily_yield: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        daily_yield_relative: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["daily_yield", b"daily_yield", "daily_yield_relative", b"daily_yield_relative", "expected_yield", b"expected_yield", "total_amount_bonds", b"total_amount_bonds", "total_amount_currencies", b"total_amount_currencies", "total_amount_etf", b"total_amount_etf", "total_amount_futures", b"total_amount_futures", "total_amount_options", b"total_amount_options", "total_amount_portfolio", b"total_amount_portfolio", "total_amount_shares", b"total_amount_shares", "total_amount_sp", b"total_amount_sp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["account_id", b"account_id", "daily_yield", b"daily_yield", "daily_yield_relative", b"daily_yield_relative", "expected_yield", b"expected_yield", "positions", b"positions", "total_amount_bonds", b"total_amount_bonds", "total_amount_currencies", b"total_amount_currencies", "total_amount_etf", b"total_amount_etf", "total_amount_futures", b"total_amount_futures", "total_amount_options", b"total_amount_options", "total_amount_portfolio", b"total_amount_portfolio", "total_amount_shares", b"total_amount_shares", "total_amount_sp", b"total_amount_sp", "virtual_positions", b"virtual_positions"]) -> None: ...

global___PortfolioResponse = PortfolioResponse

@typing.final
class PositionsRequest(google.protobuf.message.Message):
    """Запрос позиций портфеля по счету."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    account_id: builtins.str
    """Идентификатор счета пользователя."""
    def __init__(
        self,
        *,
        account_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["account_id", b"account_id"]) -> None: ...

global___PositionsRequest = PositionsRequest

@typing.final
class PositionsResponse(google.protobuf.message.Message):
    """Список позиций по счету."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MONEY_FIELD_NUMBER: builtins.int
    BLOCKED_FIELD_NUMBER: builtins.int
    SECURITIES_FIELD_NUMBER: builtins.int
    LIMITS_LOADING_IN_PROGRESS_FIELD_NUMBER: builtins.int
    FUTURES_FIELD_NUMBER: builtins.int
    OPTIONS_FIELD_NUMBER: builtins.int
    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    limits_loading_in_progress: builtins.bool
    """Признак идущей выгрузки лимитов в данный момент."""
    account_id: builtins.str
    """Идентификатор счёта пользователя."""
    @property
    def money(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[tinkoff.invest.grpc.common_pb2.MoneyValue]:
        """Массив валютных позиций портфеля."""

    @property
    def blocked(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[tinkoff.invest.grpc.common_pb2.MoneyValue]:
        """Массив заблокированных валютных позиций портфеля."""

    @property
    def securities(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PositionsSecurities]:
        """Список ценно-бумажных позиций портфеля."""

    @property
    def futures(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PositionsFutures]:
        """Список фьючерсов портфеля."""

    @property
    def options(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PositionsOptions]:
        """Список опционов портфеля."""

    def __init__(
        self,
        *,
        money: collections.abc.Iterable[tinkoff.invest.grpc.common_pb2.MoneyValue] | None = ...,
        blocked: collections.abc.Iterable[tinkoff.invest.grpc.common_pb2.MoneyValue] | None = ...,
        securities: collections.abc.Iterable[global___PositionsSecurities] | None = ...,
        limits_loading_in_progress: builtins.bool = ...,
        futures: collections.abc.Iterable[global___PositionsFutures] | None = ...,
        options: collections.abc.Iterable[global___PositionsOptions] | None = ...,
        account_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["account_id", b"account_id", "blocked", b"blocked", "futures", b"futures", "limits_loading_in_progress", b"limits_loading_in_progress", "money", b"money", "options", b"options", "securities", b"securities"]) -> None: ...

global___PositionsResponse = PositionsResponse

@typing.final
class WithdrawLimitsRequest(google.protobuf.message.Message):
    """Запрос доступного остатка для вывода."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    account_id: builtins.str
    """Идентификатор счета пользователя."""
    def __init__(
        self,
        *,
        account_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["account_id", b"account_id"]) -> None: ...

global___WithdrawLimitsRequest = WithdrawLimitsRequest

@typing.final
class WithdrawLimitsResponse(google.protobuf.message.Message):
    """Доступный остаток для вывода."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MONEY_FIELD_NUMBER: builtins.int
    BLOCKED_FIELD_NUMBER: builtins.int
    BLOCKED_GUARANTEE_FIELD_NUMBER: builtins.int
    @property
    def money(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[tinkoff.invest.grpc.common_pb2.MoneyValue]:
        """Массив валютных позиций портфеля."""

    @property
    def blocked(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[tinkoff.invest.grpc.common_pb2.MoneyValue]:
        """Массив заблокированных валютных позиций портфеля."""

    @property
    def blocked_guarantee(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[tinkoff.invest.grpc.common_pb2.MoneyValue]:
        """Заблокировано под гарантийное обеспечение фьючерсов."""

    def __init__(
        self,
        *,
        money: collections.abc.Iterable[tinkoff.invest.grpc.common_pb2.MoneyValue] | None = ...,
        blocked: collections.abc.Iterable[tinkoff.invest.grpc.common_pb2.MoneyValue] | None = ...,
        blocked_guarantee: collections.abc.Iterable[tinkoff.invest.grpc.common_pb2.MoneyValue] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["blocked", b"blocked", "blocked_guarantee", b"blocked_guarantee", "money", b"money"]) -> None: ...

global___WithdrawLimitsResponse = WithdrawLimitsResponse

@typing.final
class PortfolioPosition(google.protobuf.message.Message):
    """Позиции портфеля."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    INSTRUMENT_TYPE_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    AVERAGE_POSITION_PRICE_FIELD_NUMBER: builtins.int
    EXPECTED_YIELD_FIELD_NUMBER: builtins.int
    CURRENT_NKD_FIELD_NUMBER: builtins.int
    AVERAGE_POSITION_PRICE_PT_FIELD_NUMBER: builtins.int
    CURRENT_PRICE_FIELD_NUMBER: builtins.int
    AVERAGE_POSITION_PRICE_FIFO_FIELD_NUMBER: builtins.int
    QUANTITY_LOTS_FIELD_NUMBER: builtins.int
    BLOCKED_FIELD_NUMBER: builtins.int
    BLOCKED_LOTS_FIELD_NUMBER: builtins.int
    POSITION_UID_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    VAR_MARGIN_FIELD_NUMBER: builtins.int
    EXPECTED_YIELD_FIFO_FIELD_NUMBER: builtins.int
    DAILY_YIELD_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    instrument_type: builtins.str
    """Тип инструмента."""
    blocked: builtins.bool
    """Заблокировано на бирже."""
    position_uid: builtins.str
    """Уникальный идентификатор позиции."""
    instrument_uid: builtins.str
    """Уникальный идентификатор инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    @property
    def quantity(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Количество инструмента в портфеле в штуках."""

    @property
    def average_position_price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Средневзвешенная цена позиции. Для пересчета возможна задержка до одной секунды."""

    @property
    def expected_yield(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Текущая рассчитанная доходность позиции."""

    @property
    def current_nkd(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Текущий НКД."""

    @property
    def average_position_price_pt(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Deprecated Средняя цена позиции в пунктах (для фьючерсов). Для пересчета возможна задержка до одной секунды."""

    @property
    def current_price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Текущая цена за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента."""

    @property
    def average_position_price_fifo(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Средняя цена позиции по методу FIFO. Для пересчета возможна задержка до одной секунды."""

    @property
    def quantity_lots(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Deprecated Количество лотов в портфеле."""

    @property
    def blocked_lots(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Количество бумаг, заблокированных выставленными заявками."""

    @property
    def var_margin(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Вариационная маржа."""

    @property
    def expected_yield_fifo(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Текущая рассчитанная доходность позиции."""

    @property
    def daily_yield(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Рассчитанная доходность портфеля за день."""

    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        instrument_type: builtins.str = ...,
        quantity: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        average_position_price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        expected_yield: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        current_nkd: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        average_position_price_pt: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        current_price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        average_position_price_fifo: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        quantity_lots: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        blocked: builtins.bool = ...,
        blocked_lots: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        position_uid: builtins.str = ...,
        instrument_uid: builtins.str = ...,
        var_margin: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        expected_yield_fifo: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        daily_yield: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["average_position_price", b"average_position_price", "average_position_price_fifo", b"average_position_price_fifo", "average_position_price_pt", b"average_position_price_pt", "blocked_lots", b"blocked_lots", "current_nkd", b"current_nkd", "current_price", b"current_price", "daily_yield", b"daily_yield", "expected_yield", b"expected_yield", "expected_yield_fifo", b"expected_yield_fifo", "quantity", b"quantity", "quantity_lots", b"quantity_lots", "var_margin", b"var_margin"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["average_position_price", b"average_position_price", "average_position_price_fifo", b"average_position_price_fifo", "average_position_price_pt", b"average_position_price_pt", "blocked", b"blocked", "blocked_lots", b"blocked_lots", "class_code", b"class_code", "current_nkd", b"current_nkd", "current_price", b"current_price", "daily_yield", b"daily_yield", "expected_yield", b"expected_yield", "expected_yield_fifo", b"expected_yield_fifo", "figi", b"figi", "instrument_type", b"instrument_type", "instrument_uid", b"instrument_uid", "position_uid", b"position_uid", "quantity", b"quantity", "quantity_lots", b"quantity_lots", "ticker", b"ticker", "var_margin", b"var_margin"]) -> None: ...

global___PortfolioPosition = PortfolioPosition

@typing.final
class VirtualPortfolioPosition(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POSITION_UID_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    FIGI_FIELD_NUMBER: builtins.int
    INSTRUMENT_TYPE_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    AVERAGE_POSITION_PRICE_FIELD_NUMBER: builtins.int
    EXPECTED_YIELD_FIELD_NUMBER: builtins.int
    EXPECTED_YIELD_FIFO_FIELD_NUMBER: builtins.int
    EXPIRE_DATE_FIELD_NUMBER: builtins.int
    CURRENT_PRICE_FIELD_NUMBER: builtins.int
    AVERAGE_POSITION_PRICE_FIFO_FIELD_NUMBER: builtins.int
    DAILY_YIELD_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    position_uid: builtins.str
    """Уникальный идентификатор позиции."""
    instrument_uid: builtins.str
    """Уникальный идентификатор инструмента."""
    figi: builtins.str
    """FIGI-идентификатор инструмента."""
    instrument_type: builtins.str
    """Тип инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    @property
    def quantity(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Количество инструмента в портфеле в штуках."""

    @property
    def average_position_price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Средневзвешенная цена позиции. Для пересчета возможна задержка до одной секунды."""

    @property
    def expected_yield(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Текущая рассчитанная доходность позиции."""

    @property
    def expected_yield_fifo(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Текущая рассчитанная доходность позиции."""

    @property
    def expire_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата, до которой нужно продать виртуальные бумаги. После этой даты виртуальная позиция «сгораетт»."""

    @property
    def current_price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Текущая цена за 1 инструмент. Чтобы получить стоимость лота, нужно умножить на лотность инструмента."""

    @property
    def average_position_price_fifo(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Средняя цена позиции по методу FIFO. Для пересчета возможна задержка до одной секунды."""

    @property
    def daily_yield(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Рассчитанная доходность портфеля за день."""

    def __init__(
        self,
        *,
        position_uid: builtins.str = ...,
        instrument_uid: builtins.str = ...,
        figi: builtins.str = ...,
        instrument_type: builtins.str = ...,
        quantity: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        average_position_price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        expected_yield: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        expected_yield_fifo: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        expire_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        current_price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        average_position_price_fifo: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        daily_yield: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["average_position_price", b"average_position_price", "average_position_price_fifo", b"average_position_price_fifo", "current_price", b"current_price", "daily_yield", b"daily_yield", "expected_yield", b"expected_yield", "expected_yield_fifo", b"expected_yield_fifo", "expire_date", b"expire_date", "quantity", b"quantity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["average_position_price", b"average_position_price", "average_position_price_fifo", b"average_position_price_fifo", "class_code", b"class_code", "current_price", b"current_price", "daily_yield", b"daily_yield", "expected_yield", b"expected_yield", "expected_yield_fifo", b"expected_yield_fifo", "expire_date", b"expire_date", "figi", b"figi", "instrument_type", b"instrument_type", "instrument_uid", b"instrument_uid", "position_uid", b"position_uid", "quantity", b"quantity", "ticker", b"ticker"]) -> None: ...

global___VirtualPortfolioPosition = VirtualPortfolioPosition

@typing.final
class PositionsSecurities(google.protobuf.message.Message):
    """Баланс позиции ценной бумаги."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    BLOCKED_FIELD_NUMBER: builtins.int
    BALANCE_FIELD_NUMBER: builtins.int
    POSITION_UID_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    EXCHANGE_BLOCKED_FIELD_NUMBER: builtins.int
    INSTRUMENT_TYPE_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор бумаги."""
    blocked: builtins.int
    """Количество бумаг, заблокированных выставленными заявками."""
    balance: builtins.int
    """Текущий незаблокированный баланс."""
    position_uid: builtins.str
    """Уникальный идентификатор позиции."""
    instrument_uid: builtins.str
    """Уникальный идентификатор инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    exchange_blocked: builtins.bool
    """Заблокировано на бирже."""
    instrument_type: builtins.str
    """Тип инструмента."""
    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        blocked: builtins.int = ...,
        balance: builtins.int = ...,
        position_uid: builtins.str = ...,
        instrument_uid: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        exchange_blocked: builtins.bool = ...,
        instrument_type: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["balance", b"balance", "blocked", b"blocked", "class_code", b"class_code", "exchange_blocked", b"exchange_blocked", "figi", b"figi", "instrument_type", b"instrument_type", "instrument_uid", b"instrument_uid", "position_uid", b"position_uid", "ticker", b"ticker"]) -> None: ...

global___PositionsSecurities = PositionsSecurities

@typing.final
class PositionsFutures(google.protobuf.message.Message):
    """Баланс фьючерса."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    BLOCKED_FIELD_NUMBER: builtins.int
    BALANCE_FIELD_NUMBER: builtins.int
    POSITION_UID_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """FIGI-идентификатор фьючерса."""
    blocked: builtins.int
    """Количество бумаг, заблокированных выставленными заявками."""
    balance: builtins.int
    """Текущий незаблокированный баланс."""
    position_uid: builtins.str
    """Уникальный идентификатор позиции."""
    instrument_uid: builtins.str
    """Уникальный идентификатор  инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    def __init__(
        self,
        *,
        figi: builtins.str = ...,
        blocked: builtins.int = ...,
        balance: builtins.int = ...,
        position_uid: builtins.str = ...,
        instrument_uid: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["balance", b"balance", "blocked", b"blocked", "class_code", b"class_code", "figi", b"figi", "instrument_uid", b"instrument_uid", "position_uid", b"position_uid", "ticker", b"ticker"]) -> None: ...

global___PositionsFutures = PositionsFutures

@typing.final
class PositionsOptions(google.protobuf.message.Message):
    """Баланс опциона."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POSITION_UID_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    BLOCKED_FIELD_NUMBER: builtins.int
    BALANCE_FIELD_NUMBER: builtins.int
    position_uid: builtins.str
    """Уникальный идентификатор позиции опциона."""
    instrument_uid: builtins.str
    """Уникальный идентификатор  инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    blocked: builtins.int
    """Количество бумаг, заблокированных выставленными заявками."""
    balance: builtins.int
    """Текущий незаблокированный баланс."""
    def __init__(
        self,
        *,
        position_uid: builtins.str = ...,
        instrument_uid: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        blocked: builtins.int = ...,
        balance: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["balance", b"balance", "blocked", b"blocked", "class_code", b"class_code", "instrument_uid", b"instrument_uid", "position_uid", b"position_uid", "ticker", b"ticker"]) -> None: ...

global___PositionsOptions = PositionsOptions

@typing.final
class BrokerReportRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GENERATE_BROKER_REPORT_REQUEST_FIELD_NUMBER: builtins.int
    GET_BROKER_REPORT_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def generate_broker_report_request(self) -> global___GenerateBrokerReportRequest: ...
    @property
    def get_broker_report_request(self) -> global___GetBrokerReportRequest: ...
    def __init__(
        self,
        *,
        generate_broker_report_request: global___GenerateBrokerReportRequest | None = ...,
        get_broker_report_request: global___GetBrokerReportRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["generate_broker_report_request", b"generate_broker_report_request", "get_broker_report_request", b"get_broker_report_request", "payload", b"payload"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["generate_broker_report_request", b"generate_broker_report_request", "get_broker_report_request", b"get_broker_report_request", "payload", b"payload"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["payload", b"payload"]) -> typing.Literal["generate_broker_report_request", "get_broker_report_request"] | None: ...

global___BrokerReportRequest = BrokerReportRequest

@typing.final
class BrokerReportResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GENERATE_BROKER_REPORT_RESPONSE_FIELD_NUMBER: builtins.int
    GET_BROKER_REPORT_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def generate_broker_report_response(self) -> global___GenerateBrokerReportResponse: ...
    @property
    def get_broker_report_response(self) -> global___GetBrokerReportResponse: ...
    def __init__(
        self,
        *,
        generate_broker_report_response: global___GenerateBrokerReportResponse | None = ...,
        get_broker_report_response: global___GetBrokerReportResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["generate_broker_report_response", b"generate_broker_report_response", "get_broker_report_response", b"get_broker_report_response", "payload", b"payload"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["generate_broker_report_response", b"generate_broker_report_response", "get_broker_report_response", b"get_broker_report_response", "payload", b"payload"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["payload", b"payload"]) -> typing.Literal["generate_broker_report_response", "get_broker_report_response"] | None: ...

global___BrokerReportResponse = BrokerReportResponse

@typing.final
class GenerateBrokerReportRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    FROM_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    account_id: builtins.str
    """Идентификатор счета клиента."""
    @property
    def to(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Окончание периода по UTC."""

    def __init__(
        self,
        *,
        account_id: builtins.str = ...,
        to: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["from", b"from", "to", b"to"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["account_id", b"account_id", "from", b"from", "to", b"to"]) -> None: ...

global___GenerateBrokerReportRequest = GenerateBrokerReportRequest

@typing.final
class GenerateBrokerReportResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_ID_FIELD_NUMBER: builtins.int
    task_id: builtins.str
    """Идентификатор задачи формирования брокерского отчета."""
    def __init__(
        self,
        *,
        task_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["task_id", b"task_id"]) -> None: ...

global___GenerateBrokerReportResponse = GenerateBrokerReportResponse

@typing.final
class GetBrokerReportRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_ID_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    task_id: builtins.str
    """Идентификатор задачи формирования брокерского отчета."""
    page: builtins.int
    """Номер страницы отчета, начинается с 1. Значение по умолчанию — 0."""
    def __init__(
        self,
        *,
        task_id: builtins.str = ...,
        page: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_page", b"_page", "page", b"page"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_page", b"_page", "page", b"page", "task_id", b"task_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_page", b"_page"]) -> typing.Literal["page"] | None: ...

global___GetBrokerReportRequest = GetBrokerReportRequest

@typing.final
class GetBrokerReportResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BROKER_REPORT_FIELD_NUMBER: builtins.int
    ITEMSCOUNT_FIELD_NUMBER: builtins.int
    PAGESCOUNT_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    itemsCount: builtins.int
    """Количество записей в отчете."""
    pagesCount: builtins.int
    """Количество страниц с данными отчета, начинается с 0."""
    page: builtins.int
    """Текущая страница, начинается с 0."""
    @property
    def broker_report(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BrokerReport]: ...
    def __init__(
        self,
        *,
        broker_report: collections.abc.Iterable[global___BrokerReport] | None = ...,
        itemsCount: builtins.int = ...,
        pagesCount: builtins.int = ...,
        page: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["broker_report", b"broker_report", "itemsCount", b"itemsCount", "page", b"page", "pagesCount", b"pagesCount"]) -> None: ...

global___GetBrokerReportResponse = GetBrokerReportResponse

@typing.final
class BrokerReport(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRADE_ID_FIELD_NUMBER: builtins.int
    ORDER_ID_FIELD_NUMBER: builtins.int
    FIGI_FIELD_NUMBER: builtins.int
    EXECUTE_SIGN_FIELD_NUMBER: builtins.int
    TRADE_DATETIME_FIELD_NUMBER: builtins.int
    EXCHANGE_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    PRICE_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    ORDER_AMOUNT_FIELD_NUMBER: builtins.int
    ACI_VALUE_FIELD_NUMBER: builtins.int
    TOTAL_ORDER_AMOUNT_FIELD_NUMBER: builtins.int
    BROKER_COMMISSION_FIELD_NUMBER: builtins.int
    EXCHANGE_COMMISSION_FIELD_NUMBER: builtins.int
    EXCHANGE_CLEARING_COMMISSION_FIELD_NUMBER: builtins.int
    REPO_RATE_FIELD_NUMBER: builtins.int
    PARTY_FIELD_NUMBER: builtins.int
    CLEAR_VALUE_DATE_FIELD_NUMBER: builtins.int
    SEC_VALUE_DATE_FIELD_NUMBER: builtins.int
    BROKER_STATUS_FIELD_NUMBER: builtins.int
    SEPARATE_AGREEMENT_TYPE_FIELD_NUMBER: builtins.int
    SEPARATE_AGREEMENT_NUMBER_FIELD_NUMBER: builtins.int
    SEPARATE_AGREEMENT_DATE_FIELD_NUMBER: builtins.int
    DELIVERY_TYPE_FIELD_NUMBER: builtins.int
    trade_id: builtins.str
    """Номер сделки."""
    order_id: builtins.str
    """Номер поручения."""
    figi: builtins.str
    """FIGI-идентификаторинструмента."""
    execute_sign: builtins.str
    """Признак исполнения."""
    exchange: builtins.str
    """Торговая площадка."""
    class_code: builtins.str
    """Режим торгов."""
    direction: builtins.str
    """Вид сделки."""
    name: builtins.str
    """Сокращенное наименование актива."""
    ticker: builtins.str
    """Код актива."""
    quantity: builtins.int
    """Количество."""
    party: builtins.str
    """Контрагент или брокерарокер."""
    broker_status: builtins.str
    """Статус брокера."""
    separate_agreement_type: builtins.str
    """Тип договора."""
    separate_agreement_number: builtins.str
    """Номер договора."""
    separate_agreement_date: builtins.str
    """Дата договора."""
    delivery_type: builtins.str
    """Тип расчета по сделке."""
    @property
    def trade_datetime(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата и время заключения по UTC."""

    @property
    def price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Цена за единицу."""

    @property
    def order_amount(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Сумма без НКД."""

    @property
    def aci_value(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """НКД."""

    @property
    def total_order_amount(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Сумма сделки."""

    @property
    def broker_commission(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Комиссия брокера."""

    @property
    def exchange_commission(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Комиссия биржи."""

    @property
    def exchange_clearing_commission(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Комиссия клирингового центра."""

    @property
    def repo_rate(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Ставка РЕПО, %."""

    @property
    def clear_value_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата расчетов по UTC."""

    @property
    def sec_value_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата поставки по UTC."""

    def __init__(
        self,
        *,
        trade_id: builtins.str = ...,
        order_id: builtins.str = ...,
        figi: builtins.str = ...,
        execute_sign: builtins.str = ...,
        trade_datetime: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        exchange: builtins.str = ...,
        class_code: builtins.str = ...,
        direction: builtins.str = ...,
        name: builtins.str = ...,
        ticker: builtins.str = ...,
        price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        quantity: builtins.int = ...,
        order_amount: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        aci_value: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        total_order_amount: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        broker_commission: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        exchange_commission: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        exchange_clearing_commission: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        repo_rate: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        party: builtins.str = ...,
        clear_value_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        sec_value_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        broker_status: builtins.str = ...,
        separate_agreement_type: builtins.str = ...,
        separate_agreement_number: builtins.str = ...,
        separate_agreement_date: builtins.str = ...,
        delivery_type: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["aci_value", b"aci_value", "broker_commission", b"broker_commission", "clear_value_date", b"clear_value_date", "exchange_clearing_commission", b"exchange_clearing_commission", "exchange_commission", b"exchange_commission", "order_amount", b"order_amount", "price", b"price", "repo_rate", b"repo_rate", "sec_value_date", b"sec_value_date", "total_order_amount", b"total_order_amount", "trade_datetime", b"trade_datetime"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["aci_value", b"aci_value", "broker_commission", b"broker_commission", "broker_status", b"broker_status", "class_code", b"class_code", "clear_value_date", b"clear_value_date", "delivery_type", b"delivery_type", "direction", b"direction", "exchange", b"exchange", "exchange_clearing_commission", b"exchange_clearing_commission", "exchange_commission", b"exchange_commission", "execute_sign", b"execute_sign", "figi", b"figi", "name", b"name", "order_amount", b"order_amount", "order_id", b"order_id", "party", b"party", "price", b"price", "quantity", b"quantity", "repo_rate", b"repo_rate", "sec_value_date", b"sec_value_date", "separate_agreement_date", b"separate_agreement_date", "separate_agreement_number", b"separate_agreement_number", "separate_agreement_type", b"separate_agreement_type", "ticker", b"ticker", "total_order_amount", b"total_order_amount", "trade_datetime", b"trade_datetime", "trade_id", b"trade_id"]) -> None: ...

global___BrokerReport = BrokerReport

@typing.final
class GetDividendsForeignIssuerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GENERATE_DIV_FOREIGN_ISSUER_REPORT_FIELD_NUMBER: builtins.int
    GET_DIV_FOREIGN_ISSUER_REPORT_FIELD_NUMBER: builtins.int
    @property
    def generate_div_foreign_issuer_report(self) -> global___GenerateDividendsForeignIssuerReportRequest:
        """Объект запроса формирования отчета."""

    @property
    def get_div_foreign_issuer_report(self) -> global___GetDividendsForeignIssuerReportRequest:
        """Объект запроса сформированного отчета."""

    def __init__(
        self,
        *,
        generate_div_foreign_issuer_report: global___GenerateDividendsForeignIssuerReportRequest | None = ...,
        get_div_foreign_issuer_report: global___GetDividendsForeignIssuerReportRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["generate_div_foreign_issuer_report", b"generate_div_foreign_issuer_report", "get_div_foreign_issuer_report", b"get_div_foreign_issuer_report", "payload", b"payload"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["generate_div_foreign_issuer_report", b"generate_div_foreign_issuer_report", "get_div_foreign_issuer_report", b"get_div_foreign_issuer_report", "payload", b"payload"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["payload", b"payload"]) -> typing.Literal["generate_div_foreign_issuer_report", "get_div_foreign_issuer_report"] | None: ...

global___GetDividendsForeignIssuerRequest = GetDividendsForeignIssuerRequest

@typing.final
class GetDividendsForeignIssuerResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GENERATE_DIV_FOREIGN_ISSUER_REPORT_RESPONSE_FIELD_NUMBER: builtins.int
    DIV_FOREIGN_ISSUER_REPORT_FIELD_NUMBER: builtins.int
    @property
    def generate_div_foreign_issuer_report_response(self) -> global___GenerateDividendsForeignIssuerReportResponse:
        """Объект результата задачи запуска формирования отчета."""

    @property
    def div_foreign_issuer_report(self) -> global___GetDividendsForeignIssuerReportResponse:
        """Отчет «Справка о доходах за пределами РФ»."""

    def __init__(
        self,
        *,
        generate_div_foreign_issuer_report_response: global___GenerateDividendsForeignIssuerReportResponse | None = ...,
        div_foreign_issuer_report: global___GetDividendsForeignIssuerReportResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["div_foreign_issuer_report", b"div_foreign_issuer_report", "generate_div_foreign_issuer_report_response", b"generate_div_foreign_issuer_report_response", "payload", b"payload"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["div_foreign_issuer_report", b"div_foreign_issuer_report", "generate_div_foreign_issuer_report_response", b"generate_div_foreign_issuer_report_response", "payload", b"payload"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["payload", b"payload"]) -> typing.Literal["generate_div_foreign_issuer_report_response", "div_foreign_issuer_report"] | None: ...

global___GetDividendsForeignIssuerResponse = GetDividendsForeignIssuerResponse

@typing.final
class GenerateDividendsForeignIssuerReportRequest(google.protobuf.message.Message):
    """Объект запроса формирования отчета «Справка о доходах за пределами РФ»."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    FROM_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    account_id: builtins.str
    """Идентификатор счета клиента."""
    @property
    def to(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Окончание периода по UTC. Как правило, можно сформировать отчет по дату на несколько дней меньше текущей. Начало и окончание периода должны быть в рамках одного календарного года."""

    def __init__(
        self,
        *,
        account_id: builtins.str = ...,
        to: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["from", b"from", "to", b"to"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["account_id", b"account_id", "from", b"from", "to", b"to"]) -> None: ...

global___GenerateDividendsForeignIssuerReportRequest = GenerateDividendsForeignIssuerReportRequest

@typing.final
class GetDividendsForeignIssuerReportRequest(google.protobuf.message.Message):
    """Объект запроса сформированного отчета «Справка о доходах за пределами РФ»."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_ID_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    task_id: builtins.str
    """Идентификатор задачи формирования отчета."""
    page: builtins.int
    """Номер страницы отчета (начинается с 0), значение по умолчанию: 0."""
    def __init__(
        self,
        *,
        task_id: builtins.str = ...,
        page: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_page", b"_page", "page", b"page"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_page", b"_page", "page", b"page", "task_id", b"task_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_page", b"_page"]) -> typing.Literal["page"] | None: ...

global___GetDividendsForeignIssuerReportRequest = GetDividendsForeignIssuerReportRequest

@typing.final
class GenerateDividendsForeignIssuerReportResponse(google.protobuf.message.Message):
    """Объект результата задачи запуска формирования отчета «Справка о доходах за пределами РФ»."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_ID_FIELD_NUMBER: builtins.int
    task_id: builtins.str
    """Идентификатор задачи формирования отчета."""
    def __init__(
        self,
        *,
        task_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["task_id", b"task_id"]) -> None: ...

global___GenerateDividendsForeignIssuerReportResponse = GenerateDividendsForeignIssuerReportResponse

@typing.final
class GetDividendsForeignIssuerReportResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DIVIDENDS_FOREIGN_ISSUER_REPORT_FIELD_NUMBER: builtins.int
    ITEMSCOUNT_FIELD_NUMBER: builtins.int
    PAGESCOUNT_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    itemsCount: builtins.int
    """Количество записей в отчете."""
    pagesCount: builtins.int
    """Количество страниц с данными отчета, начинается с 0."""
    page: builtins.int
    """Текущая страница, начинается с 0."""
    @property
    def dividends_foreign_issuer_report(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DividendsForeignIssuerReport]: ...
    def __init__(
        self,
        *,
        dividends_foreign_issuer_report: collections.abc.Iterable[global___DividendsForeignIssuerReport] | None = ...,
        itemsCount: builtins.int = ...,
        pagesCount: builtins.int = ...,
        page: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dividends_foreign_issuer_report", b"dividends_foreign_issuer_report", "itemsCount", b"itemsCount", "page", b"page", "pagesCount", b"pagesCount"]) -> None: ...

global___GetDividendsForeignIssuerReportResponse = GetDividendsForeignIssuerReportResponse

@typing.final
class DividendsForeignIssuerReport(google.protobuf.message.Message):
    """Отчет «Справка о доходах за пределами РФ»."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RECORD_DATE_FIELD_NUMBER: builtins.int
    PAYMENT_DATE_FIELD_NUMBER: builtins.int
    SECURITY_NAME_FIELD_NUMBER: builtins.int
    ISIN_FIELD_NUMBER: builtins.int
    ISSUER_COUNTRY_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    DIVIDEND_FIELD_NUMBER: builtins.int
    EXTERNAL_COMMISSION_FIELD_NUMBER: builtins.int
    DIVIDEND_GROSS_FIELD_NUMBER: builtins.int
    TAX_FIELD_NUMBER: builtins.int
    DIVIDEND_AMOUNT_FIELD_NUMBER: builtins.int
    CURRENCY_FIELD_NUMBER: builtins.int
    security_name: builtins.str
    """Наименование ценной бумаги."""
    isin: builtins.str
    """ISIN-идентификатор ценной бумаги."""
    issuer_country: builtins.str
    """Страна эмитента. Для депозитарных расписок указывается страна эмитента базового актива."""
    quantity: builtins.int
    """Количество ценных бумаг."""
    currency: builtins.str
    """Валюта."""
    @property
    def record_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата фиксации реестра."""

    @property
    def payment_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата выплаты."""

    @property
    def dividend(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Выплаты на одну бумагу"""

    @property
    def external_commission(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Комиссия внешних платежных агентов."""

    @property
    def dividend_gross(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Сумма до удержания налога."""

    @property
    def tax(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Сумма налога, удержанного агентом."""

    @property
    def dividend_amount(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Итоговая сумма выплаты."""

    def __init__(
        self,
        *,
        record_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        payment_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        security_name: builtins.str = ...,
        isin: builtins.str = ...,
        issuer_country: builtins.str = ...,
        quantity: builtins.int = ...,
        dividend: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        external_commission: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dividend_gross: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        tax: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        dividend_amount: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        currency: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["dividend", b"dividend", "dividend_amount", b"dividend_amount", "dividend_gross", b"dividend_gross", "external_commission", b"external_commission", "payment_date", b"payment_date", "record_date", b"record_date", "tax", b"tax"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["currency", b"currency", "dividend", b"dividend", "dividend_amount", b"dividend_amount", "dividend_gross", b"dividend_gross", "external_commission", b"external_commission", "isin", b"isin", "issuer_country", b"issuer_country", "payment_date", b"payment_date", "quantity", b"quantity", "record_date", b"record_date", "security_name", b"security_name", "tax", b"tax"]) -> None: ...

global___DividendsForeignIssuerReport = DividendsForeignIssuerReport

@typing.final
class PortfolioStreamRequest(google.protobuf.message.Message):
    """Запрос установки stream-соединения."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNTS_FIELD_NUMBER: builtins.int
    PING_SETTINGS_FIELD_NUMBER: builtins.int
    @property
    def accounts(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Массив идентификаторов счетов пользователя."""

    @property
    def ping_settings(self) -> tinkoff.invest.grpc.common_pb2.PingDelaySettings:
        """Запрос настройки пинга."""

    def __init__(
        self,
        *,
        accounts: collections.abc.Iterable[builtins.str] | None = ...,
        ping_settings: tinkoff.invest.grpc.common_pb2.PingDelaySettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ping_settings", b"ping_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["accounts", b"accounts", "ping_settings", b"ping_settings"]) -> None: ...

global___PortfolioStreamRequest = PortfolioStreamRequest

@typing.final
class PortfolioStreamResponse(google.protobuf.message.Message):
    """Информация по позициям и доходностям портфелей."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBSCRIPTIONS_FIELD_NUMBER: builtins.int
    PORTFOLIO_FIELD_NUMBER: builtins.int
    PING_FIELD_NUMBER: builtins.int
    @property
    def subscriptions(self) -> global___PortfolioSubscriptionResult:
        """Объект результата подписки."""

    @property
    def portfolio(self) -> global___PortfolioResponse:
        """Объект стриминга портфеля."""

    @property
    def ping(self) -> tinkoff.invest.grpc.common_pb2.Ping:
        """Проверка активности стрима."""

    def __init__(
        self,
        *,
        subscriptions: global___PortfolioSubscriptionResult | None = ...,
        portfolio: global___PortfolioResponse | None = ...,
        ping: tinkoff.invest.grpc.common_pb2.Ping | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["payload", b"payload", "ping", b"ping", "portfolio", b"portfolio", "subscriptions", b"subscriptions"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["payload", b"payload", "ping", b"ping", "portfolio", b"portfolio", "subscriptions", b"subscriptions"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["payload", b"payload"]) -> typing.Literal["subscriptions", "portfolio", "ping"] | None: ...

global___PortfolioStreamResponse = PortfolioStreamResponse

@typing.final
class PortfolioSubscriptionResult(google.protobuf.message.Message):
    """Объект результата подписки."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNTS_FIELD_NUMBER: builtins.int
    TRACKING_ID_FIELD_NUMBER: builtins.int
    STREAM_ID_FIELD_NUMBER: builtins.int
    tracking_id: builtins.str
    """Уникальный идентификатор запроса, подробнее: [tracking_id](/invest/intro/developer/protocols/grpc#tracking-id)."""
    stream_id: builtins.str
    """Идентификатор открытого соединения"""
    @property
    def accounts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AccountSubscriptionStatus]:
        """Массив счетов клиента."""

    def __init__(
        self,
        *,
        accounts: collections.abc.Iterable[global___AccountSubscriptionStatus] | None = ...,
        tracking_id: builtins.str = ...,
        stream_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["accounts", b"accounts", "stream_id", b"stream_id", "tracking_id", b"tracking_id"]) -> None: ...

global___PortfolioSubscriptionResult = PortfolioSubscriptionResult

@typing.final
class AccountSubscriptionStatus(google.protobuf.message.Message):
    """Счет клиента."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_STATUS_FIELD_NUMBER: builtins.int
    account_id: builtins.str
    """Идентификатор счета."""
    subscription_status: global___PortfolioSubscriptionStatus.ValueType
    """Результат подписки."""
    def __init__(
        self,
        *,
        account_id: builtins.str = ...,
        subscription_status: global___PortfolioSubscriptionStatus.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["account_id", b"account_id", "subscription_status", b"subscription_status"]) -> None: ...

global___AccountSubscriptionStatus = AccountSubscriptionStatus

@typing.final
class GetOperationsByCursorRequest(google.protobuf.message.Message):
    """Запрос списка операций по счету с пагинацией."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    FROM_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    OPERATION_TYPES_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    WITHOUT_COMMISSIONS_FIELD_NUMBER: builtins.int
    WITHOUT_TRADES_FIELD_NUMBER: builtins.int
    WITHOUT_OVERNIGHTS_FIELD_NUMBER: builtins.int
    account_id: builtins.str
    """Идентификатор счета клиента, обязательный параметр. Остальные параметры опциональны."""
    instrument_id: builtins.str
    """Идентификатор инструмента — FIGI или UID инструмента."""
    cursor: builtins.str
    """Идентификатор элемента, с которого начать формировать ответ."""
    limit: builtins.int
    """Лимит количества операций. По умолчанию — `100`, максимальное значение — `1000`."""
    state: global___OperationState.ValueType
    """Статус запрашиваемых операций. Возможные значения указаны в `OperationState`."""
    without_commissions: builtins.bool
    """Флаг возврата комиссии. По умолчанию — `false`."""
    without_trades: builtins.bool
    """Флаг получения ответа без массива сделок."""
    without_overnights: builtins.bool
    """Флаг показа overnight операций."""
    @property
    def to(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Окончание периода по UTC."""

    @property
    def operation_types(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___OperationType.ValueType]:
        """Тип операции. Принимает значение из списка `OperationType`."""

    def __init__(
        self,
        *,
        account_id: builtins.str = ...,
        instrument_id: builtins.str | None = ...,
        to: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        cursor: builtins.str | None = ...,
        limit: builtins.int | None = ...,
        operation_types: collections.abc.Iterable[global___OperationType.ValueType] | None = ...,
        state: global___OperationState.ValueType | None = ...,
        without_commissions: builtins.bool | None = ...,
        without_trades: builtins.bool | None = ...,
        without_overnights: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_cursor", b"_cursor", "_from", b"_from", "_instrument_id", b"_instrument_id", "_limit", b"_limit", "_state", b"_state", "_to", b"_to", "_without_commissions", b"_without_commissions", "_without_overnights", b"_without_overnights", "_without_trades", b"_without_trades", "cursor", b"cursor", "from", b"from", "instrument_id", b"instrument_id", "limit", b"limit", "state", b"state", "to", b"to", "without_commissions", b"without_commissions", "without_overnights", b"without_overnights", "without_trades", b"without_trades"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_cursor", b"_cursor", "_from", b"_from", "_instrument_id", b"_instrument_id", "_limit", b"_limit", "_state", b"_state", "_to", b"_to", "_without_commissions", b"_without_commissions", "_without_overnights", b"_without_overnights", "_without_trades", b"_without_trades", "account_id", b"account_id", "cursor", b"cursor", "from", b"from", "instrument_id", b"instrument_id", "limit", b"limit", "operation_types", b"operation_types", "state", b"state", "to", b"to", "without_commissions", b"without_commissions", "without_overnights", b"without_overnights", "without_trades", b"without_trades"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_cursor", b"_cursor"]) -> typing.Literal["cursor"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_from", b"_from"]) -> typing.Literal["from"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_instrument_id", b"_instrument_id"]) -> typing.Literal["instrument_id"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_limit", b"_limit"]) -> typing.Literal["limit"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_state", b"_state"]) -> typing.Literal["state"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_to", b"_to"]) -> typing.Literal["to"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_without_commissions", b"_without_commissions"]) -> typing.Literal["without_commissions"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_without_overnights", b"_without_overnights"]) -> typing.Literal["without_overnights"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_without_trades", b"_without_trades"]) -> typing.Literal["without_trades"] | None: ...

global___GetOperationsByCursorRequest = GetOperationsByCursorRequest

@typing.final
class GetOperationsByCursorResponse(google.protobuf.message.Message):
    """Список операций по счету с пагинацией."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HAS_NEXT_FIELD_NUMBER: builtins.int
    NEXT_CURSOR_FIELD_NUMBER: builtins.int
    ITEMS_FIELD_NUMBER: builtins.int
    has_next: builtins.bool
    """Признак, есть ли следующий элемент."""
    next_cursor: builtins.str
    """Следующий курсор."""
    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OperationItem]:
        """Список операций."""

    def __init__(
        self,
        *,
        has_next: builtins.bool = ...,
        next_cursor: builtins.str = ...,
        items: collections.abc.Iterable[global___OperationItem] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["has_next", b"has_next", "items", b"items", "next_cursor", b"next_cursor"]) -> None: ...

global___GetOperationsByCursorResponse = GetOperationsByCursorResponse

@typing.final
class OperationItem(google.protobuf.message.Message):
    """Данные об операции."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CURSOR_FIELD_NUMBER: builtins.int
    BROKER_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    PARENT_OPERATION_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DATE_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    FIGI_FIELD_NUMBER: builtins.int
    INSTRUMENT_TYPE_FIELD_NUMBER: builtins.int
    INSTRUMENT_KIND_FIELD_NUMBER: builtins.int
    POSITION_UID_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    PAYMENT_FIELD_NUMBER: builtins.int
    PRICE_FIELD_NUMBER: builtins.int
    COMMISSION_FIELD_NUMBER: builtins.int
    YIELD_FIELD_NUMBER: builtins.int
    YIELD_RELATIVE_FIELD_NUMBER: builtins.int
    ACCRUED_INT_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    QUANTITY_REST_FIELD_NUMBER: builtins.int
    QUANTITY_DONE_FIELD_NUMBER: builtins.int
    CANCEL_DATE_TIME_FIELD_NUMBER: builtins.int
    CANCEL_REASON_FIELD_NUMBER: builtins.int
    TRADES_INFO_FIELD_NUMBER: builtins.int
    ASSET_UID_FIELD_NUMBER: builtins.int
    CHILD_OPERATIONS_FIELD_NUMBER: builtins.int
    cursor: builtins.str
    """Курсор."""
    broker_account_id: builtins.str
    """Номер счета клиента."""
    id: builtins.str
    """Идентификатор операции, может меняться с течением времени."""
    parent_operation_id: builtins.str
    """Идентификатор родительской операции. Может измениться, если изменился ID родительской операции."""
    name: builtins.str
    """Название операции."""
    type: global___OperationType.ValueType
    """Тип операции."""
    description: builtins.str
    """Описание операции."""
    state: global___OperationState.ValueType
    """Статус поручения."""
    instrument_uid: builtins.str
    """Уникальный идентификатор инструмента."""
    figi: builtins.str
    """FIGI."""
    instrument_type: builtins.str
    """Тип инструмента."""
    instrument_kind: tinkoff.invest.grpc.common_pb2.InstrumentType.ValueType
    """Тип инструмента."""
    position_uid: builtins.str
    """Уникальный идентификатор позиции."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    quantity: builtins.int
    """Количество единиц инструмента."""
    quantity_rest: builtins.int
    """Неисполненный остаток по сделке."""
    quantity_done: builtins.int
    """Исполненный остаток."""
    cancel_reason: builtins.str
    """Причина отмены операции."""
    asset_uid: builtins.str
    """Идентификатор актива."""
    @property
    def date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата поручения."""

    @property
    def payment(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Сумма операции."""

    @property
    def price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Цена операции за 1 инструмент."""

    @property
    def commission(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Комиссия."""

    @property
    def yield_relative(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Относительная доходность."""

    @property
    def accrued_int(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Накопленный купонный доход."""

    @property
    def cancel_date_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата и время снятия заявки."""

    @property
    def trades_info(self) -> global___OperationItemTrades:
        """Массив сделок."""

    @property
    def child_operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChildOperationItem]:
        """Массив дочерних операций."""

    def __init__(
        self,
        *,
        cursor: builtins.str = ...,
        broker_account_id: builtins.str = ...,
        id: builtins.str = ...,
        parent_operation_id: builtins.str = ...,
        name: builtins.str = ...,
        date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        type: global___OperationType.ValueType = ...,
        description: builtins.str = ...,
        state: global___OperationState.ValueType = ...,
        instrument_uid: builtins.str = ...,
        figi: builtins.str = ...,
        instrument_type: builtins.str = ...,
        instrument_kind: tinkoff.invest.grpc.common_pb2.InstrumentType.ValueType = ...,
        position_uid: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        payment: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        commission: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        yield_relative: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        accrued_int: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        quantity: builtins.int = ...,
        quantity_rest: builtins.int = ...,
        quantity_done: builtins.int = ...,
        cancel_date_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        cancel_reason: builtins.str = ...,
        trades_info: global___OperationItemTrades | None = ...,
        asset_uid: builtins.str = ...,
        child_operations: collections.abc.Iterable[global___ChildOperationItem] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["accrued_int", b"accrued_int", "cancel_date_time", b"cancel_date_time", "commission", b"commission", "date", b"date", "payment", b"payment", "price", b"price", "trades_info", b"trades_info", "yield", b"yield", "yield_relative", b"yield_relative"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["accrued_int", b"accrued_int", "asset_uid", b"asset_uid", "broker_account_id", b"broker_account_id", "cancel_date_time", b"cancel_date_time", "cancel_reason", b"cancel_reason", "child_operations", b"child_operations", "class_code", b"class_code", "commission", b"commission", "cursor", b"cursor", "date", b"date", "description", b"description", "figi", b"figi", "id", b"id", "instrument_kind", b"instrument_kind", "instrument_type", b"instrument_type", "instrument_uid", b"instrument_uid", "name", b"name", "parent_operation_id", b"parent_operation_id", "payment", b"payment", "position_uid", b"position_uid", "price", b"price", "quantity", b"quantity", "quantity_done", b"quantity_done", "quantity_rest", b"quantity_rest", "state", b"state", "ticker", b"ticker", "trades_info", b"trades_info", "type", b"type", "yield", b"yield", "yield_relative", b"yield_relative"]) -> None: ...

global___OperationItem = OperationItem

@typing.final
class OperationItemTrades(google.protobuf.message.Message):
    """Массив с информацией о сделках."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRADES_FIELD_NUMBER: builtins.int
    @property
    def trades(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OperationItemTrade]: ...
    def __init__(
        self,
        *,
        trades: collections.abc.Iterable[global___OperationItemTrade] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["trades", b"trades"]) -> None: ...

global___OperationItemTrades = OperationItemTrades

@typing.final
class OperationItemTrade(google.protobuf.message.Message):
    """Сделка по операции."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NUM_FIELD_NUMBER: builtins.int
    DATE_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    PRICE_FIELD_NUMBER: builtins.int
    YIELD_FIELD_NUMBER: builtins.int
    YIELD_RELATIVE_FIELD_NUMBER: builtins.int
    num: builtins.str
    """Номер сделки."""
    quantity: builtins.int
    """Количество в единицах."""
    @property
    def date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата сделки."""

    @property
    def price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Цена."""

    @property
    def yield_relative(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Относительная доходность."""

    def __init__(
        self,
        *,
        num: builtins.str = ...,
        date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        quantity: builtins.int = ...,
        price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        yield_relative: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["date", b"date", "price", b"price", "yield", b"yield", "yield_relative", b"yield_relative"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["date", b"date", "num", b"num", "price", b"price", "quantity", b"quantity", "yield", b"yield", "yield_relative", b"yield_relative"]) -> None: ...

global___OperationItemTrade = OperationItemTrade

@typing.final
class PositionsStreamRequest(google.protobuf.message.Message):
    """Запрос установки stream-соединения позиций."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNTS_FIELD_NUMBER: builtins.int
    WITH_INITIAL_POSITIONS_FIELD_NUMBER: builtins.int
    PING_SETTINGS_FIELD_NUMBER: builtins.int
    with_initial_positions: builtins.bool
    """Получение состояния позиций на момент подключения."""
    @property
    def accounts(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Массив идентификаторов счетов пользователя."""

    @property
    def ping_settings(self) -> tinkoff.invest.grpc.common_pb2.PingDelaySettings:
        """Запрос настройки пинга."""

    def __init__(
        self,
        *,
        accounts: collections.abc.Iterable[builtins.str] | None = ...,
        with_initial_positions: builtins.bool = ...,
        ping_settings: tinkoff.invest.grpc.common_pb2.PingDelaySettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ping_settings", b"ping_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["accounts", b"accounts", "ping_settings", b"ping_settings", "with_initial_positions", b"with_initial_positions"]) -> None: ...

global___PositionsStreamRequest = PositionsStreamRequest

@typing.final
class PositionsStreamResponse(google.protobuf.message.Message):
    """Информация по изменению позиций портфеля."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBSCRIPTIONS_FIELD_NUMBER: builtins.int
    POSITION_FIELD_NUMBER: builtins.int
    PING_FIELD_NUMBER: builtins.int
    INITIAL_POSITIONS_FIELD_NUMBER: builtins.int
    @property
    def subscriptions(self) -> global___PositionsSubscriptionResult:
        """Объект результата подписки."""

    @property
    def position(self) -> global___PositionData:
        """Объект стриминга позиций."""

    @property
    def ping(self) -> tinkoff.invest.grpc.common_pb2.Ping:
        """Проверка активности стрима."""

    @property
    def initial_positions(self) -> global___PositionsResponse:
        """Текущие позиции."""

    def __init__(
        self,
        *,
        subscriptions: global___PositionsSubscriptionResult | None = ...,
        position: global___PositionData | None = ...,
        ping: tinkoff.invest.grpc.common_pb2.Ping | None = ...,
        initial_positions: global___PositionsResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["initial_positions", b"initial_positions", "payload", b"payload", "ping", b"ping", "position", b"position", "subscriptions", b"subscriptions"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["initial_positions", b"initial_positions", "payload", b"payload", "ping", b"ping", "position", b"position", "subscriptions", b"subscriptions"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["payload", b"payload"]) -> typing.Literal["subscriptions", "position", "ping", "initial_positions"] | None: ...

global___PositionsStreamResponse = PositionsStreamResponse

@typing.final
class PositionsSubscriptionResult(google.protobuf.message.Message):
    """Объект результата подписки."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNTS_FIELD_NUMBER: builtins.int
    TRACKING_ID_FIELD_NUMBER: builtins.int
    STREAM_ID_FIELD_NUMBER: builtins.int
    tracking_id: builtins.str
    """Уникальный идентификатор запроса, подробнее: [tracking_id](/invest/intro/developer/protocols/grpc#tracking-id)."""
    stream_id: builtins.str
    """Идентификатор открытого соединения"""
    @property
    def accounts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PositionsSubscriptionStatus]:
        """Массив счетов клиента."""

    def __init__(
        self,
        *,
        accounts: collections.abc.Iterable[global___PositionsSubscriptionStatus] | None = ...,
        tracking_id: builtins.str = ...,
        stream_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["accounts", b"accounts", "stream_id", b"stream_id", "tracking_id", b"tracking_id"]) -> None: ...

global___PositionsSubscriptionResult = PositionsSubscriptionResult

@typing.final
class PositionsSubscriptionStatus(google.protobuf.message.Message):
    """Счет клиента."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_STATUS_FIELD_NUMBER: builtins.int
    account_id: builtins.str
    """Идентификатор счета."""
    subscription_status: global___PositionsAccountSubscriptionStatus.ValueType
    """Результат подписки."""
    def __init__(
        self,
        *,
        account_id: builtins.str = ...,
        subscription_status: global___PositionsAccountSubscriptionStatus.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["account_id", b"account_id", "subscription_status", b"subscription_status"]) -> None: ...

global___PositionsSubscriptionStatus = PositionsSubscriptionStatus

@typing.final
class PositionData(google.protobuf.message.Message):
    """Данные о позиции портфеля."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    MONEY_FIELD_NUMBER: builtins.int
    SECURITIES_FIELD_NUMBER: builtins.int
    FUTURES_FIELD_NUMBER: builtins.int
    OPTIONS_FIELD_NUMBER: builtins.int
    DATE_FIELD_NUMBER: builtins.int
    account_id: builtins.str
    """Идентификатор счета."""
    @property
    def money(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PositionsMoney]:
        """Массив валютных позиций портфеля."""

    @property
    def securities(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PositionsSecurities]:
        """Список ценно-бумажных позиций портфеля."""

    @property
    def futures(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PositionsFutures]:
        """Список фьючерсов портфеля."""

    @property
    def options(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PositionsOptions]:
        """Список опционов портфеля."""

    @property
    def date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата и время операции в формате UTC."""

    def __init__(
        self,
        *,
        account_id: builtins.str = ...,
        money: collections.abc.Iterable[global___PositionsMoney] | None = ...,
        securities: collections.abc.Iterable[global___PositionsSecurities] | None = ...,
        futures: collections.abc.Iterable[global___PositionsFutures] | None = ...,
        options: collections.abc.Iterable[global___PositionsOptions] | None = ...,
        date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["date", b"date"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["account_id", b"account_id", "date", b"date", "futures", b"futures", "money", b"money", "options", b"options", "securities", b"securities"]) -> None: ...

global___PositionData = PositionData

@typing.final
class PositionsMoney(google.protobuf.message.Message):
    """Валютная позиция портфеля."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AVAILABLE_VALUE_FIELD_NUMBER: builtins.int
    BLOCKED_VALUE_FIELD_NUMBER: builtins.int
    @property
    def available_value(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Доступное количество валютный позиций."""

    @property
    def blocked_value(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Заблокированное количество валютных позиций."""

    def __init__(
        self,
        *,
        available_value: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        blocked_value: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["available_value", b"available_value", "blocked_value", b"blocked_value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["available_value", b"available_value", "blocked_value", b"blocked_value"]) -> None: ...

global___PositionsMoney = PositionsMoney

@typing.final
class ChildOperationItem(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    PAYMENT_FIELD_NUMBER: builtins.int
    instrument_uid: builtins.str
    """Уникальный идентификатор инструмента."""
    @property
    def payment(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Сумма операции."""

    def __init__(
        self,
        *,
        instrument_uid: builtins.str = ...,
        payment: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["payment", b"payment"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["instrument_uid", b"instrument_uid", "payment", b"payment"]) -> None: ...

global___ChildOperationItem = ChildOperationItem
