"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import tinkoff.invest.grpc.common_pb2
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _OrderDirection:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _OrderDirectionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_OrderDirection.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ORDER_DIRECTION_UNSPECIFIED: _OrderDirection.ValueType  # 0
    """Значение не указано"""
    ORDER_DIRECTION_BUY: _OrderDirection.ValueType  # 1
    """Покупка"""
    ORDER_DIRECTION_SELL: _OrderDirection.ValueType  # 2
    """Продажа"""

class OrderDirection(_OrderDirection, metaclass=_OrderDirectionEnumTypeWrapper):
    """Направление операции."""

ORDER_DIRECTION_UNSPECIFIED: OrderDirection.ValueType  # 0
"""Значение не указано"""
ORDER_DIRECTION_BUY: OrderDirection.ValueType  # 1
"""Покупка"""
ORDER_DIRECTION_SELL: OrderDirection.ValueType  # 2
"""Продажа"""
global___OrderDirection = OrderDirection

class _OrderType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _OrderTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_OrderType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ORDER_TYPE_UNSPECIFIED: _OrderType.ValueType  # 0
    """Значение не указано"""
    ORDER_TYPE_LIMIT: _OrderType.ValueType  # 1
    """Лимитная"""
    ORDER_TYPE_MARKET: _OrderType.ValueType  # 2
    """Рыночная"""
    ORDER_TYPE_BESTPRICE: _OrderType.ValueType  # 3
    """Лучшая цена"""

class OrderType(_OrderType, metaclass=_OrderTypeEnumTypeWrapper):
    """Тип заявки."""

ORDER_TYPE_UNSPECIFIED: OrderType.ValueType  # 0
"""Значение не указано"""
ORDER_TYPE_LIMIT: OrderType.ValueType  # 1
"""Лимитная"""
ORDER_TYPE_MARKET: OrderType.ValueType  # 2
"""Рыночная"""
ORDER_TYPE_BESTPRICE: OrderType.ValueType  # 3
"""Лучшая цена"""
global___OrderType = OrderType

class _OrderExecutionReportStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _OrderExecutionReportStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_OrderExecutionReportStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    EXECUTION_REPORT_STATUS_UNSPECIFIED: _OrderExecutionReportStatus.ValueType  # 0
    EXECUTION_REPORT_STATUS_FILL: _OrderExecutionReportStatus.ValueType  # 1
    """Исполнена"""
    EXECUTION_REPORT_STATUS_REJECTED: _OrderExecutionReportStatus.ValueType  # 2
    """Отклонена"""
    EXECUTION_REPORT_STATUS_CANCELLED: _OrderExecutionReportStatus.ValueType  # 3
    """Отменена пользователем"""
    EXECUTION_REPORT_STATUS_NEW: _OrderExecutionReportStatus.ValueType  # 4
    """Новая"""
    EXECUTION_REPORT_STATUS_PARTIALLYFILL: _OrderExecutionReportStatus.ValueType  # 5
    """Частично исполнена"""

class OrderExecutionReportStatus(_OrderExecutionReportStatus, metaclass=_OrderExecutionReportStatusEnumTypeWrapper):
    """Текущий статус заявки (поручения)"""

EXECUTION_REPORT_STATUS_UNSPECIFIED: OrderExecutionReportStatus.ValueType  # 0
EXECUTION_REPORT_STATUS_FILL: OrderExecutionReportStatus.ValueType  # 1
"""Исполнена"""
EXECUTION_REPORT_STATUS_REJECTED: OrderExecutionReportStatus.ValueType  # 2
"""Отклонена"""
EXECUTION_REPORT_STATUS_CANCELLED: OrderExecutionReportStatus.ValueType  # 3
"""Отменена пользователем"""
EXECUTION_REPORT_STATUS_NEW: OrderExecutionReportStatus.ValueType  # 4
"""Новая"""
EXECUTION_REPORT_STATUS_PARTIALLYFILL: OrderExecutionReportStatus.ValueType  # 5
"""Частично исполнена"""
global___OrderExecutionReportStatus = OrderExecutionReportStatus

class _TimeInForceType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _TimeInForceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_TimeInForceType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TIME_IN_FORCE_UNSPECIFIED: _TimeInForceType.ValueType  # 0
    """Значение не определено см. TIME_IN_FORCE_DAY"""
    TIME_IN_FORCE_DAY: _TimeInForceType.ValueType  # 1
    """Заявка действует до конца торгового дня. Значение по умолчанию"""
    TIME_IN_FORCE_FILL_AND_KILL: _TimeInForceType.ValueType  # 2
    """Если в момент выставления возможно исполнение заявки(в т.ч. частичное), заявка будет исполнена или отменена сразу после выставления"""
    TIME_IN_FORCE_FILL_OR_KILL: _TimeInForceType.ValueType  # 3
    """Если в момент выставления возможно полное исполнение заявки, заявка будет исполнена или отменена сразу после выставления, недоступно для срочного рынка и торговли по выходным"""

class TimeInForceType(_TimeInForceType, metaclass=_TimeInForceTypeEnumTypeWrapper):
    """Алгоритм исполнения заявки"""

TIME_IN_FORCE_UNSPECIFIED: TimeInForceType.ValueType  # 0
"""Значение не определено см. TIME_IN_FORCE_DAY"""
TIME_IN_FORCE_DAY: TimeInForceType.ValueType  # 1
"""Заявка действует до конца торгового дня. Значение по умолчанию"""
TIME_IN_FORCE_FILL_AND_KILL: TimeInForceType.ValueType  # 2
"""Если в момент выставления возможно исполнение заявки(в т.ч. частичное), заявка будет исполнена или отменена сразу после выставления"""
TIME_IN_FORCE_FILL_OR_KILL: TimeInForceType.ValueType  # 3
"""Если в момент выставления возможно полное исполнение заявки, заявка будет исполнена или отменена сразу после выставления, недоступно для срочного рынка и торговли по выходным"""
global___TimeInForceType = TimeInForceType

class _OrderIdType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _OrderIdTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_OrderIdType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ORDER_ID_TYPE_UNSPECIFIED: _OrderIdType.ValueType  # 0
    """Тип идентификатора не указан."""
    ORDER_ID_TYPE_EXCHANGE: _OrderIdType.ValueType  # 1
    """Биржевой идентификатор"""
    ORDER_ID_TYPE_REQUEST: _OrderIdType.ValueType  # 2
    """Ключ идемпотентности, переданный клиентом"""

class OrderIdType(_OrderIdType, metaclass=_OrderIdTypeEnumTypeWrapper):
    """Тип идентификатора заявки"""

ORDER_ID_TYPE_UNSPECIFIED: OrderIdType.ValueType  # 0
"""Тип идентификатора не указан."""
ORDER_ID_TYPE_EXCHANGE: OrderIdType.ValueType  # 1
"""Биржевой идентификатор"""
ORDER_ID_TYPE_REQUEST: OrderIdType.ValueType  # 2
"""Ключ идемпотентности, переданный клиентом"""
global___OrderIdType = OrderIdType

@typing.final
class TradesStreamRequest(google.protobuf.message.Message):
    """Запрос установки соединения."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNTS_FIELD_NUMBER: builtins.int
    PING_DELAY_MS_FIELD_NUMBER: builtins.int
    ping_delay_ms: builtins.int
    """Задержка (пинг) сообщений: 5000–180 000 миллисекунд. Значение по умолчанию — 120 000."""
    @property
    def accounts(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Идентификаторы счетов."""

    def __init__(
        self,
        *,
        accounts: collections.abc.Iterable[builtins.str] | None = ...,
        ping_delay_ms: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_ping_delay_ms", b"_ping_delay_ms", "ping_delay_ms", b"ping_delay_ms"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_ping_delay_ms", b"_ping_delay_ms", "accounts", b"accounts", "ping_delay_ms", b"ping_delay_ms"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_ping_delay_ms", b"_ping_delay_ms"]) -> typing.Literal["ping_delay_ms"] | None: ...

global___TradesStreamRequest = TradesStreamRequest

@typing.final
class TradesStreamResponse(google.protobuf.message.Message):
    """Информация о торговых поручениях."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORDER_TRADES_FIELD_NUMBER: builtins.int
    PING_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_FIELD_NUMBER: builtins.int
    @property
    def order_trades(self) -> global___OrderTrades:
        """Информация об исполнении торгового поручения."""

    @property
    def ping(self) -> tinkoff.invest.grpc.common_pb2.Ping:
        """Проверка активности стрима."""

    @property
    def subscription(self) -> global___SubscriptionResponse:
        """Ответ на запрос на подписку."""

    def __init__(
        self,
        *,
        order_trades: global___OrderTrades | None = ...,
        ping: tinkoff.invest.grpc.common_pb2.Ping | None = ...,
        subscription: global___SubscriptionResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["order_trades", b"order_trades", "payload", b"payload", "ping", b"ping", "subscription", b"subscription"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["order_trades", b"order_trades", "payload", b"payload", "ping", b"ping", "subscription", b"subscription"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["payload", b"payload"]) -> typing.Literal["order_trades", "ping", "subscription"] | None: ...

global___TradesStreamResponse = TradesStreamResponse

@typing.final
class OrderTrades(google.protobuf.message.Message):
    """Информация об исполнении торгового поручения."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    FIGI_FIELD_NUMBER: builtins.int
    TRADES_FIELD_NUMBER: builtins.int
    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    order_id: builtins.str
    """Идентификатор торгового поручения."""
    direction: global___OrderDirection.ValueType
    """Направление сделки."""
    figi: builtins.str
    """Figi-идентификатор инструмента."""
    account_id: builtins.str
    """Идентификатор счета."""
    instrument_uid: builtins.str
    """UID идентификатор инструмента."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата и время создания сообщения в часовом поясе UTC."""

    @property
    def trades(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OrderTrade]:
        """Массив сделок."""

    def __init__(
        self,
        *,
        order_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        direction: global___OrderDirection.ValueType = ...,
        figi: builtins.str = ...,
        trades: collections.abc.Iterable[global___OrderTrade] | None = ...,
        account_id: builtins.str = ...,
        instrument_uid: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["account_id", b"account_id", "created_at", b"created_at", "direction", b"direction", "figi", b"figi", "instrument_uid", b"instrument_uid", "order_id", b"order_id", "trades", b"trades"]) -> None: ...

global___OrderTrades = OrderTrades

@typing.final
class OrderTrade(google.protobuf.message.Message):
    """Информация о сделке."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATE_TIME_FIELD_NUMBER: builtins.int
    PRICE_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    TRADE_ID_FIELD_NUMBER: builtins.int
    quantity: builtins.int
    """Количество штук в сделке."""
    trade_id: builtins.str
    """Идентификатор сделки."""
    @property
    def date_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата и время совершения сделки в часовом поясе UTC."""

    @property
    def price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена за 1 инструмент, по которой совершена сделка."""

    def __init__(
        self,
        *,
        date_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        quantity: builtins.int = ...,
        trade_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["date_time", b"date_time", "price", b"price"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["date_time", b"date_time", "price", b"price", "quantity", b"quantity", "trade_id", b"trade_id"]) -> None: ...

global___OrderTrade = OrderTrade

@typing.final
class PostOrderRequest(google.protobuf.message.Message):
    """Запрос выставления торгового поручения."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIGI_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    PRICE_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    ORDER_TYPE_FIELD_NUMBER: builtins.int
    ORDER_ID_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    TIME_IN_FORCE_FIELD_NUMBER: builtins.int
    PRICE_TYPE_FIELD_NUMBER: builtins.int
    CONFIRM_MARGIN_TRADE_FIELD_NUMBER: builtins.int
    figi: builtins.str
    """Deprecated Figi-идентификатор инструмента. Необходимо использовать instrument_id."""
    quantity: builtins.int
    """Количество лотов."""
    direction: global___OrderDirection.ValueType
    """Направление операции."""
    account_id: builtins.str
    """Номер счета."""
    order_type: global___OrderType.ValueType
    """Тип заявки."""
    order_id: builtins.str
    """Идентификатор запроса выставления поручения для целей идемпотентности в формате UID. Максимальная длина 36 символов."""
    instrument_id: builtins.str
    """Идентификатор инструмента, принимает значения Figi или Instrument_uid."""
    time_in_force: global___TimeInForceType.ValueType
    """Алгоритм исполнения поручения, применяется только к лимитной заявке."""
    price_type: tinkoff.invest.grpc.common_pb2.PriceType.ValueType
    """Тип цены."""
    confirm_margin_trade: builtins.bool
    """Согласие на выставление заявки, которая может привести к непокрытой позиции, по умолчанию false."""
    @property
    def price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена за 1 инструмент. Для получения стоимости лота требуется умножить на лотность инструмента. Игнорируется для рыночных поручений."""

    def __init__(
        self,
        *,
        figi: builtins.str | None = ...,
        quantity: builtins.int = ...,
        price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        direction: global___OrderDirection.ValueType = ...,
        account_id: builtins.str = ...,
        order_type: global___OrderType.ValueType = ...,
        order_id: builtins.str = ...,
        instrument_id: builtins.str = ...,
        time_in_force: global___TimeInForceType.ValueType = ...,
        price_type: tinkoff.invest.grpc.common_pb2.PriceType.ValueType = ...,
        confirm_margin_trade: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_figi", b"_figi", "_price", b"_price", "figi", b"figi", "price", b"price"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_figi", b"_figi", "_price", b"_price", "account_id", b"account_id", "confirm_margin_trade", b"confirm_margin_trade", "direction", b"direction", "figi", b"figi", "instrument_id", b"instrument_id", "order_id", b"order_id", "order_type", b"order_type", "price", b"price", "price_type", b"price_type", "quantity", b"quantity", "time_in_force", b"time_in_force"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_figi", b"_figi"]) -> typing.Literal["figi"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_price", b"_price"]) -> typing.Literal["price"] | None: ...

global___PostOrderRequest = PostOrderRequest

@typing.final
class PostOrderResponse(google.protobuf.message.Message):
    """Прочитайте  про ключ идемпотентности [здесь](./head-orders/)

    Информация о выставлении поручения.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORDER_ID_FIELD_NUMBER: builtins.int
    EXECUTION_REPORT_STATUS_FIELD_NUMBER: builtins.int
    LOTS_REQUESTED_FIELD_NUMBER: builtins.int
    LOTS_EXECUTED_FIELD_NUMBER: builtins.int
    INITIAL_ORDER_PRICE_FIELD_NUMBER: builtins.int
    EXECUTED_ORDER_PRICE_FIELD_NUMBER: builtins.int
    TOTAL_ORDER_AMOUNT_FIELD_NUMBER: builtins.int
    INITIAL_COMMISSION_FIELD_NUMBER: builtins.int
    EXECUTED_COMMISSION_FIELD_NUMBER: builtins.int
    ACI_VALUE_FIELD_NUMBER: builtins.int
    FIGI_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    INITIAL_SECURITY_PRICE_FIELD_NUMBER: builtins.int
    ORDER_TYPE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    INITIAL_ORDER_PRICE_PT_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    ORDER_REQUEST_ID_FIELD_NUMBER: builtins.int
    RESPONSE_METADATA_FIELD_NUMBER: builtins.int
    order_id: builtins.str
    """Биржевой идентификатор заявки."""
    execution_report_status: global___OrderExecutionReportStatus.ValueType
    """Текущий статус заявки."""
    lots_requested: builtins.int
    """Запрошено лотов."""
    lots_executed: builtins.int
    """Исполнено лотов."""
    figi: builtins.str
    """Figi-идентификатор инструмента."""
    direction: global___OrderDirection.ValueType
    """Направление сделки."""
    order_type: global___OrderType.ValueType
    """Тип заявки."""
    message: builtins.str
    """Дополнительные данные об исполнении заявки."""
    instrument_uid: builtins.str
    """UID идентификатор инструмента."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    order_request_id: builtins.str
    """Идентификатор ключа идемпотентности, переданный клиентом, в формате UID. Максимальная длина 36 символов."""
    @property
    def initial_order_price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Начальная цена заявки. Произведение количества запрошенных лотов на цену."""

    @property
    def executed_order_price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Исполненная средняя цена одного инструмента в заявке."""

    @property
    def total_order_amount(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Итоговая стоимость заявки, включающая все комиссии."""

    @property
    def initial_commission(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Начальная комиссия. Комиссия рассчитанная при выставлении заявки."""

    @property
    def executed_commission(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Фактическая комиссия по итогам исполнения заявки."""

    @property
    def aci_value(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Значение НКД (накопленного купонного дохода) на дату. Подробнее: [НКД при выставлении торговых поручений](./head-orders#coupon)"""

    @property
    def initial_security_price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Начальная цена за 1 инструмент. Для получения стоимости лота требуется умножить на лотность инструмента."""

    @property
    def initial_order_price_pt(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Начальная цена заявки в пунктах (для фьючерсов)."""

    @property
    def response_metadata(self) -> tinkoff.invest.grpc.common_pb2.ResponseMetadata:
        """Метадата"""

    def __init__(
        self,
        *,
        order_id: builtins.str = ...,
        execution_report_status: global___OrderExecutionReportStatus.ValueType = ...,
        lots_requested: builtins.int = ...,
        lots_executed: builtins.int = ...,
        initial_order_price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        executed_order_price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        total_order_amount: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        initial_commission: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        executed_commission: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        aci_value: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        figi: builtins.str = ...,
        direction: global___OrderDirection.ValueType = ...,
        initial_security_price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        order_type: global___OrderType.ValueType = ...,
        message: builtins.str = ...,
        initial_order_price_pt: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        instrument_uid: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
        order_request_id: builtins.str = ...,
        response_metadata: tinkoff.invest.grpc.common_pb2.ResponseMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["aci_value", b"aci_value", "executed_commission", b"executed_commission", "executed_order_price", b"executed_order_price", "initial_commission", b"initial_commission", "initial_order_price", b"initial_order_price", "initial_order_price_pt", b"initial_order_price_pt", "initial_security_price", b"initial_security_price", "response_metadata", b"response_metadata", "total_order_amount", b"total_order_amount"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["aci_value", b"aci_value", "class_code", b"class_code", "direction", b"direction", "executed_commission", b"executed_commission", "executed_order_price", b"executed_order_price", "execution_report_status", b"execution_report_status", "figi", b"figi", "initial_commission", b"initial_commission", "initial_order_price", b"initial_order_price", "initial_order_price_pt", b"initial_order_price_pt", "initial_security_price", b"initial_security_price", "instrument_uid", b"instrument_uid", "lots_executed", b"lots_executed", "lots_requested", b"lots_requested", "message", b"message", "order_id", b"order_id", "order_request_id", b"order_request_id", "order_type", b"order_type", "response_metadata", b"response_metadata", "ticker", b"ticker", "total_order_amount", b"total_order_amount"]) -> None: ...

global___PostOrderResponse = PostOrderResponse

@typing.final
class PostOrderAsyncRequest(google.protobuf.message.Message):
    """Запрос выставления асинхронного торгового поручения."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    PRICE_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    ORDER_TYPE_FIELD_NUMBER: builtins.int
    ORDER_ID_FIELD_NUMBER: builtins.int
    TIME_IN_FORCE_FIELD_NUMBER: builtins.int
    PRICE_TYPE_FIELD_NUMBER: builtins.int
    CONFIRM_MARGIN_TRADE_FIELD_NUMBER: builtins.int
    instrument_id: builtins.str
    """Идентификатор инструмента, принимает значения Figi или Instrument_uid."""
    quantity: builtins.int
    """Количество лотов."""
    direction: global___OrderDirection.ValueType
    """Направление операции."""
    account_id: builtins.str
    """Номер счета."""
    order_type: global___OrderType.ValueType
    """Тип заявки."""
    order_id: builtins.str
    """Идентификатор запроса выставления поручения для целей идемпотентности в формате UID. Максимальная длина 36 символов."""
    time_in_force: global___TimeInForceType.ValueType
    """Алгоритм исполнения поручения, применяется только к лимитной заявке."""
    price_type: tinkoff.invest.grpc.common_pb2.PriceType.ValueType
    """Тип цены."""
    confirm_margin_trade: builtins.bool
    """Согласие на выставление заявки, которая может привести к непокрытой позиции, по умолчанию false."""
    @property
    def price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена за 1 инструмент. Для получения стоимости лота требуется умножить на лотность инструмента. Игнорируется для рыночных поручений."""

    def __init__(
        self,
        *,
        instrument_id: builtins.str = ...,
        quantity: builtins.int = ...,
        price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        direction: global___OrderDirection.ValueType = ...,
        account_id: builtins.str = ...,
        order_type: global___OrderType.ValueType = ...,
        order_id: builtins.str = ...,
        time_in_force: global___TimeInForceType.ValueType | None = ...,
        price_type: tinkoff.invest.grpc.common_pb2.PriceType.ValueType | None = ...,
        confirm_margin_trade: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_price", b"_price", "_price_type", b"_price_type", "_time_in_force", b"_time_in_force", "price", b"price", "price_type", b"price_type", "time_in_force", b"time_in_force"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_price", b"_price", "_price_type", b"_price_type", "_time_in_force", b"_time_in_force", "account_id", b"account_id", "confirm_margin_trade", b"confirm_margin_trade", "direction", b"direction", "instrument_id", b"instrument_id", "order_id", b"order_id", "order_type", b"order_type", "price", b"price", "price_type", b"price_type", "quantity", b"quantity", "time_in_force", b"time_in_force"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_price", b"_price"]) -> typing.Literal["price"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_price_type", b"_price_type"]) -> typing.Literal["price_type"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_time_in_force", b"_time_in_force"]) -> typing.Literal["time_in_force"] | None: ...

global___PostOrderAsyncRequest = PostOrderAsyncRequest

@typing.final
class PostOrderAsyncResponse(google.protobuf.message.Message):
    """Результат выставления асинхронного торгового поручения."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORDER_REQUEST_ID_FIELD_NUMBER: builtins.int
    EXECUTION_REPORT_STATUS_FIELD_NUMBER: builtins.int
    TRADE_INTENT_ID_FIELD_NUMBER: builtins.int
    order_request_id: builtins.str
    """Идентификатор ключа идемпотентности, переданный клиентом, в формате UID. Максимальная длина 36 символов."""
    execution_report_status: global___OrderExecutionReportStatus.ValueType
    """Текущий статус заявки."""
    trade_intent_id: builtins.str
    """Идентификатор торгового поручения."""
    def __init__(
        self,
        *,
        order_request_id: builtins.str = ...,
        execution_report_status: global___OrderExecutionReportStatus.ValueType = ...,
        trade_intent_id: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_trade_intent_id", b"_trade_intent_id", "trade_intent_id", b"trade_intent_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_trade_intent_id", b"_trade_intent_id", "execution_report_status", b"execution_report_status", "order_request_id", b"order_request_id", "trade_intent_id", b"trade_intent_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_trade_intent_id", b"_trade_intent_id"]) -> typing.Literal["trade_intent_id"] | None: ...

global___PostOrderAsyncResponse = PostOrderAsyncResponse

@typing.final
class CancelOrderRequest(google.protobuf.message.Message):
    """Запрос отмены торгового поручения."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    ORDER_ID_FIELD_NUMBER: builtins.int
    ORDER_ID_TYPE_FIELD_NUMBER: builtins.int
    account_id: builtins.str
    """Номер счета."""
    order_id: builtins.str
    """Идентификатор заявки."""
    order_id_type: global___OrderIdType.ValueType
    """Тип идентификатора заявки."""
    def __init__(
        self,
        *,
        account_id: builtins.str = ...,
        order_id: builtins.str = ...,
        order_id_type: global___OrderIdType.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_order_id_type", b"_order_id_type", "order_id_type", b"order_id_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_order_id_type", b"_order_id_type", "account_id", b"account_id", "order_id", b"order_id", "order_id_type", b"order_id_type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_order_id_type", b"_order_id_type"]) -> typing.Literal["order_id_type"] | None: ...

global___CancelOrderRequest = CancelOrderRequest

@typing.final
class CancelOrderResponse(google.protobuf.message.Message):
    """Результат отмены торгового поручения."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIME_FIELD_NUMBER: builtins.int
    RESPONSE_METADATA_FIELD_NUMBER: builtins.int
    @property
    def time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата и время отмены заявки в часовом поясе UTC."""

    @property
    def response_metadata(self) -> tinkoff.invest.grpc.common_pb2.ResponseMetadata:
        """Метадата"""

    def __init__(
        self,
        *,
        time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        response_metadata: tinkoff.invest.grpc.common_pb2.ResponseMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["response_metadata", b"response_metadata", "time", b"time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["response_metadata", b"response_metadata", "time", b"time"]) -> None: ...

global___CancelOrderResponse = CancelOrderResponse

@typing.final
class GetOrderStateRequest(google.protobuf.message.Message):
    """Запрос получения статуса торгового поручения."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    ORDER_ID_FIELD_NUMBER: builtins.int
    PRICE_TYPE_FIELD_NUMBER: builtins.int
    ORDER_ID_TYPE_FIELD_NUMBER: builtins.int
    account_id: builtins.str
    """Номер счета."""
    order_id: builtins.str
    """Идентификатор заявки."""
    price_type: tinkoff.invest.grpc.common_pb2.PriceType.ValueType
    """Тип цены."""
    order_id_type: global___OrderIdType.ValueType
    """Тип идентификатора заявки."""
    def __init__(
        self,
        *,
        account_id: builtins.str = ...,
        order_id: builtins.str = ...,
        price_type: tinkoff.invest.grpc.common_pb2.PriceType.ValueType = ...,
        order_id_type: global___OrderIdType.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_order_id_type", b"_order_id_type", "order_id_type", b"order_id_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_order_id_type", b"_order_id_type", "account_id", b"account_id", "order_id", b"order_id", "order_id_type", b"order_id_type", "price_type", b"price_type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_order_id_type", b"_order_id_type"]) -> typing.Literal["order_id_type"] | None: ...

global___GetOrderStateRequest = GetOrderStateRequest

@typing.final
class GetOrdersRequest(google.protobuf.message.Message):
    """Запрос получения списка активных торговых поручений."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class GetOrdersRequestFilters(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        FROM_FIELD_NUMBER: builtins.int
        TO_FIELD_NUMBER: builtins.int
        EXECUTION_STATUS_FIELD_NUMBER: builtins.int
        @property
        def to(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Дата и время, до которой нужно получить информацию в часовом поясе UTC. Параметр применим только к ордерам, созданным сегодня."""

        @property
        def execution_status(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___OrderExecutionReportStatus.ValueType]:
            """Статусы заявок."""

        def __init__(
            self,
            *,
            to: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            execution_status: collections.abc.Iterable[global___OrderExecutionReportStatus.ValueType] | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["_from", b"_from", "_to", b"_to", "from", b"from", "to", b"to"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["_from", b"_from", "_to", b"_to", "execution_status", b"execution_status", "from", b"from", "to", b"to"]) -> None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing.Literal["_from", b"_from"]) -> typing.Literal["from"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing.Literal["_to", b"_to"]) -> typing.Literal["to"] | None: ...

    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    ADVANCED_FILTERS_FIELD_NUMBER: builtins.int
    account_id: builtins.str
    """Номер счета."""
    @property
    def advanced_filters(self) -> global___GetOrdersRequest.GetOrdersRequestFilters:
        """Дополнительные фильтры."""

    def __init__(
        self,
        *,
        account_id: builtins.str = ...,
        advanced_filters: global___GetOrdersRequest.GetOrdersRequestFilters | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_advanced_filters", b"_advanced_filters", "advanced_filters", b"advanced_filters"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_advanced_filters", b"_advanced_filters", "account_id", b"account_id", "advanced_filters", b"advanced_filters"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_advanced_filters", b"_advanced_filters"]) -> typing.Literal["advanced_filters"] | None: ...

global___GetOrdersRequest = GetOrdersRequest

@typing.final
class GetOrdersResponse(google.protobuf.message.Message):
    """Список активных торговых поручений."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORDERS_FIELD_NUMBER: builtins.int
    @property
    def orders(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OrderState]:
        """Массив активных заявок."""

    def __init__(
        self,
        *,
        orders: collections.abc.Iterable[global___OrderState] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["orders", b"orders"]) -> None: ...

global___GetOrdersResponse = GetOrdersResponse

@typing.final
class OrderState(google.protobuf.message.Message):
    """Информация о торговом поручении."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORDER_ID_FIELD_NUMBER: builtins.int
    EXECUTION_REPORT_STATUS_FIELD_NUMBER: builtins.int
    LOTS_REQUESTED_FIELD_NUMBER: builtins.int
    LOTS_EXECUTED_FIELD_NUMBER: builtins.int
    INITIAL_ORDER_PRICE_FIELD_NUMBER: builtins.int
    EXECUTED_ORDER_PRICE_FIELD_NUMBER: builtins.int
    TOTAL_ORDER_AMOUNT_FIELD_NUMBER: builtins.int
    AVERAGE_POSITION_PRICE_FIELD_NUMBER: builtins.int
    INITIAL_COMMISSION_FIELD_NUMBER: builtins.int
    EXECUTED_COMMISSION_FIELD_NUMBER: builtins.int
    FIGI_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    INITIAL_SECURITY_PRICE_FIELD_NUMBER: builtins.int
    STAGES_FIELD_NUMBER: builtins.int
    SERVICE_COMMISSION_FIELD_NUMBER: builtins.int
    CURRENCY_FIELD_NUMBER: builtins.int
    ORDER_TYPE_FIELD_NUMBER: builtins.int
    ORDER_DATE_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    ORDER_REQUEST_ID_FIELD_NUMBER: builtins.int
    TICKER_FIELD_NUMBER: builtins.int
    CLASS_CODE_FIELD_NUMBER: builtins.int
    order_id: builtins.str
    """Биржевой идентификатор заявки."""
    execution_report_status: global___OrderExecutionReportStatus.ValueType
    """Текущий статус заявки."""
    lots_requested: builtins.int
    """Запрошено лотов."""
    lots_executed: builtins.int
    """Исполнено лотов."""
    figi: builtins.str
    """Figi-идентификатор инструмента."""
    direction: global___OrderDirection.ValueType
    """Направление заявки."""
    currency: builtins.str
    """Валюта заявки."""
    order_type: global___OrderType.ValueType
    """Тип заявки."""
    instrument_uid: builtins.str
    """UID идентификатор инструмента."""
    order_request_id: builtins.str
    """Идентификатор ключа идемпотентности, переданный клиентом, в формате UID. Максимальная длина 36 символов."""
    ticker: builtins.str
    """Тикер инструмента."""
    class_code: builtins.str
    """Класс-код (секция торгов)."""
    @property
    def initial_order_price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Начальная цена заявки. Произведение количества запрошенных лотов на цену."""

    @property
    def executed_order_price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Исполненная цена заявки. Произведение средней цены покупки на количество лотов."""

    @property
    def total_order_amount(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Итоговая стоимость заявки, включающая все комиссии."""

    @property
    def average_position_price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Средняя цена позиции по сделке."""

    @property
    def initial_commission(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Начальная комиссия. Комиссия, рассчитанная на момент подачи заявки."""

    @property
    def executed_commission(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Фактическая комиссия по итогам исполнения заявки."""

    @property
    def initial_security_price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Начальная цена за 1 инструмент. Для получения стоимости лота требуется умножить на лотность инструмента."""

    @property
    def stages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OrderStage]:
        """Стадии выполнения заявки."""

    @property
    def service_commission(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Сервисная комиссия."""

    @property
    def order_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата и время выставления заявки в часовом поясе UTC."""

    def __init__(
        self,
        *,
        order_id: builtins.str = ...,
        execution_report_status: global___OrderExecutionReportStatus.ValueType = ...,
        lots_requested: builtins.int = ...,
        lots_executed: builtins.int = ...,
        initial_order_price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        executed_order_price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        total_order_amount: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        average_position_price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        initial_commission: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        executed_commission: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        figi: builtins.str = ...,
        direction: global___OrderDirection.ValueType = ...,
        initial_security_price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        stages: collections.abc.Iterable[global___OrderStage] | None = ...,
        service_commission: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        currency: builtins.str = ...,
        order_type: global___OrderType.ValueType = ...,
        order_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        instrument_uid: builtins.str = ...,
        order_request_id: builtins.str = ...,
        ticker: builtins.str = ...,
        class_code: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["average_position_price", b"average_position_price", "executed_commission", b"executed_commission", "executed_order_price", b"executed_order_price", "initial_commission", b"initial_commission", "initial_order_price", b"initial_order_price", "initial_security_price", b"initial_security_price", "order_date", b"order_date", "service_commission", b"service_commission", "total_order_amount", b"total_order_amount"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["average_position_price", b"average_position_price", "class_code", b"class_code", "currency", b"currency", "direction", b"direction", "executed_commission", b"executed_commission", "executed_order_price", b"executed_order_price", "execution_report_status", b"execution_report_status", "figi", b"figi", "initial_commission", b"initial_commission", "initial_order_price", b"initial_order_price", "initial_security_price", b"initial_security_price", "instrument_uid", b"instrument_uid", "lots_executed", b"lots_executed", "lots_requested", b"lots_requested", "order_date", b"order_date", "order_id", b"order_id", "order_request_id", b"order_request_id", "order_type", b"order_type", "service_commission", b"service_commission", "stages", b"stages", "ticker", b"ticker", "total_order_amount", b"total_order_amount"]) -> None: ...

global___OrderState = OrderState

@typing.final
class OrderStage(google.protobuf.message.Message):
    """Сделки в рамках торгового поручения."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PRICE_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    TRADE_ID_FIELD_NUMBER: builtins.int
    EXECUTION_TIME_FIELD_NUMBER: builtins.int
    quantity: builtins.int
    """Количество лотов."""
    trade_id: builtins.str
    """Идентификатор сделки."""
    @property
    def price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Цена за 1 инструмент. Для получения стоимости лота требуется умножить на лотность инструмента."""

    @property
    def execution_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Время исполнения сделки"""

    def __init__(
        self,
        *,
        price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        quantity: builtins.int = ...,
        trade_id: builtins.str = ...,
        execution_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["execution_time", b"execution_time", "price", b"price"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["execution_time", b"execution_time", "price", b"price", "quantity", b"quantity", "trade_id", b"trade_id"]) -> None: ...

global___OrderStage = OrderStage

@typing.final
class ReplaceOrderRequest(google.protobuf.message.Message):
    """Запрос изменения выставленной заявки."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    ORDER_ID_FIELD_NUMBER: builtins.int
    IDEMPOTENCY_KEY_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    PRICE_FIELD_NUMBER: builtins.int
    PRICE_TYPE_FIELD_NUMBER: builtins.int
    CONFIRM_MARGIN_TRADE_FIELD_NUMBER: builtins.int
    account_id: builtins.str
    """Номер счета."""
    order_id: builtins.str
    """Идентификатор заявки на бирже."""
    idempotency_key: builtins.str
    """Новый идентификатор запроса выставления поручения для целей идемпотентности. Максимальная длина 36 символов. Перезатирает старый ключ."""
    quantity: builtins.int
    """Количество лотов."""
    price_type: tinkoff.invest.grpc.common_pb2.PriceType.ValueType
    """Тип цены."""
    confirm_margin_trade: builtins.bool
    """Согласие на выставление заявки, которая может привести к непокрытой позиции, по умолчанию false."""
    @property
    def price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена за 1 инструмент."""

    def __init__(
        self,
        *,
        account_id: builtins.str = ...,
        order_id: builtins.str = ...,
        idempotency_key: builtins.str = ...,
        quantity: builtins.int = ...,
        price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        price_type: tinkoff.invest.grpc.common_pb2.PriceType.ValueType | None = ...,
        confirm_margin_trade: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_price", b"_price", "_price_type", b"_price_type", "price", b"price", "price_type", b"price_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_price", b"_price", "_price_type", b"_price_type", "account_id", b"account_id", "confirm_margin_trade", b"confirm_margin_trade", "idempotency_key", b"idempotency_key", "order_id", b"order_id", "price", b"price", "price_type", b"price_type", "quantity", b"quantity"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_price", b"_price"]) -> typing.Literal["price"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_price_type", b"_price_type"]) -> typing.Literal["price_type"] | None: ...

global___ReplaceOrderRequest = ReplaceOrderRequest

@typing.final
class GetMaxLotsRequest(google.protobuf.message.Message):
    """Запрос на расчет количества доступных для покупки/продажи лотов. Если не указывать цену инструмента, то расчет произведется по текущум ценам в стакане: по лучшему предложению для покупки и по лучшему спросу для продажи."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    PRICE_FIELD_NUMBER: builtins.int
    account_id: builtins.str
    """Номер счета"""
    instrument_id: builtins.str
    """Идентификатор инструмента, принимает значения Figi или instrument_uid"""
    @property
    def price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена инструмента"""

    def __init__(
        self,
        *,
        account_id: builtins.str = ...,
        instrument_id: builtins.str = ...,
        price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_price", b"_price", "price", b"price"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_price", b"_price", "account_id", b"account_id", "instrument_id", b"instrument_id", "price", b"price"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_price", b"_price"]) -> typing.Literal["price"] | None: ...

global___GetMaxLotsRequest = GetMaxLotsRequest

@typing.final
class GetMaxLotsResponse(google.protobuf.message.Message):
    """Результат количество доступных для покупки/продажи лотов"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class BuyLimitsView(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        BUY_MONEY_AMOUNT_FIELD_NUMBER: builtins.int
        BUY_MAX_LOTS_FIELD_NUMBER: builtins.int
        BUY_MAX_MARKET_LOTS_FIELD_NUMBER: builtins.int
        buy_max_lots: builtins.int
        """Максимальное доступное количество лотов для покупки"""
        buy_max_market_lots: builtins.int
        """Максимальное доступное количество лотов для покупки для заявки по рыночной цене на текущий момент"""
        @property
        def buy_money_amount(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Количество доступной валюты для покупки"""

        def __init__(
            self,
            *,
            buy_money_amount: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
            buy_max_lots: builtins.int = ...,
            buy_max_market_lots: builtins.int = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["buy_money_amount", b"buy_money_amount"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["buy_max_lots", b"buy_max_lots", "buy_max_market_lots", b"buy_max_market_lots", "buy_money_amount", b"buy_money_amount"]) -> None: ...

    @typing.final
    class SellLimitsView(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SELL_MAX_LOTS_FIELD_NUMBER: builtins.int
        sell_max_lots: builtins.int
        """Максимальное доступное количество лотов для продажи"""
        def __init__(
            self,
            *,
            sell_max_lots: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["sell_max_lots", b"sell_max_lots"]) -> None: ...

    CURRENCY_FIELD_NUMBER: builtins.int
    BUY_LIMITS_FIELD_NUMBER: builtins.int
    BUY_MARGIN_LIMITS_FIELD_NUMBER: builtins.int
    SELL_LIMITS_FIELD_NUMBER: builtins.int
    SELL_MARGIN_LIMITS_FIELD_NUMBER: builtins.int
    currency: builtins.str
    """Валюта инструмента"""
    @property
    def buy_limits(self) -> global___GetMaxLotsResponse.BuyLimitsView:
        """Лимиты для покупок на собственные деньги"""

    @property
    def buy_margin_limits(self) -> global___GetMaxLotsResponse.BuyLimitsView:
        """Лимиты для покупок с учетом маржинального кредитования"""

    @property
    def sell_limits(self) -> global___GetMaxLotsResponse.SellLimitsView:
        """Лимиты для продаж по собственной позиции"""

    @property
    def sell_margin_limits(self) -> global___GetMaxLotsResponse.SellLimitsView:
        """Лимиты для продаж с учетом маржинального кредитования"""

    def __init__(
        self,
        *,
        currency: builtins.str = ...,
        buy_limits: global___GetMaxLotsResponse.BuyLimitsView | None = ...,
        buy_margin_limits: global___GetMaxLotsResponse.BuyLimitsView | None = ...,
        sell_limits: global___GetMaxLotsResponse.SellLimitsView | None = ...,
        sell_margin_limits: global___GetMaxLotsResponse.SellLimitsView | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["buy_limits", b"buy_limits", "buy_margin_limits", b"buy_margin_limits", "sell_limits", b"sell_limits", "sell_margin_limits", b"sell_margin_limits"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["buy_limits", b"buy_limits", "buy_margin_limits", b"buy_margin_limits", "currency", b"currency", "sell_limits", b"sell_limits", "sell_margin_limits", b"sell_margin_limits"]) -> None: ...

global___GetMaxLotsResponse = GetMaxLotsResponse

@typing.final
class GetOrderPriceRequest(google.protobuf.message.Message):
    """Запрос получения предварительной стоимости заявки"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    INSTRUMENT_ID_FIELD_NUMBER: builtins.int
    PRICE_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    account_id: builtins.str
    """Номер счета"""
    instrument_id: builtins.str
    """Идентификатор инструмента, принимает значения Figi или instrument_uid"""
    direction: global___OrderDirection.ValueType
    """Направление заявки"""
    quantity: builtins.int
    """Количество лотов"""
    @property
    def price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена инструмента"""

    def __init__(
        self,
        *,
        account_id: builtins.str = ...,
        instrument_id: builtins.str = ...,
        price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        direction: global___OrderDirection.ValueType = ...,
        quantity: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["price", b"price"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["account_id", b"account_id", "direction", b"direction", "instrument_id", b"instrument_id", "price", b"price", "quantity", b"quantity"]) -> None: ...

global___GetOrderPriceRequest = GetOrderPriceRequest

@typing.final
class GetOrderPriceResponse(google.protobuf.message.Message):
    """Предварительная стоимость заявки"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ExtraBond(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ACI_VALUE_FIELD_NUMBER: builtins.int
        NOMINAL_CONVERSION_RATE_FIELD_NUMBER: builtins.int
        @property
        def aci_value(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
            """Значение НКД (накопленного купонного дохода) на дату"""

        @property
        def nominal_conversion_rate(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
            """Курс конвертации для замещающих облигаций"""

        def __init__(
            self,
            *,
            aci_value: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
            nominal_conversion_rate: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["aci_value", b"aci_value", "nominal_conversion_rate", b"nominal_conversion_rate"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["aci_value", b"aci_value", "nominal_conversion_rate", b"nominal_conversion_rate"]) -> None: ...

    @typing.final
    class ExtraFuture(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        INITIAL_MARGIN_FIELD_NUMBER: builtins.int
        @property
        def initial_margin(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
            """Гарантийное обеспечение для фьючерса"""

        def __init__(
            self,
            *,
            initial_margin: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["initial_margin", b"initial_margin"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["initial_margin", b"initial_margin"]) -> None: ...

    TOTAL_ORDER_AMOUNT_FIELD_NUMBER: builtins.int
    INITIAL_ORDER_AMOUNT_FIELD_NUMBER: builtins.int
    LOTS_REQUESTED_FIELD_NUMBER: builtins.int
    EXECUTED_COMMISSION_FIELD_NUMBER: builtins.int
    EXECUTED_COMMISSION_RUB_FIELD_NUMBER: builtins.int
    SERVICE_COMMISSION_FIELD_NUMBER: builtins.int
    DEAL_COMMISSION_FIELD_NUMBER: builtins.int
    EXTRA_BOND_FIELD_NUMBER: builtins.int
    EXTRA_FUTURE_FIELD_NUMBER: builtins.int
    lots_requested: builtins.int
    """Запрошено лотов"""
    @property
    def total_order_amount(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Итоговая стоимость заявки"""

    @property
    def initial_order_amount(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Стоимость заявки без комиссий, НКД, ГО (для фьючерсов — стоимость контрактов)"""

    @property
    def executed_commission(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Общая комиссия"""

    @property
    def executed_commission_rub(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Общая комиссия в рублях"""

    @property
    def service_commission(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Сервисная комиссия"""

    @property
    def deal_commission(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Комиссия за проведение сделки"""

    @property
    def extra_bond(self) -> global___GetOrderPriceResponse.ExtraBond:
        """Дополнительная информация по облигациям"""

    @property
    def extra_future(self) -> global___GetOrderPriceResponse.ExtraFuture:
        """Дополнительная информация по фьючерсам"""

    def __init__(
        self,
        *,
        total_order_amount: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        initial_order_amount: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        lots_requested: builtins.int = ...,
        executed_commission: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        executed_commission_rub: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        service_commission: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        deal_commission: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
        extra_bond: global___GetOrderPriceResponse.ExtraBond | None = ...,
        extra_future: global___GetOrderPriceResponse.ExtraFuture | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["deal_commission", b"deal_commission", "executed_commission", b"executed_commission", "executed_commission_rub", b"executed_commission_rub", "extra_bond", b"extra_bond", "extra_future", b"extra_future", "initial_order_amount", b"initial_order_amount", "instrument_extra", b"instrument_extra", "service_commission", b"service_commission", "total_order_amount", b"total_order_amount"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["deal_commission", b"deal_commission", "executed_commission", b"executed_commission", "executed_commission_rub", b"executed_commission_rub", "extra_bond", b"extra_bond", "extra_future", b"extra_future", "initial_order_amount", b"initial_order_amount", "instrument_extra", b"instrument_extra", "lots_requested", b"lots_requested", "service_commission", b"service_commission", "total_order_amount", b"total_order_amount"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["instrument_extra", b"instrument_extra"]) -> typing.Literal["extra_bond", "extra_future"] | None: ...

global___GetOrderPriceResponse = GetOrderPriceResponse

@typing.final
class OrderStateStreamRequest(google.protobuf.message.Message):
    """Запрос установки стрим-соединения торговых поручений"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNTS_FIELD_NUMBER: builtins.int
    PING_DELAY_MILLIS_FIELD_NUMBER: builtins.int
    ping_delay_millis: builtins.int
    """Задержка (пинг) сообщений:  1000-120 000 миллисекунд. Значение по умолчанию — 120 000."""
    @property
    def accounts(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Идентификаторы счетов."""

    def __init__(
        self,
        *,
        accounts: collections.abc.Iterable[builtins.str] | None = ...,
        ping_delay_millis: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_ping_delay_millis", b"_ping_delay_millis", "ping_delay_millis", b"ping_delay_millis"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_ping_delay_millis", b"_ping_delay_millis", "accounts", b"accounts", "ping_delay_millis", b"ping_delay_millis"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_ping_delay_millis", b"_ping_delay_millis"]) -> typing.Literal["ping_delay_millis"] | None: ...

global___OrderStateStreamRequest = OrderStateStreamRequest

@typing.final
class SubscriptionResponse(google.protobuf.message.Message):
    """Информация по подпискам"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRACKING_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    STREAM_ID_FIELD_NUMBER: builtins.int
    ACCOUNTS_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    tracking_id: builtins.str
    """Уникальный идентификатор запроса, подробнее: [tracking_id](./grpc#tracking-id)."""
    status: tinkoff.invest.grpc.common_pb2.ResultSubscriptionStatus.ValueType
    """Статус подписки."""
    stream_id: builtins.str
    """Идентификатор открытого соединения"""
    @property
    def accounts(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Идентификаторы счетов."""

    @property
    def error(self) -> tinkoff.invest.grpc.common_pb2.ErrorDetail: ...
    def __init__(
        self,
        *,
        tracking_id: builtins.str = ...,
        status: tinkoff.invest.grpc.common_pb2.ResultSubscriptionStatus.ValueType = ...,
        stream_id: builtins.str = ...,
        accounts: collections.abc.Iterable[builtins.str] | None = ...,
        error: tinkoff.invest.grpc.common_pb2.ErrorDetail | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_error", b"_error", "error", b"error"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_error", b"_error", "accounts", b"accounts", "error", b"error", "status", b"status", "stream_id", b"stream_id", "tracking_id", b"tracking_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_error", b"_error"]) -> typing.Literal["error"] | None: ...

global___SubscriptionResponse = SubscriptionResponse

@typing.final
class OrderStateStreamResponse(google.protobuf.message.Message):
    """Информация по заявкам"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _MarkerType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _MarkerTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[OrderStateStreamResponse._MarkerType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MARKER_UNKNOWN: OrderStateStreamResponse._MarkerType.ValueType  # 0
        """не определено"""
        MARKER_BROKER: OrderStateStreamResponse._MarkerType.ValueType  # 1
        """сделки брокера"""
        MARKER_CHAT: OrderStateStreamResponse._MarkerType.ValueType  # 2
        """исполнение поручение, полученного от клиента через каналы связи"""
        MARKER_PAPER: OrderStateStreamResponse._MarkerType.ValueType  # 3
        """исполнение поручение, полученного от клиента в бумажной форме"""
        MARKER_MARGIN: OrderStateStreamResponse._MarkerType.ValueType  # 4
        """принудительное закрытие позиций"""
        MARKER_TKBNM: OrderStateStreamResponse._MarkerType.ValueType  # 5
        """сделки по управлению ликвидностью"""
        MARKER_SHORT: OrderStateStreamResponse._MarkerType.ValueType  # 6
        """сделки РЕПО по привлечению у клиентов бумаг"""
        MARKER_SPECMM: OrderStateStreamResponse._MarkerType.ValueType  # 7
        """перенос временно непокрытых позиций"""
        MARKER_PO: OrderStateStreamResponse._MarkerType.ValueType  # 8

    class MarkerType(_MarkerType, metaclass=_MarkerTypeEnumTypeWrapper):
        """Маркер"""

    MARKER_UNKNOWN: OrderStateStreamResponse.MarkerType.ValueType  # 0
    """не определено"""
    MARKER_BROKER: OrderStateStreamResponse.MarkerType.ValueType  # 1
    """сделки брокера"""
    MARKER_CHAT: OrderStateStreamResponse.MarkerType.ValueType  # 2
    """исполнение поручение, полученного от клиента через каналы связи"""
    MARKER_PAPER: OrderStateStreamResponse.MarkerType.ValueType  # 3
    """исполнение поручение, полученного от клиента в бумажной форме"""
    MARKER_MARGIN: OrderStateStreamResponse.MarkerType.ValueType  # 4
    """принудительное закрытие позиций"""
    MARKER_TKBNM: OrderStateStreamResponse.MarkerType.ValueType  # 5
    """сделки по управлению ликвидностью"""
    MARKER_SHORT: OrderStateStreamResponse.MarkerType.ValueType  # 6
    """сделки РЕПО по привлечению у клиентов бумаг"""
    MARKER_SPECMM: OrderStateStreamResponse.MarkerType.ValueType  # 7
    """перенос временно непокрытых позиций"""
    MARKER_PO: OrderStateStreamResponse.MarkerType.ValueType  # 8

    class _StatusCauseInfo:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusCauseInfoEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[OrderStateStreamResponse._StatusCauseInfo.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        CAUSE_UNSPECIFIED: OrderStateStreamResponse._StatusCauseInfo.ValueType  # 0
        """Не определено"""
        CAUSE_CANCELLED_BY_CLIENT: OrderStateStreamResponse._StatusCauseInfo.ValueType  # 15
        """Отменено клиентом"""
        CAUSE_CANCELLED_BY_EXCHANGE: OrderStateStreamResponse._StatusCauseInfo.ValueType  # 1
        """Отменено биржей"""
        CAUSE_CANCELLED_NOT_ENOUGH_POSITION: OrderStateStreamResponse._StatusCauseInfo.ValueType  # 2
        """Заявка не выставлена из-за нехватки средств"""
        CAUSE_CANCELLED_BY_CLIENT_BLOCK: OrderStateStreamResponse._StatusCauseInfo.ValueType  # 3
        """Отменено из-за блокировки клиента"""
        CAUSE_REJECTED_BY_BROKER: OrderStateStreamResponse._StatusCauseInfo.ValueType  # 4
        """Отклонено брокером"""
        CAUSE_REJECTED_BY_EXCHANGE: OrderStateStreamResponse._StatusCauseInfo.ValueType  # 5
        """Отклонено биржей"""
        CAUSE_CANCELLED_BY_BROKER: OrderStateStreamResponse._StatusCauseInfo.ValueType  # 6
        """Отменено брокером"""

    class StatusCauseInfo(_StatusCauseInfo, metaclass=_StatusCauseInfoEnumTypeWrapper):
        """Дополнительная информация по статусу заявки"""

    CAUSE_UNSPECIFIED: OrderStateStreamResponse.StatusCauseInfo.ValueType  # 0
    """Не определено"""
    CAUSE_CANCELLED_BY_CLIENT: OrderStateStreamResponse.StatusCauseInfo.ValueType  # 15
    """Отменено клиентом"""
    CAUSE_CANCELLED_BY_EXCHANGE: OrderStateStreamResponse.StatusCauseInfo.ValueType  # 1
    """Отменено биржей"""
    CAUSE_CANCELLED_NOT_ENOUGH_POSITION: OrderStateStreamResponse.StatusCauseInfo.ValueType  # 2
    """Заявка не выставлена из-за нехватки средств"""
    CAUSE_CANCELLED_BY_CLIENT_BLOCK: OrderStateStreamResponse.StatusCauseInfo.ValueType  # 3
    """Отменено из-за блокировки клиента"""
    CAUSE_REJECTED_BY_BROKER: OrderStateStreamResponse.StatusCauseInfo.ValueType  # 4
    """Отклонено брокером"""
    CAUSE_REJECTED_BY_EXCHANGE: OrderStateStreamResponse.StatusCauseInfo.ValueType  # 5
    """Отклонено биржей"""
    CAUSE_CANCELLED_BY_BROKER: OrderStateStreamResponse.StatusCauseInfo.ValueType  # 6
    """Отменено брокером"""

    @typing.final
    class OrderState(google.protobuf.message.Message):
        """Заявка"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ORDER_ID_FIELD_NUMBER: builtins.int
        ORDER_REQUEST_ID_FIELD_NUMBER: builtins.int
        CLIENT_CODE_FIELD_NUMBER: builtins.int
        CREATED_AT_FIELD_NUMBER: builtins.int
        EXECUTION_REPORT_STATUS_FIELD_NUMBER: builtins.int
        STATUS_INFO_FIELD_NUMBER: builtins.int
        TICKER_FIELD_NUMBER: builtins.int
        CLASS_CODE_FIELD_NUMBER: builtins.int
        LOT_SIZE_FIELD_NUMBER: builtins.int
        DIRECTION_FIELD_NUMBER: builtins.int
        TIME_IN_FORCE_FIELD_NUMBER: builtins.int
        ORDER_TYPE_FIELD_NUMBER: builtins.int
        ACCOUNT_ID_FIELD_NUMBER: builtins.int
        INITIAL_ORDER_PRICE_FIELD_NUMBER: builtins.int
        ORDER_PRICE_FIELD_NUMBER: builtins.int
        AMOUNT_FIELD_NUMBER: builtins.int
        EXECUTED_ORDER_PRICE_FIELD_NUMBER: builtins.int
        CURRENCY_FIELD_NUMBER: builtins.int
        LOTS_REQUESTED_FIELD_NUMBER: builtins.int
        LOTS_EXECUTED_FIELD_NUMBER: builtins.int
        LOTS_LEFT_FIELD_NUMBER: builtins.int
        LOTS_CANCELLED_FIELD_NUMBER: builtins.int
        MARKER_FIELD_NUMBER: builtins.int
        TRADES_FIELD_NUMBER: builtins.int
        COMPLETION_TIME_FIELD_NUMBER: builtins.int
        EXCHANGE_FIELD_NUMBER: builtins.int
        INSTRUMENT_UID_FIELD_NUMBER: builtins.int
        order_id: builtins.str
        """Биржевой идентификатор заявки."""
        order_request_id: builtins.str
        """Идентификатор ключа идемпотентности, переданный клиентом, в формате UID. Максимальная длина 36 символов."""
        client_code: builtins.str
        """Код клиента на бирже."""
        execution_report_status: global___OrderExecutionReportStatus.ValueType
        """Статус заявки."""
        status_info: global___OrderStateStreamResponse.StatusCauseInfo.ValueType
        """Дополнительная информация по статусу."""
        ticker: builtins.str
        """Тикер инструмента."""
        class_code: builtins.str
        """Класс-код (секция торгов)."""
        lot_size: builtins.int
        """Лотность инструмента заявки."""
        direction: global___OrderDirection.ValueType
        """Направление заявки."""
        time_in_force: global___TimeInForceType.ValueType
        """Алгоритм исполнения поручения."""
        order_type: global___OrderType.ValueType
        """Тип заявки."""
        account_id: builtins.str
        """Номер счета."""
        currency: builtins.str
        """Валюта исполнения."""
        lots_requested: builtins.int
        """Запрошено лотов."""
        lots_executed: builtins.int
        """Исполнено лотов."""
        lots_left: builtins.int
        """Число неисполненных лотов по заявке."""
        lots_cancelled: builtins.int
        """Отмененные лоты."""
        marker: global___OrderStateStreamResponse.MarkerType.ValueType
        """Спецсимвол."""
        exchange: builtins.str
        """Код биржи."""
        instrument_uid: builtins.str
        """UID идентификатор инструмента."""
        @property
        def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Дата создания заявки."""

        @property
        def initial_order_price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
            """Начальная цена заявки."""

        @property
        def order_price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
            """Цена выставления заявки."""

        @property
        def amount(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
            """Предрассчитанная стоимость полной заявки."""

        @property
        def executed_order_price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
            """Исполненная цена заявки."""

        @property
        def trades(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OrderTrade]:
            """	Список сделок."""

        @property
        def completion_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Время исполнения заявки."""

        def __init__(
            self,
            *,
            order_id: builtins.str = ...,
            order_request_id: builtins.str | None = ...,
            client_code: builtins.str = ...,
            created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            execution_report_status: global___OrderExecutionReportStatus.ValueType = ...,
            status_info: global___OrderStateStreamResponse.StatusCauseInfo.ValueType | None = ...,
            ticker: builtins.str = ...,
            class_code: builtins.str = ...,
            lot_size: builtins.int = ...,
            direction: global___OrderDirection.ValueType = ...,
            time_in_force: global___TimeInForceType.ValueType = ...,
            order_type: global___OrderType.ValueType = ...,
            account_id: builtins.str = ...,
            initial_order_price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
            order_price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
            amount: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
            executed_order_price: tinkoff.invest.grpc.common_pb2.MoneyValue | None = ...,
            currency: builtins.str = ...,
            lots_requested: builtins.int = ...,
            lots_executed: builtins.int = ...,
            lots_left: builtins.int = ...,
            lots_cancelled: builtins.int = ...,
            marker: global___OrderStateStreamResponse.MarkerType.ValueType | None = ...,
            trades: collections.abc.Iterable[global___OrderTrade] | None = ...,
            completion_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            exchange: builtins.str = ...,
            instrument_uid: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["_amount", b"_amount", "_marker", b"_marker", "_order_request_id", b"_order_request_id", "_status_info", b"_status_info", "amount", b"amount", "completion_time", b"completion_time", "created_at", b"created_at", "executed_order_price", b"executed_order_price", "initial_order_price", b"initial_order_price", "marker", b"marker", "order_price", b"order_price", "order_request_id", b"order_request_id", "status_info", b"status_info"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["_amount", b"_amount", "_marker", b"_marker", "_order_request_id", b"_order_request_id", "_status_info", b"_status_info", "account_id", b"account_id", "amount", b"amount", "class_code", b"class_code", "client_code", b"client_code", "completion_time", b"completion_time", "created_at", b"created_at", "currency", b"currency", "direction", b"direction", "exchange", b"exchange", "executed_order_price", b"executed_order_price", "execution_report_status", b"execution_report_status", "initial_order_price", b"initial_order_price", "instrument_uid", b"instrument_uid", "lot_size", b"lot_size", "lots_cancelled", b"lots_cancelled", "lots_executed", b"lots_executed", "lots_left", b"lots_left", "lots_requested", b"lots_requested", "marker", b"marker", "order_id", b"order_id", "order_price", b"order_price", "order_request_id", b"order_request_id", "order_type", b"order_type", "status_info", b"status_info", "ticker", b"ticker", "time_in_force", b"time_in_force", "trades", b"trades"]) -> None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing.Literal["_amount", b"_amount"]) -> typing.Literal["amount"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing.Literal["_marker", b"_marker"]) -> typing.Literal["marker"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing.Literal["_order_request_id", b"_order_request_id"]) -> typing.Literal["order_request_id"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing.Literal["_status_info", b"_status_info"]) -> typing.Literal["status_info"] | None: ...

    ORDER_STATE_FIELD_NUMBER: builtins.int
    PING_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_FIELD_NUMBER: builtins.int
    @property
    def order_state(self) -> global___OrderStateStreamResponse.OrderState:
        """Информация об исполнении торгового поручения."""

    @property
    def ping(self) -> tinkoff.invest.grpc.common_pb2.Ping:
        """Проверка активности стрима."""

    @property
    def subscription(self) -> global___SubscriptionResponse:
        """Ответ на запрос на подписку."""

    def __init__(
        self,
        *,
        order_state: global___OrderStateStreamResponse.OrderState | None = ...,
        ping: tinkoff.invest.grpc.common_pb2.Ping | None = ...,
        subscription: global___SubscriptionResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["order_state", b"order_state", "payload", b"payload", "ping", b"ping", "subscription", b"subscription"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["order_state", b"order_state", "payload", b"payload", "ping", b"ping", "subscription", b"subscription"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["payload", b"payload"]) -> typing.Literal["order_state", "ping", "subscription"] | None: ...

global___OrderStateStreamResponse = OrderStateStreamResponse
