"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import tinkoff.invest.grpc.common_pb2
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _StrategyType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _StrategyTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_StrategyType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    STRATEGY_TYPE_UNSPECIFIED: _StrategyType.ValueType  # 0
    """Не определен."""
    STRATEGY_TYPE_TECHNICAL: _StrategyType.ValueType  # 1
    """Техническая стратегия."""
    STRATEGY_TYPE_FUNDAMENTAL: _StrategyType.ValueType  # 2
    """Фундаментальная стратегия."""

class StrategyType(_StrategyType, metaclass=_StrategyTypeEnumTypeWrapper):
    """Тип стратегии."""

STRATEGY_TYPE_UNSPECIFIED: StrategyType.ValueType  # 0
"""Не определен."""
STRATEGY_TYPE_TECHNICAL: StrategyType.ValueType  # 1
"""Техническая стратегия."""
STRATEGY_TYPE_FUNDAMENTAL: StrategyType.ValueType  # 2
"""Фундаментальная стратегия."""
global___StrategyType = StrategyType

class _SignalDirection:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SignalDirectionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SignalDirection.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SIGNAL_DIRECTION_UNSPECIFIED: _SignalDirection.ValueType  # 0
    """Не определен."""
    SIGNAL_DIRECTION_BUY: _SignalDirection.ValueType  # 1
    """Покупка."""
    SIGNAL_DIRECTION_SELL: _SignalDirection.ValueType  # 2
    """Продажа."""

class SignalDirection(_SignalDirection, metaclass=_SignalDirectionEnumTypeWrapper):
    """Направление сигнала."""

SIGNAL_DIRECTION_UNSPECIFIED: SignalDirection.ValueType  # 0
"""Не определен."""
SIGNAL_DIRECTION_BUY: SignalDirection.ValueType  # 1
"""Покупка."""
SIGNAL_DIRECTION_SELL: SignalDirection.ValueType  # 2
"""Продажа."""
global___SignalDirection = SignalDirection

class _SignalState:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SignalStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SignalState.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SIGNAL_STATE_UNSPECIFIED: _SignalState.ValueType  # 0
    """Не определен."""
    SIGNAL_STATE_ACTIVE: _SignalState.ValueType  # 1
    """Активный сигнал."""
    SIGNAL_STATE_CLOSED: _SignalState.ValueType  # 2
    """Закрытый сигнал."""
    SIGNAL_STATE_ALL: _SignalState.ValueType  # 3
    """Все состояния."""

class SignalState(_SignalState, metaclass=_SignalStateEnumTypeWrapper):
    """Статус сигнала."""

SIGNAL_STATE_UNSPECIFIED: SignalState.ValueType  # 0
"""Не определен."""
SIGNAL_STATE_ACTIVE: SignalState.ValueType  # 1
"""Активный сигнал."""
SIGNAL_STATE_CLOSED: SignalState.ValueType  # 2
"""Закрытый сигнал."""
SIGNAL_STATE_ALL: SignalState.ValueType  # 3
"""Все состояния."""
global___SignalState = SignalState

@typing.final
class GetStrategiesRequest(google.protobuf.message.Message):
    """Запрос стратегий."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STRATEGY_ID_FIELD_NUMBER: builtins.int
    strategy_id: builtins.str
    """Идентификатор стратегии."""
    def __init__(
        self,
        *,
        strategy_id: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_strategy_id", b"_strategy_id", "strategy_id", b"strategy_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_strategy_id", b"_strategy_id", "strategy_id", b"strategy_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_strategy_id", b"_strategy_id"]) -> typing.Literal["strategy_id"] | None: ...

global___GetStrategiesRequest = GetStrategiesRequest

@typing.final
class GetStrategiesResponse(google.protobuf.message.Message):
    """Стратегии"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STRATEGIES_FIELD_NUMBER: builtins.int
    @property
    def strategies(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Strategy]: ...
    def __init__(
        self,
        *,
        strategies: collections.abc.Iterable[global___Strategy] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["strategies", b"strategies"]) -> None: ...

global___GetStrategiesResponse = GetStrategiesResponse

@typing.final
class Strategy(google.protobuf.message.Message):
    """Стратегия"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STRATEGY_ID_FIELD_NUMBER: builtins.int
    STRATEGY_NAME_FIELD_NUMBER: builtins.int
    STRATEGY_DESCRIPTION_FIELD_NUMBER: builtins.int
    STRATEGY_URL_FIELD_NUMBER: builtins.int
    STRATEGY_TYPE_FIELD_NUMBER: builtins.int
    ACTIVE_SIGNALS_FIELD_NUMBER: builtins.int
    TOTAL_SIGNALS_FIELD_NUMBER: builtins.int
    TIME_IN_POSITION_FIELD_NUMBER: builtins.int
    AVERAGE_SIGNAL_YIELD_FIELD_NUMBER: builtins.int
    AVERAGE_SIGNAL_YIELD_YEAR_FIELD_NUMBER: builtins.int
    YIELD_FIELD_NUMBER: builtins.int
    YIELD_YEAR_FIELD_NUMBER: builtins.int
    strategy_id: builtins.str
    """Идентификатор стратегии."""
    strategy_name: builtins.str
    """Название стратегии."""
    strategy_description: builtins.str
    """Описание стратегии."""
    strategy_url: builtins.str
    """Ссылка на страницу с описанием стратегии."""
    strategy_type: global___StrategyType.ValueType
    """Тип стратегии."""
    active_signals: builtins.int
    """Количество активных сигналов."""
    total_signals: builtins.int
    """Общее количество сигналов."""
    time_in_position: builtins.int
    """Среднее время нахождения сигнала в позиции."""
    @property
    def average_signal_yield(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Средняя доходность сигнала в стратегии."""

    @property
    def average_signal_yield_year(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Средняя доходность сигналов в стратегии за последний год."""

    @property
    def yield_year(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Доходность стратегии за последний год."""

    def __init__(
        self,
        *,
        strategy_id: builtins.str = ...,
        strategy_name: builtins.str = ...,
        strategy_description: builtins.str | None = ...,
        strategy_url: builtins.str | None = ...,
        strategy_type: global___StrategyType.ValueType = ...,
        active_signals: builtins.int = ...,
        total_signals: builtins.int = ...,
        time_in_position: builtins.int = ...,
        average_signal_yield: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        average_signal_yield_year: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        yield_year: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_strategy_description", b"_strategy_description", "_strategy_url", b"_strategy_url", "average_signal_yield", b"average_signal_yield", "average_signal_yield_year", b"average_signal_yield_year", "strategy_description", b"strategy_description", "strategy_url", b"strategy_url", "yield", b"yield", "yield_year", b"yield_year"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_strategy_description", b"_strategy_description", "_strategy_url", b"_strategy_url", "active_signals", b"active_signals", "average_signal_yield", b"average_signal_yield", "average_signal_yield_year", b"average_signal_yield_year", "strategy_description", b"strategy_description", "strategy_id", b"strategy_id", "strategy_name", b"strategy_name", "strategy_type", b"strategy_type", "strategy_url", b"strategy_url", "time_in_position", b"time_in_position", "total_signals", b"total_signals", "yield", b"yield", "yield_year", b"yield_year"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_strategy_description", b"_strategy_description"]) -> typing.Literal["strategy_description"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_strategy_url", b"_strategy_url"]) -> typing.Literal["strategy_url"] | None: ...

global___Strategy = Strategy

@typing.final
class GetSignalsRequest(google.protobuf.message.Message):
    """Запрос сигналов."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNAL_ID_FIELD_NUMBER: builtins.int
    STRATEGY_ID_FIELD_NUMBER: builtins.int
    STRATEGY_TYPE_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    FROM_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    ACTIVE_FIELD_NUMBER: builtins.int
    PAGING_FIELD_NUMBER: builtins.int
    signal_id: builtins.str
    """Идентификатор сигнала."""
    strategy_id: builtins.str
    """Идентификатор стратегии."""
    strategy_type: global___StrategyType.ValueType
    """Тип стратегии."""
    instrument_uid: builtins.str
    """	Идентификатор бумаги."""
    direction: global___SignalDirection.ValueType
    """	Направление сигнала."""
    active: global___SignalState.ValueType
    """Состояние сигнала."""
    @property
    def to(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """	Дата конца запрашиваемого интервала по UTC."""

    @property
    def paging(self) -> tinkoff.invest.grpc.common_pb2.Page:
        """Настройки пагинации."""

    def __init__(
        self,
        *,
        signal_id: builtins.str | None = ...,
        strategy_id: builtins.str | None = ...,
        strategy_type: global___StrategyType.ValueType | None = ...,
        instrument_uid: builtins.str | None = ...,
        to: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        direction: global___SignalDirection.ValueType | None = ...,
        active: global___SignalState.ValueType | None = ...,
        paging: tinkoff.invest.grpc.common_pb2.Page | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_active", b"_active", "_direction", b"_direction", "_from", b"_from", "_instrument_uid", b"_instrument_uid", "_paging", b"_paging", "_signal_id", b"_signal_id", "_strategy_id", b"_strategy_id", "_strategy_type", b"_strategy_type", "_to", b"_to", "active", b"active", "direction", b"direction", "from", b"from", "instrument_uid", b"instrument_uid", "paging", b"paging", "signal_id", b"signal_id", "strategy_id", b"strategy_id", "strategy_type", b"strategy_type", "to", b"to"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_active", b"_active", "_direction", b"_direction", "_from", b"_from", "_instrument_uid", b"_instrument_uid", "_paging", b"_paging", "_signal_id", b"_signal_id", "_strategy_id", b"_strategy_id", "_strategy_type", b"_strategy_type", "_to", b"_to", "active", b"active", "direction", b"direction", "from", b"from", "instrument_uid", b"instrument_uid", "paging", b"paging", "signal_id", b"signal_id", "strategy_id", b"strategy_id", "strategy_type", b"strategy_type", "to", b"to"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_active", b"_active"]) -> typing.Literal["active"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_direction", b"_direction"]) -> typing.Literal["direction"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_from", b"_from"]) -> typing.Literal["from"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_instrument_uid", b"_instrument_uid"]) -> typing.Literal["instrument_uid"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_paging", b"_paging"]) -> typing.Literal["paging"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_signal_id", b"_signal_id"]) -> typing.Literal["signal_id"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_strategy_id", b"_strategy_id"]) -> typing.Literal["strategy_id"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_strategy_type", b"_strategy_type"]) -> typing.Literal["strategy_type"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_to", b"_to"]) -> typing.Literal["to"] | None: ...

global___GetSignalsRequest = GetSignalsRequest

@typing.final
class GetSignalsResponse(google.protobuf.message.Message):
    """Сигналы."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNALS_FIELD_NUMBER: builtins.int
    PAGING_FIELD_NUMBER: builtins.int
    @property
    def signals(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Signal]:
        """Массив сигналов."""

    @property
    def paging(self) -> tinkoff.invest.grpc.common_pb2.PageResponse:
        """Данные по пагинации."""

    def __init__(
        self,
        *,
        signals: collections.abc.Iterable[global___Signal] | None = ...,
        paging: tinkoff.invest.grpc.common_pb2.PageResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["paging", b"paging"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["paging", b"paging", "signals", b"signals"]) -> None: ...

global___GetSignalsResponse = GetSignalsResponse

@typing.final
class Signal(google.protobuf.message.Message):
    """Сигнал."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNAL_ID_FIELD_NUMBER: builtins.int
    STRATEGY_ID_FIELD_NUMBER: builtins.int
    STRATEGY_NAME_FIELD_NUMBER: builtins.int
    INSTRUMENT_UID_FIELD_NUMBER: builtins.int
    CREATE_DT_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    INITIAL_PRICE_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TARGET_PRICE_FIELD_NUMBER: builtins.int
    END_DT_FIELD_NUMBER: builtins.int
    PROBABILITY_FIELD_NUMBER: builtins.int
    STOPLOSS_FIELD_NUMBER: builtins.int
    CLOSE_PRICE_FIELD_NUMBER: builtins.int
    CLOSE_DT_FIELD_NUMBER: builtins.int
    signal_id: builtins.str
    """Идентификатор сигнала."""
    strategy_id: builtins.str
    """Идентификатор стратегии."""
    strategy_name: builtins.str
    """Название стратегии."""
    instrument_uid: builtins.str
    """Идентификатор бумаги."""
    direction: global___SignalDirection.ValueType
    """Направление сигнала."""
    info: builtins.str
    """Дополнительная информация о сигнале."""
    name: builtins.str
    """Название сигнала."""
    probability: builtins.int
    """Вероятность сигнала."""
    @property
    def create_dt(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата и время создания сигнала по UTC."""

    @property
    def initial_price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена бумаги на момент формирования сигнала."""

    @property
    def target_price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Целевая цена."""

    @property
    def end_dt(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата и время дедлайна сигнала по UTC."""

    @property
    def stoploss(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Порог закрытия сигнала по стоплосс."""

    @property
    def close_price(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Цена закрытия сигнала."""

    @property
    def close_dt(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата и время закрытия сигнала по UTC."""

    def __init__(
        self,
        *,
        signal_id: builtins.str = ...,
        strategy_id: builtins.str = ...,
        strategy_name: builtins.str = ...,
        instrument_uid: builtins.str = ...,
        create_dt: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        direction: global___SignalDirection.ValueType = ...,
        initial_price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        info: builtins.str | None = ...,
        name: builtins.str = ...,
        target_price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        end_dt: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        probability: builtins.int | None = ...,
        stoploss: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        close_price: tinkoff.invest.grpc.common_pb2.Quotation | None = ...,
        close_dt: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_close_dt", b"_close_dt", "_close_price", b"_close_price", "_info", b"_info", "_probability", b"_probability", "_stoploss", b"_stoploss", "close_dt", b"close_dt", "close_price", b"close_price", "create_dt", b"create_dt", "end_dt", b"end_dt", "info", b"info", "initial_price", b"initial_price", "probability", b"probability", "stoploss", b"stoploss", "target_price", b"target_price"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_close_dt", b"_close_dt", "_close_price", b"_close_price", "_info", b"_info", "_probability", b"_probability", "_stoploss", b"_stoploss", "close_dt", b"close_dt", "close_price", b"close_price", "create_dt", b"create_dt", "direction", b"direction", "end_dt", b"end_dt", "info", b"info", "initial_price", b"initial_price", "instrument_uid", b"instrument_uid", "name", b"name", "probability", b"probability", "signal_id", b"signal_id", "stoploss", b"stoploss", "strategy_id", b"strategy_id", "strategy_name", b"strategy_name", "target_price", b"target_price"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_close_dt", b"_close_dt"]) -> typing.Literal["close_dt"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_close_price", b"_close_price"]) -> typing.Literal["close_price"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_info", b"_info"]) -> typing.Literal["info"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_probability", b"_probability"]) -> typing.Literal["probability"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_stoploss", b"_stoploss"]) -> typing.Literal["stoploss"] | None: ...

global___Signal = Signal
