# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplianceSecurityIntrusionArgs', 'ApplianceSecurityIntrusion']

@pulumi.input_type
class ApplianceSecurityIntrusionArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[_builtins.str],
                 allowed_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityIntrusionAllowedRuleArgs']]]] = None):
        """
        The set of arguments for constructing a ApplianceSecurityIntrusion resource.
        :param pulumi.Input[_builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityIntrusionAllowedRuleArgs']]] allowed_rules: Sets a list of specific SNORT signatures to allow
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if allowed_rules is not None:
            pulumi.set(__self__, "allowed_rules", allowed_rules)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="allowedRules")
    def allowed_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityIntrusionAllowedRuleArgs']]]]:
        """
        Sets a list of specific SNORT signatures to allow
        """
        return pulumi.get(self, "allowed_rules")

    @allowed_rules.setter
    def allowed_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityIntrusionAllowedRuleArgs']]]]):
        pulumi.set(self, "allowed_rules", value)


@pulumi.input_type
class _ApplianceSecurityIntrusionState:
    def __init__(__self__, *,
                 allowed_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityIntrusionAllowedRuleArgs']]]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApplianceSecurityIntrusion resources.
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityIntrusionAllowedRuleArgs']]] allowed_rules: Sets a list of specific SNORT signatures to allow
        :param pulumi.Input[_builtins.str] organization_id: organizationId path parameter. Organization ID
        """
        if allowed_rules is not None:
            pulumi.set(__self__, "allowed_rules", allowed_rules)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)

    @_builtins.property
    @pulumi.getter(name="allowedRules")
    def allowed_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityIntrusionAllowedRuleArgs']]]]:
        """
        Sets a list of specific SNORT signatures to allow
        """
        return pulumi.get(self, "allowed_rules")

    @allowed_rules.setter
    def allowed_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityIntrusionAllowedRuleArgs']]]]):
        pulumi.set(self, "allowed_rules", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)


@pulumi.type_token("meraki:organizations/applianceSecurityIntrusion:ApplianceSecurityIntrusion")
class ApplianceSecurityIntrusion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplianceSecurityIntrusionAllowedRuleArgs', 'ApplianceSecurityIntrusionAllowedRuleArgsDict']]]]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:organizations/applianceSecurityIntrusion:ApplianceSecurityIntrusion example "organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplianceSecurityIntrusionAllowedRuleArgs', 'ApplianceSecurityIntrusionAllowedRuleArgsDict']]]] allowed_rules: Sets a list of specific SNORT signatures to allow
        :param pulumi.Input[_builtins.str] organization_id: organizationId path parameter. Organization ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplianceSecurityIntrusionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:organizations/applianceSecurityIntrusion:ApplianceSecurityIntrusion example "organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param ApplianceSecurityIntrusionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplianceSecurityIntrusionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplianceSecurityIntrusionAllowedRuleArgs', 'ApplianceSecurityIntrusionAllowedRuleArgsDict']]]]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplianceSecurityIntrusionArgs.__new__(ApplianceSecurityIntrusionArgs)

            __props__.__dict__["allowed_rules"] = allowed_rules
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
        super(ApplianceSecurityIntrusion, __self__).__init__(
            'meraki:organizations/applianceSecurityIntrusion:ApplianceSecurityIntrusion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplianceSecurityIntrusionAllowedRuleArgs', 'ApplianceSecurityIntrusionAllowedRuleArgsDict']]]]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApplianceSecurityIntrusion':
        """
        Get an existing ApplianceSecurityIntrusion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplianceSecurityIntrusionAllowedRuleArgs', 'ApplianceSecurityIntrusionAllowedRuleArgsDict']]]] allowed_rules: Sets a list of specific SNORT signatures to allow
        :param pulumi.Input[_builtins.str] organization_id: organizationId path parameter. Organization ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplianceSecurityIntrusionState.__new__(_ApplianceSecurityIntrusionState)

        __props__.__dict__["allowed_rules"] = allowed_rules
        __props__.__dict__["organization_id"] = organization_id
        return ApplianceSecurityIntrusion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedRules")
    def allowed_rules(self) -> pulumi.Output[Sequence['outputs.ApplianceSecurityIntrusionAllowedRule']]:
        """
        Sets a list of specific SNORT signatures to allow
        """
        return pulumi.get(self, "allowed_rules")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

